/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2Lc;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;

public class Vector2L
implements Externalizable,
Cloneable,
Vector2Lc {
    private static final long serialVersionUID = 1L;
    public long x;
    public long y;

    public Vector2L() {
    }

    public Vector2L(long l2) {
        this.x = l2;
        this.y = l2;
    }

    public Vector2L(long l2, long l3) {
        this.x = l2;
        this.y = l3;
    }

    public Vector2L(float f2, float f3, int n2) {
        this.x = Math.roundLongUsing(f2, n2);
        this.y = Math.roundLongUsing(f3, n2);
    }

    public Vector2L(double d2, double d3, int n2) {
        this.x = Math.roundLongUsing(d2, n2);
        this.y = Math.roundLongUsing(d3, n2);
    }

    public Vector2L(Vector2Lc vector2Lc) {
        this.x = vector2Lc.x();
        this.y = vector2Lc.y();
    }

    public Vector2L(Vector2ic vector2ic) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
    }

    public Vector2L(Vector2fc vector2fc, int n2) {
        this.x = Math.roundLongUsing(vector2fc.x(), n2);
        this.y = Math.roundLongUsing(vector2fc.y(), n2);
    }

    public Vector2L(Vector2dc vector2dc, int n2) {
        this.x = Math.roundLongUsing(vector2dc.x(), n2);
        this.y = Math.roundLongUsing(vector2dc.y(), n2);
    }

    public Vector2L(long[] lArray) {
        this.x = lArray[0];
        this.y = lArray[1];
    }

    public Vector2L(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector2L(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
    }

    public Vector2L(LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, longBuffer.position(), longBuffer);
    }

    public Vector2L(int n2, LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, n2, longBuffer);
    }

    public long x() {
        return this.x;
    }

    public long y() {
        return this.y;
    }

    public Vector2L set(long l2) {
        this.x = l2;
        this.y = l2;
        return this;
    }

    public Vector2L set(long l2, long l3) {
        this.x = l2;
        this.y = l3;
        return this;
    }

    public Vector2L set(Vector2Lc vector2Lc) {
        this.x = vector2Lc.x();
        this.y = vector2Lc.y();
        return this;
    }

    public Vector2L set(Vector2ic vector2ic) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        return this;
    }

    public Vector2L set(Vector2dc vector2dc) {
        this.x = (long)vector2dc.x();
        this.y = (long)vector2dc.y();
        return this;
    }

    public Vector2L set(Vector2dc vector2dc, int n2) {
        this.x = Math.roundLongUsing(vector2dc.x(), n2);
        this.y = Math.roundLongUsing(vector2dc.y(), n2);
        return this;
    }

    public Vector2L set(Vector2fc vector2fc, int n2) {
        this.x = Math.roundLongUsing(vector2fc.x(), n2);
        this.y = Math.roundLongUsing(vector2fc.y(), n2);
        return this;
    }

    public Vector2L set(long[] lArray) {
        this.x = lArray[0];
        this.y = lArray[1];
        return this;
    }

    public Vector2L set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector2L set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Vector2L set(LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, longBuffer.position(), longBuffer);
        return this;
    }

    public Vector2L set(int n2, LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, n2, longBuffer);
        return this;
    }

    public Vector2L setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l2);
        return this;
    }

    public long get(int n2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector2L setComponent(int n2, long l2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                this.x = l2;
                break;
            }
            case 1: {
                this.y = l2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public LongBuffer get(LongBuffer longBuffer) {
        MemUtil.INSTANCE.put(this, longBuffer.position(), longBuffer);
        return longBuffer;
    }

    public LongBuffer get(int n2, LongBuffer longBuffer) {
        MemUtil.INSTANCE.put(this, n2, longBuffer);
        return longBuffer;
    }

    public Vector2Lc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Vector2L sub(Vector2Lc vector2Lc) {
        return this.sub(vector2Lc, this);
    }

    public Vector2L sub(Vector2Lc vector2Lc, Vector2L vector2L) {
        vector2L.x = this.x - vector2Lc.x();
        vector2L.y = this.y - vector2Lc.y();
        return vector2L;
    }

    public Vector2L sub(Vector2ic vector2ic) {
        return this.sub(vector2ic, this);
    }

    public Vector2L sub(Vector2ic vector2ic, Vector2L vector2L) {
        vector2L.x = this.x - (long)vector2ic.x();
        vector2L.y = this.y - (long)vector2ic.y();
        return vector2L;
    }

    public Vector2L sub(long l2, long l3) {
        return this.sub(l2, l3, this);
    }

    public Vector2L sub(long l2, long l3, Vector2L vector2L) {
        vector2L.x = this.x - l2;
        vector2L.y = this.y - l3;
        return vector2L;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public static long lengthSquared(long l2, long l3) {
        long l4 = l2;
        long l5 = l3;
        return l4 * l4 + l5 * l5;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static double length(long l2, long l3) {
        long l4 = l2;
        long l5 = l3;
        return Math.sqrt(l4 * l4 + l5 * l5);
    }

    public double distance(Vector2Lc vector2Lc) {
        long l2 = this.x - vector2Lc.x();
        long l3 = this.y - vector2Lc.y();
        long l4 = l2;
        long l5 = l3;
        return Math.sqrt(l4 * l4 + l5 * l5);
    }

    public double distance(long l2, long l3) {
        long l4 = this.x - l2;
        long l5 = this.y - l3;
        long l6 = l4;
        long l7 = l5;
        return Math.sqrt(l6 * l6 + l7 * l7);
    }

    public long distanceSquared(Vector2Lc vector2Lc) {
        long l2 = this.x - vector2Lc.x();
        long l3 = this.y - vector2Lc.y();
        long l4 = l2;
        long l5 = l3;
        return l4 * l4 + l5 * l5;
    }

    public long distanceSquared(long l2, long l3) {
        long l4 = this.x - l2;
        long l5 = this.y - l3;
        long l6 = l4;
        long l7 = l5;
        return l6 * l6 + l7 * l7;
    }

    public long gridDistance(Vector2Lc vector2Lc) {
        return Math.abs(vector2Lc.x() - this.x()) + Math.abs(vector2Lc.y() - this.y());
    }

    public long gridDistance(long l2, long l3) {
        return Math.abs(l2 - this.x()) + Math.abs(l3 - this.y());
    }

    public static double distance(long l2, long l3, long l4, long l5) {
        long l6 = l2 - l4;
        long l7 = l3 - l5;
        long l8 = l6;
        long l9 = l7;
        return Math.sqrt(l8 * l8 + l9 * l9);
    }

    public static long distanceSquared(long l2, long l3, long l4, long l5) {
        long l6 = l2 - l4;
        long l7 = l3 - l5;
        long l8 = l6;
        long l9 = l7;
        return l8 * l8 + l9 * l9;
    }

    public Vector2L add(Vector2Lc vector2Lc) {
        this.x += vector2Lc.x();
        this.y += vector2Lc.y();
        return this;
    }

    public Vector2L add(Vector2Lc vector2Lc, Vector2L vector2L) {
        vector2L.x = this.x + vector2Lc.x();
        vector2L.y = this.y + vector2Lc.y();
        return vector2L;
    }

    public Vector2L add(Vector2ic vector2ic) {
        this.x += (long)vector2ic.x();
        this.y += (long)vector2ic.y();
        return this;
    }

    public Vector2L add(Vector2ic vector2ic, Vector2L vector2L) {
        vector2L.x = this.x + (long)vector2ic.x();
        vector2L.y = this.y + (long)vector2ic.y();
        return vector2L;
    }

    public Vector2L add(long l2, long l3) {
        return this.add(l2, l3, this);
    }

    public Vector2L add(long l2, long l3, Vector2L vector2L) {
        vector2L.x = this.x + l2;
        vector2L.y = this.y + l3;
        return vector2L;
    }

    public Vector2L mul(long l2) {
        return this.mul(l2, this);
    }

    public Vector2L mul(long l2, Vector2L vector2L) {
        vector2L.x = this.x * l2;
        vector2L.y = this.y * l2;
        return vector2L;
    }

    public Vector2L mul(Vector2Lc vector2Lc) {
        return this.mul(vector2Lc, this);
    }

    public Vector2L mul(Vector2Lc vector2Lc, Vector2L vector2L) {
        vector2L.x = this.x * vector2Lc.x();
        vector2L.y = this.y * vector2Lc.y();
        return vector2L;
    }

    public Vector2L mul(Vector2ic vector2ic) {
        return this.mul(vector2ic, this);
    }

    public Vector2L mul(Vector2ic vector2ic, Vector2L vector2L) {
        vector2L.x = this.x * (long)vector2ic.x();
        vector2L.y = this.y * (long)vector2ic.y();
        return vector2L;
    }

    public Vector2L mul(long l2, long l3) {
        return this.mul(l2, l3, this);
    }

    public Vector2L mul(long l2, long l3, Vector2L vector2L) {
        vector2L.x = this.x * l2;
        vector2L.y = this.y * l3;
        return vector2L;
    }

    public Vector2L div(float f2) {
        return this.div(f2, this);
    }

    public Vector2L div(float f2, Vector2L vector2L) {
        f2 = 1.0f / f2;
        vector2L.x = (int)((float)this.x * f2);
        vector2L.y = (int)((float)this.y * f2);
        return vector2L;
    }

    public Vector2L div(long l2) {
        return this.div(l2, this);
    }

    public Vector2L div(long l2, Vector2L vector2L) {
        vector2L.x = this.x / l2;
        vector2L.y = this.y / l2;
        return vector2L;
    }

    public Vector2L zero() {
        this.x = 0L;
        this.y = 0L;
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.x);
        objectOutput.writeLong(this.y);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readLong();
        this.y = objectInput.readLong();
    }

    public Vector2L negate() {
        Vector2L vector2L = this;
        return vector2L.negate(vector2L);
    }

    public Vector2L negate(Vector2L vector2L) {
        vector2L.x = -this.x;
        vector2L.y = -this.y;
        return vector2L;
    }

    public Vector2L min(Vector2Lc vector2Lc) {
        return this.min(vector2Lc, this);
    }

    public Vector2L min(Vector2Lc vector2Lc, Vector2L vector2L) {
        vector2L.x = this.x < vector2Lc.x() ? this.x : vector2Lc.x();
        vector2L.y = this.y < vector2Lc.y() ? this.y : vector2Lc.y();
        return vector2L;
    }

    public Vector2L max(Vector2Lc vector2Lc) {
        return this.max(vector2Lc, this);
    }

    public Vector2L max(Vector2Lc vector2Lc, Vector2L vector2L) {
        vector2L.x = this.x > vector2Lc.x() ? this.x : vector2Lc.x();
        vector2L.y = this.y > vector2Lc.y() ? this.y : vector2Lc.y();
        return vector2L;
    }

    public long maxComponent() {
        long l2;
        long l3 = Math.abs(this.x);
        if (l3 >= (l2 = Math.abs(this.y))) {
            return 0L;
        }
        return 1L;
    }

    public long minComponent() {
        long l2;
        long l3 = Math.abs(this.x);
        if (l3 < (l2 = Math.abs(this.y))) {
            return 0L;
        }
        return 1L;
    }

    public Vector2L absolute() {
        Vector2L vector2L = this;
        return vector2L.absolute(vector2L);
    }

    public Vector2L absolute(Vector2L vector2L) {
        vector2L.x = Math.abs(this.x);
        vector2L.y = Math.abs(this.y);
        return vector2L;
    }

    public int hashCode() {
        long l2 = 31L + this.x;
        long l3 = 31L * l2 + this.y;
        return (int)(l3 ^ l3 >> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Vector2L)object;
        if (this.x != ((Vector2L)object).x) {
            return false;
        }
        return this.y == ((Vector2L)object).y;
    }

    public boolean equals(long l2, long l3) {
        if (this.x != l2) {
            return false;
        }
        return this.y == l3;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + numberFormat.format(this.x) + " " + numberFormat.format(this.y) + ")";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

