/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Options;

public final class Runtime {
    public static final boolean HAS_floatToRawIntBits = Runtime.hasFloatToRawIntBits();
    public static final boolean HAS_doubleToRawLongBits = Runtime.hasDoubleToRawLongBits();
    public static final boolean HAS_Long_rotateLeft = Runtime.hasLongRotateLeft();
    public static final boolean HAS_Math_fma = Options.USE_MATH_FMA && Runtime.hasMathFma();

    private static boolean hasMathFma() {
        try {
            java.lang.Math.class.getDeclaredMethod("fma", Float.TYPE, Float.TYPE, Float.TYPE);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private Runtime() {
    }

    private static boolean hasFloatToRawIntBits() {
        try {
            Float.class.getDeclaredMethod("floatToRawIntBits", Float.TYPE);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private static boolean hasDoubleToRawLongBits() {
        try {
            Double.class.getDeclaredMethod("doubleToRawLongBits", Double.TYPE);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private static boolean hasLongRotateLeft() {
        try {
            Long.class.getDeclaredMethod("rotateLeft", Long.TYPE, Integer.TYPE);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static int floatToIntBits(float f2) {
        if (HAS_floatToRawIntBits) {
            return Runtime.floatToIntBits1_3(f2);
        }
        return Runtime.floatToIntBits1_2(f2);
    }

    private static int floatToIntBits1_3(float f2) {
        return Float.floatToRawIntBits(f2);
    }

    private static int floatToIntBits1_2(float f2) {
        return Float.floatToIntBits(f2);
    }

    public static long doubleToLongBits(double d2) {
        if (HAS_doubleToRawLongBits) {
            return Runtime.doubleToLongBits1_3(d2);
        }
        return Runtime.doubleToLongBits1_2(d2);
    }

    private static long doubleToLongBits1_3(double d2) {
        return Double.doubleToRawLongBits(d2);
    }

    private static long doubleToLongBits1_2(double d2) {
        return Double.doubleToLongBits(d2);
    }

    public static String formatNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == 'E') {
                n2 = i2;
            } else {
                if (c2 == ' ' && n2 == i2 - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c2) && n2 == i2 - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String format(double d2, NumberFormat numberFormat) {
        if (Double.isNaN(d2)) {
            return Runtime.padLeft(numberFormat, " NaN");
        }
        if (Double.isInfinite(d2)) {
            return Runtime.padLeft(numberFormat, d2 > 0.0 ? " +Inf" : " -Inf");
        }
        return numberFormat.format(d2);
    }

    private static String padLeft(NumberFormat numberFormat, String string) {
        int n2 = numberFormat.format(0.0).length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2 - string.length() + 1; ++i2) {
            stringBuffer.append(" ");
        }
        return stringBuffer.append(string).toString();
    }

    public static boolean equals(float f2, float f3, float f4) {
        return Float.floatToIntBits(f2) == Float.floatToIntBits(f3) || Math.abs(f2 - f3) <= f4;
    }

    public static boolean equals(double d2, double d3, double d4) {
        return Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3) || Math.abs(d2 - d3) <= d4;
    }
}

