/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

public class RayAabIntersection {
    private float originX;
    private float originY;
    private float originZ;
    private float dirX;
    private float dirY;
    private float dirZ;
    private float c_xy;
    private float c_yx;
    private float c_zy;
    private float c_yz;
    private float c_xz;
    private float c_zx;
    private float s_xy;
    private float s_yx;
    private float s_zy;
    private float s_yz;
    private float s_xz;
    private float s_zx;
    private byte classification;

    public RayAabIntersection() {
    }

    public RayAabIntersection(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.set(f2, f3, f4, f5, f6, f7);
    }

    public void set(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.originX = f2;
        this.originY = f3;
        this.originZ = f4;
        this.dirX = f5;
        this.dirY = f6;
        this.dirZ = f7;
        this.precomputeSlope();
    }

    private static int signum(float f2) {
        if (f2 == 0.0f || Float.isNaN(f2)) {
            return 0;
        }
        return (1 - Float.floatToIntBits(f2) >>> 31 << 1) - 1;
    }

    private void precomputeSlope() {
        float f2 = 1.0f / this.dirX;
        float f3 = 1.0f / this.dirY;
        float f4 = 1.0f / this.dirZ;
        this.s_yx = this.dirX * f3;
        this.s_xy = this.dirY * f2;
        this.s_zy = this.dirY * f4;
        this.s_yz = this.dirZ * f3;
        this.s_xz = this.dirZ * f2;
        this.s_zx = this.dirX * f4;
        this.c_xy = this.originY - this.s_xy * this.originX;
        this.c_yx = this.originX - this.s_yx * this.originY;
        this.c_zy = this.originY - this.s_zy * this.originZ;
        this.c_yz = this.originZ - this.s_yz * this.originY;
        this.c_xz = this.originZ - this.s_xz * this.originX;
        this.c_zx = this.originX - this.s_zx * this.originZ;
        int n2 = RayAabIntersection.signum(this.dirX);
        int n3 = RayAabIntersection.signum(this.dirY);
        int n4 = RayAabIntersection.signum(this.dirZ);
        this.classification = (byte)(n4 + 1 << 4 | n3 + 1 << 2 | n2 + 1);
    }

    public boolean test(float f2, float f3, float f4, float f5, float f6, float f7) {
        switch (this.classification) {
            case 0: {
                return this.MMM(f2, f3, f4, f5, f6, f7);
            }
            case 1: {
                return this.OMM(f2, f3, f4, f5, f6, f7);
            }
            case 2: {
                return this.PMM(f2, f3, f4, f5, f6, f7);
            }
            case 3: {
                return false;
            }
            case 4: {
                return this.MOM(f2, f3, f4, f5, f6, f7);
            }
            case 5: {
                return this.OOM(f2, f3, f4, f5, f6);
            }
            case 6: {
                return this.POM(f2, f3, f4, f5, f6, f7);
            }
            case 7: {
                return false;
            }
            case 8: {
                return this.MPM(f2, f3, f4, f5, f6, f7);
            }
            case 9: {
                return this.OPM(f2, f3, f4, f5, f6, f7);
            }
            case 10: {
                return this.PPM(f2, f3, f4, f5, f6, f7);
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return false;
            }
            case 16: {
                return this.MMO(f2, f3, f4, f5, f6, f7);
            }
            case 17: {
                return this.OMO(f2, f3, f4, f5, f7);
            }
            case 18: {
                return this.PMO(f2, f3, f4, f5, f6, f7);
            }
            case 19: {
                return false;
            }
            case 20: {
                return this.MOO(f2, f3, f4, f6, f7);
            }
            case 21: {
                return false;
            }
            case 22: {
                return this.POO(f3, f4, f5, f6, f7);
            }
            case 23: {
                return false;
            }
            case 24: {
                return this.MPO(f2, f3, f4, f5, f6, f7);
            }
            case 25: {
                return this.OPO(f2, f4, f5, f6, f7);
            }
            case 26: {
                return this.PPO(f2, f3, f4, f5, f6, f7);
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return false;
            }
            case 32: {
                return this.MMP(f2, f3, f4, f5, f6, f7);
            }
            case 33: {
                return this.OMP(f2, f3, f4, f5, f6, f7);
            }
            case 34: {
                return this.PMP(f2, f3, f4, f5, f6, f7);
            }
            case 35: {
                return false;
            }
            case 36: {
                return this.MOP(f2, f3, f4, f5, f6, f7);
            }
            case 37: {
                return this.OOP(f2, f3, f5, f6, f7);
            }
            case 38: {
                return this.POP(f2, f3, f4, f5, f6, f7);
            }
            case 39: {
                return false;
            }
            case 40: {
                return this.MPP(f2, f3, f4, f5, f6, f7);
            }
            case 41: {
                return this.OPP(f2, f3, f4, f5, f6, f7);
            }
            case 42: {
                return this.PPP(f2, f3, f4, f5, f6, f7);
            }
        }
        return false;
    }

    private boolean MMM(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX >= f2 && this.originY >= f3 && this.originZ >= f4 && this.s_xy * f2 - f6 + this.c_xy <= 0.0f && this.s_yx * f3 - f5 + this.c_yx <= 0.0f && this.s_zy * f4 - f6 + this.c_zy <= 0.0f && this.s_yz * f3 - f7 + this.c_yz <= 0.0f && this.s_xz * f2 - f7 + this.c_xz <= 0.0f && this.s_zx * f4 - f5 + this.c_zx <= 0.0f;
    }

    private boolean OMM(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX >= f2 && this.originX <= f5 && this.originY >= f3 && this.originZ >= f4 && this.s_zy * f4 - f6 + this.c_zy <= 0.0f && this.s_yz * f3 - f7 + this.c_yz <= 0.0f;
    }

    private boolean PMM(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX <= f5 && this.originY >= f3 && this.originZ >= f4 && this.s_xy * f5 - f6 + this.c_xy <= 0.0f && this.s_yx * f3 - f2 + this.c_yx >= 0.0f && this.s_zy * f4 - f6 + this.c_zy <= 0.0f && this.s_yz * f3 - f7 + this.c_yz <= 0.0f && this.s_xz * f5 - f7 + this.c_xz <= 0.0f && this.s_zx * f4 - f2 + this.c_zx >= 0.0f;
    }

    private boolean MOM(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originY >= f3 && this.originY <= f6 && this.originX >= f2 && this.originZ >= f4 && this.s_xz * f2 - f7 + this.c_xz <= 0.0f && this.s_zx * f4 - f5 + this.c_zx <= 0.0f;
    }

    private boolean OOM(float f2, float f3, float f4, float f5, float f6) {
        return this.originZ >= f4 && this.originX >= f2 && this.originX <= f5 && this.originY >= f3 && this.originY <= f6;
    }

    private boolean POM(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originY >= f3 && this.originY <= f6 && this.originX <= f5 && this.originZ >= f4 && this.s_xz * f5 - f7 + this.c_xz <= 0.0f && this.s_zx * f4 - f2 + this.c_zx >= 0.0f;
    }

    private boolean MPM(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX >= f2 && this.originY <= f6 && this.originZ >= f4 && this.s_xy * f2 - f3 + this.c_xy >= 0.0f && this.s_yx * f6 - f5 + this.c_yx <= 0.0f && this.s_zy * f4 - f3 + this.c_zy >= 0.0f && this.s_yz * f6 - f7 + this.c_yz <= 0.0f && this.s_xz * f2 - f7 + this.c_xz <= 0.0f && this.s_zx * f4 - f5 + this.c_zx <= 0.0f;
    }

    private boolean OPM(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX >= f2 && this.originX <= f5 && this.originY <= f6 && this.originZ >= f4 && this.s_zy * f4 - f3 + this.c_zy >= 0.0f && this.s_yz * f6 - f7 + this.c_yz <= 0.0f;
    }

    private boolean PPM(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX <= f5 && this.originY <= f6 && this.originZ >= f4 && this.s_xy * f5 - f3 + this.c_xy >= 0.0f && this.s_yx * f6 - f2 + this.c_yx >= 0.0f && this.s_zy * f4 - f3 + this.c_zy >= 0.0f && this.s_yz * f6 - f7 + this.c_yz <= 0.0f && this.s_xz * f5 - f7 + this.c_xz <= 0.0f && this.s_zx * f4 - f2 + this.c_zx >= 0.0f;
    }

    private boolean MMO(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originZ >= f4 && this.originZ <= f7 && this.originX >= f2 && this.originY >= f3 && this.s_xy * f2 - f6 + this.c_xy <= 0.0f && this.s_yx * f3 - f5 + this.c_yx <= 0.0f;
    }

    private boolean OMO(float f2, float f3, float f4, float f5, float f6) {
        return this.originY >= f3 && this.originX >= f2 && this.originX <= f5 && this.originZ >= f4 && this.originZ <= f6;
    }

    private boolean PMO(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originZ >= f4 && this.originZ <= f7 && this.originX <= f5 && this.originY >= f3 && this.s_xy * f5 - f6 + this.c_xy <= 0.0f && this.s_yx * f3 - f2 + this.c_yx >= 0.0f;
    }

    private boolean MOO(float f2, float f3, float f4, float f5, float f6) {
        return this.originX >= f2 && this.originY >= f3 && this.originY <= f5 && this.originZ >= f4 && this.originZ <= f6;
    }

    private boolean POO(float f2, float f3, float f4, float f5, float f6) {
        return this.originX <= f4 && this.originY >= f2 && this.originY <= f5 && this.originZ >= f3 && this.originZ <= f6;
    }

    private boolean MPO(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originZ >= f4 && this.originZ <= f7 && this.originX >= f2 && this.originY <= f6 && this.s_xy * f2 - f3 + this.c_xy >= 0.0f && this.s_yx * f6 - f5 + this.c_yx <= 0.0f;
    }

    private boolean OPO(float f2, float f3, float f4, float f5, float f6) {
        return this.originY <= f5 && this.originX >= f2 && this.originX <= f4 && this.originZ >= f3 && this.originZ <= f6;
    }

    private boolean PPO(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originZ >= f4 && this.originZ <= f7 && this.originX <= f5 && this.originY <= f6 && this.s_xy * f5 - f3 + this.c_xy >= 0.0f && this.s_yx * f6 - f2 + this.c_yx >= 0.0f;
    }

    private boolean MMP(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX >= f2 && this.originY >= f3 && this.originZ <= f7 && this.s_xy * f2 - f6 + this.c_xy <= 0.0f && this.s_yx * f3 - f5 + this.c_yx <= 0.0f && this.s_zy * f7 - f6 + this.c_zy <= 0.0f && this.s_yz * f3 - f4 + this.c_yz >= 0.0f && this.s_xz * f2 - f4 + this.c_xz >= 0.0f && this.s_zx * f7 - f5 + this.c_zx <= 0.0f;
    }

    private boolean OMP(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX >= f2 && this.originX <= f5 && this.originY >= f3 && this.originZ <= f7 && this.s_zy * f7 - f6 + this.c_zy <= 0.0f && this.s_yz * f3 - f4 + this.c_yz >= 0.0f;
    }

    private boolean PMP(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX <= f5 && this.originY >= f3 && this.originZ <= f7 && this.s_xy * f5 - f6 + this.c_xy <= 0.0f && this.s_yx * f3 - f2 + this.c_yx >= 0.0f && this.s_zy * f7 - f6 + this.c_zy <= 0.0f && this.s_yz * f3 - f4 + this.c_yz >= 0.0f && this.s_xz * f5 - f4 + this.c_xz >= 0.0f && this.s_zx * f7 - f2 + this.c_zx >= 0.0f;
    }

    private boolean MOP(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originY >= f3 && this.originY <= f6 && this.originX >= f2 && this.originZ <= f7 && this.s_xz * f2 - f4 + this.c_xz >= 0.0f && this.s_zx * f7 - f5 + this.c_zx <= 0.0f;
    }

    private boolean OOP(float f2, float f3, float f4, float f5, float f6) {
        return this.originZ <= f6 && this.originX >= f2 && this.originX <= f4 && this.originY >= f3 && this.originY <= f5;
    }

    private boolean POP(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originY >= f3 && this.originY <= f6 && this.originX <= f5 && this.originZ <= f7 && this.s_xz * f5 - f4 + this.c_xz >= 0.0f && this.s_zx * f7 - f2 + this.c_zx <= 0.0f;
    }

    private boolean MPP(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX >= f2 && this.originY <= f6 && this.originZ <= f7 && this.s_xy * f2 - f3 + this.c_xy >= 0.0f && this.s_yx * f6 - f5 + this.c_yx <= 0.0f && this.s_zy * f7 - f3 + this.c_zy >= 0.0f && this.s_yz * f6 - f4 + this.c_yz >= 0.0f && this.s_xz * f2 - f4 + this.c_xz >= 0.0f && this.s_zx * f7 - f5 + this.c_zx <= 0.0f;
    }

    private boolean OPP(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX >= f2 && this.originX <= f5 && this.originY <= f6 && this.originZ <= f7 && this.s_zy * f7 - f3 + this.c_zy <= 0.0f && this.s_yz * f6 - f4 + this.c_yz <= 0.0f;
    }

    private boolean PPP(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.originX <= f5 && this.originY <= f6 && this.originZ <= f7 && this.s_xy * f5 - f3 + this.c_xy >= 0.0f && this.s_yx * f6 - f2 + this.c_yx >= 0.0f && this.s_zy * f7 - f3 + this.c_zy >= 0.0f && this.s_yz * f6 - f4 + this.c_yz >= 0.0f && this.s_xz * f5 - f4 + this.c_xz >= 0.0f && this.s_zx * f7 - f2 + this.c_zx >= 0.0f;
    }
}

