/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Runtime;

public class Random {
    private final Xorshiro128 rnd;
    private static long seedHalf = 8020463840L;

    public static long newSeed() {
        long l2;
        Class clazz = Random.class;
        synchronized (clazz) {
            seedHalf = l2 = seedHalf * 3512401965023503517L;
        }
        return l2;
    }

    public Random() {
        this(Random.newSeed() ^ System.nanoTime());
    }

    public Random(long l2) {
        this.rnd = new Xorshiro128(l2);
    }

    public float nextFloat() {
        return this.rnd.nextFloat();
    }

    public int nextInt(int n2) {
        return this.rnd.nextInt(n2);
    }

    static final class Xorshiro128 {
        private static final float INT_TO_FLOAT = Float.intBitsToFloat(0x33800000);
        private long _s0;
        private long _s1;
        private long state;

        Xorshiro128(long l2) {
            this.state = l2;
            this._s0 = this.nextSplitMix64();
            this._s1 = this.nextSplitMix64();
        }

        private long nextSplitMix64() {
            long l2 = ((this.state += -7046029254386353131L) ^ this.state >>> 30) * -4658895280553007687L;
            long l3 = (l2 ^ l2 >>> 27) * -7723592293110705685L;
            return l3 ^ l3 >>> 31;
        }

        final float nextFloat() {
            return (float)(this.nextInt() >>> 8) * INT_TO_FLOAT;
        }

        private int nextInt() {
            long l2 = this._s0;
            long l3 = this._s1;
            long l4 = l2 + l3;
            this.rotateLeft(l2, l3 ^= l2);
            return (int)l4;
        }

        private static long rotl_JDK4(long l2, int n2) {
            return l2 << n2 | l2 >>> 64 - n2;
        }

        private static long rotl_JDK5(long l2, int n2) {
            return Long.rotateLeft(l2, n2);
        }

        private static long rotl(long l2, int n2) {
            if (Runtime.HAS_Long_rotateLeft) {
                return Xorshiro128.rotl_JDK5(l2, n2);
            }
            return Xorshiro128.rotl_JDK4(l2, n2);
        }

        private void rotateLeft(long l2, long l3) {
            this._s0 = Xorshiro128.rotl(l2, 55) ^ l3 ^ l3 << 14;
            this._s1 = Xorshiro128.rotl(l3, 36);
        }

        final int nextInt(int n2) {
            return (int)((long)(this.nextInt() >>> 1) * (long)n2 >> 31);
        }
    }
}

