/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3d;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3f;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class Quaternionf
implements Externalizable,
Cloneable,
Quaternionfc {
    private static final long serialVersionUID = 1L;
    public float w;
    public float x;
    public float y;
    public float z;

    public Quaternionf() {
        this.w = 1.0f;
    }

    public Quaternionf(double d2, double d3, double d4, double d5) {
        this.x = (float)d2;
        this.y = (float)d3;
        this.z = (float)d4;
        this.w = (float)d5;
    }

    public Quaternionf(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
    }

    public Quaternionf(Quaternionfc quaternionfc) {
        this.set(quaternionfc);
    }

    public Quaternionf(Quaterniondc quaterniondc) {
        this.set(quaterniondc);
    }

    public Quaternionf(AxisAngle4f axisAngle4f) {
        float f2 = Math.sin(axisAngle4f.angle * 0.5f);
        float f3 = Math.cosFromSin(f2, axisAngle4f.angle * 0.5f);
        this.x = axisAngle4f.x * f2;
        this.y = axisAngle4f.y * f2;
        this.z = axisAngle4f.z * f2;
        this.w = f3;
    }

    public Quaternionf(AxisAngle4d axisAngle4d) {
        double d2 = Math.sin(axisAngle4d.angle * 0.5);
        double d3 = Math.cosFromSin(d2, axisAngle4d.angle * 0.5);
        this.x = (float)(axisAngle4d.x * d2);
        this.y = (float)(axisAngle4d.y * d2);
        this.z = (float)(axisAngle4d.z * d2);
        this.w = (float)d3;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public Quaternionf normalize() {
        Quaternionf quaternionf = this;
        return quaternionf.normalize(quaternionf);
    }

    public Quaternionf normalize(Quaternionf quaternionf) {
        float f2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w))));
        quaternionf.x = this.x * f2;
        quaternionf.y = this.y * f2;
        quaternionf.z = this.z * f2;
        quaternionf.w = this.w * f2;
        return quaternionf;
    }

    public Quaternionf add(float f2, float f3, float f4, float f5) {
        return this.add(f2, f3, f4, f5, this);
    }

    public Quaternionf add(float f2, float f3, float f4, float f5, Quaternionf quaternionf) {
        quaternionf.x = this.x + f2;
        quaternionf.y = this.y + f3;
        quaternionf.z = this.z + f4;
        quaternionf.w = this.w + f5;
        return quaternionf;
    }

    public Quaternionf add(Quaternionfc quaternionfc) {
        return this.add(quaternionfc, this);
    }

    public Quaternionf add(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        quaternionf.x = this.x + quaternionfc.x();
        quaternionf.y = this.y + quaternionfc.y();
        quaternionf.z = this.z + quaternionfc.z();
        quaternionf.w = this.w + quaternionfc.w();
        return quaternionf;
    }

    public Quaternionf sub(float f2, float f3, float f4, float f5) {
        return this.sub(f2, f3, f4, f5, this);
    }

    public Quaternionf sub(float f2, float f3, float f4, float f5, Quaternionf quaternionf) {
        quaternionf.x = this.x - f2;
        quaternionf.y = this.y - f3;
        quaternionf.z = this.z - f4;
        quaternionf.w = this.w - f5;
        return quaternionf;
    }

    public Quaternionf sub(Quaternionfc quaternionfc) {
        return this.sub(quaternionfc, this);
    }

    public Quaternionf sub(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        quaternionf.x = this.x - quaternionfc.x();
        quaternionf.y = this.y - quaternionfc.y();
        quaternionf.z = this.z - quaternionfc.z();
        quaternionf.w = this.w - quaternionfc.w();
        return quaternionf;
    }

    public float dot(Quaternionf quaternionf) {
        return this.x * quaternionf.x + this.y * quaternionf.y + this.z * quaternionf.z + this.w * quaternionf.w;
    }

    public float angle() {
        return (float)(2.0 * (double)Math.safeAcos(this.w));
    }

    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set(this);
    }

    public Matrix4x3f get(Matrix4x3f matrix4x3f) {
        return matrix4x3f.set(this);
    }

    public Matrix4x3d get(Matrix4x3d matrix4x3d) {
        return matrix4x3d.set(this);
    }

    public AxisAngle4f get(AxisAngle4f axisAngle4f) {
        float f2;
        float f3;
        float f4;
        float f5 = this.x;
        float f6 = this.y;
        float f7 = this.z;
        float f8 = this.w;
        if (f4 > 1.0f) {
            float f9 = f5;
            float f10 = f6;
            float f11 = f7;
            float f12 = f8;
            f3 = Math.invsqrt(Math.fma(f9, f9, Math.fma(f10, f10, Math.fma(f11, f11, f12 * f12))));
            f5 *= f3;
            f6 *= f3;
            f7 *= f3;
            f8 *= f3;
        }
        axisAngle4f.angle = 2.0f * Math.acos(f8);
        float f13 = f8;
        f3 = Math.sqrt(1.0f - f13 * f13);
        if (f2 < 0.001f) {
            axisAngle4f.x = f5;
            axisAngle4f.y = f6;
            axisAngle4f.z = f7;
        } else {
            f3 = 1.0f / f3;
            axisAngle4f.x = f5 * f3;
            axisAngle4f.y = f6 * f3;
            axisAngle4f.z = f7 * f3;
        }
        return axisAngle4f;
    }

    public AxisAngle4d get(AxisAngle4d axisAngle4d) {
        float f2;
        float f3;
        float f4;
        float f5 = this.x;
        float f6 = this.y;
        float f7 = this.z;
        float f8 = this.w;
        if (f4 > 1.0f) {
            float f9 = f5;
            float f10 = f6;
            float f11 = f7;
            float f12 = f8;
            f3 = Math.invsqrt(Math.fma(f9, f9, Math.fma(f10, f10, Math.fma(f11, f11, f12 * f12))));
            f5 *= f3;
            f6 *= f3;
            f7 *= f3;
            f8 *= f3;
        }
        axisAngle4d.angle = 2.0f * Math.acos(f8);
        float f13 = f8;
        f3 = Math.sqrt(1.0f - f13 * f13);
        if (f2 < 0.001f) {
            axisAngle4d.x = f5;
            axisAngle4d.y = f6;
            axisAngle4d.z = f7;
        } else {
            f3 = 1.0f / f3;
            axisAngle4d.x = f5 * f3;
            axisAngle4d.y = f6 * f3;
            axisAngle4d.z = f7 * f3;
        }
        return axisAngle4d;
    }

    public Quaterniond get(Quaterniond quaterniond) {
        return quaterniond.set(this);
    }

    public Quaternionf get(Quaternionf quaternionf) {
        return quaternionf.set(this);
    }

    public ByteBuffer getAsMatrix3f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putMatrix3f(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer getAsMatrix3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putMatrix3f(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer getAsMatrix4f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putMatrix4f(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer getAsMatrix4f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putMatrix4f(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer getAsMatrix4x3f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putMatrix4x3f(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer getAsMatrix4x3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putMatrix4x3f(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public Quaternionf set(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
        return this;
    }

    public Quaternionf set(Quaternionfc quaternionfc) {
        this.x = quaternionfc.x();
        this.y = quaternionfc.y();
        this.z = quaternionfc.z();
        this.w = quaternionfc.w();
        return this;
    }

    public Quaternionf set(Quaterniondc quaterniondc) {
        this.x = (float)quaterniondc.x();
        this.y = (float)quaterniondc.y();
        this.z = (float)quaterniondc.z();
        this.w = (float)quaterniondc.w();
        return this;
    }

    public Quaternionf set(AxisAngle4f axisAngle4f) {
        return this.setAngleAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaternionf set(AxisAngle4d axisAngle4d) {
        return this.setAngleAxis(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Quaternionf setAngleAxis(float f2, float f3, float f4, float f5) {
        float f6 = Math.sin(f2 * 0.5f);
        this.x = f3 * f6;
        this.y = f4 * f6;
        this.z = f5 * f6;
        this.w = Math.cosFromSin(f6, f2 * 0.5f);
        return this;
    }

    public Quaternionf setAngleAxis(double d2, double d3, double d4, double d5) {
        double d6 = Math.sin(d2 * 0.5);
        this.x = (float)(d3 * d6);
        this.y = (float)(d4 * d6);
        this.z = (float)(d5 * d6);
        this.w = (float)Math.cosFromSin(d6, d2 * 0.5);
        return this;
    }

    public Quaternionf rotationAxis(AxisAngle4f axisAngle4f) {
        return this.rotationAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaternionf rotationAxis(float f2, float f3, float f4, float f5) {
        float f6 = Math.sin(f2 /= 2.0f);
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        float f10 = Math.invsqrt(f7 * f7 + f8 * f8 + f9 * f9);
        return this.set(f3 * f10 * f6, f4 * f10 * f6, f5 * f10 * f6, Math.cosFromSin(f6, f2));
    }

    public Quaternionf rotationAxis(float f2, Vector3fc vector3fc) {
        return this.rotationAxis(f2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Quaternionf rotationX(float f2) {
        float f3 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f3, f2 * 0.5f);
        return this.set(f3, 0.0f, 0.0f, f2);
    }

    public Quaternionf rotationY(float f2) {
        float f3 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f3, f2 * 0.5f);
        return this.set(0.0f, f3, 0.0f, f2);
    }

    public Quaternionf rotationZ(float f2) {
        float f3 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f3, f2 * 0.5f);
        return this.set(0.0f, 0.0f, f3, f2);
    }

    private void setFromUnnormalized(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11 = f2;
        float f12 = f3;
        float f13 = f4;
        float f14 = Math.invsqrt(f11 * f11 + f12 * f12 + f13 * f13);
        float f15 = f5;
        float f16 = f6;
        float f17 = f7;
        float f18 = Math.invsqrt(f15 * f15 + f16 * f16 + f17 * f17);
        float f19 = f8;
        float f20 = f9;
        float f21 = f10;
        float f22 = Math.invsqrt(f19 * f19 + f20 * f20 + f21 * f21);
        this.setFromNormalized(f2 *= f14, f3 *= f14, f4 *= f14, f5 *= f18, f6 *= f18, f7 *= f18, f8 *= f22, f9 *= f22, f10 *= f22);
    }

    private void setFromNormalized(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11;
        float f12 = f2 + f6 + f10;
        if (f11 >= 0.0f) {
            f2 = Math.sqrt(f12 + 1.0f);
            this.w = f2 * 0.5f;
            f2 = 0.5f / f2;
            this.x = (f7 - f9) * f2;
            this.y = (f8 - f4) * f2;
            this.z = (f3 - f5) * f2;
            return;
        }
        if (f2 >= f6 && f2 >= f10) {
            f2 = Math.sqrt(f2 - (f6 + f10) + 1.0f);
            this.x = f2 * 0.5f;
            f2 = 0.5f / f2;
            this.y = (f5 + f3) * f2;
            this.z = (f4 + f8) * f2;
            this.w = (f7 - f9) * f2;
            return;
        }
        if (f6 > f10) {
            f2 = Math.sqrt(f6 - (f10 + f2) + 1.0f);
            this.y = f2 * 0.5f;
            f2 = 0.5f / f2;
            this.z = (f9 + f7) * f2;
            this.x = (f5 + f3) * f2;
            this.w = (f8 - f4) * f2;
            return;
        }
        f2 = Math.sqrt(f10 - (f2 + f6) + 1.0f);
        this.z = f2 * 0.5f;
        f2 = 0.5f / f2;
        this.x = (f4 + f8) * f2;
        this.y = (f9 + f7) * f2;
        this.w = (f3 - f5) * f2;
    }

    private void setFromUnnormalized(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d2;
        double d12 = d3;
        double d13 = d4;
        double d14 = Math.invsqrt(d11 * d11 + d12 * d12 + d13 * d13);
        double d15 = d5;
        double d16 = d6;
        double d17 = d7;
        double d18 = Math.invsqrt(d15 * d15 + d16 * d16 + d17 * d17);
        double d19 = d8;
        double d20 = d9;
        double d21 = d10;
        double d22 = Math.invsqrt(d19 * d19 + d20 * d20 + d21 * d21);
        double d23 = d2 * d14;
        double d24 = d3 * d14;
        double d25 = d4 * d14;
        double d26 = d5 * d18;
        double d27 = d6 * d18;
        double d28 = d7 * d18;
        double d29 = d8 * d22;
        double d30 = d9 * d22;
        double d31 = d10 * d22;
        this.setFromNormalized(d23, d24, d25, d26, d27, d28, d29, d30, d31);
    }

    private void setFromNormalized(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11;
        double d12 = d2 + d6 + d10;
        if (d11 >= 0.0) {
            double d13 = Math.sqrt(d12 + 1.0);
            this.w = (float)(d13 * 0.5);
            d13 = 0.5 / d13;
            this.x = (float)((d7 - d9) * d13);
            this.y = (float)((d8 - d4) * d13);
            this.z = (float)((d3 - d5) * d13);
            return;
        }
        if (d2 >= d6 && d2 >= d10) {
            double d14 = Math.sqrt(d2 - (d6 + d10) + 1.0);
            this.x = (float)(d14 * 0.5);
            d14 = 0.5 / d14;
            this.y = (float)((d5 + d3) * d14);
            this.z = (float)((d4 + d8) * d14);
            this.w = (float)((d7 - d9) * d14);
            return;
        }
        if (d6 > d10) {
            double d15 = Math.sqrt(d6 - (d10 + d2) + 1.0);
            this.y = (float)(d15 * 0.5);
            d15 = 0.5 / d15;
            this.z = (float)((d9 + d7) * d15);
            this.x = (float)((d5 + d3) * d15);
            this.w = (float)((d8 - d4) * d15);
            return;
        }
        double d16 = Math.sqrt(d10 - (d2 + d6) + 1.0);
        this.z = (float)(d16 * 0.5);
        d16 = 0.5 / d16;
        this.x = (float)((d4 + d8) * d16);
        this.y = (float)((d9 + d7) * d16);
        this.w = (float)((d3 - d5) * d16);
    }

    public Quaternionf setFromUnnormalized(Matrix4fc matrix4fc) {
        this.setFromUnnormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromUnnormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromUnnormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4fc matrix4fc) {
        this.setFromNormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromNormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromNormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix4dc matrix4dc) {
        this.setFromUnnormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix4dc matrix4dc) {
        this.setFromNormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix3fc matrix3fc) {
        this.setFromUnnormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix3fc matrix3fc) {
        this.setFromNormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaternionf setFromUnnormalized(Matrix3dc matrix3dc) {
        this.setFromUnnormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaternionf setFromNormalized(Matrix3dc matrix3dc) {
        this.setFromNormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaternionf fromAxisAngleRad(Vector3fc vector3fc, float f2) {
        return this.fromAxisAngleRad(vector3fc.x(), vector3fc.y(), vector3fc.z(), f2);
    }

    public Quaternionf fromAxisAngleRad(float f2, float f3, float f4, float f5) {
        float f6 = Math.sin(f5 /= 2.0f);
        float f7 = f2;
        float f8 = f3;
        float f9 = f4;
        float f10 = 1.0f / Math.sqrt(f7 * f7 + f8 * f8 + f9 * f9) * f6;
        this.x = f2 * f10;
        this.y = f3 * f10;
        this.z = f4 * f10;
        this.w = Math.cosFromSin(f6, f5);
        return this;
    }

    public Quaternionf fromAxisAngleDeg(Vector3fc vector3fc, float f2) {
        return this.fromAxisAngleRad(vector3fc.x(), vector3fc.y(), vector3fc.z(), Math.toRadians(f2));
    }

    public Quaternionf fromAxisAngleDeg(float f2, float f3, float f4, float f5) {
        return this.fromAxisAngleRad(f2, f3, f4, Math.toRadians(f5));
    }

    public Quaternionf mul(Quaternionfc quaternionfc) {
        return this.mul(quaternionfc, this);
    }

    public Quaternionf mul(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(this.w, quaternionfc.x(), Math.fma(this.x, quaternionfc.w(), Math.fma(this.y, quaternionfc.z(), -this.z * quaternionfc.y()))), Math.fma(this.w, quaternionfc.y(), Math.fma(-this.x, quaternionfc.z(), Math.fma(this.y, quaternionfc.w(), this.z * quaternionfc.x()))), Math.fma(this.w, quaternionfc.z(), Math.fma(this.x, quaternionfc.y(), Math.fma(-this.y, quaternionfc.x(), this.z * quaternionfc.w()))), Math.fma(this.w, quaternionfc.w(), Math.fma(-this.x, quaternionfc.x(), Math.fma(-this.y, quaternionfc.y(), -this.z * quaternionfc.z()))));
    }

    public Quaternionf mul(float f2, float f3, float f4, float f5) {
        return this.mul(f2, f3, f4, f5, this);
    }

    public Quaternionf mul(float f2, float f3, float f4, float f5, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(this.w, f2, Math.fma(this.x, f5, Math.fma(this.y, f4, -this.z * f3))), Math.fma(this.w, f3, Math.fma(-this.x, f4, Math.fma(this.y, f5, this.z * f2))), Math.fma(this.w, f4, Math.fma(this.x, f3, Math.fma(-this.y, f2, this.z * f5))), Math.fma(this.w, f5, Math.fma(-this.x, f2, Math.fma(-this.y, f3, -this.z * f4))));
    }

    public Quaternionf mul(float f2) {
        return this.mul(f2, this);
    }

    public Quaternionf mul(float f2, Quaternionf quaternionf) {
        quaternionf.x = this.x * f2;
        quaternionf.y = this.y * f2;
        quaternionf.z = this.z * f2;
        quaternionf.w = this.w * f2;
        return quaternionf;
    }

    public Quaternionf premul(Quaternionfc quaternionfc) {
        return this.premul(quaternionfc, this);
    }

    public Quaternionf premul(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(quaternionfc.w(), this.x, Math.fma(quaternionfc.x(), this.w, Math.fma(quaternionfc.y(), this.z, -quaternionfc.z() * this.y))), Math.fma(quaternionfc.w(), this.y, Math.fma(-quaternionfc.x(), this.z, Math.fma(quaternionfc.y(), this.w, quaternionfc.z() * this.x))), Math.fma(quaternionfc.w(), this.z, Math.fma(quaternionfc.x(), this.y, Math.fma(-quaternionfc.y(), this.x, quaternionfc.z() * this.w))), Math.fma(quaternionfc.w(), this.w, Math.fma(-quaternionfc.x(), this.x, Math.fma(-quaternionfc.y(), this.y, -quaternionfc.z() * this.z))));
    }

    public Quaternionf premul(float f2, float f3, float f4, float f5) {
        return this.premul(f2, f3, f4, f5, this);
    }

    public Quaternionf premul(float f2, float f3, float f4, float f5, Quaternionf quaternionf) {
        return quaternionf.set(Math.fma(f5, this.x, Math.fma(f2, this.w, Math.fma(f3, this.z, -f4 * this.y))), Math.fma(f5, this.y, Math.fma(-f2, this.z, Math.fma(f3, this.w, f4 * this.x))), Math.fma(f5, this.z, Math.fma(f2, this.y, Math.fma(-f3, this.x, f4 * this.w))), Math.fma(f5, this.w, Math.fma(-f2, this.x, Math.fma(-f3, this.y, -f4 * this.z))));
    }

    public Vector3f transform(Vector3f vector3f) {
        return this.transform(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    public Vector3f transformInverse(Vector3f vector3f) {
        return this.transformInverse(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    public Vector3f transformPositiveX(Vector3f vector3f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.x * this.z;
        float f9 = this.y * this.w;
        vector3f.x = f2 + f3 - f5 - f4;
        vector3f.y = f7 + f6 + f6 + f7;
        vector3f.z = f8 - f9 + f8 - f9;
        return vector3f;
    }

    public Vector4f transformPositiveX(Vector4f vector4f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.x * this.z;
        float f9 = this.y * this.w;
        vector4f.x = f2 + f3 - f5 - f4;
        vector4f.y = f7 + f6 + f6 + f7;
        vector4f.z = f8 - f9 + f8 - f9;
        return vector4f;
    }

    public Vector3f transformUnitPositiveX(Vector3f vector3f) {
        float f2 = this.x * this.y;
        float f3 = this.x * this.z;
        float f4 = this.y * this.y;
        float f5 = this.y * this.w;
        float f6 = this.z * this.z;
        float f7 = this.z * this.w;
        vector3f.x = 1.0f - f4 - f6 - f4 - f6;
        vector3f.y = f2 + f7 + f2 + f7;
        vector3f.z = f3 - f5 + f3 - f5;
        return vector3f;
    }

    public Vector4f transformUnitPositiveX(Vector4f vector4f) {
        float f2 = this.y * this.y;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.x * this.z;
        float f6 = this.y * this.w;
        float f7 = this.z * this.w;
        vector4f.x = 1.0f - f2 - f2 - f3 - f3;
        vector4f.y = f4 + f7 + f4 + f7;
        vector4f.z = f5 - f6 + f5 - f6;
        return vector4f;
    }

    public Vector3f transformPositiveY(Vector3f vector3f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector3f.x = -f6 + f7 - f6 + f7;
        vector3f.y = f4 - f5 + f2 - f3;
        float f10 = f8;
        vector3f.z = f10 + f10 + f9 + f9;
        return vector3f;
    }

    public Vector4f transformPositiveY(Vector4f vector4f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector4f.x = -f6 + f7 - f6 + f7;
        vector4f.y = f4 - f5 + f2 - f3;
        float f10 = f8;
        vector4f.z = f10 + f10 + f9 + f9;
        return vector4f;
    }

    public Vector4f transformUnitPositiveY(Vector4f vector4f) {
        float f2 = this.x * this.x;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.z * this.w;
        vector4f.x = f4 - f7 + f4 - f7;
        vector4f.y = 1.0f - f2 - f2 - f3 - f3;
        float f8 = f5;
        vector4f.z = f8 + f8 + f6 + f6;
        return vector4f;
    }

    public Vector3f transformUnitPositiveY(Vector3f vector3f) {
        float f2 = this.x * this.x;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.z * this.w;
        vector3f.x = f4 - f7 + f4 - f7;
        vector3f.y = 1.0f - f2 - f2 - f3 - f3;
        float f8 = f5;
        vector3f.z = f8 + f8 + f6 + f6;
        return vector3f;
    }

    public Vector3f transformPositiveZ(Vector3f vector3f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.x * this.z;
        float f7 = this.y * this.w;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector3f.x = f7 + f6 + f6 + f7;
        float f10 = f8;
        vector3f.y = f10 + f10 - f9 - f9;
        vector3f.z = f5 - f4 - f3 + f2;
        return vector3f;
    }

    public Vector4f transformPositiveZ(Vector4f vector4f) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.x * this.z;
        float f7 = this.y * this.w;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector4f.x = f7 + f6 + f6 + f7;
        float f10 = f8;
        vector4f.y = f10 + f10 - f9 - f9;
        vector4f.z = f5 - f4 - f3 + f2;
        return vector4f;
    }

    public Vector4f transformUnitPositiveZ(Vector4f vector4f) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.x * this.z;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.y * this.w;
        vector4f.x = f4 + f7 + f4 + f7;
        float f8 = f5;
        vector4f.y = f8 + f8 - f6 - f6;
        vector4f.z = 1.0f - f2 - f2 - f3 - f3;
        return vector4f;
    }

    public Vector3f transformUnitPositiveZ(Vector3f vector3f) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.x * this.z;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.y * this.w;
        vector3f.x = f4 + f7 + f4 + f7;
        float f8 = f5;
        vector3f.y = f8 + f8 - f6 - f6;
        vector3f.z = 1.0f - f2 - f2 - f3 - f3;
        return vector3f;
    }

    public Vector4f transform(Vector4f vector4f) {
        Vector4f vector4f2 = vector4f;
        return this.transform(vector4f2, vector4f2);
    }

    public Vector4f transformInverse(Vector4f vector4f) {
        Vector4f vector4f2 = vector4f;
        return this.transformInverse(vector4f2, vector4f2);
    }

    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transform(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    public Vector3f transformInverse(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverse(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    public Vector3f transform(float f2, float f3, float f4, Vector3f vector3f) {
        float f5 = this.x * this.x;
        float f6 = this.y * this.y;
        float f7 = this.z * this.z;
        float f8 = this.w * this.w;
        float f9 = this.x * this.y;
        float f10 = this.x * this.z;
        float f11 = this.y * this.z;
        float f12 = this.x * this.w;
        float f13 = this.z * this.w;
        float f14 = this.y * this.w;
        float f15 = 1.0f / (f5 + f6 + f7 + f8);
        return vector3f.set(Math.fma((f5 - f6 - f7 + f8) * f15, f2, Math.fma(2.0f * (f9 - f13) * f15, f3, 2.0f * (f10 + f14) * f15 * f4)), Math.fma(2.0f * (f9 + f13) * f15, f2, Math.fma((f6 - f5 - f7 + f8) * f15, f3, 2.0f * (f11 - f12) * f15 * f4)), Math.fma(2.0f * (f10 - f14) * f15, f2, Math.fma(2.0f * (f11 + f12) * f15, f3, (f7 - f5 - f6 + f8) * f15 * f4)));
    }

    public Vector3f transformInverse(float f2, float f3, float f4, Vector3f vector3f) {
        float f5 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f6 = this.x * f5;
        float f7 = this.y * f5;
        float f8 = this.z * f5;
        f5 = this.w * f5;
        float f9 = f6;
        float f10 = f9 * f9;
        float f11 = f7;
        float f12 = f11 * f11;
        float f13 = f8;
        float f14 = f13 * f13;
        float f15 = f5;
        float f16 = f15 * f15;
        float f17 = f6 * f7;
        float f18 = f6 * f8;
        float f19 = f7 * f8;
        f6 *= f5;
        f8 *= f5;
        f5 = f7 * f5;
        f7 = 1.0f / (f10 + f12 + f14 + f16);
        return vector3f.set(Math.fma((f10 - f12 - f14 + f16) * f7, f2, Math.fma(2.0f * (f17 + f8) * f7, f3, 2.0f * (f18 - f5) * f7 * f4)), Math.fma(2.0f * (f17 - f8) * f7, f2, Math.fma((f12 - f10 - f14 + f16) * f7, f3, 2.0f * (f19 + f6) * f7 * f4)), Math.fma(2.0f * (f18 + f5) * f7, f2, Math.fma(2.0f * (f19 - f6) * f7, f3, (f14 - f10 - f12 + f16) * f7 * f4)));
    }

    public Vector3f transformUnit(Vector3f vector3f) {
        return this.transformUnit(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    public Vector3f transformInverseUnit(Vector3f vector3f) {
        return this.transformInverseUnit(vector3f.x, vector3f.y, vector3f.z, vector3f);
    }

    public Vector3f transformUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformUnit(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    public Vector3f transformInverseUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverseUnit(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    public Vector3f transformUnit(float f2, float f3, float f4, Vector3f vector3f) {
        float f5 = this.x * this.x;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.x * this.w;
        float f9 = this.y * this.y;
        float f10 = this.y * this.z;
        float f11 = this.y * this.w;
        float f12 = this.z * this.z;
        float f13 = this.z * this.w;
        return vector3f.set(Math.fma(Math.fma(-2.0f, f9 + f12, 1.0f), f2, Math.fma(2.0f * (f6 - f13), f3, 2.0f * (f7 + f11) * f4)), Math.fma(2.0f * (f6 + f13), f2, Math.fma(Math.fma(-2.0f, f5 + f12, 1.0f), f3, 2.0f * (f10 - f8) * f4)), Math.fma(2.0f * (f7 - f11), f2, Math.fma(2.0f * (f10 + f8), f3, Math.fma(-2.0f, f5 + f9, 1.0f) * f4)));
    }

    public Vector3f transformInverseUnit(float f2, float f3, float f4, Vector3f vector3f) {
        float f5 = this.x * this.x;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.x * this.w;
        float f9 = this.y * this.y;
        float f10 = this.y * this.z;
        float f11 = this.y * this.w;
        float f12 = this.z * this.z;
        float f13 = this.z * this.w;
        return vector3f.set(Math.fma(Math.fma(-2.0f, f9 + f12, 1.0f), f2, Math.fma(2.0f * (f6 + f13), f3, 2.0f * (f7 - f11) * f4)), Math.fma(2.0f * (f6 - f13), f2, Math.fma(Math.fma(-2.0f, f5 + f12, 1.0f), f3, 2.0f * (f10 + f8) * f4)), Math.fma(2.0f * (f7 + f11), f2, Math.fma(2.0f * (f10 - f8), f3, Math.fma(-2.0f, f5 + f9, 1.0f) * f4)));
    }

    public Vector4f transform(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transform(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    public Vector4f transformInverse(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverse(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    public Vector4f transform(float f2, float f3, float f4, Vector4f vector4f) {
        float f5 = this.x * this.x;
        float f6 = this.y * this.y;
        float f7 = this.z * this.z;
        float f8 = this.w * this.w;
        float f9 = this.x * this.y;
        float f10 = this.x * this.z;
        float f11 = this.y * this.z;
        float f12 = this.x * this.w;
        float f13 = this.z * this.w;
        float f14 = this.y * this.w;
        float f15 = 1.0f / (f5 + f6 + f7 + f8);
        return vector4f.set(Math.fma((f5 - f6 - f7 + f8) * f15, f2, Math.fma(2.0f * (f9 - f13) * f15, f3, 2.0f * (f10 + f14) * f15 * f4)), Math.fma(2.0f * (f9 + f13) * f15, f2, Math.fma((f6 - f5 - f7 + f8) * f15, f3, 2.0f * (f11 - f12) * f15 * f4)), Math.fma(2.0f * (f10 - f14) * f15, f2, Math.fma(2.0f * (f11 + f12) * f15, f3, (f7 - f5 - f6 + f8) * f15 * f4)));
    }

    public Vector4f transformInverse(float f2, float f3, float f4, Vector4f vector4f) {
        float f5 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f6 = this.x * f5;
        float f7 = this.y * f5;
        float f8 = this.z * f5;
        f5 = this.w * f5;
        float f9 = f6;
        float f10 = f9 * f9;
        float f11 = f7;
        float f12 = f11 * f11;
        float f13 = f8;
        float f14 = f13 * f13;
        float f15 = f5;
        float f16 = f15 * f15;
        float f17 = f6 * f7;
        float f18 = f6 * f8;
        float f19 = f7 * f8;
        f6 *= f5;
        f8 *= f5;
        f5 = f7 * f5;
        f7 = 1.0f / (f10 + f12 + f14 + f16);
        return vector4f.set(Math.fma((f10 - f12 - f14 + f16) * f7, f2, Math.fma(2.0f * (f17 + f8) * f7, f3, 2.0f * (f18 - f5) * f7 * f4)), Math.fma(2.0f * (f17 - f8) * f7, f2, Math.fma((f12 - f10 - f14 + f16) * f7, f3, 2.0f * (f19 + f6) * f7 * f4)), Math.fma(2.0f * (f18 + f5) * f7, f2, Math.fma(2.0f * (f19 - f6) * f7, f3, (f14 - f10 - f12 + f16) * f7 * f4)));
    }

    public Vector3d transform(Vector3d vector3d) {
        return this.transform(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector3d transformInverse(Vector3d vector3d) {
        return this.transformInverse(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector4f transformUnit(Vector4f vector4f) {
        return this.transformUnit(vector4f.x, vector4f.y, vector4f.z, vector4f);
    }

    public Vector4f transformInverseUnit(Vector4f vector4f) {
        return this.transformInverseUnit(vector4f.x, vector4f.y, vector4f.z, vector4f);
    }

    public Vector4f transformUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformUnit(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    public Vector4f transformInverseUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverseUnit(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4f);
    }

    public Vector4f transformUnit(float f2, float f3, float f4, Vector4f vector4f) {
        float f5 = this.x * this.x;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.x * this.w;
        float f9 = this.y * this.y;
        float f10 = this.y * this.z;
        float f11 = this.y * this.w;
        float f12 = this.z * this.z;
        float f13 = this.z * this.w;
        return vector4f.set(Math.fma(Math.fma(-2.0f, f9 + f12, 1.0f), f2, Math.fma(2.0f * (f6 - f13), f3, 2.0f * (f7 + f11) * f4)), Math.fma(2.0f * (f6 + f13), f2, Math.fma(Math.fma(-2.0f, f5 + f12, 1.0f), f3, 2.0f * (f10 - f8) * f4)), Math.fma(2.0f * (f7 - f11), f2, Math.fma(2.0f * (f10 + f8), f3, Math.fma(-2.0f, f5 + f9, 1.0f) * f4)));
    }

    public Vector4f transformInverseUnit(float f2, float f3, float f4, Vector4f vector4f) {
        float f5 = this.x * this.x;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.x * this.w;
        float f9 = this.y * this.y;
        float f10 = this.y * this.z;
        float f11 = this.y * this.w;
        float f12 = this.z * this.z;
        float f13 = this.z * this.w;
        return vector4f.set(Math.fma(Math.fma(-2.0f, f9 + f12, 1.0f), f2, Math.fma(2.0f * (f6 + f13), f3, 2.0f * (f7 - f11) * f4)), Math.fma(2.0f * (f6 - f13), f2, Math.fma(Math.fma(-2.0f, f5 + f12, 1.0f), f3, 2.0f * (f10 + f8) * f4)), Math.fma(2.0f * (f7 + f11), f2, Math.fma(2.0f * (f10 - f8), f3, Math.fma(-2.0f, f5 + f9, 1.0f) * f4)));
    }

    public Vector3d transformPositiveX(Vector3d vector3d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.x * this.z;
        float f9 = this.y * this.w;
        vector3d.x = f2 + f3 - f5 - f4;
        vector3d.y = f7 + f6 + f6 + f7;
        vector3d.z = f8 - f9 + f8 - f9;
        return vector3d;
    }

    public Vector4d transformPositiveX(Vector4d vector4d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.x * this.z;
        float f9 = this.y * this.w;
        vector4d.x = f2 + f3 - f5 - f4;
        vector4d.y = f7 + f6 + f6 + f7;
        vector4d.z = f8 - f9 + f8 - f9;
        return vector4d;
    }

    public Vector3d transformUnitPositiveX(Vector3d vector3d) {
        float f2 = this.y * this.y;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.x * this.z;
        float f6 = this.y * this.w;
        float f7 = this.z * this.w;
        vector3d.x = 1.0f - f2 - f2 - f3 - f3;
        vector3d.y = f4 + f7 + f4 + f7;
        vector3d.z = f5 - f6 + f5 - f6;
        return vector3d;
    }

    public Vector4d transformUnitPositiveX(Vector4d vector4d) {
        float f2 = this.y * this.y;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.x * this.z;
        float f6 = this.y * this.w;
        float f7 = this.z * this.w;
        vector4d.x = 1.0f - f2 - f2 - f3 - f3;
        vector4d.y = f4 + f7 + f4 + f7;
        vector4d.z = f5 - f6 + f5 - f6;
        return vector4d;
    }

    public Vector3d transformPositiveY(Vector3d vector3d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector3d.x = -f6 + f7 - f6 + f7;
        vector3d.y = f4 - f5 + f2 - f3;
        float f10 = f8;
        vector3d.z = f10 + f10 + f9 + f9;
        return vector3d;
    }

    public Vector4d transformPositiveY(Vector4d vector4d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.z * this.w;
        float f7 = this.x * this.y;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector4d.x = -f6 + f7 - f6 + f7;
        vector4d.y = f4 - f5 + f2 - f3;
        float f10 = f8;
        vector4d.z = f10 + f10 + f9 + f9;
        return vector4d;
    }

    public Vector4d transformUnitPositiveY(Vector4d vector4d) {
        float f2 = this.x * this.x;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.z * this.w;
        vector4d.x = f4 - f7 + f4 - f7;
        vector4d.y = 1.0f - f2 - f2 - f3 - f3;
        float f8 = f5;
        vector4d.z = f8 + f8 + f6 + f6;
        return vector4d;
    }

    public Vector3d transformUnitPositiveY(Vector3d vector3d) {
        float f2 = this.x * this.x;
        float f3 = this.z * this.z;
        float f4 = this.x * this.y;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.z * this.w;
        vector3d.x = f4 - f7 + f4 - f7;
        vector3d.y = 1.0f - f2 - f2 - f3 - f3;
        float f8 = f5;
        vector3d.z = f8 + f8 + f6 + f6;
        return vector3d;
    }

    public Vector3d transformPositiveZ(Vector3d vector3d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.x * this.z;
        float f7 = this.y * this.w;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector3d.x = f7 + f6 + f6 + f7;
        float f10 = f8;
        vector3d.y = f10 + f10 - f9 - f9;
        vector3d.z = f5 - f4 - f3 + f2;
        return vector3d;
    }

    public Vector4d transformPositiveZ(Vector4d vector4d) {
        float f2 = this.w * this.w;
        float f3 = this.x * this.x;
        float f4 = this.y * this.y;
        float f5 = this.z * this.z;
        float f6 = this.x * this.z;
        float f7 = this.y * this.w;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        vector4d.x = f7 + f6 + f6 + f7;
        float f10 = f8;
        vector4d.y = f10 + f10 - f9 - f9;
        vector4d.z = f5 - f4 - f3 + f2;
        return vector4d;
    }

    public Vector4d transformUnitPositiveZ(Vector4d vector4d) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.x * this.z;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.y * this.w;
        vector4d.x = f4 + f7 + f4 + f7;
        float f8 = f5;
        vector4d.y = f8 + f8 - f6 - f6;
        vector4d.z = 1.0f - f2 - f2 - f3 - f3;
        return vector4d;
    }

    public Vector3d transformUnitPositiveZ(Vector3d vector3d) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.x * this.z;
        float f5 = this.y * this.z;
        float f6 = this.x * this.w;
        float f7 = this.y * this.w;
        vector3d.x = f4 + f7 + f4 + f7;
        float f8 = f5;
        vector3d.y = f8 + f8 - f6 - f6;
        vector3d.z = 1.0f - f2 - f2 - f3 - f3;
        return vector3d;
    }

    public Vector4d transform(Vector4d vector4d) {
        Vector4d vector4d2 = vector4d;
        return this.transform(vector4d2, vector4d2);
    }

    public Vector4d transformInverse(Vector4d vector4d) {
        Vector4d vector4d2 = vector4d;
        return this.transformInverse(vector4d2, vector4d2);
    }

    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transform(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformInverse(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverse(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transform(float f2, float f3, float f4, Vector3d vector3d) {
        return this.transform((double)f2, (double)f3, (double)f4, vector3d);
    }

    public Vector3d transformInverse(float f2, float f3, float f4, Vector3d vector3d) {
        return this.transformInverse((double)f2, (double)f3, (double)f4, vector3d);
    }

    public Vector3d transform(double d2, double d3, double d4, Vector3d vector3d) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.w * this.w;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        float f10 = this.z * this.w;
        float f11 = this.y * this.w;
        float f12 = 1.0f / (f2 + f3 + f4 + f5);
        return vector3d.set(Math.fma((double)((f2 - f3 - f4 + f5) * f12), d2, Math.fma((double)(2.0f * (f6 - f10) * f12), d3, (double)(2.0f * (f7 + f11) * f12) * d4)), Math.fma((double)(2.0f * (f6 + f10) * f12), d2, Math.fma((double)((f3 - f2 - f4 + f5) * f12), d3, (double)(2.0f * (f8 - f9) * f12) * d4)), Math.fma((double)(2.0f * (f7 - f11) * f12), d2, Math.fma((double)(2.0f * (f8 + f9) * f12), d3, (double)((f4 - f2 - f3 + f5) * f12) * d4)));
    }

    public Vector3d transformInverse(double d2, double d3, double d4, Vector3d vector3d) {
        float f2 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f3 = this.x * f2;
        float f4 = this.y * f2;
        float f5 = this.z * f2;
        f2 = this.w * f2;
        float f6 = f3;
        float f7 = f6 * f6;
        float f8 = f4;
        float f9 = f8 * f8;
        float f10 = f5;
        float f11 = f10 * f10;
        float f12 = f2;
        float f13 = f12 * f12;
        float f14 = f3 * f4;
        float f15 = f3 * f5;
        float f16 = f4 * f5;
        f3 *= f2;
        f5 *= f2;
        f2 = f4 * f2;
        f4 = 1.0f / (f7 + f9 + f11 + f13);
        return vector3d.set(Math.fma((double)((f7 - f9 - f11 + f13) * f4), d2, Math.fma((double)(2.0f * (f14 + f5) * f4), d3, (double)(2.0f * (f15 - f2) * f4) * d4)), Math.fma((double)(2.0f * (f14 - f5) * f4), d2, Math.fma((double)((f9 - f7 - f11 + f13) * f4), d3, (double)(2.0f * (f16 + f3) * f4) * d4)), Math.fma((double)(2.0f * (f15 + f2) * f4), d2, Math.fma((double)(2.0f * (f16 - f3) * f4), d3, (double)((f11 - f7 - f9 + f13) * f4) * d4)));
    }

    public Vector4d transform(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transform(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformInverse(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverse(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transform(double d2, double d3, double d4, Vector4d vector4d) {
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.w * this.w;
        float f6 = this.x * this.y;
        float f7 = this.x * this.z;
        float f8 = this.y * this.z;
        float f9 = this.x * this.w;
        float f10 = this.z * this.w;
        float f11 = this.y * this.w;
        float f12 = 1.0f / (f2 + f3 + f4 + f5);
        return vector4d.set(Math.fma((double)((f2 - f3 - f4 + f5) * f12), d2, Math.fma((double)(2.0f * (f6 - f10) * f12), d3, (double)(2.0f * (f7 + f11) * f12) * d4)), Math.fma((double)(2.0f * (f6 + f10) * f12), d2, Math.fma((double)((f3 - f2 - f4 + f5) * f12), d3, (double)(2.0f * (f8 - f9) * f12) * d4)), Math.fma((double)(2.0f * (f7 - f11) * f12), d2, Math.fma((double)(2.0f * (f8 + f9) * f12), d3, (double)((f4 - f2 - f3 + f5) * f12) * d4)));
    }

    public Vector4d transformInverse(double d2, double d3, double d4, Vector4d vector4d) {
        float f2 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        float f3 = this.x * f2;
        float f4 = this.y * f2;
        float f5 = this.z * f2;
        f2 = this.w * f2;
        float f6 = f3;
        float f7 = f6 * f6;
        float f8 = f4;
        float f9 = f8 * f8;
        float f10 = f5;
        float f11 = f10 * f10;
        float f12 = f2;
        float f13 = f12 * f12;
        float f14 = f3 * f4;
        float f15 = f3 * f5;
        float f16 = f4 * f5;
        f3 *= f2;
        f5 *= f2;
        f2 = f4 * f2;
        f4 = 1.0f / (f7 + f9 + f11 + f13);
        return vector4d.set(Math.fma((double)((f7 - f9 - f11 + f13) * f4), d2, Math.fma((double)(2.0f * (f14 + f5) * f4), d3, (double)(2.0f * (f15 - f2) * f4) * d4)), Math.fma((double)(2.0f * (f14 - f5) * f4), d2, Math.fma((double)((f9 - f7 - f11 + f13) * f4), d3, (double)(2.0f * (f16 + f3) * f4) * d4)), Math.fma((double)(2.0f * (f15 + f2) * f4), d2, Math.fma((double)(2.0f * (f16 - f3) * f4), d3, (double)((f11 - f7 - f9 + f13) * f4) * d4)));
    }

    public Vector4d transformUnit(Vector4d vector4d) {
        Vector4d vector4d2 = vector4d;
        return this.transformUnit(vector4d2, vector4d2);
    }

    public Vector4d transformInverseUnit(Vector4d vector4d) {
        Vector4d vector4d2 = vector4d;
        return this.transformInverseUnit(vector4d2, vector4d2);
    }

    public Vector3d transformUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformInverseUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverseUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformUnit(float f2, float f3, float f4, Vector3d vector3d) {
        return this.transformUnit((double)f2, (double)f3, (double)f4, vector3d);
    }

    public Vector3d transformInverseUnit(float f2, float f3, float f4, Vector3d vector3d) {
        return this.transformInverseUnit((double)f2, (double)f3, (double)f4, vector3d);
    }

    public Vector3d transformUnit(double d2, double d3, double d4, Vector3d vector3d) {
        float f2 = this.x * this.x;
        float f3 = this.x * this.y;
        float f4 = this.x * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.y;
        float f7 = this.y * this.z;
        float f8 = this.y * this.w;
        float f9 = this.z * this.z;
        float f10 = this.z * this.w;
        return vector3d.set(Math.fma((double)Math.fma(-2.0f, f6 + f9, 1.0f), d2, Math.fma((double)(2.0f * (f3 - f10)), d3, (double)(2.0f * (f4 + f8)) * d4)), Math.fma((double)(2.0f * (f3 + f10)), d2, Math.fma((double)Math.fma(-2.0f, f2 + f9, 1.0f), d3, (double)(2.0f * (f7 - f5)) * d4)), Math.fma((double)(2.0f * (f4 - f8)), d2, Math.fma((double)(2.0f * (f7 + f5)), d3, (double)Math.fma(-2.0f, f2 + f6, 1.0f) * d4)));
    }

    public Vector3d transformInverseUnit(double d2, double d3, double d4, Vector3d vector3d) {
        float f2 = this.x * this.x;
        float f3 = this.x * this.y;
        float f4 = this.x * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.y;
        float f7 = this.y * this.z;
        float f8 = this.y * this.w;
        float f9 = this.z * this.z;
        float f10 = this.z * this.w;
        return vector3d.set(Math.fma((double)Math.fma(-2.0f, f6 + f9, 1.0f), d2, Math.fma((double)(2.0f * (f3 + f10)), d3, (double)(2.0f * (f4 - f8)) * d4)), Math.fma((double)(2.0f * (f3 - f10)), d2, Math.fma((double)Math.fma(-2.0f, f2 + f9, 1.0f), d3, (double)(2.0f * (f7 + f5)) * d4)), Math.fma((double)(2.0f * (f4 + f8)), d2, Math.fma((double)(2.0f * (f7 - f5)), d3, (double)Math.fma(-2.0f, f2 + f6, 1.0f) * d4)));
    }

    public Vector4d transformUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformInverseUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverseUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformUnit(double d2, double d3, double d4, Vector4d vector4d) {
        float f2 = this.x * this.x;
        float f3 = this.x * this.y;
        float f4 = this.x * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.y;
        float f7 = this.y * this.z;
        float f8 = this.y * this.w;
        float f9 = this.z * this.z;
        float f10 = this.z * this.w;
        return vector4d.set(Math.fma((double)Math.fma(-2.0f, f6 + f9, 1.0f), d2, Math.fma((double)(2.0f * (f3 - f10)), d3, (double)(2.0f * (f4 + f8)) * d4)), Math.fma((double)(2.0f * (f3 + f10)), d2, Math.fma((double)Math.fma(-2.0f, f2 + f9, 1.0f), d3, (double)(2.0f * (f7 - f5)) * d4)), Math.fma((double)(2.0f * (f4 - f8)), d2, Math.fma((double)(2.0f * (f7 + f5)), d3, (double)Math.fma(-2.0f, f2 + f6, 1.0f) * d4)));
    }

    public Vector4d transformInverseUnit(double d2, double d3, double d4, Vector4d vector4d) {
        float f2 = this.x * this.x;
        float f3 = this.x * this.y;
        float f4 = this.x * this.z;
        float f5 = this.x * this.w;
        float f6 = this.y * this.y;
        float f7 = this.y * this.z;
        float f8 = this.y * this.w;
        float f9 = this.z * this.z;
        float f10 = this.z * this.w;
        return vector4d.set(Math.fma((double)Math.fma(-2.0f, f6 + f9, 1.0f), d2, Math.fma((double)(2.0f * (f3 + f10)), d3, (double)(2.0f * (f4 - f8)) * d4)), Math.fma((double)(2.0f * (f3 - f10)), d2, Math.fma((double)Math.fma(-2.0f, f2 + f9, 1.0f), d3, (double)(2.0f * (f7 + f5)) * d4)), Math.fma((double)(2.0f * (f4 + f8)), d2, Math.fma((double)(2.0f * (f7 - f5)), d3, (double)Math.fma(-2.0f, f2 + f6, 1.0f) * d4)));
    }

    public Quaternionf invert(Quaternionf quaternionf) {
        float f2 = 1.0f / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        quaternionf.x = -this.x * f2;
        quaternionf.y = -this.y * f2;
        quaternionf.z = -this.z * f2;
        quaternionf.w = this.w * f2;
        return quaternionf;
    }

    public Quaternionf invert() {
        Quaternionf quaternionf = this;
        return quaternionf.invert(quaternionf);
    }

    public Quaternionf div(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        float f2 = 1.0f / Math.fma(quaternionfc.x(), quaternionfc.x(), Math.fma(quaternionfc.y(), quaternionfc.y(), Math.fma(quaternionfc.z(), quaternionfc.z(), quaternionfc.w() * quaternionfc.w())));
        float f3 = -quaternionfc.x() * f2;
        float f4 = -quaternionfc.y() * f2;
        float f5 = -quaternionfc.z() * f2;
        float f6 = quaternionfc.w() * f2;
        return quaternionf.set(Math.fma(this.w, f3, Math.fma(this.x, f6, Math.fma(this.y, f5, -this.z * f4))), Math.fma(this.w, f4, Math.fma(-this.x, f5, Math.fma(this.y, f6, this.z * f3))), Math.fma(this.w, f5, Math.fma(this.x, f4, Math.fma(-this.y, f3, this.z * f6))), Math.fma(this.w, f6, Math.fma(-this.x, f3, Math.fma(-this.y, f4, -this.z * f5))));
    }

    public Quaternionf div(Quaternionfc quaternionfc) {
        return this.div(quaternionfc, this);
    }

    public Quaternionf div(float f2, Quaternionf quaternionf) {
        quaternionf.x = this.x / f2;
        quaternionf.y = this.y / f2;
        quaternionf.z = this.z / f2;
        quaternionf.w = this.w / f2;
        return this;
    }

    public Quaternionf div(float f2) {
        return this.div(f2, this);
    }

    public Quaternionf conjugate() {
        Quaternionf quaternionf = this;
        return quaternionf.conjugate(quaternionf);
    }

    public Quaternionf conjugate(Quaternionf quaternionf) {
        quaternionf.x = -this.x;
        quaternionf.y = -this.y;
        quaternionf.z = -this.z;
        quaternionf.w = this.w;
        return quaternionf;
    }

    public Quaternionf identity() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
        return this;
    }

    public Quaternionf rotateXYZ(float f2, float f3, float f4) {
        return this.rotateXYZ(f2, f3, f4, this);
    }

    public Quaternionf rotateXYZ(float f2, float f3, float f4, Quaternionf quaternionf) {
        float f5 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f5, f2 * 0.5f);
        float f6 = Math.sin(f3 * 0.5f);
        f3 = Math.cosFromSin(f6, f3 * 0.5f);
        float f7 = Math.sin(f4 * 0.5f);
        f4 = Math.cosFromSin(f7, f4 * 0.5f);
        float f8 = f3 * f4;
        float f9 = f6 * f7;
        f4 = f6 * f4;
        f3 *= f7;
        f6 = f2 * f8 - f5 * f9;
        f7 = f5 * f8 + f2 * f9;
        f8 = f2 * f4 - f5 * f3;
        f2 = f2 * f3 + f5 * f4;
        return quaternionf.set(Math.fma(this.w, f7, Math.fma(this.x, f6, Math.fma(this.y, f2, -this.z * f8))), Math.fma(this.w, f8, Math.fma(-this.x, f2, Math.fma(this.y, f6, this.z * f7))), Math.fma(this.w, f2, Math.fma(this.x, f8, Math.fma(-this.y, f7, this.z * f6))), Math.fma(this.w, f6, Math.fma(-this.x, f7, Math.fma(-this.y, f8, -this.z * f2))));
    }

    public Quaternionf rotateZYX(float f2, float f3, float f4) {
        return this.rotateZYX(f2, f3, f4, this);
    }

    public Quaternionf rotateZYX(float f2, float f3, float f4, Quaternionf quaternionf) {
        float f5 = Math.sin(f4 * 0.5f);
        f4 = Math.cosFromSin(f5, f4 * 0.5f);
        float f6 = Math.sin(f3 * 0.5f);
        f3 = Math.cosFromSin(f6, f3 * 0.5f);
        float f7 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f7, f2 * 0.5f);
        float f8 = f3 * f2;
        float f9 = f6 * f7;
        f2 = f6 * f2;
        f3 *= f7;
        f6 = f4 * f8 + f5 * f9;
        f7 = f5 * f8 - f4 * f9;
        f8 = f4 * f2 + f5 * f3;
        f2 = f4 * f3 - f5 * f2;
        return quaternionf.set(Math.fma(this.w, f7, Math.fma(this.x, f6, Math.fma(this.y, f2, -this.z * f8))), Math.fma(this.w, f8, Math.fma(-this.x, f2, Math.fma(this.y, f6, this.z * f7))), Math.fma(this.w, f2, Math.fma(this.x, f8, Math.fma(-this.y, f7, this.z * f6))), Math.fma(this.w, f6, Math.fma(-this.x, f7, Math.fma(-this.y, f8, -this.z * f2))));
    }

    public Quaternionf rotateYXZ(float f2, float f3, float f4) {
        return this.rotateYXZ(f2, f3, f4, this);
    }

    public Quaternionf rotateYXZ(float f2, float f3, float f4, Quaternionf quaternionf) {
        float f5 = Math.sin(f3 * 0.5f);
        f3 = Math.cosFromSin(f5, f3 * 0.5f);
        float f6 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f6, f2 * 0.5f);
        float f7 = Math.sin(f4 * 0.5f);
        f4 = Math.cosFromSin(f7, f4 * 0.5f);
        float f8 = f2 * f5;
        float f9 = f6 * f3;
        f5 = f6 * f5;
        f2 *= f3;
        f3 = f8 * f4 + f9 * f7;
        f6 = f9 * f4 - f8 * f7;
        f8 = f2 * f7 - f5 * f4;
        f2 = f2 * f4 + f5 * f7;
        return quaternionf.set(Math.fma(this.w, f3, Math.fma(this.x, f2, Math.fma(this.y, f8, -this.z * f6))), Math.fma(this.w, f6, Math.fma(-this.x, f8, Math.fma(this.y, f2, this.z * f3))), Math.fma(this.w, f8, Math.fma(this.x, f6, Math.fma(-this.y, f3, this.z * f2))), Math.fma(this.w, f2, Math.fma(-this.x, f3, Math.fma(-this.y, f6, -this.z * f8))));
    }

    public Vector3f getEulerAnglesXYZ(Vector3f vector3f) {
        vector3f.x = Math.atan2(this.x * this.w - this.y * this.z, 0.5f - this.x * this.x - this.y * this.y);
        vector3f.y = Math.safeAsin(2.0f * (this.x * this.z + this.y * this.w));
        vector3f.z = Math.atan2(this.z * this.w - this.x * this.y, 0.5f - this.y * this.y - this.z * this.z);
        return vector3f;
    }

    public Vector3f getEulerAnglesZYX(Vector3f vector3f) {
        vector3f.x = Math.atan2(this.y * this.z + this.w * this.x, 0.5f - this.x * this.x - this.y * this.y);
        vector3f.y = Math.safeAsin(-2.0f * (this.x * this.z - this.w * this.y));
        vector3f.z = Math.atan2(this.x * this.y + this.w * this.z, 0.5f - this.y * this.y - this.z * this.z);
        return vector3f;
    }

    public Vector3f getEulerAnglesZXY(Vector3f vector3f) {
        vector3f.x = Math.safeAsin(2.0f * (this.w * this.x + this.y * this.z));
        vector3f.y = Math.atan2(this.w * this.y - this.x * this.z, 0.5f - this.y * this.y - this.x * this.x);
        vector3f.z = Math.atan2(this.w * this.z - this.x * this.y, 0.5f - this.z * this.z - this.x * this.x);
        return vector3f;
    }

    public Vector3f getEulerAnglesYXZ(Vector3f vector3f) {
        vector3f.x = Math.safeAsin(-2.0f * (this.y * this.z - this.w * this.x));
        vector3f.y = Math.atan2(this.x * this.z + this.y * this.w, 0.5f - this.y * this.y - this.x * this.x);
        vector3f.z = Math.atan2(this.y * this.x + this.w * this.z, 0.5f - this.x * this.x - this.z * this.z);
        return vector3f;
    }

    public float lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public Quaternionf rotationXYZ(float f2, float f3, float f4) {
        float f5 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f5, f2 * 0.5f);
        float f6 = Math.sin(f3 * 0.5f);
        f3 = Math.cosFromSin(f6, f3 * 0.5f);
        float f7 = Math.sin(f4 * 0.5f);
        f4 = Math.cosFromSin(f7, f4 * 0.5f);
        float f8 = f3 * f4;
        float f9 = f6 * f7;
        f4 = f6 * f4;
        this.w = f2 * f8 - f5 * f9;
        this.x = f5 * f8 + f2 * f9;
        this.y = f2 * f4 - f5 * (f3 *= f7);
        this.z = f2 * f3 + f5 * f4;
        return this;
    }

    public Quaternionf rotationZYX(float f2, float f3, float f4) {
        float f5 = Math.sin(f4 * 0.5f);
        f4 = Math.cosFromSin(f5, f4 * 0.5f);
        float f6 = Math.sin(f3 * 0.5f);
        f3 = Math.cosFromSin(f6, f3 * 0.5f);
        float f7 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f7, f2 * 0.5f);
        float f8 = f3 * f2;
        float f9 = f6 * f7;
        f2 = f6 * f2;
        this.w = f4 * f8 + f5 * f9;
        this.x = f5 * f8 - f4 * f9;
        this.y = f4 * f2 + f5 * (f3 *= f7);
        this.z = f4 * f3 - f5 * f2;
        return this;
    }

    public Quaternionf rotationYXZ(float f2, float f3, float f4) {
        float f5 = Math.sin(f3 * 0.5f);
        f3 = Math.cosFromSin(f5, f3 * 0.5f);
        float f6 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f6, f2 * 0.5f);
        float f7 = Math.sin(f4 * 0.5f);
        f4 = Math.cosFromSin(f7, f4 * 0.5f);
        float f8 = f2 * f5;
        float f9 = f6 * f3;
        f5 = f6 * f5;
        this.x = f8 * f4 + f9 * f7;
        this.y = f9 * f4 - f8 * f7;
        this.z = (f2 *= f3) * f7 - f5 * f4;
        this.w = f2 * f4 + f5 * f7;
        return this;
    }

    public Quaternionf slerp(Quaternionfc quaternionfc, float f2) {
        return this.slerp(quaternionfc, f2, this);
    }

    public Quaternionf slerp(Quaternionfc quaternionfc, float f2, Quaternionf quaternionf) {
        float f3 = Math.fma(this.x, quaternionfc.x(), Math.fma(this.y, quaternionfc.y(), Math.fma(this.z, quaternionfc.z(), this.w * quaternionfc.w())));
        float f4 = Math.abs(f3);
        if (1.0f - f4 > 1.0E-6f) {
            float f5 = f4;
            float f6 = 1.0f - f5 * f5;
            float f7 = Math.invsqrt(f6);
            f6 = Math.atan2(f6 * f7, f4);
            f4 = (float)(Math.sin((1.0 - (double)f2) * (double)f6) * (double)f7);
            f2 = Math.sin(f2 * f6) * f7;
        } else {
            f4 = 1.0f - f2;
        }
        f2 = f3 >= 0.0f ? f2 : -f2;
        quaternionf.x = Math.fma(f4, this.x, f2 * quaternionfc.x());
        quaternionf.y = Math.fma(f4, this.y, f2 * quaternionfc.y());
        quaternionf.z = Math.fma(f4, this.z, f2 * quaternionfc.z());
        quaternionf.w = Math.fma(f4, this.w, f2 * quaternionfc.w());
        return quaternionf;
    }

    public static Quaternionfc slerp(Quaternionf[] quaternionfArray, float[] fArray, Quaternionf quaternionf) {
        quaternionf.set(quaternionfArray[0]);
        float f2 = fArray[0];
        for (int i2 = 1; i2 < quaternionfArray.length; ++i2) {
            float f3 = f2;
            float f4 = fArray[i2];
            f3 = f4 / (f3 + f4);
            f2 += f4;
            quaternionf.slerp(quaternionfArray[i2], f3);
        }
        return quaternionf;
    }

    public Quaternionf scale(float f2) {
        return this.scale(f2, this);
    }

    public Quaternionf scale(float f2, Quaternionf quaternionf) {
        f2 = Math.sqrt(f2);
        quaternionf.x = f2 * this.x;
        quaternionf.y = f2 * this.y;
        quaternionf.z = f2 * this.z;
        quaternionf.w = f2 * this.w;
        return quaternionf;
    }

    public Quaternionf scaling(float f2) {
        f2 = Math.sqrt(f2);
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = f2;
        return this;
    }

    public Quaternionf integrate(float f2, float f3, float f4, float f5) {
        return this.integrate(f2, f3, f4, f5, this);
    }

    public Quaternionf integrate(float f2, float f3, float f4, float f5, Quaternionf quaternionf) {
        float f6;
        float f7;
        f3 = f2 * f3 * 0.5f;
        f4 = f2 * f4 * 0.5f;
        f2 = f2 * f5 * 0.5f;
        float f8 = f3;
        float f9 = f4;
        float f10 = f2;
        f5 = f8 * f8 + f9 * f9 + f10 * f10;
        if (f7 * f7 / 24.0f < 1.0E-8f) {
            f6 = 1.0f - f5 * 0.5f;
            f5 = 1.0f - f5 / 6.0f;
        } else {
            f6 = Math.sqrt(f5);
            float f11 = Math.sin(f6);
            f5 = f11 / f6;
            f6 = Math.cosFromSin(f11, f6);
        }
        return quaternionf.set(Math.fma(f6, this.x, Math.fma(f3 *= f5, this.w, Math.fma(f4 *= f5, this.z, -(f2 *= f5) * this.y))), Math.fma(f6, this.y, Math.fma(-f3, this.z, Math.fma(f4, this.w, f2 * this.x))), Math.fma(f6, this.z, Math.fma(f3, this.y, Math.fma(-f4, this.x, f2 * this.w))), Math.fma(f6, this.w, Math.fma(-f3, this.x, Math.fma(-f4, this.y, -f2 * this.z))));
    }

    public Quaternionf nlerp(Quaternionfc quaternionfc, float f2) {
        return this.nlerp(quaternionfc, f2, this);
    }

    public Quaternionf nlerp(Quaternionfc quaternionfc, float f2, Quaternionf quaternionf) {
        float f3 = Math.fma(this.x, quaternionfc.x(), Math.fma(this.y, quaternionfc.y(), Math.fma(this.z, quaternionfc.z(), this.w * quaternionfc.w())));
        float f4 = 1.0f - f2;
        f2 = f3 >= 0.0f ? f2 : -f2;
        quaternionf.x = Math.fma(f4, this.x, f2 * quaternionfc.x());
        quaternionf.y = Math.fma(f4, this.y, f2 * quaternionfc.y());
        quaternionf.z = Math.fma(f4, this.z, f2 * quaternionfc.z());
        quaternionf.w = Math.fma(f4, this.w, f2 * quaternionfc.w());
        float f5 = Math.invsqrt(Math.fma(quaternionf.x, quaternionf.x, Math.fma(quaternionf.y, quaternionf.y, Math.fma(quaternionf.z, quaternionf.z, quaternionf.w * quaternionf.w))));
        quaternionf.x *= f5;
        quaternionf.y *= f5;
        quaternionf.z *= f5;
        quaternionf.w *= f5;
        return quaternionf;
    }

    public static Quaternionfc nlerp(Quaternionfc[] quaternionfcArray, float[] fArray, Quaternionf quaternionf) {
        quaternionf.set(quaternionfcArray[0]);
        float f2 = fArray[0];
        for (int i2 = 1; i2 < quaternionfcArray.length; ++i2) {
            float f3 = f2;
            float f4 = fArray[i2];
            f3 = f4 / (f3 + f4);
            f2 += f4;
            quaternionf.nlerp(quaternionfcArray[i2], f3);
        }
        return quaternionf;
    }

    public Quaternionf nlerpIterative(Quaternionfc quaternionfc, float f2, float f3, Quaternionf quaternionf) {
        float f4;
        float f5;
        float f6;
        float f7 = this.x;
        float f8 = this.y;
        float f9 = this.z;
        float f10 = this.w;
        float f11 = quaternionfc.x();
        float f12 = Math.fma(f7, f11, Math.fma(f8, f6 = quaternionfc.y(), Math.fma(f9, f5 = quaternionfc.z(), f10 * (f4 = quaternionfc.w()))));
        float f13 = Math.abs(f12);
        if (0.999999f < f13) {
            return quaternionf.set(this);
        }
        while (f13 < f3) {
            float f14 = f12 = f12 >= 0.0f ? 0.5f : -0.5f;
            if (f2 < 0.5f) {
                f11 = Math.fma(0.5f, f11, f12 * f7);
                f6 = Math.fma(0.5f, f6, f12 * f8);
                f5 = Math.fma(0.5f, f5, f12 * f9);
                f4 = Math.fma(0.5f, f4, f12 * f10);
                float f15 = f11;
                float f16 = f6;
                float f17 = f5;
                float f18 = f4;
                f13 = Math.invsqrt(Math.fma(f15, f15, Math.fma(f16, f16, Math.fma(f17, f17, f18 * f18))));
                f11 *= f13;
                f6 *= f13;
                f5 *= f13;
                f4 *= f13;
                float f19 = f2;
                f2 = f19 + f19;
            } else {
                f7 = Math.fma(0.5f, f7, f12 * f11);
                f8 = Math.fma(0.5f, f8, f12 * f6);
                f9 = Math.fma(0.5f, f9, f12 * f5);
                f10 = Math.fma(0.5f, f10, f12 * f4);
                float f20 = f7;
                float f21 = f8;
                float f22 = f9;
                float f23 = f10;
                f13 = Math.invsqrt(Math.fma(f20, f20, Math.fma(f21, f21, Math.fma(f22, f22, f23 * f23))));
                f7 *= f13;
                f8 *= f13;
                f9 *= f13;
                f10 *= f13;
                float f24 = f2;
                f2 = f24 + f24 - 1.0f;
            }
            f12 = Math.fma(f7, f11, Math.fma(f8, f6, Math.fma(f9, f5, f10 * f4)));
            f13 = Math.abs(f12);
        }
        f3 = 1.0f - f2;
        f12 = f12 >= 0.0f ? f2 : -f2;
        f13 = Math.fma(f3, f7, f12 * f11);
        f2 = Math.fma(f3, f8, f12 * f6);
        f7 = Math.fma(f3, f9, f12 * f5);
        f4 = Math.fma(f3, f10, f12 * f4);
        float f25 = f13;
        float f26 = f2;
        float f27 = f7;
        float f28 = f4;
        f3 = Math.invsqrt(Math.fma(f25, f25, Math.fma(f26, f26, Math.fma(f27, f27, f28 * f28))));
        quaternionf.x = f13 * f3;
        quaternionf.y = f2 * f3;
        quaternionf.z = f7 * f3;
        quaternionf.w = f4 * f3;
        return quaternionf;
    }

    public Quaternionf nlerpIterative(Quaternionfc quaternionfc, float f2, float f3) {
        return this.nlerpIterative(quaternionfc, f2, f3, this);
    }

    public static Quaternionfc nlerpIterative(Quaternionf[] quaternionfArray, float[] fArray, float f2, Quaternionf quaternionf) {
        quaternionf.set(quaternionfArray[0]);
        float f3 = fArray[0];
        for (int i2 = 1; i2 < quaternionfArray.length; ++i2) {
            float f4 = f3;
            float f5 = fArray[i2];
            f4 = f5 / (f4 + f5);
            f3 += f5;
            quaternionf.nlerpIterative(quaternionfArray[i2], f4, f2);
        }
        return quaternionf;
    }

    public Quaternionf lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    public Quaternionf lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2, Quaternionf quaternionf) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), quaternionf);
    }

    public Quaternionf lookAlong(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.lookAlong(f2, f3, f4, f5, f6, f7, this);
    }

    public Quaternionf lookAlong(float f2, float f3, float f4, float f5, float f6, float f7, Quaternionf quaternionf) {
        float f8;
        double d2;
        float f9 = f2;
        float f10 = f3;
        float f11 = f4;
        float f12 = Math.invsqrt(f9 * f9 + f10 * f10 + f11 * f11);
        f2 = -f2 * f12;
        f3 = -f3 * f12;
        f4 = -f4 * f12;
        f12 = f6 * f4 - f7 * f3;
        f7 = f7 * f2 - f5 * f4;
        f5 = f5 * f3 - f6 * f2;
        float f13 = f12;
        float f14 = f7;
        float f15 = f5;
        f6 = Math.invsqrt(f13 * f13 + f14 * f14 + f15 * f15);
        f12 *= f6;
        f7 *= f6;
        f5 *= f6;
        f6 = f3 * f5 - f4 * f7;
        float f16 = f4 * f12 - f2 * f5;
        float f17 = f2 * f7 - f3 * f12;
        double d3 = f12 + f16 + f4;
        if (d2 >= 0.0) {
            double d4 = Math.sqrt(d3 + 1.0);
            f8 = (float)(d4 * 0.5);
            d4 = 0.5 / d4;
            f4 = (float)((double)(f3 - f17) * d4);
            f12 = (float)((double)(f5 - f2) * d4);
            f16 = (float)((double)(f6 - f7) * d4);
        } else if (f12 > f16 && f12 > f4) {
            double d5 = Math.sqrt(1.0 + (double)f12 - (double)f16 - (double)f4);
            f4 = (float)(d5 * 0.5);
            d5 = 0.5 / d5;
            f12 = (float)((double)(f7 + f6) * d5);
            f16 = (float)((double)(f2 + f5) * d5);
            f8 = (float)((double)(f3 - f17) * d5);
        } else if (f16 > f4) {
            double d6 = Math.sqrt(1.0 + (double)f16 - (double)f12 - (double)f4);
            f12 = (float)(d6 * 0.5);
            d6 = 0.5 / d6;
            f4 = (float)((double)(f7 + f6) * d6);
            f16 = (float)((double)(f17 + f3) * d6);
            f8 = (float)((double)(f5 - f2) * d6);
        } else {
            double d7 = Math.sqrt(1.0 + (double)f4 - (double)f12 - (double)f16);
            f16 = (float)(d7 * 0.5);
            d7 = 0.5 / d7;
            f4 = (float)((double)(f2 + f5) * d7);
            f12 = (float)((double)(f17 + f3) * d7);
            f8 = (float)((double)(f6 - f7) * d7);
        }
        return quaternionf.set(Math.fma(this.w, f4, Math.fma(this.x, f8, Math.fma(this.y, f16, -this.z * f12))), Math.fma(this.w, f12, Math.fma(-this.x, f16, Math.fma(this.y, f8, this.z * f4))), Math.fma(this.w, f16, Math.fma(this.x, f12, Math.fma(-this.y, f4, this.z * f8))), Math.fma(this.w, f8, Math.fma(-this.x, f4, Math.fma(-this.y, f12, -this.z * f16))));
    }

    public Quaternionf rotationTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8;
        float f9 = f2;
        float f10 = f3;
        float f11 = f4;
        float f12 = Math.invsqrt(Math.fma(f9, f9, Math.fma(f10, f10, f11 * f11)));
        float f13 = f5;
        float f14 = f6;
        float f15 = f7;
        float f16 = Math.invsqrt(Math.fma(f13, f13, Math.fma(f14, f14, f15 * f15)));
        f2 *= f12;
        f3 *= f12;
        f4 *= f12;
        f12 = f2 * (f5 *= f16) + f3 * (f6 *= f16) + f4 * (f7 *= f16);
        if (f8 < -0.999999f) {
            f5 = f3;
            f2 = -f2;
            f6 = 0.0f;
            float f17 = f3;
            float f18 = f2;
            if (f17 * f17 + f18 * f18 == 0.0f) {
                f5 = 0.0f;
                f2 = f4;
                f6 = -f3;
            }
            this.x = f5;
            this.y = f2;
            this.z = f6;
            this.w = 0.0f;
        } else {
            f12 = Math.sqrt((f12 + 1.0f) * 2.0f);
            f16 = 1.0f / f12;
            float f19 = f3 * f7 - f4 * f6;
            f4 = f4 * f5 - f2 * f7;
            f3 = f2 * f6 - f3 * f5;
            f5 = f19 * f16;
            f2 = f4 * f16;
            f6 = f3 * f16;
            f3 = f12 * 0.5f;
            float f20 = f5;
            float f21 = f2;
            float f22 = f6;
            float f23 = f3;
            f4 = Math.invsqrt(Math.fma(f20, f20, Math.fma(f21, f21, Math.fma(f22, f22, f23 * f23))));
            this.x = f5 * f4;
            this.y = f2 * f4;
            this.z = f6 * f4;
            this.w = f3 * f4;
        }
        return this;
    }

    public Quaternionf rotationTo(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotationTo(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Quaternionf rotateTo(float f2, float f3, float f4, float f5, float f6, float f7, Quaternionf quaternionf) {
        float f8;
        float f9 = f2;
        float f10 = f3;
        float f11 = f4;
        float f12 = Math.invsqrt(Math.fma(f9, f9, Math.fma(f10, f10, f11 * f11)));
        float f13 = f5;
        float f14 = f6;
        float f15 = f7;
        float f16 = Math.invsqrt(Math.fma(f13, f13, Math.fma(f14, f14, f15 * f15)));
        f2 *= f12;
        f3 *= f12;
        f4 *= f12;
        f12 = f2 * (f5 *= f16) + f3 * (f6 *= f16) + f4 * (f7 *= f16);
        if (f8 < -0.999999f) {
            f5 = f3;
            f2 = -f2;
            f6 = 0.0f;
            f7 = 0.0f;
            float f17 = f3;
            float f18 = f2;
            if (f17 * f17 + f18 * f18 == 0.0f) {
                f5 = 0.0f;
                f2 = f4;
                f6 = -f3;
                f7 = 0.0f;
            }
        } else {
            f12 = Math.sqrt((f12 + 1.0f) * 2.0f);
            f16 = 1.0f / f12;
            float f19 = f3 * f7 - f4 * f6;
            f4 = f4 * f5 - f2 * f7;
            f3 = f2 * f6 - f3 * f5;
            f5 = f19 * f16;
            f2 = f4 * f16;
            f6 = f3 * f16;
            f7 = f12 * 0.5f;
            float f20 = f5;
            float f21 = f2;
            float f22 = f6;
            float f23 = f7;
            f3 = Math.invsqrt(Math.fma(f20, f20, Math.fma(f21, f21, Math.fma(f22, f22, f23 * f23))));
            f5 *= f3;
            f2 *= f3;
            f6 *= f3;
            f7 *= f3;
        }
        return quaternionf.set(Math.fma(this.w, f5, Math.fma(this.x, f7, Math.fma(this.y, f6, -this.z * f2))), Math.fma(this.w, f2, Math.fma(-this.x, f6, Math.fma(this.y, f7, this.z * f5))), Math.fma(this.w, f6, Math.fma(this.x, f2, Math.fma(-this.y, f5, this.z * f7))), Math.fma(this.w, f7, Math.fma(-this.x, f5, Math.fma(-this.y, f2, -this.z * f6))));
    }

    public Quaternionf rotateTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.rotateTo(f2, f3, f4, f5, f6, f7, this);
    }

    public Quaternionf rotateTo(Vector3fc vector3fc, Vector3fc vector3fc2, Quaternionf quaternionf) {
        return this.rotateTo(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), quaternionf);
    }

    public Quaternionf rotateTo(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotateTo(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    public Quaternionf rotateX(float f2) {
        return this.rotateX(f2, this);
    }

    public Quaternionf rotateX(float f2, Quaternionf quaternionf) {
        float f3 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f3, f2 * 0.5f);
        return quaternionf.set(this.w * f3 + this.x * f2, this.y * f2 + this.z * f3, this.z * f2 - this.y * f3, this.w * f2 - this.x * f3);
    }

    public Quaternionf rotateY(float f2) {
        return this.rotateY(f2, this);
    }

    public Quaternionf rotateY(float f2, Quaternionf quaternionf) {
        float f3 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f3, f2 * 0.5f);
        return quaternionf.set(this.x * f2 - this.z * f3, this.w * f3 + this.y * f2, this.x * f3 + this.z * f2, this.w * f2 - this.y * f3);
    }

    public Quaternionf rotateZ(float f2) {
        return this.rotateZ(f2, this);
    }

    public Quaternionf rotateZ(float f2, Quaternionf quaternionf) {
        float f3 = Math.sin(f2 * 0.5f);
        f2 = Math.cosFromSin(f3, f2 * 0.5f);
        return quaternionf.set(this.x * f2 + this.y * f3, this.y * f2 - this.x * f3, this.w * f3 + this.z * f2, this.w * f2 - this.z * f3);
    }

    public Quaternionf rotateLocalX(float f2) {
        return this.rotateLocalX(f2, this);
    }

    public Quaternionf rotateLocalX(float f2, Quaternionf quaternionf) {
        float f3 = Math.sin(f2 *= 0.5f);
        f2 = Math.cosFromSin(f3, f2);
        quaternionf.set(f2 * this.x + f3 * this.w, f2 * this.y - f3 * this.z, f2 * this.z + f3 * this.y, f2 * this.w - f3 * this.x);
        return quaternionf;
    }

    public Quaternionf rotateLocalY(float f2) {
        return this.rotateLocalY(f2, this);
    }

    public Quaternionf rotateLocalY(float f2, Quaternionf quaternionf) {
        float f3 = Math.sin(f2 *= 0.5f);
        f2 = Math.cosFromSin(f3, f2);
        quaternionf.set(f2 * this.x + f3 * this.z, f2 * this.y + f3 * this.w, f2 * this.z - f3 * this.x, f2 * this.w - f3 * this.y);
        return quaternionf;
    }

    public Quaternionf rotateLocalZ(float f2) {
        return this.rotateLocalZ(f2, this);
    }

    public Quaternionf rotateLocalZ(float f2, Quaternionf quaternionf) {
        float f3 = Math.sin(f2 *= 0.5f);
        f2 = Math.cosFromSin(f3, f2);
        quaternionf.set(f2 * this.x - f3 * this.y, f2 * this.y + f3 * this.x, f2 * this.z + f3 * this.w, f2 * this.w - f3 * this.z);
        return quaternionf;
    }

    public Quaternionf rotateAxis(float f2, float f3, float f4, float f5, Quaternionf quaternionf) {
        float f6 = Math.sin(f2 /= 2.0f);
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        float f10 = Math.invsqrt(Math.fma(f7, f7, Math.fma(f8, f8, f9 * f9)));
        f3 = f3 * f10 * f6;
        f4 = f4 * f10 * f6;
        f5 = f5 * f10 * f6;
        f2 = Math.cosFromSin(f6, f2);
        return quaternionf.set(Math.fma(this.w, f3, Math.fma(this.x, f2, Math.fma(this.y, f5, -this.z * f4))), Math.fma(this.w, f4, Math.fma(-this.x, f5, Math.fma(this.y, f2, this.z * f3))), Math.fma(this.w, f5, Math.fma(this.x, f4, Math.fma(-this.y, f3, this.z * f2))), Math.fma(this.w, f2, Math.fma(-this.x, f3, Math.fma(-this.y, f4, -this.z * f5))));
    }

    public Quaternionf rotateAxis(float f2, Vector3fc vector3fc, Quaternionf quaternionf) {
        return this.rotateAxis(f2, vector3fc.x(), vector3fc.y(), vector3fc.z(), quaternionf);
    }

    public Quaternionf rotateAxis(float f2, Vector3fc vector3fc) {
        return this.rotateAxis(f2, vector3fc.x(), vector3fc.y(), vector3fc.z(), this);
    }

    public Quaternionf rotateAxis(float f2, float f3, float f4, float f5) {
        return this.rotateAxis(f2, f3, f4, f5, this);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " " + Runtime.format(this.w, numberFormat) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
        objectOutput.writeFloat(this.w);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readFloat();
        this.y = objectInput.readFloat();
        this.z = objectInput.readFloat();
        this.w = objectInput.readFloat();
    }

    public int hashCode() {
        return (((31 + Float.floatToIntBits(this.w)) * 31 + Float.floatToIntBits(this.x)) * 31 + Float.floatToIntBits(this.y)) * 31 + Float.floatToIntBits(this.z);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Quaternionf)object;
        if (Float.floatToIntBits(this.w) != Float.floatToIntBits(((Quaternionf)object).w)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(((Quaternionf)object).x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(((Quaternionf)object).y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(((Quaternionf)object).z);
    }

    public Quaternionf difference(Quaternionf quaternionf) {
        return this.difference(quaternionf, this);
    }

    public Quaternionf difference(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        float f2 = 1.0f / this.lengthSquared();
        float f3 = -this.x * f2;
        float f4 = -this.y * f2;
        float f5 = -this.z * f2;
        f2 = this.w * f2;
        quaternionf.set(Math.fma(f2, quaternionfc.x(), Math.fma(f3, quaternionfc.w(), Math.fma(f4, quaternionfc.z(), -f5 * quaternionfc.y()))), Math.fma(f2, quaternionfc.y(), Math.fma(-f3, quaternionfc.z(), Math.fma(f4, quaternionfc.w(), f5 * quaternionfc.x()))), Math.fma(f2, quaternionfc.z(), Math.fma(f3, quaternionfc.y(), Math.fma(-f4, quaternionfc.x(), f5 * quaternionfc.w()))), Math.fma(f2, quaternionfc.w(), Math.fma(-f3, quaternionfc.x(), Math.fma(-f4, quaternionfc.y(), -f5 * quaternionfc.z()))));
        return quaternionf;
    }

    public Vector3f positiveX(Vector3f vector3f) {
        float f2 = 1.0f / this.lengthSquared();
        float f3 = -this.x * f2;
        float f4 = -this.y * f2;
        float f5 = -this.z * f2;
        f2 = this.w * f2;
        float f6 = f4;
        float f7 = f6 + f6;
        float f8 = f5;
        float f9 = f8 + f8;
        vector3f.x = -f4 * f7 - f5 * f9 + 1.0f;
        vector3f.y = f3 * f7 + f2 * f9;
        vector3f.z = f3 * f9 - f2 * f7;
        return vector3f;
    }

    public Vector3f normalizedPositiveX(Vector3f vector3f) {
        float f2 = this.y + this.y;
        float f3 = this.z + this.z;
        vector3f.x = -this.y * f2 - this.z * f3 + 1.0f;
        vector3f.y = this.x * f2 - this.w * f3;
        vector3f.z = this.x * f3 + this.w * f2;
        return vector3f;
    }

    public Vector3f positiveY(Vector3f vector3f) {
        float f2 = 1.0f / this.lengthSquared();
        float f3 = -this.x * f2;
        float f4 = -this.y * f2;
        float f5 = -this.z * f2;
        f2 = this.w * f2;
        float f6 = f3;
        float f7 = f6 + f6;
        float f8 = f4;
        float f9 = f8 + f8;
        float f10 = f5;
        float f11 = f10 + f10;
        vector3f.x = f3 * f9 - f2 * f11;
        vector3f.y = -f3 * f7 - f5 * f11 + 1.0f;
        vector3f.z = f4 * f11 + f2 * f7;
        return vector3f;
    }

    public Vector3f normalizedPositiveY(Vector3f vector3f) {
        float f2 = this.x + this.x;
        float f3 = this.y + this.y;
        float f4 = this.z + this.z;
        vector3f.x = this.x * f3 + this.w * f4;
        vector3f.y = -this.x * f2 - this.z * f4 + 1.0f;
        vector3f.z = this.y * f4 - this.w * f2;
        return vector3f;
    }

    public Vector3f positiveZ(Vector3f vector3f) {
        float f2 = 1.0f / this.lengthSquared();
        float f3 = -this.x * f2;
        float f4 = -this.y * f2;
        float f5 = -this.z * f2;
        f2 = this.w * f2;
        float f6 = f3;
        float f7 = f6 + f6;
        float f8 = f4;
        float f9 = f8 + f8;
        float f10 = f5;
        f5 = f10 + f10;
        vector3f.x = f3 * f5 + f2 * f9;
        vector3f.y = f4 * f5 - f2 * f7;
        vector3f.z = -f3 * f7 - f4 * f9 + 1.0f;
        return vector3f;
    }

    public Vector3f normalizedPositiveZ(Vector3f vector3f) {
        float f2 = this.x + this.x;
        float f3 = this.y + this.y;
        float f4 = this.z + this.z;
        vector3f.x = this.x * f4 - this.w * f3;
        vector3f.y = this.y * f4 + this.w * f2;
        vector3f.z = -this.x * f2 - this.y * f3 + 1.0f;
        return vector3f;
    }

    public Quaternionf conjugateBy(Quaternionfc quaternionfc) {
        return this.conjugateBy(quaternionfc, this);
    }

    public Quaternionf conjugateBy(Quaternionfc quaternionfc, Quaternionf quaternionf) {
        float f2 = 1.0f / quaternionfc.lengthSquared();
        float f3 = -quaternionfc.x() * f2;
        float f4 = -quaternionfc.y() * f2;
        float f5 = -quaternionfc.z() * f2;
        f2 = quaternionfc.w() * f2;
        float f6 = Math.fma(quaternionfc.w(), this.x, Math.fma(quaternionfc.x(), this.w, Math.fma(quaternionfc.y(), this.z, -quaternionfc.z() * this.y)));
        float f7 = Math.fma(quaternionfc.w(), this.y, Math.fma(-quaternionfc.x(), this.z, Math.fma(quaternionfc.y(), this.w, quaternionfc.z() * this.x)));
        float f8 = Math.fma(quaternionfc.w(), this.z, Math.fma(quaternionfc.x(), this.y, Math.fma(-quaternionfc.y(), this.x, quaternionfc.z() * this.w)));
        float f9 = Math.fma(quaternionfc.w(), this.w, Math.fma(-quaternionfc.x(), this.x, Math.fma(-quaternionfc.y(), this.y, -quaternionfc.z() * this.z)));
        return quaternionf.set(Math.fma(f9, f3, Math.fma(f6, f2, Math.fma(f7, f5, -f8 * f4))), Math.fma(f9, f4, Math.fma(-f6, f5, Math.fma(f7, f2, f8 * f3))), Math.fma(f9, f5, Math.fma(f6, f4, Math.fma(-f7, f3, f8 * f2))), Math.fma(f9, f2, Math.fma(-f6, f3, Math.fma(-f7, f4, -f8 * f5))));
    }

    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }

    public boolean equals(Quaternionfc quaternionfc, float f2) {
        if (this == quaternionfc) {
            return true;
        }
        if (quaternionfc == null) {
            return false;
        }
        if (this.getClass() != quaternionfc.getClass()) {
            return false;
        }
        if (!Runtime.equals(this.x, quaternionfc.x(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.y, quaternionfc.y(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.z, quaternionfc.z(), f2)) {
            return false;
        }
        return Runtime.equals(this.w, quaternionfc.w(), f2);
    }

    public boolean equals(float f2, float f3, float f4, float f5) {
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(f2)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(f3)) {
            return false;
        }
        if (Float.floatToIntBits(this.z) != Float.floatToIntBits(f4)) {
            return false;
        }
        return Float.floatToIntBits(this.w) == Float.floatToIntBits(f5);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

