/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.Options;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class Quaterniond
implements Externalizable,
Cloneable,
Quaterniondc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Quaterniond() {
        this.w = 1.0;
    }

    public Quaterniond(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
    }

    public Quaterniond(Quaterniondc quaterniondc) {
        this.x = quaterniondc.x();
        this.y = quaterniondc.y();
        this.z = quaterniondc.z();
        this.w = quaterniondc.w();
    }

    public Quaterniond(Quaternionfc quaternionfc) {
        this.x = quaternionfc.x();
        this.y = quaternionfc.y();
        this.z = quaternionfc.z();
        this.w = quaternionfc.w();
    }

    public Quaterniond(AxisAngle4f axisAngle4f) {
        double d2 = Math.sin((double)axisAngle4f.angle * 0.5);
        this.x = (double)axisAngle4f.x * d2;
        this.y = (double)axisAngle4f.y * d2;
        this.z = (double)axisAngle4f.z * d2;
        this.w = Math.cosFromSin(d2, (double)axisAngle4f.angle * 0.5);
    }

    public Quaterniond(AxisAngle4d axisAngle4d) {
        double d2 = Math.sin(axisAngle4d.angle * 0.5);
        this.x = axisAngle4d.x * d2;
        this.y = axisAngle4d.y * d2;
        this.z = axisAngle4d.z * d2;
        this.w = Math.cosFromSin(d2, axisAngle4d.angle * 0.5);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double w() {
        return this.w;
    }

    public Quaterniond normalize() {
        double d2 = Math.invsqrt(this.lengthSquared());
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        this.w *= d2;
        return this;
    }

    public Quaterniond normalize(Quaterniond quaterniond) {
        double d2 = Math.invsqrt(this.lengthSquared());
        quaterniond.x = this.x * d2;
        quaterniond.y = this.y * d2;
        quaterniond.z = this.z * d2;
        quaterniond.w = this.w * d2;
        return quaterniond;
    }

    public Quaterniond add(double d2, double d3, double d4, double d5) {
        return this.add(d2, d3, d4, d5, this);
    }

    public Quaterniond add(double d2, double d3, double d4, double d5, Quaterniond quaterniond) {
        quaterniond.x = this.x + d2;
        quaterniond.y = this.y + d3;
        quaterniond.z = this.z + d4;
        quaterniond.w = this.w + d5;
        return quaterniond;
    }

    public Quaterniond add(Quaterniondc quaterniondc) {
        return this.add(quaterniondc, this);
    }

    public Quaterniond add(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        quaterniond.x = this.x + quaterniondc.x();
        quaterniond.y = this.y + quaterniondc.y();
        quaterniond.z = this.z + quaterniondc.z();
        quaterniond.w = this.w + quaterniondc.w();
        return quaterniond;
    }

    public Quaterniond sub(double d2, double d3, double d4, double d5) {
        return this.sub(d2, d3, d4, d5, this);
    }

    public Quaterniond sub(double d2, double d3, double d4, double d5, Quaterniond quaterniond) {
        quaterniond.x = this.x - d2;
        quaterniond.y = this.y - d3;
        quaterniond.z = this.z - d4;
        quaterniond.w = this.w - d5;
        return quaterniond;
    }

    public Quaterniond sub(Quaterniondc quaterniondc) {
        return this.sub(quaterniondc, this);
    }

    public Quaterniond sub(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        quaterniond.x = this.x - quaterniondc.x();
        quaterniond.y = this.y - quaterniondc.y();
        quaterniond.z = this.z - quaterniondc.z();
        quaterniond.w = this.w - quaterniondc.w();
        return quaterniond;
    }

    public double dot(Quaterniondc quaterniondc) {
        return this.x * quaterniondc.x() + this.y * quaterniondc.y() + this.z * quaterniondc.z() + this.w * quaterniondc.w();
    }

    public double angle() {
        return 2.0 * Math.safeAcos(this.w);
    }

    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set(this);
    }

    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    public AxisAngle4f get(AxisAngle4f axisAngle4f) {
        double d2;
        double d3;
        double d4;
        double d5 = this.x;
        double d6 = this.y;
        double d7 = this.z;
        double d8 = this.w;
        if (d4 > 1.0) {
            d3 = Math.invsqrt(this.lengthSquared());
            d5 *= d3;
            d6 *= d3;
            d7 *= d3;
            d8 *= d3;
        }
        axisAngle4f.angle = (float)(2.0 * Math.acos(d8));
        double d9 = d8;
        d3 = Math.sqrt(1.0 - d9 * d9);
        if (d2 < 0.001) {
            axisAngle4f.x = (float)d5;
            axisAngle4f.y = (float)d6;
            axisAngle4f.z = (float)d7;
        } else {
            d3 = 1.0 / d3;
            axisAngle4f.x = (float)(d5 * d3);
            axisAngle4f.y = (float)(d6 * d3);
            axisAngle4f.z = (float)(d7 * d3);
        }
        return axisAngle4f;
    }

    public AxisAngle4d get(AxisAngle4d axisAngle4d) {
        double d2;
        double d3;
        double d4;
        double d5 = this.x;
        double d6 = this.y;
        double d7 = this.z;
        double d8 = this.w;
        if (d4 > 1.0) {
            d3 = Math.invsqrt(this.lengthSquared());
            d5 *= d3;
            d6 *= d3;
            d7 *= d3;
            d8 *= d3;
        }
        axisAngle4d.angle = 2.0 * Math.acos(d8);
        double d9 = d8;
        d3 = Math.sqrt(1.0 - d9 * d9);
        if (d2 < 0.001) {
            axisAngle4d.x = d5;
            axisAngle4d.y = d6;
            axisAngle4d.z = d7;
        } else {
            d3 = 1.0 / d3;
            axisAngle4d.x = d5 * d3;
            axisAngle4d.y = d6 * d3;
            axisAngle4d.z = d7 * d3;
        }
        return axisAngle4d;
    }

    public Quaterniond get(Quaterniond quaterniond) {
        return quaterniond.set(this);
    }

    public Quaternionf get(Quaternionf quaternionf) {
        return quaternionf.set(this);
    }

    public Quaterniond set(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
        return this;
    }

    public Quaterniond set(Quaterniondc quaterniondc) {
        this.x = quaterniondc.x();
        this.y = quaterniondc.y();
        this.z = quaterniondc.z();
        this.w = quaterniondc.w();
        return this;
    }

    public Quaterniond set(Quaternionfc quaternionfc) {
        this.x = quaternionfc.x();
        this.y = quaternionfc.y();
        this.z = quaternionfc.z();
        this.w = quaternionfc.w();
        return this;
    }

    public Quaterniond set(AxisAngle4f axisAngle4f) {
        return this.setAngleAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaterniond set(AxisAngle4d axisAngle4d) {
        return this.setAngleAxis(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Quaterniond setAngleAxis(double d2, double d3, double d4, double d5) {
        double d6 = Math.sin(d2 * 0.5);
        this.x = d3 * d6;
        this.y = d4 * d6;
        this.z = d5 * d6;
        this.w = Math.cosFromSin(d6, d2 * 0.5);
        return this;
    }

    public Quaterniond setAngleAxis(double d2, Vector3dc vector3dc) {
        return this.setAngleAxis(d2, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    private void setFromUnnormalized(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d2;
        double d12 = d3;
        double d13 = d4;
        double d14 = Math.invsqrt(d11 * d11 + d12 * d12 + d13 * d13);
        double d15 = d5;
        double d16 = d6;
        double d17 = d7;
        double d18 = Math.invsqrt(d15 * d15 + d16 * d16 + d17 * d17);
        double d19 = d8;
        double d20 = d9;
        double d21 = d10;
        double d22 = Math.invsqrt(d19 * d19 + d20 * d20 + d21 * d21);
        double d23 = d2 * d14;
        double d24 = d3 * d14;
        double d25 = d4 * d14;
        double d26 = d5 * d18;
        double d27 = d6 * d18;
        double d28 = d7 * d18;
        double d29 = d8 * d22;
        double d30 = d9 * d22;
        double d31 = d10 * d22;
        this.setFromNormalized(d23, d24, d25, d26, d27, d28, d29, d30, d31);
    }

    private void setFromNormalized(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11;
        double d12 = d2 + d6 + d10;
        if (d11 >= 0.0) {
            double d13 = Math.sqrt(d12 + 1.0);
            this.w = d13 * 0.5;
            d13 = 0.5 / d13;
            this.x = (d7 - d9) * d13;
            this.y = (d8 - d4) * d13;
            this.z = (d3 - d5) * d13;
            return;
        }
        if (d2 >= d6 && d2 >= d10) {
            double d14 = Math.sqrt(d2 - (d6 + d10) + 1.0);
            this.x = d14 * 0.5;
            d14 = 0.5 / d14;
            this.y = (d5 + d3) * d14;
            this.z = (d4 + d8) * d14;
            this.w = (d7 - d9) * d14;
            return;
        }
        if (d6 > d10) {
            double d15 = Math.sqrt(d6 - (d10 + d2) + 1.0);
            this.y = d15 * 0.5;
            d15 = 0.5 / d15;
            this.z = (d9 + d7) * d15;
            this.x = (d5 + d3) * d15;
            this.w = (d8 - d4) * d15;
            return;
        }
        double d16 = Math.sqrt(d10 - (d2 + d6) + 1.0);
        this.z = d16 * 0.5;
        d16 = 0.5 / d16;
        this.x = (d4 + d8) * d16;
        this.y = (d9 + d7) * d16;
        this.w = (d3 - d5) * d16;
    }

    public Quaterniond setFromUnnormalized(Matrix4fc matrix4fc) {
        this.setFromUnnormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromUnnormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromUnnormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4fc matrix4fc) {
        this.setFromNormalized(matrix4fc.m00(), matrix4fc.m01(), matrix4fc.m02(), matrix4fc.m10(), matrix4fc.m11(), matrix4fc.m12(), matrix4fc.m20(), matrix4fc.m21(), matrix4fc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4x3fc matrix4x3fc) {
        this.setFromNormalized(matrix4x3fc.m00(), matrix4x3fc.m01(), matrix4x3fc.m02(), matrix4x3fc.m10(), matrix4x3fc.m11(), matrix4x3fc.m12(), matrix4x3fc.m20(), matrix4x3fc.m21(), matrix4x3fc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4x3dc matrix4x3dc) {
        this.setFromNormalized(matrix4x3dc.m00(), matrix4x3dc.m01(), matrix4x3dc.m02(), matrix4x3dc.m10(), matrix4x3dc.m11(), matrix4x3dc.m12(), matrix4x3dc.m20(), matrix4x3dc.m21(), matrix4x3dc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix4dc matrix4dc) {
        this.setFromUnnormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix4dc matrix4dc) {
        this.setFromNormalized(matrix4dc.m00(), matrix4dc.m01(), matrix4dc.m02(), matrix4dc.m10(), matrix4dc.m11(), matrix4dc.m12(), matrix4dc.m20(), matrix4dc.m21(), matrix4dc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix3fc matrix3fc) {
        this.setFromUnnormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix3fc matrix3fc) {
        this.setFromNormalized(matrix3fc.m00(), matrix3fc.m01(), matrix3fc.m02(), matrix3fc.m10(), matrix3fc.m11(), matrix3fc.m12(), matrix3fc.m20(), matrix3fc.m21(), matrix3fc.m22());
        return this;
    }

    public Quaterniond setFromUnnormalized(Matrix3dc matrix3dc) {
        this.setFromUnnormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaterniond setFromNormalized(Matrix3dc matrix3dc) {
        this.setFromNormalized(matrix3dc.m00(), matrix3dc.m01(), matrix3dc.m02(), matrix3dc.m10(), matrix3dc.m11(), matrix3dc.m12(), matrix3dc.m20(), matrix3dc.m21(), matrix3dc.m22());
        return this;
    }

    public Quaterniond fromAxisAngleRad(Vector3dc vector3dc, double d2) {
        return this.fromAxisAngleRad(vector3dc.x(), vector3dc.y(), vector3dc.z(), d2);
    }

    public Quaterniond fromAxisAngleRad(double d2, double d3, double d4, double d5) {
        double d6 = d5 / 2.0;
        double d7 = Math.sin(d6);
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = 1.0 / Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10) * d7;
        this.x = d2 * d11;
        this.y = d3 * d11;
        this.z = d4 * d11;
        this.w = Math.cosFromSin(d7, d6);
        return this;
    }

    public Quaterniond fromAxisAngleDeg(Vector3dc vector3dc, double d2) {
        return this.fromAxisAngleRad(vector3dc.x(), vector3dc.y(), vector3dc.z(), Math.toRadians(d2));
    }

    public Quaterniond fromAxisAngleDeg(double d2, double d3, double d4, double d5) {
        return this.fromAxisAngleRad(d2, d3, d4, Math.toRadians(d5));
    }

    public Quaterniond mul(Quaterniondc quaterniondc) {
        return this.mul(quaterniondc, this);
    }

    public Quaterniond mul(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        return this.mul(quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w(), quaterniond);
    }

    public Quaterniond mul(double d2, double d3, double d4, double d5) {
        return this.mul(d2, d3, d4, d5, this);
    }

    public Quaterniond mul(double d2, double d3, double d4, double d5, Quaterniond quaterniond) {
        return quaterniond.set(Math.fma(this.w, d2, Math.fma(this.x, d5, Math.fma(this.y, d4, -this.z * d3))), Math.fma(this.w, d3, Math.fma(-this.x, d4, Math.fma(this.y, d5, this.z * d2))), Math.fma(this.w, d4, Math.fma(this.x, d3, Math.fma(-this.y, d2, this.z * d5))), Math.fma(this.w, d5, Math.fma(-this.x, d2, Math.fma(-this.y, d3, -this.z * d4))));
    }

    public Quaterniond mul(double d2) {
        return this.mul(d2, this);
    }

    public Quaterniond mul(double d2, Quaterniond quaterniond) {
        quaterniond.x = this.x * d2;
        quaterniond.y = this.y * d2;
        quaterniond.z = this.z * d2;
        quaterniond.w = this.w * d2;
        return quaterniond;
    }

    public Quaterniond premul(Quaterniondc quaterniondc) {
        return this.premul(quaterniondc, this);
    }

    public Quaterniond premul(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        return this.premul(quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w(), quaterniond);
    }

    public Quaterniond premul(double d2, double d3, double d4, double d5) {
        return this.premul(d2, d3, d4, d5, this);
    }

    public Quaterniond premul(double d2, double d3, double d4, double d5, Quaterniond quaterniond) {
        return quaterniond.set(Math.fma(d5, this.x, Math.fma(d2, this.w, Math.fma(d3, this.z, -d4 * this.y))), Math.fma(d5, this.y, Math.fma(-d2, this.z, Math.fma(d3, this.w, d4 * this.x))), Math.fma(d5, this.z, Math.fma(d2, this.y, Math.fma(-d3, this.x, d4 * this.w))), Math.fma(d5, this.w, Math.fma(-d2, this.x, Math.fma(-d3, this.y, -d4 * this.z))));
    }

    public Vector3d transform(Vector3d vector3d) {
        return this.transform(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector3d transformInverse(Vector3d vector3d) {
        return this.transformInverse(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector3d transformUnit(Vector3d vector3d) {
        return this.transformUnit(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector3d transformInverseUnit(Vector3d vector3d) {
        return this.transformInverseUnit(vector3d.x, vector3d.y, vector3d.z, vector3d);
    }

    public Vector3d transformPositiveX(Vector3d vector3d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.x * this.z;
        double d9 = this.y * this.w;
        vector3d.x = d2 + d3 - d5 - d4;
        vector3d.y = d7 + d6 + d6 + d7;
        vector3d.z = d8 - d9 + d8 - d9;
        return vector3d;
    }

    public Vector4d transformPositiveX(Vector4d vector4d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.x * this.z;
        double d9 = this.y * this.w;
        vector4d.x = d2 + d3 - d5 - d4;
        vector4d.y = d7 + d6 + d6 + d7;
        vector4d.z = d8 - d9 + d8 - d9;
        return vector4d;
    }

    public Vector3d transformUnitPositiveX(Vector3d vector3d) {
        double d2 = this.y * this.y;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.z * this.w;
        vector3d.x = 1.0 - d2 - d2 - d3 - d3;
        vector3d.y = d4 + d7 + d4 + d7;
        vector3d.z = d5 - d6 + d5 - d6;
        return vector3d;
    }

    public Vector4d transformUnitPositiveX(Vector4d vector4d) {
        double d2 = this.y * this.y;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.z * this.w;
        vector4d.x = 1.0 - d2 - d2 - d3 - d3;
        vector4d.y = d4 + d7 + d4 + d7;
        vector4d.z = d5 - d6 + d5 - d6;
        return vector4d;
    }

    public Vector3d transformPositiveY(Vector3d vector3d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector3d.x = -d6 + d7 - d6 + d7;
        vector3d.y = d4 - d5 + d2 - d3;
        double d10 = d8;
        vector3d.z = d10 + d10 + d9 + d9;
        return vector3d;
    }

    public Vector4d transformPositiveY(Vector4d vector4d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector4d.x = -d6 + d7 - d6 + d7;
        vector4d.y = d4 - d5 + d2 - d3;
        double d10 = d8;
        vector4d.z = d10 + d10 + d9 + d9;
        return vector4d;
    }

    public Vector4d transformUnitPositiveY(Vector4d vector4d) {
        double d2 = this.x * this.x;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.z * this.w;
        vector4d.x = d4 - d7 + d4 - d7;
        vector4d.y = 1.0 - d2 - d2 - d3 - d3;
        double d8 = d5;
        vector4d.z = d8 + d8 + d6 + d6;
        return vector4d;
    }

    public Vector3d transformUnitPositiveY(Vector3d vector3d) {
        double d2 = this.x * this.x;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.z * this.w;
        vector3d.x = d4 - d7 + d4 - d7;
        vector3d.y = 1.0 - d2 - d2 - d3 - d3;
        double d8 = d5;
        vector3d.z = d8 + d8 + d6 + d6;
        return vector3d;
    }

    public Vector3d transformPositiveZ(Vector3d vector3d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.x * this.z;
        double d7 = this.y * this.w;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector3d.x = d7 + d6 + d6 + d7;
        double d10 = d8;
        vector3d.y = d10 + d10 - d9 - d9;
        vector3d.z = d5 - d4 - d3 + d2;
        return vector3d;
    }

    public Vector4d transformPositiveZ(Vector4d vector4d) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.x * this.z;
        double d7 = this.y * this.w;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector4d.x = d7 + d6 + d6 + d7;
        double d10 = d8;
        vector4d.y = d10 + d10 - d9 - d9;
        vector4d.z = d5 - d4 - d3 + d2;
        return vector4d;
    }

    public Vector4d transformUnitPositiveZ(Vector4d vector4d) {
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.y * this.w;
        vector4d.x = d4 + d7 + d4 + d7;
        double d8 = d5;
        vector4d.y = d8 + d8 - d6 - d6;
        vector4d.z = 1.0 - d2 - d2 - d3 - d3;
        return vector4d;
    }

    public Vector3d transformUnitPositiveZ(Vector3d vector3d) {
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.y * this.w;
        vector3d.x = d4 + d7 + d4 + d7;
        double d8 = d5;
        vector3d.y = d8 + d8 - d6 - d6;
        vector3d.z = 1.0 - d2 - d2 - d3 - d3;
        return vector3d;
    }

    public Vector4d transform(Vector4d vector4d) {
        Vector4d vector4d2 = vector4d;
        return this.transform(vector4d2, vector4d2);
    }

    public Vector4d transformInverse(Vector4d vector4d) {
        Vector4d vector4d2 = vector4d;
        return this.transformInverse(vector4d2, vector4d2);
    }

    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transform(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformInverse(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverse(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transform(double d2, double d3, double d4, Vector3d vector3d) {
        double d5 = this.x * this.x;
        double d6 = this.y * this.y;
        double d7 = this.z * this.z;
        double d8 = this.w * this.w;
        double d9 = this.x * this.y;
        double d10 = this.x * this.z;
        double d11 = this.y * this.z;
        double d12 = this.x * this.w;
        double d13 = this.z * this.w;
        double d14 = this.y * this.w;
        double d15 = 1.0 / (d5 + d6 + d7 + d8);
        return vector3d.set(Math.fma((d5 - d6 - d7 + d8) * d15, d2, Math.fma(2.0 * (d9 - d13) * d15, d3, 2.0 * (d10 + d14) * d15 * d4)), Math.fma(2.0 * (d9 + d13) * d15, d2, Math.fma((d6 - d5 - d7 + d8) * d15, d3, 2.0 * (d11 - d12) * d15 * d4)), Math.fma(2.0 * (d10 - d14) * d15, d2, Math.fma(2.0 * (d11 + d12) * d15, d3, (d7 - d5 - d6 + d8) * d15 * d4)));
    }

    public Vector3d transformInverse(double d2, double d3, double d4, Vector3d vector3d) {
        double d5 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d6 = this.x * d5;
        double d7 = this.y * d5;
        double d8 = this.z * d5;
        double d9 = this.w * d5;
        double d10 = d6;
        double d11 = d10 * d10;
        double d12 = d7;
        double d13 = d12 * d12;
        double d14 = d8;
        double d15 = d14 * d14;
        double d16 = d9;
        double d17 = d16 * d16;
        double d18 = d6 * d7;
        double d19 = d6 * d8;
        double d20 = d7 * d8;
        double d21 = d6 * d9;
        double d22 = d8 * d9;
        double d23 = d7 * d9;
        double d24 = 1.0 / (d11 + d13 + d15 + d17);
        return vector3d.set(Math.fma((d11 - d13 - d15 + d17) * d24, d2, Math.fma(2.0 * (d18 + d22) * d24, d3, 2.0 * (d19 - d23) * d24 * d4)), Math.fma(2.0 * (d18 - d22) * d24, d2, Math.fma((d13 - d11 - d15 + d17) * d24, d3, 2.0 * (d20 + d21) * d24 * d4)), Math.fma(2.0 * (d19 + d23) * d24, d2, Math.fma(2.0 * (d20 - d21) * d24, d3, (d15 - d11 - d13 + d17) * d24 * d4)));
    }

    public Vector4d transform(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transform(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformInverse(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverse(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transform(double d2, double d3, double d4, Vector4d vector4d) {
        double d5 = this.x * this.x;
        double d6 = this.y * this.y;
        double d7 = this.z * this.z;
        double d8 = this.w * this.w;
        double d9 = this.x * this.y;
        double d10 = this.x * this.z;
        double d11 = this.y * this.z;
        double d12 = this.x * this.w;
        double d13 = this.z * this.w;
        double d14 = this.y * this.w;
        double d15 = 1.0 / (d5 + d6 + d7 + d8);
        return vector4d.set(Math.fma((d5 - d6 - d7 + d8) * d15, d2, Math.fma(2.0 * (d9 - d13) * d15, d3, 2.0 * (d10 + d14) * d15 * d4)), Math.fma(2.0 * (d9 + d13) * d15, d2, Math.fma((d6 - d5 - d7 + d8) * d15, d3, 2.0 * (d11 - d12) * d15 * d4)), Math.fma(2.0 * (d10 - d14) * d15, d2, Math.fma(2.0 * (d11 + d12) * d15, d3, (d7 - d5 - d6 + d8) * d15 * d4)), vector4d.w);
    }

    public Vector4d transformInverse(double d2, double d3, double d4, Vector4d vector4d) {
        double d5 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d6 = this.x * d5;
        double d7 = this.y * d5;
        double d8 = this.z * d5;
        double d9 = this.w * d5;
        double d10 = d6;
        double d11 = d10 * d10;
        double d12 = d7;
        double d13 = d12 * d12;
        double d14 = d8;
        double d15 = d14 * d14;
        double d16 = d9;
        double d17 = d16 * d16;
        double d18 = d6 * d7;
        double d19 = d6 * d8;
        double d20 = d7 * d8;
        double d21 = d6 * d9;
        double d22 = d8 * d9;
        double d23 = d7 * d9;
        double d24 = 1.0 / (d11 + d13 + d15 + d17);
        return vector4d.set(Math.fma((d11 - d13 - d15 + d17) * d24, d2, Math.fma(2.0 * (d18 + d22) * d24, d3, 2.0 * (d19 - d23) * d24 * d4)), Math.fma(2.0 * (d18 - d22) * d24, d2, Math.fma((d13 - d11 - d15 + d17) * d24, d3, 2.0 * (d20 + d21) * d24 * d4)), Math.fma(2.0 * (d19 + d23) * d24, d2, Math.fma(2.0 * (d20 - d21) * d24, d3, (d15 - d11 - d13 + d17) * d24 * d4)));
    }

    public Vector3f transform(Vector3f vector3f) {
        return this.transform((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    public Vector3f transformInverse(Vector3f vector3f) {
        return this.transformInverse((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    public Vector4d transformUnit(Vector4d vector4d) {
        Vector4d vector4d2 = vector4d;
        return this.transformUnit(vector4d2, vector4d2);
    }

    public Vector4d transformInverseUnit(Vector4d vector4d) {
        Vector4d vector4d2 = vector4d;
        return this.transformInverseUnit(vector4d2, vector4d2);
    }

    public Vector3d transformUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformInverseUnit(Vector3dc vector3dc, Vector3d vector3d) {
        return this.transformInverseUnit(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3d);
    }

    public Vector3d transformUnit(double d2, double d3, double d4, Vector3d vector3d) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector3d.set(Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 - d13), d3, 2.0 * (d7 + d11) * d4)), Math.fma(2.0 * (d6 + d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 - d8) * d4)), Math.fma(2.0 * (d7 - d11), d2, Math.fma(2.0 * (d10 + d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Vector3d transformInverseUnit(double d2, double d3, double d4, Vector3d vector3d) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector3d.set(Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 + d13), d3, 2.0 * (d7 - d11) * d4)), Math.fma(2.0 * (d6 - d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 + d8) * d4)), Math.fma(2.0 * (d7 + d11), d2, Math.fma(2.0 * (d10 - d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Vector4d transformUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformInverseUnit(Vector4dc vector4dc, Vector4d vector4d) {
        return this.transformInverseUnit(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4d);
    }

    public Vector4d transformUnit(double d2, double d3, double d4, Vector4d vector4d) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector4d.set(Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 - d13), d3, 2.0 * (d7 + d11) * d4)), Math.fma(2.0 * (d6 + d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 - d8) * d4)), Math.fma(2.0 * (d7 - d11), d2, Math.fma(2.0 * (d10 + d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)), vector4d.w);
    }

    public Vector4d transformInverseUnit(double d2, double d3, double d4, Vector4d vector4d) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector4d.set(Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 + d13), d3, 2.0 * (d7 - d11) * d4)), Math.fma(2.0 * (d6 - d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 + d8) * d4)), Math.fma(2.0 * (d7 + d11), d2, Math.fma(2.0 * (d10 - d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)), vector4d.w);
    }

    public Vector3f transformUnit(Vector3f vector3f) {
        return this.transformUnit((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    public Vector3f transformInverseUnit(Vector3f vector3f) {
        return this.transformInverseUnit((double)vector3f.x, (double)vector3f.y, (double)vector3f.z, vector3f);
    }

    public Vector3f transformPositiveX(Vector3f vector3f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.x * this.z;
        double d9 = this.y * this.w;
        vector3f.x = (float)(d2 + d3 - d5 - d4);
        vector3f.y = (float)(d7 + d6 + d6 + d7);
        vector3f.z = (float)(d8 - d9 + d8 - d9);
        return vector3f;
    }

    public Vector4f transformPositiveX(Vector4f vector4f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.x * this.z;
        double d9 = this.y * this.w;
        vector4f.x = (float)(d2 + d3 - d5 - d4);
        vector4f.y = (float)(d7 + d6 + d6 + d7);
        vector4f.z = (float)(d8 - d9 + d8 - d9);
        return vector4f;
    }

    public Vector3f transformUnitPositiveX(Vector3f vector3f) {
        double d2 = this.y * this.y;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.z * this.w;
        vector3f.x = (float)(1.0 - d2 - d2 - d3 - d3);
        vector3f.y = (float)(d4 + d7 + d4 + d7);
        vector3f.z = (float)(d5 - d6 + d5 - d6);
        return vector3f;
    }

    public Vector4f transformUnitPositiveX(Vector4f vector4f) {
        double d2 = this.y * this.y;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.x * this.z;
        double d6 = this.y * this.w;
        double d7 = this.z * this.w;
        vector4f.x = (float)(1.0 - d2 - d2 - d3 - d3);
        vector4f.y = (float)(d4 + d7 + d4 + d7);
        vector4f.z = (float)(d5 - d6 + d5 - d6);
        return vector4f;
    }

    public Vector3f transformPositiveY(Vector3f vector3f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector3f.x = (float)(-d6 + d7 - d6 + d7);
        vector3f.y = (float)(d4 - d5 + d2 - d3);
        double d10 = d8;
        vector3f.z = (float)(d10 + d10 + d9 + d9);
        return vector3f;
    }

    public Vector4f transformPositiveY(Vector4f vector4f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.z * this.w;
        double d7 = this.x * this.y;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector4f.x = (float)(-d6 + d7 - d6 + d7);
        vector4f.y = (float)(d4 - d5 + d2 - d3);
        double d10 = d8;
        vector4f.z = (float)(d10 + d10 + d9 + d9);
        return vector4f;
    }

    public Vector4f transformUnitPositiveY(Vector4f vector4f) {
        double d2 = this.x * this.x;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.z * this.w;
        vector4f.x = (float)(d4 - d7 + d4 - d7);
        vector4f.y = (float)(1.0 - d2 - d2 - d3 - d3);
        double d8 = d5;
        vector4f.z = (float)(d8 + d8 + d6 + d6);
        return vector4f;
    }

    public Vector3f transformUnitPositiveY(Vector3f vector3f) {
        double d2 = this.x * this.x;
        double d3 = this.z * this.z;
        double d4 = this.x * this.y;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.z * this.w;
        vector3f.x = (float)(d4 - d7 + d4 - d7);
        vector3f.y = (float)(1.0 - d2 - d2 - d3 - d3);
        double d8 = d5;
        vector3f.z = (float)(d8 + d8 + d6 + d6);
        return vector3f;
    }

    public Vector3f transformPositiveZ(Vector3f vector3f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.x * this.z;
        double d7 = this.y * this.w;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector3f.x = (float)(d7 + d6 + d6 + d7);
        double d10 = d8;
        vector3f.y = (float)(d10 + d10 - d9 - d9);
        vector3f.z = (float)(d5 - d4 - d3 + d2);
        return vector3f;
    }

    public Vector4f transformPositiveZ(Vector4f vector4f) {
        double d2 = this.w * this.w;
        double d3 = this.x * this.x;
        double d4 = this.y * this.y;
        double d5 = this.z * this.z;
        double d6 = this.x * this.z;
        double d7 = this.y * this.w;
        double d8 = this.y * this.z;
        double d9 = this.x * this.w;
        vector4f.x = (float)(d7 + d6 + d6 + d7);
        double d10 = d8;
        vector4f.y = (float)(d10 + d10 - d9 - d9);
        vector4f.z = (float)(d5 - d4 - d3 + d2);
        return vector4f;
    }

    public Vector4f transformUnitPositiveZ(Vector4f vector4f) {
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.y * this.w;
        vector4f.x = (float)(d4 + d7 + d4 + d7);
        double d8 = d5;
        vector4f.y = (float)(d8 + d8 - d6 - d6);
        vector4f.z = (float)(1.0 - d2 - d2 - d3 - d3);
        return vector4f;
    }

    public Vector3f transformUnitPositiveZ(Vector3f vector3f) {
        double d2 = this.x * this.x;
        double d3 = this.y * this.y;
        double d4 = this.x * this.z;
        double d5 = this.y * this.z;
        double d6 = this.x * this.w;
        double d7 = this.y * this.w;
        vector3f.x = (float)(d4 + d7 + d4 + d7);
        double d8 = d5;
        vector3f.y = (float)(d8 + d8 - d6 - d6);
        vector3f.z = (float)(1.0 - d2 - d2 - d3 - d3);
        return vector3f;
    }

    public Vector4f transform(Vector4f vector4f) {
        Vector4f vector4f2 = vector4f;
        return this.transform(vector4f2, vector4f2);
    }

    public Vector4f transformInverse(Vector4f vector4f) {
        Vector4f vector4f2 = vector4f;
        return this.transformInverse(vector4f2, vector4f2);
    }

    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transform((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    public Vector3f transformInverse(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverse((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    public Vector3f transform(double d2, double d3, double d4, Vector3f vector3f) {
        double d5 = this.x * this.x;
        double d6 = this.y * this.y;
        double d7 = this.z * this.z;
        double d8 = this.w * this.w;
        double d9 = this.x * this.y;
        double d10 = this.x * this.z;
        double d11 = this.y * this.z;
        double d12 = this.x * this.w;
        double d13 = this.z * this.w;
        double d14 = this.y * this.w;
        double d15 = 1.0 / (d5 + d6 + d7 + d8);
        return vector3f.set(Math.fma((d5 - d6 - d7 + d8) * d15, d2, Math.fma(2.0 * (d9 - d13) * d15, d3, 2.0 * (d10 + d14) * d15 * d4)), Math.fma(2.0 * (d9 + d13) * d15, d2, Math.fma((d6 - d5 - d7 + d8) * d15, d3, 2.0 * (d11 - d12) * d15 * d4)), Math.fma(2.0 * (d10 - d14) * d15, d2, Math.fma(2.0 * (d11 + d12) * d15, d3, (d7 - d5 - d6 + d8) * d15 * d4)));
    }

    public Vector3f transformInverse(double d2, double d3, double d4, Vector3f vector3f) {
        double d5 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d6 = this.x * d5;
        double d7 = this.y * d5;
        double d8 = this.z * d5;
        double d9 = this.w * d5;
        double d10 = d6;
        double d11 = d10 * d10;
        double d12 = d7;
        double d13 = d12 * d12;
        double d14 = d8;
        double d15 = d14 * d14;
        double d16 = d9;
        double d17 = d16 * d16;
        double d18 = d6 * d7;
        double d19 = d6 * d8;
        double d20 = d7 * d8;
        double d21 = d6 * d9;
        double d22 = d8 * d9;
        double d23 = d7 * d9;
        double d24 = 1.0 / (d11 + d13 + d15 + d17);
        return vector3f.set(Math.fma((d11 - d13 - d15 + d17) * d24, d2, Math.fma(2.0 * (d18 + d22) * d24, d3, 2.0 * (d19 - d23) * d24 * d4)), Math.fma(2.0 * (d18 - d22) * d24, d2, Math.fma((d13 - d11 - d15 + d17) * d24, d3, 2.0 * (d20 + d21) * d24 * d4)), Math.fma(2.0 * (d19 + d23) * d24, d2, Math.fma(2.0 * (d20 - d21) * d24, d3, (d15 - d11 - d13 + d17) * d24 * d4)));
    }

    public Vector4f transform(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transform((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    public Vector4f transformInverse(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverse((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    public Vector4f transform(double d2, double d3, double d4, Vector4f vector4f) {
        double d5 = this.x * this.x;
        double d6 = this.y * this.y;
        double d7 = this.z * this.z;
        double d8 = this.w * this.w;
        double d9 = this.x * this.y;
        double d10 = this.x * this.z;
        double d11 = this.y * this.z;
        double d12 = this.x * this.w;
        double d13 = this.z * this.w;
        double d14 = this.y * this.w;
        double d15 = 1.0 / (d5 + d6 + d7 + d8);
        return vector4f.set((float)Math.fma((d5 - d6 - d7 + d8) * d15, d2, Math.fma(2.0 * (d9 - d13) * d15, d3, 2.0 * (d10 + d14) * d15 * d4)), (float)Math.fma(2.0 * (d9 + d13) * d15, d2, Math.fma((d6 - d5 - d7 + d8) * d15, d3, 2.0 * (d11 - d12) * d15 * d4)), (float)Math.fma(2.0 * (d10 - d14) * d15, d2, Math.fma(2.0 * (d11 + d12) * d15, d3, (d7 - d5 - d6 + d8) * d15 * d4)), vector4f.w);
    }

    public Vector4f transformInverse(double d2, double d3, double d4, Vector4f vector4f) {
        double d5 = 1.0 / Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d6 = this.x * d5;
        double d7 = this.y * d5;
        double d8 = this.z * d5;
        double d9 = this.w * d5;
        double d10 = d6;
        double d11 = d10 * d10;
        double d12 = d7;
        double d13 = d12 * d12;
        double d14 = d8;
        double d15 = d14 * d14;
        double d16 = d9;
        double d17 = d16 * d16;
        double d18 = d6 * d7;
        double d19 = d6 * d8;
        double d20 = d7 * d8;
        double d21 = d6 * d9;
        double d22 = d8 * d9;
        double d23 = d7 * d9;
        double d24 = 1.0 / (d11 + d13 + d15 + d17);
        return vector4f.set(Math.fma((d11 - d13 - d15 + d17) * d24, d2, Math.fma(2.0 * (d18 + d22) * d24, d3, 2.0 * (d19 - d23) * d24 * d4)), Math.fma(2.0 * (d18 - d22) * d24, d2, Math.fma((d13 - d11 - d15 + d17) * d24, d3, 2.0 * (d20 + d21) * d24 * d4)), Math.fma(2.0 * (d19 + d23) * d24, d2, Math.fma(2.0 * (d20 - d21) * d24, d3, (d15 - d11 - d13 + d17) * d24 * d4)), (double)vector4f.w);
    }

    public Vector4f transformUnit(Vector4f vector4f) {
        Vector4f vector4f2 = vector4f;
        return this.transformUnit(vector4f2, vector4f2);
    }

    public Vector4f transformInverseUnit(Vector4f vector4f) {
        Vector4f vector4f2 = vector4f;
        return this.transformInverseUnit(vector4f2, vector4f2);
    }

    public Vector3f transformUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformUnit((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    public Vector3f transformInverseUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.transformInverseUnit((double)vector3fc.x(), (double)vector3fc.y(), (double)vector3fc.z(), vector3f);
    }

    public Vector3f transformUnit(double d2, double d3, double d4, Vector3f vector3f) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector3f.set((float)Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 - d13), d3, 2.0 * (d7 + d11) * d4)), (float)Math.fma(2.0 * (d6 + d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 - d8) * d4)), (float)Math.fma(2.0 * (d7 - d11), d2, Math.fma(2.0 * (d10 + d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Vector3f transformInverseUnit(double d2, double d3, double d4, Vector3f vector3f) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector3f.set((float)Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 + d13), d3, 2.0 * (d7 - d11) * d4)), (float)Math.fma(2.0 * (d6 - d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 + d8) * d4)), (float)Math.fma(2.0 * (d7 + d11), d2, Math.fma(2.0 * (d10 - d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Vector4f transformUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformUnit((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    public Vector4f transformInverseUnit(Vector4fc vector4fc, Vector4f vector4f) {
        return this.transformInverseUnit((double)vector4fc.x(), (double)vector4fc.y(), (double)vector4fc.z(), vector4f);
    }

    public Vector4f transformUnit(double d2, double d3, double d4, Vector4f vector4f) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector4f.set((float)Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 - d13), d3, 2.0 * (d7 + d11) * d4)), (float)Math.fma(2.0 * (d6 + d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 - d8) * d4)), (float)Math.fma(2.0 * (d7 - d11), d2, Math.fma(2.0 * (d10 + d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Vector4f transformInverseUnit(double d2, double d3, double d4, Vector4f vector4f) {
        double d5 = this.x * this.x;
        double d6 = this.x * this.y;
        double d7 = this.x * this.z;
        double d8 = this.x * this.w;
        double d9 = this.y * this.y;
        double d10 = this.y * this.z;
        double d11 = this.y * this.w;
        double d12 = this.z * this.z;
        double d13 = this.z * this.w;
        return vector4f.set((float)Math.fma(Math.fma(-2.0, d9 + d12, 1.0), d2, Math.fma(2.0 * (d6 + d13), d3, 2.0 * (d7 - d11) * d4)), (float)Math.fma(2.0 * (d6 - d13), d2, Math.fma(Math.fma(-2.0, d5 + d12, 1.0), d3, 2.0 * (d10 + d8) * d4)), (float)Math.fma(2.0 * (d7 + d11), d2, Math.fma(2.0 * (d10 - d8), d3, Math.fma(-2.0, d5 + d9, 1.0) * d4)));
    }

    public Quaterniond invert(Quaterniond quaterniond) {
        double d2 = 1.0 / this.lengthSquared();
        quaterniond.x = -this.x * d2;
        quaterniond.y = -this.y * d2;
        quaterniond.z = -this.z * d2;
        quaterniond.w = this.w * d2;
        return quaterniond;
    }

    public Quaterniond invert() {
        Quaterniond quaterniond = this;
        return quaterniond.invert(quaterniond);
    }

    public Quaterniond div(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        double d2 = 1.0 / Math.fma(quaterniondc.x(), quaterniondc.x(), Math.fma(quaterniondc.y(), quaterniondc.y(), Math.fma(quaterniondc.z(), quaterniondc.z(), quaterniondc.w() * quaterniondc.w())));
        double d3 = -quaterniondc.x() * d2;
        double d4 = -quaterniondc.y() * d2;
        double d5 = -quaterniondc.z() * d2;
        double d6 = quaterniondc.w() * d2;
        return quaterniond.set(Math.fma(this.w, d3, Math.fma(this.x, d6, Math.fma(this.y, d5, -this.z * d4))), Math.fma(this.w, d4, Math.fma(-this.x, d5, Math.fma(this.y, d6, this.z * d3))), Math.fma(this.w, d5, Math.fma(this.x, d4, Math.fma(-this.y, d3, this.z * d6))), Math.fma(this.w, d6, Math.fma(-this.x, d3, Math.fma(-this.y, d4, -this.z * d5))));
    }

    public Quaterniond div(Quaterniondc quaterniondc) {
        return this.div(quaterniondc, this);
    }

    public Quaterniond div(double d2, Quaterniond quaterniond) {
        quaterniond.x = this.x / d2;
        quaterniond.y = this.y / d2;
        quaterniond.z = this.z / d2;
        quaterniond.w = this.w / d2;
        return this;
    }

    public Quaterniond div(double d2) {
        return this.div(d2, this);
    }

    public Quaterniond conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Quaterniond conjugate(Quaterniond quaterniond) {
        quaterniond.x = -this.x;
        quaterniond.y = -this.y;
        quaterniond.z = -this.z;
        quaterniond.w = this.w;
        return quaterniond;
    }

    public Quaterniond identity() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 1.0;
        return this;
    }

    public double lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public Quaterniond rotationXYZ(double d2, double d3, double d4) {
        double d5 = Math.sin(d2 * 0.5);
        double d6 = Math.cosFromSin(d5, d2 * 0.5);
        double d7 = Math.sin(d3 * 0.5);
        double d8 = Math.cosFromSin(d7, d3 * 0.5);
        double d9 = Math.sin(d4 * 0.5);
        double d10 = Math.cosFromSin(d9, d4 * 0.5);
        double d11 = d8 * d10;
        double d12 = d7 * d9;
        double d13 = d7 * d10;
        double d14 = d8 * d9;
        this.w = d6 * d11 - d5 * d12;
        this.x = d5 * d11 + d6 * d12;
        this.y = d6 * d13 - d5 * d14;
        this.z = d6 * d14 + d5 * d13;
        return this;
    }

    public Quaterniond rotationZYX(double d2, double d3, double d4) {
        double d5 = Math.sin(d4 * 0.5);
        double d6 = Math.cosFromSin(d5, d4 * 0.5);
        double d7 = Math.sin(d3 * 0.5);
        double d8 = Math.cosFromSin(d7, d3 * 0.5);
        double d9 = Math.sin(d2 * 0.5);
        double d10 = Math.cosFromSin(d9, d2 * 0.5);
        double d11 = d8 * d10;
        double d12 = d7 * d9;
        double d13 = d7 * d10;
        double d14 = d8 * d9;
        this.w = d6 * d11 + d5 * d12;
        this.x = d5 * d11 - d6 * d12;
        this.y = d6 * d13 + d5 * d14;
        this.z = d6 * d14 - d5 * d13;
        return this;
    }

    public Quaterniond rotationYXZ(double d2, double d3, double d4) {
        double d5 = Math.sin(d3 * 0.5);
        double d6 = Math.cosFromSin(d5, d3 * 0.5);
        double d7 = Math.sin(d2 * 0.5);
        double d8 = Math.cosFromSin(d7, d2 * 0.5);
        double d9 = Math.sin(d4 * 0.5);
        double d10 = Math.cosFromSin(d9, d4 * 0.5);
        double d11 = d8 * d5;
        double d12 = d7 * d6;
        double d13 = d7 * d5;
        double d14 = d8 * d6;
        this.x = d11 * d10 + d12 * d9;
        this.y = d12 * d10 - d11 * d9;
        this.z = d14 * d9 - d13 * d10;
        this.w = d14 * d10 + d13 * d9;
        return this;
    }

    public Quaterniond slerp(Quaterniondc quaterniondc, double d2) {
        return this.slerp(quaterniondc, d2, this);
    }

    public Quaterniond slerp(Quaterniondc quaterniondc, double d2, Quaterniond quaterniond) {
        double d3;
        double d4;
        double d5 = Math.fma(this.x, quaterniondc.x(), Math.fma(this.y, quaterniondc.y(), Math.fma(this.z, quaterniondc.z(), this.w * quaterniondc.w())));
        double d6 = Math.abs(d5);
        if (1.0 - d6 > 1.0E-6) {
            double d7 = d6;
            double d8 = 1.0 - d7 * d7;
            double d9 = Math.invsqrt(d8);
            double d10 = Math.atan2(d8 * d9, d6);
            d4 = Math.sin((1.0 - d2) * d10) * d9;
            d3 = Math.sin(d2 * d10) * d9;
        } else {
            d4 = 1.0 - d2;
            d3 = d2;
        }
        d3 = d5 >= 0.0 ? d3 : -d3;
        quaterniond.x = Math.fma(d4, this.x, d3 * quaterniondc.x());
        quaterniond.y = Math.fma(d4, this.y, d3 * quaterniondc.y());
        quaterniond.z = Math.fma(d4, this.z, d3 * quaterniondc.z());
        quaterniond.w = Math.fma(d4, this.w, d3 * quaterniondc.w());
        return quaterniond;
    }

    public static Quaterniondc slerp(Quaterniond[] quaterniondArray, double[] dArray, Quaterniond quaterniond) {
        quaterniond.set(quaterniondArray[0]);
        double d2 = dArray[0];
        for (int i2 = 1; i2 < quaterniondArray.length; ++i2) {
            double d3 = d2;
            double d4 = dArray[i2];
            double d5 = d4 / (d3 + d4);
            d2 += d4;
            quaterniond.slerp(quaterniondArray[i2], d5);
        }
        return quaterniond;
    }

    public Quaterniond scale(double d2) {
        return this.scale(d2, this);
    }

    public Quaterniond scale(double d2, Quaterniond quaterniond) {
        double d3 = Math.sqrt(d2);
        quaterniond.x = d3 * this.x;
        quaterniond.y = d3 * this.y;
        quaterniond.z = d3 * this.z;
        quaterniond.w = d3 * this.w;
        return quaterniond;
    }

    public Quaterniond scaling(double d2) {
        double d3 = Math.sqrt(d2);
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = d3;
        return this;
    }

    public Quaterniond integrate(double d2, double d3, double d4, double d5) {
        return this.integrate(d2, d3, d4, d5, this);
    }

    public Quaterniond integrate(double d2, double d3, double d4, double d5, Quaterniond quaterniond) {
        double d6;
        double d7;
        double d8;
        double d9 = d2 * d3 * 0.5;
        double d10 = d2 * d4 * 0.5;
        double d11 = d2 * d5 * 0.5;
        double d12 = d9;
        double d13 = d10;
        double d14 = d11;
        double d15 = d12 * d12 + d13 * d13 + d14 * d14;
        if (d8 * d8 / 24.0 < 1.0E-8) {
            d7 = 1.0 - d15 * 0.5;
            d6 = 1.0 - d15 / 6.0;
        } else {
            double d16 = Math.sqrt(d15);
            double d17 = Math.sin(d16);
            d6 = d17 / d16;
            d7 = Math.cosFromSin(d17, d16);
        }
        double d18 = d9 * d6;
        double d19 = d10 * d6;
        double d20 = d11 * d6;
        return quaterniond.set(Math.fma(d7, this.x, Math.fma(d18, this.w, Math.fma(d19, this.z, -d20 * this.y))), Math.fma(d7, this.y, Math.fma(-d18, this.z, Math.fma(d19, this.w, d20 * this.x))), Math.fma(d7, this.z, Math.fma(d18, this.y, Math.fma(-d19, this.x, d20 * this.w))), Math.fma(d7, this.w, Math.fma(-d18, this.x, Math.fma(-d19, this.y, -d20 * this.z))));
    }

    public Quaterniond nlerp(Quaterniondc quaterniondc, double d2) {
        return this.nlerp(quaterniondc, d2, this);
    }

    public Quaterniond nlerp(Quaterniondc quaterniondc, double d2, Quaterniond quaterniond) {
        double d3 = Math.fma(this.x, quaterniondc.x(), Math.fma(this.y, quaterniondc.y(), Math.fma(this.z, quaterniondc.z(), this.w * quaterniondc.w())));
        double d4 = 1.0 - d2;
        double d5 = d3 >= 0.0 ? d2 : -d2;
        quaterniond.x = Math.fma(d4, this.x, d5 * quaterniondc.x());
        quaterniond.y = Math.fma(d4, this.y, d5 * quaterniondc.y());
        quaterniond.z = Math.fma(d4, this.z, d5 * quaterniondc.z());
        quaterniond.w = Math.fma(d4, this.w, d5 * quaterniondc.w());
        double d6 = Math.invsqrt(Math.fma(quaterniond.x, quaterniond.x, Math.fma(quaterniond.y, quaterniond.y, Math.fma(quaterniond.z, quaterniond.z, quaterniond.w * quaterniond.w))));
        quaterniond.x *= d6;
        quaterniond.y *= d6;
        quaterniond.z *= d6;
        quaterniond.w *= d6;
        return quaterniond;
    }

    public static Quaterniondc nlerp(Quaterniond[] quaterniondArray, double[] dArray, Quaterniond quaterniond) {
        quaterniond.set(quaterniondArray[0]);
        double d2 = dArray[0];
        for (int i2 = 1; i2 < quaterniondArray.length; ++i2) {
            double d3 = d2;
            double d4 = dArray[i2];
            double d5 = d4 / (d3 + d4);
            d2 += d4;
            quaterniond.nlerp(quaterniondArray[i2], d5);
        }
        return quaterniond;
    }

    public Quaterniond nlerpIterative(Quaterniondc quaterniondc, double d2, double d3, Quaterniond quaterniond) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = this.x;
        double d9 = this.y;
        double d10 = this.z;
        double d11 = this.w;
        double d12 = quaterniondc.x();
        double d13 = Math.fma(d8, d12, Math.fma(d9, d7 = quaterniondc.y(), Math.fma(d10, d6 = quaterniondc.z(), d11 * (d5 = quaterniondc.w()))));
        double d14 = Math.abs(d13);
        if (0.999999 < d14) {
            return quaterniond.set(this);
        }
        double d15 = d2;
        while (d14 < d3) {
            float f2;
            double d16 = d4 = d13 >= 0.0 ? 0.5 : -0.5;
            if (d15 < 0.5) {
                d12 = Math.fma(0.5, d12, d4 * d8);
                d7 = Math.fma(0.5, d7, d4 * d9);
                d6 = Math.fma(0.5, d6, d4 * d10);
                d5 = Math.fma(0.5, d5, d4 * d11);
                double d17 = d12;
                double d18 = d7;
                double d19 = d6;
                double d20 = d5;
                f2 = (float)Math.invsqrt(Math.fma(d17, d17, Math.fma(d18, d18, Math.fma(d19, d19, d20 * d20))));
                d12 *= (double)f2;
                d7 *= (double)f2;
                d6 *= (double)f2;
                d5 *= (double)f2;
                double d21 = d15;
                d15 = d21 + d21;
            } else {
                d8 = Math.fma(0.5, d8, d4 * d12);
                d9 = Math.fma(0.5, d9, d4 * d7);
                d10 = Math.fma(0.5, d10, d4 * d6);
                d11 = Math.fma(0.5, d11, d4 * d5);
                double d22 = d8;
                double d23 = d9;
                double d24 = d10;
                double d25 = d11;
                f2 = (float)Math.invsqrt(Math.fma(d22, d22, Math.fma(d23, d23, Math.fma(d24, d24, d25 * d25))));
                d8 *= (double)f2;
                d9 *= (double)f2;
                d10 *= (double)f2;
                d11 *= (double)f2;
                double d26 = d15;
                d15 = d26 + d26 - 1.0;
            }
            d13 = Math.fma(d8, d12, Math.fma(d9, d7, Math.fma(d10, d6, d11 * d5)));
            d14 = Math.abs(d13);
        }
        double d27 = 1.0 - d15;
        d4 = d13 >= 0.0 ? d15 : -d15;
        double d28 = Math.fma(d27, d8, d4 * d12);
        double d29 = Math.fma(d27, d9, d4 * d7);
        double d30 = Math.fma(d27, d10, d4 * d6);
        double d31 = Math.fma(d27, d11, d4 * d5);
        double d32 = d28;
        double d33 = d29;
        double d34 = d30;
        double d35 = d31;
        double d36 = Math.invsqrt(Math.fma(d32, d32, Math.fma(d33, d33, Math.fma(d34, d34, d35 * d35))));
        quaterniond.x = d28 * d36;
        quaterniond.y = d29 * d36;
        quaterniond.z = d30 * d36;
        quaterniond.w = d31 * d36;
        return quaterniond;
    }

    public Quaterniond nlerpIterative(Quaterniondc quaterniondc, double d2, double d3) {
        return this.nlerpIterative(quaterniondc, d2, d3, this);
    }

    public static Quaterniond nlerpIterative(Quaterniondc[] quaterniondcArray, double[] dArray, double d2, Quaterniond quaterniond) {
        quaterniond.set(quaterniondcArray[0]);
        double d3 = dArray[0];
        for (int i2 = 1; i2 < quaterniondcArray.length; ++i2) {
            double d4 = d3;
            double d5 = dArray[i2];
            double d6 = d5 / (d4 + d5);
            d3 += d5;
            quaterniond.nlerpIterative(quaterniondcArray[i2], d6, d2);
        }
        return quaterniond;
    }

    public Quaterniond lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    public Quaterniond lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2, Quaterniond quaterniond) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), quaterniond);
    }

    public Quaterniond lookAlong(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.lookAlong(d2, d3, d4, d5, d6, d7, this);
    }

    public Quaterniond lookAlong(double d2, double d3, double d4, double d5, double d6, double d7, Quaterniond quaterniond) {
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13 = d2;
        double d14 = d3;
        double d15 = d4;
        double d16 = Math.invsqrt(d13 * d13 + d14 * d14 + d15 * d15);
        double d17 = -d2 * d16;
        double d18 = -d3 * d16;
        double d19 = -d4 * d16;
        double d20 = d6 * d19 - d7 * d18;
        double d21 = d7 * d17 - d5 * d19;
        double d22 = d5 * d18 - d6 * d17;
        double d23 = d20;
        double d24 = d21;
        double d25 = d22;
        double d26 = Math.invsqrt(d23 * d23 + d24 * d24 + d25 * d25);
        double d27 = d18 * (d22 *= d26) - d19 * (d21 *= d26);
        double d28 = d19 * (d20 *= d26) - d17 * d22;
        double d29 = d17 * d21 - d18 * d20;
        double d30 = d20 + d28 + d19;
        if (d12 >= 0.0) {
            double d31 = Math.sqrt(d30 + 1.0);
            d11 = d31 * 0.5;
            d31 = 0.5 / d31;
            d10 = (d18 - d29) * d31;
            d9 = (d22 - d17) * d31;
            d8 = (d27 - d21) * d31;
        } else if (d20 > d28 && d20 > d19) {
            double d32 = Math.sqrt(d20 + 1.0 - d28 - d19);
            d10 = d32 * 0.5;
            d32 = 0.5 / d32;
            d9 = (d21 + d27) * d32;
            d8 = (d17 + d22) * d32;
            d11 = (d18 - d29) * d32;
        } else if (d28 > d19) {
            double d33 = Math.sqrt(d28 + 1.0 - d20 - d19);
            d9 = d33 * 0.5;
            d33 = 0.5 / d33;
            d10 = (d21 + d27) * d33;
            d8 = (d29 + d18) * d33;
            d11 = (d22 - d17) * d33;
        } else {
            double d34 = Math.sqrt(d19 + 1.0 - d20 - d28);
            d8 = d34 * 0.5;
            d34 = 0.5 / d34;
            d10 = (d17 + d22) * d34;
            d9 = (d29 + d18) * d34;
            d11 = (d27 - d21) * d34;
        }
        return quaterniond.set(Math.fma(this.w, d10, Math.fma(this.x, d11, Math.fma(this.y, d8, -this.z * d9))), Math.fma(this.w, d9, Math.fma(-this.x, d8, Math.fma(this.y, d11, this.z * d10))), Math.fma(this.w, d8, Math.fma(this.x, d9, Math.fma(-this.y, d10, this.z * d11))), Math.fma(this.w, d11, Math.fma(-this.x, d10, Math.fma(-this.y, d9, -this.z * d8))));
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " " + Runtime.format(this.w, numberFormat) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
        objectOutput.writeDouble(this.w);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
        this.w = objectInput.readDouble();
    }

    public int hashCode() {
        long l2;
        long l3 = l2 = Double.doubleToLongBits(this.w);
        int n2 = 31 + (int)(l3 ^ l3 >>> 32);
        long l4 = l2 = Double.doubleToLongBits(this.x);
        n2 = n2 * 31 + (int)(l4 ^ l4 >>> 32);
        long l5 = l2 = Double.doubleToLongBits(this.y);
        n2 = n2 * 31 + (int)(l5 ^ l5 >>> 32);
        long l6 = l2 = Double.doubleToLongBits(this.z);
        return n2 * 31 + (int)(l6 ^ l6 >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Quaterniond)object;
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(((Quaterniond)object).w)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(((Quaterniond)object).x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(((Quaterniond)object).y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(((Quaterniond)object).z);
    }

    public Quaterniond difference(Quaterniondc quaterniondc) {
        return this.difference(quaterniondc, this);
    }

    public Quaterniond difference(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        double d2 = 1.0 / this.lengthSquared();
        double d3 = -this.x * d2;
        double d4 = -this.y * d2;
        double d5 = -this.z * d2;
        double d6 = this.w * d2;
        quaterniond.set(Math.fma(d6, quaterniondc.x(), Math.fma(d3, quaterniondc.w(), Math.fma(d4, quaterniondc.z(), -d5 * quaterniondc.y()))), Math.fma(d6, quaterniondc.y(), Math.fma(-d3, quaterniondc.z(), Math.fma(d4, quaterniondc.w(), d5 * quaterniondc.x()))), Math.fma(d6, quaterniondc.z(), Math.fma(d3, quaterniondc.y(), Math.fma(-d4, quaterniondc.x(), d5 * quaterniondc.w()))), Math.fma(d6, quaterniondc.w(), Math.fma(-d3, quaterniondc.x(), Math.fma(-d4, quaterniondc.y(), -d5 * quaterniondc.z()))));
        return quaterniond;
    }

    public Quaterniond rotationTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9 = d2;
        double d10 = d3;
        double d11 = d4;
        double d12 = Math.invsqrt(Math.fma(d9, d9, Math.fma(d10, d10, d11 * d11)));
        double d13 = d5;
        double d14 = d6;
        double d15 = d7;
        double d16 = Math.invsqrt(Math.fma(d13, d13, Math.fma(d14, d14, d15 * d15)));
        double d17 = d2 * d12;
        double d18 = d3 * d12;
        double d19 = d4 * d12;
        double d20 = d5 * d16;
        double d21 = d6 * d16;
        double d22 = d7 * d16;
        double d23 = d17 * d20 + d18 * d21 + d19 * d22;
        if (d8 < -0.999999) {
            double d24 = d18;
            double d25 = -d17;
            double d26 = 0.0;
            double d27 = d18;
            double d28 = d25;
            if (d27 * d27 + d28 * d28 == 0.0) {
                d24 = 0.0;
                d25 = d19;
                d26 = -d18;
            }
            this.x = d24;
            this.y = d25;
            this.z = d26;
            this.w = 0.0;
        } else {
            double d29 = Math.sqrt((d23 + 1.0) * 2.0);
            double d30 = 1.0 / d29;
            double d31 = d18 * d22 - d19 * d21;
            double d32 = d19 * d20 - d17 * d22;
            double d33 = d17 * d21 - d18 * d20;
            double d34 = d31 * d30;
            double d35 = d32 * d30;
            double d36 = d33 * d30;
            double d37 = d29 * 0.5;
            double d38 = d34;
            double d39 = d35;
            double d40 = d36;
            double d41 = d37;
            double d42 = Math.invsqrt(Math.fma(d38, d38, Math.fma(d39, d39, Math.fma(d40, d40, d41 * d41))));
            this.x = d34 * d42;
            this.y = d35 * d42;
            this.z = d36 * d42;
            this.w = d37 * d42;
        }
        return this;
    }

    public Quaterniond rotationTo(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotationTo(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Quaterniond rotateTo(double d2, double d3, double d4, double d5, double d6, double d7, Quaterniond quaterniond) {
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13 = d2;
        double d14 = d3;
        double d15 = d4;
        double d16 = Math.invsqrt(Math.fma(d13, d13, Math.fma(d14, d14, d15 * d15)));
        double d17 = d5;
        double d18 = d6;
        double d19 = d7;
        double d20 = Math.invsqrt(Math.fma(d17, d17, Math.fma(d18, d18, d19 * d19)));
        double d21 = d2 * d16;
        double d22 = d3 * d16;
        double d23 = d4 * d16;
        double d24 = d5 * d20;
        double d25 = d6 * d20;
        double d26 = d7 * d20;
        double d27 = d21 * d24 + d22 * d25 + d23 * d26;
        if (d12 < -0.999999) {
            d11 = d22;
            d10 = -d21;
            d9 = 0.0;
            d8 = 0.0;
            double d28 = d22;
            double d29 = d10;
            if (d28 * d28 + d29 * d29 == 0.0) {
                d11 = 0.0;
                d10 = d23;
                d9 = -d22;
                d8 = 0.0;
            }
        } else {
            double d30 = Math.sqrt((d27 + 1.0) * 2.0);
            double d31 = 1.0 / d30;
            double d32 = d22 * d26 - d23 * d25;
            double d33 = d23 * d24 - d21 * d26;
            double d34 = d21 * d25 - d22 * d24;
            d11 = d32 * d31;
            d10 = d33 * d31;
            d9 = d34 * d31;
            d8 = d30 * 0.5;
            double d35 = d11;
            double d36 = d10;
            double d37 = d9;
            double d38 = d8;
            double d39 = Math.invsqrt(Math.fma(d35, d35, Math.fma(d36, d36, Math.fma(d37, d37, d38 * d38))));
            d11 *= d39;
            d10 *= d39;
            d9 *= d39;
            d8 *= d39;
        }
        return quaterniond.set(Math.fma(this.w, d11, Math.fma(this.x, d8, Math.fma(this.y, d9, -this.z * d10))), Math.fma(this.w, d10, Math.fma(-this.x, d9, Math.fma(this.y, d8, this.z * d11))), Math.fma(this.w, d9, Math.fma(this.x, d10, Math.fma(-this.y, d11, this.z * d8))), Math.fma(this.w, d8, Math.fma(-this.x, d11, Math.fma(-this.y, d10, -this.z * d9))));
    }

    public Quaterniond rotationAxis(AxisAngle4f axisAngle4f) {
        return this.rotationAxis(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Quaterniond rotationAxis(double d2, double d3, double d4, double d5) {
        double d6 = d2 / 2.0;
        double d7 = Math.sin(d6);
        double d8 = d3;
        double d9 = d4;
        double d10 = d5;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        return this.set(d3 * d11 * d7, d4 * d11 * d7, d5 * d11 * d7, Math.cosFromSin(d7, d6));
    }

    public Quaterniond rotationX(double d2) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return this.set(d3, 0.0, d4, 0.0);
    }

    public Quaterniond rotationY(double d2) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return this.set(0.0, d3, 0.0, d4);
    }

    public Quaterniond rotationZ(double d2) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return this.set(0.0, 0.0, d3, d4);
    }

    public Quaterniond rotateTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.rotateTo(d2, d3, d4, d5, d6, d7, this);
    }

    public Quaterniond rotateTo(Vector3dc vector3dc, Vector3dc vector3dc2, Quaterniond quaterniond) {
        return this.rotateTo(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), quaterniond);
    }

    public Quaterniond rotateTo(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotateTo(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    public Quaterniond rotateX(double d2) {
        return this.rotateX(d2, this);
    }

    public Quaterniond rotateX(double d2, Quaterniond quaterniond) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return quaterniond.set(this.w * d3 + this.x * d4, this.y * d4 + this.z * d3, this.z * d4 - this.y * d3, this.w * d4 - this.x * d3);
    }

    public Quaterniond rotateY(double d2) {
        return this.rotateY(d2, this);
    }

    public Quaterniond rotateY(double d2, Quaterniond quaterniond) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return quaterniond.set(this.x * d4 - this.z * d3, this.w * d3 + this.y * d4, this.x * d3 + this.z * d4, this.w * d4 - this.y * d3);
    }

    public Quaterniond rotateZ(double d2) {
        return this.rotateZ(d2, this);
    }

    public Quaterniond rotateZ(double d2, Quaterniond quaterniond) {
        double d3 = Math.sin(d2 * 0.5);
        double d4 = Math.cosFromSin(d3, d2 * 0.5);
        return quaterniond.set(this.x * d4 + this.y * d3, this.y * d4 - this.x * d3, this.w * d3 + this.z * d4, this.w * d4 - this.z * d3);
    }

    public Quaterniond rotateLocalX(double d2) {
        return this.rotateLocalX(d2, this);
    }

    public Quaterniond rotateLocalX(double d2, Quaterniond quaterniond) {
        double d3 = d2 * 0.5;
        double d4 = Math.sin(d3);
        double d5 = Math.cosFromSin(d4, d3);
        quaterniond.set(d5 * this.x + d4 * this.w, d5 * this.y - d4 * this.z, d5 * this.z + d4 * this.y, d5 * this.w - d4 * this.x);
        return quaterniond;
    }

    public Quaterniond rotateLocalY(double d2) {
        return this.rotateLocalY(d2, this);
    }

    public Quaterniond rotateLocalY(double d2, Quaterniond quaterniond) {
        double d3 = d2 * 0.5;
        double d4 = Math.sin(d3);
        double d5 = Math.cosFromSin(d4, d3);
        quaterniond.set(d5 * this.x + d4 * this.z, d5 * this.y + d4 * this.w, d5 * this.z - d4 * this.x, d5 * this.w - d4 * this.y);
        return quaterniond;
    }

    public Quaterniond rotateLocalZ(double d2) {
        return this.rotateLocalZ(d2, this);
    }

    public Quaterniond rotateLocalZ(double d2, Quaterniond quaterniond) {
        double d3 = d2 * 0.5;
        double d4 = Math.sin(d3);
        double d5 = Math.cosFromSin(d4, d3);
        quaterniond.set(d5 * this.x - d4 * this.y, d5 * this.y + d4 * this.x, d5 * this.z + d4 * this.w, d5 * this.w - d4 * this.z);
        return quaterniond;
    }

    public Quaterniond rotateXYZ(double d2, double d3, double d4) {
        return this.rotateXYZ(d2, d3, d4, this);
    }

    public Quaterniond rotateXYZ(double d2, double d3, double d4, Quaterniond quaterniond) {
        double d5 = Math.sin(d2 * 0.5);
        double d6 = Math.cosFromSin(d5, d2 * 0.5);
        double d7 = Math.sin(d3 * 0.5);
        double d8 = Math.cosFromSin(d7, d3 * 0.5);
        double d9 = Math.sin(d4 * 0.5);
        double d10 = Math.cosFromSin(d9, d4 * 0.5);
        double d11 = d8 * d10;
        double d12 = d7 * d9;
        double d13 = d7 * d10;
        double d14 = d8 * d9;
        double d15 = d6 * d11 - d5 * d12;
        double d16 = d5 * d11 + d6 * d12;
        double d17 = d6 * d13 - d5 * d14;
        double d18 = d6 * d14 + d5 * d13;
        return quaterniond.set(Math.fma(this.w, d16, Math.fma(this.x, d15, Math.fma(this.y, d18, -this.z * d17))), Math.fma(this.w, d17, Math.fma(-this.x, d18, Math.fma(this.y, d15, this.z * d16))), Math.fma(this.w, d18, Math.fma(this.x, d17, Math.fma(-this.y, d16, this.z * d15))), Math.fma(this.w, d15, Math.fma(-this.x, d16, Math.fma(-this.y, d17, -this.z * d18))));
    }

    public Quaterniond rotateZYX(double d2, double d3, double d4) {
        return this.rotateZYX(d2, d3, d4, this);
    }

    public Quaterniond rotateZYX(double d2, double d3, double d4, Quaterniond quaterniond) {
        double d5 = Math.sin(d4 * 0.5);
        double d6 = Math.cosFromSin(d5, d4 * 0.5);
        double d7 = Math.sin(d3 * 0.5);
        double d8 = Math.cosFromSin(d7, d3 * 0.5);
        double d9 = Math.sin(d2 * 0.5);
        double d10 = Math.cosFromSin(d9, d2 * 0.5);
        double d11 = d8 * d10;
        double d12 = d7 * d9;
        double d13 = d7 * d10;
        double d14 = d8 * d9;
        double d15 = d6 * d11 + d5 * d12;
        double d16 = d5 * d11 - d6 * d12;
        double d17 = d6 * d13 + d5 * d14;
        double d18 = d6 * d14 - d5 * d13;
        return quaterniond.set(Math.fma(this.w, d16, Math.fma(this.x, d15, Math.fma(this.y, d18, -this.z * d17))), Math.fma(this.w, d17, Math.fma(-this.x, d18, Math.fma(this.y, d15, this.z * d16))), Math.fma(this.w, d18, Math.fma(this.x, d17, Math.fma(-this.y, d16, this.z * d15))), Math.fma(this.w, d15, Math.fma(-this.x, d16, Math.fma(-this.y, d17, -this.z * d18))));
    }

    public Quaterniond rotateYXZ(double d2, double d3, double d4) {
        return this.rotateYXZ(d2, d3, d4, this);
    }

    public Quaterniond rotateYXZ(double d2, double d3, double d4, Quaterniond quaterniond) {
        double d5 = Math.sin(d3 * 0.5);
        double d6 = Math.cosFromSin(d5, d3 * 0.5);
        double d7 = Math.sin(d2 * 0.5);
        double d8 = Math.cosFromSin(d7, d2 * 0.5);
        double d9 = Math.sin(d4 * 0.5);
        double d10 = Math.cosFromSin(d9, d4 * 0.5);
        double d11 = d8 * d5;
        double d12 = d7 * d6;
        double d13 = d7 * d5;
        double d14 = d8 * d6;
        double d15 = d11 * d10 + d12 * d9;
        double d16 = d12 * d10 - d11 * d9;
        double d17 = d14 * d9 - d13 * d10;
        double d18 = d14 * d10 + d13 * d9;
        return quaterniond.set(Math.fma(this.w, d15, Math.fma(this.x, d18, Math.fma(this.y, d17, -this.z * d16))), Math.fma(this.w, d16, Math.fma(-this.x, d17, Math.fma(this.y, d18, this.z * d15))), Math.fma(this.w, d17, Math.fma(this.x, d16, Math.fma(-this.y, d15, this.z * d18))), Math.fma(this.w, d18, Math.fma(-this.x, d15, Math.fma(-this.y, d16, -this.z * d17))));
    }

    public Vector3d getEulerAnglesXYZ(Vector3d vector3d) {
        vector3d.x = Math.atan2(this.x * this.w - this.y * this.z, 0.5 - this.x * this.x - this.y * this.y);
        vector3d.y = Math.safeAsin(2.0 * (this.x * this.z + this.y * this.w));
        vector3d.z = Math.atan2(this.z * this.w - this.x * this.y, 0.5 - this.y * this.y - this.z * this.z);
        return vector3d;
    }

    public Vector3d getEulerAnglesZYX(Vector3d vector3d) {
        vector3d.x = Math.atan2(this.y * this.z + this.w * this.x, 0.5 - this.x * this.x - this.y * this.y);
        vector3d.y = Math.safeAsin(-2.0 * (this.x * this.z - this.w * this.y));
        vector3d.z = Math.atan2(this.x * this.y + this.w * this.z, 0.5 - this.y * this.y - this.z * this.z);
        return vector3d;
    }

    public Vector3d getEulerAnglesZXY(Vector3d vector3d) {
        vector3d.x = Math.safeAsin(2.0 * (this.w * this.x + this.y * this.z));
        vector3d.y = Math.atan2(this.w * this.y - this.x * this.z, 0.5 - this.y * this.y - this.x * this.x);
        vector3d.z = Math.atan2(this.w * this.z - this.x * this.y, 0.5 - this.z * this.z - this.x * this.x);
        return vector3d;
    }

    public Vector3d getEulerAnglesYXZ(Vector3d vector3d) {
        vector3d.x = Math.safeAsin(-2.0 * (this.y * this.z - this.w * this.x));
        vector3d.y = Math.atan2(this.x * this.z + this.y * this.w, 0.5 - this.y * this.y - this.x * this.x);
        vector3d.z = Math.atan2(this.y * this.x + this.w * this.z, 0.5 - this.x * this.x - this.z * this.z);
        return vector3d;
    }

    public Quaterniond rotateAxis(double d2, double d3, double d4, double d5, Quaterniond quaterniond) {
        double d6 = d2 / 2.0;
        double d7 = Math.sin(d6);
        double d8 = d3;
        double d9 = d4;
        double d10 = d5;
        double d11 = Math.invsqrt(Math.fma(d8, d8, Math.fma(d9, d9, d10 * d10)));
        double d12 = d3 * d11 * d7;
        double d13 = d4 * d11 * d7;
        double d14 = d5 * d11 * d7;
        double d15 = Math.cosFromSin(d7, d6);
        return quaterniond.set(Math.fma(this.w, d12, Math.fma(this.x, d15, Math.fma(this.y, d14, -this.z * d13))), Math.fma(this.w, d13, Math.fma(-this.x, d14, Math.fma(this.y, d15, this.z * d12))), Math.fma(this.w, d14, Math.fma(this.x, d13, Math.fma(-this.y, d12, this.z * d15))), Math.fma(this.w, d15, Math.fma(-this.x, d12, Math.fma(-this.y, d13, -this.z * d14))));
    }

    public Quaterniond rotateAxis(double d2, Vector3dc vector3dc, Quaterniond quaterniond) {
        return this.rotateAxis(d2, vector3dc.x(), vector3dc.y(), vector3dc.z(), quaterniond);
    }

    public Quaterniond rotateAxis(double d2, Vector3dc vector3dc) {
        return this.rotateAxis(d2, vector3dc.x(), vector3dc.y(), vector3dc.z(), this);
    }

    public Quaterniond rotateAxis(double d2, double d3, double d4, double d5) {
        return this.rotateAxis(d2, d3, d4, d5, this);
    }

    public Vector3d positiveX(Vector3d vector3d) {
        double d2 = 1.0 / this.lengthSquared();
        double d3 = -this.x * d2;
        double d4 = -this.y * d2;
        double d5 = -this.z * d2;
        double d6 = this.w * d2;
        double d7 = d4;
        double d8 = d7 + d7;
        double d9 = d5;
        double d10 = d9 + d9;
        vector3d.x = -d4 * d8 - d5 * d10 + 1.0;
        vector3d.y = d3 * d8 + d6 * d10;
        vector3d.z = d3 * d10 - d6 * d8;
        return vector3d;
    }

    public Vector3d normalizedPositiveX(Vector3d vector3d) {
        double d2 = this.y + this.y;
        double d3 = this.z + this.z;
        vector3d.x = -this.y * d2 - this.z * d3 + 1.0;
        vector3d.y = this.x * d2 - this.w * d3;
        vector3d.z = this.x * d3 + this.w * d2;
        return vector3d;
    }

    public Vector3d positiveY(Vector3d vector3d) {
        double d2 = 1.0 / this.lengthSquared();
        double d3 = -this.x * d2;
        double d4 = -this.y * d2;
        double d5 = -this.z * d2;
        double d6 = this.w * d2;
        double d7 = d3;
        double d8 = d7 + d7;
        double d9 = d4;
        double d10 = d9 + d9;
        double d11 = d5;
        double d12 = d11 + d11;
        vector3d.x = d3 * d10 - d6 * d12;
        vector3d.y = -d3 * d8 - d5 * d12 + 1.0;
        vector3d.z = d4 * d12 + d6 * d8;
        return vector3d;
    }

    public Vector3d normalizedPositiveY(Vector3d vector3d) {
        double d2 = this.x + this.x;
        double d3 = this.y + this.y;
        double d4 = this.z + this.z;
        vector3d.x = this.x * d3 + this.w * d4;
        vector3d.y = -this.x * d2 - this.z * d4 + 1.0;
        vector3d.z = this.y * d4 - this.w * d2;
        return vector3d;
    }

    public Vector3d positiveZ(Vector3d vector3d) {
        double d2 = 1.0 / this.lengthSquared();
        double d3 = -this.x * d2;
        double d4 = -this.y * d2;
        double d5 = -this.z * d2;
        double d6 = this.w * d2;
        double d7 = d3;
        double d8 = d7 + d7;
        double d9 = d4;
        double d10 = d9 + d9;
        double d11 = d5;
        double d12 = d11 + d11;
        vector3d.x = d3 * d12 + d6 * d10;
        vector3d.y = d4 * d12 - d6 * d8;
        vector3d.z = -d3 * d8 - d4 * d10 + 1.0;
        return vector3d;
    }

    public Vector3d normalizedPositiveZ(Vector3d vector3d) {
        double d2 = this.x + this.x;
        double d3 = this.y + this.y;
        double d4 = this.z + this.z;
        vector3d.x = this.x * d4 - this.w * d3;
        vector3d.y = this.y * d4 + this.w * d2;
        vector3d.z = -this.x * d2 - this.y * d3 + 1.0;
        return vector3d;
    }

    public Quaterniond conjugateBy(Quaterniondc quaterniondc) {
        return this.conjugateBy(quaterniondc, this);
    }

    public Quaterniond conjugateBy(Quaterniondc quaterniondc, Quaterniond quaterniond) {
        double d2 = 1.0 / quaterniondc.lengthSquared();
        double d3 = -quaterniondc.x() * d2;
        double d4 = -quaterniondc.y() * d2;
        double d5 = -quaterniondc.z() * d2;
        double d6 = quaterniondc.w() * d2;
        double d7 = Math.fma(quaterniondc.w(), this.x, Math.fma(quaterniondc.x(), this.w, Math.fma(quaterniondc.y(), this.z, -quaterniondc.z() * this.y)));
        double d8 = Math.fma(quaterniondc.w(), this.y, Math.fma(-quaterniondc.x(), this.z, Math.fma(quaterniondc.y(), this.w, quaterniondc.z() * this.x)));
        double d9 = Math.fma(quaterniondc.w(), this.z, Math.fma(quaterniondc.x(), this.y, Math.fma(-quaterniondc.y(), this.x, quaterniondc.z() * this.w)));
        double d10 = Math.fma(quaterniondc.w(), this.w, Math.fma(-quaterniondc.x(), this.x, Math.fma(-quaterniondc.y(), this.y, -quaterniondc.z() * this.z)));
        return quaterniond.set(Math.fma(d10, d3, Math.fma(d7, d6, Math.fma(d8, d5, -d9 * d4))), Math.fma(d10, d4, Math.fma(-d7, d5, Math.fma(d8, d6, d9 * d3))), Math.fma(d10, d5, Math.fma(d7, d4, Math.fma(-d8, d3, d9 * d6))), Math.fma(d10, d6, Math.fma(-d7, d3, Math.fma(-d8, d4, -d9 * d5))));
    }

    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }

    public boolean equals(Quaterniondc quaterniondc, double d2) {
        if (this == quaterniondc) {
            return true;
        }
        if (quaterniondc == null) {
            return false;
        }
        if (this.getClass() != quaterniondc.getClass()) {
            return false;
        }
        if (!Runtime.equals(this.x, quaterniondc.x(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.y, quaterniondc.y(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.z, quaterniondc.z(), d2)) {
            return false;
        }
        return Runtime.equals(this.w, quaterniondc.w(), d2);
    }

    public boolean equals(double d2, double d3, double d4, double d5) {
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(d2)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(d3)) {
            return false;
        }
        if (Double.doubleToLongBits(this.z) != Double.doubleToLongBits(d4)) {
            return false;
        }
        return Double.doubleToLongBits(this.w) == Double.doubleToLongBits(d5);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

