/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PolygonsIntersection {
    private static final ByStartComparator byStartComparator = new ByStartComparator();
    private static final ByEndComparator byEndComparator = new ByEndComparator();
    protected final float[] verticesXY;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private float centerX;
    private float centerY;
    private float radiusSquared;
    private IntervalTreeNode tree;

    public PolygonsIntersection(float[] fArray, int[] nArray, int n2) {
        this.verticesXY = fArray;
        this.preprocess(n2, nArray);
    }

    private IntervalTreeNode buildNode(List list, float f2) {
        ArrayList<Interval> arrayList = null;
        ArrayList<Interval> arrayList2 = null;
        ArrayList<Interval> arrayList3 = null;
        ArrayList<Interval> arrayList4 = null;
        float f3 = 1.0E38f;
        float f4 = -1.0E38f;
        float f5 = 1.0E38f;
        float f6 = -1.0E38f;
        float f7 = 1.0E38f;
        float f8 = -1.0E38f;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Interval interval;
            Interval interval2 = (Interval)list.get(i2);
            if (interval.start < f2 && interval2.end < f2) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Interval>();
                }
                arrayList.add(interval2);
                f3 = f3 < interval2.start ? f3 : interval2.start;
                f4 = f4 > interval2.end ? f4 : interval2.end;
                continue;
            }
            if (interval2.start > f2 && interval2.end > f2) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Interval>();
                }
                arrayList2.add(interval2);
                f5 = f5 < interval2.start ? f5 : interval2.start;
                f6 = f6 > interval2.end ? f6 : interval2.end;
                continue;
            }
            if (arrayList3 == null || arrayList4 == null) {
                arrayList3 = new ArrayList<Interval>();
                arrayList4 = new ArrayList<Interval>();
            }
            f7 = interval2.start < f7 ? interval2.start : f7;
            f8 = interval2.end > f8 ? interval2.end : f8;
            arrayList3.add(interval2);
            arrayList4.add(interval2);
        }
        if (arrayList3 != null) {
            Collections.sort(arrayList3, byStartComparator);
            Collections.sort(arrayList4, byEndComparator);
        }
        IntervalTreeNode intervalTreeNode = new IntervalTreeNode();
        new IntervalTreeNode().byBeginning = arrayList3;
        intervalTreeNode.byEnding = arrayList4;
        intervalTreeNode.center = f2;
        if (arrayList != null) {
            intervalTreeNode.left = this.buildNode(arrayList, (f3 + f4) / 2.0f);
            intervalTreeNode.left.childrenMinMax = f4;
        }
        if (arrayList2 != null) {
            intervalTreeNode.right = this.buildNode(arrayList2, (f5 + f6) / 2.0f);
            intervalTreeNode.right.childrenMinMax = f5;
        }
        return intervalTreeNode;
    }

    private void preprocess(int n2, int[] nArray) {
        float f2;
        float f3;
        int n3 = 0;
        PolygonsIntersection polygonsIntersection = this;
        polygonsIntersection.minY = 1.0E38f;
        polygonsIntersection.minX = 1.0E38f;
        PolygonsIntersection polygonsIntersection2 = this;
        polygonsIntersection2.maxY = -1.0E38f;
        polygonsIntersection2.maxX = -1.0E38f;
        ArrayList<Interval> arrayList = new ArrayList<Interval>(n2);
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        while (n6 < n2) {
            float f4;
            if (nArray != null && nArray.length > n5 && nArray[n5] == n6) {
                f3 = this.verticesXY[2 * (n6 - 1) + 1];
                f4 = this.verticesXY[2 * n4 + 1];
                Interval interval = new Interval();
                new Interval().start = f3 < f4 ? f3 : f4;
                interval.end = f4 > f3 ? f4 : f3;
                interval.i = n6 - 1;
                interval.j = n4;
                interval.polyIndex = n5++;
                arrayList.add(interval);
                n4 = n6++;
                n3 = n6 - 1;
            }
            f3 = this.verticesXY[2 * n6 + 1];
            f4 = this.verticesXY[2 * n6];
            f2 = this.verticesXY[2 * n3 + 1];
            this.minX = f4 < this.minX ? f4 : this.minX;
            this.minY = f3 < this.minY ? f3 : this.minY;
            this.maxX = f4 > this.maxX ? f4 : this.maxX;
            this.maxY = f3 > this.maxY ? f3 : this.maxY;
            Interval interval = new Interval();
            new Interval().start = f3 < f2 ? f3 : f2;
            interval.end = f2 > f3 ? f2 : f3;
            interval.i = n6;
            interval.j = n3;
            interval.polyIndex = n5;
            arrayList.add(interval);
            n3 = n6++;
        }
        f3 = this.verticesXY[2 * (n6 - 1) + 1];
        float f5 = this.verticesXY[2 * (n6 - 1)];
        f2 = this.verticesXY[2 * n4 + 1];
        this.minX = f5 < this.minX ? f5 : this.minX;
        this.minY = f3 < this.minY ? f3 : this.minY;
        this.maxX = f5 > this.maxX ? f5 : this.maxX;
        this.maxY = f3 > this.maxY ? f3 : this.maxY;
        Interval interval = new Interval();
        new Interval().start = f3 < f2 ? f3 : f2;
        interval.end = f2 > f3 ? f2 : f3;
        interval.i = n6 - 1;
        interval.j = n4;
        interval.polyIndex = n5;
        arrayList.add(interval);
        this.centerX = (this.maxX + this.minX) * 0.5f;
        this.centerY = (this.maxY + this.minY) * 0.5f;
        float f6 = this.maxX - this.centerX;
        float f7 = this.maxY - this.centerY;
        float f8 = f6;
        float f9 = f7;
        this.radiusSquared = f8 * f8 + f9 * f9;
        this.tree = this.buildNode(arrayList, this.centerY);
    }

    public boolean testPoint(float f2, float f3) {
        return this.testPoint(f2, f3, null);
    }

    public boolean testPoint(float f2, float f3, BitSet bitSet) {
        float f4 = f2 - this.centerX;
        float f5 = f3 - this.centerY;
        if (bitSet != null) {
            bitSet.clear();
        }
        float f6 = f4;
        float f7 = f5;
        if (f6 * f6 + f7 * f7 > this.radiusSquared) {
            return false;
        }
        if (this.maxX < f2 || this.maxY < f3 || this.minX > f2 || this.minY > f3) {
            return false;
        }
        return this.tree.traverse(this.verticesXY, f2, f3, false, bitSet);
    }

    static class IntervalTreeNode {
        float center;
        float childrenMinMax;
        IntervalTreeNode left;
        IntervalTreeNode right;
        List byBeginning;
        List byEnding;

        IntervalTreeNode() {
        }

        static boolean computeEvenOdd(float[] fArray, Interval interval, float f2, float f3, boolean bl, BitSet bitSet) {
            boolean bl2 = bl;
            int n2 = interval.i;
            int n3 = interval.j;
            float f4 = fArray[2 * n2 + 1];
            float f5 = fArray[2 * n3 + 1];
            float f6 = fArray[2 * n2];
            float f7 = fArray[2 * n3];
            if ((f4 < f3 && f5 >= f3 || f5 < f3 && f4 >= f3) && (f6 <= f2 || f7 <= f2) && (bl2 = bl ^ (f7 = f6 + (f3 - f4) / (f5 - f4) * (f7 - f6) - f2) < 0.0f) != bl && bitSet != null) {
                bitSet.flip(interval.polyIndex);
            }
            return bl2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean traverse(float[] fArray, float f2, float f3, boolean n2, BitSet bitSet) {
            int n3 = n2;
            if (f3 == this.center && this.byBeginning != null) {
                n2 = this.byBeginning.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Interval interval = (Interval)this.byBeginning.get(i2);
                    n3 = IntervalTreeNode.computeEvenOdd(fArray, interval, f2, f3, n3 != 0, bitSet);
                }
                return n3 != 0;
            } else if (f3 < this.center) {
                if (this.left != null && this.left.childrenMinMax >= f3) {
                    n3 = this.left.traverse(fArray, f2, f3, n2 != 0, bitSet);
                }
                if (this.byBeginning == null) return n3 != 0;
                n2 = this.byBeginning.size();
                for (int i3 = 0; i3 < n2; ++i3) {
                    Interval interval = (Interval)this.byBeginning.get(i3);
                    if (interval.start > f3) return n3 != 0;
                    n3 = IntervalTreeNode.computeEvenOdd(fArray, interval, f2, f3, n3 != 0, bitSet);
                }
                return n3 != 0;
            } else {
                if (!(f3 > this.center)) return n3 != 0;
                if (this.right != null && this.right.childrenMinMax <= f3) {
                    n3 = this.right.traverse(fArray, f2, f3, n2 != 0, bitSet);
                }
                if (this.byEnding == null) return n3 != 0;
                n2 = this.byEnding.size();
                for (int i4 = 0; i4 < n2; ++i4) {
                    Interval interval = (Interval)this.byEnding.get(i4);
                    if (interval.end < f3) return n3 != 0;
                    n3 = IntervalTreeNode.computeEvenOdd(fArray, interval, f2, f3, n3 != 0, bitSet);
                }
            }
            return n3 != 0;
        }
    }

    static class Interval {
        float start;
        float end;
        int i;
        int j;
        int polyIndex;

        Interval() {
        }
    }

    static class ByEndComparator
    implements Comparator {
        ByEndComparator() {
        }

        public int compare(Object object, Object object2) {
            object = (Interval)object;
            return Float.compare(((Interval)object2).end, ((Interval)object).end);
        }
    }

    static class ByStartComparator
    implements Comparator {
        ByStartComparator() {
        }

        public int compare(Object object, Object object2) {
            object = (Interval)object;
            object2 = (Interval)object2;
            return Float.compare(((Interval)object).start, ((Interval)object2).start);
        }
    }
}

