/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.joml.ConfigurationException;
import org.joml.Matrix2d;
import org.joml.Matrix2dc;
import org.joml.Matrix2f;
import org.joml.Matrix2fc;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2d;
import org.joml.Matrix3x2dc;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3d;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3f;
import org.joml.Matrix4x3fc;
import org.joml.Options;
import org.joml.Quaternionf;
import org.joml.Vector2L;
import org.joml.Vector2d;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3L;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4L;
import org.joml.Vector4d;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.joml.Vector4i;
import sun.misc.Unsafe;

abstract class MemUtil {
    public static final MemUtil INSTANCE = MemUtil.createInstance();

    MemUtil() {
    }

    private static MemUtil createInstance() {
        MemUtilNIO memUtilNIO;
        try {
            if (Options.NO_UNSAFE && Options.FORCE_UNSAFE) {
                throw new ConfigurationException("Cannot enable both -Djoml.nounsafe and -Djoml.forceUnsafe", null);
            }
            memUtilNIO = Options.NO_UNSAFE ? new MemUtilNIO() : new MemUtilUnsafe();
        }
        catch (Throwable throwable) {
            if (Options.FORCE_UNSAFE) {
                throw new ConfigurationException("Unsafe is not supported but its use was forced via -Djoml.forceUnsafe", throwable);
            }
            memUtilNIO = new MemUtilNIO();
        }
        return memUtilNIO;
    }

    public abstract void put(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void put4x4(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void put4x4(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void put4x4(Matrix4x3d var1, int var2, DoubleBuffer var3);

    public abstract void put4x4(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void put4x4(Matrix3x2f var1, int var2, FloatBuffer var3);

    public abstract void put4x4(Matrix3x2f var1, int var2, ByteBuffer var3);

    public abstract void put4x4(Matrix3x2d var1, int var2, DoubleBuffer var3);

    public abstract void put4x4(Matrix3x2d var1, int var2, ByteBuffer var3);

    public abstract void put3x3(Matrix3x2f var1, int var2, FloatBuffer var3);

    public abstract void put3x3(Matrix3x2f var1, int var2, ByteBuffer var3);

    public abstract void put3x3(Matrix3x2d var1, int var2, DoubleBuffer var3);

    public abstract void put3x3(Matrix3x2d var1, int var2, ByteBuffer var3);

    public abstract void put4x3(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void put4x3(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void put3x4(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void put3x4(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void put3x4(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void put3x4(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void put3x4(Matrix3f var1, int var2, FloatBuffer var3);

    public abstract void put3x4(Matrix3f var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void putTransposed(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void put4x3Transposed(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void put4x3Transposed(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void putTransposed(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix3x2f var1, int var2, FloatBuffer var3);

    public abstract void putTransposed(Matrix3f var1, int var2, FloatBuffer var3);

    public abstract void putTransposed(Matrix3f var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix2f var1, int var2, FloatBuffer var3);

    public abstract void putTransposed(Matrix2f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix4x3d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void putf(Matrix4d var1, int var2, FloatBuffer var3);

    public abstract void putf(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void putf(Matrix4x3d var1, int var2, FloatBuffer var3);

    public abstract void putf(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void put4x3Transposed(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void put4x3Transposed(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void putTransposed(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4x3d var1, int var2, DoubleBuffer var3);

    public abstract void putTransposed(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix3d var1, int var2, DoubleBuffer var3);

    public abstract void putTransposed(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix3x2d var1, int var2, DoubleBuffer var3);

    public abstract void putTransposed(Matrix3x2d var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix2d var1, int var2, DoubleBuffer var3);

    public abstract void putTransposed(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void putfTransposed(Matrix4d var1, int var2, FloatBuffer var3);

    public abstract void putfTransposed(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void putfTransposed(Matrix4x3d var1, int var2, FloatBuffer var3);

    public abstract void putfTransposed(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void putfTransposed(Matrix3d var1, int var2, FloatBuffer var3);

    public abstract void putfTransposed(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void putfTransposed(Matrix3x2d var1, int var2, FloatBuffer var3);

    public abstract void putfTransposed(Matrix3x2d var1, int var2, ByteBuffer var3);

    public abstract void putfTransposed(Matrix2d var1, int var2, FloatBuffer var3);

    public abstract void putfTransposed(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix3f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix3f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix3d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void putf(Matrix3d var1, int var2, FloatBuffer var3);

    public abstract void putf(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix3x2f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix3x2f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix3x2d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix3x2d var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix2f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix2f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix2d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void putf(Matrix2d var1, int var2, FloatBuffer var3);

    public abstract void putf(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void put(Vector4d var1, int var2, DoubleBuffer var3);

    public abstract void put(Vector4d var1, int var2, FloatBuffer var3);

    public abstract void put(Vector4d var1, int var2, ByteBuffer var3);

    public abstract void putf(Vector4d var1, int var2, ByteBuffer var3);

    public abstract void put(Vector4f var1, int var2, FloatBuffer var3);

    public abstract void put(Vector4f var1, int var2, ByteBuffer var3);

    public abstract void put(Vector4i var1, int var2, IntBuffer var3);

    public abstract void put(Vector4i var1, int var2, ByteBuffer var3);

    public abstract void put(Vector4L var1, int var2, LongBuffer var3);

    public abstract void put(Vector4L var1, int var2, ByteBuffer var3);

    public abstract void put(Vector3f var1, int var2, FloatBuffer var3);

    public abstract void put(Vector3f var1, int var2, ByteBuffer var3);

    public abstract void put(Vector3d var1, int var2, DoubleBuffer var3);

    public abstract void put(Vector3d var1, int var2, FloatBuffer var3);

    public abstract void put(Vector3d var1, int var2, ByteBuffer var3);

    public abstract void putf(Vector3d var1, int var2, ByteBuffer var3);

    public abstract void put(Vector3i var1, int var2, IntBuffer var3);

    public abstract void put(Vector3i var1, int var2, ByteBuffer var3);

    public abstract void put(Vector3L var1, int var2, LongBuffer var3);

    public abstract void put(Vector3L var1, int var2, ByteBuffer var3);

    public abstract void put(Vector2f var1, int var2, FloatBuffer var3);

    public abstract void put(Vector2f var1, int var2, ByteBuffer var3);

    public abstract void put(Vector2d var1, int var2, DoubleBuffer var3);

    public abstract void put(Vector2d var1, int var2, ByteBuffer var3);

    public abstract void put(Vector2i var1, int var2, IntBuffer var3);

    public abstract void put(Vector2i var1, int var2, ByteBuffer var3);

    public abstract void put(Vector2L var1, int var2, LongBuffer var3);

    public abstract void put(Vector2L var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void getTransposed(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void getTransposed(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4x3d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void getf(Matrix4d var1, int var2, FloatBuffer var3);

    public abstract void getf(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void getf(Matrix4x3d var1, int var2, FloatBuffer var3);

    public abstract void getf(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix3f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix3f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix3d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix3x2f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix3x2f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix3x2d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix3x2d var1, int var2, ByteBuffer var3);

    public abstract void getf(Matrix3d var1, int var2, FloatBuffer var3);

    public abstract void getf(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix2f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix2f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix2d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void getf(Matrix2d var1, int var2, FloatBuffer var3);

    public abstract void getf(Matrix2d var1, int var2, ByteBuffer var3);

    public abstract void get(Vector4d var1, int var2, DoubleBuffer var3);

    public abstract void get(Vector4d var1, int var2, ByteBuffer var3);

    public abstract void get(Vector4f var1, int var2, FloatBuffer var3);

    public abstract void get(Vector4f var1, int var2, ByteBuffer var3);

    public abstract void get(Vector4i var1, int var2, IntBuffer var3);

    public abstract void get(Vector4i var1, int var2, ByteBuffer var3);

    public abstract void get(Vector4L var1, int var2, LongBuffer var3);

    public abstract void get(Vector4L var1, int var2, ByteBuffer var3);

    public abstract void get(Vector3f var1, int var2, FloatBuffer var3);

    public abstract void get(Vector3f var1, int var2, ByteBuffer var3);

    public abstract void get(Vector3d var1, int var2, DoubleBuffer var3);

    public abstract void get(Vector3d var1, int var2, ByteBuffer var3);

    public abstract void get(Vector3i var1, int var2, IntBuffer var3);

    public abstract void get(Vector3i var1, int var2, ByteBuffer var3);

    public abstract void get(Vector3L var1, int var2, LongBuffer var3);

    public abstract void get(Vector3L var1, int var2, ByteBuffer var3);

    public abstract void get(Vector2f var1, int var2, FloatBuffer var3);

    public abstract void get(Vector2f var1, int var2, ByteBuffer var3);

    public abstract void get(Vector2d var1, int var2, DoubleBuffer var3);

    public abstract void get(Vector2d var1, int var2, ByteBuffer var3);

    public abstract void get(Vector2i var1, int var2, IntBuffer var3);

    public abstract void get(Vector2i var1, int var2, ByteBuffer var3);

    public abstract void get(Vector2L var1, int var2, LongBuffer var3);

    public abstract void get(Vector2L var1, int var2, ByteBuffer var3);

    public abstract void putMatrix3f(Quaternionf var1, int var2, ByteBuffer var3);

    public abstract void putMatrix3f(Quaternionf var1, int var2, FloatBuffer var3);

    public abstract void putMatrix4f(Quaternionf var1, int var2, ByteBuffer var3);

    public abstract void putMatrix4f(Quaternionf var1, int var2, FloatBuffer var3);

    public abstract void putMatrix4x3f(Quaternionf var1, int var2, ByteBuffer var3);

    public abstract void putMatrix4x3f(Quaternionf var1, int var2, FloatBuffer var3);

    public abstract float get(Matrix4f var1, int var2, int var3);

    public abstract Matrix4f set(Matrix4f var1, int var2, int var3, float var4);

    public abstract double get(Matrix4d var1, int var2, int var3);

    public abstract Matrix4d set(Matrix4d var1, int var2, int var3, double var4);

    public abstract float get(Matrix3f var1, int var2, int var3);

    public abstract Matrix3f set(Matrix3f var1, int var2, int var3, float var4);

    public abstract double get(Matrix3d var1, int var2, int var3);

    public abstract Matrix3d set(Matrix3d var1, int var2, int var3, double var4);

    public abstract Vector4f getColumn(Matrix4f var1, int var2, Vector4f var3);

    public abstract Matrix4f setColumn(Vector4f var1, int var2, Matrix4f var3);

    public abstract Matrix4f setColumn(Vector4fc var1, int var2, Matrix4f var3);

    public abstract void copy(Matrix4fc var1, Matrix4f var2);

    public abstract void copy(Matrix4x3fc var1, Matrix4x3f var2);

    public abstract void copy(Matrix4fc var1, Matrix4x3f var2);

    public abstract void copy(Matrix4x3fc var1, Matrix4f var2);

    public abstract void copy(Matrix3fc var1, Matrix3f var2);

    public abstract void copy(Matrix3fc var1, Matrix4f var2);

    public abstract void copy(Matrix4fc var1, Matrix3f var2);

    public abstract void copy(Matrix3fc var1, Matrix4x3f var2);

    public abstract void copy(Matrix3x2fc var1, Matrix3x2f var2);

    public abstract void copy(Matrix3x2dc var1, Matrix3x2d var2);

    public abstract void copy(Matrix2fc var1, Matrix2f var2);

    public abstract void copy(Matrix2dc var1, Matrix2d var2);

    public abstract void copy(Matrix2fc var1, Matrix3f var2);

    public abstract void copy(Matrix3fc var1, Matrix2f var2);

    public abstract void copy(Matrix2fc var1, Matrix3x2f var2);

    public abstract void copy(Matrix3x2fc var1, Matrix2f var2);

    public abstract void copy(Matrix2dc var1, Matrix3d var2);

    public abstract void copy(Matrix3dc var1, Matrix2d var2);

    public abstract void copy(Matrix2dc var1, Matrix3x2d var2);

    public abstract void copy(Matrix3x2dc var1, Matrix2d var2);

    public abstract void copy3x3(Matrix4fc var1, Matrix4f var2);

    public abstract void copy3x3(Matrix4x3fc var1, Matrix4x3f var2);

    public abstract void copy3x3(Matrix3fc var1, Matrix4x3f var2);

    public abstract void copy3x3(Matrix3fc var1, Matrix4f var2);

    public abstract void copy4x3(Matrix4fc var1, Matrix4f var2);

    public abstract void copy4x3(Matrix4x3fc var1, Matrix4f var2);

    public abstract void copy(float[] var1, int var2, Matrix4f var3);

    public abstract void copyTransposed(float[] var1, int var2, Matrix4f var3);

    public abstract void copy(float[] var1, int var2, Matrix3f var3);

    public abstract void copy(float[] var1, int var2, Matrix4x3f var3);

    public abstract void copy(float[] var1, int var2, Matrix3x2f var3);

    public abstract void copy(double[] var1, int var2, Matrix3x2d var3);

    public abstract void copy(float[] var1, int var2, Matrix3x2d var3);

    public abstract void copy(float[] var1, int var2, Matrix2f var3);

    public abstract void copy(double[] var1, int var2, Matrix2d var3);

    public abstract void copy(Matrix4fc var1, float[] var2, int var3);

    public abstract void copy(Matrix3fc var1, float[] var2, int var3);

    public abstract void copy(Matrix4x3fc var1, float[] var2, int var3);

    public abstract void copy(Matrix3x2fc var1, float[] var2, int var3);

    public abstract void copy(Matrix3x2dc var1, double[] var2, int var3);

    public abstract void copy(Matrix2fc var1, float[] var2, int var3);

    public abstract void copy(Matrix2dc var1, double[] var2, int var3);

    public abstract void copy4x4(Matrix4x3fc var1, float[] var2, int var3);

    public abstract void copy4x4(Matrix4x3dc var1, float[] var2, int var3);

    public abstract void copy4x4(Matrix4x3dc var1, double[] var2, int var3);

    public abstract void copy4x4(Matrix3x2fc var1, float[] var2, int var3);

    public abstract void copy4x4(Matrix3x2dc var1, double[] var2, int var3);

    public abstract void copy3x3(Matrix3x2fc var1, float[] var2, int var3);

    public abstract void copy3x3(Matrix3x2dc var1, double[] var2, int var3);

    public abstract void identity(Matrix4f var1);

    public abstract void identity(Matrix4x3f var1);

    public abstract void identity(Matrix3f var1);

    public abstract void identity(Matrix3x2f var1);

    public abstract void identity(Matrix3x2d var1);

    public abstract void identity(Matrix2f var1);

    public abstract void swap(Matrix4f var1, Matrix4f var2);

    public abstract void swap(Matrix4x3f var1, Matrix4x3f var2);

    public abstract void swap(Matrix3f var1, Matrix3f var2);

    public abstract void swap(Matrix2f var1, Matrix2f var2);

    public abstract void swap(Matrix2d var1, Matrix2d var2);

    public abstract void zero(Matrix4f var1);

    public abstract void zero(Matrix4x3f var1);

    public abstract void zero(Matrix3f var1);

    public abstract void zero(Matrix3x2f var1);

    public abstract void zero(Matrix3x2d var1);

    public abstract void zero(Matrix2f var1);

    public abstract void zero(Matrix2d var1);

    public static class MemUtilUnsafe
    extends MemUtilNIO {
        public static final Unsafe UNSAFE = MemUtilUnsafe.getUnsafeInstance();
        public static final long ADDRESS;
        public static final long Matrix2f_m00;
        public static final long Matrix3f_m00;
        public static final long Matrix3d_m00;
        public static final long Matrix4f_m00;
        public static final long Matrix4d_m00;
        public static final long Matrix4x3f_m00;
        public static final long Matrix3x2f_m00;
        public static final long Vector4f_x;
        public static final long Vector4i_x;
        public static final long Vector3f_x;
        public static final long Vector3i_x;
        public static final long Vector2f_x;
        public static final long Vector2i_x;
        public static final long floatArrayOffset;

        private static long findBufferAddress() {
            try {
                return UNSAFE.objectFieldOffset(MemUtilUnsafe.getDeclaredField(Buffer.class, "address"));
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException(exception);
            }
        }

        private static long checkMatrix4f() throws NoSuchFieldException, SecurityException {
            Field field = Matrix4f.class.getDeclaredField("m00");
            long l2 = UNSAFE.objectFieldOffset(field);
            for (int i2 = 1; i2 < 16; ++i2) {
                int n2 = i2 >>> 2;
                int n3 = i2 & 3;
                field = (class$1 == null ? MemUtilUnsafe.class$("org.joml.Matrix4f") : class$1).getDeclaredField("m" + n2 + n3);
                if (UNSAFE.objectFieldOffset(field) == l2 + (long)(i2 << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix4f element offset");
            }
            return l2;
        }

        private static long checkMatrix4d() throws NoSuchFieldException, SecurityException {
            Field field = Matrix4d.class.getDeclaredField("m00");
            long l2 = UNSAFE.objectFieldOffset(field);
            for (int i2 = 1; i2 < 16; ++i2) {
                int n2 = i2 >>> 2;
                int n3 = i2 & 3;
                field = (class$2 == null ? MemUtilUnsafe.class$("org.joml.Matrix4d") : class$2).getDeclaredField("m" + n2 + n3);
                if (UNSAFE.objectFieldOffset(field) == l2 + (long)(i2 << 3)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix4d element offset");
            }
            return l2;
        }

        private static long checkMatrix4x3f() throws NoSuchFieldException, SecurityException {
            Field field = Matrix4x3f.class.getDeclaredField("m00");
            long l2 = UNSAFE.objectFieldOffset(field);
            for (int i2 = 1; i2 < 12; ++i2) {
                int n2 = i2 / 3;
                int n3 = i2 % 3;
                field = (class$3 == null ? MemUtilUnsafe.class$("org.joml.Matrix4x3f") : class$3).getDeclaredField("m" + n2 + n3);
                if (UNSAFE.objectFieldOffset(field) == l2 + (long)(i2 << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix4x3f element offset");
            }
            return l2;
        }

        private static long checkMatrix3f() throws NoSuchFieldException, SecurityException {
            Field field = Matrix3f.class.getDeclaredField("m00");
            long l2 = UNSAFE.objectFieldOffset(field);
            for (int i2 = 1; i2 < 9; ++i2) {
                int n2 = i2 / 3;
                int n3 = i2 % 3;
                field = (class$4 == null ? MemUtilUnsafe.class$("org.joml.Matrix3f") : class$4).getDeclaredField("m" + n2 + n3);
                if (UNSAFE.objectFieldOffset(field) == l2 + (long)(i2 << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix3f element offset");
            }
            return l2;
        }

        private static long checkMatrix3d() throws NoSuchFieldException, SecurityException {
            Field field = Matrix3d.class.getDeclaredField("m00");
            long l2 = UNSAFE.objectFieldOffset(field);
            for (int i2 = 1; i2 < 9; ++i2) {
                int n2 = i2 / 3;
                int n3 = i2 % 3;
                field = (class$5 == null ? MemUtilUnsafe.class$("org.joml.Matrix3d") : class$5).getDeclaredField("m" + n2 + n3);
                if (UNSAFE.objectFieldOffset(field) == l2 + (long)(i2 << 3)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix3d element offset");
            }
            return l2;
        }

        private static long checkMatrix3x2f() throws NoSuchFieldException, SecurityException {
            Field field = Matrix3x2f.class.getDeclaredField("m00");
            long l2 = UNSAFE.objectFieldOffset(field);
            for (int i2 = 1; i2 < 6; ++i2) {
                int n2 = i2 / 2;
                int n3 = i2 % 2;
                field = (class$6 == null ? MemUtilUnsafe.class$("org.joml.Matrix3x2f") : class$6).getDeclaredField("m" + n2 + n3);
                if (UNSAFE.objectFieldOffset(field) == l2 + (long)(i2 << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix3x2f element offset");
            }
            return l2;
        }

        private static long checkMatrix2f() throws NoSuchFieldException, SecurityException {
            Field field = Matrix2f.class.getDeclaredField("m00");
            long l2 = UNSAFE.objectFieldOffset(field);
            for (int i2 = 1; i2 < 4; ++i2) {
                int n2 = i2 / 2;
                int n3 = i2 % 2;
                field = (class$7 == null ? MemUtilUnsafe.class$("org.joml.Matrix2f") : class$7).getDeclaredField("m" + n2 + n3);
                if (UNSAFE.objectFieldOffset(field) == l2 + (long)(i2 << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Matrix2f element offset");
            }
            return l2;
        }

        private static long checkVector4f() throws NoSuchFieldException, SecurityException {
            Field field = Vector4f.class.getDeclaredField("x");
            long l2 = UNSAFE.objectFieldOffset(field);
            String[] stringArray = new String[]{"y", "z", "w"};
            for (int i2 = 1; i2 < 4; ++i2) {
                field = (class$8 == null ? MemUtilUnsafe.class$("org.joml.Vector4f") : class$8).getDeclaredField(stringArray[i2 - 1]);
                if (UNSAFE.objectFieldOffset(field) == l2 + (long)(i2 << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Vector4f element offset");
            }
            return l2;
        }

        private static long checkVector4i() throws NoSuchFieldException, SecurityException {
            Field field = Vector4i.class.getDeclaredField("x");
            long l2 = UNSAFE.objectFieldOffset(field);
            String[] stringArray = new String[]{"y", "z", "w"};
            for (int i2 = 1; i2 < 4; ++i2) {
                field = (class$9 == null ? MemUtilUnsafe.class$("org.joml.Vector4i") : class$9).getDeclaredField(stringArray[i2 - 1]);
                if (UNSAFE.objectFieldOffset(field) == l2 + (long)(i2 << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Vector4i element offset");
            }
            return l2;
        }

        private static long checkVector3f() throws NoSuchFieldException, SecurityException {
            Field field = Vector3f.class.getDeclaredField("x");
            long l2 = UNSAFE.objectFieldOffset(field);
            String[] stringArray = new String[]{"y", "z"};
            for (int i2 = 1; i2 < 3; ++i2) {
                field = (class$10 == null ? MemUtilUnsafe.class$("org.joml.Vector3f") : class$10).getDeclaredField(stringArray[i2 - 1]);
                if (UNSAFE.objectFieldOffset(field) == l2 + (long)(i2 << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Vector3f element offset");
            }
            return l2;
        }

        private static long checkVector3i() throws NoSuchFieldException, SecurityException {
            Field field = Vector3i.class.getDeclaredField("x");
            long l2 = UNSAFE.objectFieldOffset(field);
            String[] stringArray = new String[]{"y", "z"};
            for (int i2 = 1; i2 < 3; ++i2) {
                field = (class$11 == null ? MemUtilUnsafe.class$("org.joml.Vector3i") : class$11).getDeclaredField(stringArray[i2 - 1]);
                if (UNSAFE.objectFieldOffset(field) == l2 + (long)(i2 << 2)) continue;
                throw new UnsupportedOperationException("Unexpected Vector3i element offset");
            }
            return l2;
        }

        private static long checkVector2f() throws NoSuchFieldException, SecurityException {
            Field field = Vector2f.class.getDeclaredField("x");
            long l2 = UNSAFE.objectFieldOffset(field);
            field = Vector2f.class.getDeclaredField("y");
            if (UNSAFE.objectFieldOffset(field) != l2 + 4L) {
                throw new UnsupportedOperationException("Unexpected Vector2f element offset");
            }
            return l2;
        }

        private static long checkVector2i() throws NoSuchFieldException, SecurityException {
            Field field = Vector2i.class.getDeclaredField("x");
            long l2 = UNSAFE.objectFieldOffset(field);
            field = Vector2i.class.getDeclaredField("y");
            if (UNSAFE.objectFieldOffset(field) != l2 + 4L) {
                throw new UnsupportedOperationException("Unexpected Vector2i element offset");
            }
            return l2;
        }

        private static Field getDeclaredField(Class clazz, String string) throws NoSuchFieldException {
            Class clazz2 = clazz;
            do {
                try {
                    return clazz2.getDeclaredField(string);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    clazz2 = clazz2.getSuperclass();
                }
                catch (SecurityException securityException) {
                    clazz2 = clazz2.getSuperclass();
                }
            } while (clazz2 != null);
            throw new NoSuchFieldException(string + " does not exist in " + clazz.getName() + " or any of its superclasses.");
        }

        public static Unsafe getUnsafeInstance() throws SecurityException {
            Field[] fieldArray = Unsafe.class.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                int n2;
                Field field = fieldArray[i2];
                if (!field.getType().equals(class$14 == null ? MemUtilUnsafe.class$("sun.misc.Unsafe") : class$14) || !Modifier.isStatic(n2 = field.getModifiers()) || !Modifier.isFinal(n2)) continue;
                field.setAccessible(true);
                try {
                    return (Unsafe)field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    break;
                }
            }
            throw new UnsupportedOperationException();
        }

        public static void put(Matrix4f matrix4f, long l2) {
            for (int i2 = 0; i2 < 8; ++i2) {
                UNSAFE.putLong(null, l2 + (long)(i2 << 3), UNSAFE.getLong(matrix4f, Matrix4f_m00 + (long)(i2 << 3)));
            }
        }

        public static void put4x3(Matrix4f matrix4f, long l2) {
            Unsafe unsafe = UNSAFE;
            for (int i2 = 0; i2 < 4; ++i2) {
                unsafe.putLong(null, l2 + (long)(i2 * 12), unsafe.getLong(matrix4f, Matrix4f_m00 + (long)(i2 << 4)));
            }
            unsafe.putFloat(null, l2 + 8L, matrix4f.m02());
            unsafe.putFloat(null, l2 + 20L, matrix4f.m12());
            unsafe.putFloat(null, l2 + 32L, matrix4f.m22());
            unsafe.putFloat(null, l2 + 44L, matrix4f.m32());
        }

        public static void put3x4(Matrix4f matrix4f, long l2) {
            for (int i2 = 0; i2 < 6; ++i2) {
                UNSAFE.putLong(null, l2 + (long)(i2 << 3), UNSAFE.getLong(matrix4f, Matrix4f_m00 + (long)(i2 << 3)));
            }
        }

        public static void put(Matrix4x3f matrix4x3f, long l2) {
            for (int i2 = 0; i2 < 6; ++i2) {
                UNSAFE.putLong(null, l2 + (long)(i2 << 3), UNSAFE.getLong(matrix4x3f, Matrix4x3f_m00 + (long)(i2 << 3)));
            }
        }

        public static void put4x4(Matrix4x3f matrix4x3f, long l2) {
            for (int i2 = 0; i2 < 4; ++i2) {
                UNSAFE.putLong(null, l2 + (long)(i2 << 4), UNSAFE.getLong(matrix4x3f, Matrix4x3f_m00 + (long)(i2 * 12)));
                long l3 = (long)UNSAFE.getInt(matrix4x3f, Matrix4x3f_m00 + 8L + (long)(i2 * 12)) & 0xFFFFFFFFL;
                UNSAFE.putLong(null, l2 + 8L + (long)(i2 << 4), l3);
            }
            UNSAFE.putFloat(null, l2 + 60L, 1.0f);
        }

        public static void put3x4(Matrix4x3f matrix4x3f, long l2) {
            for (int i2 = 0; i2 < 3; ++i2) {
                UNSAFE.putLong(null, l2 + (long)(i2 << 4), UNSAFE.getLong(matrix4x3f, Matrix4x3f_m00 + (long)(i2 * 12)));
                UNSAFE.putFloat(null, l2 + (long)(i2 << 4) + 8L, UNSAFE.getFloat(matrix4x3f, Matrix4x3f_m00 + 8L + (long)(i2 * 12)));
                UNSAFE.putFloat(null, l2 + (long)(i2 << 4) + 12L, 0.0f);
            }
        }

        public static void put4x4(Matrix4x3d matrix4x3d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix4x3d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix4x3d.m01());
            unsafe.putDouble(null, l2 + 16L, matrix4x3d.m02());
            unsafe.putDouble(null, l2 + 24L, 0.0);
            unsafe.putDouble(null, l2 + 32L, matrix4x3d.m10());
            unsafe.putDouble(null, l2 + 40L, matrix4x3d.m11());
            unsafe.putDouble(null, l2 + 48L, matrix4x3d.m12());
            unsafe.putDouble(null, l2 + 56L, 0.0);
            unsafe.putDouble(null, l2 + 64L, matrix4x3d.m20());
            unsafe.putDouble(null, l2 + 72L, matrix4x3d.m21());
            unsafe.putDouble(null, l2 + 80L, matrix4x3d.m22());
            unsafe.putDouble(null, l2 + 88L, 0.0);
            unsafe.putDouble(null, l2 + 96L, matrix4x3d.m30());
            unsafe.putDouble(null, l2 + 104L, matrix4x3d.m31());
            unsafe.putDouble(null, l2 + 112L, matrix4x3d.m32());
            unsafe.putDouble(null, l2 + 120L, 1.0);
        }

        public static void put4x4(Matrix3x2f matrix3x2f, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putLong(null, l2, unsafe.getLong(matrix3x2f, Matrix3x2f_m00));
            unsafe.putLong(null, l2 + 8L, 0L);
            unsafe.putLong(null, l2 + 16L, unsafe.getLong(matrix3x2f, Matrix3x2f_m00 + 8L));
            unsafe.putLong(null, l2 + 24L, 0L);
            unsafe.putLong(null, l2 + 32L, 0L);
            unsafe.putLong(null, l2 + 40L, 1065353216L);
            unsafe.putLong(null, l2 + 48L, unsafe.getLong(matrix3x2f, Matrix3x2f_m00 + 16L));
            unsafe.putLong(null, l2 + 56L, 4575657221408423936L);
        }

        public static void put4x4(Matrix3x2d matrix3x2d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix3x2d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix3x2d.m01());
            unsafe.putDouble(null, l2 + 16L, 0.0);
            unsafe.putDouble(null, l2 + 24L, 0.0);
            unsafe.putDouble(null, l2 + 32L, matrix3x2d.m10());
            unsafe.putDouble(null, l2 + 40L, matrix3x2d.m11());
            unsafe.putDouble(null, l2 + 48L, 0.0);
            unsafe.putDouble(null, l2 + 56L, 0.0);
            unsafe.putDouble(null, l2 + 64L, 0.0);
            unsafe.putDouble(null, l2 + 72L, 0.0);
            unsafe.putDouble(null, l2 + 80L, 1.0);
            unsafe.putDouble(null, l2 + 88L, 0.0);
            unsafe.putDouble(null, l2 + 96L, matrix3x2d.m20());
            unsafe.putDouble(null, l2 + 104L, matrix3x2d.m21());
            unsafe.putDouble(null, l2 + 112L, 0.0);
            unsafe.putDouble(null, l2 + 120L, 1.0);
        }

        public static void put3x3(Matrix3x2f matrix3x2f, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putLong(null, l2, unsafe.getLong(matrix3x2f, Matrix3x2f_m00));
            unsafe.putInt(null, l2 + 8L, 0);
            unsafe.putLong(null, l2 + 12L, unsafe.getLong(matrix3x2f, Matrix3x2f_m00 + 8L));
            unsafe.putInt(null, l2 + 20L, 0);
            unsafe.putLong(null, l2 + 24L, unsafe.getLong(matrix3x2f, Matrix3x2f_m00 + 16L));
            unsafe.putFloat(null, l2 + 32L, 1.0f);
        }

        public static void put3x3(Matrix3x2d matrix3x2d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix3x2d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix3x2d.m01());
            unsafe.putDouble(null, l2 + 16L, 0.0);
            unsafe.putDouble(null, l2 + 24L, matrix3x2d.m10());
            unsafe.putDouble(null, l2 + 32L, matrix3x2d.m11());
            unsafe.putDouble(null, l2 + 40L, 0.0);
            unsafe.putDouble(null, l2 + 48L, matrix3x2d.m20());
            unsafe.putDouble(null, l2 + 56L, matrix3x2d.m21());
            unsafe.putDouble(null, l2 + 64L, 1.0);
        }

        public static void putTransposed(Matrix4f matrix4f, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, matrix4f.m00());
            unsafe.putFloat(null, l2 + 4L, matrix4f.m10());
            unsafe.putFloat(null, l2 + 8L, matrix4f.m20());
            unsafe.putFloat(null, l2 + 12L, matrix4f.m30());
            unsafe.putFloat(null, l2 + 16L, matrix4f.m01());
            unsafe.putFloat(null, l2 + 20L, matrix4f.m11());
            unsafe.putFloat(null, l2 + 24L, matrix4f.m21());
            unsafe.putFloat(null, l2 + 28L, matrix4f.m31());
            unsafe.putFloat(null, l2 + 32L, matrix4f.m02());
            unsafe.putFloat(null, l2 + 36L, matrix4f.m12());
            unsafe.putFloat(null, l2 + 40L, matrix4f.m22());
            unsafe.putFloat(null, l2 + 44L, matrix4f.m32());
            unsafe.putFloat(null, l2 + 48L, matrix4f.m03());
            unsafe.putFloat(null, l2 + 52L, matrix4f.m13());
            unsafe.putFloat(null, l2 + 56L, matrix4f.m23());
            unsafe.putFloat(null, l2 + 60L, matrix4f.m33());
        }

        public static void put4x3Transposed(Matrix4f matrix4f, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, matrix4f.m00());
            unsafe.putFloat(null, l2 + 4L, matrix4f.m10());
            unsafe.putFloat(null, l2 + 8L, matrix4f.m20());
            unsafe.putFloat(null, l2 + 12L, matrix4f.m30());
            unsafe.putFloat(null, l2 + 16L, matrix4f.m01());
            unsafe.putFloat(null, l2 + 20L, matrix4f.m11());
            unsafe.putFloat(null, l2 + 24L, matrix4f.m21());
            unsafe.putFloat(null, l2 + 28L, matrix4f.m31());
            unsafe.putFloat(null, l2 + 32L, matrix4f.m02());
            unsafe.putFloat(null, l2 + 36L, matrix4f.m12());
            unsafe.putFloat(null, l2 + 40L, matrix4f.m22());
            unsafe.putFloat(null, l2 + 44L, matrix4f.m32());
        }

        public static void putTransposed(Matrix4x3f matrix4x3f, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, matrix4x3f.m00());
            unsafe.putFloat(null, l2 + 4L, matrix4x3f.m10());
            unsafe.putFloat(null, l2 + 8L, matrix4x3f.m20());
            unsafe.putFloat(null, l2 + 12L, matrix4x3f.m30());
            unsafe.putFloat(null, l2 + 16L, matrix4x3f.m01());
            unsafe.putFloat(null, l2 + 20L, matrix4x3f.m11());
            unsafe.putFloat(null, l2 + 24L, matrix4x3f.m21());
            unsafe.putFloat(null, l2 + 28L, matrix4x3f.m31());
            unsafe.putFloat(null, l2 + 32L, matrix4x3f.m02());
            unsafe.putFloat(null, l2 + 36L, matrix4x3f.m12());
            unsafe.putFloat(null, l2 + 40L, matrix4x3f.m22());
            unsafe.putFloat(null, l2 + 44L, matrix4x3f.m32());
        }

        public static void putTransposed(Matrix3f matrix3f, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, matrix3f.m00());
            unsafe.putFloat(null, l2 + 4L, matrix3f.m10());
            unsafe.putFloat(null, l2 + 8L, matrix3f.m20());
            unsafe.putFloat(null, l2 + 12L, matrix3f.m01());
            unsafe.putFloat(null, l2 + 16L, matrix3f.m11());
            unsafe.putFloat(null, l2 + 20L, matrix3f.m21());
            unsafe.putFloat(null, l2 + 24L, matrix3f.m02());
            unsafe.putFloat(null, l2 + 28L, matrix3f.m12());
            unsafe.putFloat(null, l2 + 32L, matrix3f.m22());
        }

        public static void putTransposed(Matrix3x2f matrix3x2f, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, matrix3x2f.m00());
            unsafe.putFloat(null, l2 + 4L, matrix3x2f.m10());
            unsafe.putFloat(null, l2 + 8L, matrix3x2f.m20());
            unsafe.putFloat(null, l2 + 12L, matrix3x2f.m01());
            unsafe.putFloat(null, l2 + 16L, matrix3x2f.m11());
            unsafe.putFloat(null, l2 + 20L, matrix3x2f.m21());
        }

        public static void putTransposed(Matrix2f matrix2f, long l2) {
            UNSAFE.putFloat(null, l2, matrix2f.m00());
            UNSAFE.putFloat(null, l2 + 4L, matrix2f.m10());
            UNSAFE.putFloat(null, l2 + 8L, matrix2f.m01());
            UNSAFE.putFloat(null, l2 + 12L, matrix2f.m11());
        }

        public static void put(Matrix4d matrix4d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix4d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix4d.m01());
            unsafe.putDouble(null, l2 + 16L, matrix4d.m02());
            unsafe.putDouble(null, l2 + 24L, matrix4d.m03());
            unsafe.putDouble(null, l2 + 32L, matrix4d.m10());
            unsafe.putDouble(null, l2 + 40L, matrix4d.m11());
            unsafe.putDouble(null, l2 + 48L, matrix4d.m12());
            unsafe.putDouble(null, l2 + 56L, matrix4d.m13());
            unsafe.putDouble(null, l2 + 64L, matrix4d.m20());
            unsafe.putDouble(null, l2 + 72L, matrix4d.m21());
            unsafe.putDouble(null, l2 + 80L, matrix4d.m22());
            unsafe.putDouble(null, l2 + 88L, matrix4d.m23());
            unsafe.putDouble(null, l2 + 96L, matrix4d.m30());
            unsafe.putDouble(null, l2 + 104L, matrix4d.m31());
            unsafe.putDouble(null, l2 + 112L, matrix4d.m32());
            unsafe.putDouble(null, l2 + 120L, matrix4d.m33());
        }

        public static void put(Matrix4x3d matrix4x3d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix4x3d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix4x3d.m01());
            unsafe.putDouble(null, l2 + 16L, matrix4x3d.m02());
            unsafe.putDouble(null, l2 + 24L, matrix4x3d.m10());
            unsafe.putDouble(null, l2 + 32L, matrix4x3d.m11());
            unsafe.putDouble(null, l2 + 40L, matrix4x3d.m12());
            unsafe.putDouble(null, l2 + 48L, matrix4x3d.m20());
            unsafe.putDouble(null, l2 + 56L, matrix4x3d.m21());
            unsafe.putDouble(null, l2 + 64L, matrix4x3d.m22());
            unsafe.putDouble(null, l2 + 72L, matrix4x3d.m30());
            unsafe.putDouble(null, l2 + 80L, matrix4x3d.m31());
            unsafe.putDouble(null, l2 + 88L, matrix4x3d.m32());
        }

        public static void putTransposed(Matrix4d matrix4d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix4d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix4d.m10());
            unsafe.putDouble(null, l2 + 16L, matrix4d.m20());
            unsafe.putDouble(null, l2 + 24L, matrix4d.m30());
            unsafe.putDouble(null, l2 + 32L, matrix4d.m01());
            unsafe.putDouble(null, l2 + 40L, matrix4d.m11());
            unsafe.putDouble(null, l2 + 48L, matrix4d.m21());
            unsafe.putDouble(null, l2 + 56L, matrix4d.m31());
            unsafe.putDouble(null, l2 + 64L, matrix4d.m02());
            unsafe.putDouble(null, l2 + 72L, matrix4d.m12());
            unsafe.putDouble(null, l2 + 80L, matrix4d.m22());
            unsafe.putDouble(null, l2 + 88L, matrix4d.m32());
            unsafe.putDouble(null, l2 + 96L, matrix4d.m03());
            unsafe.putDouble(null, l2 + 104L, matrix4d.m13());
            unsafe.putDouble(null, l2 + 112L, matrix4d.m23());
            unsafe.putDouble(null, l2 + 120L, matrix4d.m33());
        }

        public static void putfTransposed(Matrix4d matrix4d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, (float)matrix4d.m00());
            unsafe.putFloat(null, l2 + 4L, (float)matrix4d.m10());
            unsafe.putFloat(null, l2 + 8L, (float)matrix4d.m20());
            unsafe.putFloat(null, l2 + 12L, (float)matrix4d.m30());
            unsafe.putFloat(null, l2 + 16L, (float)matrix4d.m01());
            unsafe.putFloat(null, l2 + 20L, (float)matrix4d.m11());
            unsafe.putFloat(null, l2 + 24L, (float)matrix4d.m21());
            unsafe.putFloat(null, l2 + 28L, (float)matrix4d.m31());
            unsafe.putFloat(null, l2 + 32L, (float)matrix4d.m02());
            unsafe.putFloat(null, l2 + 36L, (float)matrix4d.m12());
            unsafe.putFloat(null, l2 + 40L, (float)matrix4d.m22());
            unsafe.putFloat(null, l2 + 44L, (float)matrix4d.m32());
            unsafe.putFloat(null, l2 + 48L, (float)matrix4d.m03());
            unsafe.putFloat(null, l2 + 52L, (float)matrix4d.m13());
            unsafe.putFloat(null, l2 + 56L, (float)matrix4d.m23());
            unsafe.putFloat(null, l2 + 60L, (float)matrix4d.m33());
        }

        public static void put4x3Transposed(Matrix4d matrix4d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix4d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix4d.m10());
            unsafe.putDouble(null, l2 + 16L, matrix4d.m20());
            unsafe.putDouble(null, l2 + 24L, matrix4d.m30());
            unsafe.putDouble(null, l2 + 32L, matrix4d.m01());
            unsafe.putDouble(null, l2 + 40L, matrix4d.m11());
            unsafe.putDouble(null, l2 + 48L, matrix4d.m21());
            unsafe.putDouble(null, l2 + 56L, matrix4d.m31());
            unsafe.putDouble(null, l2 + 64L, matrix4d.m02());
            unsafe.putDouble(null, l2 + 72L, matrix4d.m12());
            unsafe.putDouble(null, l2 + 80L, matrix4d.m22());
            unsafe.putDouble(null, l2 + 88L, matrix4d.m32());
        }

        public static void putTransposed(Matrix4x3d matrix4x3d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix4x3d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix4x3d.m10());
            unsafe.putDouble(null, l2 + 16L, matrix4x3d.m20());
            unsafe.putDouble(null, l2 + 24L, matrix4x3d.m30());
            unsafe.putDouble(null, l2 + 32L, matrix4x3d.m01());
            unsafe.putDouble(null, l2 + 40L, matrix4x3d.m11());
            unsafe.putDouble(null, l2 + 48L, matrix4x3d.m21());
            unsafe.putDouble(null, l2 + 56L, matrix4x3d.m31());
            unsafe.putDouble(null, l2 + 64L, matrix4x3d.m02());
            unsafe.putDouble(null, l2 + 72L, matrix4x3d.m12());
            unsafe.putDouble(null, l2 + 80L, matrix4x3d.m22());
            unsafe.putDouble(null, l2 + 88L, matrix4x3d.m32());
        }

        public static void putTransposed(Matrix3d matrix3d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix3d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix3d.m10());
            unsafe.putDouble(null, l2 + 16L, matrix3d.m20());
            unsafe.putDouble(null, l2 + 24L, matrix3d.m01());
            unsafe.putDouble(null, l2 + 32L, matrix3d.m11());
            unsafe.putDouble(null, l2 + 40L, matrix3d.m21());
            unsafe.putDouble(null, l2 + 48L, matrix3d.m02());
            unsafe.putDouble(null, l2 + 56L, matrix3d.m12());
            unsafe.putDouble(null, l2 + 64L, matrix3d.m22());
        }

        public static void putTransposed(Matrix3x2d matrix3x2d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix3x2d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix3x2d.m10());
            unsafe.putDouble(null, l2 + 16L, matrix3x2d.m20());
            unsafe.putDouble(null, l2 + 24L, matrix3x2d.m01());
            unsafe.putDouble(null, l2 + 32L, matrix3x2d.m11());
            unsafe.putDouble(null, l2 + 40L, matrix3x2d.m21());
        }

        public static void putTransposed(Matrix2d matrix2d, long l2) {
            UNSAFE.putDouble(null, l2, matrix2d.m00());
            UNSAFE.putDouble(null, l2 + 8L, matrix2d.m10());
            UNSAFE.putDouble(null, l2 + 16L, matrix2d.m10());
            UNSAFE.putDouble(null, l2 + 24L, matrix2d.m10());
        }

        public static void putfTransposed(Matrix4x3d matrix4x3d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, (float)matrix4x3d.m00());
            unsafe.putFloat(null, l2 + 4L, (float)matrix4x3d.m10());
            unsafe.putFloat(null, l2 + 8L, (float)matrix4x3d.m20());
            unsafe.putFloat(null, l2 + 12L, (float)matrix4x3d.m30());
            unsafe.putFloat(null, l2 + 16L, (float)matrix4x3d.m01());
            unsafe.putFloat(null, l2 + 20L, (float)matrix4x3d.m11());
            unsafe.putFloat(null, l2 + 24L, (float)matrix4x3d.m21());
            unsafe.putFloat(null, l2 + 28L, (float)matrix4x3d.m31());
            unsafe.putFloat(null, l2 + 32L, (float)matrix4x3d.m02());
            unsafe.putFloat(null, l2 + 36L, (float)matrix4x3d.m12());
            unsafe.putFloat(null, l2 + 40L, (float)matrix4x3d.m22());
            unsafe.putFloat(null, l2 + 44L, (float)matrix4x3d.m32());
        }

        public static void putfTransposed(Matrix3d matrix3d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, (float)matrix3d.m00());
            unsafe.putFloat(null, l2 + 4L, (float)matrix3d.m10());
            unsafe.putFloat(null, l2 + 8L, (float)matrix3d.m20());
            unsafe.putFloat(null, l2 + 12L, (float)matrix3d.m01());
            unsafe.putFloat(null, l2 + 16L, (float)matrix3d.m11());
            unsafe.putFloat(null, l2 + 20L, (float)matrix3d.m21());
            unsafe.putFloat(null, l2 + 24L, (float)matrix3d.m02());
            unsafe.putFloat(null, l2 + 28L, (float)matrix3d.m12());
            unsafe.putFloat(null, l2 + 32L, (float)matrix3d.m22());
        }

        public static void putfTransposed(Matrix3x2d matrix3x2d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, (float)matrix3x2d.m00());
            unsafe.putFloat(null, l2 + 4L, (float)matrix3x2d.m10());
            unsafe.putFloat(null, l2 + 8L, (float)matrix3x2d.m20());
            unsafe.putFloat(null, l2 + 12L, (float)matrix3x2d.m01());
            unsafe.putFloat(null, l2 + 16L, (float)matrix3x2d.m11());
            unsafe.putFloat(null, l2 + 20L, (float)matrix3x2d.m21());
        }

        public static void putfTransposed(Matrix2d matrix2d, long l2) {
            UNSAFE.putFloat(null, l2, (float)matrix2d.m00());
            UNSAFE.putFloat(null, l2 + 4L, (float)matrix2d.m00());
            UNSAFE.putFloat(null, l2 + 8L, (float)matrix2d.m00());
            UNSAFE.putFloat(null, l2 + 12L, (float)matrix2d.m00());
        }

        public static void putf(Matrix4d matrix4d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, (float)matrix4d.m00());
            unsafe.putFloat(null, l2 + 4L, (float)matrix4d.m01());
            unsafe.putFloat(null, l2 + 8L, (float)matrix4d.m02());
            unsafe.putFloat(null, l2 + 12L, (float)matrix4d.m03());
            unsafe.putFloat(null, l2 + 16L, (float)matrix4d.m10());
            unsafe.putFloat(null, l2 + 20L, (float)matrix4d.m11());
            unsafe.putFloat(null, l2 + 24L, (float)matrix4d.m12());
            unsafe.putFloat(null, l2 + 28L, (float)matrix4d.m13());
            unsafe.putFloat(null, l2 + 32L, (float)matrix4d.m20());
            unsafe.putFloat(null, l2 + 36L, (float)matrix4d.m21());
            unsafe.putFloat(null, l2 + 40L, (float)matrix4d.m22());
            unsafe.putFloat(null, l2 + 44L, (float)matrix4d.m23());
            unsafe.putFloat(null, l2 + 48L, (float)matrix4d.m30());
            unsafe.putFloat(null, l2 + 52L, (float)matrix4d.m31());
            unsafe.putFloat(null, l2 + 56L, (float)matrix4d.m32());
            unsafe.putFloat(null, l2 + 60L, (float)matrix4d.m33());
        }

        public static void putf(Matrix4x3d matrix4x3d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, (float)matrix4x3d.m00());
            unsafe.putFloat(null, l2 + 4L, (float)matrix4x3d.m01());
            unsafe.putFloat(null, l2 + 8L, (float)matrix4x3d.m02());
            unsafe.putFloat(null, l2 + 12L, (float)matrix4x3d.m10());
            unsafe.putFloat(null, l2 + 16L, (float)matrix4x3d.m11());
            unsafe.putFloat(null, l2 + 20L, (float)matrix4x3d.m12());
            unsafe.putFloat(null, l2 + 24L, (float)matrix4x3d.m20());
            unsafe.putFloat(null, l2 + 28L, (float)matrix4x3d.m21());
            unsafe.putFloat(null, l2 + 32L, (float)matrix4x3d.m22());
            unsafe.putFloat(null, l2 + 36L, (float)matrix4x3d.m30());
            unsafe.putFloat(null, l2 + 40L, (float)matrix4x3d.m31());
            unsafe.putFloat(null, l2 + 44L, (float)matrix4x3d.m32());
        }

        public static void put(Matrix3f matrix3f, long l2) {
            for (int i2 = 0; i2 < 4; ++i2) {
                UNSAFE.putLong(null, l2 + (long)(i2 << 3), UNSAFE.getLong(matrix3f, Matrix3f_m00 + (long)(i2 << 3)));
            }
            UNSAFE.putFloat(null, l2 + 32L, matrix3f.m22());
        }

        public static void put3x4(Matrix3f matrix3f, long l2) {
            for (int i2 = 0; i2 < 3; ++i2) {
                UNSAFE.putLong(null, l2 + (long)(i2 << 4), UNSAFE.getLong(matrix3f, Matrix3f_m00 + (long)(i2 * 12)));
                UNSAFE.putFloat(null, l2 + (long)(i2 << 4) + 8L, UNSAFE.getFloat(matrix3f, Matrix3f_m00 + 8L + (long)(i2 * 12)));
                UNSAFE.putFloat(null, l2 + (long)(i2 << 4) + 12L, 0.0f);
            }
        }

        public static void put(Matrix3d matrix3d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix3d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix3d.m01());
            unsafe.putDouble(null, l2 + 16L, matrix3d.m02());
            unsafe.putDouble(null, l2 + 24L, matrix3d.m10());
            unsafe.putDouble(null, l2 + 32L, matrix3d.m11());
            unsafe.putDouble(null, l2 + 40L, matrix3d.m12());
            unsafe.putDouble(null, l2 + 48L, matrix3d.m20());
            unsafe.putDouble(null, l2 + 56L, matrix3d.m21());
            unsafe.putDouble(null, l2 + 64L, matrix3d.m22());
        }

        public static void put(Matrix3x2f matrix3x2f, long l2) {
            for (int i2 = 0; i2 < 3; ++i2) {
                UNSAFE.putLong(null, l2 + (long)(i2 << 3), UNSAFE.getLong(matrix3x2f, Matrix3x2f_m00 + (long)(i2 << 3)));
            }
        }

        public static void put(Matrix3x2d matrix3x2d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putDouble(null, l2, matrix3x2d.m00());
            unsafe.putDouble(null, l2 + 8L, matrix3x2d.m01());
            unsafe.putDouble(null, l2 + 16L, matrix3x2d.m10());
            unsafe.putDouble(null, l2 + 24L, matrix3x2d.m11());
            unsafe.putDouble(null, l2 + 32L, matrix3x2d.m20());
            unsafe.putDouble(null, l2 + 40L, matrix3x2d.m21());
        }

        public static void putf(Matrix3d matrix3d, long l2) {
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, (float)matrix3d.m00());
            unsafe.putFloat(null, l2 + 4L, (float)matrix3d.m01());
            unsafe.putFloat(null, l2 + 8L, (float)matrix3d.m02());
            unsafe.putFloat(null, l2 + 12L, (float)matrix3d.m10());
            unsafe.putFloat(null, l2 + 16L, (float)matrix3d.m11());
            unsafe.putFloat(null, l2 + 20L, (float)matrix3d.m12());
            unsafe.putFloat(null, l2 + 24L, (float)matrix3d.m20());
            unsafe.putFloat(null, l2 + 28L, (float)matrix3d.m21());
            unsafe.putFloat(null, l2 + 32L, (float)matrix3d.m22());
        }

        public static void put(Matrix2f matrix2f, long l2) {
            UNSAFE.putLong(null, l2, UNSAFE.getLong(matrix2f, Matrix2f_m00));
            UNSAFE.putLong(null, l2 + 8L, UNSAFE.getLong(matrix2f, Matrix2f_m00 + 8L));
        }

        public static void put(Matrix2d matrix2d, long l2) {
            UNSAFE.putDouble(null, l2, matrix2d.m00());
            UNSAFE.putDouble(null, l2 + 8L, matrix2d.m01());
            UNSAFE.putDouble(null, l2 + 16L, matrix2d.m10());
            UNSAFE.putDouble(null, l2 + 24L, matrix2d.m11());
        }

        public static void putf(Matrix2d matrix2d, long l2) {
            UNSAFE.putFloat(null, l2, (float)matrix2d.m00());
            UNSAFE.putFloat(null, l2 + 4L, (float)matrix2d.m01());
            UNSAFE.putFloat(null, l2 + 8L, (float)matrix2d.m10());
            UNSAFE.putFloat(null, l2 + 12L, (float)matrix2d.m11());
        }

        public static void put(Vector4d vector4d, long l2) {
            UNSAFE.putDouble(null, l2, vector4d.x);
            UNSAFE.putDouble(null, l2 + 8L, vector4d.y);
            UNSAFE.putDouble(null, l2 + 16L, vector4d.z);
            UNSAFE.putDouble(null, l2 + 24L, vector4d.w);
        }

        public static void putf(Vector4d vector4d, long l2) {
            UNSAFE.putFloat(null, l2, (float)vector4d.x);
            UNSAFE.putFloat(null, l2 + 4L, (float)vector4d.y);
            UNSAFE.putFloat(null, l2 + 8L, (float)vector4d.z);
            UNSAFE.putFloat(null, l2 + 12L, (float)vector4d.w);
        }

        public static void put(Vector4f vector4f, long l2) {
            UNSAFE.putLong(null, l2, UNSAFE.getLong(vector4f, Vector4f_x));
            UNSAFE.putLong(null, l2 + 8L, UNSAFE.getLong(vector4f, Vector4f_x + 8L));
        }

        public static void put(Vector4i vector4i, long l2) {
            UNSAFE.putLong(null, l2, UNSAFE.getLong(vector4i, Vector4i_x));
            UNSAFE.putLong(null, l2 + 8L, UNSAFE.getLong(vector4i, Vector4i_x + 8L));
        }

        public static void put(Vector4L vector4L, long l2) {
            UNSAFE.putLong(null, l2, vector4L.x);
            UNSAFE.putLong(null, l2 + 8L, vector4L.y);
            UNSAFE.putLong(null, l2 + 16L, vector4L.z);
            UNSAFE.putLong(null, l2 + 24L, vector4L.w);
        }

        public static void put(Vector3f vector3f, long l2) {
            UNSAFE.putLong(null, l2, UNSAFE.getLong(vector3f, Vector3f_x));
            UNSAFE.putFloat(null, l2 + 8L, vector3f.z);
        }

        public static void put(Vector3d vector3d, long l2) {
            UNSAFE.putDouble(null, l2, vector3d.x);
            UNSAFE.putDouble(null, l2 + 8L, vector3d.y);
            UNSAFE.putDouble(null, l2 + 16L, vector3d.z);
        }

        public static void putf(Vector3d vector3d, long l2) {
            UNSAFE.putFloat(null, l2, (float)vector3d.x);
            UNSAFE.putFloat(null, l2 + 4L, (float)vector3d.y);
            UNSAFE.putFloat(null, l2 + 8L, (float)vector3d.z);
        }

        public static void put(Vector3i vector3i, long l2) {
            UNSAFE.putLong(null, l2, UNSAFE.getLong(vector3i, Vector3i_x));
            UNSAFE.putInt(null, l2 + 8L, vector3i.z);
        }

        public static void put(Vector3L vector3L, long l2) {
            UNSAFE.putLong(null, l2, vector3L.x);
            UNSAFE.putLong(null, l2 + 8L, vector3L.y);
            UNSAFE.putLong(null, l2 + 16L, vector3L.z);
        }

        public static void put(Vector2f vector2f, long l2) {
            UNSAFE.putLong(null, l2, UNSAFE.getLong(vector2f, Vector2f_x));
        }

        public static void put(Vector2d vector2d, long l2) {
            UNSAFE.putDouble(null, l2, vector2d.x);
            UNSAFE.putDouble(null, l2 + 8L, vector2d.y);
        }

        public static void put(Vector2i vector2i, long l2) {
            UNSAFE.putLong(null, l2, UNSAFE.getLong(vector2i, Vector2i_x));
        }

        public static void put(Vector2L vector2L, long l2) {
            UNSAFE.putLong(null, l2, vector2L.x);
            UNSAFE.putLong(null, l2 + 8L, vector2L.y);
        }

        public static void get(Matrix4f matrix4f, long l2) {
            for (int i2 = 0; i2 < 8; ++i2) {
                UNSAFE.putLong(matrix4f, Matrix4f_m00 + (long)(i2 << 3), UNSAFE.getLong(l2 + (long)(i2 << 3)));
            }
        }

        public static void getTransposed(Matrix4f matrix4f, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix4f._m00(unsafe.getFloat(l2))._m10(unsafe.getFloat(l2 + 4L))._m20(unsafe.getFloat(l2 + 8L))._m30(unsafe.getFloat(l2 + 12L))._m01(unsafe.getFloat(l2 + 16L))._m11(unsafe.getFloat(l2 + 20L))._m21(unsafe.getFloat(l2 + 24L))._m31(unsafe.getFloat(l2 + 28L))._m02(unsafe.getFloat(l2 + 32L))._m12(unsafe.getFloat(l2 + 36L))._m22(unsafe.getFloat(l2 + 40L))._m32(unsafe.getFloat(l2 + 44L))._m03(unsafe.getFloat(l2 + 48L))._m13(unsafe.getFloat(l2 + 52L))._m23(unsafe.getFloat(l2 + 56L))._m33(unsafe.getFloat(l2 + 60L));
        }

        public static void getTransposed(Matrix3f matrix3f, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix3f._m00(unsafe.getFloat(l2))._m10(unsafe.getFloat(l2 + 4L))._m20(unsafe.getFloat(l2 + 8L))._m01(unsafe.getFloat(l2 + 12L))._m11(unsafe.getFloat(l2 + 16L))._m21(unsafe.getFloat(l2 + 20L))._m02(unsafe.getFloat(l2 + 24L))._m12(unsafe.getFloat(l2 + 28L))._m22(unsafe.getFloat(l2 + 32L));
        }

        public static void getTransposed(Matrix4x3f matrix4x3f, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix4x3f._m00(unsafe.getFloat(l2))._m10(unsafe.getFloat(l2 + 4L))._m20(unsafe.getFloat(l2 + 8L))._m30(unsafe.getFloat(l2 + 12L))._m01(unsafe.getFloat(l2 + 16L))._m11(unsafe.getFloat(l2 + 20L))._m21(unsafe.getFloat(l2 + 24L))._m31(unsafe.getFloat(l2 + 28L))._m02(unsafe.getFloat(l2 + 32L))._m12(unsafe.getFloat(l2 + 36L))._m22(unsafe.getFloat(l2 + 40L))._m32(unsafe.getFloat(l2 + 44L));
        }

        public static void getTransposed(Matrix3x2f matrix3x2f, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix3x2f._m00(unsafe.getFloat(l2))._m10(unsafe.getFloat(l2 + 4L))._m20(unsafe.getFloat(l2 + 8L))._m01(unsafe.getFloat(l2 + 12L))._m11(unsafe.getFloat(l2 + 16L))._m21(unsafe.getFloat(l2 + 20L));
        }

        public static void getTransposed(Matrix2f matrix2f, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix2f._m00(unsafe.getFloat(l2))._m10(unsafe.getFloat(l2 + 4L))._m01(unsafe.getFloat(l2 + 8L))._m11(unsafe.getFloat(l2 + 12L));
        }

        public static void getTransposed(Matrix2d matrix2d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix2d._m00(unsafe.getDouble(l2))._m10(unsafe.getDouble(l2 + 8L))._m01(unsafe.getDouble(l2 + 16L))._m11(unsafe.getDouble(l2 + 24L));
        }

        public static void getTransposed(Matrix4x3d matrix4x3d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix4x3d._m00(unsafe.getDouble(l2))._m10(unsafe.getDouble(l2 + 8L))._m20(unsafe.getDouble(l2 + 16L))._m30(unsafe.getDouble(l2 + 24L))._m01(unsafe.getDouble(l2 + 32L))._m11(unsafe.getDouble(l2 + 40L))._m21(unsafe.getDouble(l2 + 48L))._m31(unsafe.getDouble(l2 + 56L))._m02(unsafe.getDouble(l2 + 64L))._m12(unsafe.getDouble(l2 + 72L))._m22(unsafe.getDouble(l2 + 80L))._m32(unsafe.getDouble(l2 + 88L));
        }

        public static void getTransposed(Matrix3x2d matrix3x2d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix3x2d._m00(unsafe.getDouble(l2))._m10(unsafe.getDouble(l2 + 8L))._m20(unsafe.getDouble(l2 + 16L))._m01(unsafe.getDouble(l2 + 24L))._m11(unsafe.getDouble(l2 + 32L))._m21(unsafe.getDouble(l2 + 40L));
        }

        public static void getTransposed(Matrix3d matrix3d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix3d._m00(unsafe.getDouble(l2))._m10(unsafe.getDouble(l2 + 8L))._m20(unsafe.getDouble(l2 + 16L))._m01(unsafe.getDouble(l2 + 24L))._m11(unsafe.getDouble(l2 + 32L))._m21(unsafe.getDouble(l2 + 40L))._m02(unsafe.getDouble(l2 + 48L))._m12(unsafe.getDouble(l2 + 56L))._m22(unsafe.getDouble(l2 + 64L));
        }

        public static void getTransposed(Matrix4d matrix4d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix4d._m00(unsafe.getDouble(l2))._m10(unsafe.getDouble(l2 + 8L))._m20(unsafe.getDouble(l2 + 16L))._m30(unsafe.getDouble(l2 + 24L))._m01(unsafe.getDouble(l2 + 32L))._m11(unsafe.getDouble(l2 + 40L))._m21(unsafe.getDouble(l2 + 48L))._m31(unsafe.getDouble(l2 + 56L))._m02(unsafe.getDouble(l2 + 64L))._m12(unsafe.getDouble(l2 + 72L))._m22(unsafe.getDouble(l2 + 80L))._m32(unsafe.getDouble(l2 + 88L))._m03(unsafe.getDouble(l2 + 96L))._m13(unsafe.getDouble(l2 + 104L))._m23(unsafe.getDouble(l2 + 112L))._m33(unsafe.getDouble(l2 + 120L));
        }

        public static void get(Matrix4x3f matrix4x3f, long l2) {
            for (int i2 = 0; i2 < 6; ++i2) {
                UNSAFE.putLong(matrix4x3f, Matrix4x3f_m00 + (long)(i2 << 3), UNSAFE.getLong(l2 + (long)(i2 << 3)));
            }
        }

        public static void get(Matrix4d matrix4d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix4d._m00(unsafe.getDouble(null, l2))._m01(unsafe.getDouble(null, l2 + 8L))._m02(unsafe.getDouble(null, l2 + 16L))._m03(unsafe.getDouble(null, l2 + 24L))._m10(unsafe.getDouble(null, l2 + 32L))._m11(unsafe.getDouble(null, l2 + 40L))._m12(unsafe.getDouble(null, l2 + 48L))._m13(unsafe.getDouble(null, l2 + 56L))._m20(unsafe.getDouble(null, l2 + 64L))._m21(unsafe.getDouble(null, l2 + 72L))._m22(unsafe.getDouble(null, l2 + 80L))._m23(unsafe.getDouble(null, l2 + 88L))._m30(unsafe.getDouble(null, l2 + 96L))._m31(unsafe.getDouble(null, l2 + 104L))._m32(unsafe.getDouble(null, l2 + 112L))._m33(unsafe.getDouble(null, l2 + 120L));
        }

        public static void get(Matrix4x3d matrix4x3d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix4x3d._m00(unsafe.getDouble(null, l2))._m01(unsafe.getDouble(null, l2 + 8L))._m02(unsafe.getDouble(null, l2 + 16L))._m10(unsafe.getDouble(null, l2 + 24L))._m11(unsafe.getDouble(null, l2 + 32L))._m12(unsafe.getDouble(null, l2 + 40L))._m20(unsafe.getDouble(null, l2 + 48L))._m21(unsafe.getDouble(null, l2 + 56L))._m22(unsafe.getDouble(null, l2 + 64L))._m30(unsafe.getDouble(null, l2 + 72L))._m31(unsafe.getDouble(null, l2 + 80L))._m32(unsafe.getDouble(null, l2 + 88L));
        }

        public static void getf(Matrix4d matrix4d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix4d._m00(unsafe.getFloat(null, l2))._m01(unsafe.getFloat(null, l2 + 4L))._m02(unsafe.getFloat(null, l2 + 8L))._m03(unsafe.getFloat(null, l2 + 12L))._m10(unsafe.getFloat(null, l2 + 16L))._m11(unsafe.getFloat(null, l2 + 20L))._m12(unsafe.getFloat(null, l2 + 24L))._m13(unsafe.getFloat(null, l2 + 28L))._m20(unsafe.getFloat(null, l2 + 32L))._m21(unsafe.getFloat(null, l2 + 36L))._m22(unsafe.getFloat(null, l2 + 40L))._m23(unsafe.getFloat(null, l2 + 44L))._m30(unsafe.getFloat(null, l2 + 48L))._m31(unsafe.getFloat(null, l2 + 52L))._m32(unsafe.getFloat(null, l2 + 56L))._m33(unsafe.getFloat(null, l2 + 60L));
        }

        public static void getf(Matrix4x3d matrix4x3d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix4x3d._m00(unsafe.getFloat(null, l2))._m01(unsafe.getFloat(null, l2 + 4L))._m02(unsafe.getFloat(null, l2 + 8L))._m10(unsafe.getFloat(null, l2 + 12L))._m11(unsafe.getFloat(null, l2 + 16L))._m12(unsafe.getFloat(null, l2 + 20L))._m20(unsafe.getFloat(null, l2 + 24L))._m21(unsafe.getFloat(null, l2 + 28L))._m22(unsafe.getFloat(null, l2 + 32L))._m30(unsafe.getFloat(null, l2 + 36L))._m31(unsafe.getFloat(null, l2 + 40L))._m32(unsafe.getFloat(null, l2 + 44L));
        }

        public static void get(Matrix3f matrix3f, long l2) {
            for (int i2 = 0; i2 < 4; ++i2) {
                UNSAFE.putLong(matrix3f, Matrix3f_m00 + (long)(i2 << 3), UNSAFE.getLong(null, l2 + (long)(i2 << 3)));
            }
            matrix3f._m22(UNSAFE.getFloat(null, l2 + 32L));
        }

        public static void get(Matrix3d matrix3d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix3d._m00(unsafe.getDouble(null, l2))._m01(unsafe.getDouble(null, l2 + 8L))._m02(unsafe.getDouble(null, l2 + 16L))._m10(unsafe.getDouble(null, l2 + 24L))._m11(unsafe.getDouble(null, l2 + 32L))._m12(unsafe.getDouble(null, l2 + 40L))._m20(unsafe.getDouble(null, l2 + 48L))._m21(unsafe.getDouble(null, l2 + 56L))._m22(unsafe.getDouble(null, l2 + 64L));
        }

        public static void get(Matrix3x2f matrix3x2f, long l2) {
            for (int i2 = 0; i2 < 3; ++i2) {
                UNSAFE.putLong(matrix3x2f, Matrix3x2f_m00 + (long)(i2 << 3), UNSAFE.getLong(null, l2 + (long)(i2 << 3)));
            }
        }

        public static void get(Matrix3x2d matrix3x2d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix3x2d._m00(unsafe.getDouble(null, l2))._m01(unsafe.getDouble(null, l2 + 8L))._m10(unsafe.getDouble(null, l2 + 16L))._m11(unsafe.getDouble(null, l2 + 24L))._m20(unsafe.getDouble(null, l2 + 32L))._m21(unsafe.getDouble(null, l2 + 40L));
        }

        public static void getf(Matrix3d matrix3d, long l2) {
            Unsafe unsafe = UNSAFE;
            matrix3d._m00(unsafe.getFloat(null, l2))._m01(unsafe.getFloat(null, l2 + 4L))._m02(unsafe.getFloat(null, l2 + 8L))._m10(unsafe.getFloat(null, l2 + 12L))._m11(unsafe.getFloat(null, l2 + 16L))._m12(unsafe.getFloat(null, l2 + 20L))._m20(unsafe.getFloat(null, l2 + 24L))._m21(unsafe.getFloat(null, l2 + 28L))._m22(unsafe.getFloat(null, l2 + 32L));
        }

        public static void get(Matrix2f matrix2f, long l2) {
            UNSAFE.putLong(matrix2f, Matrix2f_m00, UNSAFE.getLong(null, l2));
            UNSAFE.putLong(matrix2f, Matrix2f_m00 + 8L, UNSAFE.getLong(null, l2 + 8L));
        }

        public static void get(Matrix2d matrix2d, long l2) {
            matrix2d._m00(UNSAFE.getDouble(null, l2))._m01(UNSAFE.getDouble(null, l2 + 8L))._m10(UNSAFE.getDouble(null, l2 + 16L))._m11(UNSAFE.getDouble(null, l2 + 24L));
        }

        public static void getf(Matrix2d matrix2d, long l2) {
            matrix2d._m00(UNSAFE.getFloat(null, l2))._m01(UNSAFE.getFloat(null, l2 + 4L))._m10(UNSAFE.getFloat(null, l2 + 8L))._m11(UNSAFE.getFloat(null, l2 + 12L));
        }

        public static void get(Vector4d vector4d, long l2) {
            vector4d.x = UNSAFE.getDouble(null, l2);
            vector4d.y = UNSAFE.getDouble(null, l2 + 8L);
            vector4d.z = UNSAFE.getDouble(null, l2 + 16L);
            vector4d.w = UNSAFE.getDouble(null, l2 + 24L);
        }

        public static void get(Vector4f vector4f, long l2) {
            vector4f.x = UNSAFE.getFloat(null, l2);
            vector4f.y = UNSAFE.getFloat(null, l2 + 4L);
            vector4f.z = UNSAFE.getFloat(null, l2 + 8L);
            vector4f.w = UNSAFE.getFloat(null, l2 + 12L);
        }

        public static void get(Vector4i vector4i, long l2) {
            vector4i.x = UNSAFE.getInt(null, l2);
            vector4i.y = UNSAFE.getInt(null, l2 + 4L);
            vector4i.z = UNSAFE.getInt(null, l2 + 8L);
            vector4i.w = UNSAFE.getInt(null, l2 + 12L);
        }

        public static void get(Vector4L vector4L, long l2) {
            vector4L.x = UNSAFE.getLong(null, l2);
            vector4L.y = UNSAFE.getLong(null, l2 + 8L);
            vector4L.z = UNSAFE.getLong(null, l2 + 16L);
            vector4L.w = UNSAFE.getLong(null, l2 + 24L);
        }

        public static void get(Vector3f vector3f, long l2) {
            vector3f.x = UNSAFE.getFloat(null, l2);
            vector3f.y = UNSAFE.getFloat(null, l2 + 4L);
            vector3f.z = UNSAFE.getFloat(null, l2 + 8L);
        }

        public static void get(Vector3d vector3d, long l2) {
            vector3d.x = UNSAFE.getDouble(null, l2);
            vector3d.y = UNSAFE.getDouble(null, l2 + 8L);
            vector3d.z = UNSAFE.getDouble(null, l2 + 16L);
        }

        public static void get(Vector3i vector3i, long l2) {
            vector3i.x = UNSAFE.getInt(null, l2);
            vector3i.y = UNSAFE.getInt(null, l2 + 4L);
            vector3i.z = UNSAFE.getInt(null, l2 + 8L);
        }

        public static void get(Vector3L vector3L, long l2) {
            vector3L.x = UNSAFE.getLong(null, l2);
            vector3L.y = UNSAFE.getLong(null, l2 + 8L);
            vector3L.z = UNSAFE.getLong(null, l2 + 16L);
        }

        public static void get(Vector2f vector2f, long l2) {
            vector2f.x = UNSAFE.getFloat(null, l2);
            vector2f.y = UNSAFE.getFloat(null, l2 + 4L);
        }

        public static void get(Vector2d vector2d, long l2) {
            vector2d.x = UNSAFE.getDouble(null, l2);
            vector2d.y = UNSAFE.getDouble(null, l2 + 8L);
        }

        public static void get(Vector2i vector2i, long l2) {
            vector2i.x = UNSAFE.getInt(null, l2);
            vector2i.y = UNSAFE.getInt(null, l2 + 4L);
        }

        public static void get(Vector2L vector2L, long l2) {
            vector2L.x = UNSAFE.getLong(null, l2);
            vector2L.y = UNSAFE.getLong(null, l2 + 8L);
        }

        public static void putMatrix3f(Quaternionf quaternionf, long l2) {
            float f2 = quaternionf.x + quaternionf.x;
            float f3 = quaternionf.y + quaternionf.y;
            float f4 = quaternionf.z + quaternionf.z;
            float f5 = f2 * quaternionf.x;
            float f6 = f3 * quaternionf.y;
            float f7 = f4 * quaternionf.z;
            float f8 = f2 * quaternionf.y;
            float f9 = f2 * quaternionf.z;
            f2 *= quaternionf.w;
            float f10 = f3 * quaternionf.z;
            float f11 = f4 * quaternionf.w;
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, 1.0f - f6 - f7);
            unsafe.putFloat(null, l2 + 4L, f8 + f11);
            unsafe.putFloat(null, l2 + 8L, f9 - (f3 *= quaternionf.w));
            unsafe.putFloat(null, l2 + 12L, f8 - f11);
            unsafe.putFloat(null, l2 + 16L, 1.0f - f7 - f5);
            unsafe.putFloat(null, l2 + 20L, f10 + f2);
            unsafe.putFloat(null, l2 + 24L, f9 + f3);
            unsafe.putFloat(null, l2 + 28L, f10 - f2);
            unsafe.putFloat(null, l2 + 32L, 1.0f - f6 - f5);
        }

        public static void putMatrix4f(Quaternionf quaternionf, long l2) {
            float f2 = quaternionf.x + quaternionf.x;
            float f3 = quaternionf.y + quaternionf.y;
            float f4 = quaternionf.z + quaternionf.z;
            float f5 = f2 * quaternionf.x;
            float f6 = f3 * quaternionf.y;
            float f7 = f4 * quaternionf.z;
            float f8 = f2 * quaternionf.y;
            float f9 = f2 * quaternionf.z;
            f2 *= quaternionf.w;
            float f10 = f3 * quaternionf.z;
            float f11 = f4 * quaternionf.w;
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, 1.0f - f6 - f7);
            unsafe.putFloat(null, l2 + 4L, f8 + f11);
            unsafe.putLong(null, l2 + 8L, (long)Float.floatToRawIntBits(f9 - (f3 *= quaternionf.w)) & 0xFFFFFFFFL);
            unsafe.putFloat(null, l2 + 16L, f8 - f11);
            unsafe.putFloat(null, l2 + 20L, 1.0f - f7 - f5);
            unsafe.putLong(null, l2 + 24L, (long)Float.floatToRawIntBits(f10 + f2) & 0xFFFFFFFFL);
            unsafe.putFloat(null, l2 + 32L, f9 + f3);
            unsafe.putFloat(null, l2 + 36L, f10 - f2);
            unsafe.putLong(null, l2 + 40L, (long)Float.floatToRawIntBits(1.0f - f6 - f5) & 0xFFFFFFFFL);
            unsafe.putLong(null, l2 + 48L, 0L);
            unsafe.putLong(null, l2 + 56L, 4575657221408423936L);
        }

        public static void putMatrix4x3f(Quaternionf quaternionf, long l2) {
            float f2 = quaternionf.x + quaternionf.x;
            float f3 = quaternionf.y + quaternionf.y;
            float f4 = quaternionf.z + quaternionf.z;
            float f5 = f2 * quaternionf.x;
            float f6 = f3 * quaternionf.y;
            float f7 = f4 * quaternionf.z;
            float f8 = f2 * quaternionf.y;
            float f9 = f2 * quaternionf.z;
            f2 *= quaternionf.w;
            float f10 = f3 * quaternionf.z;
            float f11 = f4 * quaternionf.w;
            Unsafe unsafe = UNSAFE;
            unsafe.putFloat(null, l2, 1.0f - f6 - f7);
            unsafe.putFloat(null, l2 + 4L, f8 + f11);
            unsafe.putFloat(null, l2 + 8L, f9 - (f3 *= quaternionf.w));
            unsafe.putFloat(null, l2 + 12L, f8 - f11);
            unsafe.putFloat(null, l2 + 16L, 1.0f - f7 - f5);
            unsafe.putFloat(null, l2 + 20L, f10 + f2);
            unsafe.putFloat(null, l2 + 24L, f9 + f3);
            unsafe.putFloat(null, l2 + 28L, f10 - f2);
            unsafe.putFloat(null, l2 + 32L, 1.0f - f6 - f5);
            unsafe.putLong(null, l2 + 36L, 0L);
            unsafe.putFloat(null, l2 + 44L, 0.0f);
        }

        private static void throwNoDirectBufferException() {
            throw new IllegalArgumentException("Must use a direct buffer");
        }

        public void putMatrix3f(Quaternionf quaternionf, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putMatrix3f(quaternionf, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putMatrix3f(quaternionf, n2, byteBuffer);
        }

        public void putMatrix3f(Quaternionf quaternionf, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putMatrix3f(quaternionf, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putMatrix3f(quaternionf, n2, floatBuffer);
        }

        private static void checkPut(int n2, boolean bl, int n3, int n4) {
            if (!bl) {
                MemUtilUnsafe.throwNoDirectBufferException();
            }
            if (n3 - n2 < n4) {
                throw new BufferOverflowException();
            }
        }

        public void putMatrix4f(Quaternionf quaternionf, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putMatrix4f(quaternionf, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putMatrix4f(quaternionf, n2, byteBuffer);
        }

        public void putMatrix4f(Quaternionf quaternionf, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putMatrix4f(quaternionf, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putMatrix4f(quaternionf, n2, floatBuffer);
        }

        public void putMatrix4x3f(Quaternionf quaternionf, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putMatrix4x3f(quaternionf, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putMatrix4x3f(quaternionf, n2, byteBuffer);
        }

        public void putMatrix4x3f(Quaternionf quaternionf, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putMatrix4x3f(quaternionf, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putMatrix4x3f(quaternionf, n2, floatBuffer);
        }

        public void put(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(matrix4f, n2, floatBuffer);
        }

        public void put(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(matrix4f, n2, byteBuffer);
        }

        public void put4x3(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x3(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put4x3(matrix4f, n2, floatBuffer);
        }

        public void put4x3(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x3(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put4x3(matrix4f, n2, byteBuffer);
        }

        public void put3x4(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put3x4(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put3x4(matrix4f, n2, floatBuffer);
        }

        public void put3x4(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put3x4(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put3x4(matrix4f, n2, byteBuffer);
        }

        public void put(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix4x3f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(matrix4x3f, n2, floatBuffer);
        }

        public void put(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix4x3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(matrix4x3f, n2, byteBuffer);
        }

        public void put4x4(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x4(matrix4x3f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put4x4(matrix4x3f, n2, floatBuffer);
        }

        public void put4x4(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x4(matrix4x3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put4x4(matrix4x3f, n2, byteBuffer);
        }

        public void put3x4(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put3x4(matrix4x3f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put3x4(matrix4x3f, n2, floatBuffer);
        }

        public void put3x4(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put3x4(matrix4x3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put3x4(matrix4x3f, n2, byteBuffer);
        }

        public void put4x4(Matrix4x3d matrix4x3d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 16);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x4(matrix4x3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put4x4(matrix4x3d, n2, doubleBuffer);
        }

        public void put4x4(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 128);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x4(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put4x4(matrix4x3d, n2, byteBuffer);
        }

        public void put4x4(Matrix3x2f matrix3x2f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x4(matrix3x2f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put4x4(matrix3x2f, n2, floatBuffer);
        }

        public void put4x4(Matrix3x2f matrix3x2f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x4(matrix3x2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put4x4(matrix3x2f, n2, byteBuffer);
        }

        public void put4x4(Matrix3x2d matrix3x2d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 16);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x4(matrix3x2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put4x4(matrix3x2d, n2, doubleBuffer);
        }

        public void put4x4(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 128);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x4(matrix3x2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put4x4(matrix3x2d, n2, byteBuffer);
        }

        public void put3x3(Matrix3x2f matrix3x2f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put3x3(matrix3x2f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put3x3(matrix3x2f, n2, floatBuffer);
        }

        public void put3x3(Matrix3x2f matrix3x2f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put3x3(matrix3x2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put3x3(matrix3x2f, n2, byteBuffer);
        }

        public void put3x3(Matrix3x2d matrix3x2d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 9);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put3x3(matrix3x2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put3x3(matrix3x2d, n2, doubleBuffer);
        }

        public void put3x3(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 72);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put3x3(matrix3x2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put3x3(matrix3x2d, n2, byteBuffer);
        }

        public void putTransposed(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putTransposed(matrix4f, n2, floatBuffer);
        }

        public void putTransposed(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putTransposed(matrix4f, n2, byteBuffer);
        }

        public void put4x3Transposed(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x3Transposed(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put4x3Transposed(matrix4f, n2, floatBuffer);
        }

        public void put4x3Transposed(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x3Transposed(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put4x3Transposed(matrix4f, n2, byteBuffer);
        }

        public void putTransposed(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix4x3f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putTransposed(matrix4x3f, n2, floatBuffer);
        }

        public void putTransposed(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix4x3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putTransposed(matrix4x3f, n2, byteBuffer);
        }

        public void putTransposed(Matrix3f matrix3f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix3f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putTransposed(matrix3f, n2, floatBuffer);
        }

        public void putTransposed(Matrix3f matrix3f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putTransposed(matrix3f, n2, byteBuffer);
        }

        public void putTransposed(Matrix3x2f matrix3x2f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 6);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix3x2f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putTransposed(matrix3x2f, n2, floatBuffer);
        }

        public void putTransposed(Matrix2f matrix2f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix2f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putTransposed(matrix2f, n2, floatBuffer);
        }

        public void putTransposed(Matrix2f matrix2f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putTransposed(matrix2f, n2, byteBuffer);
        }

        public void put(Matrix4d matrix4d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 16);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put(matrix4d, n2, doubleBuffer);
        }

        public void put(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 128);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(matrix4d, n2, byteBuffer);
        }

        public void put(Matrix4x3d matrix4x3d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 12);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix4x3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put(matrix4x3d, n2, doubleBuffer);
        }

        public void put(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 96);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(matrix4x3d, n2, byteBuffer);
        }

        public void putf(Matrix4d matrix4d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(matrix4d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putf(matrix4d, n2, floatBuffer);
        }

        public void putf(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putf(matrix4d, n2, byteBuffer);
        }

        public void putf(Matrix4x3d matrix4x3d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(matrix4x3d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putf(matrix4x3d, n2, floatBuffer);
        }

        public void putf(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putf(matrix4x3d, n2, byteBuffer);
        }

        public void putTransposed(Matrix4d matrix4d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 16);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.putTransposed(matrix4d, n2, doubleBuffer);
        }

        public void putTransposed(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 128);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putTransposed(matrix4d, n2, byteBuffer);
        }

        public void put4x3Transposed(Matrix4d matrix4d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 12);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x3Transposed(matrix4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put4x3Transposed(matrix4d, n2, doubleBuffer);
        }

        public void put4x3Transposed(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 96);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put4x3Transposed(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put4x3Transposed(matrix4d, n2, byteBuffer);
        }

        public void putTransposed(Matrix4x3d matrix4x3d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 12);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix4x3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.putTransposed(matrix4x3d, n2, doubleBuffer);
        }

        public void putTransposed(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 96);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putTransposed(matrix4x3d, n2, byteBuffer);
        }

        public void putTransposed(Matrix3d matrix3d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 9);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.putTransposed(matrix3d, n2, doubleBuffer);
        }

        public void putTransposed(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 72);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putTransposed(matrix3d, n2, byteBuffer);
        }

        public void putTransposed(Matrix3x2d matrix3x2d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 6);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix3x2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.putTransposed(matrix3x2d, n2, doubleBuffer);
        }

        public void putTransposed(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix3x2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putTransposed(matrix3x2d, n2, byteBuffer);
        }

        public void putTransposed(Matrix2d matrix2d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 4);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.putTransposed(matrix2d, n2, doubleBuffer);
        }

        public void putTransposed(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 32);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putTransposed(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putTransposed(matrix2d, n2, byteBuffer);
        }

        public void putfTransposed(Matrix4d matrix4d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putfTransposed(matrix4d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putfTransposed(matrix4d, n2, floatBuffer);
        }

        public void putfTransposed(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putfTransposed(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putfTransposed(matrix4d, n2, byteBuffer);
        }

        public void putfTransposed(Matrix4x3d matrix4x3d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putfTransposed(matrix4x3d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putfTransposed(matrix4x3d, n2, floatBuffer);
        }

        public void putfTransposed(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putfTransposed(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putfTransposed(matrix4x3d, n2, byteBuffer);
        }

        public void putfTransposed(Matrix3d matrix3d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putfTransposed(matrix3d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putfTransposed(matrix3d, n2, floatBuffer);
        }

        public void putfTransposed(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putfTransposed(matrix3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putfTransposed(matrix3d, n2, byteBuffer);
        }

        public void putfTransposed(Matrix3x2d matrix3x2d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 6);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putfTransposed(matrix3x2d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putfTransposed(matrix3x2d, n2, floatBuffer);
        }

        public void putfTransposed(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 24);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putfTransposed(matrix3x2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putfTransposed(matrix3x2d, n2, byteBuffer);
        }

        public void putfTransposed(Matrix2d matrix2d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putfTransposed(matrix2d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putfTransposed(matrix2d, n2, floatBuffer);
        }

        public void putfTransposed(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putfTransposed(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putfTransposed(matrix2d, n2, byteBuffer);
        }

        public void put(Matrix3f matrix3f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix3f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(matrix3f, n2, floatBuffer);
        }

        public void put(Matrix3f matrix3f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(matrix3f, n2, byteBuffer);
        }

        public void put3x4(Matrix3f matrix3f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put3x4(matrix3f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put3x4(matrix3f, n2, floatBuffer);
        }

        public void put3x4(Matrix3f matrix3f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put3x4(matrix3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put3x4(matrix3f, n2, byteBuffer);
        }

        public void put(Matrix3d matrix3d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 9);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put(matrix3d, n2, doubleBuffer);
        }

        public void put(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 72);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(matrix3d, n2, byteBuffer);
        }

        public void put(Matrix3x2f matrix3x2f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 6);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix3x2f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(matrix3x2f, n2, floatBuffer);
        }

        public void put(Matrix3x2f matrix3x2f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 24);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix3x2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(matrix3x2f, n2, byteBuffer);
        }

        public void put(Matrix3x2d matrix3x2d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 6);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix3x2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put(matrix3x2d, n2, doubleBuffer);
        }

        public void put(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix3x2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(matrix3x2d, n2, byteBuffer);
        }

        public void putf(Matrix3d matrix3d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(matrix3d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putf(matrix3d, n2, floatBuffer);
        }

        public void putf(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(matrix3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putf(matrix3d, n2, byteBuffer);
        }

        public void put(Matrix2f matrix2f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix2f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(matrix2f, n2, floatBuffer);
        }

        public void put(Matrix2f matrix2f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(matrix2f, n2, byteBuffer);
        }

        public void put(Matrix2d matrix2d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 4);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put(matrix2d, n2, doubleBuffer);
        }

        public void put(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 32);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(matrix2d, n2, byteBuffer);
        }

        public void putf(Matrix2d matrix2d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(matrix2d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.putf(matrix2d, n2, floatBuffer);
        }

        public void putf(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putf(matrix2d, n2, byteBuffer);
        }

        public void put(Vector4d vector4d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 4);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put(vector4d, n2, doubleBuffer);
        }

        public void put(Vector4d vector4d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(vector4d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(vector4d, n2, floatBuffer);
        }

        public void put(Vector4d vector4d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 32);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(vector4d, n2, byteBuffer);
        }

        public void putf(Vector4d vector4d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(vector4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putf(vector4d, n2, byteBuffer);
        }

        public void put(Vector4f vector4f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector4f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(vector4f, n2, floatBuffer);
        }

        public void put(Vector4f vector4f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(vector4f, n2, byteBuffer);
        }

        public void put(Vector4i vector4i, int n2, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, intBuffer.isDirect(), intBuffer.capacity(), 4);
            }
            if (intBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector4i, UNSAFE.getLong(intBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(vector4i, n2, intBuffer);
        }

        public void put(Vector4i vector4i, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector4i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(vector4i, n2, byteBuffer);
        }

        public void put(Vector3f vector3f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 3);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector3f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(vector3f, n2, floatBuffer);
        }

        public void put(Vector3f vector3f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 12);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(vector3f, n2, byteBuffer);
        }

        public void put(Vector3d vector3d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 3);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put(vector3d, n2, doubleBuffer);
        }

        public void put(Vector3d vector3d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 3);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(vector3d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(vector3d, n2, floatBuffer);
        }

        public void put(Vector3d vector3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 24);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(vector3d, n2, byteBuffer);
        }

        public void putf(Vector3d vector3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 12);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.putf(vector3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.putf(vector3d, n2, byteBuffer);
        }

        public void put(Vector3i vector3i, int n2, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, intBuffer.isDirect(), intBuffer.capacity(), 3);
            }
            if (intBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector3i, UNSAFE.getLong(intBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(vector3i, n2, intBuffer);
        }

        public void put(Vector3i vector3i, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 12);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector3i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(vector3i, n2, byteBuffer);
        }

        public void put(Vector2f vector2f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 2);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector2f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(vector2f, n2, floatBuffer);
        }

        public void put(Vector2f vector2f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 8);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(vector2f, n2, byteBuffer);
        }

        public void put(Vector2d vector2d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 2);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put(vector2d, n2, doubleBuffer);
        }

        public void put(Vector2d vector2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(vector2d, n2, byteBuffer);
        }

        public void put(Vector2i vector2i, int n2, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, intBuffer.isDirect(), intBuffer.capacity(), 2);
            }
            if (intBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector2i, UNSAFE.getLong(intBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.put(vector2i, n2, intBuffer);
        }

        public void put(Vector2i vector2i, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 8);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector2i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(vector2i, n2, byteBuffer);
        }

        public void put(Vector2L vector2L, int n2, LongBuffer longBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, longBuffer.isDirect(), longBuffer.capacity(), 2);
            }
            if (longBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector2L, UNSAFE.getLong(longBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.put(vector2L, n2, longBuffer);
        }

        public void put(Vector2L vector2L, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkPut(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.put(vector2L, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.put(vector2L, n2, byteBuffer);
        }

        public void get(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix4f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.get(matrix4f, n2, floatBuffer);
        }

        public void get(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(matrix4f, n2, byteBuffer);
        }

        public float get(Matrix4f matrix4f, int n2, int n3) {
            return UNSAFE.getFloat(matrix4f, Matrix4f_m00 + ((long)n2 << 4) + ((long)n3 << 2));
        }

        public Matrix4f set(Matrix4f matrix4f, int n2, int n3, float f2) {
            UNSAFE.putFloat(matrix4f, Matrix4f_m00 + ((long)n2 << 4) + ((long)n3 << 2), f2);
            return matrix4f;
        }

        public double get(Matrix4d matrix4d, int n2, int n3) {
            return UNSAFE.getDouble(matrix4d, Matrix4d_m00 + ((long)n2 << 5) + ((long)n3 << 3));
        }

        public Matrix4d set(Matrix4d matrix4d, int n2, int n3, double d2) {
            UNSAFE.putDouble(matrix4d, Matrix4d_m00 + ((long)n2 << 5) + ((long)n3 << 3), d2);
            return matrix4d;
        }

        public float get(Matrix3f matrix3f, int n2, int n3) {
            return UNSAFE.getFloat(matrix3f, Matrix3f_m00 + (long)n2 * 12L + ((long)n3 << 2));
        }

        public Matrix3f set(Matrix3f matrix3f, int n2, int n3, float f2) {
            UNSAFE.putFloat(matrix3f, Matrix3f_m00 + (long)n2 * 12L + ((long)n3 << 2), f2);
            return matrix3f;
        }

        public double get(Matrix3d matrix3d, int n2, int n3) {
            return UNSAFE.getDouble(matrix3d, Matrix3d_m00 + (long)n2 * 24L + ((long)n3 << 3));
        }

        public Matrix3d set(Matrix3d matrix3d, int n2, int n3, double d2) {
            UNSAFE.putDouble(matrix3d, Matrix3d_m00 + (long)n2 * 24L + ((long)n3 << 3), d2);
            return matrix3d;
        }

        public void get(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix4x3f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.get(matrix4x3f, n2, floatBuffer);
        }

        public void get(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix4x3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(matrix4x3f, n2, byteBuffer);
        }

        public void get(Matrix4d matrix4d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 16);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.get(matrix4d, n2, doubleBuffer);
        }

        public void get(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 128);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(matrix4d, n2, byteBuffer);
        }

        public void get(Matrix4x3d matrix4x3d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 12);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix4x3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.get(matrix4x3d, n2, doubleBuffer);
        }

        public void get(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 96);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(matrix4x3d, n2, byteBuffer);
        }

        public void getf(Matrix4d matrix4d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 16);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.getf(matrix4d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.getf(matrix4d, n2, floatBuffer);
        }

        public void getf(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 64);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.getf(matrix4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.getf(matrix4d, n2, byteBuffer);
        }

        public void getf(Matrix4x3d matrix4x3d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 12);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.getf(matrix4x3d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.getf(matrix4x3d, n2, floatBuffer);
        }

        private static void checkGet(int n2, boolean bl, int n3, int n4) {
            if (!bl) {
                MemUtilUnsafe.throwNoDirectBufferException();
            }
            if (n3 - n2 < n4) {
                throw new BufferUnderflowException();
            }
        }

        public void getf(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.getf(matrix4x3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.getf(matrix4x3d, n2, byteBuffer);
        }

        public void get(Matrix3f matrix3f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix3f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.get(matrix3f, n2, floatBuffer);
        }

        public void get(Matrix3f matrix3f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(matrix3f, n2, byteBuffer);
        }

        public void get(Matrix3d matrix3d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 9);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.get(matrix3d, n2, doubleBuffer);
        }

        public void get(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 72);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(matrix3d, n2, byteBuffer);
        }

        public void get(Matrix3x2f matrix3x2f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 6);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix3x2f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.get(matrix3x2f, n2, floatBuffer);
        }

        public void get(Matrix3x2f matrix3x2f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 24);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix3x2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(matrix3x2f, n2, byteBuffer);
        }

        public void get(Matrix3x2d matrix3x2d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 6);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix3x2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.get(matrix3x2d, n2, doubleBuffer);
        }

        public void get(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 48);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix3x2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(matrix3x2d, n2, byteBuffer);
        }

        public void getf(Matrix3d matrix3d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 9);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.getf(matrix3d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.getf(matrix3d, n2, floatBuffer);
        }

        public void getf(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 36);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.getf(matrix3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.getf(matrix3d, n2, byteBuffer);
        }

        public void get(Matrix2f matrix2f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix2f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.get(matrix2f, n2, floatBuffer);
        }

        public void get(Matrix2f matrix2f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(matrix2f, n2, byteBuffer);
        }

        public void get(Matrix2d matrix2d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 4);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.get(matrix2d, n2, doubleBuffer);
        }

        public void get(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 32);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(matrix2d, n2, byteBuffer);
        }

        public void getf(Matrix2d matrix2d, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.getf(matrix2d, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.getf(matrix2d, n2, floatBuffer);
        }

        public void getf(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.getf(matrix2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.getf(matrix2d, n2, byteBuffer);
        }

        public void get(Vector4d vector4d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 4);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector4d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.get(vector4d, n2, doubleBuffer);
        }

        public void get(Vector4d vector4d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 32);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector4d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(vector4d, n2, byteBuffer);
        }

        public void get(Vector4f vector4f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 4);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector4f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.get(vector4f, n2, floatBuffer);
        }

        public void get(Vector4f vector4f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector4f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(vector4f, n2, byteBuffer);
        }

        public void get(Vector4i vector4i, int n2, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, intBuffer.isDirect(), intBuffer.capacity(), 4);
            }
            if (intBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector4i, UNSAFE.getLong(intBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.get(vector4i, n2, intBuffer);
        }

        public void get(Vector4i vector4i, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector4i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(vector4i, n2, byteBuffer);
        }

        public void get(Vector3f vector3f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 3);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector3f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.get(vector3f, n2, floatBuffer);
        }

        public void get(Vector3f vector3f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 12);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector3f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(vector3f, n2, byteBuffer);
        }

        public void get(Vector3d vector3d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 3);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector3d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.get(vector3d, n2, doubleBuffer);
        }

        public void get(Vector3d vector3d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 24);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector3d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(vector3d, n2, byteBuffer);
        }

        public void get(Vector3i vector3i, int n2, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, intBuffer.isDirect(), intBuffer.capacity(), 3);
            }
            if (intBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector3i, UNSAFE.getLong(intBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.get(vector3i, n2, intBuffer);
        }

        public void get(Vector3i vector3i, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 12);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector3i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(vector3i, n2, byteBuffer);
        }

        public void get(Vector2f vector2f, int n2, FloatBuffer floatBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, floatBuffer.isDirect(), floatBuffer.capacity(), 2);
            }
            if (floatBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector2f, UNSAFE.getLong(floatBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.get(vector2f, n2, floatBuffer);
        }

        public void get(Vector2f vector2f, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 8);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector2f, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(vector2f, n2, byteBuffer);
        }

        public void get(Vector2d vector2d, int n2, DoubleBuffer doubleBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, doubleBuffer.isDirect(), doubleBuffer.capacity(), 2);
            }
            if (doubleBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector2d, UNSAFE.getLong(doubleBuffer, ADDRESS) + ((long)n2 << 3));
                return;
            }
            super.get(vector2d, n2, doubleBuffer);
        }

        public void get(Vector2d vector2d, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 16);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector2d, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(vector2d, n2, byteBuffer);
        }

        public void get(Vector2i vector2i, int n2, IntBuffer intBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, intBuffer.isDirect(), intBuffer.capacity(), 2);
            }
            if (intBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector2i, UNSAFE.getLong(intBuffer, ADDRESS) + ((long)n2 << 2));
                return;
            }
            super.get(vector2i, n2, intBuffer);
        }

        public void get(Vector2i vector2i, int n2, ByteBuffer byteBuffer) {
            if (Options.DEBUG) {
                MemUtilUnsafe.checkGet(n2, byteBuffer.isDirect(), byteBuffer.capacity(), 8);
            }
            if (byteBuffer.order() == ByteOrder.nativeOrder()) {
                MemUtilUnsafe.get(vector2i, UNSAFE.getLong(byteBuffer, ADDRESS) + (long)n2);
                return;
            }
            super.get(vector2i, n2, byteBuffer);
        }

        static {
            try {
                ADDRESS = MemUtilUnsafe.findBufferAddress();
                Matrix4f_m00 = MemUtilUnsafe.checkMatrix4f();
                Matrix4d_m00 = MemUtilUnsafe.checkMatrix4d();
                Matrix4x3f_m00 = MemUtilUnsafe.checkMatrix4x3f();
                Matrix3f_m00 = MemUtilUnsafe.checkMatrix3f();
                Matrix3d_m00 = MemUtilUnsafe.checkMatrix3d();
                Matrix3x2f_m00 = MemUtilUnsafe.checkMatrix3x2f();
                Matrix2f_m00 = MemUtilUnsafe.checkMatrix2f();
                Vector4f_x = MemUtilUnsafe.checkVector4f();
                Vector4i_x = MemUtilUnsafe.checkVector4i();
                Vector3f_x = MemUtilUnsafe.checkVector3f();
                Vector3i_x = MemUtilUnsafe.checkVector3i();
                Vector2f_x = MemUtilUnsafe.checkVector2f();
                Vector2i_x = MemUtilUnsafe.checkVector2i();
                floatArrayOffset = UNSAFE.arrayBaseOffset([F.class);
                Unsafe.class.getDeclaredMethod("getLong", Object.class, Long.TYPE);
                Unsafe.class.getDeclaredMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new UnsupportedOperationException(noSuchFieldException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new UnsupportedOperationException(noSuchMethodException);
            }
        }
    }

    public static class MemUtilNIO
    extends MemUtil {
        public void put0(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4f.m00()).put(1, matrix4f.m01()).put(2, matrix4f.m02()).put(3, matrix4f.m03()).put(4, matrix4f.m10()).put(5, matrix4f.m11()).put(6, matrix4f.m12()).put(7, matrix4f.m13()).put(8, matrix4f.m20()).put(9, matrix4f.m21()).put(10, matrix4f.m22()).put(11, matrix4f.m23()).put(12, matrix4f.m30()).put(13, matrix4f.m31()).put(14, matrix4f.m32()).put(15, matrix4f.m33());
        }

        public void putN(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix4f.m00()).put(n2 + 1, matrix4f.m01()).put(n2 + 2, matrix4f.m02()).put(n2 + 3, matrix4f.m03()).put(n2 + 4, matrix4f.m10()).put(n2 + 5, matrix4f.m11()).put(n2 + 6, matrix4f.m12()).put(n2 + 7, matrix4f.m13()).put(n2 + 8, matrix4f.m20()).put(n2 + 9, matrix4f.m21()).put(n2 + 10, matrix4f.m22()).put(n2 + 11, matrix4f.m23()).put(n2 + 12, matrix4f.m30()).put(n2 + 13, matrix4f.m31()).put(n2 + 14, matrix4f.m32()).put(n2 + 15, matrix4f.m33());
        }

        public void put(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            if (n2 == 0) {
                this.put0(matrix4f, floatBuffer);
                return;
            }
            this.putN(matrix4f, n2, floatBuffer);
        }

        public void put0(Matrix4f matrix4f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4f.m00()).putFloat(4, matrix4f.m01()).putFloat(8, matrix4f.m02()).putFloat(12, matrix4f.m03()).putFloat(16, matrix4f.m10()).putFloat(20, matrix4f.m11()).putFloat(24, matrix4f.m12()).putFloat(28, matrix4f.m13()).putFloat(32, matrix4f.m20()).putFloat(36, matrix4f.m21()).putFloat(40, matrix4f.m22()).putFloat(44, matrix4f.m23()).putFloat(48, matrix4f.m30()).putFloat(52, matrix4f.m31()).putFloat(56, matrix4f.m32()).putFloat(60, matrix4f.m33());
        }

        private void putN(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix4f.m00()).putFloat(n2 + 4, matrix4f.m01()).putFloat(n2 + 8, matrix4f.m02()).putFloat(n2 + 12, matrix4f.m03()).putFloat(n2 + 16, matrix4f.m10()).putFloat(n2 + 20, matrix4f.m11()).putFloat(n2 + 24, matrix4f.m12()).putFloat(n2 + 28, matrix4f.m13()).putFloat(n2 + 32, matrix4f.m20()).putFloat(n2 + 36, matrix4f.m21()).putFloat(n2 + 40, matrix4f.m22()).putFloat(n2 + 44, matrix4f.m23()).putFloat(n2 + 48, matrix4f.m30()).putFloat(n2 + 52, matrix4f.m31()).putFloat(n2 + 56, matrix4f.m32()).putFloat(n2 + 60, matrix4f.m33());
        }

        public void put(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            if (n2 == 0) {
                this.put0(matrix4f, byteBuffer);
                return;
            }
            this.putN(matrix4f, n2, byteBuffer);
        }

        public void put4x3_0(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4f.m00()).put(1, matrix4f.m01()).put(2, matrix4f.m02()).put(3, matrix4f.m10()).put(4, matrix4f.m11()).put(5, matrix4f.m12()).put(6, matrix4f.m20()).put(7, matrix4f.m21()).put(8, matrix4f.m22()).put(9, matrix4f.m30()).put(10, matrix4f.m31()).put(11, matrix4f.m32());
        }

        public void put4x3_N(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix4f.m00()).put(n2 + 1, matrix4f.m01()).put(n2 + 2, matrix4f.m02()).put(n2 + 3, matrix4f.m10()).put(n2 + 4, matrix4f.m11()).put(n2 + 5, matrix4f.m12()).put(n2 + 6, matrix4f.m20()).put(n2 + 7, matrix4f.m21()).put(n2 + 8, matrix4f.m22()).put(n2 + 9, matrix4f.m30()).put(n2 + 10, matrix4f.m31()).put(n2 + 11, matrix4f.m32());
        }

        public void put4x3(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            if (n2 == 0) {
                this.put4x3_0(matrix4f, floatBuffer);
                return;
            }
            this.put4x3_N(matrix4f, n2, floatBuffer);
        }

        public void put4x3_0(Matrix4f matrix4f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4f.m00()).putFloat(4, matrix4f.m01()).putFloat(8, matrix4f.m02()).putFloat(12, matrix4f.m10()).putFloat(16, matrix4f.m11()).putFloat(20, matrix4f.m12()).putFloat(24, matrix4f.m20()).putFloat(28, matrix4f.m21()).putFloat(32, matrix4f.m22()).putFloat(36, matrix4f.m30()).putFloat(40, matrix4f.m31()).putFloat(44, matrix4f.m32());
        }

        private void put4x3_N(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix4f.m00()).putFloat(n2 + 4, matrix4f.m01()).putFloat(n2 + 8, matrix4f.m02()).putFloat(n2 + 12, matrix4f.m10()).putFloat(n2 + 16, matrix4f.m11()).putFloat(n2 + 20, matrix4f.m12()).putFloat(n2 + 24, matrix4f.m20()).putFloat(n2 + 28, matrix4f.m21()).putFloat(n2 + 32, matrix4f.m22()).putFloat(n2 + 36, matrix4f.m30()).putFloat(n2 + 40, matrix4f.m31()).putFloat(n2 + 44, matrix4f.m32());
        }

        public void put4x3(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            if (n2 == 0) {
                this.put4x3_0(matrix4f, byteBuffer);
                return;
            }
            this.put4x3_N(matrix4f, n2, byteBuffer);
        }

        public void put3x4_0(Matrix4f matrix4f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4f.m00()).putFloat(4, matrix4f.m01()).putFloat(8, matrix4f.m02()).putFloat(12, matrix4f.m03()).putFloat(16, matrix4f.m10()).putFloat(20, matrix4f.m11()).putFloat(24, matrix4f.m12()).putFloat(28, matrix4f.m13()).putFloat(32, matrix4f.m20()).putFloat(36, matrix4f.m21()).putFloat(40, matrix4f.m22()).putFloat(44, matrix4f.m23());
        }

        private void put3x4_N(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix4f.m00()).putFloat(n2 + 4, matrix4f.m01()).putFloat(n2 + 8, matrix4f.m02()).putFloat(n2 + 12, matrix4f.m03()).putFloat(n2 + 16, matrix4f.m10()).putFloat(n2 + 20, matrix4f.m11()).putFloat(n2 + 24, matrix4f.m12()).putFloat(n2 + 28, matrix4f.m13()).putFloat(n2 + 32, matrix4f.m20()).putFloat(n2 + 36, matrix4f.m21()).putFloat(n2 + 40, matrix4f.m22()).putFloat(n2 + 44, matrix4f.m23());
        }

        public void put3x4(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            if (n2 == 0) {
                this.put3x4_0(matrix4f, byteBuffer);
                return;
            }
            this.put3x4_N(matrix4f, n2, byteBuffer);
        }

        public void put3x4_0(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4f.m00()).put(1, matrix4f.m01()).put(2, matrix4f.m02()).put(3, matrix4f.m03()).put(4, matrix4f.m10()).put(5, matrix4f.m11()).put(6, matrix4f.m12()).put(7, matrix4f.m13()).put(8, matrix4f.m20()).put(9, matrix4f.m21()).put(10, matrix4f.m22()).put(11, matrix4f.m23());
        }

        public void put3x4_N(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix4f.m00()).put(n2 + 1, matrix4f.m01()).put(n2 + 2, matrix4f.m02()).put(n2 + 3, matrix4f.m03()).put(n2 + 4, matrix4f.m10()).put(n2 + 5, matrix4f.m11()).put(n2 + 6, matrix4f.m12()).put(n2 + 7, matrix4f.m13()).put(n2 + 8, matrix4f.m20()).put(n2 + 9, matrix4f.m21()).put(n2 + 10, matrix4f.m22()).put(n2 + 11, matrix4f.m23());
        }

        public void put3x4(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            if (n2 == 0) {
                this.put3x4_0(matrix4f, floatBuffer);
                return;
            }
            this.put3x4_N(matrix4f, n2, floatBuffer);
        }

        public void put3x4_0(Matrix4x3f matrix4x3f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4x3f.m00()).putFloat(4, matrix4x3f.m01()).putFloat(8, matrix4x3f.m02()).putFloat(12, 0.0f).putFloat(16, matrix4x3f.m10()).putFloat(20, matrix4x3f.m11()).putFloat(24, matrix4x3f.m12()).putFloat(28, 0.0f).putFloat(32, matrix4x3f.m20()).putFloat(36, matrix4x3f.m21()).putFloat(40, matrix4x3f.m22()).putFloat(44, 0.0f);
        }

        private void put3x4_N(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix4x3f.m00()).putFloat(n2 + 4, matrix4x3f.m01()).putFloat(n2 + 8, matrix4x3f.m02()).putFloat(n2 + 12, 0.0f).putFloat(n2 + 16, matrix4x3f.m10()).putFloat(n2 + 20, matrix4x3f.m11()).putFloat(n2 + 24, matrix4x3f.m12()).putFloat(n2 + 28, 0.0f).putFloat(n2 + 32, matrix4x3f.m20()).putFloat(n2 + 36, matrix4x3f.m21()).putFloat(n2 + 40, matrix4x3f.m22()).putFloat(n2 + 44, 0.0f);
        }

        public void put3x4(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            if (n2 == 0) {
                this.put3x4_0(matrix4x3f, byteBuffer);
                return;
            }
            this.put3x4_N(matrix4x3f, n2, byteBuffer);
        }

        public void put3x4_0(Matrix4x3f matrix4x3f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4x3f.m00()).put(1, matrix4x3f.m01()).put(2, matrix4x3f.m02()).put(3, 0.0f).put(4, matrix4x3f.m10()).put(5, matrix4x3f.m11()).put(6, matrix4x3f.m12()).put(7, 0.0f).put(8, matrix4x3f.m20()).put(9, matrix4x3f.m21()).put(10, matrix4x3f.m22()).put(11, 0.0f);
        }

        public void put3x4_N(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix4x3f.m00()).put(n2 + 1, matrix4x3f.m01()).put(n2 + 2, matrix4x3f.m02()).put(n2 + 3, 0.0f).put(n2 + 4, matrix4x3f.m10()).put(n2 + 5, matrix4x3f.m11()).put(n2 + 6, matrix4x3f.m12()).put(n2 + 7, 0.0f).put(n2 + 8, matrix4x3f.m20()).put(n2 + 9, matrix4x3f.m21()).put(n2 + 10, matrix4x3f.m22()).put(n2 + 11, 0.0f);
        }

        public void put3x4(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            if (n2 == 0) {
                this.put3x4_0(matrix4x3f, floatBuffer);
                return;
            }
            this.put3x4_N(matrix4x3f, n2, floatBuffer);
        }

        public void put0(Matrix4x3f matrix4x3f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4x3f.m00()).put(1, matrix4x3f.m01()).put(2, matrix4x3f.m02()).put(3, matrix4x3f.m10()).put(4, matrix4x3f.m11()).put(5, matrix4x3f.m12()).put(6, matrix4x3f.m20()).put(7, matrix4x3f.m21()).put(8, matrix4x3f.m22()).put(9, matrix4x3f.m30()).put(10, matrix4x3f.m31()).put(11, matrix4x3f.m32());
        }

        public void putN(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix4x3f.m00()).put(n2 + 1, matrix4x3f.m01()).put(n2 + 2, matrix4x3f.m02()).put(n2 + 3, matrix4x3f.m10()).put(n2 + 4, matrix4x3f.m11()).put(n2 + 5, matrix4x3f.m12()).put(n2 + 6, matrix4x3f.m20()).put(n2 + 7, matrix4x3f.m21()).put(n2 + 8, matrix4x3f.m22()).put(n2 + 9, matrix4x3f.m30()).put(n2 + 10, matrix4x3f.m31()).put(n2 + 11, matrix4x3f.m32());
        }

        public void put(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            if (n2 == 0) {
                this.put0(matrix4x3f, floatBuffer);
                return;
            }
            this.putN(matrix4x3f, n2, floatBuffer);
        }

        public void put0(Matrix4x3f matrix4x3f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4x3f.m00()).putFloat(4, matrix4x3f.m01()).putFloat(8, matrix4x3f.m02()).putFloat(12, matrix4x3f.m10()).putFloat(16, matrix4x3f.m11()).putFloat(20, matrix4x3f.m12()).putFloat(24, matrix4x3f.m20()).putFloat(28, matrix4x3f.m21()).putFloat(32, matrix4x3f.m22()).putFloat(36, matrix4x3f.m30()).putFloat(40, matrix4x3f.m31()).putFloat(44, matrix4x3f.m32());
        }

        public void putN(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix4x3f.m00()).putFloat(n2 + 4, matrix4x3f.m01()).putFloat(n2 + 8, matrix4x3f.m02()).putFloat(n2 + 12, matrix4x3f.m10()).putFloat(n2 + 16, matrix4x3f.m11()).putFloat(n2 + 20, matrix4x3f.m12()).putFloat(n2 + 24, matrix4x3f.m20()).putFloat(n2 + 28, matrix4x3f.m21()).putFloat(n2 + 32, matrix4x3f.m22()).putFloat(n2 + 36, matrix4x3f.m30()).putFloat(n2 + 40, matrix4x3f.m31()).putFloat(n2 + 44, matrix4x3f.m32());
        }

        public void put(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            if (n2 == 0) {
                this.put0(matrix4x3f, byteBuffer);
                return;
            }
            this.putN(matrix4x3f, n2, byteBuffer);
        }

        public void put4x4(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix4x3f.m00()).put(n2 + 1, matrix4x3f.m01()).put(n2 + 2, matrix4x3f.m02()).put(n2 + 3, 0.0f).put(n2 + 4, matrix4x3f.m10()).put(n2 + 5, matrix4x3f.m11()).put(n2 + 6, matrix4x3f.m12()).put(n2 + 7, 0.0f).put(n2 + 8, matrix4x3f.m20()).put(n2 + 9, matrix4x3f.m21()).put(n2 + 10, matrix4x3f.m22()).put(n2 + 11, 0.0f).put(n2 + 12, matrix4x3f.m30()).put(n2 + 13, matrix4x3f.m31()).put(n2 + 14, matrix4x3f.m32()).put(n2 + 15, 1.0f);
        }

        public void put4x4(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix4x3f.m00()).putFloat(n2 + 4, matrix4x3f.m01()).putFloat(n2 + 8, matrix4x3f.m02()).putFloat(n2 + 12, 0.0f).putFloat(n2 + 16, matrix4x3f.m10()).putFloat(n2 + 20, matrix4x3f.m11()).putFloat(n2 + 24, matrix4x3f.m12()).putFloat(n2 + 28, 0.0f).putFloat(n2 + 32, matrix4x3f.m20()).putFloat(n2 + 36, matrix4x3f.m21()).putFloat(n2 + 40, matrix4x3f.m22()).putFloat(n2 + 44, 0.0f).putFloat(n2 + 48, matrix4x3f.m30()).putFloat(n2 + 52, matrix4x3f.m31()).putFloat(n2 + 56, matrix4x3f.m32()).putFloat(n2 + 60, 1.0f);
        }

        public void put4x4(Matrix4x3d matrix4x3d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix4x3d.m00()).put(n2 + 1, matrix4x3d.m01()).put(n2 + 2, matrix4x3d.m02()).put(n2 + 3, 0.0).put(n2 + 4, matrix4x3d.m10()).put(n2 + 5, matrix4x3d.m11()).put(n2 + 6, matrix4x3d.m12()).put(n2 + 7, 0.0).put(n2 + 8, matrix4x3d.m20()).put(n2 + 9, matrix4x3d.m21()).put(n2 + 10, matrix4x3d.m22()).put(n2 + 11, 0.0).put(n2 + 12, matrix4x3d.m30()).put(n2 + 13, matrix4x3d.m31()).put(n2 + 14, matrix4x3d.m32()).put(n2 + 15, 1.0);
        }

        public void put4x4(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix4x3d.m00()).putDouble(n2 + 8, matrix4x3d.m01()).putDouble(n2 + 16, matrix4x3d.m02()).putDouble(n2 + 24, 0.0).putDouble(n2 + 32, matrix4x3d.m10()).putDouble(n2 + 40, matrix4x3d.m11()).putDouble(n2 + 48, matrix4x3d.m12()).putDouble(n2 + 56, 0.0).putDouble(n2 + 64, matrix4x3d.m20()).putDouble(n2 + 72, matrix4x3d.m21()).putDouble(n2 + 80, matrix4x3d.m22()).putDouble(n2 + 88, 0.0).putDouble(n2 + 96, matrix4x3d.m30()).putDouble(n2 + 104, matrix4x3d.m31()).putDouble(n2 + 112, matrix4x3d.m32()).putDouble(n2 + 120, 1.0);
        }

        public void put4x4(Matrix3x2f matrix3x2f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix3x2f.m00()).put(n2 + 1, matrix3x2f.m01()).put(n2 + 2, 0.0f).put(n2 + 3, 0.0f).put(n2 + 4, matrix3x2f.m10()).put(n2 + 5, matrix3x2f.m11()).put(n2 + 6, 0.0f).put(n2 + 7, 0.0f).put(n2 + 8, 0.0f).put(n2 + 9, 0.0f).put(n2 + 10, 1.0f).put(n2 + 11, 0.0f).put(n2 + 12, matrix3x2f.m20()).put(n2 + 13, matrix3x2f.m21()).put(n2 + 14, 0.0f).put(n2 + 15, 1.0f);
        }

        public void put4x4(Matrix3x2f matrix3x2f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix3x2f.m00()).putFloat(n2 + 4, matrix3x2f.m01()).putFloat(n2 + 8, 0.0f).putFloat(n2 + 12, 0.0f).putFloat(n2 + 16, matrix3x2f.m10()).putFloat(n2 + 20, matrix3x2f.m11()).putFloat(n2 + 24, 0.0f).putFloat(n2 + 28, 0.0f).putFloat(n2 + 32, 0.0f).putFloat(n2 + 36, 0.0f).putFloat(n2 + 40, 1.0f).putFloat(n2 + 44, 0.0f).putFloat(n2 + 48, matrix3x2f.m20()).putFloat(n2 + 52, matrix3x2f.m21()).putFloat(n2 + 56, 0.0f).putFloat(n2 + 60, 1.0f);
        }

        public void put4x4(Matrix3x2d matrix3x2d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix3x2d.m00()).put(n2 + 1, matrix3x2d.m01()).put(n2 + 2, 0.0).put(n2 + 3, 0.0).put(n2 + 4, matrix3x2d.m10()).put(n2 + 5, matrix3x2d.m11()).put(n2 + 6, 0.0).put(n2 + 7, 0.0).put(n2 + 8, 0.0).put(n2 + 9, 0.0).put(n2 + 10, 1.0).put(n2 + 11, 0.0).put(n2 + 12, matrix3x2d.m20()).put(n2 + 13, matrix3x2d.m21()).put(n2 + 14, 0.0).put(n2 + 15, 1.0);
        }

        public void put4x4(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix3x2d.m00()).putDouble(n2 + 8, matrix3x2d.m01()).putDouble(n2 + 16, 0.0).putDouble(n2 + 24, 0.0).putDouble(n2 + 32, matrix3x2d.m10()).putDouble(n2 + 40, matrix3x2d.m11()).putDouble(n2 + 48, 0.0).putDouble(n2 + 56, 0.0).putDouble(n2 + 64, 0.0).putDouble(n2 + 72, 0.0).putDouble(n2 + 80, 1.0).putDouble(n2 + 88, 0.0).putDouble(n2 + 96, matrix3x2d.m20()).putDouble(n2 + 104, matrix3x2d.m21()).putDouble(n2 + 112, 0.0).putDouble(n2 + 120, 1.0);
        }

        public void put3x3(Matrix3x2f matrix3x2f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix3x2f.m00()).put(n2 + 1, matrix3x2f.m01()).put(n2 + 2, 0.0f).put(n2 + 3, matrix3x2f.m10()).put(n2 + 4, matrix3x2f.m11()).put(n2 + 5, 0.0f).put(n2 + 6, matrix3x2f.m20()).put(n2 + 7, matrix3x2f.m21()).put(n2 + 8, 1.0f);
        }

        public void put3x3(Matrix3x2f matrix3x2f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix3x2f.m00()).putFloat(n2 + 4, matrix3x2f.m01()).putFloat(n2 + 8, 0.0f).putFloat(n2 + 12, matrix3x2f.m10()).putFloat(n2 + 16, matrix3x2f.m11()).putFloat(n2 + 20, 0.0f).putFloat(n2 + 24, matrix3x2f.m20()).putFloat(n2 + 28, matrix3x2f.m21()).putFloat(n2 + 32, 1.0f);
        }

        public void put3x3(Matrix3x2d matrix3x2d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix3x2d.m00()).put(n2 + 1, matrix3x2d.m01()).put(n2 + 2, 0.0).put(n2 + 3, matrix3x2d.m10()).put(n2 + 4, matrix3x2d.m11()).put(n2 + 5, 0.0).put(n2 + 6, matrix3x2d.m20()).put(n2 + 7, matrix3x2d.m21()).put(n2 + 8, 1.0);
        }

        public void put3x3(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix3x2d.m00()).putDouble(n2 + 8, matrix3x2d.m01()).putDouble(n2 + 16, 0.0).putDouble(n2 + 24, matrix3x2d.m10()).putDouble(n2 + 32, matrix3x2d.m11()).putDouble(n2 + 40, 0.0).putDouble(n2 + 48, matrix3x2d.m20()).putDouble(n2 + 56, matrix3x2d.m21()).putDouble(n2 + 64, 1.0);
        }

        private void putTransposedN(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix4f.m00()).put(n2 + 1, matrix4f.m10()).put(n2 + 2, matrix4f.m20()).put(n2 + 3, matrix4f.m30()).put(n2 + 4, matrix4f.m01()).put(n2 + 5, matrix4f.m11()).put(n2 + 6, matrix4f.m21()).put(n2 + 7, matrix4f.m31()).put(n2 + 8, matrix4f.m02()).put(n2 + 9, matrix4f.m12()).put(n2 + 10, matrix4f.m22()).put(n2 + 11, matrix4f.m32()).put(n2 + 12, matrix4f.m03()).put(n2 + 13, matrix4f.m13()).put(n2 + 14, matrix4f.m23()).put(n2 + 15, matrix4f.m33());
        }

        private void putTransposed0(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix4f.m00()).put(1, matrix4f.m10()).put(2, matrix4f.m20()).put(3, matrix4f.m30()).put(4, matrix4f.m01()).put(5, matrix4f.m11()).put(6, matrix4f.m21()).put(7, matrix4f.m31()).put(8, matrix4f.m02()).put(9, matrix4f.m12()).put(10, matrix4f.m22()).put(11, matrix4f.m32()).put(12, matrix4f.m03()).put(13, matrix4f.m13()).put(14, matrix4f.m23()).put(15, matrix4f.m33());
        }

        public void putTransposed(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            if (n2 == 0) {
                this.putTransposed0(matrix4f, floatBuffer);
                return;
            }
            this.putTransposedN(matrix4f, n2, floatBuffer);
        }

        private void putTransposedN(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix4f.m00()).putFloat(n2 + 4, matrix4f.m10()).putFloat(n2 + 8, matrix4f.m20()).putFloat(n2 + 12, matrix4f.m30()).putFloat(n2 + 16, matrix4f.m01()).putFloat(n2 + 20, matrix4f.m11()).putFloat(n2 + 24, matrix4f.m21()).putFloat(n2 + 28, matrix4f.m31()).putFloat(n2 + 32, matrix4f.m02()).putFloat(n2 + 36, matrix4f.m12()).putFloat(n2 + 40, matrix4f.m22()).putFloat(n2 + 44, matrix4f.m32()).putFloat(n2 + 48, matrix4f.m03()).putFloat(n2 + 52, matrix4f.m13()).putFloat(n2 + 56, matrix4f.m23()).putFloat(n2 + 60, matrix4f.m33());
        }

        private void putTransposed0(Matrix4f matrix4f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix4f.m00()).putFloat(4, matrix4f.m10()).putFloat(8, matrix4f.m20()).putFloat(12, matrix4f.m30()).putFloat(16, matrix4f.m01()).putFloat(20, matrix4f.m11()).putFloat(24, matrix4f.m21()).putFloat(28, matrix4f.m31()).putFloat(32, matrix4f.m02()).putFloat(36, matrix4f.m12()).putFloat(40, matrix4f.m22()).putFloat(44, matrix4f.m32()).putFloat(48, matrix4f.m03()).putFloat(52, matrix4f.m13()).putFloat(56, matrix4f.m23()).putFloat(60, matrix4f.m33());
        }

        public void putTransposed(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            if (n2 == 0) {
                this.putTransposed0(matrix4f, byteBuffer);
                return;
            }
            this.putTransposedN(matrix4f, n2, byteBuffer);
        }

        public void put4x3Transposed(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix4f.m00()).put(n2 + 1, matrix4f.m10()).put(n2 + 2, matrix4f.m20()).put(n2 + 3, matrix4f.m30()).put(n2 + 4, matrix4f.m01()).put(n2 + 5, matrix4f.m11()).put(n2 + 6, matrix4f.m21()).put(n2 + 7, matrix4f.m31()).put(n2 + 8, matrix4f.m02()).put(n2 + 9, matrix4f.m12()).put(n2 + 10, matrix4f.m22()).put(n2 + 11, matrix4f.m32());
        }

        public void put4x3Transposed(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix4f.m00()).putFloat(n2 + 4, matrix4f.m10()).putFloat(n2 + 8, matrix4f.m20()).putFloat(n2 + 12, matrix4f.m30()).putFloat(n2 + 16, matrix4f.m01()).putFloat(n2 + 20, matrix4f.m11()).putFloat(n2 + 24, matrix4f.m21()).putFloat(n2 + 28, matrix4f.m31()).putFloat(n2 + 32, matrix4f.m02()).putFloat(n2 + 36, matrix4f.m12()).putFloat(n2 + 40, matrix4f.m22()).putFloat(n2 + 44, matrix4f.m32());
        }

        public void putTransposed(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix4x3f.m00()).put(n2 + 1, matrix4x3f.m10()).put(n2 + 2, matrix4x3f.m20()).put(n2 + 3, matrix4x3f.m30()).put(n2 + 4, matrix4x3f.m01()).put(n2 + 5, matrix4x3f.m11()).put(n2 + 6, matrix4x3f.m21()).put(n2 + 7, matrix4x3f.m31()).put(n2 + 8, matrix4x3f.m02()).put(n2 + 9, matrix4x3f.m12()).put(n2 + 10, matrix4x3f.m22()).put(n2 + 11, matrix4x3f.m32());
        }

        public void putTransposed(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix4x3f.m00()).putFloat(n2 + 4, matrix4x3f.m10()).putFloat(n2 + 8, matrix4x3f.m20()).putFloat(n2 + 12, matrix4x3f.m30()).putFloat(n2 + 16, matrix4x3f.m01()).putFloat(n2 + 20, matrix4x3f.m11()).putFloat(n2 + 24, matrix4x3f.m21()).putFloat(n2 + 28, matrix4x3f.m31()).putFloat(n2 + 32, matrix4x3f.m02()).putFloat(n2 + 36, matrix4x3f.m12()).putFloat(n2 + 40, matrix4x3f.m22()).putFloat(n2 + 44, matrix4x3f.m32());
        }

        public void putTransposed(Matrix3f matrix3f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix3f.m00()).put(n2 + 1, matrix3f.m10()).put(n2 + 2, matrix3f.m20()).put(n2 + 3, matrix3f.m01()).put(n2 + 4, matrix3f.m11()).put(n2 + 5, matrix3f.m21()).put(n2 + 6, matrix3f.m02()).put(n2 + 7, matrix3f.m12()).put(n2 + 8, matrix3f.m22());
        }

        public void putTransposed(Matrix3f matrix3f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix3f.m00()).putFloat(n2 + 4, matrix3f.m10()).putFloat(n2 + 8, matrix3f.m20()).putFloat(n2 + 12, matrix3f.m01()).putFloat(n2 + 16, matrix3f.m11()).putFloat(n2 + 20, matrix3f.m21()).putFloat(n2 + 24, matrix3f.m02()).putFloat(n2 + 28, matrix3f.m12()).putFloat(n2 + 32, matrix3f.m22());
        }

        public void putTransposed(Matrix2f matrix2f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix2f.m00()).put(n2 + 1, matrix2f.m10()).put(n2 + 2, matrix2f.m01()).put(n2 + 3, matrix2f.m11());
        }

        public void putTransposed(Matrix3x2f matrix3x2f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix3x2f.m00()).put(n2 + 1, matrix3x2f.m10()).put(n2 + 2, matrix3x2f.m20()).put(n2 + 3, matrix3x2f.m01()).put(n2 + 4, matrix3x2f.m11()).put(n2 + 5, matrix3x2f.m21());
        }

        public void putTransposed(Matrix2f matrix2f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix2f.m00()).putFloat(n2 + 4, matrix2f.m10()).putFloat(n2 + 8, matrix2f.m01()).putFloat(n2 + 12, matrix2f.m11());
        }

        public void put(Matrix4d matrix4d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix4d.m00()).put(n2 + 1, matrix4d.m01()).put(n2 + 2, matrix4d.m02()).put(n2 + 3, matrix4d.m03()).put(n2 + 4, matrix4d.m10()).put(n2 + 5, matrix4d.m11()).put(n2 + 6, matrix4d.m12()).put(n2 + 7, matrix4d.m13()).put(n2 + 8, matrix4d.m20()).put(n2 + 9, matrix4d.m21()).put(n2 + 10, matrix4d.m22()).put(n2 + 11, matrix4d.m23()).put(n2 + 12, matrix4d.m30()).put(n2 + 13, matrix4d.m31()).put(n2 + 14, matrix4d.m32()).put(n2 + 15, matrix4d.m33());
        }

        public void put(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix4d.m00()).putDouble(n2 + 8, matrix4d.m01()).putDouble(n2 + 16, matrix4d.m02()).putDouble(n2 + 24, matrix4d.m03()).putDouble(n2 + 32, matrix4d.m10()).putDouble(n2 + 40, matrix4d.m11()).putDouble(n2 + 48, matrix4d.m12()).putDouble(n2 + 56, matrix4d.m13()).putDouble(n2 + 64, matrix4d.m20()).putDouble(n2 + 72, matrix4d.m21()).putDouble(n2 + 80, matrix4d.m22()).putDouble(n2 + 88, matrix4d.m23()).putDouble(n2 + 96, matrix4d.m30()).putDouble(n2 + 104, matrix4d.m31()).putDouble(n2 + 112, matrix4d.m32()).putDouble(n2 + 120, matrix4d.m33());
        }

        public void put(Matrix4x3d matrix4x3d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix4x3d.m00()).put(n2 + 1, matrix4x3d.m01()).put(n2 + 2, matrix4x3d.m02()).put(n2 + 3, matrix4x3d.m10()).put(n2 + 4, matrix4x3d.m11()).put(n2 + 5, matrix4x3d.m12()).put(n2 + 6, matrix4x3d.m20()).put(n2 + 7, matrix4x3d.m21()).put(n2 + 8, matrix4x3d.m22()).put(n2 + 9, matrix4x3d.m30()).put(n2 + 10, matrix4x3d.m31()).put(n2 + 11, matrix4x3d.m32());
        }

        public void put(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix4x3d.m00()).putDouble(n2 + 8, matrix4x3d.m01()).putDouble(n2 + 16, matrix4x3d.m02()).putDouble(n2 + 24, matrix4x3d.m10()).putDouble(n2 + 32, matrix4x3d.m11()).putDouble(n2 + 40, matrix4x3d.m12()).putDouble(n2 + 48, matrix4x3d.m20()).putDouble(n2 + 56, matrix4x3d.m21()).putDouble(n2 + 64, matrix4x3d.m22()).putDouble(n2 + 72, matrix4x3d.m30()).putDouble(n2 + 80, matrix4x3d.m31()).putDouble(n2 + 88, matrix4x3d.m32());
        }

        public void putf(Matrix4d matrix4d, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, (float)matrix4d.m00()).put(n2 + 1, (float)matrix4d.m01()).put(n2 + 2, (float)matrix4d.m02()).put(n2 + 3, (float)matrix4d.m03()).put(n2 + 4, (float)matrix4d.m10()).put(n2 + 5, (float)matrix4d.m11()).put(n2 + 6, (float)matrix4d.m12()).put(n2 + 7, (float)matrix4d.m13()).put(n2 + 8, (float)matrix4d.m20()).put(n2 + 9, (float)matrix4d.m21()).put(n2 + 10, (float)matrix4d.m22()).put(n2 + 11, (float)matrix4d.m23()).put(n2 + 12, (float)matrix4d.m30()).put(n2 + 13, (float)matrix4d.m31()).put(n2 + 14, (float)matrix4d.m32()).put(n2 + 15, (float)matrix4d.m33());
        }

        public void putf(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, (float)matrix4d.m00()).putFloat(n2 + 4, (float)matrix4d.m01()).putFloat(n2 + 8, (float)matrix4d.m02()).putFloat(n2 + 12, (float)matrix4d.m03()).putFloat(n2 + 16, (float)matrix4d.m10()).putFloat(n2 + 20, (float)matrix4d.m11()).putFloat(n2 + 24, (float)matrix4d.m12()).putFloat(n2 + 28, (float)matrix4d.m13()).putFloat(n2 + 32, (float)matrix4d.m20()).putFloat(n2 + 36, (float)matrix4d.m21()).putFloat(n2 + 40, (float)matrix4d.m22()).putFloat(n2 + 44, (float)matrix4d.m23()).putFloat(n2 + 48, (float)matrix4d.m30()).putFloat(n2 + 52, (float)matrix4d.m31()).putFloat(n2 + 56, (float)matrix4d.m32()).putFloat(n2 + 60, (float)matrix4d.m33());
        }

        public void putf(Matrix4x3d matrix4x3d, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, (float)matrix4x3d.m00()).put(n2 + 1, (float)matrix4x3d.m01()).put(n2 + 2, (float)matrix4x3d.m02()).put(n2 + 3, (float)matrix4x3d.m10()).put(n2 + 4, (float)matrix4x3d.m11()).put(n2 + 5, (float)matrix4x3d.m12()).put(n2 + 6, (float)matrix4x3d.m20()).put(n2 + 7, (float)matrix4x3d.m21()).put(n2 + 8, (float)matrix4x3d.m22()).put(n2 + 9, (float)matrix4x3d.m30()).put(n2 + 10, (float)matrix4x3d.m31()).put(n2 + 11, (float)matrix4x3d.m32());
        }

        public void putf(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, (float)matrix4x3d.m00()).putFloat(n2 + 4, (float)matrix4x3d.m01()).putFloat(n2 + 8, (float)matrix4x3d.m02()).putFloat(n2 + 12, (float)matrix4x3d.m10()).putFloat(n2 + 16, (float)matrix4x3d.m11()).putFloat(n2 + 20, (float)matrix4x3d.m12()).putFloat(n2 + 24, (float)matrix4x3d.m20()).putFloat(n2 + 28, (float)matrix4x3d.m21()).putFloat(n2 + 32, (float)matrix4x3d.m22()).putFloat(n2 + 36, (float)matrix4x3d.m30()).putFloat(n2 + 40, (float)matrix4x3d.m31()).putFloat(n2 + 44, (float)matrix4x3d.m32());
        }

        public void putTransposed(Matrix4d matrix4d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix4d.m00()).put(n2 + 1, matrix4d.m10()).put(n2 + 2, matrix4d.m20()).put(n2 + 3, matrix4d.m30()).put(n2 + 4, matrix4d.m01()).put(n2 + 5, matrix4d.m11()).put(n2 + 6, matrix4d.m21()).put(n2 + 7, matrix4d.m31()).put(n2 + 8, matrix4d.m02()).put(n2 + 9, matrix4d.m12()).put(n2 + 10, matrix4d.m22()).put(n2 + 11, matrix4d.m32()).put(n2 + 12, matrix4d.m03()).put(n2 + 13, matrix4d.m13()).put(n2 + 14, matrix4d.m23()).put(n2 + 15, matrix4d.m33());
        }

        public void putTransposed(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix4d.m00()).putDouble(n2 + 8, matrix4d.m10()).putDouble(n2 + 16, matrix4d.m20()).putDouble(n2 + 24, matrix4d.m30()).putDouble(n2 + 32, matrix4d.m01()).putDouble(n2 + 40, matrix4d.m11()).putDouble(n2 + 48, matrix4d.m21()).putDouble(n2 + 56, matrix4d.m31()).putDouble(n2 + 64, matrix4d.m02()).putDouble(n2 + 72, matrix4d.m12()).putDouble(n2 + 80, matrix4d.m22()).putDouble(n2 + 88, matrix4d.m32()).putDouble(n2 + 96, matrix4d.m03()).putDouble(n2 + 104, matrix4d.m13()).putDouble(n2 + 112, matrix4d.m23()).putDouble(n2 + 120, matrix4d.m33());
        }

        public void put4x3Transposed(Matrix4d matrix4d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix4d.m00()).put(n2 + 1, matrix4d.m10()).put(n2 + 2, matrix4d.m20()).put(n2 + 3, matrix4d.m30()).put(n2 + 4, matrix4d.m01()).put(n2 + 5, matrix4d.m11()).put(n2 + 6, matrix4d.m21()).put(n2 + 7, matrix4d.m31()).put(n2 + 8, matrix4d.m02()).put(n2 + 9, matrix4d.m12()).put(n2 + 10, matrix4d.m22()).put(n2 + 11, matrix4d.m32());
        }

        public void put4x3Transposed(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix4d.m00()).putDouble(n2 + 8, matrix4d.m10()).putDouble(n2 + 16, matrix4d.m20()).putDouble(n2 + 24, matrix4d.m30()).putDouble(n2 + 32, matrix4d.m01()).putDouble(n2 + 40, matrix4d.m11()).putDouble(n2 + 48, matrix4d.m21()).putDouble(n2 + 56, matrix4d.m31()).putDouble(n2 + 64, matrix4d.m02()).putDouble(n2 + 72, matrix4d.m12()).putDouble(n2 + 80, matrix4d.m22()).putDouble(n2 + 88, matrix4d.m32());
        }

        public void putTransposed(Matrix4x3d matrix4x3d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix4x3d.m00()).put(n2 + 1, matrix4x3d.m10()).put(n2 + 2, matrix4x3d.m20()).put(n2 + 3, matrix4x3d.m30()).put(n2 + 4, matrix4x3d.m01()).put(n2 + 5, matrix4x3d.m11()).put(n2 + 6, matrix4x3d.m21()).put(n2 + 7, matrix4x3d.m31()).put(n2 + 8, matrix4x3d.m02()).put(n2 + 9, matrix4x3d.m12()).put(n2 + 10, matrix4x3d.m22()).put(n2 + 11, matrix4x3d.m32());
        }

        public void putTransposed(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix4x3d.m00()).putDouble(n2 + 8, matrix4x3d.m10()).putDouble(n2 + 16, matrix4x3d.m20()).putDouble(n2 + 24, matrix4x3d.m30()).putDouble(n2 + 32, matrix4x3d.m01()).putDouble(n2 + 40, matrix4x3d.m11()).putDouble(n2 + 48, matrix4x3d.m21()).putDouble(n2 + 56, matrix4x3d.m31()).putDouble(n2 + 64, matrix4x3d.m02()).putDouble(n2 + 72, matrix4x3d.m12()).putDouble(n2 + 80, matrix4x3d.m22()).putDouble(n2 + 88, matrix4x3d.m32());
        }

        public void putTransposed(Matrix3d matrix3d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix3d.m00()).put(n2 + 1, matrix3d.m10()).put(n2 + 2, matrix3d.m20()).put(n2 + 3, matrix3d.m01()).put(n2 + 4, matrix3d.m11()).put(n2 + 5, matrix3d.m21()).put(n2 + 6, matrix3d.m02()).put(n2 + 7, matrix3d.m12()).put(n2 + 8, matrix3d.m22());
        }

        public void putTransposed(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix3d.m00()).putDouble(n2 + 8, matrix3d.m10()).putDouble(n2 + 16, matrix3d.m20()).putDouble(n2 + 24, matrix3d.m01()).putDouble(n2 + 32, matrix3d.m11()).putDouble(n2 + 40, matrix3d.m21()).putDouble(n2 + 48, matrix3d.m02()).putDouble(n2 + 56, matrix3d.m12()).putDouble(n2 + 64, matrix3d.m22());
        }

        public void putTransposed(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix3x2d.m00()).putDouble(n2 + 8, matrix3x2d.m10()).putDouble(n2 + 16, matrix3x2d.m20()).putDouble(n2 + 24, matrix3x2d.m01()).putDouble(n2 + 32, matrix3x2d.m11()).putDouble(n2 + 40, matrix3x2d.m21());
        }

        public void putTransposed(Matrix3x2d matrix3x2d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix3x2d.m00()).put(n2 + 1, matrix3x2d.m10()).put(n2 + 2, matrix3x2d.m20()).put(n2 + 3, matrix3x2d.m01()).put(n2 + 4, matrix3x2d.m11()).put(n2 + 5, matrix3x2d.m21());
        }

        public void putTransposed(Matrix2d matrix2d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix2d.m00()).put(n2 + 1, matrix2d.m10()).put(n2 + 2, matrix2d.m01()).put(n2 + 3, matrix2d.m11());
        }

        public void putTransposed(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix2d.m00()).putDouble(n2 + 8, matrix2d.m10()).putDouble(n2 + 16, matrix2d.m01()).putDouble(n2 + 24, matrix2d.m11());
        }

        public void putfTransposed(Matrix4x3d matrix4x3d, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, (float)matrix4x3d.m00()).put(n2 + 1, (float)matrix4x3d.m10()).put(n2 + 2, (float)matrix4x3d.m20()).put(n2 + 3, (float)matrix4x3d.m30()).put(n2 + 4, (float)matrix4x3d.m01()).put(n2 + 5, (float)matrix4x3d.m11()).put(n2 + 6, (float)matrix4x3d.m21()).put(n2 + 7, (float)matrix4x3d.m31()).put(n2 + 8, (float)matrix4x3d.m02()).put(n2 + 9, (float)matrix4x3d.m12()).put(n2 + 10, (float)matrix4x3d.m22()).put(n2 + 11, (float)matrix4x3d.m32());
        }

        public void putfTransposed(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, (float)matrix4x3d.m00()).putFloat(n2 + 4, (float)matrix4x3d.m10()).putFloat(n2 + 8, (float)matrix4x3d.m20()).putFloat(n2 + 12, (float)matrix4x3d.m30()).putFloat(n2 + 16, (float)matrix4x3d.m01()).putFloat(n2 + 20, (float)matrix4x3d.m11()).putFloat(n2 + 24, (float)matrix4x3d.m21()).putFloat(n2 + 28, (float)matrix4x3d.m31()).putFloat(n2 + 32, (float)matrix4x3d.m02()).putFloat(n2 + 36, (float)matrix4x3d.m12()).putFloat(n2 + 40, (float)matrix4x3d.m22()).putFloat(n2 + 44, (float)matrix4x3d.m32());
        }

        public void putfTransposed(Matrix3d matrix3d, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, (float)matrix3d.m00()).put(n2 + 1, (float)matrix3d.m10()).put(n2 + 2, (float)matrix3d.m20()).put(n2 + 3, (float)matrix3d.m01()).put(n2 + 4, (float)matrix3d.m11()).put(n2 + 5, (float)matrix3d.m21()).put(n2 + 6, (float)matrix3d.m02()).put(n2 + 7, (float)matrix3d.m12()).put(n2 + 8, (float)matrix3d.m22());
        }

        public void putfTransposed(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, (float)matrix3d.m00()).putFloat(n2 + 4, (float)matrix3d.m10()).putFloat(n2 + 8, (float)matrix3d.m20()).putFloat(n2 + 12, (float)matrix3d.m01()).putFloat(n2 + 16, (float)matrix3d.m11()).putFloat(n2 + 20, (float)matrix3d.m21()).putFloat(n2 + 24, (float)matrix3d.m02()).putFloat(n2 + 28, (float)matrix3d.m12()).putFloat(n2 + 32, (float)matrix3d.m22());
        }

        public void putfTransposed(Matrix3x2d matrix3x2d, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, (float)matrix3x2d.m00()).put(n2 + 1, (float)matrix3x2d.m10()).put(n2 + 2, (float)matrix3x2d.m20()).put(n2 + 3, (float)matrix3x2d.m01()).put(n2 + 4, (float)matrix3x2d.m11()).put(n2 + 5, (float)matrix3x2d.m21());
        }

        public void putfTransposed(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, (float)matrix3x2d.m00()).putFloat(n2 + 4, (float)matrix3x2d.m10()).putFloat(n2 + 8, (float)matrix3x2d.m20()).putFloat(n2 + 12, (float)matrix3x2d.m01()).putFloat(n2 + 16, (float)matrix3x2d.m11()).putFloat(n2 + 20, (float)matrix3x2d.m21());
        }

        public void putfTransposed(Matrix2d matrix2d, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, (float)matrix2d.m00()).put(n2 + 1, (float)matrix2d.m10()).put(n2 + 2, (float)matrix2d.m01()).put(n2 + 3, (float)matrix2d.m11());
        }

        public void putfTransposed(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, (float)matrix2d.m00()).putFloat(n2 + 4, (float)matrix2d.m10()).putFloat(n2 + 8, (float)matrix2d.m01()).putFloat(n2 + 12, (float)matrix2d.m11());
        }

        public void putfTransposed(Matrix4d matrix4d, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, (float)matrix4d.m00()).put(n2 + 1, (float)matrix4d.m10()).put(n2 + 2, (float)matrix4d.m20()).put(n2 + 3, (float)matrix4d.m30()).put(n2 + 4, (float)matrix4d.m01()).put(n2 + 5, (float)matrix4d.m11()).put(n2 + 6, (float)matrix4d.m21()).put(n2 + 7, (float)matrix4d.m31()).put(n2 + 8, (float)matrix4d.m02()).put(n2 + 9, (float)matrix4d.m12()).put(n2 + 10, (float)matrix4d.m22()).put(n2 + 11, (float)matrix4d.m32()).put(n2 + 12, (float)matrix4d.m03()).put(n2 + 13, (float)matrix4d.m13()).put(n2 + 14, (float)matrix4d.m23()).put(n2 + 15, (float)matrix4d.m33());
        }

        public void putfTransposed(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, (float)matrix4d.m00()).putFloat(n2 + 4, (float)matrix4d.m10()).putFloat(n2 + 8, (float)matrix4d.m20()).putFloat(n2 + 12, (float)matrix4d.m30()).putFloat(n2 + 16, (float)matrix4d.m01()).putFloat(n2 + 20, (float)matrix4d.m11()).putFloat(n2 + 24, (float)matrix4d.m21()).putFloat(n2 + 28, (float)matrix4d.m31()).putFloat(n2 + 32, (float)matrix4d.m02()).putFloat(n2 + 36, (float)matrix4d.m12()).putFloat(n2 + 40, (float)matrix4d.m22()).putFloat(n2 + 44, (float)matrix4d.m32()).putFloat(n2 + 48, (float)matrix4d.m03()).putFloat(n2 + 52, (float)matrix4d.m13()).putFloat(n2 + 56, (float)matrix4d.m23()).putFloat(n2 + 60, (float)matrix4d.m33());
        }

        public void put0(Matrix3f matrix3f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix3f.m00()).put(1, matrix3f.m01()).put(2, matrix3f.m02()).put(3, matrix3f.m10()).put(4, matrix3f.m11()).put(5, matrix3f.m12()).put(6, matrix3f.m20()).put(7, matrix3f.m21()).put(8, matrix3f.m22());
        }

        public void putN(Matrix3f matrix3f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix3f.m00()).put(n2 + 1, matrix3f.m01()).put(n2 + 2, matrix3f.m02()).put(n2 + 3, matrix3f.m10()).put(n2 + 4, matrix3f.m11()).put(n2 + 5, matrix3f.m12()).put(n2 + 6, matrix3f.m20()).put(n2 + 7, matrix3f.m21()).put(n2 + 8, matrix3f.m22());
        }

        public void put(Matrix3f matrix3f, int n2, FloatBuffer floatBuffer) {
            if (n2 == 0) {
                this.put0(matrix3f, floatBuffer);
                return;
            }
            this.putN(matrix3f, n2, floatBuffer);
        }

        public void put0(Matrix3f matrix3f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix3f.m00()).putFloat(4, matrix3f.m01()).putFloat(8, matrix3f.m02()).putFloat(12, matrix3f.m10()).putFloat(16, matrix3f.m11()).putFloat(20, matrix3f.m12()).putFloat(24, matrix3f.m20()).putFloat(28, matrix3f.m21()).putFloat(32, matrix3f.m22());
        }

        public void putN(Matrix3f matrix3f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix3f.m00()).putFloat(n2 + 4, matrix3f.m01()).putFloat(n2 + 8, matrix3f.m02()).putFloat(n2 + 12, matrix3f.m10()).putFloat(n2 + 16, matrix3f.m11()).putFloat(n2 + 20, matrix3f.m12()).putFloat(n2 + 24, matrix3f.m20()).putFloat(n2 + 28, matrix3f.m21()).putFloat(n2 + 32, matrix3f.m22());
        }

        public void put(Matrix3f matrix3f, int n2, ByteBuffer byteBuffer) {
            if (n2 == 0) {
                this.put0(matrix3f, byteBuffer);
                return;
            }
            this.putN(matrix3f, n2, byteBuffer);
        }

        public void put3x4_0(Matrix3f matrix3f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(0, matrix3f.m00()).putFloat(4, matrix3f.m01()).putFloat(8, matrix3f.m02()).putFloat(12, 0.0f).putFloat(16, matrix3f.m10()).putFloat(20, matrix3f.m11()).putFloat(24, matrix3f.m12()).putFloat(28, 0.0f).putFloat(32, matrix3f.m20()).putFloat(36, matrix3f.m21()).putFloat(40, matrix3f.m22()).putFloat(44, 0.0f);
        }

        private void put3x4_N(Matrix3f matrix3f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix3f.m00()).putFloat(n2 + 4, matrix3f.m01()).putFloat(n2 + 8, matrix3f.m02()).putFloat(n2 + 12, 0.0f).putFloat(n2 + 16, matrix3f.m10()).putFloat(n2 + 20, matrix3f.m11()).putFloat(n2 + 24, matrix3f.m12()).putFloat(n2 + 28, 0.0f).putFloat(n2 + 32, matrix3f.m20()).putFloat(n2 + 36, matrix3f.m21()).putFloat(n2 + 40, matrix3f.m22()).putFloat(n2 + 44, 0.0f);
        }

        public void put3x4(Matrix3f matrix3f, int n2, ByteBuffer byteBuffer) {
            if (n2 == 0) {
                this.put3x4_0(matrix3f, byteBuffer);
                return;
            }
            this.put3x4_N(matrix3f, n2, byteBuffer);
        }

        public void put3x4_0(Matrix3f matrix3f, FloatBuffer floatBuffer) {
            floatBuffer.put(0, matrix3f.m00()).put(1, matrix3f.m01()).put(2, matrix3f.m02()).put(3, 0.0f).put(4, matrix3f.m10()).put(5, matrix3f.m11()).put(6, matrix3f.m12()).put(7, 0.0f).put(8, matrix3f.m20()).put(9, matrix3f.m21()).put(10, matrix3f.m22()).put(11, 0.0f);
        }

        public void put3x4_N(Matrix3f matrix3f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix3f.m00()).put(n2 + 1, matrix3f.m01()).put(n2 + 2, matrix3f.m02()).put(n2 + 3, 0.0f).put(n2 + 4, matrix3f.m10()).put(n2 + 5, matrix3f.m11()).put(n2 + 6, matrix3f.m12()).put(n2 + 7, 0.0f).put(n2 + 8, matrix3f.m20()).put(n2 + 9, matrix3f.m21()).put(n2 + 10, matrix3f.m22()).put(n2 + 11, 0.0f);
        }

        public void put3x4(Matrix3f matrix3f, int n2, FloatBuffer floatBuffer) {
            if (n2 == 0) {
                this.put3x4_0(matrix3f, floatBuffer);
                return;
            }
            this.put3x4_N(matrix3f, n2, floatBuffer);
        }

        public void put(Matrix3d matrix3d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix3d.m00()).put(n2 + 1, matrix3d.m01()).put(n2 + 2, matrix3d.m02()).put(n2 + 3, matrix3d.m10()).put(n2 + 4, matrix3d.m11()).put(n2 + 5, matrix3d.m12()).put(n2 + 6, matrix3d.m20()).put(n2 + 7, matrix3d.m21()).put(n2 + 8, matrix3d.m22());
        }

        public void put(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix3d.m00()).putDouble(n2 + 8, matrix3d.m01()).putDouble(n2 + 16, matrix3d.m02()).putDouble(n2 + 24, matrix3d.m10()).putDouble(n2 + 32, matrix3d.m11()).putDouble(n2 + 40, matrix3d.m12()).putDouble(n2 + 48, matrix3d.m20()).putDouble(n2 + 56, matrix3d.m21()).putDouble(n2 + 64, matrix3d.m22());
        }

        public void put(Matrix3x2f matrix3x2f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix3x2f.m00()).put(n2 + 1, matrix3x2f.m01()).put(n2 + 2, matrix3x2f.m10()).put(n2 + 3, matrix3x2f.m11()).put(n2 + 4, matrix3x2f.m20()).put(n2 + 5, matrix3x2f.m21());
        }

        public void put(Matrix3x2f matrix3x2f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix3x2f.m00()).putFloat(n2 + 4, matrix3x2f.m01()).putFloat(n2 + 8, matrix3x2f.m10()).putFloat(n2 + 12, matrix3x2f.m11()).putFloat(n2 + 16, matrix3x2f.m20()).putFloat(n2 + 20, matrix3x2f.m21());
        }

        public void put(Matrix3x2d matrix3x2d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix3x2d.m00()).put(n2 + 1, matrix3x2d.m01()).put(n2 + 2, matrix3x2d.m10()).put(n2 + 3, matrix3x2d.m11()).put(n2 + 4, matrix3x2d.m20()).put(n2 + 5, matrix3x2d.m21());
        }

        public void put(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix3x2d.m00()).putDouble(n2 + 8, matrix3x2d.m01()).putDouble(n2 + 16, matrix3x2d.m10()).putDouble(n2 + 24, matrix3x2d.m11()).putDouble(n2 + 32, matrix3x2d.m20()).putDouble(n2 + 40, matrix3x2d.m21());
        }

        public void putf(Matrix3d matrix3d, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, (float)matrix3d.m00()).put(n2 + 1, (float)matrix3d.m01()).put(n2 + 2, (float)matrix3d.m02()).put(n2 + 3, (float)matrix3d.m10()).put(n2 + 4, (float)matrix3d.m11()).put(n2 + 5, (float)matrix3d.m12()).put(n2 + 6, (float)matrix3d.m20()).put(n2 + 7, (float)matrix3d.m21()).put(n2 + 8, (float)matrix3d.m22());
        }

        public void put(Matrix2f matrix2f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, matrix2f.m00()).put(n2 + 1, matrix2f.m01()).put(n2 + 2, matrix2f.m10()).put(n2 + 3, matrix2f.m11());
        }

        public void put(Matrix2f matrix2f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, matrix2f.m00()).putFloat(n2 + 4, matrix2f.m01()).putFloat(n2 + 8, matrix2f.m10()).putFloat(n2 + 12, matrix2f.m11());
        }

        public void put(Matrix2d matrix2d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, matrix2d.m00()).put(n2 + 1, matrix2d.m01()).put(n2 + 2, matrix2d.m10()).put(n2 + 3, matrix2d.m11());
        }

        public void put(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, matrix2d.m00()).putDouble(n2 + 8, matrix2d.m01()).putDouble(n2 + 16, matrix2d.m10()).putDouble(n2 + 24, matrix2d.m11());
        }

        public void putf(Matrix2d matrix2d, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, (float)matrix2d.m00()).put(n2 + 1, (float)matrix2d.m01()).put(n2 + 2, (float)matrix2d.m10()).put(n2 + 3, (float)matrix2d.m11());
        }

        public void putf(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, (float)matrix2d.m00()).putFloat(n2 + 4, (float)matrix2d.m01()).putFloat(n2 + 8, (float)matrix2d.m10()).putFloat(n2 + 12, (float)matrix2d.m11());
        }

        public void putf(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, (float)matrix3d.m00()).putFloat(n2 + 4, (float)matrix3d.m01()).putFloat(n2 + 8, (float)matrix3d.m02()).putFloat(n2 + 12, (float)matrix3d.m10()).putFloat(n2 + 16, (float)matrix3d.m11()).putFloat(n2 + 20, (float)matrix3d.m12()).putFloat(n2 + 24, (float)matrix3d.m20()).putFloat(n2 + 28, (float)matrix3d.m21()).putFloat(n2 + 32, (float)matrix3d.m22());
        }

        public void put(Vector4d vector4d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, vector4d.x).put(n2 + 1, vector4d.y).put(n2 + 2, vector4d.z).put(n2 + 3, vector4d.w);
        }

        public void put(Vector4d vector4d, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, (float)vector4d.x).put(n2 + 1, (float)vector4d.y).put(n2 + 2, (float)vector4d.z).put(n2 + 3, (float)vector4d.w);
        }

        public void put(Vector4d vector4d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, vector4d.x).putDouble(n2 + 8, vector4d.y).putDouble(n2 + 16, vector4d.z).putDouble(n2 + 24, vector4d.w);
        }

        public void putf(Vector4d vector4d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, (float)vector4d.x).putFloat(n2 + 4, (float)vector4d.y).putFloat(n2 + 8, (float)vector4d.z).putFloat(n2 + 12, (float)vector4d.w);
        }

        public void put(Vector4f vector4f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, vector4f.x).put(n2 + 1, vector4f.y).put(n2 + 2, vector4f.z).put(n2 + 3, vector4f.w);
        }

        public void put(Vector4f vector4f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, vector4f.x).putFloat(n2 + 4, vector4f.y).putFloat(n2 + 8, vector4f.z).putFloat(n2 + 12, vector4f.w);
        }

        public void put(Vector4L vector4L, int n2, LongBuffer longBuffer) {
            longBuffer.put(n2, vector4L.x).put(n2 + 1, vector4L.y).put(n2 + 2, vector4L.z).put(n2 + 3, vector4L.w);
        }

        public void put(Vector4L vector4L, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putLong(n2, vector4L.x).putLong(n2 + 8, vector4L.y).putLong(n2 + 16, vector4L.z).putLong(n2 + 24, vector4L.w);
        }

        public void put(Vector4i vector4i, int n2, IntBuffer intBuffer) {
            intBuffer.put(n2, vector4i.x).put(n2 + 1, vector4i.y).put(n2 + 2, vector4i.z).put(n2 + 3, vector4i.w);
        }

        public void put(Vector4i vector4i, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putInt(n2, vector4i.x).putInt(n2 + 4, vector4i.y).putInt(n2 + 8, vector4i.z).putInt(n2 + 12, vector4i.w);
        }

        public void put(Vector3f vector3f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, vector3f.x).put(n2 + 1, vector3f.y).put(n2 + 2, vector3f.z);
        }

        public void put(Vector3f vector3f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, vector3f.x).putFloat(n2 + 4, vector3f.y).putFloat(n2 + 8, vector3f.z);
        }

        public void put(Vector3d vector3d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, vector3d.x).put(n2 + 1, vector3d.y).put(n2 + 2, vector3d.z);
        }

        public void put(Vector3d vector3d, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, (float)vector3d.x).put(n2 + 1, (float)vector3d.y).put(n2 + 2, (float)vector3d.z);
        }

        public void put(Vector3d vector3d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, vector3d.x).putDouble(n2 + 8, vector3d.y).putDouble(n2 + 16, vector3d.z);
        }

        public void putf(Vector3d vector3d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, (float)vector3d.x).putFloat(n2 + 4, (float)vector3d.y).putFloat(n2 + 8, (float)vector3d.z);
        }

        public void put(Vector3i vector3i, int n2, IntBuffer intBuffer) {
            intBuffer.put(n2, vector3i.x).put(n2 + 1, vector3i.y).put(n2 + 2, vector3i.z);
        }

        public void put(Vector3i vector3i, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putInt(n2, vector3i.x).putInt(n2 + 4, vector3i.y).putInt(n2 + 8, vector3i.z);
        }

        public void put(Vector3L vector3L, int n2, LongBuffer longBuffer) {
            longBuffer.put(n2, vector3L.x).put(n2 + 1, vector3L.y).put(n2 + 2, vector3L.z);
        }

        public void put(Vector3L vector3L, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putLong(n2, vector3L.x).putLong(n2 + 8, vector3L.y).putLong(n2 + 16, vector3L.z);
        }

        public void put(Vector2f vector2f, int n2, FloatBuffer floatBuffer) {
            floatBuffer.put(n2, vector2f.x).put(n2 + 1, vector2f.y);
        }

        public void put(Vector2f vector2f, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(n2, vector2f.x).putFloat(n2 + 4, vector2f.y);
        }

        public void put(Vector2d vector2d, int n2, DoubleBuffer doubleBuffer) {
            doubleBuffer.put(n2, vector2d.x).put(n2 + 1, vector2d.y);
        }

        public void put(Vector2d vector2d, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(n2, vector2d.x).putDouble(n2 + 8, vector2d.y);
        }

        public void put(Vector2i vector2i, int n2, IntBuffer intBuffer) {
            intBuffer.put(n2, vector2i.x).put(n2 + 1, vector2i.y);
        }

        public void put(Vector2i vector2i, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putInt(n2, vector2i.x).putInt(n2 + 4, vector2i.y);
        }

        public void put(Vector2i vector2i, int n2, LongBuffer longBuffer) {
            longBuffer.put(n2, vector2i.x).put(n2 + 1, vector2i.y);
        }

        public void put(Vector2L vector2L, int n2, ByteBuffer byteBuffer) {
            byteBuffer.putLong(n2, vector2L.x).putLong(n2 + 8, vector2L.y);
        }

        public void put(Vector2L vector2L, int n2, LongBuffer longBuffer) {
            longBuffer.put(n2, vector2L.x).put(n2 + 1, vector2L.y);
        }

        public void get(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            matrix4f._m00(floatBuffer.get(n2))._m01(floatBuffer.get(n2 + 1))._m02(floatBuffer.get(n2 + 2))._m03(floatBuffer.get(n2 + 3))._m10(floatBuffer.get(n2 + 4))._m11(floatBuffer.get(n2 + 5))._m12(floatBuffer.get(n2 + 6))._m13(floatBuffer.get(n2 + 7))._m20(floatBuffer.get(n2 + 8))._m21(floatBuffer.get(n2 + 9))._m22(floatBuffer.get(n2 + 10))._m23(floatBuffer.get(n2 + 11))._m30(floatBuffer.get(n2 + 12))._m31(floatBuffer.get(n2 + 13))._m32(floatBuffer.get(n2 + 14))._m33(floatBuffer.get(n2 + 15));
        }

        public void get(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            matrix4f._m00(byteBuffer.getFloat(n2))._m01(byteBuffer.getFloat(n2 + 4))._m02(byteBuffer.getFloat(n2 + 8))._m03(byteBuffer.getFloat(n2 + 12))._m10(byteBuffer.getFloat(n2 + 16))._m11(byteBuffer.getFloat(n2 + 20))._m12(byteBuffer.getFloat(n2 + 24))._m13(byteBuffer.getFloat(n2 + 28))._m20(byteBuffer.getFloat(n2 + 32))._m21(byteBuffer.getFloat(n2 + 36))._m22(byteBuffer.getFloat(n2 + 40))._m23(byteBuffer.getFloat(n2 + 44))._m30(byteBuffer.getFloat(n2 + 48))._m31(byteBuffer.getFloat(n2 + 52))._m32(byteBuffer.getFloat(n2 + 56))._m33(byteBuffer.getFloat(n2 + 60));
        }

        public void getTransposed(Matrix4f matrix4f, int n2, FloatBuffer floatBuffer) {
            matrix4f._m00(floatBuffer.get(n2))._m10(floatBuffer.get(n2 + 1))._m20(floatBuffer.get(n2 + 2))._m30(floatBuffer.get(n2 + 3))._m01(floatBuffer.get(n2 + 4))._m11(floatBuffer.get(n2 + 5))._m21(floatBuffer.get(n2 + 6))._m31(floatBuffer.get(n2 + 7))._m02(floatBuffer.get(n2 + 8))._m12(floatBuffer.get(n2 + 9))._m22(floatBuffer.get(n2 + 10))._m32(floatBuffer.get(n2 + 11))._m03(floatBuffer.get(n2 + 12))._m13(floatBuffer.get(n2 + 13))._m23(floatBuffer.get(n2 + 14))._m33(floatBuffer.get(n2 + 15));
        }

        public void getTransposed(Matrix4f matrix4f, int n2, ByteBuffer byteBuffer) {
            matrix4f._m00(byteBuffer.getFloat(n2))._m10(byteBuffer.getFloat(n2 + 4))._m20(byteBuffer.getFloat(n2 + 8))._m30(byteBuffer.getFloat(n2 + 12))._m01(byteBuffer.getFloat(n2 + 16))._m11(byteBuffer.getFloat(n2 + 20))._m21(byteBuffer.getFloat(n2 + 24))._m31(byteBuffer.getFloat(n2 + 28))._m02(byteBuffer.getFloat(n2 + 32))._m12(byteBuffer.getFloat(n2 + 36))._m22(byteBuffer.getFloat(n2 + 40))._m32(byteBuffer.getFloat(n2 + 44))._m03(byteBuffer.getFloat(n2 + 48))._m13(byteBuffer.getFloat(n2 + 52))._m23(byteBuffer.getFloat(n2 + 56))._m33(byteBuffer.getFloat(n2 + 60));
        }

        public void get(Matrix4x3f matrix4x3f, int n2, FloatBuffer floatBuffer) {
            matrix4x3f._m00(floatBuffer.get(n2))._m01(floatBuffer.get(n2 + 1))._m02(floatBuffer.get(n2 + 2))._m10(floatBuffer.get(n2 + 3))._m11(floatBuffer.get(n2 + 4))._m12(floatBuffer.get(n2 + 5))._m20(floatBuffer.get(n2 + 6))._m21(floatBuffer.get(n2 + 7))._m22(floatBuffer.get(n2 + 8))._m30(floatBuffer.get(n2 + 9))._m31(floatBuffer.get(n2 + 10))._m32(floatBuffer.get(n2 + 11));
        }

        public void get(Matrix4x3f matrix4x3f, int n2, ByteBuffer byteBuffer) {
            matrix4x3f._m00(byteBuffer.getFloat(n2))._m01(byteBuffer.getFloat(n2 + 4))._m02(byteBuffer.getFloat(n2 + 8))._m10(byteBuffer.getFloat(n2 + 12))._m11(byteBuffer.getFloat(n2 + 16))._m12(byteBuffer.getFloat(n2 + 20))._m20(byteBuffer.getFloat(n2 + 24))._m21(byteBuffer.getFloat(n2 + 28))._m22(byteBuffer.getFloat(n2 + 32))._m30(byteBuffer.getFloat(n2 + 36))._m31(byteBuffer.getFloat(n2 + 40))._m32(byteBuffer.getFloat(n2 + 44));
        }

        public void get(Matrix4d matrix4d, int n2, DoubleBuffer doubleBuffer) {
            matrix4d._m00(doubleBuffer.get(n2))._m01(doubleBuffer.get(n2 + 1))._m02(doubleBuffer.get(n2 + 2))._m03(doubleBuffer.get(n2 + 3))._m10(doubleBuffer.get(n2 + 4))._m11(doubleBuffer.get(n2 + 5))._m12(doubleBuffer.get(n2 + 6))._m13(doubleBuffer.get(n2 + 7))._m20(doubleBuffer.get(n2 + 8))._m21(doubleBuffer.get(n2 + 9))._m22(doubleBuffer.get(n2 + 10))._m23(doubleBuffer.get(n2 + 11))._m30(doubleBuffer.get(n2 + 12))._m31(doubleBuffer.get(n2 + 13))._m32(doubleBuffer.get(n2 + 14))._m33(doubleBuffer.get(n2 + 15));
        }

        public void get(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            matrix4d._m00(byteBuffer.getDouble(n2))._m01(byteBuffer.getDouble(n2 + 8))._m02(byteBuffer.getDouble(n2 + 16))._m03(byteBuffer.getDouble(n2 + 24))._m10(byteBuffer.getDouble(n2 + 32))._m11(byteBuffer.getDouble(n2 + 40))._m12(byteBuffer.getDouble(n2 + 48))._m13(byteBuffer.getDouble(n2 + 56))._m20(byteBuffer.getDouble(n2 + 64))._m21(byteBuffer.getDouble(n2 + 72))._m22(byteBuffer.getDouble(n2 + 80))._m23(byteBuffer.getDouble(n2 + 88))._m30(byteBuffer.getDouble(n2 + 96))._m31(byteBuffer.getDouble(n2 + 104))._m32(byteBuffer.getDouble(n2 + 112))._m33(byteBuffer.getDouble(n2 + 120));
        }

        public void get(Matrix4x3d matrix4x3d, int n2, DoubleBuffer doubleBuffer) {
            matrix4x3d._m00(doubleBuffer.get(n2))._m01(doubleBuffer.get(n2 + 1))._m02(doubleBuffer.get(n2 + 2))._m10(doubleBuffer.get(n2 + 3))._m11(doubleBuffer.get(n2 + 4))._m12(doubleBuffer.get(n2 + 5))._m20(doubleBuffer.get(n2 + 6))._m21(doubleBuffer.get(n2 + 7))._m22(doubleBuffer.get(n2 + 8))._m30(doubleBuffer.get(n2 + 9))._m31(doubleBuffer.get(n2 + 10))._m32(doubleBuffer.get(n2 + 11));
        }

        public void get(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            matrix4x3d._m00(byteBuffer.getDouble(n2))._m01(byteBuffer.getDouble(n2 + 8))._m02(byteBuffer.getDouble(n2 + 16))._m10(byteBuffer.getDouble(n2 + 24))._m11(byteBuffer.getDouble(n2 + 32))._m12(byteBuffer.getDouble(n2 + 40))._m20(byteBuffer.getDouble(n2 + 48))._m21(byteBuffer.getDouble(n2 + 56))._m22(byteBuffer.getDouble(n2 + 64))._m30(byteBuffer.getDouble(n2 + 72))._m31(byteBuffer.getDouble(n2 + 80))._m32(byteBuffer.getDouble(n2 + 88));
        }

        public void getf(Matrix4d matrix4d, int n2, FloatBuffer floatBuffer) {
            matrix4d._m00(floatBuffer.get(n2))._m01(floatBuffer.get(n2 + 1))._m02(floatBuffer.get(n2 + 2))._m03(floatBuffer.get(n2 + 3))._m10(floatBuffer.get(n2 + 4))._m11(floatBuffer.get(n2 + 5))._m12(floatBuffer.get(n2 + 6))._m13(floatBuffer.get(n2 + 7))._m20(floatBuffer.get(n2 + 8))._m21(floatBuffer.get(n2 + 9))._m22(floatBuffer.get(n2 + 10))._m23(floatBuffer.get(n2 + 11))._m30(floatBuffer.get(n2 + 12))._m31(floatBuffer.get(n2 + 13))._m32(floatBuffer.get(n2 + 14))._m33(floatBuffer.get(n2 + 15));
        }

        public void getf(Matrix4d matrix4d, int n2, ByteBuffer byteBuffer) {
            matrix4d._m00(byteBuffer.getFloat(n2))._m01(byteBuffer.getFloat(n2 + 4))._m02(byteBuffer.getFloat(n2 + 8))._m03(byteBuffer.getFloat(n2 + 12))._m10(byteBuffer.getFloat(n2 + 16))._m11(byteBuffer.getFloat(n2 + 20))._m12(byteBuffer.getFloat(n2 + 24))._m13(byteBuffer.getFloat(n2 + 28))._m20(byteBuffer.getFloat(n2 + 32))._m21(byteBuffer.getFloat(n2 + 36))._m22(byteBuffer.getFloat(n2 + 40))._m23(byteBuffer.getFloat(n2 + 44))._m30(byteBuffer.getFloat(n2 + 48))._m31(byteBuffer.getFloat(n2 + 52))._m32(byteBuffer.getFloat(n2 + 56))._m33(byteBuffer.getFloat(n2 + 60));
        }

        public void getf(Matrix4x3d matrix4x3d, int n2, FloatBuffer floatBuffer) {
            matrix4x3d._m00(floatBuffer.get(n2))._m01(floatBuffer.get(n2 + 1))._m02(floatBuffer.get(n2 + 2))._m10(floatBuffer.get(n2 + 3))._m11(floatBuffer.get(n2 + 4))._m12(floatBuffer.get(n2 + 5))._m20(floatBuffer.get(n2 + 6))._m21(floatBuffer.get(n2 + 7))._m22(floatBuffer.get(n2 + 8))._m30(floatBuffer.get(n2 + 9))._m31(floatBuffer.get(n2 + 10))._m32(floatBuffer.get(n2 + 11));
        }

        public void getf(Matrix4x3d matrix4x3d, int n2, ByteBuffer byteBuffer) {
            matrix4x3d._m00(byteBuffer.getFloat(n2))._m01(byteBuffer.getFloat(n2 + 4))._m02(byteBuffer.getFloat(n2 + 8))._m10(byteBuffer.getFloat(n2 + 12))._m11(byteBuffer.getFloat(n2 + 16))._m12(byteBuffer.getFloat(n2 + 20))._m20(byteBuffer.getFloat(n2 + 24))._m21(byteBuffer.getFloat(n2 + 28))._m22(byteBuffer.getFloat(n2 + 32))._m30(byteBuffer.getFloat(n2 + 36))._m31(byteBuffer.getFloat(n2 + 40))._m32(byteBuffer.getFloat(n2 + 44));
        }

        public void get(Matrix3f matrix3f, int n2, FloatBuffer floatBuffer) {
            matrix3f._m00(floatBuffer.get(n2))._m01(floatBuffer.get(n2 + 1))._m02(floatBuffer.get(n2 + 2))._m10(floatBuffer.get(n2 + 3))._m11(floatBuffer.get(n2 + 4))._m12(floatBuffer.get(n2 + 5))._m20(floatBuffer.get(n2 + 6))._m21(floatBuffer.get(n2 + 7))._m22(floatBuffer.get(n2 + 8));
        }

        public void get(Matrix3f matrix3f, int n2, ByteBuffer byteBuffer) {
            matrix3f._m00(byteBuffer.getFloat(n2))._m01(byteBuffer.getFloat(n2 + 4))._m02(byteBuffer.getFloat(n2 + 8))._m10(byteBuffer.getFloat(n2 + 12))._m11(byteBuffer.getFloat(n2 + 16))._m12(byteBuffer.getFloat(n2 + 20))._m20(byteBuffer.getFloat(n2 + 24))._m21(byteBuffer.getFloat(n2 + 28))._m22(byteBuffer.getFloat(n2 + 32));
        }

        public void get(Matrix3d matrix3d, int n2, DoubleBuffer doubleBuffer) {
            matrix3d._m00(doubleBuffer.get(n2))._m01(doubleBuffer.get(n2 + 1))._m02(doubleBuffer.get(n2 + 2))._m10(doubleBuffer.get(n2 + 3))._m11(doubleBuffer.get(n2 + 4))._m12(doubleBuffer.get(n2 + 5))._m20(doubleBuffer.get(n2 + 6))._m21(doubleBuffer.get(n2 + 7))._m22(doubleBuffer.get(n2 + 8));
        }

        public void get(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            matrix3d._m00(byteBuffer.getDouble(n2))._m01(byteBuffer.getDouble(n2 + 8))._m02(byteBuffer.getDouble(n2 + 16))._m10(byteBuffer.getDouble(n2 + 24))._m11(byteBuffer.getDouble(n2 + 32))._m12(byteBuffer.getDouble(n2 + 40))._m20(byteBuffer.getDouble(n2 + 48))._m21(byteBuffer.getDouble(n2 + 56))._m22(byteBuffer.getDouble(n2 + 64));
        }

        public void get(Matrix3x2f matrix3x2f, int n2, FloatBuffer floatBuffer) {
            matrix3x2f._m00(floatBuffer.get(n2))._m01(floatBuffer.get(n2 + 1))._m10(floatBuffer.get(n2 + 2))._m11(floatBuffer.get(n2 + 3))._m20(floatBuffer.get(n2 + 4))._m21(floatBuffer.get(n2 + 5));
        }

        public void get(Matrix3x2f matrix3x2f, int n2, ByteBuffer byteBuffer) {
            matrix3x2f._m00(byteBuffer.getFloat(n2))._m01(byteBuffer.getFloat(n2 + 4))._m10(byteBuffer.getFloat(n2 + 8))._m11(byteBuffer.getFloat(n2 + 12))._m20(byteBuffer.getFloat(n2 + 16))._m21(byteBuffer.getFloat(n2 + 20));
        }

        public void get(Matrix3x2d matrix3x2d, int n2, DoubleBuffer doubleBuffer) {
            matrix3x2d._m00(doubleBuffer.get(n2))._m01(doubleBuffer.get(n2 + 1))._m10(doubleBuffer.get(n2 + 2))._m11(doubleBuffer.get(n2 + 3))._m20(doubleBuffer.get(n2 + 4))._m21(doubleBuffer.get(n2 + 5));
        }

        public void get(Matrix3x2d matrix3x2d, int n2, ByteBuffer byteBuffer) {
            matrix3x2d._m00(byteBuffer.getDouble(n2))._m01(byteBuffer.getDouble(n2 + 8))._m10(byteBuffer.getDouble(n2 + 16))._m11(byteBuffer.getDouble(n2 + 24))._m20(byteBuffer.getDouble(n2 + 32))._m21(byteBuffer.getDouble(n2 + 40));
        }

        public void getf(Matrix3d matrix3d, int n2, FloatBuffer floatBuffer) {
            matrix3d._m00(floatBuffer.get(n2))._m01(floatBuffer.get(n2 + 1))._m02(floatBuffer.get(n2 + 2))._m10(floatBuffer.get(n2 + 3))._m11(floatBuffer.get(n2 + 4))._m12(floatBuffer.get(n2 + 5))._m20(floatBuffer.get(n2 + 6))._m21(floatBuffer.get(n2 + 7))._m22(floatBuffer.get(n2 + 8));
        }

        public void getf(Matrix3d matrix3d, int n2, ByteBuffer byteBuffer) {
            matrix3d._m00(byteBuffer.getFloat(n2))._m01(byteBuffer.getFloat(n2 + 4))._m02(byteBuffer.getFloat(n2 + 8))._m10(byteBuffer.getFloat(n2 + 12))._m11(byteBuffer.getFloat(n2 + 16))._m12(byteBuffer.getFloat(n2 + 20))._m20(byteBuffer.getFloat(n2 + 24))._m21(byteBuffer.getFloat(n2 + 28))._m22(byteBuffer.getFloat(n2 + 32));
        }

        public void get(Matrix2f matrix2f, int n2, FloatBuffer floatBuffer) {
            matrix2f._m00(floatBuffer.get(n2))._m01(floatBuffer.get(n2 + 1))._m10(floatBuffer.get(n2 + 2))._m11(floatBuffer.get(n2 + 3));
        }

        public void get(Matrix2f matrix2f, int n2, ByteBuffer byteBuffer) {
            matrix2f._m00(byteBuffer.getFloat(n2))._m01(byteBuffer.getFloat(n2 + 4))._m10(byteBuffer.getFloat(n2 + 8))._m11(byteBuffer.getFloat(n2 + 12));
        }

        public void get(Matrix2d matrix2d, int n2, DoubleBuffer doubleBuffer) {
            matrix2d._m00(doubleBuffer.get(n2))._m01(doubleBuffer.get(n2 + 1))._m10(doubleBuffer.get(n2 + 2))._m11(doubleBuffer.get(n2 + 3));
        }

        public void get(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            matrix2d._m00(byteBuffer.getDouble(n2))._m01(byteBuffer.getDouble(n2 + 8))._m10(byteBuffer.getDouble(n2 + 16))._m11(byteBuffer.getDouble(n2 + 24));
        }

        public void getf(Matrix2d matrix2d, int n2, FloatBuffer floatBuffer) {
            matrix2d._m00(floatBuffer.get(n2))._m01(floatBuffer.get(n2 + 1))._m10(floatBuffer.get(n2 + 2))._m11(floatBuffer.get(n2 + 3));
        }

        public void getf(Matrix2d matrix2d, int n2, ByteBuffer byteBuffer) {
            matrix2d._m00(byteBuffer.getFloat(n2))._m01(byteBuffer.getFloat(n2 + 4))._m10(byteBuffer.getFloat(n2 + 8))._m11(byteBuffer.getFloat(n2 + 12));
        }

        public void get(Vector4d vector4d, int n2, DoubleBuffer doubleBuffer) {
            vector4d.x = doubleBuffer.get(n2);
            vector4d.y = doubleBuffer.get(n2 + 1);
            vector4d.z = doubleBuffer.get(n2 + 2);
            vector4d.w = doubleBuffer.get(n2 + 3);
        }

        public void get(Vector4d vector4d, int n2, ByteBuffer byteBuffer) {
            vector4d.x = byteBuffer.getDouble(n2);
            vector4d.y = byteBuffer.getDouble(n2 + 8);
            vector4d.z = byteBuffer.getDouble(n2 + 16);
            vector4d.w = byteBuffer.getDouble(n2 + 24);
        }

        public void get(Vector4f vector4f, int n2, FloatBuffer floatBuffer) {
            vector4f.x = floatBuffer.get(n2);
            vector4f.y = floatBuffer.get(n2 + 1);
            vector4f.z = floatBuffer.get(n2 + 2);
            vector4f.w = floatBuffer.get(n2 + 3);
        }

        public void get(Vector4f vector4f, int n2, ByteBuffer byteBuffer) {
            vector4f.x = byteBuffer.getFloat(n2);
            vector4f.y = byteBuffer.getFloat(n2 + 4);
            vector4f.z = byteBuffer.getFloat(n2 + 8);
            vector4f.w = byteBuffer.getFloat(n2 + 12);
        }

        public void get(Vector4L vector4L, int n2, LongBuffer longBuffer) {
            vector4L.x = longBuffer.get(n2);
            vector4L.y = longBuffer.get(n2 + 1);
            vector4L.z = longBuffer.get(n2 + 2);
            vector4L.w = longBuffer.get(n2 + 3);
        }

        public void get(Vector4L vector4L, int n2, ByteBuffer byteBuffer) {
            vector4L.x = byteBuffer.getLong(n2);
            vector4L.y = byteBuffer.getLong(n2 + 8);
            vector4L.z = byteBuffer.getLong(n2 + 16);
            vector4L.w = byteBuffer.getLong(n2 + 24);
        }

        public void get(Vector4i vector4i, int n2, IntBuffer intBuffer) {
            vector4i.x = intBuffer.get(n2);
            vector4i.y = intBuffer.get(n2 + 1);
            vector4i.z = intBuffer.get(n2 + 2);
            vector4i.w = intBuffer.get(n2 + 3);
        }

        public void get(Vector4i vector4i, int n2, ByteBuffer byteBuffer) {
            vector4i.x = byteBuffer.getInt(n2);
            vector4i.y = byteBuffer.getInt(n2 + 4);
            vector4i.z = byteBuffer.getInt(n2 + 8);
            vector4i.w = byteBuffer.getInt(n2 + 12);
        }

        public void get(Vector3f vector3f, int n2, FloatBuffer floatBuffer) {
            vector3f.x = floatBuffer.get(n2);
            vector3f.y = floatBuffer.get(n2 + 1);
            vector3f.z = floatBuffer.get(n2 + 2);
        }

        public void get(Vector3f vector3f, int n2, ByteBuffer byteBuffer) {
            vector3f.x = byteBuffer.getFloat(n2);
            vector3f.y = byteBuffer.getFloat(n2 + 4);
            vector3f.z = byteBuffer.getFloat(n2 + 8);
        }

        public void get(Vector3d vector3d, int n2, DoubleBuffer doubleBuffer) {
            vector3d.x = doubleBuffer.get(n2);
            vector3d.y = doubleBuffer.get(n2 + 1);
            vector3d.z = doubleBuffer.get(n2 + 2);
        }

        public void get(Vector3d vector3d, int n2, ByteBuffer byteBuffer) {
            vector3d.x = byteBuffer.getDouble(n2);
            vector3d.y = byteBuffer.getDouble(n2 + 8);
            vector3d.z = byteBuffer.getDouble(n2 + 16);
        }

        public void get(Vector3i vector3i, int n2, IntBuffer intBuffer) {
            vector3i.x = intBuffer.get(n2);
            vector3i.y = intBuffer.get(n2 + 1);
            vector3i.z = intBuffer.get(n2 + 2);
        }

        public void get(Vector3i vector3i, int n2, ByteBuffer byteBuffer) {
            vector3i.x = byteBuffer.getInt(n2);
            vector3i.y = byteBuffer.getInt(n2 + 4);
            vector3i.z = byteBuffer.getInt(n2 + 8);
        }

        public void get(Vector3L vector3L, int n2, LongBuffer longBuffer) {
            vector3L.x = longBuffer.get(n2);
            vector3L.y = longBuffer.get(n2 + 1);
            vector3L.z = longBuffer.get(n2 + 2);
        }

        public void get(Vector3L vector3L, int n2, ByteBuffer byteBuffer) {
            vector3L.x = byteBuffer.getLong(n2);
            vector3L.y = byteBuffer.getLong(n2 + 8);
            vector3L.z = byteBuffer.getLong(n2 + 16);
        }

        public void get(Vector2f vector2f, int n2, FloatBuffer floatBuffer) {
            vector2f.x = floatBuffer.get(n2);
            vector2f.y = floatBuffer.get(n2 + 1);
        }

        public void get(Vector2f vector2f, int n2, ByteBuffer byteBuffer) {
            vector2f.x = byteBuffer.getFloat(n2);
            vector2f.y = byteBuffer.getFloat(n2 + 4);
        }

        public void get(Vector2d vector2d, int n2, DoubleBuffer doubleBuffer) {
            vector2d.x = doubleBuffer.get(n2);
            vector2d.y = doubleBuffer.get(n2 + 1);
        }

        public void get(Vector2d vector2d, int n2, ByteBuffer byteBuffer) {
            vector2d.x = byteBuffer.getDouble(n2);
            vector2d.y = byteBuffer.getDouble(n2 + 8);
        }

        public void get(Vector2i vector2i, int n2, IntBuffer intBuffer) {
            vector2i.x = intBuffer.get(n2);
            vector2i.y = intBuffer.get(n2 + 1);
        }

        public void get(Vector2L vector2L, int n2, LongBuffer longBuffer) {
            vector2L.x = longBuffer.get(n2);
            vector2L.y = longBuffer.get(n2 + 1);
        }

        public void get(Vector2i vector2i, int n2, ByteBuffer byteBuffer) {
            vector2i.x = byteBuffer.getInt(n2);
            vector2i.y = byteBuffer.getInt(n2 + 4);
        }

        public void get(Vector2L vector2L, int n2, ByteBuffer byteBuffer) {
            vector2L.x = byteBuffer.getLong(n2);
            vector2L.y = byteBuffer.getLong(n2 + 8);
        }

        public float get(Matrix4f matrix4f, int n2, int n3) {
            switch (n2) {
                case 0: {
                    switch (n3) {
                        case 0: {
                            return matrix4f.m00();
                        }
                        case 1: {
                            return matrix4f.m01();
                        }
                        case 2: {
                            return matrix4f.m02();
                        }
                        case 3: {
                            return matrix4f.m03();
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n3) {
                        case 0: {
                            return matrix4f.m10();
                        }
                        case 1: {
                            return matrix4f.m11();
                        }
                        case 2: {
                            return matrix4f.m12();
                        }
                        case 3: {
                            return matrix4f.m13();
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n3) {
                        case 0: {
                            return matrix4f.m20();
                        }
                        case 1: {
                            return matrix4f.m21();
                        }
                        case 2: {
                            return matrix4f.m22();
                        }
                        case 3: {
                            return matrix4f.m23();
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n3) {
                        case 0: {
                            return matrix4f.m30();
                        }
                        case 1: {
                            return matrix4f.m31();
                        }
                        case 2: {
                            return matrix4f.m32();
                        }
                        case 3: {
                            return matrix4f.m33();
                        }
                    }
                }
            }
            throw new IllegalArgumentException();
        }

        public Matrix4f set(Matrix4f matrix4f, int n2, int n3, float f2) {
            switch (n2) {
                case 0: {
                    switch (n3) {
                        case 0: {
                            return matrix4f.m00(f2);
                        }
                        case 1: {
                            return matrix4f.m01(f2);
                        }
                        case 2: {
                            return matrix4f.m02(f2);
                        }
                        case 3: {
                            return matrix4f.m03(f2);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n3) {
                        case 0: {
                            return matrix4f.m10(f2);
                        }
                        case 1: {
                            return matrix4f.m11(f2);
                        }
                        case 2: {
                            return matrix4f.m12(f2);
                        }
                        case 3: {
                            return matrix4f.m13(f2);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n3) {
                        case 0: {
                            return matrix4f.m20(f2);
                        }
                        case 1: {
                            return matrix4f.m21(f2);
                        }
                        case 2: {
                            return matrix4f.m22(f2);
                        }
                        case 3: {
                            return matrix4f.m23(f2);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n3) {
                        case 0: {
                            return matrix4f.m30(f2);
                        }
                        case 1: {
                            return matrix4f.m31(f2);
                        }
                        case 2: {
                            return matrix4f.m32(f2);
                        }
                        case 3: {
                            return matrix4f.m33(f2);
                        }
                    }
                }
            }
            throw new IllegalArgumentException();
        }

        public double get(Matrix4d matrix4d, int n2, int n3) {
            switch (n2) {
                case 0: {
                    switch (n3) {
                        case 0: {
                            return matrix4d.m00;
                        }
                        case 1: {
                            return matrix4d.m01;
                        }
                        case 2: {
                            return matrix4d.m02;
                        }
                        case 3: {
                            return matrix4d.m03;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n3) {
                        case 0: {
                            return matrix4d.m10;
                        }
                        case 1: {
                            return matrix4d.m11;
                        }
                        case 2: {
                            return matrix4d.m12;
                        }
                        case 3: {
                            return matrix4d.m13;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n3) {
                        case 0: {
                            return matrix4d.m20;
                        }
                        case 1: {
                            return matrix4d.m21;
                        }
                        case 2: {
                            return matrix4d.m22;
                        }
                        case 3: {
                            return matrix4d.m23;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n3) {
                        case 0: {
                            return matrix4d.m30;
                        }
                        case 1: {
                            return matrix4d.m31;
                        }
                        case 2: {
                            return matrix4d.m32;
                        }
                        case 3: {
                            return matrix4d.m33;
                        }
                    }
                }
            }
            throw new IllegalArgumentException();
        }

        public Matrix4d set(Matrix4d matrix4d, int n2, int n3, double d2) {
            switch (n2) {
                case 0: {
                    switch (n3) {
                        case 0: {
                            return matrix4d.m00(d2);
                        }
                        case 1: {
                            return matrix4d.m01(d2);
                        }
                        case 2: {
                            return matrix4d.m02(d2);
                        }
                        case 3: {
                            return matrix4d.m03(d2);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n3) {
                        case 0: {
                            return matrix4d.m10(d2);
                        }
                        case 1: {
                            return matrix4d.m11(d2);
                        }
                        case 2: {
                            return matrix4d.m12(d2);
                        }
                        case 3: {
                            return matrix4d.m13(d2);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n3) {
                        case 0: {
                            return matrix4d.m20(d2);
                        }
                        case 1: {
                            return matrix4d.m21(d2);
                        }
                        case 2: {
                            return matrix4d.m22(d2);
                        }
                        case 3: {
                            return matrix4d.m23(d2);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n3) {
                        case 0: {
                            return matrix4d.m30(d2);
                        }
                        case 1: {
                            return matrix4d.m31(d2);
                        }
                        case 2: {
                            return matrix4d.m32(d2);
                        }
                        case 3: {
                            return matrix4d.m33(d2);
                        }
                    }
                }
            }
            throw new IllegalArgumentException();
        }

        public float get(Matrix3f matrix3f, int n2, int n3) {
            switch (n2) {
                case 0: {
                    switch (n3) {
                        case 0: {
                            return matrix3f.m00;
                        }
                        case 1: {
                            return matrix3f.m01;
                        }
                        case 2: {
                            return matrix3f.m02;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n3) {
                        case 0: {
                            return matrix3f.m10;
                        }
                        case 1: {
                            return matrix3f.m11;
                        }
                        case 2: {
                            return matrix3f.m12;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n3) {
                        case 0: {
                            return matrix3f.m20;
                        }
                        case 1: {
                            return matrix3f.m21;
                        }
                        case 2: {
                            return matrix3f.m22;
                        }
                    }
                }
            }
            throw new IllegalArgumentException();
        }

        public Matrix3f set(Matrix3f matrix3f, int n2, int n3, float f2) {
            switch (n2) {
                case 0: {
                    switch (n3) {
                        case 0: {
                            return matrix3f.m00(f2);
                        }
                        case 1: {
                            return matrix3f.m01(f2);
                        }
                        case 2: {
                            return matrix3f.m02(f2);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n3) {
                        case 0: {
                            return matrix3f.m10(f2);
                        }
                        case 1: {
                            return matrix3f.m11(f2);
                        }
                        case 2: {
                            return matrix3f.m12(f2);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n3) {
                        case 0: {
                            return matrix3f.m20(f2);
                        }
                        case 1: {
                            return matrix3f.m21(f2);
                        }
                        case 2: {
                            return matrix3f.m22(f2);
                        }
                    }
                }
            }
            throw new IllegalArgumentException();
        }

        public double get(Matrix3d matrix3d, int n2, int n3) {
            switch (n2) {
                case 0: {
                    switch (n3) {
                        case 0: {
                            return matrix3d.m00;
                        }
                        case 1: {
                            return matrix3d.m01;
                        }
                        case 2: {
                            return matrix3d.m02;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n3) {
                        case 0: {
                            return matrix3d.m10;
                        }
                        case 1: {
                            return matrix3d.m11;
                        }
                        case 2: {
                            return matrix3d.m12;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n3) {
                        case 0: {
                            return matrix3d.m20;
                        }
                        case 1: {
                            return matrix3d.m21;
                        }
                        case 2: {
                            return matrix3d.m22;
                        }
                    }
                }
            }
            throw new IllegalArgumentException();
        }

        public Matrix3d set(Matrix3d matrix3d, int n2, int n3, double d2) {
            switch (n2) {
                case 0: {
                    switch (n3) {
                        case 0: {
                            return matrix3d.m00(d2);
                        }
                        case 1: {
                            return matrix3d.m01(d2);
                        }
                        case 2: {
                            return matrix3d.m02(d2);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (n3) {
                        case 0: {
                            return matrix3d.m10(d2);
                        }
                        case 1: {
                            return matrix3d.m11(d2);
                        }
                        case 2: {
                            return matrix3d.m12(d2);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n3) {
                        case 0: {
                            return matrix3d.m20(d2);
                        }
                        case 1: {
                            return matrix3d.m21(d2);
                        }
                        case 2: {
                            return matrix3d.m22(d2);
                        }
                    }
                }
            }
            throw new IllegalArgumentException();
        }

        public Vector4f getColumn(Matrix4f matrix4f, int n2, Vector4f vector4f) {
            switch (n2) {
                case 0: {
                    return vector4f.set(matrix4f.m00(), matrix4f.m01(), matrix4f.m02(), matrix4f.m03());
                }
                case 1: {
                    return vector4f.set(matrix4f.m10(), matrix4f.m11(), matrix4f.m12(), matrix4f.m13());
                }
                case 2: {
                    return vector4f.set(matrix4f.m20(), matrix4f.m21(), matrix4f.m22(), matrix4f.m23());
                }
                case 3: {
                    return vector4f.set(matrix4f.m30(), matrix4f.m31(), matrix4f.m32(), matrix4f.m33());
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public Matrix4f setColumn(Vector4f vector4f, int n2, Matrix4f matrix4f) {
            switch (n2) {
                case 0: {
                    return matrix4f._m00(vector4f.x)._m01(vector4f.y)._m02(vector4f.z)._m03(vector4f.w);
                }
                case 1: {
                    return matrix4f._m10(vector4f.x)._m11(vector4f.y)._m12(vector4f.z)._m13(vector4f.w);
                }
                case 2: {
                    return matrix4f._m20(vector4f.x)._m21(vector4f.y)._m22(vector4f.z)._m23(vector4f.w);
                }
                case 3: {
                    return matrix4f._m30(vector4f.x)._m31(vector4f.y)._m32(vector4f.z)._m33(vector4f.w);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public Matrix4f setColumn(Vector4fc vector4fc, int n2, Matrix4f matrix4f) {
            switch (n2) {
                case 0: {
                    return matrix4f._m00(vector4fc.x())._m01(vector4fc.y())._m02(vector4fc.z())._m03(vector4fc.w());
                }
                case 1: {
                    return matrix4f._m10(vector4fc.x())._m11(vector4fc.y())._m12(vector4fc.z())._m13(vector4fc.w());
                }
                case 2: {
                    return matrix4f._m20(vector4fc.x())._m21(vector4fc.y())._m22(vector4fc.z())._m23(vector4fc.w());
                }
                case 3: {
                    return matrix4f._m30(vector4fc.x())._m31(vector4fc.y())._m32(vector4fc.z())._m33(vector4fc.w());
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public void copy(Matrix4fc matrix4fc, Matrix4f matrix4f) {
            matrix4f._m00(matrix4fc.m00())._m01(matrix4fc.m01())._m02(matrix4fc.m02())._m03(matrix4fc.m03())._m10(matrix4fc.m10())._m11(matrix4fc.m11())._m12(matrix4fc.m12())._m13(matrix4fc.m13())._m20(matrix4fc.m20())._m21(matrix4fc.m21())._m22(matrix4fc.m22())._m23(matrix4fc.m23())._m30(matrix4fc.m30())._m31(matrix4fc.m31())._m32(matrix4fc.m32())._m33(matrix4fc.m33());
        }

        public void copy(Matrix3fc matrix3fc, Matrix4f matrix4f) {
            matrix4f._m00(matrix3fc.m00())._m01(matrix3fc.m01())._m02(matrix3fc.m02())._m03(0.0f)._m10(matrix3fc.m10())._m11(matrix3fc.m11())._m12(matrix3fc.m12())._m13(0.0f)._m20(matrix3fc.m20())._m21(matrix3fc.m21())._m22(matrix3fc.m22())._m23(0.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f)._m33(1.0f);
        }

        public void copy(Matrix4fc matrix4fc, Matrix3f matrix3f) {
            matrix3f._m00(matrix4fc.m00())._m01(matrix4fc.m01())._m02(matrix4fc.m02())._m10(matrix4fc.m10())._m11(matrix4fc.m11())._m12(matrix4fc.m12())._m20(matrix4fc.m20())._m21(matrix4fc.m21())._m22(matrix4fc.m22());
        }

        public void copy(Matrix3fc matrix3fc, Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(matrix3fc.m00())._m01(matrix3fc.m01())._m02(matrix3fc.m02())._m10(matrix3fc.m10())._m11(matrix3fc.m11())._m12(matrix3fc.m12())._m20(matrix3fc.m20())._m21(matrix3fc.m21())._m22(matrix3fc.m22())._m30(0.0f)._m31(0.0f)._m32(0.0f);
        }

        public void copy(Matrix3x2fc matrix3x2fc, Matrix3x2f matrix3x2f) {
            matrix3x2f._m00(matrix3x2fc.m00())._m01(matrix3x2fc.m01())._m10(matrix3x2fc.m10())._m11(matrix3x2fc.m11())._m20(matrix3x2fc.m20())._m21(matrix3x2fc.m21());
        }

        public void copy(Matrix3x2dc matrix3x2dc, Matrix3x2d matrix3x2d) {
            matrix3x2d._m00(matrix3x2dc.m00())._m01(matrix3x2dc.m01())._m10(matrix3x2dc.m10())._m11(matrix3x2dc.m11())._m20(matrix3x2dc.m20())._m21(matrix3x2dc.m21());
        }

        public void copy(Matrix2fc matrix2fc, Matrix2f matrix2f) {
            matrix2f._m00(matrix2fc.m00())._m01(matrix2fc.m01())._m10(matrix2fc.m10())._m11(matrix2fc.m11());
        }

        public void copy(Matrix2dc matrix2dc, Matrix2d matrix2d) {
            matrix2d._m00(matrix2dc.m00())._m01(matrix2dc.m01())._m10(matrix2dc.m10())._m11(matrix2dc.m11());
        }

        public void copy(Matrix2fc matrix2fc, Matrix3f matrix3f) {
            matrix3f._m00(matrix2fc.m00())._m01(matrix2fc.m01())._m02(0.0f)._m10(matrix2fc.m10())._m11(matrix2fc.m11())._m12(0.0f)._m20(0.0f)._m21(0.0f)._m22(1.0f);
        }

        public void copy(Matrix3fc matrix3fc, Matrix2f matrix2f) {
            matrix2f._m00(matrix3fc.m00())._m01(matrix3fc.m01())._m10(matrix3fc.m10())._m11(matrix3fc.m11());
        }

        public void copy(Matrix2fc matrix2fc, Matrix3x2f matrix3x2f) {
            matrix3x2f._m00(matrix2fc.m00())._m01(matrix2fc.m01())._m10(matrix2fc.m10())._m11(matrix2fc.m11())._m20(0.0f)._m21(0.0f);
        }

        public void copy(Matrix3x2fc matrix3x2fc, Matrix2f matrix2f) {
            matrix2f._m00(matrix3x2fc.m00())._m01(matrix3x2fc.m01())._m10(matrix3x2fc.m10())._m11(matrix3x2fc.m11());
        }

        public void copy(Matrix2dc matrix2dc, Matrix3d matrix3d) {
            matrix3d._m00(matrix2dc.m00())._m01(matrix2dc.m01())._m02(0.0)._m10(matrix2dc.m10())._m11(matrix2dc.m11())._m12(0.0)._m20(0.0)._m21(0.0)._m22(1.0);
        }

        public void copy(Matrix3dc matrix3dc, Matrix2d matrix2d) {
            matrix2d._m00(matrix3dc.m00())._m01(matrix3dc.m01())._m10(matrix3dc.m10())._m11(matrix3dc.m11());
        }

        public void copy(Matrix2dc matrix2dc, Matrix3x2d matrix3x2d) {
            matrix3x2d._m00(matrix2dc.m00())._m01(matrix2dc.m01())._m10(matrix2dc.m10())._m11(matrix2dc.m11())._m20(0.0)._m21(0.0);
        }

        public void copy(Matrix3x2dc matrix3x2dc, Matrix2d matrix2d) {
            matrix2d._m00(matrix3x2dc.m00())._m01(matrix3x2dc.m01())._m10(matrix3x2dc.m10())._m11(matrix3x2dc.m11());
        }

        public void copy3x3(Matrix4fc matrix4fc, Matrix4f matrix4f) {
            matrix4f._m00(matrix4fc.m00())._m01(matrix4fc.m01())._m02(matrix4fc.m02())._m10(matrix4fc.m10())._m11(matrix4fc.m11())._m12(matrix4fc.m12())._m20(matrix4fc.m20())._m21(matrix4fc.m21())._m22(matrix4fc.m22());
        }

        public void copy3x3(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(matrix4x3fc.m00())._m01(matrix4x3fc.m01())._m02(matrix4x3fc.m02())._m10(matrix4x3fc.m10())._m11(matrix4x3fc.m11())._m12(matrix4x3fc.m12())._m20(matrix4x3fc.m20())._m21(matrix4x3fc.m21())._m22(matrix4x3fc.m22());
        }

        public void copy3x3(Matrix3fc matrix3fc, Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(matrix3fc.m00())._m01(matrix3fc.m01())._m02(matrix3fc.m02())._m10(matrix3fc.m10())._m11(matrix3fc.m11())._m12(matrix3fc.m12())._m20(matrix3fc.m20())._m21(matrix3fc.m21())._m22(matrix3fc.m22());
        }

        public void copy3x3(Matrix3fc matrix3fc, Matrix4f matrix4f) {
            matrix4f._m00(matrix3fc.m00())._m01(matrix3fc.m01())._m02(matrix3fc.m02())._m10(matrix3fc.m10())._m11(matrix3fc.m11())._m12(matrix3fc.m12())._m20(matrix3fc.m20())._m21(matrix3fc.m21())._m22(matrix3fc.m22());
        }

        public void copy4x3(Matrix4x3fc matrix4x3fc, Matrix4f matrix4f) {
            matrix4f._m00(matrix4x3fc.m00())._m01(matrix4x3fc.m01())._m02(matrix4x3fc.m02())._m10(matrix4x3fc.m10())._m11(matrix4x3fc.m11())._m12(matrix4x3fc.m12())._m20(matrix4x3fc.m20())._m21(matrix4x3fc.m21())._m22(matrix4x3fc.m22())._m30(matrix4x3fc.m30())._m31(matrix4x3fc.m31())._m32(matrix4x3fc.m32());
        }

        public void copy4x3(Matrix4fc matrix4fc, Matrix4f matrix4f) {
            matrix4f._m00(matrix4fc.m00())._m01(matrix4fc.m01())._m02(matrix4fc.m02())._m10(matrix4fc.m10())._m11(matrix4fc.m11())._m12(matrix4fc.m12())._m20(matrix4fc.m20())._m21(matrix4fc.m21())._m22(matrix4fc.m22())._m30(matrix4fc.m30())._m31(matrix4fc.m31())._m32(matrix4fc.m32());
        }

        public void copy(Matrix4fc matrix4fc, Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(matrix4fc.m00())._m01(matrix4fc.m01())._m02(matrix4fc.m02())._m10(matrix4fc.m10())._m11(matrix4fc.m11())._m12(matrix4fc.m12())._m20(matrix4fc.m20())._m21(matrix4fc.m21())._m22(matrix4fc.m22())._m30(matrix4fc.m30())._m31(matrix4fc.m31())._m32(matrix4fc.m32());
        }

        public void copy(Matrix4x3fc matrix4x3fc, Matrix4f matrix4f) {
            matrix4f._m00(matrix4x3fc.m00())._m01(matrix4x3fc.m01())._m02(matrix4x3fc.m02())._m03(0.0f)._m10(matrix4x3fc.m10())._m11(matrix4x3fc.m11())._m12(matrix4x3fc.m12())._m13(0.0f)._m20(matrix4x3fc.m20())._m21(matrix4x3fc.m21())._m22(matrix4x3fc.m22())._m23(0.0f)._m30(matrix4x3fc.m30())._m31(matrix4x3fc.m31())._m32(matrix4x3fc.m32())._m33(1.0f);
        }

        public void copy(Matrix4x3fc matrix4x3fc, Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(matrix4x3fc.m00())._m01(matrix4x3fc.m01())._m02(matrix4x3fc.m02())._m10(matrix4x3fc.m10())._m11(matrix4x3fc.m11())._m12(matrix4x3fc.m12())._m20(matrix4x3fc.m20())._m21(matrix4x3fc.m21())._m22(matrix4x3fc.m22())._m30(matrix4x3fc.m30())._m31(matrix4x3fc.m31())._m32(matrix4x3fc.m32());
        }

        public void copy(Matrix3fc matrix3fc, Matrix3f matrix3f) {
            matrix3f._m00(matrix3fc.m00())._m01(matrix3fc.m01())._m02(matrix3fc.m02())._m10(matrix3fc.m10())._m11(matrix3fc.m11())._m12(matrix3fc.m12())._m20(matrix3fc.m20())._m21(matrix3fc.m21())._m22(matrix3fc.m22());
        }

        public void copy(float[] fArray, int n2, Matrix4f matrix4f) {
            matrix4f._m00(fArray[n2])._m01(fArray[n2 + 1])._m02(fArray[n2 + 2])._m03(fArray[n2 + 3])._m10(fArray[n2 + 4])._m11(fArray[n2 + 5])._m12(fArray[n2 + 6])._m13(fArray[n2 + 7])._m20(fArray[n2 + 8])._m21(fArray[n2 + 9])._m22(fArray[n2 + 10])._m23(fArray[n2 + 11])._m30(fArray[n2 + 12])._m31(fArray[n2 + 13])._m32(fArray[n2 + 14])._m33(fArray[n2 + 15]);
        }

        public void copyTransposed(float[] fArray, int n2, Matrix4f matrix4f) {
            matrix4f._m00(fArray[n2])._m10(fArray[n2 + 1])._m20(fArray[n2 + 2])._m30(fArray[n2 + 3])._m01(fArray[n2 + 4])._m11(fArray[n2 + 5])._m21(fArray[n2 + 6])._m31(fArray[n2 + 7])._m02(fArray[n2 + 8])._m12(fArray[n2 + 9])._m22(fArray[n2 + 10])._m32(fArray[n2 + 11])._m03(fArray[n2 + 12])._m13(fArray[n2 + 13])._m23(fArray[n2 + 14])._m33(fArray[n2 + 15]);
        }

        public void copy(float[] fArray, int n2, Matrix3f matrix3f) {
            matrix3f._m00(fArray[n2])._m01(fArray[n2 + 1])._m02(fArray[n2 + 2])._m10(fArray[n2 + 3])._m11(fArray[n2 + 4])._m12(fArray[n2 + 5])._m20(fArray[n2 + 6])._m21(fArray[n2 + 7])._m22(fArray[n2 + 8]);
        }

        public void copy(float[] fArray, int n2, Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(fArray[n2])._m01(fArray[n2 + 1])._m02(fArray[n2 + 2])._m10(fArray[n2 + 3])._m11(fArray[n2 + 4])._m12(fArray[n2 + 5])._m20(fArray[n2 + 6])._m21(fArray[n2 + 7])._m22(fArray[n2 + 8])._m30(fArray[n2 + 9])._m31(fArray[n2 + 10])._m32(fArray[n2 + 11]);
        }

        public void copy(float[] fArray, int n2, Matrix3x2f matrix3x2f) {
            matrix3x2f._m00(fArray[n2])._m01(fArray[n2 + 1])._m10(fArray[n2 + 2])._m11(fArray[n2 + 3])._m20(fArray[n2 + 4])._m21(fArray[n2 + 5]);
        }

        public void copy(double[] dArray, int n2, Matrix3x2d matrix3x2d) {
            matrix3x2d._m00(dArray[n2])._m01(dArray[n2 + 1])._m10(dArray[n2 + 2])._m11(dArray[n2 + 3])._m20(dArray[n2 + 4])._m21(dArray[n2 + 5]);
        }

        public void copy(float[] fArray, int n2, Matrix3x2d matrix3x2d) {
            matrix3x2d._m00(fArray[n2])._m01(fArray[n2 + 1])._m10(fArray[n2 + 2])._m11(fArray[n2 + 3])._m20(fArray[n2 + 4])._m21(fArray[n2 + 5]);
        }

        public void copy(float[] fArray, int n2, Matrix2f matrix2f) {
            matrix2f._m00(fArray[n2])._m01(fArray[n2 + 1])._m10(fArray[n2 + 2])._m11(fArray[n2 + 3]);
        }

        public void copy(double[] dArray, int n2, Matrix2d matrix2d) {
            matrix2d._m00(dArray[n2])._m01(dArray[n2 + 1])._m10(dArray[n2 + 2])._m11(dArray[n2 + 3]);
        }

        public void copy(Matrix4fc matrix4fc, float[] fArray, int n2) {
            fArray[n2] = matrix4fc.m00();
            fArray[n2 + 1] = matrix4fc.m01();
            fArray[n2 + 2] = matrix4fc.m02();
            fArray[n2 + 3] = matrix4fc.m03();
            fArray[n2 + 4] = matrix4fc.m10();
            fArray[n2 + 5] = matrix4fc.m11();
            fArray[n2 + 6] = matrix4fc.m12();
            fArray[n2 + 7] = matrix4fc.m13();
            fArray[n2 + 8] = matrix4fc.m20();
            fArray[n2 + 9] = matrix4fc.m21();
            fArray[n2 + 10] = matrix4fc.m22();
            fArray[n2 + 11] = matrix4fc.m23();
            fArray[n2 + 12] = matrix4fc.m30();
            fArray[n2 + 13] = matrix4fc.m31();
            fArray[n2 + 14] = matrix4fc.m32();
            fArray[n2 + 15] = matrix4fc.m33();
        }

        public void copy(Matrix3fc matrix3fc, float[] fArray, int n2) {
            fArray[n2] = matrix3fc.m00();
            fArray[n2 + 1] = matrix3fc.m01();
            fArray[n2 + 2] = matrix3fc.m02();
            fArray[n2 + 3] = matrix3fc.m10();
            fArray[n2 + 4] = matrix3fc.m11();
            fArray[n2 + 5] = matrix3fc.m12();
            fArray[n2 + 6] = matrix3fc.m20();
            fArray[n2 + 7] = matrix3fc.m21();
            fArray[n2 + 8] = matrix3fc.m22();
        }

        public void copy(Matrix4x3fc matrix4x3fc, float[] fArray, int n2) {
            fArray[n2] = matrix4x3fc.m00();
            fArray[n2 + 1] = matrix4x3fc.m01();
            fArray[n2 + 2] = matrix4x3fc.m02();
            fArray[n2 + 3] = matrix4x3fc.m10();
            fArray[n2 + 4] = matrix4x3fc.m11();
            fArray[n2 + 5] = matrix4x3fc.m12();
            fArray[n2 + 6] = matrix4x3fc.m20();
            fArray[n2 + 7] = matrix4x3fc.m21();
            fArray[n2 + 8] = matrix4x3fc.m22();
            fArray[n2 + 9] = matrix4x3fc.m30();
            fArray[n2 + 10] = matrix4x3fc.m31();
            fArray[n2 + 11] = matrix4x3fc.m32();
        }

        public void copy(Matrix3x2fc matrix3x2fc, float[] fArray, int n2) {
            fArray[n2] = matrix3x2fc.m00();
            fArray[n2 + 1] = matrix3x2fc.m01();
            fArray[n2 + 2] = matrix3x2fc.m10();
            fArray[n2 + 3] = matrix3x2fc.m11();
            fArray[n2 + 4] = matrix3x2fc.m20();
            fArray[n2 + 5] = matrix3x2fc.m21();
        }

        public void copy(Matrix3x2dc matrix3x2dc, double[] dArray, int n2) {
            dArray[n2] = matrix3x2dc.m00();
            dArray[n2 + 1] = matrix3x2dc.m01();
            dArray[n2 + 2] = matrix3x2dc.m10();
            dArray[n2 + 3] = matrix3x2dc.m11();
            dArray[n2 + 4] = matrix3x2dc.m20();
            dArray[n2 + 5] = matrix3x2dc.m21();
        }

        public void copy(Matrix2fc matrix2fc, float[] fArray, int n2) {
            fArray[n2] = matrix2fc.m00();
            fArray[n2 + 1] = matrix2fc.m01();
            fArray[n2 + 2] = matrix2fc.m10();
            fArray[n2 + 3] = matrix2fc.m11();
        }

        public void copy(Matrix2dc matrix2dc, double[] dArray, int n2) {
            dArray[n2] = matrix2dc.m00();
            dArray[n2 + 1] = matrix2dc.m01();
            dArray[n2 + 2] = matrix2dc.m10();
            dArray[n2 + 3] = matrix2dc.m11();
        }

        public void copy4x4(Matrix4x3fc matrix4x3fc, float[] fArray, int n2) {
            fArray[n2] = matrix4x3fc.m00();
            fArray[n2 + 1] = matrix4x3fc.m01();
            fArray[n2 + 2] = matrix4x3fc.m02();
            fArray[n2 + 3] = 0.0f;
            fArray[n2 + 4] = matrix4x3fc.m10();
            fArray[n2 + 5] = matrix4x3fc.m11();
            fArray[n2 + 6] = matrix4x3fc.m12();
            fArray[n2 + 7] = 0.0f;
            fArray[n2 + 8] = matrix4x3fc.m20();
            fArray[n2 + 9] = matrix4x3fc.m21();
            fArray[n2 + 10] = matrix4x3fc.m22();
            fArray[n2 + 11] = 0.0f;
            fArray[n2 + 12] = matrix4x3fc.m30();
            fArray[n2 + 13] = matrix4x3fc.m31();
            fArray[n2 + 14] = matrix4x3fc.m32();
            fArray[n2 + 15] = 1.0f;
        }

        public void copy4x4(Matrix4x3dc matrix4x3dc, float[] fArray, int n2) {
            fArray[n2] = (float)matrix4x3dc.m00();
            fArray[n2 + 1] = (float)matrix4x3dc.m01();
            fArray[n2 + 2] = (float)matrix4x3dc.m02();
            fArray[n2 + 3] = 0.0f;
            fArray[n2 + 4] = (float)matrix4x3dc.m10();
            fArray[n2 + 5] = (float)matrix4x3dc.m11();
            fArray[n2 + 6] = (float)matrix4x3dc.m12();
            fArray[n2 + 7] = 0.0f;
            fArray[n2 + 8] = (float)matrix4x3dc.m20();
            fArray[n2 + 9] = (float)matrix4x3dc.m21();
            fArray[n2 + 10] = (float)matrix4x3dc.m22();
            fArray[n2 + 11] = 0.0f;
            fArray[n2 + 12] = (float)matrix4x3dc.m30();
            fArray[n2 + 13] = (float)matrix4x3dc.m31();
            fArray[n2 + 14] = (float)matrix4x3dc.m32();
            fArray[n2 + 15] = 1.0f;
        }

        public void copy4x4(Matrix4x3dc matrix4x3dc, double[] dArray, int n2) {
            dArray[n2] = matrix4x3dc.m00();
            dArray[n2 + 1] = matrix4x3dc.m01();
            dArray[n2 + 2] = matrix4x3dc.m02();
            dArray[n2 + 3] = 0.0;
            dArray[n2 + 4] = matrix4x3dc.m10();
            dArray[n2 + 5] = matrix4x3dc.m11();
            dArray[n2 + 6] = matrix4x3dc.m12();
            dArray[n2 + 7] = 0.0;
            dArray[n2 + 8] = matrix4x3dc.m20();
            dArray[n2 + 9] = matrix4x3dc.m21();
            dArray[n2 + 10] = matrix4x3dc.m22();
            dArray[n2 + 11] = 0.0;
            dArray[n2 + 12] = matrix4x3dc.m30();
            dArray[n2 + 13] = matrix4x3dc.m31();
            dArray[n2 + 14] = matrix4x3dc.m32();
            dArray[n2 + 15] = 1.0;
        }

        public void copy3x3(Matrix3x2fc matrix3x2fc, float[] fArray, int n2) {
            fArray[n2] = matrix3x2fc.m00();
            fArray[n2 + 1] = matrix3x2fc.m01();
            fArray[n2 + 2] = 0.0f;
            fArray[n2 + 3] = matrix3x2fc.m10();
            fArray[n2 + 4] = matrix3x2fc.m11();
            fArray[n2 + 5] = 0.0f;
            fArray[n2 + 6] = matrix3x2fc.m20();
            fArray[n2 + 7] = matrix3x2fc.m21();
            fArray[n2 + 8] = 1.0f;
        }

        public void copy3x3(Matrix3x2dc matrix3x2dc, double[] dArray, int n2) {
            dArray[n2] = matrix3x2dc.m00();
            dArray[n2 + 1] = matrix3x2dc.m01();
            dArray[n2 + 2] = 0.0;
            dArray[n2 + 3] = matrix3x2dc.m10();
            dArray[n2 + 4] = matrix3x2dc.m11();
            dArray[n2 + 5] = 0.0;
            dArray[n2 + 6] = matrix3x2dc.m20();
            dArray[n2 + 7] = matrix3x2dc.m21();
            dArray[n2 + 8] = 1.0;
        }

        public void copy4x4(Matrix3x2fc matrix3x2fc, float[] fArray, int n2) {
            fArray[n2] = matrix3x2fc.m00();
            fArray[n2 + 1] = matrix3x2fc.m01();
            fArray[n2 + 2] = 0.0f;
            fArray[n2 + 3] = 0.0f;
            fArray[n2 + 4] = matrix3x2fc.m10();
            fArray[n2 + 5] = matrix3x2fc.m11();
            fArray[n2 + 6] = 0.0f;
            fArray[n2 + 7] = 0.0f;
            fArray[n2 + 8] = 0.0f;
            fArray[n2 + 9] = 0.0f;
            fArray[n2 + 10] = 1.0f;
            fArray[n2 + 11] = 0.0f;
            fArray[n2 + 12] = matrix3x2fc.m20();
            fArray[n2 + 13] = matrix3x2fc.m21();
            fArray[n2 + 14] = 0.0f;
            fArray[n2 + 15] = 1.0f;
        }

        public void copy4x4(Matrix3x2dc matrix3x2dc, double[] dArray, int n2) {
            dArray[n2] = matrix3x2dc.m00();
            dArray[n2 + 1] = matrix3x2dc.m01();
            dArray[n2 + 2] = 0.0;
            dArray[n2 + 3] = 0.0;
            dArray[n2 + 4] = matrix3x2dc.m10();
            dArray[n2 + 5] = matrix3x2dc.m11();
            dArray[n2 + 6] = 0.0;
            dArray[n2 + 7] = 0.0;
            dArray[n2 + 8] = 0.0;
            dArray[n2 + 9] = 0.0;
            dArray[n2 + 10] = 1.0;
            dArray[n2 + 11] = 0.0;
            dArray[n2 + 12] = matrix3x2dc.m20();
            dArray[n2 + 13] = matrix3x2dc.m21();
            dArray[n2 + 14] = 0.0;
            dArray[n2 + 15] = 1.0;
        }

        public void identity(Matrix4f matrix4f) {
            matrix4f._m00(1.0f)._m01(0.0f)._m02(0.0f)._m03(0.0f)._m10(0.0f)._m11(1.0f)._m12(0.0f)._m13(0.0f)._m20(0.0f)._m21(0.0f)._m22(1.0f)._m23(0.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f)._m33(1.0f);
        }

        public void identity(Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(1.0f)._m01(0.0f)._m02(0.0f)._m10(0.0f)._m11(1.0f)._m12(0.0f)._m20(0.0f)._m21(0.0f)._m22(1.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f);
        }

        public void identity(Matrix3f matrix3f) {
            matrix3f._m00(1.0f)._m01(0.0f)._m02(0.0f)._m10(0.0f)._m11(1.0f)._m12(0.0f)._m20(0.0f)._m21(0.0f)._m22(1.0f);
        }

        public void identity(Matrix3x2f matrix3x2f) {
            matrix3x2f._m00(1.0f)._m01(0.0f)._m10(0.0f)._m11(1.0f)._m20(0.0f)._m21(0.0f);
        }

        public void identity(Matrix3x2d matrix3x2d) {
            matrix3x2d._m00(1.0)._m01(0.0)._m10(0.0)._m11(1.0)._m20(0.0)._m21(0.0);
        }

        public void identity(Matrix2f matrix2f) {
            matrix2f._m00(1.0f)._m01(0.0f)._m10(0.0f)._m11(1.0f);
        }

        public void swap(Matrix4f matrix4f, Matrix4f matrix4f2) {
            float f2 = matrix4f.m00();
            matrix4f._m00(matrix4f2.m00());
            matrix4f2._m00(f2);
            f2 = matrix4f.m01();
            matrix4f._m01(matrix4f2.m01());
            matrix4f2._m01(f2);
            f2 = matrix4f.m02();
            matrix4f._m02(matrix4f2.m02());
            matrix4f2._m02(f2);
            f2 = matrix4f.m03();
            matrix4f._m03(matrix4f2.m03());
            matrix4f2._m03(f2);
            f2 = matrix4f.m10();
            matrix4f._m10(matrix4f2.m10());
            matrix4f2._m10(f2);
            f2 = matrix4f.m11();
            matrix4f._m11(matrix4f2.m11());
            matrix4f2._m11(f2);
            f2 = matrix4f.m12();
            matrix4f._m12(matrix4f2.m12());
            matrix4f2._m12(f2);
            f2 = matrix4f.m13();
            matrix4f._m13(matrix4f2.m13());
            matrix4f2._m13(f2);
            f2 = matrix4f.m20();
            matrix4f._m20(matrix4f2.m20());
            matrix4f2._m20(f2);
            f2 = matrix4f.m21();
            matrix4f._m21(matrix4f2.m21());
            matrix4f2._m21(f2);
            f2 = matrix4f.m22();
            matrix4f._m22(matrix4f2.m22());
            matrix4f2._m22(f2);
            f2 = matrix4f.m23();
            matrix4f._m23(matrix4f2.m23());
            matrix4f2._m23(f2);
            f2 = matrix4f.m30();
            matrix4f._m30(matrix4f2.m30());
            matrix4f2._m30(f2);
            f2 = matrix4f.m31();
            matrix4f._m31(matrix4f2.m31());
            matrix4f2._m31(f2);
            f2 = matrix4f.m32();
            matrix4f._m32(matrix4f2.m32());
            matrix4f2._m32(f2);
            f2 = matrix4f.m33();
            matrix4f._m33(matrix4f2.m33());
            matrix4f2._m33(f2);
        }

        public void swap(Matrix4x3f matrix4x3f, Matrix4x3f matrix4x3f2) {
            float f2 = matrix4x3f.m00();
            matrix4x3f._m00(matrix4x3f2.m00());
            matrix4x3f2._m00(f2);
            f2 = matrix4x3f.m01();
            matrix4x3f._m01(matrix4x3f2.m01());
            matrix4x3f2._m01(f2);
            f2 = matrix4x3f.m02();
            matrix4x3f._m02(matrix4x3f2.m02());
            matrix4x3f2._m02(f2);
            f2 = matrix4x3f.m10();
            matrix4x3f._m10(matrix4x3f2.m10());
            matrix4x3f2._m10(f2);
            f2 = matrix4x3f.m11();
            matrix4x3f._m11(matrix4x3f2.m11());
            matrix4x3f2._m11(f2);
            f2 = matrix4x3f.m12();
            matrix4x3f._m12(matrix4x3f2.m12());
            matrix4x3f2._m12(f2);
            f2 = matrix4x3f.m20();
            matrix4x3f._m20(matrix4x3f2.m20());
            matrix4x3f2._m20(f2);
            f2 = matrix4x3f.m21();
            matrix4x3f._m21(matrix4x3f2.m21());
            matrix4x3f2._m21(f2);
            f2 = matrix4x3f.m22();
            matrix4x3f._m22(matrix4x3f2.m22());
            matrix4x3f2._m22(f2);
            f2 = matrix4x3f.m30();
            matrix4x3f._m30(matrix4x3f2.m30());
            matrix4x3f2._m30(f2);
            f2 = matrix4x3f.m31();
            matrix4x3f._m31(matrix4x3f2.m31());
            matrix4x3f2._m31(f2);
            f2 = matrix4x3f.m32();
            matrix4x3f._m32(matrix4x3f2.m32());
            matrix4x3f2._m32(f2);
        }

        public void swap(Matrix3f matrix3f, Matrix3f matrix3f2) {
            float f2 = matrix3f.m00();
            matrix3f._m00(matrix3f2.m00());
            matrix3f2._m00(f2);
            f2 = matrix3f.m01();
            matrix3f._m01(matrix3f2.m01());
            matrix3f2._m01(f2);
            f2 = matrix3f.m02();
            matrix3f._m02(matrix3f2.m02());
            matrix3f2._m02(f2);
            f2 = matrix3f.m10();
            matrix3f._m10(matrix3f2.m10());
            matrix3f2._m10(f2);
            f2 = matrix3f.m11();
            matrix3f._m11(matrix3f2.m11());
            matrix3f2._m11(f2);
            f2 = matrix3f.m12();
            matrix3f._m12(matrix3f2.m12());
            matrix3f2._m12(f2);
            f2 = matrix3f.m20();
            matrix3f._m20(matrix3f2.m20());
            matrix3f2._m20(f2);
            f2 = matrix3f.m21();
            matrix3f._m21(matrix3f2.m21());
            matrix3f2._m21(f2);
            f2 = matrix3f.m22();
            matrix3f._m22(matrix3f2.m22());
            matrix3f2._m22(f2);
        }

        public void swap(Matrix2f matrix2f, Matrix2f matrix2f2) {
            float f2 = matrix2f.m00();
            matrix2f._m00(matrix2f2.m00());
            matrix2f2._m00(f2);
            f2 = matrix2f.m01();
            matrix2f._m00(matrix2f2.m01());
            matrix2f2._m01(f2);
            f2 = matrix2f.m10();
            matrix2f._m00(matrix2f2.m10());
            matrix2f2._m10(f2);
            f2 = matrix2f.m11();
            matrix2f._m00(matrix2f2.m11());
            matrix2f2._m11(f2);
        }

        public void swap(Matrix2d matrix2d, Matrix2d matrix2d2) {
            double d2 = matrix2d.m00();
            matrix2d._m00(matrix2d2.m00());
            matrix2d2._m00(d2);
            d2 = matrix2d.m01();
            matrix2d._m00(matrix2d2.m01());
            matrix2d2._m01(d2);
            d2 = matrix2d.m10();
            matrix2d._m00(matrix2d2.m10());
            matrix2d2._m10(d2);
            d2 = matrix2d.m11();
            matrix2d._m00(matrix2d2.m11());
            matrix2d2._m11(d2);
        }

        public void zero(Matrix4f matrix4f) {
            matrix4f._m00(0.0f)._m01(0.0f)._m02(0.0f)._m03(0.0f)._m10(0.0f)._m11(0.0f)._m12(0.0f)._m13(0.0f)._m20(0.0f)._m21(0.0f)._m22(0.0f)._m23(0.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f)._m33(0.0f);
        }

        public void zero(Matrix4x3f matrix4x3f) {
            matrix4x3f._m00(0.0f)._m01(0.0f)._m02(0.0f)._m10(0.0f)._m11(0.0f)._m12(0.0f)._m20(0.0f)._m21(0.0f)._m22(0.0f)._m30(0.0f)._m31(0.0f)._m32(0.0f);
        }

        public void zero(Matrix3f matrix3f) {
            matrix3f._m00(0.0f)._m01(0.0f)._m02(0.0f)._m10(0.0f)._m11(0.0f)._m12(0.0f)._m20(0.0f)._m21(0.0f)._m22(0.0f);
        }

        public void zero(Matrix3x2f matrix3x2f) {
            matrix3x2f._m00(0.0f)._m01(0.0f)._m10(0.0f)._m11(0.0f)._m20(0.0f)._m21(0.0f);
        }

        public void zero(Matrix3x2d matrix3x2d) {
            matrix3x2d._m00(0.0)._m01(0.0)._m10(0.0)._m11(0.0)._m20(0.0)._m21(0.0);
        }

        public void zero(Matrix2f matrix2f) {
            matrix2f._m00(0.0f)._m01(0.0f)._m10(0.0f)._m11(0.0f);
        }

        public void zero(Matrix2d matrix2d) {
            matrix2d._m00(0.0)._m01(0.0)._m10(0.0)._m11(0.0);
        }

        public void putMatrix3f(Quaternionf quaternionf, int n2, ByteBuffer byteBuffer) {
            float f2 = quaternionf.w * quaternionf.w;
            float f3 = quaternionf.x * quaternionf.x;
            float f4 = quaternionf.y * quaternionf.y;
            float f5 = quaternionf.z * quaternionf.z;
            float f6 = quaternionf.z * quaternionf.w;
            float f7 = quaternionf.x * quaternionf.y;
            float f8 = quaternionf.x * quaternionf.z;
            float f9 = quaternionf.y * quaternionf.w;
            float f10 = quaternionf.y * quaternionf.z;
            float f11 = quaternionf.x * quaternionf.w;
            float f12 = f10;
            float f13 = f10;
            byteBuffer.putFloat(n2, f2 + f3 - f5 - f4).putFloat(n2 + 4, f7 + f6 + f6 + f7).putFloat(n2 + 8, f8 - f9 + f8 - f9).putFloat(n2 + 12, -f6 + f7 - f6 + f7).putFloat(n2 + 16, f4 - f5 + f2 - f3).putFloat(n2 + 20, f12 + f12 + f11 + f11).putFloat(n2 + 24, f9 + f8 + f8 + f9).putFloat(n2 + 28, f13 + f13 - f11 - f11).putFloat(n2 + 32, f5 - f4 - f3 + f2);
        }

        public void putMatrix3f(Quaternionf quaternionf, int n2, FloatBuffer floatBuffer) {
            float f2 = quaternionf.w * quaternionf.w;
            float f3 = quaternionf.x * quaternionf.x;
            float f4 = quaternionf.y * quaternionf.y;
            float f5 = quaternionf.z * quaternionf.z;
            float f6 = quaternionf.z * quaternionf.w;
            float f7 = quaternionf.x * quaternionf.y;
            float f8 = quaternionf.x * quaternionf.z;
            float f9 = quaternionf.y * quaternionf.w;
            float f10 = quaternionf.y * quaternionf.z;
            float f11 = quaternionf.x * quaternionf.w;
            float f12 = f10;
            float f13 = f10;
            floatBuffer.put(n2, f2 + f3 - f5 - f4).put(n2 + 1, f7 + f6 + f6 + f7).put(n2 + 2, f8 - f9 + f8 - f9).put(n2 + 3, -f6 + f7 - f6 + f7).put(n2 + 4, f4 - f5 + f2 - f3).put(n2 + 5, f12 + f12 + f11 + f11).put(n2 + 6, f9 + f8 + f8 + f9).put(n2 + 7, f13 + f13 - f11 - f11).put(n2 + 8, f5 - f4 - f3 + f2);
        }

        public void putMatrix4f(Quaternionf quaternionf, int n2, ByteBuffer byteBuffer) {
            float f2 = quaternionf.w * quaternionf.w;
            float f3 = quaternionf.x * quaternionf.x;
            float f4 = quaternionf.y * quaternionf.y;
            float f5 = quaternionf.z * quaternionf.z;
            float f6 = quaternionf.z * quaternionf.w;
            float f7 = quaternionf.x * quaternionf.y;
            float f8 = quaternionf.x * quaternionf.z;
            float f9 = quaternionf.y * quaternionf.w;
            float f10 = quaternionf.y * quaternionf.z;
            float f11 = quaternionf.x * quaternionf.w;
            float f12 = f10;
            float f13 = f10;
            byteBuffer.putFloat(n2, f2 + f3 - f5 - f4).putFloat(n2 + 4, f7 + f6 + f6 + f7).putFloat(n2 + 8, f8 - f9 + f8 - f9).putFloat(n2 + 12, 0.0f).putFloat(n2 + 16, -f6 + f7 - f6 + f7).putFloat(n2 + 20, f4 - f5 + f2 - f3).putFloat(n2 + 24, f12 + f12 + f11 + f11).putFloat(n2 + 28, 0.0f).putFloat(n2 + 32, f9 + f8 + f8 + f9).putFloat(n2 + 36, f13 + f13 - f11 - f11).putFloat(n2 + 40, f5 - f4 - f3 + f2).putFloat(n2 + 44, 0.0f).putLong(n2 + 48, 0L).putLong(n2 + 56, 4575657221408423936L);
        }

        public void putMatrix4f(Quaternionf quaternionf, int n2, FloatBuffer floatBuffer) {
            float f2 = quaternionf.w * quaternionf.w;
            float f3 = quaternionf.x * quaternionf.x;
            float f4 = quaternionf.y * quaternionf.y;
            float f5 = quaternionf.z * quaternionf.z;
            float f6 = quaternionf.z * quaternionf.w;
            float f7 = quaternionf.x * quaternionf.y;
            float f8 = quaternionf.x * quaternionf.z;
            float f9 = quaternionf.y * quaternionf.w;
            float f10 = quaternionf.y * quaternionf.z;
            float f11 = quaternionf.x * quaternionf.w;
            float f12 = f10;
            float f13 = f10;
            floatBuffer.put(n2, f2 + f3 - f5 - f4).put(n2 + 1, f7 + f6 + f6 + f7).put(n2 + 2, f8 - f9 + f8 - f9).put(n2 + 3, 0.0f).put(n2 + 4, -f6 + f7 - f6 + f7).put(n2 + 5, f4 - f5 + f2 - f3).put(n2 + 6, f12 + f12 + f11 + f11).put(n2 + 7, 0.0f).put(n2 + 8, f9 + f8 + f8 + f9).put(n2 + 9, f13 + f13 - f11 - f11).put(n2 + 10, f5 - f4 - f3 + f2).put(n2 + 11, 0.0f).put(n2 + 12, 0.0f).put(n2 + 13, 0.0f).put(n2 + 14, 0.0f).put(n2 + 15, 1.0f);
        }

        public void putMatrix4x3f(Quaternionf quaternionf, int n2, ByteBuffer byteBuffer) {
            float f2 = quaternionf.w * quaternionf.w;
            float f3 = quaternionf.x * quaternionf.x;
            float f4 = quaternionf.y * quaternionf.y;
            float f5 = quaternionf.z * quaternionf.z;
            float f6 = quaternionf.z * quaternionf.w;
            float f7 = quaternionf.x * quaternionf.y;
            float f8 = quaternionf.x * quaternionf.z;
            float f9 = quaternionf.y * quaternionf.w;
            float f10 = quaternionf.y * quaternionf.z;
            float f11 = quaternionf.x * quaternionf.w;
            float f12 = f10;
            float f13 = f10;
            byteBuffer.putFloat(n2, f2 + f3 - f5 - f4).putFloat(n2 + 4, f7 + f6 + f6 + f7).putFloat(n2 + 8, f8 - f9 + f8 - f9).putFloat(n2 + 12, -f6 + f7 - f6 + f7).putFloat(n2 + 16, f4 - f5 + f2 - f3).putFloat(n2 + 20, f12 + f12 + f11 + f11).putFloat(n2 + 24, f9 + f8 + f8 + f9).putFloat(n2 + 28, f13 + f13 - f11 - f11).putFloat(n2 + 32, f5 - f4 - f3 + f2).putLong(n2 + 36, 0L).putFloat(n2 + 44, 0.0f);
        }

        public void putMatrix4x3f(Quaternionf quaternionf, int n2, FloatBuffer floatBuffer) {
            float f2 = quaternionf.w * quaternionf.w;
            float f3 = quaternionf.x * quaternionf.x;
            float f4 = quaternionf.y * quaternionf.y;
            float f5 = quaternionf.z * quaternionf.z;
            float f6 = quaternionf.z * quaternionf.w;
            float f7 = quaternionf.x * quaternionf.y;
            float f8 = quaternionf.x * quaternionf.z;
            float f9 = quaternionf.y * quaternionf.w;
            float f10 = quaternionf.y * quaternionf.z;
            float f11 = quaternionf.x * quaternionf.w;
            float f12 = f10;
            float f13 = f10;
            floatBuffer.put(n2, f2 + f3 - f5 - f4).put(n2 + 1, f7 + f6 + f6 + f7).put(n2 + 2, f8 - f9 + f8 - f9).put(n2 + 3, -f6 + f7 - f6 + f7).put(n2 + 4, f4 - f5 + f2 - f3).put(n2 + 5, f12 + f12 + f11 + f11).put(n2 + 6, f9 + f8 + f8 + f9).put(n2 + 7, f13 + f13 - f11 - f11).put(n2 + 8, f5 - f4 - f3 + f2).put(n2 + 9, 0.0f).put(n2 + 10, 0.0f).put(n2 + 11, 0.0f);
        }
    }
}

