/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.joml.Matrix4x3d;

public class Matrix4x3dStack
extends Matrix4x3d {
    private static final long serialVersionUID = 1L;
    private Matrix4x3d[] mats;
    private int curr;

    public Matrix4x3dStack(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("stackSize must be >= 1");
        }
        this.mats = new Matrix4x3d[n2 - 1];
        for (n2 = 0; n2 < this.mats.length; ++n2) {
            this.mats[n2] = new Matrix4x3d();
        }
    }

    public Matrix4x3dStack() {
    }

    public Matrix4x3dStack clear() {
        this.curr = 0;
        this.identity();
        return this;
    }

    public Matrix4x3dStack pushMatrix() {
        if (this.curr == this.mats.length) {
            throw new IllegalStateException("max stack size of " + (this.curr + 1) + " reached");
        }
        this.mats[this.curr++].set(this);
        return this;
    }

    public Matrix4x3dStack popMatrix() {
        if (this.curr == 0) {
            throw new IllegalStateException("already at the bottom of the stack");
        }
        Matrix4x3dStack matrix4x3dStack = this;
        matrix4x3dStack.set(matrix4x3dStack.mats[--this.curr]);
        return this;
    }

    public int hashCode() {
        int n2 = super.hashCode() * 31 + this.curr;
        for (int i2 = 0; i2 < this.curr; ++i2) {
            n2 = n2 * 31 + this.mats[i2].hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof Matrix4x3dStack) {
            object = (Matrix4x3dStack)object;
            if (this.curr != ((Matrix4x3dStack)object).curr) {
                return false;
            }
            for (int i2 = 0; i2 < this.curr; ++i2) {
                if (this.mats[i2].equals(((Matrix4x3dStack)object).mats[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.curr);
        for (int i2 = 0; i2 < this.curr; ++i2) {
            objectOutput.writeObject(this.mats[i2]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        super.readExternal(objectInput);
        this.curr = objectInput.readInt();
        this.mats = new Matrix4x3dStack[this.curr];
        for (int i2 = 0; i2 < this.curr; ++i2) {
            Matrix4x3d matrix4x3d = new Matrix4x3d();
            matrix4x3d.readExternal(objectInput);
            this.mats[i2] = matrix4x3d;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Matrix4x3dStack matrix4x3dStack = (Matrix4x3dStack)super.clone();
        Matrix4x3d[] matrix4x3dArray = new Matrix4x3d[this.mats.length];
        for (int i2 = 0; i2 < this.mats.length; ++i2) {
            matrix4x3dArray[i2] = (Matrix4x3d)this.mats[i2].clone();
        }
        matrix4x3dStack.mats = matrix4x3dArray;
        return matrix4x3dStack;
    }
}

