/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.Vector4d;
import org.joml.Vector4dc;

public class Matrix4x3d
implements Externalizable,
Cloneable,
Matrix4x3dc {
    private static final long serialVersionUID = 1L;
    double m00;
    double m01;
    double m02;
    double m10;
    double m11;
    double m12;
    double m20;
    double m21;
    double m22;
    double m30;
    double m31;
    double m32;
    int properties;

    public Matrix4x3d() {
        this.m00 = 1.0;
        this.m11 = 1.0;
        this.m22 = 1.0;
        this.properties = 28;
    }

    public Matrix4x3d(Matrix4x3dc matrix4x3dc) {
        this.set(matrix4x3dc);
    }

    public Matrix4x3d(Matrix4x3fc matrix4x3fc) {
        this.set(matrix4x3fc);
    }

    public Matrix4x3d(Matrix3dc matrix3dc) {
        this.set(matrix3dc);
    }

    public Matrix4x3d(Matrix3fc matrix3fc) {
        this.set(matrix3fc);
    }

    public Matrix4x3d(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m20 = d8;
        this.m21 = d9;
        this.m22 = d10;
        this.m30 = d11;
        this.m31 = d12;
        this.m32 = d13;
        this.determineProperties();
    }

    public Matrix4x3d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        this.determineProperties();
    }

    public Matrix4x3d assume(int n2) {
        this.properties = n2;
        return this;
    }

    public Matrix4x3d determineProperties() {
        int n2 = 0;
        if (this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0) {
            n2 = 24;
            if (this.m30 == 0.0 && this.m31 == 0.0 && this.m32 == 0.0) {
                n2 = 28;
            }
        }
        this.properties = n2;
        return this;
    }

    public int properties() {
        return this.properties;
    }

    public double m00() {
        return this.m00;
    }

    public double m01() {
        return this.m01;
    }

    public double m02() {
        return this.m02;
    }

    public double m10() {
        return this.m10;
    }

    public double m11() {
        return this.m11;
    }

    public double m12() {
        return this.m12;
    }

    public double m20() {
        return this.m20;
    }

    public double m21() {
        return this.m21;
    }

    public double m22() {
        return this.m22;
    }

    public double m30() {
        return this.m30;
    }

    public double m31() {
        return this.m31;
    }

    public double m32() {
        return this.m32;
    }

    Matrix4x3d _properties(int n2) {
        this.properties = n2;
        return this;
    }

    Matrix4x3d _m00(double d2) {
        this.m00 = d2;
        return this;
    }

    Matrix4x3d _m01(double d2) {
        this.m01 = d2;
        return this;
    }

    Matrix4x3d _m02(double d2) {
        this.m02 = d2;
        return this;
    }

    Matrix4x3d _m10(double d2) {
        this.m10 = d2;
        return this;
    }

    Matrix4x3d _m11(double d2) {
        this.m11 = d2;
        return this;
    }

    Matrix4x3d _m12(double d2) {
        this.m12 = d2;
        return this;
    }

    Matrix4x3d _m20(double d2) {
        this.m20 = d2;
        return this;
    }

    Matrix4x3d _m21(double d2) {
        this.m21 = d2;
        return this;
    }

    Matrix4x3d _m22(double d2) {
        this.m22 = d2;
        return this;
    }

    Matrix4x3d _m30(double d2) {
        this.m30 = d2;
        return this;
    }

    Matrix4x3d _m31(double d2) {
        this.m31 = d2;
        return this;
    }

    Matrix4x3d _m32(double d2) {
        this.m32 = d2;
        return this;
    }

    public Matrix4x3d m00(double d2) {
        this.m00 = d2;
        this.properties &= 0xFFFFFFEF;
        if (d2 != 1.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m01(double d2) {
        this.m01 = d2;
        this.properties &= 0xFFFFFFEF;
        if (d2 != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m02(double d2) {
        this.m02 = d2;
        this.properties &= 0xFFFFFFEF;
        if (d2 != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m10(double d2) {
        this.m10 = d2;
        this.properties &= 0xFFFFFFEF;
        if (d2 != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m11(double d2) {
        this.m11 = d2;
        this.properties &= 0xFFFFFFEF;
        if (d2 != 1.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m12(double d2) {
        this.m12 = d2;
        this.properties &= 0xFFFFFFEF;
        if (d2 != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m20(double d2) {
        this.m20 = d2;
        this.properties &= 0xFFFFFFEF;
        if (d2 != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m21(double d2) {
        this.m21 = d2;
        this.properties &= 0xFFFFFFEF;
        if (d2 != 0.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m22(double d2) {
        this.m22 = d2;
        this.properties &= 0xFFFFFFEF;
        if (d2 != 1.0) {
            this.properties &= 0xFFFFFFF3;
        }
        return this;
    }

    public Matrix4x3d m30(double d2) {
        this.m30 = d2;
        if (d2 != 0.0) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    public Matrix4x3d m31(double d2) {
        this.m31 = d2;
        if (d2 != 0.0) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    public Matrix4x3d m32(double d2) {
        this.m32 = d2;
        if (d2 != 0.0) {
            this.properties &= 0xFFFFFFFB;
        }
        return this;
    }

    public Matrix4x3d identity() {
        if ((this.properties & 4) != 0) {
            return this;
        }
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 28;
        return this;
    }

    public Matrix4x3d set(Matrix4x3dc matrix4x3dc) {
        if (matrix4x3dc == this) {
            return this;
        }
        this.m00 = matrix4x3dc.m00();
        this.m01 = matrix4x3dc.m01();
        this.m02 = matrix4x3dc.m02();
        this.m10 = matrix4x3dc.m10();
        this.m11 = matrix4x3dc.m11();
        this.m12 = matrix4x3dc.m12();
        this.m20 = matrix4x3dc.m20();
        this.m21 = matrix4x3dc.m21();
        this.m22 = matrix4x3dc.m22();
        this.m30 = matrix4x3dc.m30();
        this.m31 = matrix4x3dc.m31();
        this.m32 = matrix4x3dc.m32();
        this.properties = matrix4x3dc.properties();
        return this;
    }

    public Matrix4x3d set(Matrix4x3fc matrix4x3fc) {
        this.m00 = matrix4x3fc.m00();
        this.m01 = matrix4x3fc.m01();
        this.m02 = matrix4x3fc.m02();
        this.m10 = matrix4x3fc.m10();
        this.m11 = matrix4x3fc.m11();
        this.m12 = matrix4x3fc.m12();
        this.m20 = matrix4x3fc.m20();
        this.m21 = matrix4x3fc.m21();
        this.m22 = matrix4x3fc.m22();
        this.m30 = matrix4x3fc.m30();
        this.m31 = matrix4x3fc.m31();
        this.m32 = matrix4x3fc.m32();
        this.properties = matrix4x3fc.properties();
        return this;
    }

    public Matrix4x3d set(Matrix4dc matrix4dc) {
        this.m00 = matrix4dc.m00();
        this.m01 = matrix4dc.m01();
        this.m02 = matrix4dc.m02();
        this.m10 = matrix4dc.m10();
        this.m11 = matrix4dc.m11();
        this.m12 = matrix4dc.m12();
        this.m20 = matrix4dc.m20();
        this.m21 = matrix4dc.m21();
        this.m22 = matrix4dc.m22();
        this.m30 = matrix4dc.m30();
        this.m31 = matrix4dc.m31();
        this.m32 = matrix4dc.m32();
        this.properties = matrix4dc.properties() & 0x1C;
        return this;
    }

    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set4x3(this);
    }

    public Matrix4x3d set(Matrix3dc matrix3dc) {
        this.m00 = matrix3dc.m00();
        this.m01 = matrix3dc.m01();
        this.m02 = matrix3dc.m02();
        this.m10 = matrix3dc.m10();
        this.m11 = matrix3dc.m11();
        this.m12 = matrix3dc.m12();
        this.m20 = matrix3dc.m20();
        this.m21 = matrix3dc.m21();
        this.m22 = matrix3dc.m22();
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        return this.determineProperties();
    }

    public Matrix4x3d set(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m02 = matrix3fc.m02();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
        this.m12 = matrix3fc.m12();
        this.m20 = matrix3fc.m20();
        this.m21 = matrix3fc.m21();
        this.m22 = matrix3fc.m22();
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        return this.determineProperties();
    }

    public Matrix4x3d set(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4) {
        this.m00 = vector3dc.x();
        this.m01 = vector3dc.y();
        this.m02 = vector3dc.z();
        this.m10 = vector3dc2.x();
        this.m11 = vector3dc2.y();
        this.m12 = vector3dc2.z();
        this.m20 = vector3dc3.x();
        this.m21 = vector3dc3.y();
        this.m22 = vector3dc3.z();
        this.m30 = vector3dc4.x();
        this.m31 = vector3dc4.y();
        this.m32 = vector3dc4.z();
        return this.determineProperties();
    }

    public Matrix4x3d set3x3(Matrix4x3dc matrix4x3dc) {
        this.m00 = matrix4x3dc.m00();
        this.m01 = matrix4x3dc.m01();
        this.m02 = matrix4x3dc.m02();
        this.m10 = matrix4x3dc.m10();
        this.m11 = matrix4x3dc.m11();
        this.m12 = matrix4x3dc.m12();
        this.m20 = matrix4x3dc.m20();
        this.m21 = matrix4x3dc.m21();
        this.m22 = matrix4x3dc.m22();
        this.properties &= matrix4x3dc.properties();
        return this;
    }

    public Matrix4x3d set(AxisAngle4f axisAngle4f) {
        double d2 = axisAngle4f.x;
        double d3 = axisAngle4f.y;
        double d4 = axisAngle4f.z;
        double d5 = axisAngle4f.angle;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = Math.invsqrt(d6 * d6 + d7 * d7 + d8 * d8);
        d2 *= d9;
        d3 *= d9;
        d4 *= d9;
        double d10 = Math.sin(d5);
        double d11 = Math.cosFromSin(d10, d5);
        double d12 = 1.0 - d11;
        double d13 = d2;
        this.m00 = d11 + d13 * d13 * d12;
        double d14 = d3;
        this.m11 = d11 + d14 * d14 * d12;
        double d15 = d4;
        this.m22 = d11 + d15 * d15 * d12;
        double d16 = d2 * d3 * d12;
        double d17 = d4 * d10;
        this.m10 = d16 - d17;
        this.m01 = d16 + d17;
        d16 = d2 * d4 * d12;
        d17 = d3 * d10;
        this.m20 = d16 + d17;
        this.m02 = d16 - d17;
        d16 = d3 * d4 * d12;
        d17 = d2 * d10;
        this.m21 = d16 - d17;
        this.m12 = d16 + d17;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d set(AxisAngle4d axisAngle4d) {
        double d2 = axisAngle4d.x;
        double d3 = axisAngle4d.y;
        double d4 = axisAngle4d.z;
        double d5 = axisAngle4d.angle;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = Math.invsqrt(d6 * d6 + d7 * d7 + d8 * d8);
        d2 *= d9;
        d3 *= d9;
        d4 *= d9;
        double d10 = Math.sin(d5);
        double d11 = Math.cosFromSin(d10, d5);
        double d12 = 1.0 - d11;
        double d13 = d2;
        this.m00 = d11 + d13 * d13 * d12;
        double d14 = d3;
        this.m11 = d11 + d14 * d14 * d12;
        double d15 = d4;
        this.m22 = d11 + d15 * d15 * d12;
        double d16 = d2 * d3 * d12;
        double d17 = d4 * d10;
        this.m10 = d16 - d17;
        this.m01 = d16 + d17;
        d16 = d2 * d4 * d12;
        d17 = d3 * d10;
        this.m20 = d16 + d17;
        this.m02 = d16 - d17;
        d16 = d3 * d4 * d12;
        d17 = d2 * d10;
        this.m21 = d16 - d17;
        this.m12 = d16 + d17;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d set(Quaternionfc quaternionfc) {
        return this.rotation(quaternionfc);
    }

    public Matrix4x3d set(Quaterniondc quaterniondc) {
        return this.rotation(quaterniondc);
    }

    public Matrix4x3d mul(Matrix4x3dc matrix4x3dc) {
        return this.mul(matrix4x3dc, this);
    }

    public Matrix4x3d mul(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.set(matrix4x3dc);
        }
        if ((matrix4x3dc.properties() & 4) != 0) {
            return matrix4x3d.set(this);
        }
        if ((this.properties & 8) != 0) {
            return this.mulTranslation(matrix4x3dc, matrix4x3d);
        }
        return this.mulGeneric(matrix4x3dc, matrix4x3d);
    }

    private Matrix4x3d mulGeneric(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        double d8 = this.m20;
        double d9 = this.m21;
        double d10 = this.m22;
        double d11 = matrix4x3dc.m00();
        double d12 = matrix4x3dc.m01();
        double d13 = matrix4x3dc.m02();
        double d14 = matrix4x3dc.m10();
        double d15 = matrix4x3dc.m11();
        double d16 = matrix4x3dc.m12();
        double d17 = matrix4x3dc.m20();
        double d18 = matrix4x3dc.m21();
        double d19 = matrix4x3dc.m22();
        double d20 = matrix4x3dc.m30();
        double d21 = matrix4x3dc.m31();
        double d22 = matrix4x3dc.m32();
        return matrix4x3d._m00(Math.fma(d2, d11, Math.fma(d5, d12, d8 * d13)))._m01(Math.fma(d3, d11, Math.fma(d6, d12, d9 * d13)))._m02(Math.fma(d4, d11, Math.fma(d7, d12, d10 * d13)))._m10(Math.fma(d2, d14, Math.fma(d5, d15, d8 * d16)))._m11(Math.fma(d3, d14, Math.fma(d6, d15, d9 * d16)))._m12(Math.fma(d4, d14, Math.fma(d7, d15, d10 * d16)))._m20(Math.fma(d2, d17, Math.fma(d5, d18, d8 * d19)))._m21(Math.fma(d3, d17, Math.fma(d6, d18, d9 * d19)))._m22(Math.fma(d4, d17, Math.fma(d7, d18, d10 * d19)))._m30(Math.fma(d2, d20, Math.fma(d5, d21, Math.fma(d8, d22, this.m30))))._m31(Math.fma(d3, d20, Math.fma(d6, d21, Math.fma(d9, d22, this.m31))))._m32(Math.fma(d4, d20, Math.fma(d7, d21, Math.fma(d10, d22, this.m32))))._properties(this.properties & matrix4x3dc.properties() & 0x10);
    }

    public Matrix4x3d mul(Matrix4x3fc matrix4x3fc) {
        return this.mul(matrix4x3fc, this);
    }

    public Matrix4x3d mul(Matrix4x3fc matrix4x3fc, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.set(matrix4x3fc);
        }
        if ((matrix4x3fc.properties() & 4) != 0) {
            return matrix4x3d.set(this);
        }
        if ((this.properties & 8) != 0) {
            return this.mulTranslation(matrix4x3fc, matrix4x3d);
        }
        return this.mulGeneric(matrix4x3fc, matrix4x3d);
    }

    private Matrix4x3d mulGeneric(Matrix4x3fc matrix4x3fc, Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        double d8 = this.m20;
        double d9 = this.m21;
        double d10 = this.m22;
        double d11 = matrix4x3fc.m00();
        double d12 = matrix4x3fc.m01();
        double d13 = matrix4x3fc.m02();
        double d14 = matrix4x3fc.m10();
        double d15 = matrix4x3fc.m11();
        double d16 = matrix4x3fc.m12();
        double d17 = matrix4x3fc.m20();
        double d18 = matrix4x3fc.m21();
        double d19 = matrix4x3fc.m22();
        double d20 = matrix4x3fc.m30();
        double d21 = matrix4x3fc.m31();
        double d22 = matrix4x3fc.m32();
        return matrix4x3d._m00(Math.fma(d2, d11, Math.fma(d5, d12, d8 * d13)))._m01(Math.fma(d3, d11, Math.fma(d6, d12, d9 * d13)))._m02(Math.fma(d4, d11, Math.fma(d7, d12, d10 * d13)))._m10(Math.fma(d2, d14, Math.fma(d5, d15, d8 * d16)))._m11(Math.fma(d3, d14, Math.fma(d6, d15, d9 * d16)))._m12(Math.fma(d4, d14, Math.fma(d7, d15, d10 * d16)))._m20(Math.fma(d2, d17, Math.fma(d5, d18, d8 * d19)))._m21(Math.fma(d3, d17, Math.fma(d6, d18, d9 * d19)))._m22(Math.fma(d4, d17, Math.fma(d7, d18, d10 * d19)))._m30(Math.fma(d2, d20, Math.fma(d5, d21, Math.fma(d8, d22, this.m30))))._m31(Math.fma(d3, d20, Math.fma(d6, d21, Math.fma(d9, d22, this.m31))))._m32(Math.fma(d4, d20, Math.fma(d7, d21, Math.fma(d10, d22, this.m32))))._properties(this.properties & matrix4x3fc.properties() & 0x10);
    }

    public Matrix4x3d mulTranslation(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        return matrix4x3d._m00(matrix4x3dc.m00())._m01(matrix4x3dc.m01())._m02(matrix4x3dc.m02())._m10(matrix4x3dc.m10())._m11(matrix4x3dc.m11())._m12(matrix4x3dc.m12())._m20(matrix4x3dc.m20())._m21(matrix4x3dc.m21())._m22(matrix4x3dc.m22())._m30(matrix4x3dc.m30() + this.m30)._m31(matrix4x3dc.m31() + this.m31)._m32(matrix4x3dc.m32() + this.m32)._properties(matrix4x3dc.properties() & 0x10);
    }

    public Matrix4x3d mulTranslation(Matrix4x3fc matrix4x3fc, Matrix4x3d matrix4x3d) {
        return matrix4x3d._m00(matrix4x3fc.m00())._m01(matrix4x3fc.m01())._m02(matrix4x3fc.m02())._m10(matrix4x3fc.m10())._m11(matrix4x3fc.m11())._m12(matrix4x3fc.m12())._m20(matrix4x3fc.m20())._m21(matrix4x3fc.m21())._m22(matrix4x3fc.m22())._m30((double)matrix4x3fc.m30() + this.m30)._m31((double)matrix4x3fc.m31() + this.m31)._m32((double)matrix4x3fc.m32() + this.m32)._properties(matrix4x3fc.properties() & 0x10);
    }

    public Matrix4x3d mulOrtho(Matrix4x3dc matrix4x3dc) {
        return this.mulOrtho(matrix4x3dc, this);
    }

    public Matrix4x3d mulOrtho(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        double d2 = this.m00 * matrix4x3dc.m00();
        double d3 = this.m11 * matrix4x3dc.m01();
        double d4 = this.m22 * matrix4x3dc.m02();
        double d5 = this.m00 * matrix4x3dc.m10();
        double d6 = this.m11 * matrix4x3dc.m11();
        double d7 = this.m22 * matrix4x3dc.m12();
        double d8 = this.m00 * matrix4x3dc.m20();
        double d9 = this.m11 * matrix4x3dc.m21();
        double d10 = this.m22 * matrix4x3dc.m22();
        double d11 = this.m00 * matrix4x3dc.m30() + this.m30;
        double d12 = this.m11 * matrix4x3dc.m31() + this.m31;
        double d13 = this.m22 * matrix4x3dc.m32() + this.m32;
        matrix4x3d.m00 = d2;
        matrix4x3d.m01 = d3;
        matrix4x3d.m02 = d4;
        matrix4x3d.m10 = d5;
        matrix4x3d.m11 = d6;
        matrix4x3d.m12 = d7;
        matrix4x3d.m20 = d8;
        matrix4x3d.m21 = d9;
        matrix4x3d.m22 = d10;
        matrix4x3d.m30 = d11;
        matrix4x3d.m31 = d12;
        matrix4x3d.m32 = d13;
        matrix4x3d.properties = this.properties & matrix4x3dc.properties() & 0x10;
        return matrix4x3d;
    }

    public Matrix4x3d mul3x3(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        return this.mul3x3(d2, d3, d4, d5, d6, d7, d8, d9, d10, this);
    }

    public Matrix4x3d mul3x3(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Matrix4x3d matrix4x3d) {
        double d11 = this.m00;
        double d12 = this.m01;
        double d13 = this.m02;
        double d14 = this.m10;
        double d15 = this.m11;
        double d16 = this.m12;
        double d17 = this.m20;
        double d18 = this.m21;
        double d19 = this.m22;
        return matrix4x3d._m00(Math.fma(d11, d2, Math.fma(d14, d3, d17 * d4)))._m01(Math.fma(d12, d2, Math.fma(d15, d3, d18 * d4)))._m02(Math.fma(d13, d2, Math.fma(d16, d3, d19 * d4)))._m10(Math.fma(d11, d5, Math.fma(d14, d6, d17 * d7)))._m11(Math.fma(d12, d5, Math.fma(d15, d6, d18 * d7)))._m12(Math.fma(d13, d5, Math.fma(d16, d6, d19 * d7)))._m20(Math.fma(d11, d8, Math.fma(d14, d9, d17 * d10)))._m21(Math.fma(d12, d8, Math.fma(d15, d9, d18 * d10)))._m22(Math.fma(d13, d8, Math.fma(d16, d9, d19 * d10)))._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(0);
    }

    public Matrix4x3d fma(Matrix4x3dc matrix4x3dc, double d2) {
        return this.fma(matrix4x3dc, d2, this);
    }

    public Matrix4x3d fma(Matrix4x3dc matrix4x3dc, double d2, Matrix4x3d matrix4x3d) {
        matrix4x3d._m00(Math.fma(matrix4x3dc.m00(), d2, this.m00))._m01(Math.fma(matrix4x3dc.m01(), d2, this.m01))._m02(Math.fma(matrix4x3dc.m02(), d2, this.m02))._m10(Math.fma(matrix4x3dc.m10(), d2, this.m10))._m11(Math.fma(matrix4x3dc.m11(), d2, this.m11))._m12(Math.fma(matrix4x3dc.m12(), d2, this.m12))._m20(Math.fma(matrix4x3dc.m20(), d2, this.m20))._m21(Math.fma(matrix4x3dc.m21(), d2, this.m21))._m22(Math.fma(matrix4x3dc.m22(), d2, this.m22))._m30(Math.fma(matrix4x3dc.m30(), d2, this.m30))._m31(Math.fma(matrix4x3dc.m31(), d2, this.m31))._m32(Math.fma(matrix4x3dc.m32(), d2, this.m32))._properties(0);
        return matrix4x3d;
    }

    public Matrix4x3d fma(Matrix4x3fc matrix4x3fc, double d2) {
        return this.fma(matrix4x3fc, d2, this);
    }

    public Matrix4x3d fma(Matrix4x3fc matrix4x3fc, double d2, Matrix4x3d matrix4x3d) {
        matrix4x3d._m00(Math.fma((double)matrix4x3fc.m00(), d2, this.m00))._m01(Math.fma((double)matrix4x3fc.m01(), d2, this.m01))._m02(Math.fma((double)matrix4x3fc.m02(), d2, this.m02))._m10(Math.fma((double)matrix4x3fc.m10(), d2, this.m10))._m11(Math.fma((double)matrix4x3fc.m11(), d2, this.m11))._m12(Math.fma((double)matrix4x3fc.m12(), d2, this.m12))._m20(Math.fma((double)matrix4x3fc.m20(), d2, this.m20))._m21(Math.fma((double)matrix4x3fc.m21(), d2, this.m21))._m22(Math.fma((double)matrix4x3fc.m22(), d2, this.m22))._m30(Math.fma((double)matrix4x3fc.m30(), d2, this.m30))._m31(Math.fma((double)matrix4x3fc.m31(), d2, this.m31))._m32(Math.fma((double)matrix4x3fc.m32(), d2, this.m32))._properties(0);
        return matrix4x3d;
    }

    public Matrix4x3d add(Matrix4x3dc matrix4x3dc) {
        return this.add(matrix4x3dc, this);
    }

    public Matrix4x3d add(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 + matrix4x3dc.m00();
        matrix4x3d.m01 = this.m01 + matrix4x3dc.m01();
        matrix4x3d.m02 = this.m02 + matrix4x3dc.m02();
        matrix4x3d.m10 = this.m10 + matrix4x3dc.m10();
        matrix4x3d.m11 = this.m11 + matrix4x3dc.m11();
        matrix4x3d.m12 = this.m12 + matrix4x3dc.m12();
        matrix4x3d.m20 = this.m20 + matrix4x3dc.m20();
        matrix4x3d.m21 = this.m21 + matrix4x3dc.m21();
        matrix4x3d.m22 = this.m22 + matrix4x3dc.m22();
        matrix4x3d.m30 = this.m30 + matrix4x3dc.m30();
        matrix4x3d.m31 = this.m31 + matrix4x3dc.m31();
        matrix4x3d.m32 = this.m32 + matrix4x3dc.m32();
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d add(Matrix4x3fc matrix4x3fc) {
        return this.add(matrix4x3fc, this);
    }

    public Matrix4x3d add(Matrix4x3fc matrix4x3fc, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 + (double)matrix4x3fc.m00();
        matrix4x3d.m01 = this.m01 + (double)matrix4x3fc.m01();
        matrix4x3d.m02 = this.m02 + (double)matrix4x3fc.m02();
        matrix4x3d.m10 = this.m10 + (double)matrix4x3fc.m10();
        matrix4x3d.m11 = this.m11 + (double)matrix4x3fc.m11();
        matrix4x3d.m12 = this.m12 + (double)matrix4x3fc.m12();
        matrix4x3d.m20 = this.m20 + (double)matrix4x3fc.m20();
        matrix4x3d.m21 = this.m21 + (double)matrix4x3fc.m21();
        matrix4x3d.m22 = this.m22 + (double)matrix4x3fc.m22();
        matrix4x3d.m30 = this.m30 + (double)matrix4x3fc.m30();
        matrix4x3d.m31 = this.m31 + (double)matrix4x3fc.m31();
        matrix4x3d.m32 = this.m32 + (double)matrix4x3fc.m32();
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d sub(Matrix4x3dc matrix4x3dc) {
        return this.sub(matrix4x3dc, this);
    }

    public Matrix4x3d sub(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 - matrix4x3dc.m00();
        matrix4x3d.m01 = this.m01 - matrix4x3dc.m01();
        matrix4x3d.m02 = this.m02 - matrix4x3dc.m02();
        matrix4x3d.m10 = this.m10 - matrix4x3dc.m10();
        matrix4x3d.m11 = this.m11 - matrix4x3dc.m11();
        matrix4x3d.m12 = this.m12 - matrix4x3dc.m12();
        matrix4x3d.m20 = this.m20 - matrix4x3dc.m20();
        matrix4x3d.m21 = this.m21 - matrix4x3dc.m21();
        matrix4x3d.m22 = this.m22 - matrix4x3dc.m22();
        matrix4x3d.m30 = this.m30 - matrix4x3dc.m30();
        matrix4x3d.m31 = this.m31 - matrix4x3dc.m31();
        matrix4x3d.m32 = this.m32 - matrix4x3dc.m32();
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d sub(Matrix4x3fc matrix4x3fc) {
        return this.sub(matrix4x3fc, this);
    }

    public Matrix4x3d sub(Matrix4x3fc matrix4x3fc, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 - (double)matrix4x3fc.m00();
        matrix4x3d.m01 = this.m01 - (double)matrix4x3fc.m01();
        matrix4x3d.m02 = this.m02 - (double)matrix4x3fc.m02();
        matrix4x3d.m10 = this.m10 - (double)matrix4x3fc.m10();
        matrix4x3d.m11 = this.m11 - (double)matrix4x3fc.m11();
        matrix4x3d.m12 = this.m12 - (double)matrix4x3fc.m12();
        matrix4x3d.m20 = this.m20 - (double)matrix4x3fc.m20();
        matrix4x3d.m21 = this.m21 - (double)matrix4x3fc.m21();
        matrix4x3d.m22 = this.m22 - (double)matrix4x3fc.m22();
        matrix4x3d.m30 = this.m30 - (double)matrix4x3fc.m30();
        matrix4x3d.m31 = this.m31 - (double)matrix4x3fc.m31();
        matrix4x3d.m32 = this.m32 - (double)matrix4x3fc.m32();
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d mulComponentWise(Matrix4x3dc matrix4x3dc) {
        return this.mulComponentWise(matrix4x3dc, this);
    }

    public Matrix4x3d mulComponentWise(Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 * matrix4x3dc.m00();
        matrix4x3d.m01 = this.m01 * matrix4x3dc.m01();
        matrix4x3d.m02 = this.m02 * matrix4x3dc.m02();
        matrix4x3d.m10 = this.m10 * matrix4x3dc.m10();
        matrix4x3d.m11 = this.m11 * matrix4x3dc.m11();
        matrix4x3d.m12 = this.m12 * matrix4x3dc.m12();
        matrix4x3d.m20 = this.m20 * matrix4x3dc.m20();
        matrix4x3d.m21 = this.m21 * matrix4x3dc.m21();
        matrix4x3d.m22 = this.m22 * matrix4x3dc.m22();
        matrix4x3d.m30 = this.m30 * matrix4x3dc.m30();
        matrix4x3d.m31 = this.m31 * matrix4x3dc.m31();
        matrix4x3d.m32 = this.m32 * matrix4x3dc.m32();
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d set(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.m00 = d2;
        this.m10 = d5;
        this.m20 = d8;
        this.m30 = d11;
        this.m01 = d3;
        this.m11 = d6;
        this.m21 = d9;
        this.m31 = d12;
        this.m02 = d4;
        this.m12 = d7;
        this.m22 = d10;
        this.m32 = d13;
        return this.determineProperties();
    }

    public Matrix4x3d set(double[] dArray, int n2) {
        this.m00 = dArray[n2];
        this.m01 = dArray[n2 + 1];
        this.m02 = dArray[n2 + 2];
        this.m10 = dArray[n2 + 3];
        this.m11 = dArray[n2 + 4];
        this.m12 = dArray[n2 + 5];
        this.m20 = dArray[n2 + 6];
        this.m21 = dArray[n2 + 7];
        this.m22 = dArray[n2 + 8];
        this.m30 = dArray[n2 + 9];
        this.m31 = dArray[n2 + 10];
        this.m32 = dArray[n2 + 11];
        return this.determineProperties();
    }

    public Matrix4x3d set(double[] dArray) {
        return this.set(dArray, 0);
    }

    public Matrix4x3d set(float[] fArray, int n2) {
        this.m00 = fArray[n2];
        this.m01 = fArray[n2 + 1];
        this.m02 = fArray[n2 + 2];
        this.m10 = fArray[n2 + 3];
        this.m11 = fArray[n2 + 4];
        this.m12 = fArray[n2 + 5];
        this.m20 = fArray[n2 + 6];
        this.m21 = fArray[n2 + 7];
        this.m22 = fArray[n2 + 8];
        this.m30 = fArray[n2 + 9];
        this.m31 = fArray[n2 + 10];
        this.m32 = fArray[n2 + 11];
        return this.determineProperties();
    }

    public Matrix4x3d set(float[] fArray) {
        return this.set(fArray, 0);
    }

    public Matrix4x3d set(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.getf(this, floatBuffer.position(), floatBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d set(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n2, doubleBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d set(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.getf(this, n2, floatBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d setFloats(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.getf(this, byteBuffer.position(), byteBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d setFloats(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.getf(this, n2, byteBuffer);
        return this.determineProperties();
    }

    public Matrix4x3d setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l2);
        return this.determineProperties();
    }

    public Matrix4x3d setTransposedFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.getTransposed(this, l2);
        return this.determineProperties();
    }

    public double determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Matrix4x3d invert() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.invert(matrix4x3d);
    }

    public Matrix4x3d invert(Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.identity();
        }
        if ((this.properties & 0x10) != 0) {
            return this.invertOrthonormal(matrix4x3d);
        }
        return this.invertGeneric(matrix4x3d);
    }

    private Matrix4x3d invertGeneric(Matrix4x3d matrix4x3d) {
        double d2 = this.m00 * this.m11;
        double d3 = this.m01 * this.m10;
        double d4 = this.m02 * this.m10;
        double d5 = this.m00 * this.m12;
        double d6 = this.m01 * this.m12;
        double d7 = this.m02 * this.m11;
        double d8 = 1.0 / ((d2 - d3) * this.m22 + (d4 - d5) * this.m21 + (d6 - d7) * this.m20);
        double d9 = this.m10 * this.m22;
        double d10 = this.m10 * this.m21;
        double d11 = this.m11 * this.m22;
        double d12 = this.m11 * this.m20;
        double d13 = this.m12 * this.m21;
        double d14 = this.m12 * this.m20;
        double d15 = this.m20 * this.m02;
        double d16 = this.m20 * this.m01;
        double d17 = this.m21 * this.m02;
        double d18 = this.m21 * this.m00;
        double d19 = this.m22 * this.m01;
        double d20 = this.m22 * this.m00;
        double d21 = (d11 - d13) * d8;
        double d22 = (d17 - d19) * d8;
        double d23 = (d6 - d7) * d8;
        double d24 = (d14 - d9) * d8;
        double d25 = (d20 - d15) * d8;
        double d26 = (d4 - d5) * d8;
        double d27 = (d10 - d12) * d8;
        double d28 = (d16 - d18) * d8;
        double d29 = (d2 - d3) * d8;
        double d30 = (d9 * this.m31 - d10 * this.m32 + d12 * this.m32 - d11 * this.m30 + d13 * this.m30 - d14 * this.m31) * d8;
        double d31 = (d15 * this.m31 - d16 * this.m32 + d18 * this.m32 - d17 * this.m30 + d19 * this.m30 - d20 * this.m31) * d8;
        double d32 = (d7 * this.m30 - d6 * this.m30 + d5 * this.m31 - d4 * this.m31 + d3 * this.m32 - d2 * this.m32) * d8;
        matrix4x3d.m00 = d21;
        matrix4x3d.m01 = d22;
        matrix4x3d.m02 = d23;
        matrix4x3d.m10 = d24;
        matrix4x3d.m11 = d25;
        matrix4x3d.m12 = d26;
        matrix4x3d.m20 = d27;
        matrix4x3d.m21 = d28;
        matrix4x3d.m22 = d29;
        matrix4x3d.m30 = d30;
        matrix4x3d.m31 = d31;
        matrix4x3d.m32 = d32;
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    private Matrix4x3d invertOrthonormal(Matrix4x3d matrix4x3d) {
        double d2 = -(this.m00 * this.m30 + this.m01 * this.m31 + this.m02 * this.m32);
        double d3 = -(this.m10 * this.m30 + this.m11 * this.m31 + this.m12 * this.m32);
        double d4 = -(this.m20 * this.m30 + this.m21 * this.m31 + this.m22 * this.m32);
        double d5 = this.m01;
        double d6 = this.m02;
        double d7 = this.m12;
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = this.m10;
        matrix4x3d.m02 = this.m20;
        matrix4x3d.m10 = d5;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = this.m21;
        matrix4x3d.m20 = d6;
        matrix4x3d.m21 = d7;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.m30 = d2;
        matrix4x3d.m31 = d3;
        matrix4x3d.m32 = d4;
        matrix4x3d.properties = 16;
        return matrix4x3d;
    }

    public Matrix4x3d invertOrtho(Matrix4x3d matrix4x3d) {
        double d2 = 1.0 / this.m00;
        double d3 = 1.0 / this.m11;
        double d4 = 1.0 / this.m22;
        matrix4x3d.set(d2, 0.0, 0.0, 0.0, d3, 0.0, 0.0, 0.0, d4, -this.m30 * d2, -this.m31 * d3, -this.m32 * d4);
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d invertOrtho() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.invertOrtho(matrix4x3d);
    }

    public Matrix4x3d transpose3x3() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.transpose3x3(matrix4x3d);
    }

    public Matrix4x3d transpose3x3(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m10;
        double d4 = this.m20;
        double d5 = this.m01;
        double d6 = this.m11;
        double d7 = this.m21;
        double d8 = this.m02;
        double d9 = this.m12;
        double d10 = this.m22;
        matrix4x3d.m00 = d2;
        matrix4x3d.m01 = d3;
        matrix4x3d.m02 = d4;
        matrix4x3d.m10 = d5;
        matrix4x3d.m11 = d6;
        matrix4x3d.m12 = d7;
        matrix4x3d.m20 = d8;
        matrix4x3d.m21 = d9;
        matrix4x3d.m22 = d10;
        matrix4x3d.properties = this.properties;
        return matrix4x3d;
    }

    public Matrix3d transpose3x3(Matrix3d matrix3d) {
        matrix3d.m00(this.m00);
        matrix3d.m01(this.m10);
        matrix3d.m02(this.m20);
        matrix3d.m10(this.m01);
        matrix3d.m11(this.m11);
        matrix3d.m12(this.m21);
        matrix3d.m20(this.m02);
        matrix3d.m21(this.m12);
        matrix3d.m22(this.m22);
        return matrix3d;
    }

    public Matrix4x3d translation(double d2, double d3, double d4) {
        if ((this.properties & 4) == 0) {
            this.identity();
        }
        this.m30 = d2;
        this.m31 = d3;
        this.m32 = d4;
        this.properties = 24;
        return this;
    }

    public Matrix4x3d translation(Vector3fc vector3fc) {
        return this.translation(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3d translation(Vector3dc vector3dc) {
        return this.translation(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix4x3d setTranslation(double d2, double d3, double d4) {
        this.m30 = d2;
        this.m31 = d3;
        this.m32 = d4;
        this.properties &= 0xFFFFFFFB;
        return this;
    }

    public Matrix4x3d setTranslation(Vector3dc vector3dc) {
        return this.setTranslation(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Vector3d getTranslation(Vector3d vector3d) {
        vector3d.x = this.m30;
        vector3d.y = this.m31;
        vector3d.z = this.m32;
        return vector3d;
    }

    public Vector3d getScale(Vector3d vector3d) {
        vector3d.x = Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        vector3d.y = Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        vector3d.z = Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        return vector3d;
    }

    public String toString() {
        String string = this.toString(Options.NUMBER_FORMAT);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == 'E') {
                n2 = i2;
            } else {
                if (c2 == ' ' && n2 == i2 - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c2) && n2 == i2 - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + " " + Runtime.format(this.m30, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + " " + Runtime.format(this.m31, numberFormat) + "\n" + Runtime.format(this.m02, numberFormat) + " " + Runtime.format(this.m12, numberFormat) + " " + Runtime.format(this.m22, numberFormat) + " " + Runtime.format(this.m32, numberFormat) + "\n";
    }

    public Matrix4x3d get(Matrix4x3d matrix4x3d) {
        return matrix4x3d.set(this);
    }

    public Quaternionf getUnnormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromUnnormalized(this);
    }

    public Quaternionf getNormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromNormalized(this);
    }

    public Quaterniond getUnnormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromUnnormalized(this);
    }

    public Quaterniond getNormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromNormalized(this);
    }

    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        return this.get(doubleBuffer.position(), doubleBuffer);
    }

    public DoubleBuffer get(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer get(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putf(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer getFloats(ByteBuffer byteBuffer) {
        return this.getFloats(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getFloats(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Matrix4x3dc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Matrix4x3dc getTransposedToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.putTransposed(this, l2);
        return this;
    }

    public double[] get(double[] dArray, int n2) {
        dArray[n2] = this.m00;
        dArray[n2 + 1] = this.m01;
        dArray[n2 + 2] = this.m02;
        dArray[n2 + 3] = this.m10;
        dArray[n2 + 4] = this.m11;
        dArray[n2 + 5] = this.m12;
        dArray[n2 + 6] = this.m20;
        dArray[n2 + 7] = this.m21;
        dArray[n2 + 8] = this.m22;
        dArray[n2 + 9] = this.m30;
        dArray[n2 + 10] = this.m31;
        dArray[n2 + 11] = this.m32;
        return dArray;
    }

    public double[] get(double[] dArray) {
        return this.get(dArray, 0);
    }

    public float[] get(float[] fArray, int n2) {
        fArray[n2] = (float)this.m00;
        fArray[n2 + 1] = (float)this.m01;
        fArray[n2 + 2] = (float)this.m02;
        fArray[n2 + 3] = (float)this.m10;
        fArray[n2 + 4] = (float)this.m11;
        fArray[n2 + 5] = (float)this.m12;
        fArray[n2 + 6] = (float)this.m20;
        fArray[n2 + 7] = (float)this.m21;
        fArray[n2 + 8] = (float)this.m22;
        fArray[n2 + 9] = (float)this.m30;
        fArray[n2 + 10] = (float)this.m31;
        fArray[n2 + 11] = (float)this.m32;
        return fArray;
    }

    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    public float[] get4x4(float[] fArray, int n2) {
        MemUtil.INSTANCE.copy4x4((Matrix4x3dc)this, fArray, n2);
        return fArray;
    }

    public float[] get4x4(float[] fArray) {
        return this.get4x4(fArray, 0);
    }

    public double[] get4x4(double[] dArray, int n2) {
        MemUtil.INSTANCE.copy4x4((Matrix4x3dc)this, dArray, n2);
        return dArray;
    }

    public double[] get4x4(double[] dArray) {
        return this.get4x4(dArray, 0);
    }

    public DoubleBuffer get4x4(DoubleBuffer doubleBuffer) {
        return this.get4x4(doubleBuffer.position(), doubleBuffer);
    }

    public DoubleBuffer get4x4(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put4x4(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public ByteBuffer get4x4(ByteBuffer byteBuffer) {
        return this.get4x4(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get4x4(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put4x4(this, n2, byteBuffer);
        return byteBuffer;
    }

    public DoubleBuffer getTransposed(DoubleBuffer doubleBuffer) {
        return this.getTransposed(doubleBuffer.position(), doubleBuffer);
    }

    public DoubleBuffer getTransposed(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public ByteBuffer getTransposed(ByteBuffer byteBuffer) {
        return this.getTransposed(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getTransposed(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer getTransposed(FloatBuffer floatBuffer) {
        return this.getTransposed(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer getTransposed(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putfTransposed(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer getTransposedFloats(ByteBuffer byteBuffer) {
        return this.getTransposedFloats(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getTransposedFloats(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putfTransposed(this, n2, byteBuffer);
        return byteBuffer;
    }

    public double[] getTransposed(double[] dArray, int n2) {
        dArray[n2] = this.m00;
        dArray[n2 + 1] = this.m10;
        dArray[n2 + 2] = this.m20;
        dArray[n2 + 3] = this.m30;
        dArray[n2 + 4] = this.m01;
        dArray[n2 + 5] = this.m11;
        dArray[n2 + 6] = this.m21;
        dArray[n2 + 7] = this.m31;
        dArray[n2 + 8] = this.m02;
        dArray[n2 + 9] = this.m12;
        dArray[n2 + 10] = this.m22;
        dArray[n2 + 11] = this.m32;
        return dArray;
    }

    public double[] getTransposed(double[] dArray) {
        return this.getTransposed(dArray, 0);
    }

    public Matrix4x3d zero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d scaling(double d2) {
        double d3 = d2;
        return this.scaling(d3, d3, d2);
    }

    public Matrix4x3d scaling(double d2, double d3, double d4) {
        if ((this.properties & 4) == 0) {
            this.identity();
        }
        this.m00 = d2;
        this.m11 = d3;
        this.m22 = d4;
        boolean bl = Math.absEqualsOne(d2) && Math.absEqualsOne(d3) && Math.absEqualsOne(d4);
        this.properties = bl ? 16 : 0;
        return this;
    }

    public Matrix4x3d scaling(Vector3dc vector3dc) {
        return this.scaling(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix4x3d rotation(double d2, double d3, double d4, double d5) {
        if (d4 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotationX(d3 * d2);
        }
        if (d3 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotationY(d4 * d2);
        }
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d5)) {
            return this.rotationZ(d5 * d2);
        }
        return this.rotationInternal(d2, d3, d4, d5);
    }

    private Matrix4x3d rotationInternal(double d2, double d3, double d4, double d5) {
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = 1.0 - d7;
        double d9 = d3 * d4;
        double d10 = d3 * d5;
        double d11 = d4 * d5;
        double d12 = d3;
        this.m00 = d7 + d12 * d12 * d8;
        this.m01 = d9 * d8 + d5 * d6;
        this.m02 = d10 * d8 - d4 * d6;
        this.m10 = d9 * d8 - d5 * d6;
        double d13 = d4;
        this.m11 = d7 + d13 * d13 * d8;
        this.m12 = d11 * d8 + d3 * d6;
        this.m20 = d10 * d8 + d4 * d6;
        this.m21 = d11 * d8 - d3 * d6;
        double d14 = d5;
        this.m22 = d7 + d14 * d14 * d8;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationX(double d2) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d4;
        this.m12 = d3;
        this.m20 = 0.0;
        this.m21 = -d3;
        this.m22 = d4;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationY(double d2) {
        double d3;
        double d4 = Math.sin(d2);
        this.m00 = d3 = Math.cosFromSin(d4, d2);
        this.m01 = 0.0;
        this.m02 = -d4;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = d4;
        this.m21 = 0.0;
        this.m22 = d3;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationZ(double d2) {
        double d3;
        double d4 = Math.sin(d2);
        this.m00 = d3 = Math.cosFromSin(d4, d2);
        this.m01 = d4;
        this.m02 = 0.0;
        this.m10 = -d4;
        this.m11 = d3;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationXYZ(double d2, double d3, double d4) {
        double d5 = Math.sin(d2);
        double d6 = Math.cosFromSin(d5, d2);
        double d7 = Math.sin(d3);
        double d8 = Math.cosFromSin(d7, d3);
        double d9 = Math.sin(d4);
        double d10 = Math.cosFromSin(d9, d4);
        double d11 = -d5;
        double d12 = -d7;
        double d13 = -d9;
        double d14 = d11 * d12;
        double d15 = d6 * d12;
        this.m20 = d7;
        this.m21 = d11 * d8;
        this.m22 = d6 * d8;
        this.m00 = d8 * d10;
        this.m01 = d14 * d10 + d6 * d9;
        this.m02 = d15 * d10 + d5 * d9;
        this.m10 = d8 * d13;
        this.m11 = d14 * d13 + d6 * d10;
        this.m12 = d15 * d13 + d5 * d10;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationZYX(double d2, double d3, double d4) {
        double d5 = Math.sin(d4);
        double d6 = Math.cosFromSin(d5, d4);
        double d7 = Math.sin(d3);
        double d8 = Math.cosFromSin(d7, d3);
        double d9 = Math.sin(d2);
        double d10 = Math.cosFromSin(d9, d2);
        double d11 = -d9;
        double d12 = -d7;
        double d13 = -d5;
        double d14 = d10 * d7;
        double d15 = d9 * d7;
        this.m00 = d10 * d8;
        this.m01 = d9 * d8;
        this.m02 = d12;
        this.m10 = d11 * d6 + d14 * d5;
        this.m11 = d10 * d6 + d15 * d5;
        this.m12 = d8 * d5;
        this.m20 = d11 * d13 + d14 * d6;
        this.m21 = d10 * d13 + d15 * d6;
        this.m22 = d8 * d6;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotationYXZ(double d2, double d3, double d4) {
        double d5 = Math.sin(d3);
        double d6 = Math.cosFromSin(d5, d3);
        double d7 = Math.sin(d2);
        double d8 = Math.cosFromSin(d7, d2);
        double d9 = Math.sin(d4);
        double d10 = Math.cosFromSin(d9, d4);
        double d11 = -d7;
        double d12 = -d5;
        double d13 = -d9;
        double d14 = d7 * d5;
        double d15 = d8 * d5;
        this.m20 = d7 * d6;
        this.m21 = d12;
        this.m22 = d8 * d6;
        this.m00 = d8 * d10 + d14 * d9;
        this.m01 = d6 * d9;
        this.m02 = d11 * d10 + d15 * d9;
        this.m10 = d8 * d13 + d14 * d10;
        this.m11 = d6 * d10;
        this.m12 = d11 * d13 + d15 * d10;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d setRotationXYZ(double d2, double d3, double d4) {
        double d5 = Math.sin(d2);
        double d6 = Math.cosFromSin(d5, d2);
        double d7 = Math.sin(d3);
        double d8 = Math.cosFromSin(d7, d3);
        double d9 = Math.sin(d4);
        double d10 = Math.cosFromSin(d9, d4);
        double d11 = -d5;
        double d12 = -d7;
        double d13 = -d9;
        double d14 = d11 * d12;
        double d15 = d6 * d12;
        this.m20 = d7;
        this.m21 = d11 * d8;
        this.m22 = d6 * d8;
        this.m00 = d8 * d10;
        this.m01 = d14 * d10 + d6 * d9;
        this.m02 = d15 * d10 + d5 * d9;
        this.m10 = d8 * d13;
        this.m11 = d14 * d13 + d6 * d10;
        this.m12 = d15 * d13 + d5 * d10;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3d setRotationZYX(double d2, double d3, double d4) {
        double d5 = Math.sin(d4);
        double d6 = Math.cosFromSin(d5, d4);
        double d7 = Math.sin(d3);
        double d8 = Math.cosFromSin(d7, d3);
        double d9 = Math.sin(d2);
        double d10 = Math.cosFromSin(d9, d2);
        double d11 = -d9;
        double d12 = -d7;
        double d13 = -d5;
        double d14 = d10 * d7;
        double d15 = d9 * d7;
        this.m00 = d10 * d8;
        this.m01 = d9 * d8;
        this.m02 = d12;
        this.m10 = d11 * d6 + d14 * d5;
        this.m11 = d10 * d6 + d15 * d5;
        this.m12 = d8 * d5;
        this.m20 = d11 * d13 + d14 * d6;
        this.m21 = d10 * d13 + d15 * d6;
        this.m22 = d8 * d6;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3d setRotationYXZ(double d2, double d3, double d4) {
        double d5 = Math.sin(d3);
        double d6 = Math.cosFromSin(d5, d3);
        double d7 = Math.sin(d2);
        double d8 = Math.cosFromSin(d7, d2);
        double d9 = Math.sin(d4);
        double d10 = Math.cosFromSin(d9, d4);
        double d11 = -d7;
        double d12 = -d5;
        double d13 = -d9;
        double d14 = d7 * d5;
        double d15 = d8 * d5;
        this.m20 = d7 * d6;
        this.m21 = d12;
        this.m22 = d8 * d6;
        this.m00 = d8 * d10 + d14 * d9;
        this.m01 = d6 * d9;
        this.m02 = d11 * d10 + d15 * d9;
        this.m10 = d8 * d13 + d14 * d10;
        this.m11 = d6 * d10;
        this.m12 = d11 * d13 + d15 * d10;
        this.properties &= 0xFFFFFFF3;
        return this;
    }

    public Matrix4x3d rotation(double d2, Vector3dc vector3dc) {
        return this.rotation(d2, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix4x3d rotation(double d2, Vector3fc vector3fc) {
        return this.rotation(d2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Vector4d transform(Vector4d vector4d) {
        return vector4d.mul(this);
    }

    public Vector4d transform(Vector4dc vector4dc, Vector4d vector4d) {
        return vector4dc.mul(this, vector4d);
    }

    public Vector3d transformPosition(Vector3d vector3d) {
        vector3d.set(this.m00 * vector3d.x + this.m10 * vector3d.y + this.m20 * vector3d.z + this.m30, this.m01 * vector3d.x + this.m11 * vector3d.y + this.m21 * vector3d.z + this.m31, this.m02 * vector3d.x + this.m12 * vector3d.y + this.m22 * vector3d.z + this.m32);
        return vector3d;
    }

    public Vector3d transformPosition(Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.set(this.m00 * vector3dc.x() + this.m10 * vector3dc.y() + this.m20 * vector3dc.z() + this.m30, this.m01 * vector3dc.x() + this.m11 * vector3dc.y() + this.m21 * vector3dc.z() + this.m31, this.m02 * vector3dc.x() + this.m12 * vector3dc.y() + this.m22 * vector3dc.z() + this.m32);
        return vector3d;
    }

    public Vector3d transformDirection(Vector3d vector3d) {
        vector3d.set(this.m00 * vector3d.x + this.m10 * vector3d.y + this.m20 * vector3d.z, this.m01 * vector3d.x + this.m11 * vector3d.y + this.m21 * vector3d.z, this.m02 * vector3d.x + this.m12 * vector3d.y + this.m22 * vector3d.z);
        return vector3d;
    }

    public Vector3d transformDirection(Vector3dc vector3dc, Vector3d vector3d) {
        vector3d.set(this.m00 * vector3dc.x() + this.m10 * vector3dc.y() + this.m20 * vector3dc.z(), this.m01 * vector3dc.x() + this.m11 * vector3dc.y() + this.m21 * vector3dc.z(), this.m02 * vector3dc.x() + this.m12 * vector3dc.y() + this.m22 * vector3dc.z());
        return vector3d;
    }

    public Matrix4x3d set3x3(Matrix3dc matrix3dc) {
        this.m00 = matrix3dc.m00();
        this.m01 = matrix3dc.m01();
        this.m02 = matrix3dc.m02();
        this.m10 = matrix3dc.m10();
        this.m11 = matrix3dc.m11();
        this.m12 = matrix3dc.m12();
        this.m20 = matrix3dc.m20();
        this.m21 = matrix3dc.m21();
        this.m22 = matrix3dc.m22();
        this.properties = 0;
        return this;
    }

    public Matrix4x3d set3x3(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m02 = matrix3fc.m02();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
        this.m12 = matrix3fc.m12();
        this.m20 = matrix3fc.m20();
        this.m21 = matrix3fc.m21();
        this.m22 = matrix3fc.m22();
        this.properties = 0;
        return this;
    }

    public Matrix4x3d scale(Vector3dc vector3dc, Matrix4x3d matrix4x3d) {
        return this.scale(vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix4x3d);
    }

    public Matrix4x3d scale(Vector3dc vector3dc) {
        return this.scale(vector3dc.x(), vector3dc.y(), vector3dc.z(), this);
    }

    public Matrix4x3d scale(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.scaling(d2, d3, d4);
        }
        return this.scaleGeneric(d2, d3, d4, matrix4x3d);
    }

    private Matrix4x3d scaleGeneric(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00 * d2;
        matrix4x3d.m01 = this.m01 * d2;
        matrix4x3d.m02 = this.m02 * d2;
        matrix4x3d.m10 = this.m10 * d3;
        matrix4x3d.m11 = this.m11 * d3;
        matrix4x3d.m12 = this.m12 * d3;
        matrix4x3d.m20 = this.m20 * d4;
        matrix4x3d.m21 = this.m21 * d4;
        matrix4x3d.m22 = this.m22 * d4;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d scale(double d2, double d3, double d4) {
        return this.scale(d2, d3, d4, this);
    }

    public Matrix4x3d scale(double d2, Matrix4x3d matrix4x3d) {
        double d3 = d2;
        return this.scale(d3, d3, d2, matrix4x3d);
    }

    public Matrix4x3d scale(double d2) {
        double d3 = d2;
        return this.scale(d3, d3, d2);
    }

    public Matrix4x3d scaleXY(double d2, double d3, Matrix4x3d matrix4x3d) {
        return this.scale(d2, d3, 1.0, matrix4x3d);
    }

    public Matrix4x3d scaleXY(double d2, double d3) {
        return this.scale(d2, d3, 1.0);
    }

    public Matrix4x3d scaleAround(double d2, double d3, double d4, double d5, double d6, double d7, Matrix4x3d matrix4x3d) {
        double d8 = this.m00 * d5 + this.m10 * d6 + this.m20 * d7 + this.m30;
        double d9 = this.m01 * d5 + this.m11 * d6 + this.m21 * d7 + this.m31;
        double d10 = this.m02 * d5 + this.m12 * d6 + this.m22 * d7 + this.m32;
        boolean bl = Math.absEqualsOne(d2) && Math.absEqualsOne(d3) && Math.absEqualsOne(d4);
        return matrix4x3d._m00(this.m00 * d2)._m01(this.m01 * d2)._m02(this.m02 * d2)._m10(this.m10 * d3)._m11(this.m11 * d3)._m12(this.m12 * d3)._m20(this.m20 * d4)._m21(this.m21 * d4)._m22(this.m22 * d4)._m30(-matrix4x3d.m00 * d5 - matrix4x3d.m10 * d6 - matrix4x3d.m20 * d7 + d8)._m31(-matrix4x3d.m01 * d5 - matrix4x3d.m11 * d6 - matrix4x3d.m21 * d7 + d9)._m32(-matrix4x3d.m02 * d5 - matrix4x3d.m12 * d6 - matrix4x3d.m22 * d7 + d10)._properties(this.properties & ~(0xC | (bl ? 0 : 16)));
    }

    public Matrix4x3d scaleAround(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.scaleAround(d2, d3, d4, d5, d6, d7, this);
    }

    public Matrix4x3d scaleAround(double d2, double d3, double d4, double d5) {
        double d6 = d2;
        return this.scaleAround(d6, d6, d2, d3, d4, d5, this);
    }

    public Matrix4x3d scaleAround(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        double d6 = d2;
        return this.scaleAround(d6, d6, d2, d3, d4, d5, matrix4x3d);
    }

    public Matrix4x3d scaleLocal(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.scaling(d2, d3, d4);
        }
        double d5 = d2 * this.m00;
        double d6 = d3 * this.m01;
        double d7 = d4 * this.m02;
        double d8 = d2 * this.m10;
        double d9 = d3 * this.m11;
        double d10 = d4 * this.m12;
        double d11 = d2 * this.m20;
        double d12 = d3 * this.m21;
        double d13 = d4 * this.m22;
        double d14 = d2 * this.m30;
        double d15 = d3 * this.m31;
        double d16 = d4 * this.m32;
        matrix4x3d.m00 = d5;
        matrix4x3d.m01 = d6;
        matrix4x3d.m02 = d7;
        matrix4x3d.m10 = d8;
        matrix4x3d.m11 = d9;
        matrix4x3d.m12 = d10;
        matrix4x3d.m20 = d11;
        matrix4x3d.m21 = d12;
        matrix4x3d.m22 = d13;
        matrix4x3d.m30 = d14;
        matrix4x3d.m31 = d15;
        matrix4x3d.m32 = d16;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d scaleLocal(double d2, double d3, double d4) {
        return this.scaleLocal(d2, d3, d4, this);
    }

    public Matrix4x3d rotate(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotation(d2, d3, d4, d5);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(d2, d3, d4, d5, matrix4x3d);
        }
        return this.rotateGeneric(d2, d3, d4, d5, matrix4x3d);
    }

    private Matrix4x3d rotateGeneric(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        if (d4 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotateX(d3 * d2, matrix4x3d);
        }
        if (d3 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotateY(d4 * d2, matrix4x3d);
        }
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d5)) {
            return this.rotateZ(d5 * d2, matrix4x3d);
        }
        return this.rotateGenericInternal(d2, d3, d4, d5, matrix4x3d);
    }

    private Matrix4x3d rotateGenericInternal(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = 1.0 - d7;
        double d9 = d3;
        double d10 = d9 * d9;
        double d11 = d3 * d4;
        double d12 = d3 * d5;
        double d13 = d4;
        double d14 = d13 * d13;
        double d15 = d4 * d5;
        double d16 = d5;
        double d17 = d16 * d16;
        double d18 = d10 * d8 + d7;
        double d19 = d11 * d8 + d5 * d6;
        double d20 = d12 * d8 - d4 * d6;
        double d21 = d11 * d8 - d5 * d6;
        double d22 = d14 * d8 + d7;
        double d23 = d15 * d8 + d3 * d6;
        double d24 = d12 * d8 + d4 * d6;
        double d25 = d15 * d8 - d3 * d6;
        double d26 = d17 * d8 + d7;
        double d27 = this.m00 * d18 + this.m10 * d19 + this.m20 * d20;
        double d28 = this.m01 * d18 + this.m11 * d19 + this.m21 * d20;
        double d29 = this.m02 * d18 + this.m12 * d19 + this.m22 * d20;
        double d30 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        double d31 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        double d32 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        matrix4x3d.m20 = this.m00 * d24 + this.m10 * d25 + this.m20 * d26;
        matrix4x3d.m21 = this.m01 * d24 + this.m11 * d25 + this.m21 * d26;
        matrix4x3d.m22 = this.m02 * d24 + this.m12 * d25 + this.m22 * d26;
        matrix4x3d.m00 = d27;
        matrix4x3d.m01 = d28;
        matrix4x3d.m02 = d29;
        matrix4x3d.m10 = d30;
        matrix4x3d.m11 = d31;
        matrix4x3d.m12 = d32;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotate(double d2, double d3, double d4, double d5) {
        return this.rotate(d2, d3, d4, d5, this);
    }

    public Matrix4x3d rotateTranslation(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        double d6 = this.m30;
        double d7 = this.m31;
        double d8 = this.m32;
        if (d4 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d3)) {
            return matrix4x3d.rotationX(d3 * d2).setTranslation(d6, d7, d8);
        }
        if (d3 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d4)) {
            return matrix4x3d.rotationY(d4 * d2).setTranslation(d6, d7, d8);
        }
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d5)) {
            return matrix4x3d.rotationZ(d5 * d2).setTranslation(d6, d7, d8);
        }
        return this.rotateTranslationInternal(d2, d3, d4, d5, matrix4x3d);
    }

    private Matrix4x3d rotateTranslationInternal(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = 1.0 - d7;
        double d9 = d3;
        double d10 = d9 * d9;
        double d11 = d3 * d4;
        double d12 = d3 * d5;
        double d13 = d4;
        double d14 = d13 * d13;
        double d15 = d4 * d5;
        double d16 = d5;
        double d17 = d16 * d16;
        double d18 = d10 * d8 + d7;
        double d19 = d11 * d8 + d5 * d6;
        double d20 = d12 * d8 - d4 * d6;
        double d21 = d11 * d8 - d5 * d6;
        double d22 = d14 * d8 + d7;
        double d23 = d15 * d8 + d3 * d6;
        double d24 = d12 * d8 + d4 * d6;
        double d25 = d15 * d8 - d3 * d6;
        double d26 = d17 * d8 + d7;
        matrix4x3d.m20 = d24;
        matrix4x3d.m21 = d25;
        matrix4x3d.m22 = d26;
        matrix4x3d.m00 = d18;
        matrix4x3d.m01 = d19;
        matrix4x3d.m02 = d20;
        matrix4x3d.m10 = d21;
        matrix4x3d.m11 = d22;
        matrix4x3d.m12 = d23;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateAround(Quaterniondc quaterniondc, double d2, double d3, double d4) {
        return this.rotateAround(quaterniondc, d2, d3, d4, this);
    }

    private Matrix4x3d rotateAroundAffine(Quaterniondc quaterniondc, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        double d5 = quaterniondc.w() * quaterniondc.w();
        double d6 = quaterniondc.x() * quaterniondc.x();
        double d7 = quaterniondc.y() * quaterniondc.y();
        double d8 = quaterniondc.z() * quaterniondc.z();
        double d9 = quaterniondc.z() * quaterniondc.w();
        double d10 = d9 + d9;
        double d11 = quaterniondc.x() * quaterniondc.y();
        double d12 = d11 + d11;
        double d13 = quaterniondc.x() * quaterniondc.z();
        double d14 = d13 + d13;
        double d15 = quaterniondc.y() * quaterniondc.w();
        double d16 = d15 + d15;
        double d17 = quaterniondc.y() * quaterniondc.z();
        double d18 = d17 + d17;
        double d19 = quaterniondc.x() * quaterniondc.w();
        double d20 = d19 + d19;
        double d21 = d5 + d6 - d8 - d7;
        double d22 = d12 + d10;
        double d23 = d14 - d16;
        double d24 = d12 - d10;
        double d25 = d7 - d8 + d5 - d6;
        double d26 = d18 + d20;
        double d27 = d16 + d14;
        double d28 = d18 - d20;
        double d29 = d8 - d7 - d6 + d5;
        double d30 = this.m00 * d2 + this.m10 * d3 + this.m20 * d4 + this.m30;
        double d31 = this.m01 * d2 + this.m11 * d3 + this.m21 * d4 + this.m31;
        double d32 = this.m02 * d2 + this.m12 * d3 + this.m22 * d4 + this.m32;
        double d33 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        double d34 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        double d35 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        double d36 = this.m00 * d24 + this.m10 * d25 + this.m20 * d26;
        double d37 = this.m01 * d24 + this.m11 * d25 + this.m21 * d26;
        double d38 = this.m02 * d24 + this.m12 * d25 + this.m22 * d26;
        matrix4x3d._m20(this.m00 * d27 + this.m10 * d28 + this.m20 * d29)._m21(this.m01 * d27 + this.m11 * d28 + this.m21 * d29)._m22(this.m02 * d27 + this.m12 * d28 + this.m22 * d29)._m00(d33)._m01(d34)._m02(d35)._m10(d36)._m11(d37)._m12(d38)._m30(-d33 * d2 - d36 * d3 - this.m20 * d4 + d30)._m31(-d34 * d2 - d37 * d3 - this.m21 * d4 + d31)._m32(-d35 * d2 - d38 * d3 - this.m22 * d4 + d32)._properties(this.properties & 0xFFFFFFF3);
        return matrix4x3d;
    }

    public Matrix4x3d rotateAround(Quaterniondc quaterniondc, double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return this.rotationAround(quaterniondc, d2, d3, d4);
        }
        return this.rotateAroundAffine(quaterniondc, d2, d3, d4, matrix4x3d);
    }

    public Matrix4x3d rotationAround(Quaterniondc quaterniondc, double d2, double d3, double d4) {
        double d5 = quaterniondc.w() * quaterniondc.w();
        double d6 = quaterniondc.x() * quaterniondc.x();
        double d7 = quaterniondc.y() * quaterniondc.y();
        double d8 = quaterniondc.z() * quaterniondc.z();
        double d9 = quaterniondc.z() * quaterniondc.w();
        double d10 = d9 + d9;
        double d11 = quaterniondc.x() * quaterniondc.y();
        double d12 = d11 + d11;
        double d13 = quaterniondc.x() * quaterniondc.z();
        double d14 = d13 + d13;
        double d15 = quaterniondc.y() * quaterniondc.w();
        double d16 = d15 + d15;
        double d17 = quaterniondc.y() * quaterniondc.z();
        double d18 = d17 + d17;
        double d19 = quaterniondc.x() * quaterniondc.w();
        double d20 = d19 + d19;
        this._m20(d16 + d14);
        this._m21(d18 - d20);
        this._m22(d8 - d7 - d6 + d5);
        this._m00(d5 + d6 - d8 - d7);
        this._m01(d12 + d10);
        this._m02(d14 - d16);
        this._m10(d12 - d10);
        this._m11(d7 - d8 + d5 - d6);
        this._m12(d18 + d20);
        Matrix4x3d matrix4x3d = this;
        matrix4x3d._m30(-matrix4x3d.m00 * d2 - this.m10 * d3 - this.m20 * d4 + d2);
        Matrix4x3d matrix4x3d2 = this;
        matrix4x3d2._m31(-matrix4x3d2.m01 * d2 - this.m11 * d3 - this.m21 * d4 + d3);
        Matrix4x3d matrix4x3d3 = this;
        matrix4x3d3._m32(-matrix4x3d3.m02 * d2 - this.m12 * d3 - this.m22 * d4 + d4);
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotateLocal(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        if (d4 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotateLocalX(d3 * d2, matrix4x3d);
        }
        if (d3 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotateLocalY(d4 * d2, matrix4x3d);
        }
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d5)) {
            return this.rotateLocalZ(d5 * d2, matrix4x3d);
        }
        return this.rotateLocalInternal(d2, d3, d4, d5, matrix4x3d);
    }

    private Matrix4x3d rotateLocalInternal(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = 1.0 - d7;
        double d9 = d3;
        double d10 = d9 * d9;
        double d11 = d3 * d4;
        double d12 = d3 * d5;
        double d13 = d4;
        double d14 = d13 * d13;
        double d15 = d4 * d5;
        double d16 = d5;
        double d17 = d16 * d16;
        double d18 = d10 * d8 + d7;
        double d19 = d11 * d8 + d5 * d6;
        double d20 = d12 * d8 - d4 * d6;
        double d21 = d11 * d8 - d5 * d6;
        double d22 = d14 * d8 + d7;
        double d23 = d15 * d8 + d3 * d6;
        double d24 = d12 * d8 + d4 * d6;
        double d25 = d15 * d8 - d3 * d6;
        double d26 = d17 * d8 + d7;
        double d27 = d18 * this.m00 + d21 * this.m01 + d24 * this.m02;
        double d28 = d19 * this.m00 + d22 * this.m01 + d25 * this.m02;
        double d29 = d20 * this.m00 + d23 * this.m01 + d26 * this.m02;
        double d30 = d18 * this.m10 + d21 * this.m11 + d24 * this.m12;
        double d31 = d19 * this.m10 + d22 * this.m11 + d25 * this.m12;
        double d32 = d20 * this.m10 + d23 * this.m11 + d26 * this.m12;
        double d33 = d18 * this.m20 + d21 * this.m21 + d24 * this.m22;
        double d34 = d19 * this.m20 + d22 * this.m21 + d25 * this.m22;
        double d35 = d20 * this.m20 + d23 * this.m21 + d26 * this.m22;
        double d36 = d18 * this.m30 + d21 * this.m31 + d24 * this.m32;
        double d37 = d19 * this.m30 + d22 * this.m31 + d25 * this.m32;
        double d38 = d20 * this.m30 + d23 * this.m31 + d26 * this.m32;
        matrix4x3d.m00 = d27;
        matrix4x3d.m01 = d28;
        matrix4x3d.m02 = d29;
        matrix4x3d.m10 = d30;
        matrix4x3d.m11 = d31;
        matrix4x3d.m12 = d32;
        matrix4x3d.m20 = d33;
        matrix4x3d.m21 = d34;
        matrix4x3d.m22 = d35;
        matrix4x3d.m30 = d36;
        matrix4x3d.m31 = d37;
        matrix4x3d.m32 = d38;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocal(double d2, double d3, double d4, double d5) {
        return this.rotateLocal(d2, d3, d4, d5, this);
    }

    public Matrix4x3d rotateLocalX(double d2, Matrix4x3d matrix4x3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = d4 * this.m01 - d3 * this.m02;
        double d6 = d3 * this.m01 + d4 * this.m02;
        double d7 = d4 * this.m11 - d3 * this.m12;
        double d8 = d3 * this.m11 + d4 * this.m12;
        double d9 = d4 * this.m21 - d3 * this.m22;
        double d10 = d3 * this.m21 + d4 * this.m22;
        double d11 = d4 * this.m31 - d3 * this.m32;
        double d12 = d3 * this.m31 + d4 * this.m32;
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = d5;
        matrix4x3d.m02 = d6;
        matrix4x3d.m10 = this.m10;
        matrix4x3d.m11 = d7;
        matrix4x3d.m12 = d8;
        matrix4x3d.m20 = this.m20;
        matrix4x3d.m21 = d9;
        matrix4x3d.m22 = d10;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = d11;
        matrix4x3d.m32 = d12;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocalX(double d2) {
        return this.rotateLocalX(d2, this);
    }

    public Matrix4x3d rotateLocalY(double d2, Matrix4x3d matrix4x3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = d4 * this.m00 + d3 * this.m02;
        double d6 = -d3 * this.m00 + d4 * this.m02;
        double d7 = d4 * this.m10 + d3 * this.m12;
        double d8 = -d3 * this.m10 + d4 * this.m12;
        double d9 = d4 * this.m20 + d3 * this.m22;
        double d10 = -d3 * this.m20 + d4 * this.m22;
        double d11 = d4 * this.m30 + d3 * this.m32;
        double d12 = -d3 * this.m30 + d4 * this.m32;
        matrix4x3d.m00 = d5;
        matrix4x3d.m01 = this.m01;
        matrix4x3d.m02 = d6;
        matrix4x3d.m10 = d7;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = d8;
        matrix4x3d.m20 = d9;
        matrix4x3d.m21 = this.m21;
        matrix4x3d.m22 = d10;
        matrix4x3d.m30 = d11;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = d12;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocalY(double d2) {
        return this.rotateLocalY(d2, this);
    }

    public Matrix4x3d rotateLocalZ(double d2, Matrix4x3d matrix4x3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = d4 * this.m00 - d3 * this.m01;
        double d6 = d3 * this.m00 + d4 * this.m01;
        double d7 = d4 * this.m10 - d3 * this.m11;
        double d8 = d3 * this.m10 + d4 * this.m11;
        double d9 = d4 * this.m20 - d3 * this.m21;
        double d10 = d3 * this.m20 + d4 * this.m21;
        double d11 = d4 * this.m30 - d3 * this.m31;
        double d12 = d3 * this.m30 + d4 * this.m31;
        matrix4x3d.m00 = d5;
        matrix4x3d.m01 = d6;
        matrix4x3d.m02 = this.m02;
        matrix4x3d.m10 = d7;
        matrix4x3d.m11 = d8;
        matrix4x3d.m12 = this.m12;
        matrix4x3d.m20 = d9;
        matrix4x3d.m21 = d10;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.m30 = d11;
        matrix4x3d.m31 = d12;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocalZ(double d2) {
        return this.rotateLocalZ(d2, this);
    }

    public Matrix4x3d translate(Vector3dc vector3dc) {
        return this.translate(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix4x3d translate(Vector3dc vector3dc, Matrix4x3d matrix4x3d) {
        return this.translate(vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix4x3d);
    }

    public Matrix4x3d translate(Vector3fc vector3fc) {
        return this.translate(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3d translate(Vector3fc vector3fc, Matrix4x3d matrix4x3d) {
        return this.translate(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3d);
    }

    public Matrix4x3d translate(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.translation(d2, d3, d4);
        }
        return this.translateGeneric(d2, d3, d4, matrix4x3d);
    }

    private Matrix4x3d translateGeneric(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = this.m01;
        matrix4x3d.m02 = this.m02;
        matrix4x3d.m10 = this.m10;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = this.m12;
        matrix4x3d.m20 = this.m20;
        matrix4x3d.m21 = this.m21;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.m30 = this.m00 * d2 + this.m10 * d3 + this.m20 * d4 + this.m30;
        matrix4x3d.m31 = this.m01 * d2 + this.m11 * d3 + this.m21 * d4 + this.m31;
        matrix4x3d.m32 = this.m02 * d2 + this.m12 * d3 + this.m22 * d4 + this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFFB;
        return matrix4x3d;
    }

    public Matrix4x3d translate(double d2, double d3, double d4) {
        if ((this.properties & 4) != 0) {
            return this.translation(d2, d3, d4);
        }
        Matrix4x3d matrix4x3d = this;
        matrix4x3d.m30 = matrix4x3d.m00 * d2 + matrix4x3d.m10 * d3 + matrix4x3d.m20 * d4 + matrix4x3d.m30;
        matrix4x3d.m31 = matrix4x3d.m01 * d2 + matrix4x3d.m11 * d3 + matrix4x3d.m21 * d4 + matrix4x3d.m31;
        matrix4x3d.m32 = matrix4x3d.m02 * d2 + matrix4x3d.m12 * d3 + matrix4x3d.m22 * d4 + matrix4x3d.m32;
        matrix4x3d.properties &= 0xFFFFFFFB;
        return this;
    }

    public Matrix4x3d translateLocal(Vector3fc vector3fc) {
        return this.translateLocal(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3d translateLocal(Vector3fc vector3fc, Matrix4x3d matrix4x3d) {
        return this.translateLocal(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3d);
    }

    public Matrix4x3d translateLocal(Vector3dc vector3dc) {
        return this.translateLocal(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix4x3d translateLocal(Vector3dc vector3dc, Matrix4x3d matrix4x3d) {
        return this.translateLocal(vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix4x3d);
    }

    public Matrix4x3d translateLocal(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = this.m01;
        matrix4x3d.m02 = this.m02;
        matrix4x3d.m10 = this.m10;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = this.m12;
        matrix4x3d.m20 = this.m20;
        matrix4x3d.m21 = this.m21;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.m30 = this.m30 + d2;
        matrix4x3d.m31 = this.m31 + d3;
        matrix4x3d.m32 = this.m32 + d4;
        matrix4x3d.properties = this.properties & 0xFFFFFFFB;
        return matrix4x3d;
    }

    public Matrix4x3d translateLocal(double d2, double d3, double d4) {
        return this.translateLocal(d2, d3, d4, this);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.m00);
        objectOutput.writeDouble(this.m01);
        objectOutput.writeDouble(this.m02);
        objectOutput.writeDouble(this.m10);
        objectOutput.writeDouble(this.m11);
        objectOutput.writeDouble(this.m12);
        objectOutput.writeDouble(this.m20);
        objectOutput.writeDouble(this.m21);
        objectOutput.writeDouble(this.m22);
        objectOutput.writeDouble(this.m30);
        objectOutput.writeDouble(this.m31);
        objectOutput.writeDouble(this.m32);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.m00 = objectInput.readDouble();
        this.m01 = objectInput.readDouble();
        this.m02 = objectInput.readDouble();
        this.m10 = objectInput.readDouble();
        this.m11 = objectInput.readDouble();
        this.m12 = objectInput.readDouble();
        this.m20 = objectInput.readDouble();
        this.m21 = objectInput.readDouble();
        this.m22 = objectInput.readDouble();
        this.m30 = objectInput.readDouble();
        this.m31 = objectInput.readDouble();
        this.m32 = objectInput.readDouble();
        this.determineProperties();
    }

    public Matrix4x3d rotateX(double d2, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationX(d2);
        }
        if ((this.properties & 8) != 0) {
            double d3 = this.m30;
            double d4 = this.m31;
            double d5 = this.m32;
            return matrix4x3d.rotationX(d2).setTranslation(d3, d4, d5);
        }
        return this.rotateXInternal(d2, matrix4x3d);
    }

    private Matrix4x3d rotateXInternal(double d2, Matrix4x3d matrix4x3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = -d3;
        double d6 = this.m10 * d4 + this.m20 * d3;
        double d7 = this.m11 * d4 + this.m21 * d3;
        double d8 = this.m12 * d4 + this.m22 * d3;
        matrix4x3d.m20 = this.m10 * d5 + this.m20 * d4;
        matrix4x3d.m21 = this.m11 * d5 + this.m21 * d4;
        matrix4x3d.m22 = this.m12 * d5 + this.m22 * d4;
        matrix4x3d.m10 = d6;
        matrix4x3d.m11 = d7;
        matrix4x3d.m12 = d8;
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = this.m01;
        matrix4x3d.m02 = this.m02;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateX(double d2) {
        return this.rotateX(d2, this);
    }

    public Matrix4x3d rotateY(double d2, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationY(d2);
        }
        if ((this.properties & 8) != 0) {
            double d3 = this.m30;
            double d4 = this.m31;
            double d5 = this.m32;
            return matrix4x3d.rotationY(d2).setTranslation(d3, d4, d5);
        }
        return this.rotateYInternal(d2, matrix4x3d);
    }

    private Matrix4x3d rotateYInternal(double d2, Matrix4x3d matrix4x3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = -d3;
        double d6 = this.m00 * d4 + this.m20 * d5;
        double d7 = this.m01 * d4 + this.m21 * d5;
        double d8 = this.m02 * d4 + this.m22 * d5;
        matrix4x3d.m20 = this.m00 * d3 + this.m20 * d4;
        matrix4x3d.m21 = this.m01 * d3 + this.m21 * d4;
        matrix4x3d.m22 = this.m02 * d3 + this.m22 * d4;
        matrix4x3d.m00 = d6;
        matrix4x3d.m01 = d7;
        matrix4x3d.m02 = d8;
        matrix4x3d.m10 = this.m10;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = this.m12;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateY(double d2) {
        return this.rotateY(d2, this);
    }

    public Matrix4x3d rotateZ(double d2, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationZ(d2);
        }
        if ((this.properties & 8) != 0) {
            double d3 = this.m30;
            double d4 = this.m31;
            double d5 = this.m32;
            return matrix4x3d.rotationZ(d2).setTranslation(d3, d4, d5);
        }
        return this.rotateZInternal(d2, matrix4x3d);
    }

    private Matrix4x3d rotateZInternal(double d2, Matrix4x3d matrix4x3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = -d3;
        double d6 = this.m00 * d4 + this.m10 * d3;
        double d7 = this.m01 * d4 + this.m11 * d3;
        double d8 = this.m02 * d4 + this.m12 * d3;
        matrix4x3d.m10 = this.m00 * d5 + this.m10 * d4;
        matrix4x3d.m11 = this.m01 * d5 + this.m11 * d4;
        matrix4x3d.m12 = this.m02 * d5 + this.m12 * d4;
        matrix4x3d.m00 = d6;
        matrix4x3d.m01 = d7;
        matrix4x3d.m02 = d8;
        matrix4x3d.m20 = this.m20;
        matrix4x3d.m21 = this.m21;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateZ(double d2) {
        return this.rotateZ(d2, this);
    }

    public Matrix4x3d rotateXYZ(Vector3d vector3d) {
        return this.rotateXYZ(vector3d.x, vector3d.y, vector3d.z);
    }

    public Matrix4x3d rotateXYZ(double d2, double d3, double d4) {
        return this.rotateXYZ(d2, d3, d4, this);
    }

    public Matrix4x3d rotateXYZ(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationXYZ(d2, d3, d4);
        }
        if ((this.properties & 8) != 0) {
            double d5 = this.m30;
            double d6 = this.m31;
            double d7 = this.m32;
            return matrix4x3d.rotationXYZ(d2, d3, d4).setTranslation(d5, d6, d7);
        }
        return this.rotateXYZInternal(d2, d3, d4, matrix4x3d);
    }

    private Matrix4x3d rotateXYZInternal(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        double d5 = Math.sin(d2);
        double d6 = Math.cosFromSin(d5, d2);
        double d7 = Math.sin(d3);
        double d8 = Math.cosFromSin(d7, d3);
        double d9 = Math.sin(d4);
        double d10 = Math.cosFromSin(d9, d4);
        double d11 = -d5;
        double d12 = -d7;
        double d13 = -d9;
        double d14 = this.m10 * d6 + this.m20 * d5;
        double d15 = this.m11 * d6 + this.m21 * d5;
        double d16 = this.m12 * d6 + this.m22 * d5;
        double d17 = this.m10 * d11 + this.m20 * d6;
        double d18 = this.m11 * d11 + this.m21 * d6;
        double d19 = this.m12 * d11 + this.m22 * d6;
        double d20 = this.m00 * d8 + d17 * d12;
        double d21 = this.m01 * d8 + d18 * d12;
        double d22 = this.m02 * d8 + d19 * d12;
        matrix4x3d.m20 = this.m00 * d7 + d17 * d8;
        matrix4x3d.m21 = this.m01 * d7 + d18 * d8;
        matrix4x3d.m22 = this.m02 * d7 + d19 * d8;
        matrix4x3d.m00 = d20 * d10 + d14 * d9;
        matrix4x3d.m01 = d21 * d10 + d15 * d9;
        matrix4x3d.m02 = d22 * d10 + d16 * d9;
        matrix4x3d.m10 = d20 * d13 + d14 * d10;
        matrix4x3d.m11 = d21 * d13 + d15 * d10;
        matrix4x3d.m12 = d22 * d13 + d16 * d10;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateZYX(Vector3d vector3d) {
        return this.rotateZYX(vector3d.z, vector3d.y, vector3d.x);
    }

    public Matrix4x3d rotateZYX(double d2, double d3, double d4) {
        return this.rotateZYX(d2, d3, d4, this);
    }

    public Matrix4x3d rotateZYX(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationZYX(d2, d3, d4);
        }
        if ((this.properties & 8) != 0) {
            double d5 = this.m30;
            double d6 = this.m31;
            double d7 = this.m32;
            return matrix4x3d.rotationZYX(d2, d3, d4).setTranslation(d5, d6, d7);
        }
        return this.rotateZYXInternal(d2, d3, d4, matrix4x3d);
    }

    private Matrix4x3d rotateZYXInternal(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        double d5 = Math.sin(d4);
        double d6 = Math.cosFromSin(d5, d4);
        double d7 = Math.sin(d3);
        double d8 = Math.cosFromSin(d7, d3);
        double d9 = Math.sin(d2);
        double d10 = Math.cosFromSin(d9, d2);
        double d11 = -d9;
        double d12 = -d7;
        double d13 = -d5;
        double d14 = this.m00 * d10 + this.m10 * d9;
        double d15 = this.m01 * d10 + this.m11 * d9;
        double d16 = this.m02 * d10 + this.m12 * d9;
        double d17 = this.m00 * d11 + this.m10 * d10;
        double d18 = this.m01 * d11 + this.m11 * d10;
        double d19 = this.m02 * d11 + this.m12 * d10;
        double d20 = d14 * d7 + this.m20 * d8;
        double d21 = d15 * d7 + this.m21 * d8;
        double d22 = d16 * d7 + this.m22 * d8;
        matrix4x3d.m00 = d14 * d8 + this.m20 * d12;
        matrix4x3d.m01 = d15 * d8 + this.m21 * d12;
        matrix4x3d.m02 = d16 * d8 + this.m22 * d12;
        matrix4x3d.m10 = d17 * d6 + d20 * d5;
        matrix4x3d.m11 = d18 * d6 + d21 * d5;
        matrix4x3d.m12 = d19 * d6 + d22 * d5;
        matrix4x3d.m20 = d17 * d13 + d20 * d6;
        matrix4x3d.m21 = d18 * d13 + d21 * d6;
        matrix4x3d.m22 = d19 * d13 + d22 * d6;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateYXZ(Vector3d vector3d) {
        return this.rotateYXZ(vector3d.y, vector3d.x, vector3d.z);
    }

    public Matrix4x3d rotateYXZ(double d2, double d3, double d4) {
        return this.rotateYXZ(d2, d3, d4, this);
    }

    public Matrix4x3d rotateYXZ(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotationYXZ(d2, d3, d4);
        }
        if ((this.properties & 8) != 0) {
            double d5 = this.m30;
            double d6 = this.m31;
            double d7 = this.m32;
            return matrix4x3d.rotationYXZ(d2, d3, d4).setTranslation(d5, d6, d7);
        }
        return this.rotateYXZInternal(d2, d3, d4, matrix4x3d);
    }

    private Matrix4x3d rotateYXZInternal(double d2, double d3, double d4, Matrix4x3d matrix4x3d) {
        double d5 = Math.sin(d3);
        double d6 = Math.cosFromSin(d5, d3);
        double d7 = Math.sin(d2);
        double d8 = Math.cosFromSin(d7, d2);
        double d9 = Math.sin(d4);
        double d10 = Math.cosFromSin(d9, d4);
        double d11 = -d7;
        double d12 = -d5;
        double d13 = -d9;
        double d14 = this.m00 * d7 + this.m20 * d8;
        double d15 = this.m01 * d7 + this.m21 * d8;
        double d16 = this.m02 * d7 + this.m22 * d8;
        double d17 = this.m00 * d8 + this.m20 * d11;
        double d18 = this.m01 * d8 + this.m21 * d11;
        double d19 = this.m02 * d8 + this.m22 * d11;
        double d20 = this.m10 * d6 + d14 * d5;
        double d21 = this.m11 * d6 + d15 * d5;
        double d22 = this.m12 * d6 + d16 * d5;
        matrix4x3d.m20 = this.m10 * d12 + d14 * d6;
        matrix4x3d.m21 = this.m11 * d12 + d15 * d6;
        matrix4x3d.m22 = this.m12 * d12 + d16 * d6;
        matrix4x3d.m00 = d17 * d10 + d20 * d9;
        matrix4x3d.m01 = d18 * d10 + d21 * d9;
        matrix4x3d.m02 = d19 * d10 + d22 * d9;
        matrix4x3d.m10 = d17 * d13 + d20 * d10;
        matrix4x3d.m11 = d18 * d13 + d21 * d10;
        matrix4x3d.m12 = d19 * d13 + d22 * d10;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotation(AxisAngle4f axisAngle4f) {
        return this.rotation(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix4x3d rotation(AxisAngle4d axisAngle4d) {
        return this.rotation(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Matrix4x3d rotation(Quaterniondc quaterniondc) {
        double d2 = quaterniondc.w() * quaterniondc.w();
        double d3 = quaterniondc.x() * quaterniondc.x();
        double d4 = quaterniondc.y() * quaterniondc.y();
        double d5 = quaterniondc.z() * quaterniondc.z();
        double d6 = quaterniondc.z() * quaterniondc.w();
        double d7 = d6 + d6;
        double d8 = quaterniondc.x() * quaterniondc.y();
        double d9 = d8 + d8;
        double d10 = quaterniondc.x() * quaterniondc.z();
        double d11 = d10 + d10;
        double d12 = quaterniondc.y() * quaterniondc.w();
        double d13 = d12 + d12;
        double d14 = quaterniondc.y() * quaterniondc.z();
        double d15 = d14 + d14;
        double d16 = quaterniondc.x() * quaterniondc.w();
        double d17 = d16 + d16;
        this._m00(d2 + d3 - d5 - d4);
        this._m01(d9 + d7);
        this._m02(d11 - d13);
        this._m10(d9 - d7);
        this._m11(d4 - d5 + d2 - d3);
        this._m12(d15 + d17);
        this._m20(d13 + d11);
        this._m21(d15 - d17);
        this._m22(d5 - d4 - d3 + d2);
        this._m30(0.0);
        this._m31(0.0);
        this._m32(0.0);
        this.properties = 16;
        return this;
    }

    public Matrix4x3d rotation(Quaternionfc quaternionfc) {
        double d2 = quaternionfc.w() * quaternionfc.w();
        double d3 = quaternionfc.x() * quaternionfc.x();
        double d4 = quaternionfc.y() * quaternionfc.y();
        double d5 = quaternionfc.z() * quaternionfc.z();
        double d6 = quaternionfc.z() * quaternionfc.w();
        double d7 = d6 + d6;
        double d8 = quaternionfc.x() * quaternionfc.y();
        double d9 = d8 + d8;
        double d10 = quaternionfc.x() * quaternionfc.z();
        double d11 = d10 + d10;
        double d12 = quaternionfc.y() * quaternionfc.w();
        double d13 = d12 + d12;
        double d14 = quaternionfc.y() * quaternionfc.z();
        double d15 = d14 + d14;
        double d16 = quaternionfc.x() * quaternionfc.w();
        double d17 = d16 + d16;
        this._m00(d2 + d3 - d5 - d4);
        this._m01(d9 + d7);
        this._m02(d11 - d13);
        this._m10(d9 - d7);
        this._m11(d4 - d5 + d2 - d3);
        this._m12(d15 + d17);
        this._m20(d13 + d11);
        this._m21(d15 - d17);
        this._m22(d5 - d4 - d3 + d2);
        this._m30(0.0);
        this._m31(0.0);
        this._m32(0.0);
        this.properties = 16;
        return this;
    }

    public Matrix4x3d translationRotateScale(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        double d12 = d5;
        double d13 = d12 + d12;
        double d14 = d6;
        double d15 = d14 + d14;
        double d16 = d7;
        double d17 = d16 + d16;
        double d18 = d13 * d5;
        double d19 = d15 * d6;
        double d20 = d17 * d7;
        double d21 = d13 * d6;
        double d22 = d13 * d7;
        double d23 = d13 * d8;
        double d24 = d15 * d7;
        double d25 = d15 * d8;
        double d26 = d17 * d8;
        this.m00 = d9 - (d19 + d20) * d9;
        this.m01 = (d21 + d26) * d9;
        this.m02 = (d22 - d25) * d9;
        this.m10 = (d21 - d26) * d10;
        this.m11 = d10 - (d20 + d18) * d10;
        this.m12 = (d24 + d23) * d10;
        this.m20 = (d22 + d25) * d11;
        this.m21 = (d24 - d23) * d11;
        this.m22 = d11 - (d19 + d18) * d11;
        this.m30 = d2;
        this.m31 = d3;
        this.m32 = d4;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d translationRotateScale(Vector3fc vector3fc, Quaternionfc quaternionfc, Vector3fc vector3fc2) {
        return this.translationRotateScale(vector3fc.x(), vector3fc.y(), vector3fc.z(), quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix4x3d translationRotateScale(Vector3dc vector3dc, Quaterniondc quaterniondc, Vector3dc vector3dc2) {
        return this.translationRotateScale(vector3dc.x(), vector3dc.y(), vector3dc.z(), quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix4x3d translationRotateScaleMul(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, Matrix4x3dc matrix4x3dc) {
        double d12 = d5;
        double d13 = d12 + d12;
        double d14 = d6;
        double d15 = d14 + d14;
        double d16 = d7;
        double d17 = d16 + d16;
        double d18 = d13 * d5;
        double d19 = d15 * d6;
        double d20 = d17 * d7;
        double d21 = d13 * d6;
        double d22 = d13 * d7;
        double d23 = d13 * d8;
        double d24 = d15 * d7;
        double d25 = d15 * d8;
        double d26 = d17 * d8;
        double d27 = d9 - (d19 + d20) * d9;
        double d28 = (d21 + d26) * d9;
        double d29 = (d22 - d25) * d9;
        double d30 = (d21 - d26) * d10;
        double d31 = d10 - (d20 + d18) * d10;
        double d32 = (d24 + d23) * d10;
        double d33 = (d22 + d25) * d11;
        double d34 = (d24 - d23) * d11;
        double d35 = d11 - (d19 + d18) * d11;
        double d36 = d27 * matrix4x3dc.m00() + d30 * matrix4x3dc.m01() + d33 * matrix4x3dc.m02();
        double d37 = d28 * matrix4x3dc.m00() + d31 * matrix4x3dc.m01() + d34 * matrix4x3dc.m02();
        this.m02 = d29 * matrix4x3dc.m00() + d32 * matrix4x3dc.m01() + d35 * matrix4x3dc.m02();
        this.m00 = d36;
        this.m01 = d37;
        double d38 = d27 * matrix4x3dc.m10() + d30 * matrix4x3dc.m11() + d33 * matrix4x3dc.m12();
        double d39 = d28 * matrix4x3dc.m10() + d31 * matrix4x3dc.m11() + d34 * matrix4x3dc.m12();
        this.m12 = d29 * matrix4x3dc.m10() + d32 * matrix4x3dc.m11() + d35 * matrix4x3dc.m12();
        this.m10 = d38;
        this.m11 = d39;
        double d40 = d27 * matrix4x3dc.m20() + d30 * matrix4x3dc.m21() + d33 * matrix4x3dc.m22();
        double d41 = d28 * matrix4x3dc.m20() + d31 * matrix4x3dc.m21() + d34 * matrix4x3dc.m22();
        this.m22 = d29 * matrix4x3dc.m20() + d32 * matrix4x3dc.m21() + d35 * matrix4x3dc.m22();
        this.m20 = d40;
        this.m21 = d41;
        double d42 = d27 * matrix4x3dc.m30() + d30 * matrix4x3dc.m31() + d33 * matrix4x3dc.m32() + d2;
        double d43 = d28 * matrix4x3dc.m30() + d31 * matrix4x3dc.m31() + d34 * matrix4x3dc.m32() + d3;
        this.m32 = d29 * matrix4x3dc.m30() + d32 * matrix4x3dc.m31() + d35 * matrix4x3dc.m32() + d4;
        this.m30 = d42;
        this.m31 = d43;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d translationRotateScaleMul(Vector3dc vector3dc, Quaterniondc quaterniondc, Vector3dc vector3dc2, Matrix4x3dc matrix4x3dc) {
        return this.translationRotateScaleMul(vector3dc.x(), vector3dc.y(), vector3dc.z(), quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix4x3dc);
    }

    public Matrix4x3d translationRotate(double d2, double d3, double d4, Quaterniondc quaterniondc) {
        double d5 = quaterniondc.x() + quaterniondc.x();
        double d6 = quaterniondc.y() + quaterniondc.y();
        double d7 = quaterniondc.z() + quaterniondc.z();
        double d8 = d5 * quaterniondc.x();
        double d9 = d6 * quaterniondc.y();
        double d10 = d7 * quaterniondc.z();
        double d11 = d5 * quaterniondc.y();
        double d12 = d5 * quaterniondc.z();
        double d13 = d5 * quaterniondc.w();
        double d14 = d6 * quaterniondc.z();
        double d15 = d6 * quaterniondc.w();
        double d16 = d7 * quaterniondc.w();
        this.m00 = 1.0 - (d9 + d10);
        this.m01 = d11 + d16;
        this.m02 = d12 - d15;
        this.m10 = d11 - d16;
        this.m11 = 1.0 - (d10 + d8);
        this.m12 = d14 + d13;
        this.m20 = d12 + d15;
        this.m21 = d14 - d13;
        this.m22 = 1.0 - (d9 + d8);
        this.m30 = d2;
        this.m31 = d3;
        this.m32 = d4;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d translationRotate(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d8;
        double d10 = d9 * d9;
        double d11 = d5;
        double d12 = d11 * d11;
        double d13 = d6;
        double d14 = d13 * d13;
        double d15 = d7;
        double d16 = d15 * d15;
        double d17 = d7 * d8;
        double d18 = d5 * d6;
        double d19 = d5 * d7;
        double d20 = d6 * d8;
        double d21 = d6 * d7;
        double d22 = d5 * d8;
        this.m00 = d10 + d12 - d16 - d14;
        this.m01 = d18 + d17 + d17 + d18;
        this.m02 = d19 - d20 + d19 - d20;
        this.m10 = -d17 + d18 - d17 + d18;
        this.m11 = d14 - d16 + d10 - d12;
        double d23 = d21;
        this.m12 = d23 + d23 + d22 + d22;
        this.m20 = d20 + d19 + d19 + d20;
        double d24 = d21;
        this.m21 = d24 + d24 - d22 - d22;
        this.m22 = d16 - d14 - d12 + d10;
        this.m30 = d2;
        this.m31 = d3;
        this.m32 = d4;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d translationRotate(Vector3dc vector3dc, Quaterniondc quaterniondc) {
        return this.translationRotate(vector3dc.x(), vector3dc.y(), vector3dc.z(), quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w());
    }

    public Matrix4x3d translationRotateMul(double d2, double d3, double d4, Quaternionfc quaternionfc, Matrix4x3dc matrix4x3dc) {
        return this.translationRotateMul(d2, d3, d4, quaternionfc.x(), quaternionfc.y(), quaternionfc.z(), quaternionfc.w(), matrix4x3dc);
    }

    public Matrix4x3d translationRotateMul(double d2, double d3, double d4, double d5, double d6, double d7, double d8, Matrix4x3dc matrix4x3dc) {
        double d9 = d8;
        double d10 = d9 * d9;
        double d11 = d5;
        double d12 = d11 * d11;
        double d13 = d6;
        double d14 = d13 * d13;
        double d15 = d7;
        double d16 = d15 * d15;
        double d17 = d7 * d8;
        double d18 = d5 * d6;
        double d19 = d5 * d7;
        double d20 = d6 * d8;
        double d21 = d6 * d7;
        double d22 = d5 * d8;
        double d23 = d10 + d12 - d16 - d14;
        double d24 = d18 + d17 + d17 + d18;
        double d25 = d19 - d20 + d19 - d20;
        double d26 = -d17 + d18 - d17 + d18;
        double d27 = d14 - d16 + d10 - d12;
        double d28 = d21;
        double d29 = d28 + d28 + d22 + d22;
        double d30 = d20 + d19 + d19 + d20;
        double d31 = d21;
        double d32 = d31 + d31 - d22 - d22;
        double d33 = d16 - d14 - d12 + d10;
        this.m00 = d23 * matrix4x3dc.m00() + d26 * matrix4x3dc.m01() + d30 * matrix4x3dc.m02();
        this.m01 = d24 * matrix4x3dc.m00() + d27 * matrix4x3dc.m01() + d32 * matrix4x3dc.m02();
        this.m02 = d25 * matrix4x3dc.m00() + d29 * matrix4x3dc.m01() + d33 * matrix4x3dc.m02();
        this.m10 = d23 * matrix4x3dc.m10() + d26 * matrix4x3dc.m11() + d30 * matrix4x3dc.m12();
        this.m11 = d24 * matrix4x3dc.m10() + d27 * matrix4x3dc.m11() + d32 * matrix4x3dc.m12();
        this.m12 = d25 * matrix4x3dc.m10() + d29 * matrix4x3dc.m11() + d33 * matrix4x3dc.m12();
        this.m20 = d23 * matrix4x3dc.m20() + d26 * matrix4x3dc.m21() + d30 * matrix4x3dc.m22();
        this.m21 = d24 * matrix4x3dc.m20() + d27 * matrix4x3dc.m21() + d32 * matrix4x3dc.m22();
        this.m22 = d25 * matrix4x3dc.m20() + d29 * matrix4x3dc.m21() + d33 * matrix4x3dc.m22();
        this.m30 = d23 * matrix4x3dc.m30() + d26 * matrix4x3dc.m31() + d30 * matrix4x3dc.m32() + d2;
        this.m31 = d24 * matrix4x3dc.m30() + d27 * matrix4x3dc.m31() + d32 * matrix4x3dc.m32() + d3;
        this.m32 = d25 * matrix4x3dc.m30() + d29 * matrix4x3dc.m31() + d33 * matrix4x3dc.m32() + d4;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d translationRotateInvert(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = -d5;
        double d10 = -d6;
        double d11 = -d7;
        double d12 = d9;
        double d13 = d12 + d12;
        double d14 = d10;
        double d15 = d14 + d14;
        double d16 = d11;
        double d17 = d16 + d16;
        double d18 = d13 * d9;
        double d19 = d15 * d10;
        double d20 = d17 * d11;
        double d21 = d13 * d10;
        double d22 = d13 * d11;
        double d23 = d13 * d8;
        double d24 = d15 * d11;
        double d25 = d15 * d8;
        double d26 = d17 * d8;
        return this._m00(1.0 - d19 - d20)._m01(d21 + d26)._m02(d22 - d25)._m10(d21 - d26)._m11(1.0 - d20 - d18)._m12(d24 + d23)._m20(d22 + d25)._m21(d24 - d23)._m22(1.0 - d19 - d18)._m30(-this.m00 * d2 - this.m10 * d3 - this.m20 * d4)._m31(-this.m01 * d2 - this.m11 * d3 - this.m21 * d4)._m32(-this.m02 * d2 - this.m12 * d3 - this.m22 * d4)._properties(16);
    }

    public Matrix4x3d translationRotateInvert(Vector3dc vector3dc, Quaterniondc quaterniondc) {
        return this.translationRotateInvert(vector3dc.x(), vector3dc.y(), vector3dc.z(), quaterniondc.x(), quaterniondc.y(), quaterniondc.z(), quaterniondc.w());
    }

    public Matrix4x3d rotate(Quaterniondc quaterniondc, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotation(quaterniondc);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(quaterniondc, matrix4x3d);
        }
        return this.rotateGeneric(quaterniondc, matrix4x3d);
    }

    private Matrix4x3d rotateGeneric(Quaterniondc quaterniondc, Matrix4x3d matrix4x3d) {
        double d2 = quaterniondc.w() * quaterniondc.w();
        double d3 = quaterniondc.x() * quaterniondc.x();
        double d4 = quaterniondc.y() * quaterniondc.y();
        double d5 = quaterniondc.z() * quaterniondc.z();
        double d6 = quaterniondc.z() * quaterniondc.w();
        double d7 = d6 + d6;
        double d8 = quaterniondc.x() * quaterniondc.y();
        double d9 = d8 + d8;
        double d10 = quaterniondc.x() * quaterniondc.z();
        double d11 = d10 + d10;
        double d12 = quaterniondc.y() * quaterniondc.w();
        double d13 = d12 + d12;
        double d14 = quaterniondc.y() * quaterniondc.z();
        double d15 = d14 + d14;
        double d16 = quaterniondc.x() * quaterniondc.w();
        double d17 = d16 + d16;
        double d18 = d2 + d3 - d5 - d4;
        double d19 = d9 + d7;
        double d20 = d11 - d13;
        double d21 = d9 - d7;
        double d22 = d4 - d5 + d2 - d3;
        double d23 = d15 + d17;
        double d24 = d13 + d11;
        double d25 = d15 - d17;
        double d26 = d5 - d4 - d3 + d2;
        double d27 = this.m00 * d18 + this.m10 * d19 + this.m20 * d20;
        double d28 = this.m01 * d18 + this.m11 * d19 + this.m21 * d20;
        double d29 = this.m02 * d18 + this.m12 * d19 + this.m22 * d20;
        double d30 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        double d31 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        double d32 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        matrix4x3d.m20 = this.m00 * d24 + this.m10 * d25 + this.m20 * d26;
        matrix4x3d.m21 = this.m01 * d24 + this.m11 * d25 + this.m21 * d26;
        matrix4x3d.m22 = this.m02 * d24 + this.m12 * d25 + this.m22 * d26;
        matrix4x3d.m00 = d27;
        matrix4x3d.m01 = d28;
        matrix4x3d.m02 = d29;
        matrix4x3d.m10 = d30;
        matrix4x3d.m11 = d31;
        matrix4x3d.m12 = d32;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotate(Quaternionfc quaternionfc, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.rotation(quaternionfc);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(quaternionfc, matrix4x3d);
        }
        return this.rotateGeneric(quaternionfc, matrix4x3d);
    }

    private Matrix4x3d rotateGeneric(Quaternionfc quaternionfc, Matrix4x3d matrix4x3d) {
        double d2 = quaternionfc.w() * quaternionfc.w();
        double d3 = quaternionfc.x() * quaternionfc.x();
        double d4 = quaternionfc.y() * quaternionfc.y();
        double d5 = quaternionfc.z() * quaternionfc.z();
        double d6 = quaternionfc.z() * quaternionfc.w();
        double d7 = quaternionfc.x() * quaternionfc.y();
        double d8 = quaternionfc.x() * quaternionfc.z();
        double d9 = quaternionfc.y() * quaternionfc.w();
        double d10 = quaternionfc.y() * quaternionfc.z();
        double d11 = quaternionfc.x() * quaternionfc.w();
        double d12 = d2 + d3 - d5 - d4;
        double d13 = d7 + d6 + d6 + d7;
        double d14 = d8 - d9 + d8 - d9;
        double d15 = -d6 + d7 - d6 + d7;
        double d16 = d4 - d5 + d2 - d3;
        double d17 = d10;
        double d18 = d17 + d17 + d11 + d11;
        double d19 = d9 + d8 + d8 + d9;
        double d20 = d10;
        double d21 = d20 + d20 - d11 - d11;
        double d22 = d5 - d4 - d3 + d2;
        double d23 = this.m00 * d12 + this.m10 * d13 + this.m20 * d14;
        double d24 = this.m01 * d12 + this.m11 * d13 + this.m21 * d14;
        double d25 = this.m02 * d12 + this.m12 * d13 + this.m22 * d14;
        double d26 = this.m00 * d15 + this.m10 * d16 + this.m20 * d18;
        double d27 = this.m01 * d15 + this.m11 * d16 + this.m21 * d18;
        double d28 = this.m02 * d15 + this.m12 * d16 + this.m22 * d18;
        matrix4x3d.m20 = this.m00 * d19 + this.m10 * d21 + this.m20 * d22;
        matrix4x3d.m21 = this.m01 * d19 + this.m11 * d21 + this.m21 * d22;
        matrix4x3d.m22 = this.m02 * d19 + this.m12 * d21 + this.m22 * d22;
        matrix4x3d.m00 = d23;
        matrix4x3d.m01 = d24;
        matrix4x3d.m02 = d25;
        matrix4x3d.m10 = d26;
        matrix4x3d.m11 = d27;
        matrix4x3d.m12 = d28;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotate(Quaterniondc quaterniondc) {
        return this.rotate(quaterniondc, this);
    }

    public Matrix4x3d rotate(Quaternionfc quaternionfc) {
        return this.rotate(quaternionfc, this);
    }

    public Matrix4x3d rotateTranslation(Quaterniondc quaterniondc, Matrix4x3d matrix4x3d) {
        double d2 = quaterniondc.w() * quaterniondc.w();
        double d3 = quaterniondc.x() * quaterniondc.x();
        double d4 = quaterniondc.y() * quaterniondc.y();
        double d5 = quaterniondc.z() * quaterniondc.z();
        double d6 = quaterniondc.z() * quaterniondc.w();
        double d7 = d6 + d6;
        double d8 = quaterniondc.x() * quaterniondc.y();
        double d9 = d8 + d8;
        double d10 = quaterniondc.x() * quaterniondc.z();
        double d11 = d10 + d10;
        double d12 = quaterniondc.y() * quaterniondc.w();
        double d13 = d12 + d12;
        double d14 = quaterniondc.y() * quaterniondc.z();
        double d15 = d14 + d14;
        double d16 = quaterniondc.x() * quaterniondc.w();
        double d17 = d16 + d16;
        double d18 = d2 + d3 - d5 - d4;
        double d19 = d9 + d7;
        double d20 = d11 - d13;
        double d21 = d9 - d7;
        double d22 = d4 - d5 + d2 - d3;
        double d23 = d15 + d17;
        double d24 = d13 + d11;
        double d25 = d15 - d17;
        double d26 = d5 - d4 - d3 + d2;
        matrix4x3d.m20 = d24;
        matrix4x3d.m21 = d25;
        matrix4x3d.m22 = d26;
        matrix4x3d.m00 = d18;
        matrix4x3d.m01 = d19;
        matrix4x3d.m02 = d20;
        matrix4x3d.m10 = d21;
        matrix4x3d.m11 = d22;
        matrix4x3d.m12 = d23;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateTranslation(Quaternionfc quaternionfc, Matrix4x3d matrix4x3d) {
        double d2 = quaternionfc.w() * quaternionfc.w();
        double d3 = quaternionfc.x() * quaternionfc.x();
        double d4 = quaternionfc.y() * quaternionfc.y();
        double d5 = quaternionfc.z() * quaternionfc.z();
        double d6 = quaternionfc.z() * quaternionfc.w();
        double d7 = quaternionfc.x() * quaternionfc.y();
        double d8 = quaternionfc.x() * quaternionfc.z();
        double d9 = quaternionfc.y() * quaternionfc.w();
        double d10 = quaternionfc.y() * quaternionfc.z();
        double d11 = quaternionfc.x() * quaternionfc.w();
        double d12 = d2 + d3 - d5 - d4;
        double d13 = d7 + d6 + d6 + d7;
        double d14 = d8 - d9 + d8 - d9;
        double d15 = -d6 + d7 - d6 + d7;
        double d16 = d4 - d5 + d2 - d3;
        double d17 = d10;
        double d18 = d17 + d17 + d11 + d11;
        double d19 = d9 + d8 + d8 + d9;
        double d20 = d10;
        double d21 = d20 + d20 - d11 - d11;
        double d22 = d5 - d4 - d3 + d2;
        matrix4x3d.m20 = d19;
        matrix4x3d.m21 = d21;
        matrix4x3d.m22 = d22;
        matrix4x3d.m00 = d12;
        matrix4x3d.m01 = d13;
        matrix4x3d.m02 = d14;
        matrix4x3d.m10 = d15;
        matrix4x3d.m11 = d16;
        matrix4x3d.m12 = d18;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocal(Quaterniondc quaterniondc, Matrix4x3d matrix4x3d) {
        double d2 = quaterniondc.w() * quaterniondc.w();
        double d3 = quaterniondc.x() * quaterniondc.x();
        double d4 = quaterniondc.y() * quaterniondc.y();
        double d5 = quaterniondc.z() * quaterniondc.z();
        double d6 = quaterniondc.z() * quaterniondc.w();
        double d7 = d6 + d6;
        double d8 = quaterniondc.x() * quaterniondc.y();
        double d9 = d8 + d8;
        double d10 = quaterniondc.x() * quaterniondc.z();
        double d11 = d10 + d10;
        double d12 = quaterniondc.y() * quaterniondc.w();
        double d13 = d12 + d12;
        double d14 = quaterniondc.y() * quaterniondc.z();
        double d15 = d14 + d14;
        double d16 = quaterniondc.x() * quaterniondc.w();
        double d17 = d16 + d16;
        double d18 = d2 + d3 - d5 - d4;
        double d19 = d9 + d7;
        double d20 = d11 - d13;
        double d21 = d9 - d7;
        double d22 = d4 - d5 + d2 - d3;
        double d23 = d15 + d17;
        double d24 = d13 + d11;
        double d25 = d15 - d17;
        double d26 = d5 - d4 - d3 + d2;
        double d27 = d18 * this.m00 + d21 * this.m01 + d24 * this.m02;
        double d28 = d19 * this.m00 + d22 * this.m01 + d25 * this.m02;
        double d29 = d20 * this.m00 + d23 * this.m01 + d26 * this.m02;
        double d30 = d18 * this.m10 + d21 * this.m11 + d24 * this.m12;
        double d31 = d19 * this.m10 + d22 * this.m11 + d25 * this.m12;
        double d32 = d20 * this.m10 + d23 * this.m11 + d26 * this.m12;
        double d33 = d18 * this.m20 + d21 * this.m21 + d24 * this.m22;
        double d34 = d19 * this.m20 + d22 * this.m21 + d25 * this.m22;
        double d35 = d20 * this.m20 + d23 * this.m21 + d26 * this.m22;
        double d36 = d18 * this.m30 + d21 * this.m31 + d24 * this.m32;
        double d37 = d19 * this.m30 + d22 * this.m31 + d25 * this.m32;
        double d38 = d20 * this.m30 + d23 * this.m31 + d26 * this.m32;
        matrix4x3d.m00 = d27;
        matrix4x3d.m01 = d28;
        matrix4x3d.m02 = d29;
        matrix4x3d.m10 = d30;
        matrix4x3d.m11 = d31;
        matrix4x3d.m12 = d32;
        matrix4x3d.m20 = d33;
        matrix4x3d.m21 = d34;
        matrix4x3d.m22 = d35;
        matrix4x3d.m30 = d36;
        matrix4x3d.m31 = d37;
        matrix4x3d.m32 = d38;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocal(Quaterniondc quaterniondc) {
        return this.rotateLocal(quaterniondc, this);
    }

    public Matrix4x3d rotateLocal(Quaternionfc quaternionfc, Matrix4x3d matrix4x3d) {
        double d2 = quaternionfc.w() * quaternionfc.w();
        double d3 = quaternionfc.x() * quaternionfc.x();
        double d4 = quaternionfc.y() * quaternionfc.y();
        double d5 = quaternionfc.z() * quaternionfc.z();
        double d6 = quaternionfc.z() * quaternionfc.w();
        double d7 = d6 + d6;
        double d8 = quaternionfc.x() * quaternionfc.y();
        double d9 = d8 + d8;
        double d10 = quaternionfc.x() * quaternionfc.z();
        double d11 = d10 + d10;
        double d12 = quaternionfc.y() * quaternionfc.w();
        double d13 = d12 + d12;
        double d14 = quaternionfc.y() * quaternionfc.z();
        double d15 = d14 + d14;
        double d16 = quaternionfc.x() * quaternionfc.w();
        double d17 = d16 + d16;
        double d18 = d2 + d3 - d5 - d4;
        double d19 = d9 + d7;
        double d20 = d11 - d13;
        double d21 = d9 - d7;
        double d22 = d4 - d5 + d2 - d3;
        double d23 = d15 + d17;
        double d24 = d13 + d11;
        double d25 = d15 - d17;
        double d26 = d5 - d4 - d3 + d2;
        double d27 = d18 * this.m00 + d21 * this.m01 + d24 * this.m02;
        double d28 = d19 * this.m00 + d22 * this.m01 + d25 * this.m02;
        double d29 = d20 * this.m00 + d23 * this.m01 + d26 * this.m02;
        double d30 = d18 * this.m10 + d21 * this.m11 + d24 * this.m12;
        double d31 = d19 * this.m10 + d22 * this.m11 + d25 * this.m12;
        double d32 = d20 * this.m10 + d23 * this.m11 + d26 * this.m12;
        double d33 = d18 * this.m20 + d21 * this.m21 + d24 * this.m22;
        double d34 = d19 * this.m20 + d22 * this.m21 + d25 * this.m22;
        double d35 = d20 * this.m20 + d23 * this.m21 + d26 * this.m22;
        double d36 = d18 * this.m30 + d21 * this.m31 + d24 * this.m32;
        double d37 = d19 * this.m30 + d22 * this.m31 + d25 * this.m32;
        double d38 = d20 * this.m30 + d23 * this.m31 + d26 * this.m32;
        matrix4x3d.m00 = d27;
        matrix4x3d.m01 = d28;
        matrix4x3d.m02 = d29;
        matrix4x3d.m10 = d30;
        matrix4x3d.m11 = d31;
        matrix4x3d.m12 = d32;
        matrix4x3d.m20 = d33;
        matrix4x3d.m21 = d34;
        matrix4x3d.m22 = d35;
        matrix4x3d.m30 = d36;
        matrix4x3d.m31 = d37;
        matrix4x3d.m32 = d38;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotateLocal(Quaternionfc quaternionfc) {
        return this.rotateLocal(quaternionfc, this);
    }

    public Matrix4x3d rotate(AxisAngle4f axisAngle4f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix4x3d rotate(AxisAngle4f axisAngle4f, Matrix4x3d matrix4x3d) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, matrix4x3d);
    }

    public Matrix4x3d rotate(AxisAngle4d axisAngle4d) {
        return this.rotate(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Matrix4x3d rotate(AxisAngle4d axisAngle4d, Matrix4x3d matrix4x3d) {
        return this.rotate(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z, matrix4x3d);
    }

    public Matrix4x3d rotate(double d2, Vector3dc vector3dc) {
        return this.rotate(d2, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix4x3d rotate(double d2, Vector3dc vector3dc, Matrix4x3d matrix4x3d) {
        return this.rotate(d2, vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix4x3d);
    }

    public Matrix4x3d rotate(double d2, Vector3fc vector3fc) {
        return this.rotate(d2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix4x3d rotate(double d2, Vector3fc vector3fc, Matrix4x3d matrix4x3d) {
        return this.rotate(d2, vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix4x3d);
    }

    public Vector4d getRow(int n2, Vector4d vector4d) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                vector4d.x = this.m00;
                vector4d.y = this.m10;
                vector4d.z = this.m20;
                vector4d.w = this.m30;
                break;
            }
            case 1: {
                vector4d.x = this.m01;
                vector4d.y = this.m11;
                vector4d.z = this.m21;
                vector4d.w = this.m31;
                break;
            }
            case 2: {
                vector4d.x = this.m02;
                vector4d.y = this.m12;
                vector4d.z = this.m22;
                vector4d.w = this.m32;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector4d;
    }

    public Matrix4x3d setRow(int n2, Vector4dc vector4dc) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                this.m00 = vector4dc.x();
                this.m10 = vector4dc.y();
                this.m20 = vector4dc.z();
                this.m30 = vector4dc.w();
                break;
            }
            case 1: {
                this.m01 = vector4dc.x();
                this.m11 = vector4dc.y();
                this.m21 = vector4dc.z();
                this.m31 = vector4dc.w();
                break;
            }
            case 2: {
                this.m02 = vector4dc.x();
                this.m12 = vector4dc.y();
                this.m22 = vector4dc.z();
                this.m32 = vector4dc.w();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        this.properties = 0;
        return this;
    }

    public Vector3d getColumn(int n2, Vector3d vector3d) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                vector3d.x = this.m00;
                vector3d.y = this.m01;
                vector3d.z = this.m02;
                break;
            }
            case 1: {
                vector3d.x = this.m10;
                vector3d.y = this.m11;
                vector3d.z = this.m12;
                break;
            }
            case 2: {
                vector3d.x = this.m20;
                vector3d.y = this.m21;
                vector3d.z = this.m22;
                break;
            }
            case 3: {
                vector3d.x = this.m30;
                vector3d.y = this.m31;
                vector3d.z = this.m32;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector3d;
    }

    public Matrix4x3d setColumn(int n2, Vector3dc vector3dc) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                this.m00 = vector3dc.x();
                this.m01 = vector3dc.y();
                this.m02 = vector3dc.z();
                break;
            }
            case 1: {
                this.m10 = vector3dc.x();
                this.m11 = vector3dc.y();
                this.m12 = vector3dc.z();
                break;
            }
            case 2: {
                this.m20 = vector3dc.x();
                this.m21 = vector3dc.y();
                this.m22 = vector3dc.z();
                break;
            }
            case 3: {
                this.m30 = vector3dc.x();
                this.m31 = vector3dc.y();
                this.m32 = vector3dc.z();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        this.properties = 0;
        return this;
    }

    public Matrix4x3d normal() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.normal(matrix4x3d);
    }

    public Matrix4x3d normal(Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.identity();
        }
        if ((this.properties & 0x10) != 0) {
            return this.normalOrthonormal(matrix4x3d);
        }
        return this.normalGeneric(matrix4x3d);
    }

    private Matrix4x3d normalOrthonormal(Matrix4x3d matrix4x3d) {
        if (matrix4x3d != this) {
            matrix4x3d.set(this);
        }
        return matrix4x3d._properties(16);
    }

    private Matrix4x3d normalGeneric(Matrix4x3d matrix4x3d) {
        double d2 = this.m00 * this.m11;
        double d3 = this.m01 * this.m10;
        double d4 = this.m02 * this.m10;
        double d5 = this.m00 * this.m12;
        double d6 = this.m01 * this.m12;
        double d7 = this.m02 * this.m11;
        double d8 = (d2 - d3) * this.m22 + (d4 - d5) * this.m21 + (d6 - d7) * this.m20;
        double d9 = 1.0 / d8;
        double d10 = (this.m11 * this.m22 - this.m21 * this.m12) * d9;
        double d11 = (this.m20 * this.m12 - this.m10 * this.m22) * d9;
        double d12 = (this.m10 * this.m21 - this.m20 * this.m11) * d9;
        double d13 = (this.m21 * this.m02 - this.m01 * this.m22) * d9;
        double d14 = (this.m00 * this.m22 - this.m20 * this.m02) * d9;
        double d15 = (this.m20 * this.m01 - this.m00 * this.m21) * d9;
        double d16 = (d6 - d7) * d9;
        double d17 = (d4 - d5) * d9;
        double d18 = (d2 - d3) * d9;
        matrix4x3d.m00 = d10;
        matrix4x3d.m01 = d11;
        matrix4x3d.m02 = d12;
        matrix4x3d.m10 = d13;
        matrix4x3d.m11 = d14;
        matrix4x3d.m12 = d15;
        matrix4x3d.m20 = d16;
        matrix4x3d.m21 = d17;
        matrix4x3d.m22 = d18;
        matrix4x3d.m30 = 0.0;
        matrix4x3d.m31 = 0.0;
        matrix4x3d.m32 = 0.0;
        matrix4x3d.properties = this.properties & 0xFFFFFFF7;
        return matrix4x3d;
    }

    public Matrix3d normal(Matrix3d matrix3d) {
        if ((this.properties & 0x10) != 0) {
            return this.normalOrthonormal(matrix3d);
        }
        return this.normalGeneric(matrix3d);
    }

    private Matrix3d normalOrthonormal(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    private Matrix3d normalGeneric(Matrix3d matrix3d) {
        double d2 = this.m00 * this.m11;
        double d3 = this.m01 * this.m10;
        double d4 = this.m02 * this.m10;
        double d5 = this.m00 * this.m12;
        double d6 = this.m01 * this.m12;
        double d7 = this.m02 * this.m11;
        double d8 = (d2 - d3) * this.m22 + (d4 - d5) * this.m21 + (d6 - d7) * this.m20;
        double d9 = 1.0 / d8;
        matrix3d.m00((this.m11 * this.m22 - this.m21 * this.m12) * d9);
        matrix3d.m01((this.m20 * this.m12 - this.m10 * this.m22) * d9);
        matrix3d.m02((this.m10 * this.m21 - this.m20 * this.m11) * d9);
        matrix3d.m10((this.m21 * this.m02 - this.m01 * this.m22) * d9);
        matrix3d.m11((this.m00 * this.m22 - this.m20 * this.m02) * d9);
        matrix3d.m12((this.m20 * this.m01 - this.m00 * this.m21) * d9);
        matrix3d.m20((d6 - d7) * d9);
        matrix3d.m21((d4 - d5) * d9);
        matrix3d.m22((d2 - d3) * d9);
        return matrix3d;
    }

    public Matrix4x3d cofactor3x3() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.cofactor3x3(matrix4x3d);
    }

    public Matrix3d cofactor3x3(Matrix3d matrix3d) {
        matrix3d.m00 = this.m11 * this.m22 - this.m21 * this.m12;
        matrix3d.m01 = this.m20 * this.m12 - this.m10 * this.m22;
        matrix3d.m02 = this.m10 * this.m21 - this.m20 * this.m11;
        matrix3d.m10 = this.m21 * this.m02 - this.m01 * this.m22;
        matrix3d.m11 = this.m00 * this.m22 - this.m20 * this.m02;
        matrix3d.m12 = this.m20 * this.m01 - this.m00 * this.m21;
        matrix3d.m20 = this.m01 * this.m12 - this.m02 * this.m11;
        matrix3d.m21 = this.m02 * this.m10 - this.m00 * this.m12;
        matrix3d.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        return matrix3d;
    }

    public Matrix4x3d cofactor3x3(Matrix4x3d matrix4x3d) {
        double d2 = this.m11 * this.m22 - this.m21 * this.m12;
        double d3 = this.m20 * this.m12 - this.m10 * this.m22;
        double d4 = this.m10 * this.m21 - this.m20 * this.m11;
        double d5 = this.m21 * this.m02 - this.m01 * this.m22;
        double d6 = this.m00 * this.m22 - this.m20 * this.m02;
        double d7 = this.m20 * this.m01 - this.m00 * this.m21;
        double d8 = this.m01 * this.m12 - this.m11 * this.m02;
        double d9 = this.m02 * this.m10 - this.m12 * this.m00;
        double d10 = this.m00 * this.m11 - this.m10 * this.m01;
        matrix4x3d.m00 = d2;
        matrix4x3d.m01 = d3;
        matrix4x3d.m02 = d4;
        matrix4x3d.m10 = d5;
        matrix4x3d.m11 = d6;
        matrix4x3d.m12 = d7;
        matrix4x3d.m20 = d8;
        matrix4x3d.m21 = d9;
        matrix4x3d.m22 = d10;
        matrix4x3d.m30 = 0.0;
        matrix4x3d.m31 = 0.0;
        matrix4x3d.m32 = 0.0;
        matrix4x3d.properties = this.properties & 0xFFFFFFF7;
        return matrix4x3d;
    }

    public Matrix4x3d normalize3x3() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.normalize3x3(matrix4x3d);
    }

    public Matrix4x3d normalize3x3(Matrix4x3d matrix4x3d) {
        double d2 = Math.invsqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        double d3 = Math.invsqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        double d4 = Math.invsqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        matrix4x3d.m00 = this.m00 * d2;
        matrix4x3d.m01 = this.m01 * d2;
        matrix4x3d.m02 = this.m02 * d2;
        matrix4x3d.m10 = this.m10 * d3;
        matrix4x3d.m11 = this.m11 * d3;
        matrix4x3d.m12 = this.m12 * d3;
        matrix4x3d.m20 = this.m20 * d4;
        matrix4x3d.m21 = this.m21 * d4;
        matrix4x3d.m22 = this.m22 * d4;
        return matrix4x3d;
    }

    public Matrix3d normalize3x3(Matrix3d matrix3d) {
        double d2 = Math.invsqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        double d3 = Math.invsqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        double d4 = Math.invsqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        matrix3d.m00(this.m00 * d2);
        matrix3d.m01(this.m01 * d2);
        matrix3d.m02(this.m02 * d2);
        matrix3d.m10(this.m10 * d3);
        matrix3d.m11(this.m11 * d3);
        matrix3d.m12(this.m12 * d3);
        matrix3d.m20(this.m20 * d4);
        matrix3d.m21(this.m21 * d4);
        matrix3d.m22(this.m22 * d4);
        return matrix3d;
    }

    public Matrix4x3d reflect(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.reflection(d2, d3, d4, d5);
        }
        double d6 = d2;
        double d7 = d6 + d6;
        double d8 = d3;
        double d9 = d8 + d8;
        double d10 = d4;
        double d11 = d10 + d10;
        double d12 = d5;
        double d13 = d12 + d12;
        double d14 = 1.0 - d7 * d2;
        double d15 = -d7 * d3;
        double d16 = -d7 * d4;
        double d17 = -d9 * d2;
        double d18 = 1.0 - d9 * d3;
        double d19 = -d9 * d4;
        double d20 = -d11 * d2;
        double d21 = -d11 * d3;
        double d22 = 1.0 - d11 * d4;
        double d23 = -d13 * d2;
        double d24 = -d13 * d3;
        double d25 = -d13 * d4;
        matrix4x3d.m30 = this.m00 * d23 + this.m10 * d24 + this.m20 * d25 + this.m30;
        matrix4x3d.m31 = this.m01 * d23 + this.m11 * d24 + this.m21 * d25 + this.m31;
        matrix4x3d.m32 = this.m02 * d23 + this.m12 * d24 + this.m22 * d25 + this.m32;
        double d26 = this.m00 * d14 + this.m10 * d15 + this.m20 * d16;
        double d27 = this.m01 * d14 + this.m11 * d15 + this.m21 * d16;
        double d28 = this.m02 * d14 + this.m12 * d15 + this.m22 * d16;
        double d29 = this.m00 * d17 + this.m10 * d18 + this.m20 * d19;
        double d30 = this.m01 * d17 + this.m11 * d18 + this.m21 * d19;
        double d31 = this.m02 * d17 + this.m12 * d18 + this.m22 * d19;
        matrix4x3d.m20 = this.m00 * d20 + this.m10 * d21 + this.m20 * d22;
        matrix4x3d.m21 = this.m01 * d20 + this.m11 * d21 + this.m21 * d22;
        matrix4x3d.m22 = this.m02 * d20 + this.m12 * d21 + this.m22 * d22;
        matrix4x3d.m00 = d26;
        matrix4x3d.m01 = d27;
        matrix4x3d.m02 = d28;
        matrix4x3d.m10 = d29;
        matrix4x3d.m11 = d30;
        matrix4x3d.m12 = d31;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d reflect(double d2, double d3, double d4, double d5) {
        return this.reflect(d2, d3, d4, d5, this);
    }

    public Matrix4x3d reflect(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.reflect(d2, d3, d4, d5, d6, d7, this);
    }

    public Matrix4x3d reflect(double d2, double d3, double d4, double d5, double d6, double d7, Matrix4x3d matrix4x3d) {
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d2 * d11;
        double d13 = d3 * d11;
        double d14 = d4 * d11;
        return this.reflect(d12, d13, d14, -d12 * d5 - d13 * d6 - d14 * d7, matrix4x3d);
    }

    public Matrix4x3d reflect(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.reflect(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix4x3d reflect(Quaterniondc quaterniondc, Vector3dc vector3dc) {
        return this.reflect(quaterniondc, vector3dc, this);
    }

    public Matrix4x3d reflect(Quaterniondc quaterniondc, Vector3dc vector3dc, Matrix4x3d matrix4x3d) {
        double d2 = quaterniondc.x() + quaterniondc.x();
        double d3 = quaterniondc.y() + quaterniondc.y();
        double d4 = quaterniondc.z() + quaterniondc.z();
        double d5 = quaterniondc.x() * d4 + quaterniondc.w() * d3;
        double d6 = quaterniondc.y() * d4 - quaterniondc.w() * d2;
        double d7 = 1.0 - (quaterniondc.x() * d2 + quaterniondc.y() * d3);
        return this.reflect(d5, d6, d7, vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix4x3d);
    }

    public Matrix4x3d reflect(Vector3dc vector3dc, Vector3dc vector3dc2, Matrix4x3d matrix4x3d) {
        return this.reflect(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix4x3d);
    }

    public Matrix4x3d reflection(double d2, double d3, double d4, double d5) {
        double d6 = d2;
        double d7 = d6 + d6;
        double d8 = d3;
        double d9 = d8 + d8;
        double d10 = d4;
        double d11 = d10 + d10;
        double d12 = d5;
        double d13 = d12 + d12;
        this.m00 = 1.0 - d7 * d2;
        this.m01 = -d7 * d3;
        this.m02 = -d7 * d4;
        this.m10 = -d9 * d2;
        this.m11 = 1.0 - d9 * d3;
        this.m12 = -d9 * d4;
        this.m20 = -d11 * d2;
        this.m21 = -d11 * d3;
        this.m22 = 1.0 - d11 * d4;
        this.m30 = -d13 * d2;
        this.m31 = -d13 * d3;
        this.m32 = -d13 * d4;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d reflection(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d2 * d11;
        double d13 = d3 * d11;
        double d14 = d4 * d11;
        return this.reflection(d12, d13, d14, -d12 * d5 - d13 * d6 - d14 * d7);
    }

    public Matrix4x3d reflection(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.reflection(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix4x3d reflection(Quaterniondc quaterniondc, Vector3dc vector3dc) {
        double d2 = quaterniondc.x() + quaterniondc.x();
        double d3 = quaterniondc.y() + quaterniondc.y();
        double d4 = quaterniondc.z() + quaterniondc.z();
        double d5 = quaterniondc.x() * d4 + quaterniondc.w() * d3;
        double d6 = quaterniondc.y() * d4 - quaterniondc.w() * d2;
        double d7 = 1.0 - (quaterniondc.x() * d2 + quaterniondc.y() * d3);
        return this.reflection(d5, d6, d7, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix4x3d ortho(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, Matrix4x3d matrix4x3d) {
        double d8 = 2.0 / (d3 - d2);
        double d9 = 2.0 / (d5 - d4);
        double d10 = (bl ? 1.0 : 2.0) / (d6 - d7);
        double d11 = (d2 + d3) / (d2 - d3);
        double d12 = (d5 + d4) / (d4 - d5);
        double d13 = (bl ? d6 : d7 + d6) / (d6 - d7);
        matrix4x3d.m30 = this.m00 * d11 + this.m10 * d12 + this.m20 * d13 + this.m30;
        matrix4x3d.m31 = this.m01 * d11 + this.m11 * d12 + this.m21 * d13 + this.m31;
        matrix4x3d.m32 = this.m02 * d11 + this.m12 * d12 + this.m22 * d13 + this.m32;
        matrix4x3d.m00 = this.m00 * d8;
        matrix4x3d.m01 = this.m01 * d8;
        matrix4x3d.m02 = this.m02 * d8;
        matrix4x3d.m10 = this.m10 * d9;
        matrix4x3d.m11 = this.m11 * d9;
        matrix4x3d.m12 = this.m12 * d9;
        matrix4x3d.m20 = this.m20 * d10;
        matrix4x3d.m21 = this.m21 * d10;
        matrix4x3d.m22 = this.m22 * d10;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d ortho(double d2, double d3, double d4, double d5, double d6, double d7, Matrix4x3d matrix4x3d) {
        return this.ortho(d2, d3, d4, d5, d6, d7, false, matrix4x3d);
    }

    public Matrix4x3d ortho(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        return this.ortho(d2, d3, d4, d5, d6, d7, bl, this);
    }

    public Matrix4x3d ortho(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.ortho(d2, d3, d4, d5, d6, d7, false);
    }

    public Matrix4x3d orthoLH(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, Matrix4x3d matrix4x3d) {
        double d8 = 2.0 / (d3 - d2);
        double d9 = 2.0 / (d5 - d4);
        double d10 = (bl ? 1.0 : 2.0) / (d7 - d6);
        double d11 = (d2 + d3) / (d2 - d3);
        double d12 = (d5 + d4) / (d4 - d5);
        double d13 = (bl ? d6 : d7 + d6) / (d6 - d7);
        matrix4x3d.m30 = this.m00 * d11 + this.m10 * d12 + this.m20 * d13 + this.m30;
        matrix4x3d.m31 = this.m01 * d11 + this.m11 * d12 + this.m21 * d13 + this.m31;
        matrix4x3d.m32 = this.m02 * d11 + this.m12 * d12 + this.m22 * d13 + this.m32;
        matrix4x3d.m00 = this.m00 * d8;
        matrix4x3d.m01 = this.m01 * d8;
        matrix4x3d.m02 = this.m02 * d8;
        matrix4x3d.m10 = this.m10 * d9;
        matrix4x3d.m11 = this.m11 * d9;
        matrix4x3d.m12 = this.m12 * d9;
        matrix4x3d.m20 = this.m20 * d10;
        matrix4x3d.m21 = this.m21 * d10;
        matrix4x3d.m22 = this.m22 * d10;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d orthoLH(double d2, double d3, double d4, double d5, double d6, double d7, Matrix4x3d matrix4x3d) {
        return this.orthoLH(d2, d3, d4, d5, d6, d7, false, matrix4x3d);
    }

    public Matrix4x3d orthoLH(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        return this.orthoLH(d2, d3, d4, d5, d6, d7, bl, this);
    }

    public Matrix4x3d orthoLH(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.orthoLH(d2, d3, d4, d5, d6, d7, false);
    }

    public Matrix4x3d setOrtho(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        this.m00 = 2.0 / (d3 - d2);
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / (d5 - d4);
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = (bl ? 1.0 : 2.0) / (d6 - d7);
        this.m30 = (d3 + d2) / (d2 - d3);
        this.m31 = (d5 + d4) / (d4 - d5);
        this.m32 = (bl ? d6 : d7 + d6) / (d6 - d7);
        this.properties = 0;
        return this;
    }

    public Matrix4x3d setOrtho(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.setOrtho(d2, d3, d4, d5, d6, d7, false);
    }

    public Matrix4x3d setOrthoLH(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        this.m00 = 2.0 / (d3 - d2);
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / (d5 - d4);
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = (bl ? 1.0 : 2.0) / (d7 - d6);
        this.m30 = (d3 + d2) / (d2 - d3);
        this.m31 = (d5 + d4) / (d4 - d5);
        this.m32 = (bl ? d6 : d7 + d6) / (d6 - d7);
        this.properties = 0;
        return this;
    }

    public Matrix4x3d setOrthoLH(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.setOrthoLH(d2, d3, d4, d5, d6, d7, false);
    }

    public Matrix4x3d orthoSymmetric(double d2, double d3, double d4, double d5, boolean bl, Matrix4x3d matrix4x3d) {
        double d6 = 2.0 / d2;
        double d7 = 2.0 / d3;
        double d8 = (bl ? 1.0 : 2.0) / (d4 - d5);
        double d9 = (bl ? d4 : d5 + d4) / (d4 - d5);
        matrix4x3d.m30 = this.m20 * d9 + this.m30;
        matrix4x3d.m31 = this.m21 * d9 + this.m31;
        matrix4x3d.m32 = this.m22 * d9 + this.m32;
        matrix4x3d.m00 = this.m00 * d6;
        matrix4x3d.m01 = this.m01 * d6;
        matrix4x3d.m02 = this.m02 * d6;
        matrix4x3d.m10 = this.m10 * d7;
        matrix4x3d.m11 = this.m11 * d7;
        matrix4x3d.m12 = this.m12 * d7;
        matrix4x3d.m20 = this.m20 * d8;
        matrix4x3d.m21 = this.m21 * d8;
        matrix4x3d.m22 = this.m22 * d8;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d orthoSymmetric(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        return this.orthoSymmetric(d2, d3, d4, d5, false, matrix4x3d);
    }

    public Matrix4x3d orthoSymmetric(double d2, double d3, double d4, double d5, boolean bl) {
        return this.orthoSymmetric(d2, d3, d4, d5, bl, this);
    }

    public Matrix4x3d orthoSymmetric(double d2, double d3, double d4, double d5) {
        return this.orthoSymmetric(d2, d3, d4, d5, false, this);
    }

    public Matrix4x3d orthoSymmetricLH(double d2, double d3, double d4, double d5, boolean bl, Matrix4x3d matrix4x3d) {
        double d6 = 2.0 / d2;
        double d7 = 2.0 / d3;
        double d8 = (bl ? 1.0 : 2.0) / (d5 - d4);
        double d9 = (bl ? d4 : d5 + d4) / (d4 - d5);
        matrix4x3d.m30 = this.m20 * d9 + this.m30;
        matrix4x3d.m31 = this.m21 * d9 + this.m31;
        matrix4x3d.m32 = this.m22 * d9 + this.m32;
        matrix4x3d.m00 = this.m00 * d6;
        matrix4x3d.m01 = this.m01 * d6;
        matrix4x3d.m02 = this.m02 * d6;
        matrix4x3d.m10 = this.m10 * d7;
        matrix4x3d.m11 = this.m11 * d7;
        matrix4x3d.m12 = this.m12 * d7;
        matrix4x3d.m20 = this.m20 * d8;
        matrix4x3d.m21 = this.m21 * d8;
        matrix4x3d.m22 = this.m22 * d8;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d orthoSymmetricLH(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        return this.orthoSymmetricLH(d2, d3, d4, d5, false, matrix4x3d);
    }

    public Matrix4x3d orthoSymmetricLH(double d2, double d3, double d4, double d5, boolean bl) {
        return this.orthoSymmetricLH(d2, d3, d4, d5, bl, this);
    }

    public Matrix4x3d orthoSymmetricLH(double d2, double d3, double d4, double d5) {
        return this.orthoSymmetricLH(d2, d3, d4, d5, false, this);
    }

    public Matrix4x3d setOrthoSymmetric(double d2, double d3, double d4, double d5, boolean bl) {
        this.m00 = 2.0 / d2;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / d3;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = (bl ? 1.0 : 2.0) / (d4 - d5);
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = (bl ? d4 : d5 + d4) / (d4 - d5);
        this.properties = 0;
        return this;
    }

    public Matrix4x3d setOrthoSymmetric(double d2, double d3, double d4, double d5) {
        return this.setOrthoSymmetric(d2, d3, d4, d5, false);
    }

    public Matrix4x3d setOrthoSymmetricLH(double d2, double d3, double d4, double d5, boolean bl) {
        this.m00 = 2.0 / d2;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / d3;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = (bl ? 1.0 : 2.0) / (d5 - d4);
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = (bl ? d4 : d5 + d4) / (d4 - d5);
        this.properties = 0;
        return this;
    }

    public Matrix4x3d setOrthoSymmetricLH(double d2, double d3, double d4, double d5) {
        return this.setOrthoSymmetricLH(d2, d3, d4, d5, false);
    }

    public Matrix4x3d ortho2D(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        double d6 = 2.0 / (d3 - d2);
        double d7 = 2.0 / (d5 - d4);
        double d8 = -(d3 + d2) / (d3 - d2);
        double d9 = -(d5 + d4) / (d5 - d4);
        matrix4x3d.m30 = this.m00 * d8 + this.m10 * d9 + this.m30;
        matrix4x3d.m31 = this.m01 * d8 + this.m11 * d9 + this.m31;
        matrix4x3d.m32 = this.m02 * d8 + this.m12 * d9 + this.m32;
        matrix4x3d.m00 = this.m00 * d6;
        matrix4x3d.m01 = this.m01 * d6;
        matrix4x3d.m02 = this.m02 * d6;
        matrix4x3d.m10 = this.m10 * d7;
        matrix4x3d.m11 = this.m11 * d7;
        matrix4x3d.m12 = this.m12 * d7;
        matrix4x3d.m20 = -this.m20;
        matrix4x3d.m21 = -this.m21;
        matrix4x3d.m22 = -this.m22;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d ortho2D(double d2, double d3, double d4, double d5) {
        return this.ortho2D(d2, d3, d4, d5, this);
    }

    public Matrix4x3d ortho2DLH(double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        double d6 = 2.0 / (d3 - d2);
        double d7 = 2.0 / (d5 - d4);
        double d8 = -(d3 + d2) / (d3 - d2);
        double d9 = -(d5 + d4) / (d5 - d4);
        matrix4x3d.m30 = this.m00 * d8 + this.m10 * d9 + this.m30;
        matrix4x3d.m31 = this.m01 * d8 + this.m11 * d9 + this.m31;
        matrix4x3d.m32 = this.m02 * d8 + this.m12 * d9 + this.m32;
        matrix4x3d.m00 = this.m00 * d6;
        matrix4x3d.m01 = this.m01 * d6;
        matrix4x3d.m02 = this.m02 * d6;
        matrix4x3d.m10 = this.m10 * d7;
        matrix4x3d.m11 = this.m11 * d7;
        matrix4x3d.m12 = this.m12 * d7;
        matrix4x3d.m20 = this.m20;
        matrix4x3d.m21 = this.m21;
        matrix4x3d.m22 = this.m22;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d ortho2DLH(double d2, double d3, double d4, double d5) {
        return this.ortho2DLH(d2, d3, d4, d5, this);
    }

    public Matrix4x3d setOrtho2D(double d2, double d3, double d4, double d5) {
        this.m00 = 2.0 / (d3 - d2);
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / (d5 - d4);
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = -1.0;
        this.m30 = -(d3 + d2) / (d3 - d2);
        this.m31 = -(d5 + d4) / (d5 - d4);
        this.m32 = 0.0;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d setOrtho2DLH(double d2, double d3, double d4, double d5) {
        this.m00 = 2.0 / (d3 - d2);
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 2.0 / (d5 - d4);
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m30 = -(d3 + d2) / (d3 - d2);
        this.m31 = -(d5 + d4) / (d5 - d4);
        this.m32 = 0.0;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    public Matrix4x3d lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2, Matrix4x3d matrix4x3d) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix4x3d);
    }

    public Matrix4x3d lookAlong(double d2, double d3, double d4, double d5, double d6, double d7, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return this.setLookAlong(d2, d3, d4, d5, d6, d7);
        }
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d6 * (d4 *= -d11) - d7 * (d3 *= -d11);
        double d13 = d7 * (d2 *= -d11) - d5 * d4;
        double d14 = d5 * d3 - d6 * d2;
        double d15 = d12;
        double d16 = d13;
        double d17 = d14;
        double d18 = Math.invsqrt(d15 * d15 + d16 * d16 + d17 * d17);
        double d19 = d3 * (d14 *= d18) - d4 * (d13 *= d18);
        double d20 = d4 * (d12 *= d18) - d2 * d14;
        double d21 = d2 * d13 - d3 * d12;
        double d22 = this.m00 * d12 + this.m10 * d19 + this.m20 * d2;
        double d23 = this.m01 * d12 + this.m11 * d19 + this.m21 * d2;
        double d24 = this.m02 * d12 + this.m12 * d19 + this.m22 * d2;
        double d25 = this.m00 * d13 + this.m10 * d20 + this.m20 * d3;
        double d26 = this.m01 * d13 + this.m11 * d20 + this.m21 * d3;
        double d27 = this.m02 * d13 + this.m12 * d20 + this.m22 * d3;
        matrix4x3d.m20 = this.m00 * d14 + this.m10 * d21 + this.m20 * d4;
        matrix4x3d.m21 = this.m01 * d14 + this.m11 * d21 + this.m21 * d4;
        matrix4x3d.m22 = this.m02 * d14 + this.m12 * d21 + this.m22 * d4;
        matrix4x3d.m00 = d22;
        matrix4x3d.m01 = d23;
        matrix4x3d.m02 = d24;
        matrix4x3d.m10 = d25;
        matrix4x3d.m11 = d26;
        matrix4x3d.m12 = d27;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d lookAlong(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.lookAlong(d2, d3, d4, d5, d6, d7, this);
    }

    public Matrix4x3d setLookAlong(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.setLookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix4x3d setLookAlong(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d6 * (d4 *= -d11) - d7 * (d3 *= -d11);
        double d13 = d7 * (d2 *= -d11) - d5 * d4;
        double d14 = d5 * d3 - d6 * d2;
        double d15 = d12;
        double d16 = d13;
        double d17 = d14;
        double d18 = Math.invsqrt(d15 * d15 + d16 * d16 + d17 * d17);
        double d19 = d3 * (d14 *= d18) - d4 * (d13 *= d18);
        double d20 = d4 * (d12 *= d18) - d2 * d14;
        double d21 = d2 * d13 - d3 * d12;
        this.m00 = d12;
        this.m01 = d19;
        this.m02 = d2;
        this.m10 = d13;
        this.m11 = d20;
        this.m12 = d3;
        this.m20 = d14;
        this.m21 = d21;
        this.m22 = d4;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d setLookAt(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        return this.setLookAt(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z());
    }

    public Matrix4x3d setLookAt(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d2 - d5;
        double d12 = d3 - d6;
        double d13 = d4 - d7;
        double d14 = d11;
        double d15 = d12;
        double d16 = d13;
        double d17 = Math.invsqrt(d14 * d14 + d15 * d15 + d16 * d16);
        double d18 = d9 * (d13 *= d17) - d10 * (d12 *= d17);
        double d19 = d10 * (d11 *= d17) - d8 * d13;
        double d20 = d8 * d12 - d9 * d11;
        double d21 = d18;
        double d22 = d19;
        double d23 = d20;
        double d24 = Math.invsqrt(d21 * d21 + d22 * d22 + d23 * d23);
        double d25 = d12 * (d20 *= d24) - d13 * (d19 *= d24);
        double d26 = d13 * (d18 *= d24) - d11 * d20;
        double d27 = d11 * d19 - d12 * d18;
        this.m00 = d18;
        this.m01 = d25;
        this.m02 = d11;
        this.m10 = d19;
        this.m11 = d26;
        this.m12 = d12;
        this.m20 = d20;
        this.m21 = d27;
        this.m22 = d13;
        this.m30 = -(d18 * d2 + d19 * d3 + d20 * d4);
        this.m31 = -(d25 * d2 + d26 * d3 + d27 * d4);
        this.m32 = -(d11 * d2 + d12 * d3 + d13 * d4);
        this.properties = 16;
        return this;
    }

    public Matrix4x3d lookAt(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Matrix4x3d matrix4x3d) {
        return this.lookAt(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), matrix4x3d);
    }

    public Matrix4x3d lookAt(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        return this.lookAt(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), this);
    }

    public Matrix4x3d lookAt(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.setLookAt(d2, d3, d4, d5, d6, d7, d8, d9, d10);
        }
        return this.lookAtGeneric(d2, d3, d4, d5, d6, d7, d8, d9, d10, matrix4x3d);
    }

    private Matrix4x3d lookAtGeneric(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Matrix4x3d matrix4x3d) {
        double d11 = d2 - d5;
        double d12 = d3 - d6;
        double d13 = d4 - d7;
        double d14 = d11;
        double d15 = d12;
        double d16 = d13;
        double d17 = Math.invsqrt(d14 * d14 + d15 * d15 + d16 * d16);
        double d18 = d9 * (d13 *= d17) - d10 * (d12 *= d17);
        double d19 = d10 * (d11 *= d17) - d8 * d13;
        double d20 = d8 * d12 - d9 * d11;
        double d21 = d18;
        double d22 = d19;
        double d23 = d20;
        double d24 = Math.invsqrt(d21 * d21 + d22 * d22 + d23 * d23);
        double d25 = d12 * (d20 *= d24) - d13 * (d19 *= d24);
        double d26 = d13 * (d18 *= d24) - d11 * d20;
        double d27 = d11 * d19 - d12 * d18;
        double d28 = -(d18 * d2 + d19 * d3 + d20 * d4);
        double d29 = -(d25 * d2 + d26 * d3 + d27 * d4);
        double d30 = -(d11 * d2 + d12 * d3 + d13 * d4);
        matrix4x3d.m30 = this.m00 * d28 + this.m10 * d29 + this.m20 * d30 + this.m30;
        matrix4x3d.m31 = this.m01 * d28 + this.m11 * d29 + this.m21 * d30 + this.m31;
        matrix4x3d.m32 = this.m02 * d28 + this.m12 * d29 + this.m22 * d30 + this.m32;
        double d31 = this.m00 * d18 + this.m10 * d25 + this.m20 * d11;
        double d32 = this.m01 * d18 + this.m11 * d25 + this.m21 * d11;
        double d33 = this.m02 * d18 + this.m12 * d25 + this.m22 * d11;
        double d34 = this.m00 * d19 + this.m10 * d26 + this.m20 * d12;
        double d35 = this.m01 * d19 + this.m11 * d26 + this.m21 * d12;
        double d36 = this.m02 * d19 + this.m12 * d26 + this.m22 * d12;
        matrix4x3d.m20 = this.m00 * d20 + this.m10 * d27 + this.m20 * d13;
        matrix4x3d.m21 = this.m01 * d20 + this.m11 * d27 + this.m21 * d13;
        matrix4x3d.m22 = this.m02 * d20 + this.m12 * d27 + this.m22 * d13;
        matrix4x3d.m00 = d31;
        matrix4x3d.m01 = d32;
        matrix4x3d.m02 = d33;
        matrix4x3d.m10 = d34;
        matrix4x3d.m11 = d35;
        matrix4x3d.m12 = d36;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d lookAt(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        return this.lookAt(d2, d3, d4, d5, d6, d7, d8, d9, d10, this);
    }

    public Matrix4x3d setLookAtLH(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        return this.setLookAtLH(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z());
    }

    public Matrix4x3d setLookAtLH(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d5 - d2;
        double d12 = d6 - d3;
        double d13 = d7 - d4;
        double d14 = d11;
        double d15 = d12;
        double d16 = d13;
        double d17 = Math.invsqrt(d14 * d14 + d15 * d15 + d16 * d16);
        double d18 = d9 * (d13 *= d17) - d10 * (d12 *= d17);
        double d19 = d10 * (d11 *= d17) - d8 * d13;
        double d20 = d8 * d12 - d9 * d11;
        double d21 = d18;
        double d22 = d19;
        double d23 = d20;
        double d24 = Math.invsqrt(d21 * d21 + d22 * d22 + d23 * d23);
        double d25 = d12 * (d20 *= d24) - d13 * (d19 *= d24);
        double d26 = d13 * (d18 *= d24) - d11 * d20;
        double d27 = d11 * d19 - d12 * d18;
        this.m00 = d18;
        this.m01 = d25;
        this.m02 = d11;
        this.m10 = d19;
        this.m11 = d26;
        this.m12 = d12;
        this.m20 = d20;
        this.m21 = d27;
        this.m22 = d13;
        this.m30 = -(d18 * d2 + d19 * d3 + d20 * d4);
        this.m31 = -(d25 * d2 + d26 * d3 + d27 * d4);
        this.m32 = -(d11 * d2 + d12 * d3 + d13 * d4);
        this.properties = 16;
        return this;
    }

    public Matrix4x3d lookAtLH(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Matrix4x3d matrix4x3d) {
        return this.lookAtLH(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), matrix4x3d);
    }

    public Matrix4x3d lookAtLH(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        return this.lookAtLH(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), this);
    }

    public Matrix4x3d lookAtLH(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Matrix4x3d matrix4x3d) {
        if ((this.properties & 4) != 0) {
            return matrix4x3d.setLookAtLH(d2, d3, d4, d5, d6, d7, d8, d9, d10);
        }
        return this.lookAtLHGeneric(d2, d3, d4, d5, d6, d7, d8, d9, d10, matrix4x3d);
    }

    private Matrix4x3d lookAtLHGeneric(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Matrix4x3d matrix4x3d) {
        double d11 = d5 - d2;
        double d12 = d6 - d3;
        double d13 = d7 - d4;
        double d14 = d11;
        double d15 = d12;
        double d16 = d13;
        double d17 = Math.invsqrt(d14 * d14 + d15 * d15 + d16 * d16);
        double d18 = d9 * (d13 *= d17) - d10 * (d12 *= d17);
        double d19 = d10 * (d11 *= d17) - d8 * d13;
        double d20 = d8 * d12 - d9 * d11;
        double d21 = d18;
        double d22 = d19;
        double d23 = d20;
        double d24 = Math.invsqrt(d21 * d21 + d22 * d22 + d23 * d23);
        double d25 = d12 * (d20 *= d24) - d13 * (d19 *= d24);
        double d26 = d13 * (d18 *= d24) - d11 * d20;
        double d27 = d11 * d19 - d12 * d18;
        double d28 = -(d18 * d2 + d19 * d3 + d20 * d4);
        double d29 = -(d25 * d2 + d26 * d3 + d27 * d4);
        double d30 = -(d11 * d2 + d12 * d3 + d13 * d4);
        matrix4x3d.m30 = this.m00 * d28 + this.m10 * d29 + this.m20 * d30 + this.m30;
        matrix4x3d.m31 = this.m01 * d28 + this.m11 * d29 + this.m21 * d30 + this.m31;
        matrix4x3d.m32 = this.m02 * d28 + this.m12 * d29 + this.m22 * d30 + this.m32;
        double d31 = this.m00 * d18 + this.m10 * d25 + this.m20 * d11;
        double d32 = this.m01 * d18 + this.m11 * d25 + this.m21 * d11;
        double d33 = this.m02 * d18 + this.m12 * d25 + this.m22 * d11;
        double d34 = this.m00 * d19 + this.m10 * d26 + this.m20 * d12;
        double d35 = this.m01 * d19 + this.m11 * d26 + this.m21 * d12;
        double d36 = this.m02 * d19 + this.m12 * d26 + this.m22 * d12;
        matrix4x3d.m20 = this.m00 * d20 + this.m10 * d27 + this.m20 * d13;
        matrix4x3d.m21 = this.m01 * d20 + this.m11 * d27 + this.m21 * d13;
        matrix4x3d.m22 = this.m02 * d20 + this.m12 * d27 + this.m22 * d13;
        matrix4x3d.m00 = d31;
        matrix4x3d.m01 = d32;
        matrix4x3d.m02 = d33;
        matrix4x3d.m10 = d34;
        matrix4x3d.m11 = d35;
        matrix4x3d.m12 = d36;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d lookAtLH(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        return this.lookAtLH(d2, d3, d4, d5, d6, d7, d8, d9, d10, this);
    }

    public Vector4d frustumPlane(int n2, Vector4d vector4d) {
        switch (n2) {
            case 0: {
                vector4d.set(this.m00, this.m10, this.m20, 1.0 + this.m30).normalize();
                break;
            }
            case 1: {
                vector4d.set(-this.m00, -this.m10, -this.m20, 1.0 - this.m30).normalize();
                break;
            }
            case 2: {
                vector4d.set(this.m01, this.m11, this.m21, 1.0 + this.m31).normalize();
                break;
            }
            case 3: {
                vector4d.set(-this.m01, -this.m11, -this.m21, 1.0 - this.m31).normalize();
                break;
            }
            case 4: {
                vector4d.set(this.m02, this.m12, this.m22, 1.0 + this.m32).normalize();
                break;
            }
            case 5: {
                vector4d.set(-this.m02, -this.m12, -this.m22, 1.0 - this.m32).normalize();
                break;
            }
            default: {
                throw new IllegalArgumentException("which");
            }
        }
        return vector4d;
    }

    public Vector3d positiveZ(Vector3d vector3d) {
        vector3d.x = this.m10 * this.m21 - this.m11 * this.m20;
        vector3d.y = this.m20 * this.m01 - this.m21 * this.m00;
        vector3d.z = this.m00 * this.m11 - this.m01 * this.m10;
        Vector3d vector3d2 = vector3d;
        return vector3d2.normalize(vector3d2);
    }

    public Vector3d normalizedPositiveZ(Vector3d vector3d) {
        vector3d.x = this.m02;
        vector3d.y = this.m12;
        vector3d.z = this.m22;
        return vector3d;
    }

    public Vector3d positiveX(Vector3d vector3d) {
        vector3d.x = this.m11 * this.m22 - this.m12 * this.m21;
        vector3d.y = this.m02 * this.m21 - this.m01 * this.m22;
        vector3d.z = this.m01 * this.m12 - this.m02 * this.m11;
        Vector3d vector3d2 = vector3d;
        return vector3d2.normalize(vector3d2);
    }

    public Vector3d normalizedPositiveX(Vector3d vector3d) {
        vector3d.x = this.m00;
        vector3d.y = this.m10;
        vector3d.z = this.m20;
        return vector3d;
    }

    public Vector3d positiveY(Vector3d vector3d) {
        vector3d.x = this.m12 * this.m20 - this.m10 * this.m22;
        vector3d.y = this.m00 * this.m22 - this.m02 * this.m20;
        vector3d.z = this.m02 * this.m10 - this.m00 * this.m12;
        Vector3d vector3d2 = vector3d;
        return vector3d2.normalize(vector3d2);
    }

    public Vector3d normalizedPositiveY(Vector3d vector3d) {
        vector3d.x = this.m01;
        vector3d.y = this.m11;
        vector3d.z = this.m21;
        return vector3d;
    }

    public Vector3d origin(Vector3d vector3d) {
        double d2 = this.m00 * this.m11 - this.m01 * this.m10;
        double d3 = this.m00 * this.m12 - this.m02 * this.m10;
        double d4 = this.m01 * this.m12 - this.m02 * this.m11;
        double d5 = this.m20 * this.m31 - this.m21 * this.m30;
        double d6 = this.m20 * this.m32 - this.m22 * this.m30;
        double d7 = this.m21 * this.m32 - this.m22 * this.m31;
        vector3d.x = -this.m10 * d7 + this.m11 * d6 - this.m12 * d5;
        vector3d.y = this.m00 * d7 - this.m01 * d6 + this.m02 * d5;
        vector3d.z = -this.m30 * d4 + this.m31 * d3 - this.m32 * d2;
        return vector3d;
    }

    public Matrix4x3d shadow(Vector4dc vector4dc, double d2, double d3, double d4, double d5) {
        return this.shadow(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4dc.w(), d2, d3, d4, d5, this);
    }

    public Matrix4x3d shadow(Vector4dc vector4dc, double d2, double d3, double d4, double d5, Matrix4x3d matrix4x3d) {
        return this.shadow(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4dc.w(), d2, d3, d4, d5, matrix4x3d);
    }

    public Matrix4x3d shadow(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return this.shadow(d2, d3, d4, d5, d6, d7, d8, d9, this);
    }

    public Matrix4x3d shadow(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Matrix4x3d matrix4x3d) {
        double d10 = d6;
        double d11 = d7;
        double d12 = d8;
        double d13 = Math.invsqrt(d10 * d10 + d11 * d11 + d12 * d12);
        double d14 = d6 * d13;
        double d15 = d7 * d13;
        double d16 = d8 * d13;
        double d17 = d9 * d13;
        double d18 = d14 * d2 + d15 * d3 + d16 * d4 + d17 * d5;
        double d19 = d18 - d14 * d2;
        double d20 = -d14 * d3;
        double d21 = -d14 * d4;
        double d22 = -d14 * d5;
        double d23 = -d15 * d2;
        double d24 = d18 - d15 * d3;
        double d25 = -d15 * d4;
        double d26 = -d15 * d5;
        double d27 = -d16 * d2;
        double d28 = -d16 * d3;
        double d29 = d18 - d16 * d4;
        double d30 = -d16 * d5;
        double d31 = -d17 * d2;
        double d32 = -d17 * d3;
        double d33 = -d17 * d4;
        double d34 = d18 - d17 * d5;
        double d35 = this.m00 * d19 + this.m10 * d20 + this.m20 * d21 + this.m30 * d22;
        double d36 = this.m01 * d19 + this.m11 * d20 + this.m21 * d21 + this.m31 * d22;
        double d37 = this.m02 * d19 + this.m12 * d20 + this.m22 * d21 + this.m32 * d22;
        double d38 = this.m00 * d23 + this.m10 * d24 + this.m20 * d25 + this.m30 * d26;
        double d39 = this.m01 * d23 + this.m11 * d24 + this.m21 * d25 + this.m31 * d26;
        double d40 = this.m02 * d23 + this.m12 * d24 + this.m22 * d25 + this.m32 * d26;
        double d41 = this.m00 * d27 + this.m10 * d28 + this.m20 * d29 + this.m30 * d30;
        double d42 = this.m01 * d27 + this.m11 * d28 + this.m21 * d29 + this.m31 * d30;
        double d43 = this.m02 * d27 + this.m12 * d28 + this.m22 * d29 + this.m32 * d30;
        matrix4x3d.m30 = this.m00 * d31 + this.m10 * d32 + this.m20 * d33 + this.m30 * d34;
        matrix4x3d.m31 = this.m01 * d31 + this.m11 * d32 + this.m21 * d33 + this.m31 * d34;
        matrix4x3d.m32 = this.m02 * d31 + this.m12 * d32 + this.m22 * d33 + this.m32 * d34;
        matrix4x3d.m00 = d35;
        matrix4x3d.m01 = d36;
        matrix4x3d.m02 = d37;
        matrix4x3d.m10 = d38;
        matrix4x3d.m11 = d39;
        matrix4x3d.m12 = d40;
        matrix4x3d.m20 = d41;
        matrix4x3d.m21 = d42;
        matrix4x3d.m22 = d43;
        matrix4x3d.properties = this.properties & 0xFFFFFFE3;
        return matrix4x3d;
    }

    public Matrix4x3d shadow(Vector4dc vector4dc, Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        double d2 = matrix4x3dc.m10();
        double d3 = matrix4x3dc.m11();
        double d4 = matrix4x3dc.m12();
        double d5 = -d2 * matrix4x3dc.m30() - d3 * matrix4x3dc.m31() - d4 * matrix4x3dc.m32();
        return this.shadow(vector4dc.x(), vector4dc.y(), vector4dc.z(), vector4dc.w(), d2, d3, d4, d5, matrix4x3d);
    }

    public Matrix4x3d shadow(Vector4dc vector4dc, Matrix4x3dc matrix4x3dc) {
        return this.shadow(vector4dc, matrix4x3dc, this);
    }

    public Matrix4x3d shadow(double d2, double d3, double d4, double d5, Matrix4x3dc matrix4x3dc, Matrix4x3d matrix4x3d) {
        double d6 = matrix4x3dc.m10();
        double d7 = matrix4x3dc.m11();
        double d8 = matrix4x3dc.m12();
        double d9 = -d6 * matrix4x3dc.m30() - d7 * matrix4x3dc.m31() - d8 * matrix4x3dc.m32();
        return this.shadow(d2, d3, d4, d5, d6, d7, d8, d9, matrix4x3d);
    }

    public Matrix4x3d shadow(double d2, double d3, double d4, double d5, Matrix4x3dc matrix4x3dc) {
        return this.shadow(d2, d3, d4, d5, matrix4x3dc, this);
    }

    public Matrix4x3d billboardCylindrical(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        double d2 = vector3dc2.x() - vector3dc.x();
        double d3 = vector3dc2.y() - vector3dc.y();
        double d4 = vector3dc2.z() - vector3dc.z();
        double d5 = vector3dc3.y() * d4 - vector3dc3.z() * d3;
        double d6 = vector3dc3.z() * d2 - vector3dc3.x() * d4;
        double d7 = vector3dc3.x() * d3 - vector3dc3.y() * d2;
        double d8 = d5;
        double d9 = d6;
        double d10 = d7;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        d2 = (d6 *= d11) * vector3dc3.z() - (d7 *= d11) * vector3dc3.y();
        d3 = d7 * vector3dc3.x() - (d5 *= d11) * vector3dc3.z();
        d4 = d5 * vector3dc3.y() - d6 * vector3dc3.x();
        double d12 = d2;
        double d13 = d3;
        double d14 = d4;
        double d15 = Math.invsqrt(d12 * d12 + d13 * d13 + d14 * d14);
        d2 *= d15;
        d3 *= d15;
        d4 *= d15;
        this.m00 = d5;
        this.m01 = d6;
        this.m02 = d7;
        this.m10 = vector3dc3.x();
        this.m11 = vector3dc3.y();
        this.m12 = vector3dc3.z();
        this.m20 = d2;
        this.m21 = d3;
        this.m22 = d4;
        this.m30 = vector3dc.x();
        this.m31 = vector3dc.y();
        this.m32 = vector3dc.z();
        this.properties = 16;
        return this;
    }

    public Matrix4x3d billboardSpherical(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        double d2 = vector3dc2.x() - vector3dc.x();
        double d3 = vector3dc2.y() - vector3dc.y();
        double d4 = vector3dc2.z() - vector3dc.z();
        double d5 = d2;
        double d6 = d3;
        double d7 = d4;
        double d8 = Math.invsqrt(d5 * d5 + d6 * d6 + d7 * d7);
        double d9 = vector3dc3.y() * (d4 *= d8) - vector3dc3.z() * (d3 *= d8);
        double d10 = vector3dc3.z() * (d2 *= d8) - vector3dc3.x() * d4;
        double d11 = vector3dc3.x() * d3 - vector3dc3.y() * d2;
        double d12 = d9;
        double d13 = d10;
        double d14 = d11;
        double d15 = Math.invsqrt(d12 * d12 + d13 * d13 + d14 * d14);
        double d16 = d3 * (d11 *= d15) - d4 * (d10 *= d15);
        double d17 = d4 * (d9 *= d15) - d2 * d11;
        double d18 = d2 * d10 - d3 * d9;
        this.m00 = d9;
        this.m01 = d10;
        this.m02 = d11;
        this.m10 = d16;
        this.m11 = d17;
        this.m12 = d18;
        this.m20 = d2;
        this.m21 = d3;
        this.m22 = d4;
        this.m30 = vector3dc.x();
        this.m31 = vector3dc.y();
        this.m32 = vector3dc.z();
        this.properties = 16;
        return this;
    }

    public Matrix4x3d billboardSpherical(Vector3dc vector3dc, Vector3dc vector3dc2) {
        double d2 = vector3dc2.x() - vector3dc.x();
        double d3 = vector3dc2.y() - vector3dc.y();
        double d4 = vector3dc2.z() - vector3dc.z();
        double d5 = -d3;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8) + d4;
        double d10 = d5;
        double d11 = d2;
        double d12 = d9;
        double d13 = Math.invsqrt(d10 * d10 + d11 * d11 + d12 * d12);
        double d14 = d2 * d13;
        d9 *= d13;
        double d15 = d5 *= d13;
        double d16 = (d15 + d15) * d5;
        double d17 = d14;
        double d18 = (d17 + d17) * d14;
        double d19 = d5;
        double d20 = (d19 + d19) * d14;
        double d21 = d5;
        double d22 = (d21 + d21) * d9;
        double d23 = d14;
        double d24 = (d23 + d23) * d9;
        this.m00 = 1.0 - d18;
        this.m01 = d20;
        this.m02 = -d24;
        this.m10 = d20;
        this.m11 = 1.0 - d16;
        this.m12 = d22;
        this.m20 = d24;
        this.m21 = -d22;
        this.m22 = 1.0 - d18 - d16;
        this.m30 = vector3dc.x();
        this.m31 = vector3dc.y();
        this.m32 = vector3dc.z();
        this.properties = 16;
        return this;
    }

    public int hashCode() {
        long l2;
        long l3 = l2 = Double.doubleToLongBits(this.m00);
        int n2 = 31 + (int)(l3 ^ l3 >>> 32);
        long l4 = l2 = Double.doubleToLongBits(this.m01);
        n2 = n2 * 31 + (int)(l4 ^ l4 >>> 32);
        long l5 = l2 = Double.doubleToLongBits(this.m02);
        n2 = n2 * 31 + (int)(l5 ^ l5 >>> 32);
        long l6 = l2 = Double.doubleToLongBits(this.m10);
        n2 = n2 * 31 + (int)(l6 ^ l6 >>> 32);
        long l7 = l2 = Double.doubleToLongBits(this.m11);
        n2 = n2 * 31 + (int)(l7 ^ l7 >>> 32);
        long l8 = l2 = Double.doubleToLongBits(this.m12);
        n2 = n2 * 31 + (int)(l8 ^ l8 >>> 32);
        long l9 = l2 = Double.doubleToLongBits(this.m20);
        n2 = n2 * 31 + (int)(l9 ^ l9 >>> 32);
        long l10 = l2 = Double.doubleToLongBits(this.m21);
        n2 = n2 * 31 + (int)(l10 ^ l10 >>> 32);
        long l11 = l2 = Double.doubleToLongBits(this.m22);
        n2 = n2 * 31 + (int)(l11 ^ l11 >>> 32);
        long l12 = l2 = Double.doubleToLongBits(this.m30);
        n2 = n2 * 31 + (int)(l12 ^ l12 >>> 32);
        long l13 = l2 = Double.doubleToLongBits(this.m31);
        n2 = n2 * 31 + (int)(l13 ^ l13 >>> 32);
        long l14 = l2 = Double.doubleToLongBits(this.m32);
        return n2 * 31 + (int)(l14 ^ l14 >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Matrix4x3d)) {
            return false;
        }
        object = (Matrix4x3d)object;
        if (Double.doubleToLongBits(this.m00) != Double.doubleToLongBits(((Matrix4x3d)object).m00)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m01) != Double.doubleToLongBits(((Matrix4x3d)object).m01)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m02) != Double.doubleToLongBits(((Matrix4x3d)object).m02)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m10) != Double.doubleToLongBits(((Matrix4x3d)object).m10)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m11) != Double.doubleToLongBits(((Matrix4x3d)object).m11)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m12) != Double.doubleToLongBits(((Matrix4x3d)object).m12)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m20) != Double.doubleToLongBits(((Matrix4x3d)object).m20)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m21) != Double.doubleToLongBits(((Matrix4x3d)object).m21)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m22) != Double.doubleToLongBits(((Matrix4x3d)object).m22)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m30) != Double.doubleToLongBits(((Matrix4x3d)object).m30)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m31) != Double.doubleToLongBits(((Matrix4x3d)object).m31)) {
            return false;
        }
        return Double.doubleToLongBits(this.m32) == Double.doubleToLongBits(((Matrix4x3d)object).m32);
    }

    public boolean equals(Matrix4x3dc matrix4x3dc, double d2) {
        if (this == matrix4x3dc) {
            return true;
        }
        if (matrix4x3dc == null) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix4x3dc.m00(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix4x3dc.m01(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m02, matrix4x3dc.m02(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix4x3dc.m10(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix4x3dc.m11(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m12, matrix4x3dc.m12(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix4x3dc.m20(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m21, matrix4x3dc.m21(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m22, matrix4x3dc.m22(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m30, matrix4x3dc.m30(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m31, matrix4x3dc.m31(), d2)) {
            return false;
        }
        return Runtime.equals(this.m32, matrix4x3dc.m32(), d2);
    }

    public Matrix4x3d pick(double d2, double d3, double d4, double d5, int[] nArray, Matrix4x3d matrix4x3d) {
        double d6 = (double)nArray[2] / d4;
        double d7 = (double)nArray[3] / d5;
        double d8 = ((double)nArray[2] + 2.0 * ((double)nArray[0] - d2)) / d4;
        double d9 = ((double)nArray[3] + 2.0 * ((double)nArray[1] - d3)) / d5;
        matrix4x3d.m30 = this.m00 * d8 + this.m10 * d9 + this.m30;
        matrix4x3d.m31 = this.m01 * d8 + this.m11 * d9 + this.m31;
        matrix4x3d.m32 = this.m02 * d8 + this.m12 * d9 + this.m32;
        matrix4x3d.m00 = this.m00 * d6;
        matrix4x3d.m01 = this.m01 * d6;
        matrix4x3d.m02 = this.m02 * d6;
        matrix4x3d.m10 = this.m10 * d7;
        matrix4x3d.m11 = this.m11 * d7;
        matrix4x3d.m12 = this.m12 * d7;
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d pick(double d2, double d3, double d4, double d5, int[] nArray) {
        return this.pick(d2, d3, d4, d5, nArray, this);
    }

    public Matrix4x3d swap(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        this.m00 = matrix4x3d.m00;
        matrix4x3d.m00 = d2;
        d2 = this.m01;
        this.m01 = matrix4x3d.m01;
        matrix4x3d.m01 = d2;
        d2 = this.m02;
        this.m02 = matrix4x3d.m02;
        matrix4x3d.m02 = d2;
        d2 = this.m10;
        this.m10 = matrix4x3d.m10;
        matrix4x3d.m10 = d2;
        d2 = this.m11;
        this.m11 = matrix4x3d.m11;
        matrix4x3d.m11 = d2;
        d2 = this.m12;
        this.m12 = matrix4x3d.m12;
        matrix4x3d.m12 = d2;
        d2 = this.m20;
        this.m20 = matrix4x3d.m20;
        matrix4x3d.m20 = d2;
        d2 = this.m21;
        this.m21 = matrix4x3d.m21;
        matrix4x3d.m21 = d2;
        d2 = this.m22;
        this.m22 = matrix4x3d.m22;
        matrix4x3d.m22 = d2;
        d2 = this.m30;
        this.m30 = matrix4x3d.m30;
        matrix4x3d.m30 = d2;
        d2 = this.m31;
        this.m31 = matrix4x3d.m31;
        matrix4x3d.m31 = d2;
        d2 = this.m32;
        this.m32 = matrix4x3d.m32;
        matrix4x3d.m32 = d2;
        int n2 = this.properties;
        this.properties = matrix4x3d.properties;
        matrix4x3d.properties = n2;
        return this;
    }

    public Matrix4x3d arcball(double d2, double d3, double d4, double d5, double d6, double d7, Matrix4x3d matrix4x3d) {
        double d8 = this.m20 * -d2 + this.m30;
        double d9 = this.m21 * -d2 + this.m31;
        double d10 = this.m22 * -d2 + this.m32;
        double d11 = Math.sin(d6);
        double d12 = Math.cosFromSin(d11, d6);
        double d13 = this.m10 * d12 + this.m20 * d11;
        double d14 = this.m11 * d12 + this.m21 * d11;
        double d15 = this.m12 * d12 + this.m22 * d11;
        double d16 = this.m20 * d12 - this.m10 * d11;
        double d17 = this.m21 * d12 - this.m11 * d11;
        double d18 = this.m22 * d12 - this.m12 * d11;
        d11 = Math.sin(d7);
        d12 = Math.cosFromSin(d11, d7);
        double d19 = this.m00 * d12 - d16 * d11;
        double d20 = this.m01 * d12 - d17 * d11;
        double d21 = this.m02 * d12 - d18 * d11;
        double d22 = this.m00 * d11 + d16 * d12;
        double d23 = this.m01 * d11 + d17 * d12;
        double d24 = this.m02 * d11 + d18 * d12;
        matrix4x3d.m30 = -d19 * d3 - d13 * d4 - d22 * d5 + d8;
        matrix4x3d.m31 = -d20 * d3 - d14 * d4 - d23 * d5 + d9;
        matrix4x3d.m32 = -d21 * d3 - d15 * d4 - d24 * d5 + d10;
        matrix4x3d.m20 = d22;
        matrix4x3d.m21 = d23;
        matrix4x3d.m22 = d24;
        matrix4x3d.m10 = d13;
        matrix4x3d.m11 = d14;
        matrix4x3d.m12 = d15;
        matrix4x3d.m00 = d19;
        matrix4x3d.m01 = d20;
        matrix4x3d.m02 = d21;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d arcball(double d2, Vector3dc vector3dc, double d3, double d4, Matrix4x3d matrix4x3d) {
        return this.arcball(d2, vector3dc.x(), vector3dc.y(), vector3dc.z(), d3, d4, matrix4x3d);
    }

    public Matrix4x3d arcball(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.arcball(d2, d3, d4, d5, d6, d7, this);
    }

    public Matrix4x3d arcball(double d2, Vector3dc vector3dc, double d3, double d4) {
        return this.arcball(d2, vector3dc.x(), vector3dc.y(), vector3dc.z(), d3, d4, this);
    }

    public Matrix4x3d transformAab(double d2, double d3, double d4, double d5, double d6, double d7, Vector3d vector3d, Vector3d vector3d2) {
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20;
        double d21;
        double d22;
        double d23;
        double d24;
        double d25;
        double d26 = this.m00 * d2;
        double d27 = this.m01 * d2;
        double d28 = this.m02 * d2;
        double d29 = this.m00 * d5;
        double d30 = this.m01 * d5;
        double d31 = this.m02 * d5;
        double d32 = this.m10 * d3;
        double d33 = this.m11 * d3;
        double d34 = this.m12 * d3;
        double d35 = this.m10 * d6;
        double d36 = this.m11 * d6;
        double d37 = this.m12 * d6;
        double d38 = this.m20 * d4;
        double d39 = this.m21 * d4;
        double d40 = this.m22 * d4;
        double d41 = this.m20 * d7;
        double d42 = this.m21 * d7;
        double d43 = this.m22 * d7;
        if (d26 < d29) {
            d25 = d26;
            d24 = d29;
        } else {
            d25 = d29;
            d24 = d26;
        }
        if (d27 < d30) {
            d23 = d27;
            d22 = d30;
        } else {
            d23 = d30;
            d22 = d27;
        }
        if (d28 < d31) {
            d21 = d28;
            d20 = d31;
        } else {
            d21 = d31;
            d20 = d28;
        }
        if (d32 < d35) {
            d19 = d32;
            d18 = d35;
        } else {
            d19 = d35;
            d18 = d32;
        }
        if (d33 < d36) {
            d17 = d33;
            d16 = d36;
        } else {
            d17 = d36;
            d16 = d33;
        }
        if (d34 < d37) {
            d15 = d34;
            d14 = d37;
        } else {
            d15 = d37;
            d14 = d34;
        }
        if (d38 < d41) {
            d13 = d38;
            d12 = d41;
        } else {
            d13 = d41;
            d12 = d38;
        }
        if (d39 < d42) {
            d11 = d39;
            d10 = d42;
        } else {
            d11 = d42;
            d10 = d39;
        }
        if (d40 < d43) {
            d9 = d40;
            d8 = d43;
        } else {
            d9 = d43;
            d8 = d40;
        }
        vector3d.x = d25 + d19 + d13 + this.m30;
        vector3d.y = d23 + d17 + d11 + this.m31;
        vector3d.z = d21 + d15 + d9 + this.m32;
        vector3d2.x = d24 + d18 + d12 + this.m30;
        vector3d2.y = d22 + d16 + d10 + this.m31;
        vector3d2.z = d20 + d14 + d8 + this.m32;
        return this;
    }

    public Matrix4x3d transformAab(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3d vector3d, Vector3d vector3d2) {
        return this.transformAab(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3d, vector3d2);
    }

    public Matrix4x3d lerp(Matrix4x3dc matrix4x3dc, double d2) {
        return this.lerp(matrix4x3dc, d2, this);
    }

    public Matrix4x3d lerp(Matrix4x3dc matrix4x3dc, double d2, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = Math.fma(matrix4x3dc.m00() - this.m00, d2, this.m00);
        matrix4x3d.m01 = Math.fma(matrix4x3dc.m01() - this.m01, d2, this.m01);
        matrix4x3d.m02 = Math.fma(matrix4x3dc.m02() - this.m02, d2, this.m02);
        matrix4x3d.m10 = Math.fma(matrix4x3dc.m10() - this.m10, d2, this.m10);
        matrix4x3d.m11 = Math.fma(matrix4x3dc.m11() - this.m11, d2, this.m11);
        matrix4x3d.m12 = Math.fma(matrix4x3dc.m12() - this.m12, d2, this.m12);
        matrix4x3d.m20 = Math.fma(matrix4x3dc.m20() - this.m20, d2, this.m20);
        matrix4x3d.m21 = Math.fma(matrix4x3dc.m21() - this.m21, d2, this.m21);
        matrix4x3d.m22 = Math.fma(matrix4x3dc.m22() - this.m22, d2, this.m22);
        matrix4x3d.m30 = Math.fma(matrix4x3dc.m30() - this.m30, d2, this.m30);
        matrix4x3d.m31 = Math.fma(matrix4x3dc.m31() - this.m31, d2, this.m31);
        matrix4x3d.m32 = Math.fma(matrix4x3dc.m32() - this.m32, d2, this.m32);
        matrix4x3d.properties = this.properties & matrix4x3dc.properties();
        return matrix4x3d;
    }

    public Matrix4x3d rotateTowards(Vector3dc vector3dc, Vector3dc vector3dc2, Matrix4x3d matrix4x3d) {
        return this.rotateTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix4x3d);
    }

    public Matrix4x3d rotateTowards(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotateTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    public Matrix4x3d rotateTowards(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.rotateTowards(d2, d3, d4, d5, d6, d7, this);
    }

    public Matrix4x3d rotateTowards(double d2, double d3, double d4, double d5, double d6, double d7, Matrix4x3d matrix4x3d) {
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d2 * d11;
        double d13 = d3 * d11;
        double d14 = d4 * d11;
        double d15 = d6 * d14 - d7 * d13;
        double d16 = d7 * d12 - d5 * d14;
        double d17 = d5 * d13 - d6 * d12;
        double d18 = d15;
        double d19 = d16;
        double d20 = d17;
        double d21 = Math.invsqrt(d18 * d18 + d19 * d19 + d20 * d20);
        double d22 = d13 * (d17 *= d21) - d14 * (d16 *= d21);
        double d23 = d14 * (d15 *= d21) - d12 * d17;
        double d24 = d12 * d16 - d13 * d15;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        double d25 = this.m00 * d15 + this.m10 * d16 + this.m20 * d17;
        double d26 = this.m01 * d15 + this.m11 * d16 + this.m21 * d17;
        double d27 = this.m02 * d15 + this.m12 * d16 + this.m22 * d17;
        double d28 = this.m00 * d22 + this.m10 * d23 + this.m20 * d24;
        double d29 = this.m01 * d22 + this.m11 * d23 + this.m21 * d24;
        double d30 = this.m02 * d22 + this.m12 * d23 + this.m22 * d24;
        matrix4x3d.m20 = this.m00 * d12 + this.m10 * d13 + this.m20 * d14;
        matrix4x3d.m21 = this.m01 * d12 + this.m11 * d13 + this.m21 * d14;
        matrix4x3d.m22 = this.m02 * d12 + this.m12 * d13 + this.m22 * d14;
        matrix4x3d.m00 = d25;
        matrix4x3d.m01 = d26;
        matrix4x3d.m02 = d27;
        matrix4x3d.m10 = d28;
        matrix4x3d.m11 = d29;
        matrix4x3d.m12 = d30;
        matrix4x3d.properties = this.properties & 0xFFFFFFF3;
        return matrix4x3d;
    }

    public Matrix4x3d rotationTowards(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotationTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix4x3d rotationTowards(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d2 * d11;
        double d13 = d3 * d11;
        double d14 = d4 * d11;
        double d15 = d6 * d14 - d7 * d13;
        double d16 = d7 * d12 - d5 * d14;
        double d17 = d5 * d13 - d6 * d12;
        double d18 = d15;
        double d19 = d16;
        double d20 = d17;
        double d21 = Math.invsqrt(d18 * d18 + d19 * d19 + d20 * d20);
        double d22 = d13 * (d17 *= d21) - d14 * (d16 *= d21);
        double d23 = d14 * (d15 *= d21) - d12 * d17;
        double d24 = d12 * d16 - d13 * d15;
        this.m00 = d15;
        this.m01 = d16;
        this.m02 = d17;
        this.m10 = d22;
        this.m11 = d23;
        this.m12 = d24;
        this.m20 = d12;
        this.m21 = d13;
        this.m22 = d14;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.properties = 16;
        return this;
    }

    public Matrix4x3d translationRotateTowards(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        return this.translationRotateTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z());
    }

    public Matrix4x3d translationRotateTowards(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d5;
        double d12 = d6;
        double d13 = d7;
        double d14 = Math.invsqrt(d11 * d11 + d12 * d12 + d13 * d13);
        double d15 = d5 * d14;
        double d16 = d6 * d14;
        double d17 = d7 * d14;
        double d18 = d9 * d17 - d10 * d16;
        double d19 = d10 * d15 - d8 * d17;
        double d20 = d8 * d16 - d9 * d15;
        double d21 = d18;
        double d22 = d19;
        double d23 = d20;
        double d24 = Math.invsqrt(d21 * d21 + d22 * d22 + d23 * d23);
        double d25 = d16 * (d20 *= d24) - d17 * (d19 *= d24);
        double d26 = d17 * (d18 *= d24) - d15 * d20;
        double d27 = d15 * d19 - d16 * d18;
        this.m00 = d18;
        this.m01 = d19;
        this.m02 = d20;
        this.m10 = d25;
        this.m11 = d26;
        this.m12 = d27;
        this.m20 = d15;
        this.m21 = d16;
        this.m22 = d17;
        this.m30 = d2;
        this.m31 = d3;
        this.m32 = d4;
        this.properties = 16;
        return this;
    }

    public Vector3d getEulerAnglesZYX(Vector3d vector3d) {
        vector3d.x = Math.atan2(this.m12, this.m22);
        vector3d.y = Math.atan2(-this.m02, Math.sqrt(1.0 - this.m02 * this.m02));
        vector3d.z = Math.atan2(this.m01, this.m00);
        return vector3d;
    }

    public Vector3d getEulerAnglesXYZ(Vector3d vector3d) {
        vector3d.x = Math.atan2(-this.m21, this.m22);
        vector3d.y = Math.atan2(this.m20, Math.sqrt(1.0 - this.m20 * this.m20));
        vector3d.z = Math.atan2(-this.m10, this.m00);
        return vector3d;
    }

    public Vector3d getEulerAnglesYXZ(Vector3d vector3d) {
        vector3d.x = Math.atan2(-this.m21, Math.sqrt(1.0 - this.m21 * this.m21));
        vector3d.y = Math.atan2(this.m20, this.m22);
        vector3d.z = Math.atan2(this.m01, this.m11);
        return vector3d;
    }

    public Matrix4x3d obliqueZ(double d2, double d3) {
        this.m20 = this.m00 * d2 + this.m10 * d3 + this.m20;
        this.m21 = this.m01 * d2 + this.m11 * d3 + this.m21;
        this.m22 = this.m02 * d2 + this.m12 * d3 + this.m22;
        this.properties = 0;
        return this;
    }

    public Matrix4x3d obliqueZ(double d2, double d3, Matrix4x3d matrix4x3d) {
        matrix4x3d.m00 = this.m00;
        matrix4x3d.m01 = this.m01;
        matrix4x3d.m02 = this.m02;
        matrix4x3d.m10 = this.m10;
        matrix4x3d.m11 = this.m11;
        matrix4x3d.m12 = this.m12;
        matrix4x3d.m20 = this.m00 * d2 + this.m10 * d3 + this.m20;
        matrix4x3d.m21 = this.m01 * d2 + this.m11 * d3 + this.m21;
        matrix4x3d.m22 = this.m02 * d2 + this.m12 * d3 + this.m22;
        matrix4x3d.m30 = this.m30;
        matrix4x3d.m31 = this.m31;
        matrix4x3d.m32 = this.m32;
        matrix4x3d.properties = 0;
        return matrix4x3d;
    }

    public Matrix4x3d mapXZY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapXZY(matrix4x3d);
    }

    public Matrix4x3d mapXZY(Matrix4x3d matrix4x3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix4x3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapXZnY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapXZnY(matrix4x3d);
    }

    public Matrix4x3d mapXZnY(Matrix4x3d matrix4x3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix4x3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapXnYnZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapXnYnZ(matrix4x3d);
    }

    public Matrix4x3d mapXnYnZ(Matrix4x3d matrix4x3d) {
        return matrix4x3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapXnZY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapXnZY(matrix4x3d);
    }

    public Matrix4x3d mapXnZY(Matrix4x3d matrix4x3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix4x3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapXnZnY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapXnZnY(matrix4x3d);
    }

    public Matrix4x3d mapXnZnY(Matrix4x3d matrix4x3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix4x3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapYXZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapYXZ(matrix4x3d);
    }

    public Matrix4x3d mapYXZ(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(d2)._m11(d3)._m12(d4)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapYXnZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapYXnZ(matrix4x3d);
    }

    public Matrix4x3d mapYXnZ(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(d2)._m11(d3)._m12(d4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapYZX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapYZX(matrix4x3d);
    }

    public Matrix4x3d mapYZX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapYZnX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapYZnX(matrix4x3d);
    }

    public Matrix4x3d mapYZnX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapYnXZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapYnXZ(matrix4x3d);
    }

    public Matrix4x3d mapYnXZ(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-d2)._m11(-d3)._m12(-d4)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapYnXnZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapYnXnZ(matrix4x3d);
    }

    public Matrix4x3d mapYnXnZ(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-d2)._m11(-d3)._m12(-d4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapYnZX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapYnZX(matrix4x3d);
    }

    public Matrix4x3d mapYnZX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapYnZnX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapYnZnX(matrix4x3d);
    }

    public Matrix4x3d mapYnZnX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapZXY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapZXY(matrix4x3d);
    }

    public Matrix4x3d mapZXY(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix4x3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(d2)._m11(d3)._m12(d4)._m20(d5)._m21(d6)._m22(d7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapZXnY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapZXnY(matrix4x3d);
    }

    public Matrix4x3d mapZXnY(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix4x3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(d2)._m11(d3)._m12(d4)._m20(-d5)._m21(-d6)._m22(-d7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapZYX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapZYX(matrix4x3d);
    }

    public Matrix4x3d mapZYX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapZYnX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapZYnX(matrix4x3d);
    }

    public Matrix4x3d mapZYnX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapZnXY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapZnXY(matrix4x3d);
    }

    public Matrix4x3d mapZnXY(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix4x3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-d2)._m11(-d3)._m12(-d4)._m20(d5)._m21(d6)._m22(d7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapZnXnY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapZnXnY(matrix4x3d);
    }

    public Matrix4x3d mapZnXnY(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix4x3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-d2)._m11(-d3)._m12(-d4)._m20(-d5)._m21(-d6)._m22(-d7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapZnYX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapZnYX(matrix4x3d);
    }

    public Matrix4x3d mapZnYX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapZnYnX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapZnYnX(matrix4x3d);
    }

    public Matrix4x3d mapZnYnX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnXYnZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnXYnZ(matrix4x3d);
    }

    public Matrix4x3d mapnXYnZ(Matrix4x3d matrix4x3d) {
        return matrix4x3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnXZY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnXZY(matrix4x3d);
    }

    public Matrix4x3d mapnXZY(Matrix4x3d matrix4x3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix4x3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnXZnY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnXZnY(matrix4x3d);
    }

    public Matrix4x3d mapnXZnY(Matrix4x3d matrix4x3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix4x3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnXnYZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnXnYZ(matrix4x3d);
    }

    public Matrix4x3d mapnXnYZ(Matrix4x3d matrix4x3d) {
        return matrix4x3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnXnYnZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnXnYnZ(matrix4x3d);
    }

    public Matrix4x3d mapnXnYnZ(Matrix4x3d matrix4x3d) {
        return matrix4x3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnXnZY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnXnZY(matrix4x3d);
    }

    public Matrix4x3d mapnXnZY(Matrix4x3d matrix4x3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix4x3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnXnZnY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnXnZnY(matrix4x3d);
    }

    public Matrix4x3d mapnXnZnY(Matrix4x3d matrix4x3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix4x3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnYXZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnYXZ(matrix4x3d);
    }

    public Matrix4x3d mapnYXZ(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(d2)._m11(d3)._m12(d4)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnYXnZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnYXnZ(matrix4x3d);
    }

    public Matrix4x3d mapnYXnZ(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(d2)._m11(d3)._m12(d4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnYZX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnYZX(matrix4x3d);
    }

    public Matrix4x3d mapnYZX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnYZnX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnYZnX(matrix4x3d);
    }

    public Matrix4x3d mapnYZnX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnYnXZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnYnXZ(matrix4x3d);
    }

    public Matrix4x3d mapnYnXZ(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-d2)._m11(-d3)._m12(-d4)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnYnXnZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnYnXnZ(matrix4x3d);
    }

    public Matrix4x3d mapnYnXnZ(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-d2)._m11(-d3)._m12(-d4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnYnZX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnYnZX(matrix4x3d);
    }

    public Matrix4x3d mapnYnZX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnYnZnX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnYnZnX(matrix4x3d);
    }

    public Matrix4x3d mapnYnZnX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnZXY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnZXY(matrix4x3d);
    }

    public Matrix4x3d mapnZXY(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix4x3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(d2)._m11(d3)._m12(d4)._m20(d5)._m21(d6)._m22(d7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnZXnY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnZXnY(matrix4x3d);
    }

    public Matrix4x3d mapnZXnY(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix4x3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(d2)._m11(d3)._m12(d4)._m20(-d5)._m21(-d6)._m22(-d7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnZYX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnZYX(matrix4x3d);
    }

    public Matrix4x3d mapnZYX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnZYnX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnZYnX(matrix4x3d);
    }

    public Matrix4x3d mapnZYnX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnZnXY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnZnXY(matrix4x3d);
    }

    public Matrix4x3d mapnZnXY(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix4x3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-d2)._m11(-d3)._m12(-d4)._m20(d5)._m21(d6)._m22(d7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnZnXnY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnZnXnY(matrix4x3d);
    }

    public Matrix4x3d mapnZnXnY(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix4x3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-d2)._m11(-d3)._m12(-d4)._m20(-d5)._m21(-d6)._m22(-d7)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnZnYX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnZnYX(matrix4x3d);
    }

    public Matrix4x3d mapnZnYX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(d2)._m21(d3)._m22(d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d mapnZnYnX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d.mapnZnYnX(matrix4x3d);
    }

    public Matrix4x3d mapnZnYnX(Matrix4x3d matrix4x3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix4x3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-d2)._m21(-d3)._m22(-d4)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d negateX() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d._m00(-matrix4x3d.m00)._m01(-this.m01)._m02(-this.m02)._properties(this.properties & 0x10);
    }

    public Matrix4x3d negateX(Matrix4x3d matrix4x3d) {
        return matrix4x3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d negateY() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d._m10(-matrix4x3d.m10)._m11(-this.m11)._m12(-this.m12)._properties(this.properties & 0x10);
    }

    public Matrix4x3d negateY(Matrix4x3d matrix4x3d) {
        return matrix4x3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public Matrix4x3d negateZ() {
        Matrix4x3d matrix4x3d = this;
        return matrix4x3d._m20(-matrix4x3d.m20)._m21(-this.m21)._m22(-this.m22)._properties(this.properties & 0x10);
    }

    public Matrix4x3d negateZ(Matrix4x3d matrix4x3d) {
        return matrix4x3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22)._m30(this.m30)._m31(this.m31)._m32(this.m32)._properties(this.properties & 0x10);
    }

    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m02) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m12) && Math.isFinite(this.m20) && Math.isFinite(this.m21) && Math.isFinite(this.m22) && Math.isFinite(this.m30) && Math.isFinite(this.m31) && Math.isFinite(this.m32);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

