/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.joml.Matrix3x2f;

public class Matrix3x2fStack
extends Matrix3x2f {
    private static final long serialVersionUID = 1L;
    private Matrix3x2f[] mats;
    private int curr;

    public Matrix3x2fStack(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("stackSize must be >= 1");
        }
        this.mats = new Matrix3x2f[n2 - 1];
        for (n2 = 0; n2 < this.mats.length; ++n2) {
            this.mats[n2] = new Matrix3x2f();
        }
    }

    public Matrix3x2fStack() {
    }

    public Matrix3x2fStack clear() {
        this.curr = 0;
        this.identity();
        return this;
    }

    public Matrix3x2fStack pushMatrix() {
        if (this.curr == this.mats.length) {
            throw new IllegalStateException("max stack size of " + (this.curr + 1) + " reached");
        }
        this.mats[this.curr++].set(this);
        return this;
    }

    public Matrix3x2fStack popMatrix() {
        if (this.curr == 0) {
            throw new IllegalStateException("already at the bottom of the stack");
        }
        Matrix3x2fStack matrix3x2fStack = this;
        matrix3x2fStack.set(matrix3x2fStack.mats[--this.curr]);
        return this;
    }

    public int hashCode() {
        int n2 = super.hashCode() * 31 + this.curr;
        for (int i2 = 0; i2 < this.curr; ++i2) {
            n2 = n2 * 31 + this.mats[i2].hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof Matrix3x2fStack) {
            object = (Matrix3x2fStack)object;
            if (this.curr != ((Matrix3x2fStack)object).curr) {
                return false;
            }
            for (int i2 = 0; i2 < this.curr; ++i2) {
                if (this.mats[i2].equals(((Matrix3x2fStack)object).mats[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.curr);
        for (int i2 = 0; i2 < this.curr; ++i2) {
            objectOutput.writeObject(this.mats[i2]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        super.readExternal(objectInput);
        this.curr = objectInput.readInt();
        this.mats = new Matrix3x2fStack[this.curr];
        for (int i2 = 0; i2 < this.curr; ++i2) {
            Matrix3x2f matrix3x2f = new Matrix3x2f();
            matrix3x2f.readExternal(objectInput);
            this.mats[i2] = matrix3x2f;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Matrix3x2fStack matrix3x2fStack = (Matrix3x2fStack)super.clone();
        Matrix3x2f[] matrix3x2fArray = new Matrix3x2f[this.mats.length];
        for (int i2 = 0; i2 < this.mats.length; ++i2) {
            matrix3x2fArray[i2] = (Matrix3x2f)this.mats[i2].clone();
        }
        matrix3x2fStack.mats = matrix3x2fArray;
        return matrix3x2fStack;
    }
}

