/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.joml.Matrix3f;

public class Matrix3fStack
extends Matrix3f {
    private static final long serialVersionUID = 1L;
    private Matrix3f[] mats;
    private int curr;

    public Matrix3fStack(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("stackSize must be >= 1");
        }
        this.mats = new Matrix3f[n2 - 1];
        for (n2 = 0; n2 < this.mats.length; ++n2) {
            this.mats[n2] = new Matrix3f();
        }
    }

    public Matrix3fStack() {
    }

    public Matrix3fStack clear() {
        this.curr = 0;
        this.identity();
        return this;
    }

    public Matrix3fStack pushMatrix() {
        if (this.curr == this.mats.length) {
            throw new IllegalStateException("max stack size of " + (this.curr + 1) + " reached");
        }
        this.mats[this.curr++].set(this);
        return this;
    }

    public Matrix3fStack popMatrix() {
        if (this.curr == 0) {
            throw new IllegalStateException("already at the bottom of the stack");
        }
        Matrix3fStack matrix3fStack = this;
        matrix3fStack.set(matrix3fStack.mats[--this.curr]);
        return this;
    }

    public int hashCode() {
        int n2 = super.hashCode() * 31 + this.curr;
        for (int i2 = 0; i2 < this.curr; ++i2) {
            n2 = n2 * 31 + this.mats[i2].hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof Matrix3fStack) {
            object = (Matrix3fStack)object;
            if (this.curr != ((Matrix3fStack)object).curr) {
                return false;
            }
            for (int i2 = 0; i2 < this.curr; ++i2) {
                if (this.mats[i2].equals(((Matrix3fStack)object).mats[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.curr);
        for (int i2 = 0; i2 < this.curr; ++i2) {
            objectOutput.writeObject(this.mats[i2]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        super.readExternal(objectInput);
        this.curr = objectInput.readInt();
        this.mats = new Matrix3fStack[this.curr];
        for (int i2 = 0; i2 < this.curr; ++i2) {
            Matrix3f matrix3f = new Matrix3f();
            matrix3f.readExternal(objectInput);
            this.mats[i2] = matrix3f;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Matrix3fStack matrix3fStack = (Matrix3fStack)super.clone();
        Matrix3f[] matrix3fArray = new Matrix3f[this.mats.length];
        for (int i2 = 0; i2 < this.mats.length; ++i2) {
            matrix3fArray[i2] = (Matrix3f)this.mats[i2].clone();
        }
        matrix3fStack.mats = matrix3fArray;
        return matrix3fStack;
    }
}

