/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix2fc;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Matrix3f
implements Externalizable,
Cloneable,
Matrix3fc {
    private static final long serialVersionUID = 1L;
    public float m00;
    public float m01;
    public float m02;
    public float m10;
    public float m11;
    public float m12;
    public float m20;
    public float m21;
    public float m22;

    public Matrix3f() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
        this.m22 = 1.0f;
    }

    public Matrix3f(Matrix2fc matrix2fc) {
        this.set(matrix2fc);
    }

    public Matrix3f(Matrix3fc matrix3fc) {
        this.set(matrix3fc);
    }

    public Matrix3f(Matrix4fc matrix4fc) {
        this.set(matrix4fc);
    }

    public Matrix3f(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.m00 = f2;
        this.m01 = f3;
        this.m02 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m20 = f8;
        this.m21 = f9;
        this.m22 = f10;
    }

    public Matrix3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
    }

    public Matrix3f(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        this.set(vector3fc, vector3fc2, vector3fc3);
    }

    public float m00() {
        return this.m00;
    }

    public float m01() {
        return this.m01;
    }

    public float m02() {
        return this.m02;
    }

    public float m10() {
        return this.m10;
    }

    public float m11() {
        return this.m11;
    }

    public float m12() {
        return this.m12;
    }

    public float m20() {
        return this.m20;
    }

    public float m21() {
        return this.m21;
    }

    public float m22() {
        return this.m22;
    }

    public Matrix3f m00(float f2) {
        this.m00 = f2;
        return this;
    }

    public Matrix3f m01(float f2) {
        this.m01 = f2;
        return this;
    }

    public Matrix3f m02(float f2) {
        this.m02 = f2;
        return this;
    }

    public Matrix3f m10(float f2) {
        this.m10 = f2;
        return this;
    }

    public Matrix3f m11(float f2) {
        this.m11 = f2;
        return this;
    }

    public Matrix3f m12(float f2) {
        this.m12 = f2;
        return this;
    }

    public Matrix3f m20(float f2) {
        this.m20 = f2;
        return this;
    }

    public Matrix3f m21(float f2) {
        this.m21 = f2;
        return this;
    }

    public Matrix3f m22(float f2) {
        this.m22 = f2;
        return this;
    }

    Matrix3f _m00(float f2) {
        this.m00 = f2;
        return this;
    }

    Matrix3f _m01(float f2) {
        this.m01 = f2;
        return this;
    }

    Matrix3f _m02(float f2) {
        this.m02 = f2;
        return this;
    }

    Matrix3f _m10(float f2) {
        this.m10 = f2;
        return this;
    }

    Matrix3f _m11(float f2) {
        this.m11 = f2;
        return this;
    }

    Matrix3f _m12(float f2) {
        this.m12 = f2;
        return this;
    }

    Matrix3f _m20(float f2) {
        this.m20 = f2;
        return this;
    }

    Matrix3f _m21(float f2) {
        this.m21 = f2;
        return this;
    }

    Matrix3f _m22(float f2) {
        this.m22 = f2;
        return this;
    }

    public Matrix3f set(Matrix3fc matrix3fc) {
        if (matrix3fc == this) {
            return this;
        }
        return this._m00(matrix3fc.m00())._m01(matrix3fc.m01())._m02(matrix3fc.m02())._m10(matrix3fc.m10())._m11(matrix3fc.m11())._m12(matrix3fc.m12())._m20(matrix3fc.m20())._m21(matrix3fc.m21())._m22(matrix3fc.m22());
    }

    public Matrix3f setTransposed(Matrix3fc matrix3fc) {
        float f2 = matrix3fc.m01();
        float f3 = matrix3fc.m21();
        float f4 = matrix3fc.m02();
        float f5 = matrix3fc.m12();
        return this._m00(matrix3fc.m00())._m01(matrix3fc.m10())._m02(matrix3fc.m20())._m10(f2)._m11(matrix3fc.m11())._m12(f3)._m20(f4)._m21(f5)._m22(matrix3fc.m22());
    }

    public Matrix3f set(Matrix4x3fc matrix4x3fc) {
        this.m00 = matrix4x3fc.m00();
        this.m01 = matrix4x3fc.m01();
        this.m02 = matrix4x3fc.m02();
        this.m10 = matrix4x3fc.m10();
        this.m11 = matrix4x3fc.m11();
        this.m12 = matrix4x3fc.m12();
        this.m20 = matrix4x3fc.m20();
        this.m21 = matrix4x3fc.m21();
        this.m22 = matrix4x3fc.m22();
        return this;
    }

    public Matrix3f set(Matrix4fc matrix4fc) {
        this.m00 = matrix4fc.m00();
        this.m01 = matrix4fc.m01();
        this.m02 = matrix4fc.m02();
        this.m10 = matrix4fc.m10();
        this.m11 = matrix4fc.m11();
        this.m12 = matrix4fc.m12();
        this.m20 = matrix4fc.m20();
        this.m21 = matrix4fc.m21();
        this.m22 = matrix4fc.m22();
        return this;
    }

    public Matrix3f set(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m02 = 0.0f;
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f set(AxisAngle4f axisAngle4f) {
        float f2 = axisAngle4f.x;
        float f3 = axisAngle4f.y;
        float f4 = axisAngle4f.z;
        float f5 = axisAngle4f.angle;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        float f9 = Math.invsqrt(f6 * f6 + f7 * f7 + f8 * f8);
        f2 *= f9;
        f3 *= f9;
        f4 *= f9;
        f9 = Math.sin(f5);
        f5 = Math.cosFromSin(f9, f5);
        float f10 = 1.0f - f5;
        float f11 = f2;
        this.m00 = f5 + f11 * f11 * f10;
        float f12 = f3;
        this.m11 = f5 + f12 * f12 * f10;
        float f13 = f4;
        this.m22 = f5 + f13 * f13 * f10;
        f5 = f2 * f3 * f10;
        float f14 = f4 * f9;
        this.m10 = f5 - f14;
        this.m01 = f5 + f14;
        f5 = f2 * f4 * f10;
        f14 = f3 * f9;
        this.m20 = f5 + f14;
        this.m02 = f5 - f14;
        f5 = f3 * f4 * f10;
        f14 = f2 * f9;
        this.m21 = f5 - f14;
        this.m12 = f5 + f14;
        return this;
    }

    public Matrix3f set(AxisAngle4d axisAngle4d) {
        double d2 = axisAngle4d.x;
        double d3 = axisAngle4d.y;
        double d4 = axisAngle4d.z;
        double d5 = axisAngle4d.angle;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = Math.invsqrt(d6 * d6 + d7 * d7 + d8 * d8);
        d2 *= d9;
        d3 *= d9;
        d4 *= d9;
        double d10 = Math.sin(d5);
        double d11 = Math.cosFromSin(d10, d5);
        double d12 = 1.0 - d11;
        double d13 = d2;
        this.m00 = (float)(d11 + d13 * d13 * d12);
        double d14 = d3;
        this.m11 = (float)(d11 + d14 * d14 * d12);
        double d15 = d4;
        this.m22 = (float)(d11 + d15 * d15 * d12);
        double d16 = d2 * d3 * d12;
        double d17 = d4 * d10;
        this.m10 = (float)(d16 - d17);
        this.m01 = (float)(d16 + d17);
        d16 = d2 * d4 * d12;
        d17 = d3 * d10;
        this.m20 = (float)(d16 + d17);
        this.m02 = (float)(d16 - d17);
        d16 = d3 * d4 * d12;
        d17 = d2 * d10;
        this.m21 = (float)(d16 - d17);
        this.m12 = (float)(d16 + d17);
        return this;
    }

    public Matrix3f set(Quaternionfc quaternionfc) {
        return this.rotation(quaternionfc);
    }

    public Matrix3f set(Quaterniondc quaterniondc) {
        double d2 = quaterniondc.w() * quaterniondc.w();
        double d3 = quaterniondc.x() * quaterniondc.x();
        double d4 = quaterniondc.y() * quaterniondc.y();
        double d5 = quaterniondc.z() * quaterniondc.z();
        double d6 = quaterniondc.z() * quaterniondc.w();
        double d7 = quaterniondc.x() * quaterniondc.y();
        double d8 = quaterniondc.x() * quaterniondc.z();
        double d9 = quaterniondc.y() * quaterniondc.w();
        double d10 = quaterniondc.y() * quaterniondc.z();
        double d11 = quaterniondc.x() * quaterniondc.w();
        this.m00 = (float)(d2 + d3 - d5 - d4);
        this.m01 = (float)(d7 + d6 + d6 + d7);
        this.m02 = (float)(d8 - d9 + d8 - d9);
        this.m10 = (float)(-d6 + d7 - d6 + d7);
        this.m11 = (float)(d4 - d5 + d2 - d3);
        double d12 = d10;
        this.m12 = (float)(d12 + d12 + d11 + d11);
        this.m20 = (float)(d9 + d8 + d8 + d9);
        double d13 = d10;
        this.m21 = (float)(d13 + d13 - d11 - d11);
        this.m22 = (float)(d5 - d4 - d3 + d2);
        return this;
    }

    public Matrix3f mul(Matrix3fc matrix3fc) {
        return this.mul(matrix3fc, this);
    }

    public Matrix3f mul(Matrix3fc matrix3fc, Matrix3f matrix3f) {
        float f2 = Math.fma(this.m00, matrix3fc.m00(), Math.fma(this.m10, matrix3fc.m01(), this.m20 * matrix3fc.m02()));
        float f3 = Math.fma(this.m01, matrix3fc.m00(), Math.fma(this.m11, matrix3fc.m01(), this.m21 * matrix3fc.m02()));
        float f4 = Math.fma(this.m02, matrix3fc.m00(), Math.fma(this.m12, matrix3fc.m01(), this.m22 * matrix3fc.m02()));
        float f5 = Math.fma(this.m00, matrix3fc.m10(), Math.fma(this.m10, matrix3fc.m11(), this.m20 * matrix3fc.m12()));
        float f6 = Math.fma(this.m01, matrix3fc.m10(), Math.fma(this.m11, matrix3fc.m11(), this.m21 * matrix3fc.m12()));
        float f7 = Math.fma(this.m02, matrix3fc.m10(), Math.fma(this.m12, matrix3fc.m11(), this.m22 * matrix3fc.m12()));
        float f8 = Math.fma(this.m00, matrix3fc.m20(), Math.fma(this.m10, matrix3fc.m21(), this.m20 * matrix3fc.m22()));
        float f9 = Math.fma(this.m01, matrix3fc.m20(), Math.fma(this.m11, matrix3fc.m21(), this.m21 * matrix3fc.m22()));
        float f10 = Math.fma(this.m02, matrix3fc.m20(), Math.fma(this.m12, matrix3fc.m21(), this.m22 * matrix3fc.m22()));
        matrix3f.m00 = f2;
        matrix3f.m01 = f3;
        matrix3f.m02 = f4;
        matrix3f.m10 = f5;
        matrix3f.m11 = f6;
        matrix3f.m12 = f7;
        matrix3f.m20 = f8;
        matrix3f.m21 = f9;
        matrix3f.m22 = f10;
        return matrix3f;
    }

    public Matrix3f mulLocal(Matrix3fc matrix3fc) {
        return this.mulLocal(matrix3fc, this);
    }

    public Matrix3f mulLocal(Matrix3fc matrix3fc, Matrix3f matrix3f) {
        float f2 = matrix3fc.m00() * this.m00 + matrix3fc.m10() * this.m01 + matrix3fc.m20() * this.m02;
        float f3 = matrix3fc.m01() * this.m00 + matrix3fc.m11() * this.m01 + matrix3fc.m21() * this.m02;
        float f4 = matrix3fc.m02() * this.m00 + matrix3fc.m12() * this.m01 + matrix3fc.m22() * this.m02;
        float f5 = matrix3fc.m00() * this.m10 + matrix3fc.m10() * this.m11 + matrix3fc.m20() * this.m12;
        float f6 = matrix3fc.m01() * this.m10 + matrix3fc.m11() * this.m11 + matrix3fc.m21() * this.m12;
        float f7 = matrix3fc.m02() * this.m10 + matrix3fc.m12() * this.m11 + matrix3fc.m22() * this.m12;
        float f8 = matrix3fc.m00() * this.m20 + matrix3fc.m10() * this.m21 + matrix3fc.m20() * this.m22;
        float f9 = matrix3fc.m01() * this.m20 + matrix3fc.m11() * this.m21 + matrix3fc.m21() * this.m22;
        float f10 = matrix3fc.m02() * this.m20 + matrix3fc.m12() * this.m21 + matrix3fc.m22() * this.m22;
        matrix3f.m00 = f2;
        matrix3f.m01 = f3;
        matrix3f.m02 = f4;
        matrix3f.m10 = f5;
        matrix3f.m11 = f6;
        matrix3f.m12 = f7;
        matrix3f.m20 = f8;
        matrix3f.m21 = f9;
        matrix3f.m22 = f10;
        return matrix3f;
    }

    public Matrix3f set(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.m00 = f2;
        this.m01 = f3;
        this.m02 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m20 = f8;
        this.m21 = f9;
        this.m22 = f10;
        return this;
    }

    public Matrix3f set(float[] fArray) {
        return this.set(fArray, 0);
    }

    public Matrix3f set(float[] fArray, int n2) {
        MemUtil.INSTANCE.copy(fArray, n2, this);
        return this;
    }

    public Matrix3f set(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3) {
        this.m00 = vector3fc.x();
        this.m01 = vector3fc.y();
        this.m02 = vector3fc.z();
        this.m10 = vector3fc2.x();
        this.m11 = vector3fc2.y();
        this.m12 = vector3fc2.z();
        this.m20 = vector3fc3.x();
        this.m21 = vector3fc3.y();
        this.m22 = vector3fc3.z();
        return this;
    }

    public float determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Matrix3f invert() {
        Matrix3f matrix3f = this;
        return matrix3f.invert(matrix3f);
    }

    public Matrix3f invert(Matrix3f matrix3f) {
        float f2 = Math.fma(this.m00, this.m11, -this.m01 * this.m10);
        float f3 = Math.fma(this.m02, this.m10, -this.m00 * this.m12);
        float f4 = Math.fma(this.m01, this.m12, -this.m02 * this.m11);
        float f5 = Math.fma(f2, this.m22, Math.fma(f3, this.m21, f4 * this.m20));
        f5 = 1.0f / f5;
        float f6 = Math.fma(this.m11, this.m22, -this.m21 * this.m12) * f5;
        float f7 = Math.fma(this.m21, this.m02, -this.m01 * this.m22) * f5;
        f4 *= f5;
        float f8 = Math.fma(this.m20, this.m12, -this.m10 * this.m22) * f5;
        float f9 = Math.fma(this.m00, this.m22, -this.m20 * this.m02) * f5;
        f3 *= f5;
        float f10 = Math.fma(this.m10, this.m21, -this.m20 * this.m11) * f5;
        float f11 = Math.fma(this.m20, this.m01, -this.m00 * this.m21) * f5;
        f2 *= f5;
        matrix3f.m00 = f6;
        matrix3f.m01 = f7;
        matrix3f.m02 = f4;
        matrix3f.m10 = f8;
        matrix3f.m11 = f9;
        matrix3f.m12 = f3;
        matrix3f.m20 = f10;
        matrix3f.m21 = f11;
        matrix3f.m22 = f2;
        return matrix3f;
    }

    public Matrix3f transpose() {
        Matrix3f matrix3f = this;
        return matrix3f.transpose(matrix3f);
    }

    public Matrix3f transpose(Matrix3f matrix3f) {
        return matrix3f.set(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
    }

    public String toString() {
        String string = this.toString(Options.NUMBER_FORMAT);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == 'E') {
                n2 = i2;
            } else {
                if (c2 == ' ' && n2 == i2 - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c2) && n2 == i2 - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + "\n" + Runtime.format(this.m02, numberFormat) + " " + Runtime.format(this.m12, numberFormat) + " " + Runtime.format(this.m22, numberFormat) + "\n";
    }

    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    public AxisAngle4f getRotation(AxisAngle4f axisAngle4f) {
        return axisAngle4f.set(this);
    }

    public Quaternionf getUnnormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromUnnormalized(this);
    }

    public Quaternionf getNormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromNormalized(this);
    }

    public Quaterniond getUnnormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromUnnormalized(this);
    }

    public Quaterniond getNormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromNormalized(this);
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer get(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer get3x4(FloatBuffer floatBuffer) {
        return this.get3x4(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer get3x4(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put3x4(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get3x4(ByteBuffer byteBuffer) {
        return this.get3x4(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get3x4(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put3x4(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer getTransposed(FloatBuffer floatBuffer) {
        return this.getTransposed(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer getTransposed(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer getTransposed(ByteBuffer byteBuffer) {
        return this.getTransposed(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getTransposed(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Matrix3fc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Matrix3fc getTransposedToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.putTransposed(this, l2);
        return this;
    }

    public float[] get(float[] fArray, int n2) {
        MemUtil.INSTANCE.copy(this, fArray, n2);
        return fArray;
    }

    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    public Matrix3f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Matrix3f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Matrix3f set(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n2, floatBuffer);
        return this;
    }

    public Matrix3f set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Matrix3f setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l2);
        return this;
    }

    public Matrix3f setTransposedFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.getTransposed(this, l2);
        return this;
    }

    public Matrix3f zero() {
        MemUtil.INSTANCE.zero(this);
        return this;
    }

    public Matrix3f identity() {
        MemUtil.INSTANCE.identity(this);
        return this;
    }

    public Matrix3f scale(Vector3fc vector3fc, Matrix3f matrix3f) {
        return this.scale(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix3f);
    }

    public Matrix3f scale(Vector3fc vector3fc) {
        return this.scale(vector3fc.x(), vector3fc.y(), vector3fc.z(), this);
    }

    public Matrix3f scale(float f2, float f3, float f4, Matrix3f matrix3f) {
        matrix3f.m00 = this.m00 * f2;
        matrix3f.m01 = this.m01 * f2;
        matrix3f.m02 = this.m02 * f2;
        matrix3f.m10 = this.m10 * f3;
        matrix3f.m11 = this.m11 * f3;
        matrix3f.m12 = this.m12 * f3;
        matrix3f.m20 = this.m20 * f4;
        matrix3f.m21 = this.m21 * f4;
        matrix3f.m22 = this.m22 * f4;
        return matrix3f;
    }

    public Matrix3f scale(float f2, float f3, float f4) {
        return this.scale(f2, f3, f4, this);
    }

    public Matrix3f scale(float f2, Matrix3f matrix3f) {
        float f3 = f2;
        return this.scale(f3, f3, f2, matrix3f);
    }

    public Matrix3f scale(float f2) {
        float f3 = f2;
        return this.scale(f3, f3, f2);
    }

    public Matrix3f scaleLocal(float f2, float f3, float f4, Matrix3f matrix3f) {
        float f5 = f2 * this.m00;
        float f6 = f3 * this.m01;
        float f7 = f4 * this.m02;
        float f8 = f2 * this.m10;
        float f9 = f3 * this.m11;
        float f10 = f4 * this.m12;
        f2 *= this.m20;
        f3 *= this.m21;
        f4 *= this.m22;
        matrix3f.m00 = f5;
        matrix3f.m01 = f6;
        matrix3f.m02 = f7;
        matrix3f.m10 = f8;
        matrix3f.m11 = f9;
        matrix3f.m12 = f10;
        matrix3f.m20 = f2;
        matrix3f.m21 = f3;
        matrix3f.m22 = f4;
        return matrix3f;
    }

    public Matrix3f scaleLocal(float f2, float f3, float f4) {
        return this.scaleLocal(f2, f3, f4, this);
    }

    public Matrix3f scaling(float f2) {
        MemUtil.INSTANCE.zero(this);
        this.m00 = f2;
        this.m11 = f2;
        this.m22 = f2;
        return this;
    }

    public Matrix3f scaling(float f2, float f3, float f4) {
        MemUtil.INSTANCE.zero(this);
        this.m00 = f2;
        this.m11 = f3;
        this.m22 = f4;
        return this;
    }

    public Matrix3f scaling(Vector3fc vector3fc) {
        return this.scaling(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f rotation(float f2, Vector3fc vector3fc) {
        return this.rotation(f2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f rotation(AxisAngle4f axisAngle4f) {
        return this.rotation(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix3f rotation(float f2, float f3, float f4, float f5) {
        float f6 = Math.sin(f2);
        f2 = Math.cosFromSin(f6, f2);
        float f7 = 1.0f - f2;
        float f8 = f3 * f4;
        float f9 = f3 * f5;
        float f10 = f4 * f5;
        float f11 = f3;
        this.m00 = f2 + f11 * f11 * f7;
        this.m10 = f8 * f7 - f5 * f6;
        this.m20 = f9 * f7 + f4 * f6;
        this.m01 = f8 * f7 + f5 * f6;
        float f12 = f4;
        this.m11 = f2 + f12 * f12 * f7;
        this.m21 = f10 * f7 - f3 * f6;
        this.m02 = f9 * f7 - f4 * f6;
        this.m12 = f10 * f7 + f3 * f6;
        float f13 = f5;
        this.m22 = f2 + f13 * f13 * f7;
        return this;
    }

    public Matrix3f rotationX(float f2) {
        float f3 = Math.sin(f2);
        f2 = Math.cosFromSin(f3, f2);
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f2;
        this.m12 = f3;
        this.m20 = 0.0f;
        this.m21 = -f3;
        this.m22 = f2;
        return this;
    }

    public Matrix3f rotationY(float f2) {
        float f3 = Math.sin(f2);
        this.m00 = f2 = Math.cosFromSin(f3, f2);
        this.m01 = 0.0f;
        this.m02 = -f3;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m20 = f3;
        this.m21 = 0.0f;
        this.m22 = f2;
        return this;
    }

    public Matrix3f rotationZ(float f2) {
        float f3 = Math.sin(f2);
        this.m00 = f2 = Math.cosFromSin(f3, f2);
        this.m01 = f3;
        this.m02 = 0.0f;
        this.m10 = -f3;
        this.m11 = f2;
        this.m12 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        return this;
    }

    public Matrix3f rotationXYZ(float f2, float f3, float f4) {
        float f5 = Math.sin(f2);
        f2 = Math.cosFromSin(f5, f2);
        float f6 = Math.sin(f3);
        f3 = Math.cosFromSin(f6, f3);
        float f7 = Math.sin(f4);
        f4 = Math.cosFromSin(f7, f4);
        float f8 = -f5;
        float f9 = -f6;
        float f10 = -f7;
        float f11 = f8 * f9;
        f9 = f2 * f9;
        this.m20 = f6;
        this.m21 = f8 * f3;
        this.m22 = f2 * f3;
        this.m00 = f3 * f4;
        this.m01 = f11 * f4 + f2 * f7;
        this.m02 = f9 * f4 + f5 * f7;
        this.m10 = f3 * f10;
        this.m11 = f11 * f10 + f2 * f4;
        this.m12 = f9 * f10 + f5 * f4;
        return this;
    }

    public Matrix3f rotationZYX(float f2, float f3, float f4) {
        float f5 = Math.sin(f4);
        f4 = Math.cosFromSin(f5, f4);
        float f6 = Math.sin(f3);
        f3 = Math.cosFromSin(f6, f3);
        float f7 = Math.sin(f2);
        f2 = Math.cosFromSin(f7, f2);
        float f8 = -f7;
        float f9 = -f6;
        float f10 = -f5;
        float f11 = f2 * f6;
        f6 = f7 * f6;
        this.m00 = f2 * f3;
        this.m01 = f7 * f3;
        this.m02 = f9;
        this.m10 = f8 * f4 + f11 * f5;
        this.m11 = f2 * f4 + f6 * f5;
        this.m12 = f3 * f5;
        this.m20 = f8 * f10 + f11 * f4;
        this.m21 = f2 * f10 + f6 * f4;
        this.m22 = f3 * f4;
        return this;
    }

    public Matrix3f rotationYXZ(float f2, float f3, float f4) {
        float f5 = Math.sin(f3);
        f3 = Math.cosFromSin(f5, f3);
        float f6 = Math.sin(f2);
        f2 = Math.cosFromSin(f6, f2);
        float f7 = Math.sin(f4);
        f4 = Math.cosFromSin(f7, f4);
        float f8 = -f6;
        float f9 = -f5;
        float f10 = -f7;
        float f11 = f6 * f5;
        f5 = f2 * f5;
        this.m20 = f6 * f3;
        this.m21 = f9;
        this.m22 = f2 * f3;
        this.m00 = f2 * f4 + f11 * f7;
        this.m01 = f3 * f7;
        this.m02 = f8 * f4 + f5 * f7;
        this.m10 = f2 * f10 + f11 * f4;
        this.m11 = f3 * f4;
        this.m12 = f8 * f10 + f5 * f4;
        return this;
    }

    public Matrix3f rotation(Quaternionfc quaternionfc) {
        float f2 = quaternionfc.w() * quaternionfc.w();
        float f3 = quaternionfc.x() * quaternionfc.x();
        float f4 = quaternionfc.y() * quaternionfc.y();
        float f5 = quaternionfc.z() * quaternionfc.z();
        float f6 = quaternionfc.z() * quaternionfc.w();
        float f7 = f6 + f6;
        float f8 = quaternionfc.x() * quaternionfc.y();
        float f9 = f8 + f8;
        float f10 = quaternionfc.x() * quaternionfc.z();
        float f11 = f10 + f10;
        float f12 = quaternionfc.y() * quaternionfc.w();
        float f13 = f12 + f12;
        float f14 = quaternionfc.y() * quaternionfc.z();
        float f15 = f14 + f14;
        float f16 = quaternionfc.x() * quaternionfc.w();
        float f17 = f16 + f16;
        this.m00 = f2 + f3 - f5 - f4;
        this.m01 = f9 + f7;
        this.m02 = f11 - f13;
        this.m10 = -f7 + f9;
        this.m11 = f4 - f5 + f2 - f3;
        this.m12 = f15 + f17;
        this.m20 = f13 + f11;
        this.m21 = f15 - f17;
        this.m22 = f5 - f4 - f3 + f2;
        return this;
    }

    public Vector3f transform(Vector3f vector3f) {
        return vector3f.mul(this);
    }

    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        return vector3fc.mul(this, vector3f);
    }

    public Vector3f transform(float f2, float f3, float f4, Vector3f vector3f) {
        return vector3f.set(Math.fma(this.m00, f2, Math.fma(this.m10, f3, this.m20 * f4)), Math.fma(this.m01, f2, Math.fma(this.m11, f3, this.m21 * f4)), Math.fma(this.m02, f2, Math.fma(this.m12, f3, this.m22 * f4)));
    }

    public Vector3f transformTranspose(Vector3f vector3f) {
        return vector3f.mulTranspose(this);
    }

    public Vector3f transformTranspose(Vector3fc vector3fc, Vector3f vector3f) {
        return vector3fc.mulTranspose(this, vector3f);
    }

    public Vector3f transformTranspose(float f2, float f3, float f4, Vector3f vector3f) {
        return vector3f.set(Math.fma(this.m00, f2, Math.fma(this.m01, f3, this.m02 * f4)), Math.fma(this.m10, f2, Math.fma(this.m11, f3, this.m12 * f4)), Math.fma(this.m20, f2, Math.fma(this.m21, f3, this.m22 * f4)));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.m00);
        objectOutput.writeFloat(this.m01);
        objectOutput.writeFloat(this.m02);
        objectOutput.writeFloat(this.m10);
        objectOutput.writeFloat(this.m11);
        objectOutput.writeFloat(this.m12);
        objectOutput.writeFloat(this.m20);
        objectOutput.writeFloat(this.m21);
        objectOutput.writeFloat(this.m22);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.m00 = objectInput.readFloat();
        this.m01 = objectInput.readFloat();
        this.m02 = objectInput.readFloat();
        this.m10 = objectInput.readFloat();
        this.m11 = objectInput.readFloat();
        this.m12 = objectInput.readFloat();
        this.m20 = objectInput.readFloat();
        this.m21 = objectInput.readFloat();
        this.m22 = objectInput.readFloat();
    }

    public Matrix3f rotateX(float f2, Matrix3f matrix3f) {
        float f3 = Math.sin(f2);
        float f4 = f2 = Math.cosFromSin(f3, f2);
        float f5 = -f3;
        float f6 = this.m10 * f2 + this.m20 * f3;
        float f7 = this.m11 * f2 + this.m21 * f3;
        f2 = this.m12 * f2 + this.m22 * f3;
        matrix3f.m20 = this.m10 * f5 + this.m20 * f4;
        matrix3f.m21 = this.m11 * f5 + this.m21 * f4;
        matrix3f.m22 = this.m12 * f5 + this.m22 * f4;
        matrix3f.m10 = f6;
        matrix3f.m11 = f7;
        matrix3f.m12 = f2;
        matrix3f.m00 = this.m00;
        matrix3f.m01 = this.m01;
        matrix3f.m02 = this.m02;
        return matrix3f;
    }

    public Matrix3f rotateX(float f2) {
        return this.rotateX(f2, this);
    }

    public Matrix3f rotateY(float f2, Matrix3f matrix3f) {
        float f3 = Math.sin(f2);
        float f4 = f2 = Math.cosFromSin(f3, f2);
        float f5 = -f3;
        float f6 = this.m00 * f2 + this.m20 * f5;
        float f7 = this.m01 * f2 + this.m21 * f5;
        f2 = this.m02 * f2 + this.m22 * f5;
        matrix3f.m20 = this.m00 * f3 + this.m20 * f4;
        matrix3f.m21 = this.m01 * f3 + this.m21 * f4;
        matrix3f.m22 = this.m02 * f3 + this.m22 * f4;
        matrix3f.m00 = f6;
        matrix3f.m01 = f7;
        matrix3f.m02 = f2;
        matrix3f.m10 = this.m10;
        matrix3f.m11 = this.m11;
        matrix3f.m12 = this.m12;
        return matrix3f;
    }

    public Matrix3f rotateY(float f2) {
        return this.rotateY(f2, this);
    }

    public Matrix3f rotateZ(float f2, Matrix3f matrix3f) {
        float f3 = Math.sin(f2);
        float f4 = f2 = Math.cosFromSin(f3, f2);
        float f5 = -f3;
        float f6 = this.m00 * f2 + this.m10 * f3;
        float f7 = this.m01 * f2 + this.m11 * f3;
        f2 = this.m02 * f2 + this.m12 * f3;
        matrix3f.m10 = this.m00 * f5 + this.m10 * f4;
        matrix3f.m11 = this.m01 * f5 + this.m11 * f4;
        matrix3f.m12 = this.m02 * f5 + this.m12 * f4;
        matrix3f.m00 = f6;
        matrix3f.m01 = f7;
        matrix3f.m02 = f2;
        matrix3f.m20 = this.m20;
        matrix3f.m21 = this.m21;
        matrix3f.m22 = this.m22;
        return matrix3f;
    }

    public Matrix3f rotateZ(float f2) {
        return this.rotateZ(f2, this);
    }

    public Matrix3f rotateXYZ(Vector3f vector3f) {
        return this.rotateXYZ(vector3f.x, vector3f.y, vector3f.z);
    }

    public Matrix3f rotateXYZ(float f2, float f3, float f4) {
        return this.rotateXYZ(f2, f3, f4, this);
    }

    public Matrix3f rotateXYZ(float f2, float f3, float f4, Matrix3f matrix3f) {
        float f5 = Math.sin(f2);
        f2 = Math.cosFromSin(f5, f2);
        float f6 = Math.sin(f3);
        f3 = Math.cosFromSin(f6, f3);
        float f7 = Math.sin(f4);
        f4 = Math.cosFromSin(f7, f4);
        float f8 = -f5;
        float f9 = -f6;
        float f10 = -f7;
        float f11 = this.m10 * f2 + this.m20 * f5;
        float f12 = this.m11 * f2 + this.m21 * f5;
        f5 = this.m12 * f2 + this.m22 * f5;
        float f13 = this.m10 * f8 + this.m20 * f2;
        float f14 = this.m11 * f8 + this.m21 * f2;
        f2 = this.m12 * f8 + this.m22 * f2;
        f8 = this.m00 * f3 + f13 * f9;
        float f15 = this.m01 * f3 + f14 * f9;
        f9 = this.m02 * f3 + f2 * f9;
        matrix3f.m20 = this.m00 * f6 + f13 * f3;
        matrix3f.m21 = this.m01 * f6 + f14 * f3;
        matrix3f.m22 = this.m02 * f6 + f2 * f3;
        matrix3f.m00 = f8 * f4 + f11 * f7;
        matrix3f.m01 = f15 * f4 + f12 * f7;
        matrix3f.m02 = f9 * f4 + f5 * f7;
        matrix3f.m10 = f8 * f10 + f11 * f4;
        matrix3f.m11 = f15 * f10 + f12 * f4;
        matrix3f.m12 = f9 * f10 + f5 * f4;
        return matrix3f;
    }

    public Matrix3f rotateZYX(Vector3f vector3f) {
        return this.rotateZYX(vector3f.z, vector3f.y, vector3f.x);
    }

    public Matrix3f rotateZYX(float f2, float f3, float f4) {
        return this.rotateZYX(f2, f3, f4, this);
    }

    public Matrix3f rotateZYX(float f2, float f3, float f4, Matrix3f matrix3f) {
        float f5 = Math.sin(f4);
        f4 = Math.cosFromSin(f5, f4);
        float f6 = Math.sin(f3);
        f3 = Math.cosFromSin(f6, f3);
        float f7 = Math.sin(f2);
        f2 = Math.cosFromSin(f7, f2);
        float f8 = -f7;
        float f9 = -f6;
        float f10 = -f5;
        float f11 = this.m00 * f2 + this.m10 * f7;
        float f12 = this.m01 * f2 + this.m11 * f7;
        f7 = this.m02 * f2 + this.m12 * f7;
        float f13 = this.m00 * f8 + this.m10 * f2;
        float f14 = this.m01 * f8 + this.m11 * f2;
        f2 = this.m02 * f8 + this.m12 * f2;
        f8 = f11 * f6 + this.m20 * f3;
        float f15 = f12 * f6 + this.m21 * f3;
        f6 = f7 * f6 + this.m22 * f3;
        matrix3f.m00 = f11 * f3 + this.m20 * f9;
        matrix3f.m01 = f12 * f3 + this.m21 * f9;
        matrix3f.m02 = f7 * f3 + this.m22 * f9;
        matrix3f.m10 = f13 * f4 + f8 * f5;
        matrix3f.m11 = f14 * f4 + f15 * f5;
        matrix3f.m12 = f2 * f4 + f6 * f5;
        matrix3f.m20 = f13 * f10 + f8 * f4;
        matrix3f.m21 = f14 * f10 + f15 * f4;
        matrix3f.m22 = f2 * f10 + f6 * f4;
        return matrix3f;
    }

    public Matrix3f rotateYXZ(Vector3f vector3f) {
        return this.rotateYXZ(vector3f.y, vector3f.x, vector3f.z);
    }

    public Matrix3f rotateYXZ(float f2, float f3, float f4) {
        return this.rotateYXZ(f2, f3, f4, this);
    }

    public Matrix3f rotateYXZ(float f2, float f3, float f4, Matrix3f matrix3f) {
        float f5 = Math.sin(f3);
        f3 = Math.cosFromSin(f5, f3);
        float f6 = Math.sin(f2);
        f2 = Math.cosFromSin(f6, f2);
        float f7 = Math.sin(f4);
        f4 = Math.cosFromSin(f7, f4);
        float f8 = -f6;
        float f9 = -f5;
        float f10 = -f7;
        float f11 = this.m00 * f6 + this.m20 * f2;
        float f12 = this.m01 * f6 + this.m21 * f2;
        f6 = this.m02 * f6 + this.m22 * f2;
        float f13 = this.m00 * f2 + this.m20 * f8;
        float f14 = this.m01 * f2 + this.m21 * f8;
        f2 = this.m02 * f2 + this.m22 * f8;
        f8 = this.m10 * f3 + f11 * f5;
        float f15 = this.m11 * f3 + f12 * f5;
        f5 = this.m12 * f3 + f6 * f5;
        matrix3f.m20 = this.m10 * f9 + f11 * f3;
        matrix3f.m21 = this.m11 * f9 + f12 * f3;
        matrix3f.m22 = this.m12 * f9 + f6 * f3;
        matrix3f.m00 = f13 * f4 + f8 * f7;
        matrix3f.m01 = f14 * f4 + f15 * f7;
        matrix3f.m02 = f2 * f4 + f5 * f7;
        matrix3f.m10 = f13 * f10 + f8 * f4;
        matrix3f.m11 = f14 * f10 + f15 * f4;
        matrix3f.m12 = f2 * f10 + f5 * f4;
        return matrix3f;
    }

    public Matrix3f rotate(float f2, float f3, float f4, float f5) {
        return this.rotate(f2, f3, f4, f5, this);
    }

    public Matrix3f rotate(float f2, float f3, float f4, float f5, Matrix3f matrix3f) {
        float f6 = Math.sin(f2);
        f2 = Math.cosFromSin(f6, f2);
        float f7 = 1.0f - f2;
        float f8 = f3;
        float f9 = f8 * f8;
        float f10 = f3 * f4;
        float f11 = f3 * f5;
        float f12 = f4;
        float f13 = f12 * f12;
        float f14 = f4 * f5;
        float f15 = f5;
        float f16 = f15 * f15;
        f9 = f9 * f7 + f2;
        float f17 = f10 * f7 + f5 * f6;
        float f18 = f11 * f7 - f4 * f6;
        f5 = f10 * f7 - f5 * f6;
        f10 = f13 * f7 + f2;
        f13 = f14 * f7 + f3 * f6;
        f4 = f11 * f7 + f4 * f6;
        f3 = f14 * f7 - f3 * f6;
        f2 = f16 * f7 + f2;
        f6 = this.m00 * f9 + this.m10 * f17 + this.m20 * f18;
        f7 = this.m01 * f9 + this.m11 * f17 + this.m21 * f18;
        f9 = this.m02 * f9 + this.m12 * f17 + this.m22 * f18;
        f11 = this.m00 * f5 + this.m10 * f10 + this.m20 * f13;
        f14 = this.m01 * f5 + this.m11 * f10 + this.m21 * f13;
        f5 = this.m02 * f5 + this.m12 * f10 + this.m22 * f13;
        matrix3f.m20 = this.m00 * f4 + this.m10 * f3 + this.m20 * f2;
        matrix3f.m21 = this.m01 * f4 + this.m11 * f3 + this.m21 * f2;
        matrix3f.m22 = this.m02 * f4 + this.m12 * f3 + this.m22 * f2;
        matrix3f.m00 = f6;
        matrix3f.m01 = f7;
        matrix3f.m02 = f9;
        matrix3f.m10 = f11;
        matrix3f.m11 = f14;
        matrix3f.m12 = f5;
        return matrix3f;
    }

    public Matrix3f rotateLocal(float f2, float f3, float f4, float f5, Matrix3f matrix3f) {
        float f6 = Math.sin(f2);
        f2 = Math.cosFromSin(f6, f2);
        float f7 = 1.0f - f2;
        float f8 = f3;
        float f9 = f8 * f8;
        float f10 = f3 * f4;
        float f11 = f3 * f5;
        float f12 = f4;
        float f13 = f12 * f12;
        float f14 = f4 * f5;
        float f15 = f5;
        float f16 = f15 * f15;
        f9 = f9 * f7 + f2;
        float f17 = f10 * f7 + f5 * f6;
        float f18 = f11 * f7 - f4 * f6;
        f5 = f10 * f7 - f5 * f6;
        f10 = f13 * f7 + f2;
        f13 = f14 * f7 + f3 * f6;
        f4 = f11 * f7 + f4 * f6;
        f3 = f14 * f7 - f3 * f6;
        f2 = f16 * f7 + f2;
        f6 = f9 * this.m00 + f5 * this.m01 + f4 * this.m02;
        f7 = f17 * this.m00 + f10 * this.m01 + f3 * this.m02;
        f11 = f18 * this.m00 + f13 * this.m01 + f2 * this.m02;
        f14 = f9 * this.m10 + f5 * this.m11 + f4 * this.m12;
        f16 = f17 * this.m10 + f10 * this.m11 + f3 * this.m12;
        float f19 = f18 * this.m10 + f13 * this.m11 + f2 * this.m12;
        f4 = f9 * this.m20 + f5 * this.m21 + f4 * this.m22;
        f3 = f17 * this.m20 + f10 * this.m21 + f3 * this.m22;
        f2 = f18 * this.m20 + f13 * this.m21 + f2 * this.m22;
        matrix3f.m00 = f6;
        matrix3f.m01 = f7;
        matrix3f.m02 = f11;
        matrix3f.m10 = f14;
        matrix3f.m11 = f16;
        matrix3f.m12 = f19;
        matrix3f.m20 = f4;
        matrix3f.m21 = f3;
        matrix3f.m22 = f2;
        return matrix3f;
    }

    public Matrix3f rotateLocal(float f2, float f3, float f4, float f5) {
        return this.rotateLocal(f2, f3, f4, f5, this);
    }

    public Matrix3f rotateLocalX(float f2, Matrix3f matrix3f) {
        float f3 = Math.sin(f2);
        f2 = Math.cosFromSin(f3, f2);
        float f4 = f2 * this.m01 - f3 * this.m02;
        float f5 = f3 * this.m01 + f2 * this.m02;
        float f6 = f2 * this.m11 - f3 * this.m12;
        float f7 = f3 * this.m11 + f2 * this.m12;
        float f8 = f2 * this.m21 - f3 * this.m22;
        f2 = f3 * this.m21 + f2 * this.m22;
        matrix3f.m00 = this.m00;
        matrix3f.m01 = f4;
        matrix3f.m02 = f5;
        matrix3f.m10 = this.m10;
        matrix3f.m11 = f6;
        matrix3f.m12 = f7;
        matrix3f.m20 = this.m20;
        matrix3f.m21 = f8;
        matrix3f.m22 = f2;
        return matrix3f;
    }

    public Matrix3f rotateLocalX(float f2) {
        return this.rotateLocalX(f2, this);
    }

    public Matrix3f rotateLocalY(float f2, Matrix3f matrix3f) {
        float f3 = Math.sin(f2);
        f2 = Math.cosFromSin(f3, f2);
        float f4 = f2 * this.m00 + f3 * this.m02;
        float f5 = -f3 * this.m00 + f2 * this.m02;
        float f6 = f2 * this.m10 + f3 * this.m12;
        float f7 = -f3 * this.m10 + f2 * this.m12;
        float f8 = f2 * this.m20 + f3 * this.m22;
        f2 = -f3 * this.m20 + f2 * this.m22;
        matrix3f.m00 = f4;
        matrix3f.m01 = this.m01;
        matrix3f.m02 = f5;
        matrix3f.m10 = f6;
        matrix3f.m11 = this.m11;
        matrix3f.m12 = f7;
        matrix3f.m20 = f8;
        matrix3f.m21 = this.m21;
        matrix3f.m22 = f2;
        return matrix3f;
    }

    public Matrix3f rotateLocalY(float f2) {
        return this.rotateLocalY(f2, this);
    }

    public Matrix3f rotateLocalZ(float f2, Matrix3f matrix3f) {
        float f3 = Math.sin(f2);
        f2 = Math.cosFromSin(f3, f2);
        float f4 = f2 * this.m00 - f3 * this.m01;
        float f5 = f3 * this.m00 + f2 * this.m01;
        float f6 = f2 * this.m10 - f3 * this.m11;
        float f7 = f3 * this.m10 + f2 * this.m11;
        float f8 = f2 * this.m20 - f3 * this.m21;
        f2 = f3 * this.m20 + f2 * this.m21;
        matrix3f.m00 = f4;
        matrix3f.m01 = f5;
        matrix3f.m02 = this.m02;
        matrix3f.m10 = f6;
        matrix3f.m11 = f7;
        matrix3f.m12 = this.m12;
        matrix3f.m20 = f8;
        matrix3f.m21 = f2;
        matrix3f.m22 = this.m22;
        return matrix3f;
    }

    public Matrix3f rotateLocalZ(float f2) {
        return this.rotateLocalZ(f2, this);
    }

    public Matrix3f rotate(Quaternionfc quaternionfc) {
        return this.rotate(quaternionfc, this);
    }

    public Matrix3f rotate(Quaternionfc quaternionfc, Matrix3f matrix3f) {
        float f2 = quaternionfc.w() * quaternionfc.w();
        float f3 = quaternionfc.x() * quaternionfc.x();
        float f4 = quaternionfc.y() * quaternionfc.y();
        float f5 = quaternionfc.z() * quaternionfc.z();
        float f6 = quaternionfc.z() * quaternionfc.w();
        float f7 = f6 + f6;
        float f8 = quaternionfc.x() * quaternionfc.y();
        float f9 = f8 + f8;
        float f10 = quaternionfc.x() * quaternionfc.z();
        float f11 = f10 + f10;
        float f12 = quaternionfc.y() * quaternionfc.w();
        float f13 = f12 + f12;
        float f14 = quaternionfc.y() * quaternionfc.z();
        float f15 = f14 + f14;
        float f16 = quaternionfc.x() * quaternionfc.w();
        float f17 = f16 + f16;
        float f18 = f2 + f3 - f5 - f4;
        float f19 = f9 + f7;
        float f20 = f11 - f13;
        f7 = f9 - f7;
        f9 = f4 - f5 + f2 - f3;
        float f21 = f15 + f17;
        f11 = f13 + f11;
        f17 = f15 - f17;
        f2 = f5 - f4 - f3 + f2;
        f3 = this.m00 * f18 + this.m10 * f19 + this.m20 * f20;
        f4 = this.m01 * f18 + this.m11 * f19 + this.m21 * f20;
        f5 = this.m02 * f18 + this.m12 * f19 + this.m22 * f20;
        f13 = this.m00 * f7 + this.m10 * f9 + this.m20 * f21;
        f15 = this.m01 * f7 + this.m11 * f9 + this.m21 * f21;
        f7 = this.m02 * f7 + this.m12 * f9 + this.m22 * f21;
        matrix3f.m20 = this.m00 * f11 + this.m10 * f17 + this.m20 * f2;
        matrix3f.m21 = this.m01 * f11 + this.m11 * f17 + this.m21 * f2;
        matrix3f.m22 = this.m02 * f11 + this.m12 * f17 + this.m22 * f2;
        matrix3f.m00 = f3;
        matrix3f.m01 = f4;
        matrix3f.m02 = f5;
        matrix3f.m10 = f13;
        matrix3f.m11 = f15;
        matrix3f.m12 = f7;
        return matrix3f;
    }

    public Matrix3f rotateLocal(Quaternionfc quaternionfc, Matrix3f matrix3f) {
        float f2 = quaternionfc.w() * quaternionfc.w();
        float f3 = quaternionfc.x() * quaternionfc.x();
        float f4 = quaternionfc.y() * quaternionfc.y();
        float f5 = quaternionfc.z() * quaternionfc.z();
        float f6 = quaternionfc.z() * quaternionfc.w();
        float f7 = f6 + f6;
        float f8 = quaternionfc.x() * quaternionfc.y();
        float f9 = f8 + f8;
        float f10 = quaternionfc.x() * quaternionfc.z();
        float f11 = f10 + f10;
        float f12 = quaternionfc.y() * quaternionfc.w();
        float f13 = f12 + f12;
        float f14 = quaternionfc.y() * quaternionfc.z();
        float f15 = f14 + f14;
        float f16 = quaternionfc.x() * quaternionfc.w();
        float f17 = f16 + f16;
        float f18 = f2 + f3 - f5 - f4;
        float f19 = f9 + f7;
        float f20 = f11 - f13;
        f7 = f9 - f7;
        f9 = f4 - f5 + f2 - f3;
        float f21 = f15 + f17;
        f11 = f13 + f11;
        f17 = f15 - f17;
        f2 = f5 - f4 - f3 + f2;
        f3 = f18 * this.m00 + f7 * this.m01 + f11 * this.m02;
        f4 = f19 * this.m00 + f9 * this.m01 + f17 * this.m02;
        f5 = f20 * this.m00 + f21 * this.m01 + f2 * this.m02;
        f13 = f18 * this.m10 + f7 * this.m11 + f11 * this.m12;
        f15 = f19 * this.m10 + f9 * this.m11 + f17 * this.m12;
        float f22 = f20 * this.m10 + f21 * this.m11 + f2 * this.m12;
        f7 = f18 * this.m20 + f7 * this.m21 + f11 * this.m22;
        f17 = f19 * this.m20 + f9 * this.m21 + f17 * this.m22;
        f2 = f20 * this.m20 + f21 * this.m21 + f2 * this.m22;
        matrix3f.m00 = f3;
        matrix3f.m01 = f4;
        matrix3f.m02 = f5;
        matrix3f.m10 = f13;
        matrix3f.m11 = f15;
        matrix3f.m12 = f22;
        matrix3f.m20 = f7;
        matrix3f.m21 = f17;
        matrix3f.m22 = f2;
        return matrix3f;
    }

    public Matrix3f rotateLocal(Quaternionfc quaternionfc) {
        return this.rotateLocal(quaternionfc, this);
    }

    public Matrix3f rotate(AxisAngle4f axisAngle4f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix3f rotate(AxisAngle4f axisAngle4f, Matrix3f matrix3f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, matrix3f);
    }

    public Matrix3f rotate(float f2, Vector3fc vector3fc) {
        return this.rotate(f2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f rotate(float f2, Vector3fc vector3fc, Matrix3f matrix3f) {
        return this.rotate(f2, vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix3f);
    }

    public Matrix3f lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    public Matrix3f lookAlong(Vector3fc vector3fc, Vector3fc vector3fc2, Matrix3f matrix3f) {
        return this.lookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix3f);
    }

    public Matrix3f lookAlong(float f2, float f3, float f4, float f5, float f6, float f7, Matrix3f matrix3f) {
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        float f11 = Math.invsqrt(f8 * f8 + f9 * f9 + f10 * f10);
        f2 *= -f11;
        f3 *= -f11;
        f4 *= -f11;
        f11 = f6 * f4 - f7 * f3;
        f7 = f7 * f2 - f5 * f4;
        f5 = f5 * f3 - f6 * f2;
        float f12 = f11;
        float f13 = f7;
        float f14 = f5;
        f6 = Math.invsqrt(f12 * f12 + f13 * f13 + f14 * f14);
        f11 *= f6;
        f7 *= f6;
        f5 *= f6;
        f6 = f3 * f5 - f4 * f7;
        float f15 = f4 * f11 - f2 * f5;
        float f16 = f2 * f7 - f3 * f11;
        float f17 = this.m00 * f11 + this.m10 * f6 + this.m20 * f2;
        float f18 = this.m01 * f11 + this.m11 * f6 + this.m21 * f2;
        f2 = this.m02 * f11 + this.m12 * f6 + this.m22 * f2;
        f6 = this.m00 * f7 + this.m10 * f15 + this.m20 * f3;
        f11 = this.m01 * f7 + this.m11 * f15 + this.m21 * f3;
        f3 = this.m02 * f7 + this.m12 * f15 + this.m22 * f3;
        matrix3f.m20 = this.m00 * f5 + this.m10 * f16 + this.m20 * f4;
        matrix3f.m21 = this.m01 * f5 + this.m11 * f16 + this.m21 * f4;
        matrix3f.m22 = this.m02 * f5 + this.m12 * f16 + this.m22 * f4;
        matrix3f.m00 = f17;
        matrix3f.m01 = f18;
        matrix3f.m02 = f2;
        matrix3f.m10 = f6;
        matrix3f.m11 = f11;
        matrix3f.m12 = f3;
        return matrix3f;
    }

    public Matrix3f lookAlong(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.lookAlong(f2, f3, f4, f5, f6, f7, this);
    }

    public Matrix3f setLookAlong(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.setLookAlong(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix3f setLookAlong(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        float f11 = Math.invsqrt(f8 * f8 + f9 * f9 + f10 * f10);
        f2 *= -f11;
        f3 *= -f11;
        f4 *= -f11;
        f11 = f6 * f4 - f7 * f3;
        f7 = f7 * f2 - f5 * f4;
        f5 = f5 * f3 - f6 * f2;
        float f12 = f11;
        float f13 = f7;
        float f14 = f5;
        f6 = Math.invsqrt(f12 * f12 + f13 * f13 + f14 * f14);
        f11 *= f6;
        f7 *= f6;
        f5 *= f6;
        f6 = f3 * f5 - f4 * f7;
        float f15 = f4 * f11 - f2 * f5;
        float f16 = f2 * f7 - f3 * f11;
        this.m00 = f11;
        this.m01 = f6;
        this.m02 = f2;
        this.m10 = f7;
        this.m11 = f15;
        this.m12 = f3;
        this.m20 = f5;
        this.m21 = f16;
        this.m22 = f4;
        return this;
    }

    public Vector3f getRow(int n2, Vector3f vector3f) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                return vector3f.set(this.m00, this.m10, this.m20);
            }
            case 1: {
                return vector3f.set(this.m01, this.m11, this.m21);
            }
            case 2: {
                return vector3f.set(this.m02, this.m12, this.m22);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix3f setRow(int n2, Vector3fc vector3fc) throws IndexOutOfBoundsException {
        return this.setRow(n2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f setRow(int n2, float f2, float f3, float f4) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                this.m00 = f2;
                this.m10 = f3;
                this.m20 = f4;
                break;
            }
            case 1: {
                this.m01 = f2;
                this.m11 = f3;
                this.m21 = f4;
                break;
            }
            case 2: {
                this.m02 = f2;
                this.m12 = f3;
                this.m22 = f4;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public Vector3f getColumn(int n2, Vector3f vector3f) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                return vector3f.set(this.m00, this.m01, this.m02);
            }
            case 1: {
                return vector3f.set(this.m10, this.m11, this.m12);
            }
            case 2: {
                return vector3f.set(this.m20, this.m21, this.m22);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix3f setColumn(int n2, Vector3fc vector3fc) throws IndexOutOfBoundsException {
        return this.setColumn(n2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f setColumn(int n2, float f2, float f3, float f4) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                this.m00 = f2;
                this.m01 = f3;
                this.m02 = f4;
                break;
            }
            case 1: {
                this.m10 = f2;
                this.m11 = f3;
                this.m12 = f4;
                break;
            }
            case 2: {
                this.m20 = f2;
                this.m21 = f3;
                this.m22 = f4;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public float get(int n2, int n3) {
        return MemUtil.INSTANCE.get(this, n2, n3);
    }

    public Matrix3f set(int n2, int n3, float f2) {
        return MemUtil.INSTANCE.set(this, n2, n3, f2);
    }

    public float getRowColumn(int n2, int n3) {
        return MemUtil.INSTANCE.get(this, n3, n2);
    }

    public Matrix3f setRowColumn(int n2, int n3, float f2) {
        return MemUtil.INSTANCE.set(this, n3, n2, f2);
    }

    public Matrix3f normal() {
        Matrix3f matrix3f = this;
        return matrix3f.normal(matrix3f);
    }

    public Matrix3f normal(Matrix3f matrix3f) {
        float f2 = this.m00 * this.m11;
        float f3 = this.m01 * this.m10;
        float f4 = this.m02 * this.m10;
        float f5 = this.m00 * this.m12;
        float f6 = this.m01 * this.m12;
        float f7 = this.m02 * this.m11;
        float f8 = (f2 - f3) * this.m22 + (f4 - f5) * this.m21 + (f6 - f7) * this.m20;
        f8 = 1.0f / f8;
        float f9 = (this.m11 * this.m22 - this.m21 * this.m12) * f8;
        float f10 = (this.m20 * this.m12 - this.m10 * this.m22) * f8;
        float f11 = (this.m10 * this.m21 - this.m20 * this.m11) * f8;
        float f12 = (this.m21 * this.m02 - this.m01 * this.m22) * f8;
        float f13 = (this.m00 * this.m22 - this.m20 * this.m02) * f8;
        float f14 = (this.m20 * this.m01 - this.m00 * this.m21) * f8;
        f6 = (f6 - f7) * f8;
        f4 = (f4 - f5) * f8;
        f2 = (f2 - f3) * f8;
        matrix3f.m00 = f9;
        matrix3f.m01 = f10;
        matrix3f.m02 = f11;
        matrix3f.m10 = f12;
        matrix3f.m11 = f13;
        matrix3f.m12 = f14;
        matrix3f.m20 = f6;
        matrix3f.m21 = f4;
        matrix3f.m22 = f2;
        return matrix3f;
    }

    public Matrix3f cofactor() {
        Matrix3f matrix3f = this;
        return matrix3f.cofactor(matrix3f);
    }

    public Matrix3f cofactor(Matrix3f matrix3f) {
        float f2 = this.m11 * this.m22 - this.m21 * this.m12;
        float f3 = this.m20 * this.m12 - this.m10 * this.m22;
        float f4 = this.m10 * this.m21 - this.m20 * this.m11;
        float f5 = this.m21 * this.m02 - this.m01 * this.m22;
        float f6 = this.m00 * this.m22 - this.m20 * this.m02;
        float f7 = this.m20 * this.m01 - this.m00 * this.m21;
        float f8 = this.m01 * this.m12 - this.m11 * this.m02;
        float f9 = this.m02 * this.m10 - this.m12 * this.m00;
        float f10 = this.m00 * this.m11 - this.m10 * this.m01;
        matrix3f.m00 = f2;
        matrix3f.m01 = f3;
        matrix3f.m02 = f4;
        matrix3f.m10 = f5;
        matrix3f.m11 = f6;
        matrix3f.m12 = f7;
        matrix3f.m20 = f8;
        matrix3f.m21 = f9;
        matrix3f.m22 = f10;
        return matrix3f;
    }

    public Vector3f getScale(Vector3f vector3f) {
        return vector3f.set(Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02), Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12), Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22));
    }

    public Vector3f positiveZ(Vector3f vector3f) {
        vector3f.x = this.m10 * this.m21 - this.m11 * this.m20;
        vector3f.y = this.m20 * this.m01 - this.m21 * this.m00;
        vector3f.z = this.m00 * this.m11 - this.m01 * this.m10;
        Vector3f vector3f2 = vector3f;
        return vector3f2.normalize(vector3f2);
    }

    public Vector3f normalizedPositiveZ(Vector3f vector3f) {
        vector3f.x = this.m02;
        vector3f.y = this.m12;
        vector3f.z = this.m22;
        return vector3f;
    }

    public Vector3f positiveX(Vector3f vector3f) {
        vector3f.x = this.m11 * this.m22 - this.m12 * this.m21;
        vector3f.y = this.m02 * this.m21 - this.m01 * this.m22;
        vector3f.z = this.m01 * this.m12 - this.m02 * this.m11;
        Vector3f vector3f2 = vector3f;
        return vector3f2.normalize(vector3f2);
    }

    public Vector3f normalizedPositiveX(Vector3f vector3f) {
        vector3f.x = this.m00;
        vector3f.y = this.m10;
        vector3f.z = this.m20;
        return vector3f;
    }

    public Vector3f positiveY(Vector3f vector3f) {
        vector3f.x = this.m12 * this.m20 - this.m10 * this.m22;
        vector3f.y = this.m00 * this.m22 - this.m02 * this.m20;
        vector3f.z = this.m02 * this.m10 - this.m00 * this.m12;
        Vector3f vector3f2 = vector3f;
        return vector3f2.normalize(vector3f2);
    }

    public Vector3f normalizedPositiveY(Vector3f vector3f) {
        vector3f.x = this.m01;
        vector3f.y = this.m11;
        vector3f.z = this.m21;
        return vector3f;
    }

    public int hashCode() {
        return ((((((((31 + Float.floatToIntBits(this.m00)) * 31 + Float.floatToIntBits(this.m01)) * 31 + Float.floatToIntBits(this.m02)) * 31 + Float.floatToIntBits(this.m10)) * 31 + Float.floatToIntBits(this.m11)) * 31 + Float.floatToIntBits(this.m12)) * 31 + Float.floatToIntBits(this.m20)) * 31 + Float.floatToIntBits(this.m21)) * 31 + Float.floatToIntBits(this.m22);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Matrix3f)) {
            return false;
        }
        object = (Matrix3f)object;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(((Matrix3f)object).m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(((Matrix3f)object).m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m02) != Float.floatToIntBits(((Matrix3f)object).m02)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(((Matrix3f)object).m10)) {
            return false;
        }
        if (Float.floatToIntBits(this.m11) != Float.floatToIntBits(((Matrix3f)object).m11)) {
            return false;
        }
        if (Float.floatToIntBits(this.m12) != Float.floatToIntBits(((Matrix3f)object).m12)) {
            return false;
        }
        if (Float.floatToIntBits(this.m20) != Float.floatToIntBits(((Matrix3f)object).m20)) {
            return false;
        }
        if (Float.floatToIntBits(this.m21) != Float.floatToIntBits(((Matrix3f)object).m21)) {
            return false;
        }
        return Float.floatToIntBits(this.m22) == Float.floatToIntBits(((Matrix3f)object).m22);
    }

    public boolean equals(Matrix3fc matrix3fc, float f2) {
        if (this == matrix3fc) {
            return true;
        }
        if (matrix3fc == null) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix3fc.m00(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix3fc.m01(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m02, matrix3fc.m02(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix3fc.m10(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix3fc.m11(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m12, matrix3fc.m12(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix3fc.m20(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.m21, matrix3fc.m21(), f2)) {
            return false;
        }
        return Runtime.equals(this.m22, matrix3fc.m22(), f2);
    }

    public Matrix3f swap(Matrix3f matrix3f) {
        MemUtil.INSTANCE.swap(this, matrix3f);
        return this;
    }

    public Matrix3f add(Matrix3fc matrix3fc) {
        return this.add(matrix3fc, this);
    }

    public Matrix3f add(Matrix3fc matrix3fc, Matrix3f matrix3f) {
        matrix3f.m00 = this.m00 + matrix3fc.m00();
        matrix3f.m01 = this.m01 + matrix3fc.m01();
        matrix3f.m02 = this.m02 + matrix3fc.m02();
        matrix3f.m10 = this.m10 + matrix3fc.m10();
        matrix3f.m11 = this.m11 + matrix3fc.m11();
        matrix3f.m12 = this.m12 + matrix3fc.m12();
        matrix3f.m20 = this.m20 + matrix3fc.m20();
        matrix3f.m21 = this.m21 + matrix3fc.m21();
        matrix3f.m22 = this.m22 + matrix3fc.m22();
        return matrix3f;
    }

    public Matrix3f sub(Matrix3fc matrix3fc) {
        return this.sub(matrix3fc, this);
    }

    public Matrix3f sub(Matrix3fc matrix3fc, Matrix3f matrix3f) {
        matrix3f.m00 = this.m00 - matrix3fc.m00();
        matrix3f.m01 = this.m01 - matrix3fc.m01();
        matrix3f.m02 = this.m02 - matrix3fc.m02();
        matrix3f.m10 = this.m10 - matrix3fc.m10();
        matrix3f.m11 = this.m11 - matrix3fc.m11();
        matrix3f.m12 = this.m12 - matrix3fc.m12();
        matrix3f.m20 = this.m20 - matrix3fc.m20();
        matrix3f.m21 = this.m21 - matrix3fc.m21();
        matrix3f.m22 = this.m22 - matrix3fc.m22();
        return matrix3f;
    }

    public Matrix3f mulComponentWise(Matrix3fc matrix3fc) {
        return this.mulComponentWise(matrix3fc, this);
    }

    public Matrix3f mulComponentWise(Matrix3fc matrix3fc, Matrix3f matrix3f) {
        matrix3f.m00 = this.m00 * matrix3fc.m00();
        matrix3f.m01 = this.m01 * matrix3fc.m01();
        matrix3f.m02 = this.m02 * matrix3fc.m02();
        matrix3f.m10 = this.m10 * matrix3fc.m10();
        matrix3f.m11 = this.m11 * matrix3fc.m11();
        matrix3f.m12 = this.m12 * matrix3fc.m12();
        matrix3f.m20 = this.m20 * matrix3fc.m20();
        matrix3f.m21 = this.m21 * matrix3fc.m21();
        matrix3f.m22 = this.m22 * matrix3fc.m22();
        return matrix3f;
    }

    public Matrix3f setSkewSymmetric(float f2, float f3, float f4) {
        Matrix3f matrix3f = this;
        this.m22 = 0.0f;
        matrix3f.m11 = 0.0f;
        matrix3f.m00 = 0.0f;
        this.m01 = -f2;
        this.m02 = f3;
        this.m10 = f2;
        this.m12 = -f4;
        this.m20 = -f3;
        this.m21 = f4;
        return this;
    }

    public Matrix3f lerp(Matrix3fc matrix3fc, float f2) {
        return this.lerp(matrix3fc, f2, this);
    }

    public Matrix3f lerp(Matrix3fc matrix3fc, float f2, Matrix3f matrix3f) {
        matrix3f.m00 = Math.fma(matrix3fc.m00() - this.m00, f2, this.m00);
        matrix3f.m01 = Math.fma(matrix3fc.m01() - this.m01, f2, this.m01);
        matrix3f.m02 = Math.fma(matrix3fc.m02() - this.m02, f2, this.m02);
        matrix3f.m10 = Math.fma(matrix3fc.m10() - this.m10, f2, this.m10);
        matrix3f.m11 = Math.fma(matrix3fc.m11() - this.m11, f2, this.m11);
        matrix3f.m12 = Math.fma(matrix3fc.m12() - this.m12, f2, this.m12);
        matrix3f.m20 = Math.fma(matrix3fc.m20() - this.m20, f2, this.m20);
        matrix3f.m21 = Math.fma(matrix3fc.m21() - this.m21, f2, this.m21);
        matrix3f.m22 = Math.fma(matrix3fc.m22() - this.m22, f2, this.m22);
        return matrix3f;
    }

    public Matrix3f rotateTowards(Vector3fc vector3fc, Vector3fc vector3fc2, Matrix3f matrix3f) {
        return this.rotateTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), matrix3f);
    }

    public Matrix3f rotateTowards(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotateTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), this);
    }

    public Matrix3f rotateTowards(float f2, float f3, float f4, float f5, float f6, float f7) {
        return this.rotateTowards(f2, f3, f4, f5, f6, f7, this);
    }

    public Matrix3f rotateTowards(float f2, float f3, float f4, float f5, float f6, float f7, Matrix3f matrix3f) {
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        float f11 = Math.invsqrt(f8 * f8 + f9 * f9 + f10 * f10);
        f2 *= f11;
        f3 *= f11;
        f4 *= f11;
        f11 = f6 * f4 - f7 * f3;
        f7 = f7 * f2 - f5 * f4;
        f5 = f5 * f3 - f6 * f2;
        float f12 = f11;
        float f13 = f7;
        float f14 = f5;
        f6 = Math.invsqrt(f12 * f12 + f13 * f13 + f14 * f14);
        f11 *= f6;
        f7 *= f6;
        f5 *= f6;
        f6 = f3 * f5 - f4 * f7;
        float f15 = f4 * f11 - f2 * f5;
        float f16 = f2 * f7 - f3 * f11;
        float f17 = this.m00 * f11 + this.m10 * f7 + this.m20 * f5;
        float f18 = this.m01 * f11 + this.m11 * f7 + this.m21 * f5;
        f5 = this.m02 * f11 + this.m12 * f7 + this.m22 * f5;
        f7 = this.m00 * f6 + this.m10 * f15 + this.m20 * f16;
        f11 = this.m01 * f6 + this.m11 * f15 + this.m21 * f16;
        f6 = this.m02 * f6 + this.m12 * f15 + this.m22 * f16;
        matrix3f.m20 = this.m00 * f2 + this.m10 * f3 + this.m20 * f4;
        matrix3f.m21 = this.m01 * f2 + this.m11 * f3 + this.m21 * f4;
        matrix3f.m22 = this.m02 * f2 + this.m12 * f3 + this.m22 * f4;
        matrix3f.m00 = f17;
        matrix3f.m01 = f18;
        matrix3f.m02 = f5;
        matrix3f.m10 = f7;
        matrix3f.m11 = f11;
        matrix3f.m12 = f6;
        return matrix3f;
    }

    public Matrix3f rotationTowards(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.rotationTowards(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public Matrix3f rotationTowards(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        float f11 = Math.invsqrt(f8 * f8 + f9 * f9 + f10 * f10);
        f2 *= f11;
        f3 *= f11;
        f4 *= f11;
        f11 = f6 * f4 - f7 * f3;
        f7 = f7 * f2 - f5 * f4;
        f5 = f5 * f3 - f6 * f2;
        float f12 = f11;
        float f13 = f7;
        float f14 = f5;
        f6 = Math.invsqrt(f12 * f12 + f13 * f13 + f14 * f14);
        f11 *= f6;
        f7 *= f6;
        f5 *= f6;
        f6 = f3 * f5 - f4 * f7;
        float f15 = f4 * f11 - f2 * f5;
        float f16 = f2 * f7 - f3 * f11;
        this.m00 = f11;
        this.m01 = f7;
        this.m02 = f5;
        this.m10 = f6;
        this.m11 = f15;
        this.m12 = f16;
        this.m20 = f2;
        this.m21 = f3;
        this.m22 = f4;
        return this;
    }

    public Vector3f getEulerAnglesZYX(Vector3f vector3f) {
        vector3f.x = Math.atan2(this.m12, this.m22);
        vector3f.y = Math.atan2(-this.m02, Math.sqrt(1.0f - this.m02 * this.m02));
        vector3f.z = Math.atan2(this.m01, this.m00);
        return vector3f;
    }

    public Vector3f getEulerAnglesXYZ(Vector3f vector3f) {
        vector3f.x = Math.atan2(-this.m21, this.m22);
        vector3f.y = Math.atan2(this.m20, Math.sqrt(1.0f - this.m20 * this.m20));
        vector3f.z = Math.atan2(-this.m10, this.m00);
        return vector3f;
    }

    public Vector3f getEulerAnglesYXZ(Vector3f vector3f) {
        vector3f.x = Math.atan2(-this.m21, Math.sqrt(1.0f - this.m21 * this.m21));
        vector3f.y = Math.atan2(this.m20, this.m22);
        vector3f.z = Math.atan2(this.m01, this.m11);
        return vector3f;
    }

    public Matrix3f obliqueZ(float f2, float f3) {
        this.m20 = this.m00 * f2 + this.m10 * f3 + this.m20;
        this.m21 = this.m01 * f2 + this.m11 * f3 + this.m21;
        this.m22 = this.m02 * f2 + this.m12 * f3 + this.m22;
        return this;
    }

    public Matrix3f obliqueZ(float f2, float f3, Matrix3f matrix3f) {
        matrix3f.m00 = this.m00;
        matrix3f.m01 = this.m01;
        matrix3f.m02 = this.m02;
        matrix3f.m10 = this.m10;
        matrix3f.m11 = this.m11;
        matrix3f.m12 = this.m12;
        matrix3f.m20 = this.m00 * f2 + this.m10 * f3 + this.m20;
        matrix3f.m21 = this.m01 * f2 + this.m11 * f3 + this.m21;
        matrix3f.m22 = this.m02 * f2 + this.m12 * f3 + this.m22;
        return matrix3f;
    }

    public Matrix3f reflect(float f2, float f3, float f4, Matrix3f matrix3f) {
        float f5 = f2;
        float f6 = f5 + f5;
        float f7 = f3;
        float f8 = f7 + f7;
        float f9 = f4;
        float f10 = f9 + f9;
        float f11 = 1.0f - f6 * f2;
        float f12 = -f6 * f3;
        f6 = -f6 * f4;
        float f13 = -f8 * f2;
        float f14 = 1.0f - f8 * f3;
        f8 = -f8 * f4;
        f2 = -f10 * f2;
        f3 = -f10 * f3;
        f4 = 1.0f - f10 * f4;
        f10 = this.m00 * f11 + this.m10 * f12 + this.m20 * f6;
        float f15 = this.m01 * f11 + this.m11 * f12 + this.m21 * f6;
        f6 = this.m02 * f11 + this.m12 * f12 + this.m22 * f6;
        f11 = this.m00 * f13 + this.m10 * f14 + this.m20 * f8;
        f12 = this.m01 * f13 + this.m11 * f14 + this.m21 * f8;
        f8 = this.m02 * f13 + this.m12 * f14 + this.m22 * f8;
        return matrix3f._m20(this.m00 * f2 + this.m10 * f3 + this.m20 * f4)._m21(this.m01 * f2 + this.m11 * f3 + this.m21 * f4)._m22(this.m02 * f2 + this.m12 * f3 + this.m22 * f4)._m00(f10)._m01(f15)._m02(f6)._m10(f11)._m11(f12)._m12(f8);
    }

    public Matrix3f reflect(float f2, float f3, float f4) {
        return this.reflect(f2, f3, f4, this);
    }

    public Matrix3f reflect(Vector3fc vector3fc) {
        return this.reflect(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f reflect(Quaternionfc quaternionfc) {
        return this.reflect(quaternionfc, this);
    }

    public Matrix3f reflect(Quaternionfc quaternionfc, Matrix3f matrix3f) {
        float f2 = quaternionfc.x() + quaternionfc.x();
        float f3 = quaternionfc.y() + quaternionfc.y();
        float f4 = quaternionfc.z() + quaternionfc.z();
        float f5 = quaternionfc.x() * f4 + quaternionfc.w() * f3;
        f4 = quaternionfc.y() * f4 - quaternionfc.w() * f2;
        float f6 = 1.0f - (quaternionfc.x() * f2 + quaternionfc.y() * f3);
        return this.reflect(f5, f4, f6, matrix3f);
    }

    public Matrix3f reflect(Vector3fc vector3fc, Matrix3f matrix3f) {
        return this.reflect(vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix3f);
    }

    public Matrix3f reflection(float f2, float f3, float f4) {
        float f5 = f2;
        float f6 = f5 + f5;
        float f7 = f3;
        float f8 = f7 + f7;
        float f9 = f4;
        float f10 = f9 + f9;
        this._m00(1.0f - f6 * f2);
        this._m01(-f6 * f3);
        this._m02(-f6 * f4);
        this._m10(-f8 * f2);
        this._m11(1.0f - f8 * f3);
        this._m12(-f8 * f4);
        this._m20(-f10 * f2);
        this._m21(-f10 * f3);
        this._m22(1.0f - f10 * f4);
        return this;
    }

    public Matrix3f reflection(Vector3fc vector3fc) {
        return this.reflection(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f reflection(Quaternionfc quaternionfc) {
        float f2 = quaternionfc.x() + quaternionfc.x();
        float f3 = quaternionfc.y() + quaternionfc.y();
        float f4 = quaternionfc.z() + quaternionfc.z();
        float f5 = quaternionfc.x() * f4 + quaternionfc.w() * f3;
        f4 = quaternionfc.y() * f4 - quaternionfc.w() * f2;
        float f6 = 1.0f - (quaternionfc.x() * f2 + quaternionfc.y() * f3);
        return this.reflection(f5, f4, f6);
    }

    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m02) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m12) && Math.isFinite(this.m20) && Math.isFinite(this.m21) && Math.isFinite(this.m22);
    }

    public float quadraticFormProduct(float f2, float f3, float f4) {
        float f5 = this.m00 * f2 + this.m10 * f3 + this.m20 * f4;
        float f6 = this.m01 * f2 + this.m11 * f3 + this.m21 * f4;
        float f7 = this.m02 * f2 + this.m12 * f3 + this.m22 * f4;
        return f2 * f5 + f3 * f6 + f4 * f7;
    }

    public float quadraticFormProduct(Vector3fc vector3fc) {
        return this.quadraticFormProduct(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3f mapXZY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapXZY(matrix3f);
    }

    public Matrix3f mapXZY(Matrix3f matrix3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapXZnY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapXZnY(matrix3f);
    }

    public Matrix3f mapXZnY(Matrix3f matrix3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f mapXnYnZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapXnYnZ(matrix3f);
    }

    public Matrix3f mapXnYnZ(Matrix3f matrix3f) {
        return matrix3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3f mapXnZY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapXnZY(matrix3f);
    }

    public Matrix3f mapXnZY(Matrix3f matrix3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapXnZnY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapXnZnY(matrix3f);
    }

    public Matrix3f mapXnZnY(Matrix3f matrix3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f mapYXZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapYXZ(matrix3f);
    }

    public Matrix3f mapYXZ(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(f2)._m11(f3)._m12(f4)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3f mapYXnZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapYXnZ(matrix3f);
    }

    public Matrix3f mapYXnZ(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(f2)._m11(f3)._m12(f4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3f mapYZX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapYZX(matrix3f);
    }

    public Matrix3f mapYZX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapYZnX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapYZnX(matrix3f);
    }

    public Matrix3f mapYZnX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f mapYnXZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapYnXZ(matrix3f);
    }

    public Matrix3f mapYnXZ(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-f2)._m11(-f3)._m12(-f4)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3f mapYnXnZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapYnXnZ(matrix3f);
    }

    public Matrix3f mapYnXnZ(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-f2)._m11(-f3)._m12(-f4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3f mapYnZX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapYnZX(matrix3f);
    }

    public Matrix3f mapYnZX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapYnZnX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapYnZnX(matrix3f);
    }

    public Matrix3f mapYnZnX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f mapZXY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapZXY(matrix3f);
    }

    public Matrix3f mapZXY(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(f2)._m11(f3)._m12(f4)._m20(f5)._m21(f6)._m22(f7);
    }

    public Matrix3f mapZXnY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapZXnY(matrix3f);
    }

    public Matrix3f mapZXnY(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(f2)._m11(f3)._m12(f4)._m20(-f5)._m21(-f6)._m22(-f7);
    }

    public Matrix3f mapZYX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapZYX(matrix3f);
    }

    public Matrix3f mapZYX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapZYnX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapZYnX(matrix3f);
    }

    public Matrix3f mapZYnX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f mapZnXY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapZnXY(matrix3f);
    }

    public Matrix3f mapZnXY(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-f2)._m11(-f3)._m12(-f4)._m20(f5)._m21(f6)._m22(f7);
    }

    public Matrix3f mapZnXnY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapZnXnY(matrix3f);
    }

    public Matrix3f mapZnXnY(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-f2)._m11(-f3)._m12(-f4)._m20(-f5)._m21(-f6)._m22(-f7);
    }

    public Matrix3f mapZnYX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapZnYX(matrix3f);
    }

    public Matrix3f mapZnYX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapZnYnX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapZnYnX(matrix3f);
    }

    public Matrix3f mapZnYnX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f mapnXYnZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnXYnZ(matrix3f);
    }

    public Matrix3f mapnXYnZ(Matrix3f matrix3f) {
        return matrix3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3f mapnXZY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnXZY(matrix3f);
    }

    public Matrix3f mapnXZY(Matrix3f matrix3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapnXZnY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnXZnY(matrix3f);
    }

    public Matrix3f mapnXZnY(Matrix3f matrix3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f mapnXnYZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnXnYZ(matrix3f);
    }

    public Matrix3f mapnXnYZ(Matrix3f matrix3f) {
        return matrix3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3f mapnXnYnZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnXnYnZ(matrix3f);
    }

    public Matrix3f mapnXnYnZ(Matrix3f matrix3f) {
        return matrix3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3f mapnXnZY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnXnZY(matrix3f);
    }

    public Matrix3f mapnXnZY(Matrix3f matrix3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapnXnZnY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnXnZnY(matrix3f);
    }

    public Matrix3f mapnXnZnY(Matrix3f matrix3f) {
        float f2 = this.m10;
        float f3 = this.m11;
        float f4 = this.m12;
        return matrix3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f mapnYXZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnYXZ(matrix3f);
    }

    public Matrix3f mapnYXZ(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(f2)._m11(f3)._m12(f4)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3f mapnYXnZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnYXnZ(matrix3f);
    }

    public Matrix3f mapnYXnZ(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(f2)._m11(f3)._m12(f4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3f mapnYZX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnYZX(matrix3f);
    }

    public Matrix3f mapnYZX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapnYZnX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnYZnX(matrix3f);
    }

    public Matrix3f mapnYZnX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f mapnYnXZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnYnXZ(matrix3f);
    }

    public Matrix3f mapnYnXZ(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-f2)._m11(-f3)._m12(-f4)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3f mapnYnXnZ() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnYnXnZ(matrix3f);
    }

    public Matrix3f mapnYnXnZ(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-f2)._m11(-f3)._m12(-f4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3f mapnYnZX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnYnZX(matrix3f);
    }

    public Matrix3f mapnYnZX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapnYnZnX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnYnZnX(matrix3f);
    }

    public Matrix3f mapnYnZnX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f mapnZXY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnZXY(matrix3f);
    }

    public Matrix3f mapnZXY(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(f2)._m11(f3)._m12(f4)._m20(f5)._m21(f6)._m22(f7);
    }

    public Matrix3f mapnZXnY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnZXnY(matrix3f);
    }

    public Matrix3f mapnZXnY(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(f2)._m11(f3)._m12(f4)._m20(-f5)._m21(-f6)._m22(-f7);
    }

    public Matrix3f mapnZYX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnZYX(matrix3f);
    }

    public Matrix3f mapnZYX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapnZYnX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnZYnX(matrix3f);
    }

    public Matrix3f mapnZYnX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f mapnZnXY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnZnXY(matrix3f);
    }

    public Matrix3f mapnZnXY(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-f2)._m11(-f3)._m12(-f4)._m20(f5)._m21(f6)._m22(f7);
    }

    public Matrix3f mapnZnXnY() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnZnXnY(matrix3f);
    }

    public Matrix3f mapnZnXnY(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        return matrix3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-f2)._m11(-f3)._m12(-f4)._m20(-f5)._m21(-f6)._m22(-f7);
    }

    public Matrix3f mapnZnYX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnZnYX(matrix3f);
    }

    public Matrix3f mapnZnYX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(f2)._m21(f3)._m22(f4);
    }

    public Matrix3f mapnZnYnX() {
        Matrix3f matrix3f = this;
        return matrix3f.mapnZnYnX(matrix3f);
    }

    public Matrix3f mapnZnYnX(Matrix3f matrix3f) {
        float f2 = this.m00;
        float f3 = this.m01;
        float f4 = this.m02;
        return matrix3f._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-f2)._m21(-f3)._m22(-f4);
    }

    public Matrix3f negateX() {
        Matrix3f matrix3f = this;
        return matrix3f._m00(-matrix3f.m00)._m01(-this.m01)._m02(-this.m02);
    }

    public Matrix3f negateX(Matrix3f matrix3f) {
        return matrix3f._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3f negateY() {
        Matrix3f matrix3f = this;
        return matrix3f._m10(-matrix3f.m10)._m11(-this.m11)._m12(-this.m12);
    }

    public Matrix3f negateY(Matrix3f matrix3f) {
        return matrix3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3f negateZ() {
        Matrix3f matrix3f = this;
        return matrix3f._m20(-matrix3f.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3f negateZ(Matrix3f matrix3f) {
        return matrix3f._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

