/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.joml.Matrix3d;

public class Matrix3dStack
extends Matrix3d {
    private static final long serialVersionUID = 1L;
    private Matrix3d[] mats;
    private int curr;

    public Matrix3dStack(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("stackSize must be >= 1");
        }
        this.mats = new Matrix3d[n2 - 1];
        for (n2 = 0; n2 < this.mats.length; ++n2) {
            this.mats[n2] = new Matrix3d();
        }
    }

    public Matrix3dStack() {
    }

    public Matrix3dStack clear() {
        this.curr = 0;
        this.identity();
        return this;
    }

    public Matrix3dStack pushMatrix() {
        if (this.curr == this.mats.length) {
            throw new IllegalStateException("max stack size of " + (this.curr + 1) + " reached");
        }
        this.mats[this.curr++].set(this);
        return this;
    }

    public Matrix3dStack popMatrix() {
        if (this.curr == 0) {
            throw new IllegalStateException("already at the bottom of the stack");
        }
        Matrix3dStack matrix3dStack = this;
        matrix3dStack.set(matrix3dStack.mats[--this.curr]);
        return this;
    }

    public int hashCode() {
        int n2 = super.hashCode() * 31 + this.curr;
        for (int i2 = 0; i2 < this.curr; ++i2) {
            n2 = n2 * 31 + this.mats[i2].hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof Matrix3dStack) {
            object = (Matrix3dStack)object;
            if (this.curr != ((Matrix3dStack)object).curr) {
                return false;
            }
            for (int i2 = 0; i2 < this.curr; ++i2) {
                if (this.mats[i2].equals(((Matrix3dStack)object).mats[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.curr);
        for (int i2 = 0; i2 < this.curr; ++i2) {
            objectOutput.writeObject(this.mats[i2]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        super.readExternal(objectInput);
        this.curr = objectInput.readInt();
        this.mats = new Matrix3dStack[this.curr];
        for (int i2 = 0; i2 < this.curr; ++i2) {
            Matrix3d matrix3d = new Matrix3d();
            matrix3d.readExternal(objectInput);
            this.mats[i2] = matrix3d;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Matrix3dStack matrix3dStack = (Matrix3dStack)super.clone();
        Matrix3d[] matrix3dArray = new Matrix3d[this.mats.length];
        for (int i2 = 0; i2 < this.mats.length; ++i2) {
            matrix3dArray[i2] = (Matrix3d)this.mats[i2].clone();
        }
        matrix3dStack.mats = matrix3dArray;
        return matrix3dStack;
    }
}

