/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix2dc;
import org.joml.Matrix2fc;
import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Matrix3d
implements Externalizable,
Cloneable,
Matrix3dc {
    private static final long serialVersionUID = 1L;
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix3d() {
        this.m00 = 1.0;
        this.m11 = 1.0;
        this.m22 = 1.0;
    }

    public Matrix3d(Matrix2dc matrix2dc) {
        this.set(matrix2dc);
    }

    public Matrix3d(Matrix2fc matrix2fc) {
        this.set(matrix2fc);
    }

    public Matrix3d(Matrix3dc matrix3dc) {
        this.set(matrix3dc);
    }

    public Matrix3d(Matrix3fc matrix3fc) {
        this.set(matrix3fc);
    }

    public Matrix3d(Matrix4fc matrix4fc) {
        this.set(matrix4fc);
    }

    public Matrix3d(Matrix4dc matrix4dc) {
        this.set(matrix4dc);
    }

    public Matrix3d(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m20 = d8;
        this.m21 = d9;
        this.m22 = d10;
    }

    public Matrix3d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
    }

    public Matrix3d(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        this.set(vector3dc, vector3dc2, vector3dc3);
    }

    public double m00() {
        return this.m00;
    }

    public double m01() {
        return this.m01;
    }

    public double m02() {
        return this.m02;
    }

    public double m10() {
        return this.m10;
    }

    public double m11() {
        return this.m11;
    }

    public double m12() {
        return this.m12;
    }

    public double m20() {
        return this.m20;
    }

    public double m21() {
        return this.m21;
    }

    public double m22() {
        return this.m22;
    }

    public Matrix3d m00(double d2) {
        this.m00 = d2;
        return this;
    }

    public Matrix3d m01(double d2) {
        this.m01 = d2;
        return this;
    }

    public Matrix3d m02(double d2) {
        this.m02 = d2;
        return this;
    }

    public Matrix3d m10(double d2) {
        this.m10 = d2;
        return this;
    }

    public Matrix3d m11(double d2) {
        this.m11 = d2;
        return this;
    }

    public Matrix3d m12(double d2) {
        this.m12 = d2;
        return this;
    }

    public Matrix3d m20(double d2) {
        this.m20 = d2;
        return this;
    }

    public Matrix3d m21(double d2) {
        this.m21 = d2;
        return this;
    }

    public Matrix3d m22(double d2) {
        this.m22 = d2;
        return this;
    }

    Matrix3d _m00(double d2) {
        this.m00 = d2;
        return this;
    }

    Matrix3d _m01(double d2) {
        this.m01 = d2;
        return this;
    }

    Matrix3d _m02(double d2) {
        this.m02 = d2;
        return this;
    }

    Matrix3d _m10(double d2) {
        this.m10 = d2;
        return this;
    }

    Matrix3d _m11(double d2) {
        this.m11 = d2;
        return this;
    }

    Matrix3d _m12(double d2) {
        this.m12 = d2;
        return this;
    }

    Matrix3d _m20(double d2) {
        this.m20 = d2;
        return this;
    }

    Matrix3d _m21(double d2) {
        this.m21 = d2;
        return this;
    }

    Matrix3d _m22(double d2) {
        this.m22 = d2;
        return this;
    }

    public Matrix3d set(Matrix3dc matrix3dc) {
        if (matrix3dc == this) {
            return this;
        }
        this.m00 = matrix3dc.m00();
        this.m01 = matrix3dc.m01();
        this.m02 = matrix3dc.m02();
        this.m10 = matrix3dc.m10();
        this.m11 = matrix3dc.m11();
        this.m12 = matrix3dc.m12();
        this.m20 = matrix3dc.m20();
        this.m21 = matrix3dc.m21();
        this.m22 = matrix3dc.m22();
        return this;
    }

    public Matrix3d setTransposed(Matrix3dc matrix3dc) {
        double d2 = matrix3dc.m01();
        double d3 = matrix3dc.m21();
        double d4 = matrix3dc.m02();
        double d5 = matrix3dc.m12();
        return this._m00(matrix3dc.m00())._m01(matrix3dc.m10())._m02(matrix3dc.m20())._m10(d2)._m11(matrix3dc.m11())._m12(d3)._m20(d4)._m21(d5)._m22(matrix3dc.m22());
    }

    public Matrix3d set(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m02 = matrix3fc.m02();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
        this.m12 = matrix3fc.m12();
        this.m20 = matrix3fc.m20();
        this.m21 = matrix3fc.m21();
        this.m22 = matrix3fc.m22();
        return this;
    }

    public Matrix3d setTransposed(Matrix3fc matrix3fc) {
        float f2 = matrix3fc.m01();
        float f3 = matrix3fc.m21();
        float f4 = matrix3fc.m02();
        float f5 = matrix3fc.m12();
        return this._m00(matrix3fc.m00())._m01(matrix3fc.m10())._m02(matrix3fc.m20())._m10(f2)._m11(matrix3fc.m11())._m12(f3)._m20(f4)._m21(f5)._m22(matrix3fc.m22());
    }

    public Matrix3d set(Matrix4x3dc matrix4x3dc) {
        this.m00 = matrix4x3dc.m00();
        this.m01 = matrix4x3dc.m01();
        this.m02 = matrix4x3dc.m02();
        this.m10 = matrix4x3dc.m10();
        this.m11 = matrix4x3dc.m11();
        this.m12 = matrix4x3dc.m12();
        this.m20 = matrix4x3dc.m20();
        this.m21 = matrix4x3dc.m21();
        this.m22 = matrix4x3dc.m22();
        return this;
    }

    public Matrix3d set(Matrix4fc matrix4fc) {
        this.m00 = matrix4fc.m00();
        this.m01 = matrix4fc.m01();
        this.m02 = matrix4fc.m02();
        this.m10 = matrix4fc.m10();
        this.m11 = matrix4fc.m11();
        this.m12 = matrix4fc.m12();
        this.m20 = matrix4fc.m20();
        this.m21 = matrix4fc.m21();
        this.m22 = matrix4fc.m22();
        return this;
    }

    public Matrix3d set(Matrix4dc matrix4dc) {
        this.m00 = matrix4dc.m00();
        this.m01 = matrix4dc.m01();
        this.m02 = matrix4dc.m02();
        this.m10 = matrix4dc.m10();
        this.m11 = matrix4dc.m11();
        this.m12 = matrix4dc.m12();
        this.m20 = matrix4dc.m20();
        this.m21 = matrix4dc.m21();
        this.m22 = matrix4dc.m22();
        return this;
    }

    public Matrix3d set(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m02 = 0.0;
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix3d set(Matrix2dc matrix2dc) {
        this.m00 = matrix2dc.m00();
        this.m01 = matrix2dc.m01();
        this.m02 = 0.0;
        this.m10 = matrix2dc.m10();
        this.m11 = matrix2dc.m11();
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix3d set(AxisAngle4f axisAngle4f) {
        double d2 = axisAngle4f.x;
        double d3 = axisAngle4f.y;
        double d4 = axisAngle4f.z;
        double d5 = axisAngle4f.angle;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = Math.invsqrt(d6 * d6 + d7 * d7 + d8 * d8);
        d2 *= d9;
        d3 *= d9;
        d4 *= d9;
        double d10 = Math.sin(d5);
        double d11 = Math.cosFromSin(d10, d5);
        double d12 = 1.0 - d11;
        double d13 = d2;
        this.m00 = d11 + d13 * d13 * d12;
        double d14 = d3;
        this.m11 = d11 + d14 * d14 * d12;
        double d15 = d4;
        this.m22 = d11 + d15 * d15 * d12;
        double d16 = d2 * d3 * d12;
        double d17 = d4 * d10;
        this.m10 = d16 - d17;
        this.m01 = d16 + d17;
        d16 = d2 * d4 * d12;
        d17 = d3 * d10;
        this.m20 = d16 + d17;
        this.m02 = d16 - d17;
        d16 = d3 * d4 * d12;
        d17 = d2 * d10;
        this.m21 = d16 - d17;
        this.m12 = d16 + d17;
        return this;
    }

    public Matrix3d set(AxisAngle4d axisAngle4d) {
        double d2 = axisAngle4d.x;
        double d3 = axisAngle4d.y;
        double d4 = axisAngle4d.z;
        double d5 = axisAngle4d.angle;
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = Math.invsqrt(d6 * d6 + d7 * d7 + d8 * d8);
        d2 *= d9;
        d3 *= d9;
        d4 *= d9;
        double d10 = Math.sin(d5);
        double d11 = Math.cosFromSin(d10, d5);
        double d12 = 1.0 - d11;
        double d13 = d2;
        this.m00 = d11 + d13 * d13 * d12;
        double d14 = d3;
        this.m11 = d11 + d14 * d14 * d12;
        double d15 = d4;
        this.m22 = d11 + d15 * d15 * d12;
        double d16 = d2 * d3 * d12;
        double d17 = d4 * d10;
        this.m10 = d16 - d17;
        this.m01 = d16 + d17;
        d16 = d2 * d4 * d12;
        d17 = d3 * d10;
        this.m20 = d16 + d17;
        this.m02 = d16 - d17;
        d16 = d3 * d4 * d12;
        d17 = d2 * d10;
        this.m21 = d16 - d17;
        this.m12 = d16 + d17;
        return this;
    }

    public Matrix3d set(Quaternionfc quaternionfc) {
        return this.rotation(quaternionfc);
    }

    public Matrix3d set(Quaterniondc quaterniondc) {
        return this.rotation(quaterniondc);
    }

    public Matrix3d mul(Matrix3dc matrix3dc) {
        return this.mul(matrix3dc, this);
    }

    public Matrix3d mul(Matrix3dc matrix3dc, Matrix3d matrix3d) {
        double d2 = Math.fma(this.m00, matrix3dc.m00(), Math.fma(this.m10, matrix3dc.m01(), this.m20 * matrix3dc.m02()));
        double d3 = Math.fma(this.m01, matrix3dc.m00(), Math.fma(this.m11, matrix3dc.m01(), this.m21 * matrix3dc.m02()));
        double d4 = Math.fma(this.m02, matrix3dc.m00(), Math.fma(this.m12, matrix3dc.m01(), this.m22 * matrix3dc.m02()));
        double d5 = Math.fma(this.m00, matrix3dc.m10(), Math.fma(this.m10, matrix3dc.m11(), this.m20 * matrix3dc.m12()));
        double d6 = Math.fma(this.m01, matrix3dc.m10(), Math.fma(this.m11, matrix3dc.m11(), this.m21 * matrix3dc.m12()));
        double d7 = Math.fma(this.m02, matrix3dc.m10(), Math.fma(this.m12, matrix3dc.m11(), this.m22 * matrix3dc.m12()));
        double d8 = Math.fma(this.m00, matrix3dc.m20(), Math.fma(this.m10, matrix3dc.m21(), this.m20 * matrix3dc.m22()));
        double d9 = Math.fma(this.m01, matrix3dc.m20(), Math.fma(this.m11, matrix3dc.m21(), this.m21 * matrix3dc.m22()));
        double d10 = Math.fma(this.m02, matrix3dc.m20(), Math.fma(this.m12, matrix3dc.m21(), this.m22 * matrix3dc.m22()));
        matrix3d.m00 = d2;
        matrix3d.m01 = d3;
        matrix3d.m02 = d4;
        matrix3d.m10 = d5;
        matrix3d.m11 = d6;
        matrix3d.m12 = d7;
        matrix3d.m20 = d8;
        matrix3d.m21 = d9;
        matrix3d.m22 = d10;
        return matrix3d;
    }

    public Matrix3d mulLocal(Matrix3dc matrix3dc) {
        return this.mulLocal(matrix3dc, this);
    }

    public Matrix3d mulLocal(Matrix3dc matrix3dc, Matrix3d matrix3d) {
        double d2 = matrix3dc.m00() * this.m00 + matrix3dc.m10() * this.m01 + matrix3dc.m20() * this.m02;
        double d3 = matrix3dc.m01() * this.m00 + matrix3dc.m11() * this.m01 + matrix3dc.m21() * this.m02;
        double d4 = matrix3dc.m02() * this.m00 + matrix3dc.m12() * this.m01 + matrix3dc.m22() * this.m02;
        double d5 = matrix3dc.m00() * this.m10 + matrix3dc.m10() * this.m11 + matrix3dc.m20() * this.m12;
        double d6 = matrix3dc.m01() * this.m10 + matrix3dc.m11() * this.m11 + matrix3dc.m21() * this.m12;
        double d7 = matrix3dc.m02() * this.m10 + matrix3dc.m12() * this.m11 + matrix3dc.m22() * this.m12;
        double d8 = matrix3dc.m00() * this.m20 + matrix3dc.m10() * this.m21 + matrix3dc.m20() * this.m22;
        double d9 = matrix3dc.m01() * this.m20 + matrix3dc.m11() * this.m21 + matrix3dc.m21() * this.m22;
        double d10 = matrix3dc.m02() * this.m20 + matrix3dc.m12() * this.m21 + matrix3dc.m22() * this.m22;
        matrix3d.m00 = d2;
        matrix3d.m01 = d3;
        matrix3d.m02 = d4;
        matrix3d.m10 = d5;
        matrix3d.m11 = d6;
        matrix3d.m12 = d7;
        matrix3d.m20 = d8;
        matrix3d.m21 = d9;
        matrix3d.m22 = d10;
        return matrix3d;
    }

    public Matrix3d mul(Matrix3fc matrix3fc) {
        return this.mul(matrix3fc, this);
    }

    public Matrix3d mul(Matrix3fc matrix3fc, Matrix3d matrix3d) {
        double d2 = Math.fma(this.m00, (double)matrix3fc.m00(), Math.fma(this.m10, (double)matrix3fc.m01(), this.m20 * (double)matrix3fc.m02()));
        double d3 = Math.fma(this.m01, (double)matrix3fc.m00(), Math.fma(this.m11, (double)matrix3fc.m01(), this.m21 * (double)matrix3fc.m02()));
        double d4 = Math.fma(this.m02, (double)matrix3fc.m00(), Math.fma(this.m12, (double)matrix3fc.m01(), this.m22 * (double)matrix3fc.m02()));
        double d5 = Math.fma(this.m00, (double)matrix3fc.m10(), Math.fma(this.m10, (double)matrix3fc.m11(), this.m20 * (double)matrix3fc.m12()));
        double d6 = Math.fma(this.m01, (double)matrix3fc.m10(), Math.fma(this.m11, (double)matrix3fc.m11(), this.m21 * (double)matrix3fc.m12()));
        double d7 = Math.fma(this.m02, (double)matrix3fc.m10(), Math.fma(this.m12, (double)matrix3fc.m11(), this.m22 * (double)matrix3fc.m12()));
        double d8 = Math.fma(this.m00, (double)matrix3fc.m20(), Math.fma(this.m10, (double)matrix3fc.m21(), this.m20 * (double)matrix3fc.m22()));
        double d9 = Math.fma(this.m01, (double)matrix3fc.m20(), Math.fma(this.m11, (double)matrix3fc.m21(), this.m21 * (double)matrix3fc.m22()));
        double d10 = Math.fma(this.m02, (double)matrix3fc.m20(), Math.fma(this.m12, (double)matrix3fc.m21(), this.m22 * (double)matrix3fc.m22()));
        matrix3d.m00 = d2;
        matrix3d.m01 = d3;
        matrix3d.m02 = d4;
        matrix3d.m10 = d5;
        matrix3d.m11 = d6;
        matrix3d.m12 = d7;
        matrix3d.m20 = d8;
        matrix3d.m21 = d9;
        matrix3d.m22 = d10;
        return matrix3d;
    }

    public Matrix3d set(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m20 = d8;
        this.m21 = d9;
        this.m22 = d10;
        return this;
    }

    public Matrix3d set(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
        return this;
    }

    public Matrix3d set(double[] dArray, int n2) {
        this.m00 = dArray[n2];
        this.m01 = dArray[n2 + 1];
        this.m02 = dArray[n2 + 2];
        this.m10 = dArray[n2 + 3];
        this.m11 = dArray[n2 + 4];
        this.m12 = dArray[n2 + 5];
        this.m20 = dArray[n2 + 6];
        this.m21 = dArray[n2 + 7];
        this.m22 = dArray[n2 + 8];
        return this;
    }

    public Matrix3d set(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m10 = fArray[3];
        this.m11 = fArray[4];
        this.m12 = fArray[5];
        this.m20 = fArray[6];
        this.m21 = fArray[7];
        this.m22 = fArray[8];
        return this;
    }

    public Matrix3d set(float[] fArray, int n2) {
        this.m00 = fArray[n2];
        this.m01 = fArray[n2 + 1];
        this.m02 = fArray[n2 + 2];
        this.m10 = fArray[n2 + 3];
        this.m11 = fArray[n2 + 4];
        this.m12 = fArray[n2 + 5];
        this.m20 = fArray[n2 + 6];
        this.m21 = fArray[n2 + 7];
        this.m22 = fArray[n2 + 8];
        return this;
    }

    public double determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Matrix3d invert() {
        Matrix3d matrix3d = this;
        return matrix3d.invert(matrix3d);
    }

    public Matrix3d invert(Matrix3d matrix3d) {
        double d2 = Math.fma(this.m00, this.m11, -this.m01 * this.m10);
        double d3 = Math.fma(this.m02, this.m10, -this.m00 * this.m12);
        double d4 = Math.fma(this.m01, this.m12, -this.m02 * this.m11);
        double d5 = Math.fma(d2, this.m22, Math.fma(d3, this.m21, d4 * this.m20));
        double d6 = 1.0 / d5;
        double d7 = Math.fma(this.m11, this.m22, -this.m21 * this.m12) * d6;
        double d8 = Math.fma(this.m21, this.m02, -this.m01 * this.m22) * d6;
        double d9 = d4 * d6;
        double d10 = Math.fma(this.m20, this.m12, -this.m10 * this.m22) * d6;
        double d11 = Math.fma(this.m00, this.m22, -this.m20 * this.m02) * d6;
        double d12 = d3 * d6;
        double d13 = Math.fma(this.m10, this.m21, -this.m20 * this.m11) * d6;
        double d14 = Math.fma(this.m20, this.m01, -this.m00 * this.m21) * d6;
        double d15 = d2 * d6;
        matrix3d.m00 = d7;
        matrix3d.m01 = d8;
        matrix3d.m02 = d9;
        matrix3d.m10 = d10;
        matrix3d.m11 = d11;
        matrix3d.m12 = d12;
        matrix3d.m20 = d13;
        matrix3d.m21 = d14;
        matrix3d.m22 = d15;
        return matrix3d;
    }

    public Matrix3d transpose() {
        Matrix3d matrix3d = this;
        return matrix3d.transpose(matrix3d);
    }

    public Matrix3d transpose(Matrix3d matrix3d) {
        matrix3d.set(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        return matrix3d;
    }

    public String toString() {
        String string = this.toString(Options.NUMBER_FORMAT);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == 'E') {
                n2 = i2;
            } else {
                if (c2 == ' ' && n2 == i2 - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c2) && n2 == i2 - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + " " + Runtime.format(this.m20, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + " " + Runtime.format(this.m21, numberFormat) + "\n" + Runtime.format(this.m02, numberFormat) + " " + Runtime.format(this.m12, numberFormat) + " " + Runtime.format(this.m22, numberFormat) + "\n";
    }

    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    public AxisAngle4f getRotation(AxisAngle4f axisAngle4f) {
        return axisAngle4f.set(this);
    }

    public Quaternionf getUnnormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromUnnormalized(this);
    }

    public Quaternionf getNormalizedRotation(Quaternionf quaternionf) {
        return quaternionf.setFromNormalized(this);
    }

    public Quaterniond getUnnormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromUnnormalized(this);
    }

    public Quaterniond getNormalizedRotation(Quaterniond quaterniond) {
        return quaterniond.setFromNormalized(this);
    }

    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        return this.get(doubleBuffer.position(), doubleBuffer);
    }

    public DoubleBuffer get(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer get(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putf(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer getFloats(ByteBuffer byteBuffer) {
        return this.getFloats(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getFloats(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, n2, byteBuffer);
        return byteBuffer;
    }

    public DoubleBuffer getTransposed(DoubleBuffer doubleBuffer) {
        return this.getTransposed(doubleBuffer.position(), doubleBuffer);
    }

    public DoubleBuffer getTransposed(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public FloatBuffer getTransposed(FloatBuffer floatBuffer) {
        return this.getTransposed(floatBuffer.position(), floatBuffer);
    }

    public FloatBuffer getTransposed(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putfTransposed(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer getTransposed(ByteBuffer byteBuffer) {
        return this.getTransposed(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getTransposed(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n2, byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer getTransposedFloats(ByteBuffer byteBuffer) {
        return this.getTransposedFloats(byteBuffer.position(), byteBuffer);
    }

    public ByteBuffer getTransposedFloats(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putfTransposed(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Matrix3dc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Matrix3dc getTransposedToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.putTransposed(this, l2);
        return this;
    }

    public double[] get(double[] dArray, int n2) {
        dArray[n2] = this.m00;
        dArray[n2 + 1] = this.m01;
        dArray[n2 + 2] = this.m02;
        dArray[n2 + 3] = this.m10;
        dArray[n2 + 4] = this.m11;
        dArray[n2 + 5] = this.m12;
        dArray[n2 + 6] = this.m20;
        dArray[n2 + 7] = this.m21;
        dArray[n2 + 8] = this.m22;
        return dArray;
    }

    public double[] get(double[] dArray) {
        return this.get(dArray, 0);
    }

    public float[] get(float[] fArray, int n2) {
        fArray[n2] = (float)this.m00;
        fArray[n2 + 1] = (float)this.m01;
        fArray[n2 + 2] = (float)this.m02;
        fArray[n2 + 3] = (float)this.m10;
        fArray[n2 + 4] = (float)this.m11;
        fArray[n2 + 5] = (float)this.m12;
        fArray[n2 + 6] = (float)this.m20;
        fArray[n2 + 7] = (float)this.m21;
        fArray[n2 + 8] = (float)this.m22;
        return fArray;
    }

    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    public Matrix3d set(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        return this;
    }

    public Matrix3d set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.getf(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Matrix3d set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Matrix3d setFloats(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.getf(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Matrix3d set(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n2, doubleBuffer);
        return this;
    }

    public Matrix3d set(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.getf(this, n2, floatBuffer);
        return this;
    }

    public Matrix3d set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Matrix3d setFloats(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.getf(this, n2, byteBuffer);
        return this;
    }

    public Matrix3d setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l2);
        return this;
    }

    public Matrix3d setTransposedFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.getTransposed(this, l2);
        return this;
    }

    public Matrix3d set(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3) {
        this.m00 = vector3dc.x();
        this.m01 = vector3dc.y();
        this.m02 = vector3dc.z();
        this.m10 = vector3dc2.x();
        this.m11 = vector3dc2.y();
        this.m12 = vector3dc2.z();
        this.m20 = vector3dc3.x();
        this.m21 = vector3dc3.y();
        this.m22 = vector3dc3.z();
        return this;
    }

    public Matrix3d zero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        return this;
    }

    public Matrix3d identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix3d scaling(double d2) {
        this.m00 = d2;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d2;
        return this;
    }

    public Matrix3d scaling(double d2, double d3, double d4) {
        this.m00 = d2;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d3;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d4;
        return this;
    }

    public Matrix3d scaling(Vector3dc vector3dc) {
        this.m00 = vector3dc.x();
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = vector3dc.y();
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = vector3dc.z();
        return this;
    }

    public Matrix3d scale(Vector3dc vector3dc, Matrix3d matrix3d) {
        return this.scale(vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix3d);
    }

    public Matrix3d scale(Vector3dc vector3dc) {
        return this.scale(vector3dc.x(), vector3dc.y(), vector3dc.z(), this);
    }

    public Matrix3d scale(double d2, double d3, double d4, Matrix3d matrix3d) {
        matrix3d.m00 = this.m00 * d2;
        matrix3d.m01 = this.m01 * d2;
        matrix3d.m02 = this.m02 * d2;
        matrix3d.m10 = this.m10 * d3;
        matrix3d.m11 = this.m11 * d3;
        matrix3d.m12 = this.m12 * d3;
        matrix3d.m20 = this.m20 * d4;
        matrix3d.m21 = this.m21 * d4;
        matrix3d.m22 = this.m22 * d4;
        return matrix3d;
    }

    public Matrix3d scale(double d2, double d3, double d4) {
        return this.scale(d2, d3, d4, this);
    }

    public Matrix3d scale(double d2, Matrix3d matrix3d) {
        double d3 = d2;
        return this.scale(d3, d3, d2, matrix3d);
    }

    public Matrix3d scale(double d2) {
        double d3 = d2;
        return this.scale(d3, d3, d2);
    }

    public Matrix3d scaleLocal(double d2, double d3, double d4, Matrix3d matrix3d) {
        double d5 = d2 * this.m00;
        double d6 = d3 * this.m01;
        double d7 = d4 * this.m02;
        double d8 = d2 * this.m10;
        double d9 = d3 * this.m11;
        double d10 = d4 * this.m12;
        double d11 = d2 * this.m20;
        double d12 = d3 * this.m21;
        double d13 = d4 * this.m22;
        matrix3d.m00 = d5;
        matrix3d.m01 = d6;
        matrix3d.m02 = d7;
        matrix3d.m10 = d8;
        matrix3d.m11 = d9;
        matrix3d.m12 = d10;
        matrix3d.m20 = d11;
        matrix3d.m21 = d12;
        matrix3d.m22 = d13;
        return matrix3d;
    }

    public Matrix3d scaleLocal(double d2, double d3, double d4) {
        return this.scaleLocal(d2, d3, d4, this);
    }

    public Matrix3d rotation(double d2, Vector3dc vector3dc) {
        return this.rotation(d2, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix3d rotation(double d2, Vector3fc vector3fc) {
        return this.rotation(d2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3d rotation(AxisAngle4f axisAngle4f) {
        return this.rotation(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix3d rotation(AxisAngle4d axisAngle4d) {
        return this.rotation(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Matrix3d rotation(double d2, double d3, double d4, double d5) {
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = 1.0 - d7;
        double d9 = d3 * d4;
        double d10 = d3 * d5;
        double d11 = d4 * d5;
        double d12 = d3;
        this.m00 = d7 + d12 * d12 * d8;
        this.m10 = d9 * d8 - d5 * d6;
        this.m20 = d10 * d8 + d4 * d6;
        this.m01 = d9 * d8 + d5 * d6;
        double d13 = d4;
        this.m11 = d7 + d13 * d13 * d8;
        this.m21 = d11 * d8 - d3 * d6;
        this.m02 = d10 * d8 - d4 * d6;
        this.m12 = d11 * d8 + d3 * d6;
        double d14 = d5;
        this.m22 = d7 + d14 * d14 * d8;
        return this;
    }

    public Matrix3d rotationX(double d2) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d4;
        this.m12 = d3;
        this.m20 = 0.0;
        this.m21 = -d3;
        this.m22 = d4;
        return this;
    }

    public Matrix3d rotationY(double d2) {
        double d3;
        double d4 = Math.sin(d2);
        this.m00 = d3 = Math.cosFromSin(d4, d2);
        this.m01 = 0.0;
        this.m02 = -d4;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = d4;
        this.m21 = 0.0;
        this.m22 = d3;
        return this;
    }

    public Matrix3d rotationZ(double d2) {
        double d3;
        double d4 = Math.sin(d2);
        this.m00 = d3 = Math.cosFromSin(d4, d2);
        this.m01 = d4;
        this.m02 = 0.0;
        this.m10 = -d4;
        this.m11 = d3;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix3d rotationXYZ(double d2, double d3, double d4) {
        double d5 = Math.sin(d2);
        double d6 = Math.cosFromSin(d5, d2);
        double d7 = Math.sin(d3);
        double d8 = Math.cosFromSin(d7, d3);
        double d9 = Math.sin(d4);
        double d10 = Math.cosFromSin(d9, d4);
        double d11 = -d5;
        double d12 = -d7;
        double d13 = -d9;
        double d14 = d11 * d12;
        double d15 = d6 * d12;
        this.m20 = d7;
        this.m21 = d11 * d8;
        this.m22 = d6 * d8;
        this.m00 = d8 * d10;
        this.m01 = d14 * d10 + d6 * d9;
        this.m02 = d15 * d10 + d5 * d9;
        this.m10 = d8 * d13;
        this.m11 = d14 * d13 + d6 * d10;
        this.m12 = d15 * d13 + d5 * d10;
        return this;
    }

    public Matrix3d rotationZYX(double d2, double d3, double d4) {
        double d5 = Math.sin(d4);
        double d6 = Math.cosFromSin(d5, d4);
        double d7 = Math.sin(d3);
        double d8 = Math.cosFromSin(d7, d3);
        double d9 = Math.sin(d2);
        double d10 = Math.cosFromSin(d9, d2);
        double d11 = -d9;
        double d12 = -d7;
        double d13 = -d5;
        double d14 = d10 * d7;
        double d15 = d9 * d7;
        this.m00 = d10 * d8;
        this.m01 = d9 * d8;
        this.m02 = d12;
        this.m10 = d11 * d6 + d14 * d5;
        this.m11 = d10 * d6 + d15 * d5;
        this.m12 = d8 * d5;
        this.m20 = d11 * d13 + d14 * d6;
        this.m21 = d10 * d13 + d15 * d6;
        this.m22 = d8 * d6;
        return this;
    }

    public Matrix3d rotationYXZ(double d2, double d3, double d4) {
        double d5 = Math.sin(d3);
        double d6 = Math.cosFromSin(d5, d3);
        double d7 = Math.sin(d2);
        double d8 = Math.cosFromSin(d7, d2);
        double d9 = Math.sin(d4);
        double d10 = Math.cosFromSin(d9, d4);
        double d11 = -d7;
        double d12 = -d5;
        double d13 = -d9;
        double d14 = d7 * d5;
        double d15 = d8 * d5;
        this.m20 = d7 * d6;
        this.m21 = d12;
        this.m22 = d8 * d6;
        this.m00 = d8 * d10 + d14 * d9;
        this.m01 = d6 * d9;
        this.m02 = d11 * d10 + d15 * d9;
        this.m10 = d8 * d13 + d14 * d10;
        this.m11 = d6 * d10;
        this.m12 = d11 * d13 + d15 * d10;
        return this;
    }

    public Matrix3d rotation(Quaterniondc quaterniondc) {
        double d2 = quaterniondc.w() * quaterniondc.w();
        double d3 = quaterniondc.x() * quaterniondc.x();
        double d4 = quaterniondc.y() * quaterniondc.y();
        double d5 = quaterniondc.z() * quaterniondc.z();
        double d6 = quaterniondc.z() * quaterniondc.w();
        double d7 = d6 + d6;
        double d8 = quaterniondc.x() * quaterniondc.y();
        double d9 = d8 + d8;
        double d10 = quaterniondc.x() * quaterniondc.z();
        double d11 = d10 + d10;
        double d12 = quaterniondc.y() * quaterniondc.w();
        double d13 = d12 + d12;
        double d14 = quaterniondc.y() * quaterniondc.z();
        double d15 = d14 + d14;
        double d16 = quaterniondc.x() * quaterniondc.w();
        double d17 = d16 + d16;
        this.m00 = d2 + d3 - d5 - d4;
        this.m01 = d9 + d7;
        this.m02 = d11 - d13;
        this.m10 = -d7 + d9;
        this.m11 = d4 - d5 + d2 - d3;
        this.m12 = d15 + d17;
        this.m20 = d13 + d11;
        this.m21 = d15 - d17;
        this.m22 = d5 - d4 - d3 + d2;
        return this;
    }

    public Matrix3d rotation(Quaternionfc quaternionfc) {
        double d2 = quaternionfc.w() * quaternionfc.w();
        double d3 = quaternionfc.x() * quaternionfc.x();
        double d4 = quaternionfc.y() * quaternionfc.y();
        double d5 = quaternionfc.z() * quaternionfc.z();
        double d6 = quaternionfc.z() * quaternionfc.w();
        double d7 = d6 + d6;
        double d8 = quaternionfc.x() * quaternionfc.y();
        double d9 = d8 + d8;
        double d10 = quaternionfc.x() * quaternionfc.z();
        double d11 = d10 + d10;
        double d12 = quaternionfc.y() * quaternionfc.w();
        double d13 = d12 + d12;
        double d14 = quaternionfc.y() * quaternionfc.z();
        double d15 = d14 + d14;
        double d16 = quaternionfc.x() * quaternionfc.w();
        double d17 = d16 + d16;
        this.m00 = d2 + d3 - d5 - d4;
        this.m01 = d9 + d7;
        this.m02 = d11 - d13;
        this.m10 = -d7 + d9;
        this.m11 = d4 - d5 + d2 - d3;
        this.m12 = d15 + d17;
        this.m20 = d13 + d11;
        this.m21 = d15 - d17;
        this.m22 = d5 - d4 - d3 + d2;
        return this;
    }

    public Vector3d transform(Vector3d vector3d) {
        return vector3d.mul(this);
    }

    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        vector3dc.mul((Matrix3dc)this, vector3d);
        return vector3d;
    }

    public Vector3f transform(Vector3f vector3f) {
        return vector3f.mul(this);
    }

    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        return vector3fc.mul(this, vector3f);
    }

    public Vector3d transform(double d2, double d3, double d4, Vector3d vector3d) {
        return vector3d.set(Math.fma(this.m00, d2, Math.fma(this.m10, d3, this.m20 * d4)), Math.fma(this.m01, d2, Math.fma(this.m11, d3, this.m21 * d4)), Math.fma(this.m02, d2, Math.fma(this.m12, d3, this.m22 * d4)));
    }

    public Vector3d transformTranspose(Vector3d vector3d) {
        return vector3d.mulTranspose(this);
    }

    public Vector3d transformTranspose(Vector3dc vector3dc, Vector3d vector3d) {
        return vector3dc.mulTranspose(this, vector3d);
    }

    public Vector3d transformTranspose(double d2, double d3, double d4, Vector3d vector3d) {
        return vector3d.set(Math.fma(this.m00, d2, Math.fma(this.m01, d3, this.m02 * d4)), Math.fma(this.m10, d2, Math.fma(this.m11, d3, this.m12 * d4)), Math.fma(this.m20, d2, Math.fma(this.m21, d3, this.m22 * d4)));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.m00);
        objectOutput.writeDouble(this.m01);
        objectOutput.writeDouble(this.m02);
        objectOutput.writeDouble(this.m10);
        objectOutput.writeDouble(this.m11);
        objectOutput.writeDouble(this.m12);
        objectOutput.writeDouble(this.m20);
        objectOutput.writeDouble(this.m21);
        objectOutput.writeDouble(this.m22);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.m00 = objectInput.readDouble();
        this.m01 = objectInput.readDouble();
        this.m02 = objectInput.readDouble();
        this.m10 = objectInput.readDouble();
        this.m11 = objectInput.readDouble();
        this.m12 = objectInput.readDouble();
        this.m20 = objectInput.readDouble();
        this.m21 = objectInput.readDouble();
        this.m22 = objectInput.readDouble();
    }

    public Matrix3d rotateX(double d2, Matrix3d matrix3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = -d3;
        double d6 = this.m10 * d4 + this.m20 * d3;
        double d7 = this.m11 * d4 + this.m21 * d3;
        double d8 = this.m12 * d4 + this.m22 * d3;
        matrix3d.m20 = this.m10 * d5 + this.m20 * d4;
        matrix3d.m21 = this.m11 * d5 + this.m21 * d4;
        matrix3d.m22 = this.m12 * d5 + this.m22 * d4;
        matrix3d.m10 = d6;
        matrix3d.m11 = d7;
        matrix3d.m12 = d8;
        matrix3d.m00 = this.m00;
        matrix3d.m01 = this.m01;
        matrix3d.m02 = this.m02;
        return matrix3d;
    }

    public Matrix3d rotateX(double d2) {
        return this.rotateX(d2, this);
    }

    public Matrix3d rotateY(double d2, Matrix3d matrix3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = -d3;
        double d6 = this.m00 * d4 + this.m20 * d5;
        double d7 = this.m01 * d4 + this.m21 * d5;
        double d8 = this.m02 * d4 + this.m22 * d5;
        matrix3d.m20 = this.m00 * d3 + this.m20 * d4;
        matrix3d.m21 = this.m01 * d3 + this.m21 * d4;
        matrix3d.m22 = this.m02 * d3 + this.m22 * d4;
        matrix3d.m00 = d6;
        matrix3d.m01 = d7;
        matrix3d.m02 = d8;
        matrix3d.m10 = this.m10;
        matrix3d.m11 = this.m11;
        matrix3d.m12 = this.m12;
        return matrix3d;
    }

    public Matrix3d rotateY(double d2) {
        return this.rotateY(d2, this);
    }

    public Matrix3d rotateZ(double d2, Matrix3d matrix3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = -d3;
        double d6 = this.m00 * d4 + this.m10 * d3;
        double d7 = this.m01 * d4 + this.m11 * d3;
        double d8 = this.m02 * d4 + this.m12 * d3;
        matrix3d.m10 = this.m00 * d5 + this.m10 * d4;
        matrix3d.m11 = this.m01 * d5 + this.m11 * d4;
        matrix3d.m12 = this.m02 * d5 + this.m12 * d4;
        matrix3d.m00 = d6;
        matrix3d.m01 = d7;
        matrix3d.m02 = d8;
        matrix3d.m20 = this.m20;
        matrix3d.m21 = this.m21;
        matrix3d.m22 = this.m22;
        return matrix3d;
    }

    public Matrix3d rotateZ(double d2) {
        return this.rotateZ(d2, this);
    }

    public Matrix3d rotateXYZ(double d2, double d3, double d4) {
        return this.rotateXYZ(d2, d3, d4, this);
    }

    public Matrix3d rotateXYZ(double d2, double d3, double d4, Matrix3d matrix3d) {
        double d5 = Math.sin(d2);
        double d6 = Math.cosFromSin(d5, d2);
        double d7 = Math.sin(d3);
        double d8 = Math.cosFromSin(d7, d3);
        double d9 = Math.sin(d4);
        double d10 = Math.cosFromSin(d9, d4);
        double d11 = -d5;
        double d12 = -d7;
        double d13 = -d9;
        double d14 = this.m10 * d6 + this.m20 * d5;
        double d15 = this.m11 * d6 + this.m21 * d5;
        double d16 = this.m12 * d6 + this.m22 * d5;
        double d17 = this.m10 * d11 + this.m20 * d6;
        double d18 = this.m11 * d11 + this.m21 * d6;
        double d19 = this.m12 * d11 + this.m22 * d6;
        double d20 = this.m00 * d8 + d17 * d12;
        double d21 = this.m01 * d8 + d18 * d12;
        double d22 = this.m02 * d8 + d19 * d12;
        matrix3d.m20 = this.m00 * d7 + d17 * d8;
        matrix3d.m21 = this.m01 * d7 + d18 * d8;
        matrix3d.m22 = this.m02 * d7 + d19 * d8;
        matrix3d.m00 = d20 * d10 + d14 * d9;
        matrix3d.m01 = d21 * d10 + d15 * d9;
        matrix3d.m02 = d22 * d10 + d16 * d9;
        matrix3d.m10 = d20 * d13 + d14 * d10;
        matrix3d.m11 = d21 * d13 + d15 * d10;
        matrix3d.m12 = d22 * d13 + d16 * d10;
        return matrix3d;
    }

    public Matrix3d rotateZYX(double d2, double d3, double d4) {
        return this.rotateZYX(d2, d3, d4, this);
    }

    public Matrix3d rotateZYX(double d2, double d3, double d4, Matrix3d matrix3d) {
        double d5 = Math.sin(d4);
        double d6 = Math.cosFromSin(d5, d4);
        double d7 = Math.sin(d3);
        double d8 = Math.cosFromSin(d7, d3);
        double d9 = Math.sin(d2);
        double d10 = Math.cosFromSin(d9, d2);
        double d11 = -d9;
        double d12 = -d7;
        double d13 = -d5;
        double d14 = this.m00 * d10 + this.m10 * d9;
        double d15 = this.m01 * d10 + this.m11 * d9;
        double d16 = this.m02 * d10 + this.m12 * d9;
        double d17 = this.m00 * d11 + this.m10 * d10;
        double d18 = this.m01 * d11 + this.m11 * d10;
        double d19 = this.m02 * d11 + this.m12 * d10;
        double d20 = d14 * d7 + this.m20 * d8;
        double d21 = d15 * d7 + this.m21 * d8;
        double d22 = d16 * d7 + this.m22 * d8;
        matrix3d.m00 = d14 * d8 + this.m20 * d12;
        matrix3d.m01 = d15 * d8 + this.m21 * d12;
        matrix3d.m02 = d16 * d8 + this.m22 * d12;
        matrix3d.m10 = d17 * d6 + d20 * d5;
        matrix3d.m11 = d18 * d6 + d21 * d5;
        matrix3d.m12 = d19 * d6 + d22 * d5;
        matrix3d.m20 = d17 * d13 + d20 * d6;
        matrix3d.m21 = d18 * d13 + d21 * d6;
        matrix3d.m22 = d19 * d13 + d22 * d6;
        return matrix3d;
    }

    public Matrix3d rotateYXZ(Vector3d vector3d) {
        return this.rotateYXZ(vector3d.y, vector3d.x, vector3d.z);
    }

    public Matrix3d rotateYXZ(double d2, double d3, double d4) {
        return this.rotateYXZ(d2, d3, d4, this);
    }

    public Matrix3d rotateYXZ(double d2, double d3, double d4, Matrix3d matrix3d) {
        double d5 = Math.sin(d3);
        double d6 = Math.cosFromSin(d5, d3);
        double d7 = Math.sin(d2);
        double d8 = Math.cosFromSin(d7, d2);
        double d9 = Math.sin(d4);
        double d10 = Math.cosFromSin(d9, d4);
        double d11 = -d7;
        double d12 = -d5;
        double d13 = -d9;
        double d14 = this.m00 * d7 + this.m20 * d8;
        double d15 = this.m01 * d7 + this.m21 * d8;
        double d16 = this.m02 * d7 + this.m22 * d8;
        double d17 = this.m00 * d8 + this.m20 * d11;
        double d18 = this.m01 * d8 + this.m21 * d11;
        double d19 = this.m02 * d8 + this.m22 * d11;
        double d20 = this.m10 * d6 + d14 * d5;
        double d21 = this.m11 * d6 + d15 * d5;
        double d22 = this.m12 * d6 + d16 * d5;
        matrix3d.m20 = this.m10 * d12 + d14 * d6;
        matrix3d.m21 = this.m11 * d12 + d15 * d6;
        matrix3d.m22 = this.m12 * d12 + d16 * d6;
        matrix3d.m00 = d17 * d10 + d20 * d9;
        matrix3d.m01 = d18 * d10 + d21 * d9;
        matrix3d.m02 = d19 * d10 + d22 * d9;
        matrix3d.m10 = d17 * d13 + d20 * d10;
        matrix3d.m11 = d18 * d13 + d21 * d10;
        matrix3d.m12 = d19 * d13 + d22 * d10;
        return matrix3d;
    }

    public Matrix3d rotate(double d2, double d3, double d4, double d5) {
        return this.rotate(d2, d3, d4, d5, this);
    }

    public Matrix3d rotate(double d2, double d3, double d4, double d5, Matrix3d matrix3d) {
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = 1.0 - d7;
        double d9 = d3;
        double d10 = d9 * d9;
        double d11 = d3 * d4;
        double d12 = d3 * d5;
        double d13 = d4;
        double d14 = d13 * d13;
        double d15 = d4 * d5;
        double d16 = d5;
        double d17 = d16 * d16;
        double d18 = d10 * d8 + d7;
        double d19 = d11 * d8 + d5 * d6;
        double d20 = d12 * d8 - d4 * d6;
        double d21 = d11 * d8 - d5 * d6;
        double d22 = d14 * d8 + d7;
        double d23 = d15 * d8 + d3 * d6;
        double d24 = d12 * d8 + d4 * d6;
        double d25 = d15 * d8 - d3 * d6;
        double d26 = d17 * d8 + d7;
        double d27 = this.m00 * d18 + this.m10 * d19 + this.m20 * d20;
        double d28 = this.m01 * d18 + this.m11 * d19 + this.m21 * d20;
        double d29 = this.m02 * d18 + this.m12 * d19 + this.m22 * d20;
        double d30 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        double d31 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        double d32 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        matrix3d.m20 = this.m00 * d24 + this.m10 * d25 + this.m20 * d26;
        matrix3d.m21 = this.m01 * d24 + this.m11 * d25 + this.m21 * d26;
        matrix3d.m22 = this.m02 * d24 + this.m12 * d25 + this.m22 * d26;
        matrix3d.m00 = d27;
        matrix3d.m01 = d28;
        matrix3d.m02 = d29;
        matrix3d.m10 = d30;
        matrix3d.m11 = d31;
        matrix3d.m12 = d32;
        return matrix3d;
    }

    public Matrix3d rotateLocal(double d2, double d3, double d4, double d5, Matrix3d matrix3d) {
        double d6 = Math.sin(d2);
        double d7 = Math.cosFromSin(d6, d2);
        double d8 = 1.0 - d7;
        double d9 = d3;
        double d10 = d9 * d9;
        double d11 = d3 * d4;
        double d12 = d3 * d5;
        double d13 = d4;
        double d14 = d13 * d13;
        double d15 = d4 * d5;
        double d16 = d5;
        double d17 = d16 * d16;
        double d18 = d10 * d8 + d7;
        double d19 = d11 * d8 + d5 * d6;
        double d20 = d12 * d8 - d4 * d6;
        double d21 = d11 * d8 - d5 * d6;
        double d22 = d14 * d8 + d7;
        double d23 = d15 * d8 + d3 * d6;
        double d24 = d12 * d8 + d4 * d6;
        double d25 = d15 * d8 - d3 * d6;
        double d26 = d17 * d8 + d7;
        double d27 = d18 * this.m00 + d21 * this.m01 + d24 * this.m02;
        double d28 = d19 * this.m00 + d22 * this.m01 + d25 * this.m02;
        double d29 = d20 * this.m00 + d23 * this.m01 + d26 * this.m02;
        double d30 = d18 * this.m10 + d21 * this.m11 + d24 * this.m12;
        double d31 = d19 * this.m10 + d22 * this.m11 + d25 * this.m12;
        double d32 = d20 * this.m10 + d23 * this.m11 + d26 * this.m12;
        double d33 = d18 * this.m20 + d21 * this.m21 + d24 * this.m22;
        double d34 = d19 * this.m20 + d22 * this.m21 + d25 * this.m22;
        double d35 = d20 * this.m20 + d23 * this.m21 + d26 * this.m22;
        matrix3d.m00 = d27;
        matrix3d.m01 = d28;
        matrix3d.m02 = d29;
        matrix3d.m10 = d30;
        matrix3d.m11 = d31;
        matrix3d.m12 = d32;
        matrix3d.m20 = d33;
        matrix3d.m21 = d34;
        matrix3d.m22 = d35;
        return matrix3d;
    }

    public Matrix3d rotateLocal(double d2, double d3, double d4, double d5) {
        return this.rotateLocal(d2, d3, d4, d5, this);
    }

    public Matrix3d rotateLocalX(double d2, Matrix3d matrix3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = d4 * this.m01 - d3 * this.m02;
        double d6 = d3 * this.m01 + d4 * this.m02;
        double d7 = d4 * this.m11 - d3 * this.m12;
        double d8 = d3 * this.m11 + d4 * this.m12;
        double d9 = d4 * this.m21 - d3 * this.m22;
        double d10 = d3 * this.m21 + d4 * this.m22;
        matrix3d.m00 = this.m00;
        matrix3d.m01 = d5;
        matrix3d.m02 = d6;
        matrix3d.m10 = this.m10;
        matrix3d.m11 = d7;
        matrix3d.m12 = d8;
        matrix3d.m20 = this.m20;
        matrix3d.m21 = d9;
        matrix3d.m22 = d10;
        return matrix3d;
    }

    public Matrix3d rotateLocalX(double d2) {
        return this.rotateLocalX(d2, this);
    }

    public Matrix3d rotateLocalY(double d2, Matrix3d matrix3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = d4 * this.m00 + d3 * this.m02;
        double d6 = -d3 * this.m00 + d4 * this.m02;
        double d7 = d4 * this.m10 + d3 * this.m12;
        double d8 = -d3 * this.m10 + d4 * this.m12;
        double d9 = d4 * this.m20 + d3 * this.m22;
        double d10 = -d3 * this.m20 + d4 * this.m22;
        matrix3d.m00 = d5;
        matrix3d.m01 = this.m01;
        matrix3d.m02 = d6;
        matrix3d.m10 = d7;
        matrix3d.m11 = this.m11;
        matrix3d.m12 = d8;
        matrix3d.m20 = d9;
        matrix3d.m21 = this.m21;
        matrix3d.m22 = d10;
        return matrix3d;
    }

    public Matrix3d rotateLocalY(double d2) {
        return this.rotateLocalY(d2, this);
    }

    public Matrix3d rotateLocalZ(double d2, Matrix3d matrix3d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = d4 * this.m00 - d3 * this.m01;
        double d6 = d3 * this.m00 + d4 * this.m01;
        double d7 = d4 * this.m10 - d3 * this.m11;
        double d8 = d3 * this.m10 + d4 * this.m11;
        double d9 = d4 * this.m20 - d3 * this.m21;
        double d10 = d3 * this.m20 + d4 * this.m21;
        matrix3d.m00 = d5;
        matrix3d.m01 = d6;
        matrix3d.m02 = this.m02;
        matrix3d.m10 = d7;
        matrix3d.m11 = d8;
        matrix3d.m12 = this.m12;
        matrix3d.m20 = d9;
        matrix3d.m21 = d10;
        matrix3d.m22 = this.m22;
        return matrix3d;
    }

    public Matrix3d rotateLocalZ(double d2) {
        return this.rotateLocalZ(d2, this);
    }

    public Matrix3d rotateLocal(Quaterniondc quaterniondc, Matrix3d matrix3d) {
        double d2 = quaterniondc.w() * quaterniondc.w();
        double d3 = quaterniondc.x() * quaterniondc.x();
        double d4 = quaterniondc.y() * quaterniondc.y();
        double d5 = quaterniondc.z() * quaterniondc.z();
        double d6 = quaterniondc.z() * quaterniondc.w();
        double d7 = d6 + d6;
        double d8 = quaterniondc.x() * quaterniondc.y();
        double d9 = d8 + d8;
        double d10 = quaterniondc.x() * quaterniondc.z();
        double d11 = d10 + d10;
        double d12 = quaterniondc.y() * quaterniondc.w();
        double d13 = d12 + d12;
        double d14 = quaterniondc.y() * quaterniondc.z();
        double d15 = d14 + d14;
        double d16 = quaterniondc.x() * quaterniondc.w();
        double d17 = d16 + d16;
        double d18 = d2 + d3 - d5 - d4;
        double d19 = d9 + d7;
        double d20 = d11 - d13;
        double d21 = d9 - d7;
        double d22 = d4 - d5 + d2 - d3;
        double d23 = d15 + d17;
        double d24 = d13 + d11;
        double d25 = d15 - d17;
        double d26 = d5 - d4 - d3 + d2;
        double d27 = d18 * this.m00 + d21 * this.m01 + d24 * this.m02;
        double d28 = d19 * this.m00 + d22 * this.m01 + d25 * this.m02;
        double d29 = d20 * this.m00 + d23 * this.m01 + d26 * this.m02;
        double d30 = d18 * this.m10 + d21 * this.m11 + d24 * this.m12;
        double d31 = d19 * this.m10 + d22 * this.m11 + d25 * this.m12;
        double d32 = d20 * this.m10 + d23 * this.m11 + d26 * this.m12;
        double d33 = d18 * this.m20 + d21 * this.m21 + d24 * this.m22;
        double d34 = d19 * this.m20 + d22 * this.m21 + d25 * this.m22;
        double d35 = d20 * this.m20 + d23 * this.m21 + d26 * this.m22;
        matrix3d.m00 = d27;
        matrix3d.m01 = d28;
        matrix3d.m02 = d29;
        matrix3d.m10 = d30;
        matrix3d.m11 = d31;
        matrix3d.m12 = d32;
        matrix3d.m20 = d33;
        matrix3d.m21 = d34;
        matrix3d.m22 = d35;
        return matrix3d;
    }

    public Matrix3d rotateLocal(Quaterniondc quaterniondc) {
        return this.rotateLocal(quaterniondc, this);
    }

    public Matrix3d rotateLocal(Quaternionfc quaternionfc, Matrix3d matrix3d) {
        double d2 = quaternionfc.w() * quaternionfc.w();
        double d3 = quaternionfc.x() * quaternionfc.x();
        double d4 = quaternionfc.y() * quaternionfc.y();
        double d5 = quaternionfc.z() * quaternionfc.z();
        double d6 = quaternionfc.z() * quaternionfc.w();
        double d7 = d6 + d6;
        double d8 = quaternionfc.x() * quaternionfc.y();
        double d9 = d8 + d8;
        double d10 = quaternionfc.x() * quaternionfc.z();
        double d11 = d10 + d10;
        double d12 = quaternionfc.y() * quaternionfc.w();
        double d13 = d12 + d12;
        double d14 = quaternionfc.y() * quaternionfc.z();
        double d15 = d14 + d14;
        double d16 = quaternionfc.x() * quaternionfc.w();
        double d17 = d16 + d16;
        double d18 = d2 + d3 - d5 - d4;
        double d19 = d9 + d7;
        double d20 = d11 - d13;
        double d21 = d9 - d7;
        double d22 = d4 - d5 + d2 - d3;
        double d23 = d15 + d17;
        double d24 = d13 + d11;
        double d25 = d15 - d17;
        double d26 = d5 - d4 - d3 + d2;
        double d27 = d18 * this.m00 + d21 * this.m01 + d24 * this.m02;
        double d28 = d19 * this.m00 + d22 * this.m01 + d25 * this.m02;
        double d29 = d20 * this.m00 + d23 * this.m01 + d26 * this.m02;
        double d30 = d18 * this.m10 + d21 * this.m11 + d24 * this.m12;
        double d31 = d19 * this.m10 + d22 * this.m11 + d25 * this.m12;
        double d32 = d20 * this.m10 + d23 * this.m11 + d26 * this.m12;
        double d33 = d18 * this.m20 + d21 * this.m21 + d24 * this.m22;
        double d34 = d19 * this.m20 + d22 * this.m21 + d25 * this.m22;
        double d35 = d20 * this.m20 + d23 * this.m21 + d26 * this.m22;
        matrix3d.m00 = d27;
        matrix3d.m01 = d28;
        matrix3d.m02 = d29;
        matrix3d.m10 = d30;
        matrix3d.m11 = d31;
        matrix3d.m12 = d32;
        matrix3d.m20 = d33;
        matrix3d.m21 = d34;
        matrix3d.m22 = d35;
        return matrix3d;
    }

    public Matrix3d rotateLocal(Quaternionfc quaternionfc) {
        return this.rotateLocal(quaternionfc, this);
    }

    public Matrix3d rotate(Quaterniondc quaterniondc) {
        return this.rotate(quaterniondc, this);
    }

    public Matrix3d rotate(Quaterniondc quaterniondc, Matrix3d matrix3d) {
        double d2 = quaterniondc.w() * quaterniondc.w();
        double d3 = quaterniondc.x() * quaterniondc.x();
        double d4 = quaterniondc.y() * quaterniondc.y();
        double d5 = quaterniondc.z() * quaterniondc.z();
        double d6 = quaterniondc.z() * quaterniondc.w();
        double d7 = d6 + d6;
        double d8 = quaterniondc.x() * quaterniondc.y();
        double d9 = d8 + d8;
        double d10 = quaterniondc.x() * quaterniondc.z();
        double d11 = d10 + d10;
        double d12 = quaterniondc.y() * quaterniondc.w();
        double d13 = d12 + d12;
        double d14 = quaterniondc.y() * quaterniondc.z();
        double d15 = d14 + d14;
        double d16 = quaterniondc.x() * quaterniondc.w();
        double d17 = d16 + d16;
        double d18 = d2 + d3 - d5 - d4;
        double d19 = d9 + d7;
        double d20 = d11 - d13;
        double d21 = d9 - d7;
        double d22 = d4 - d5 + d2 - d3;
        double d23 = d15 + d17;
        double d24 = d13 + d11;
        double d25 = d15 - d17;
        double d26 = d5 - d4 - d3 + d2;
        double d27 = this.m00 * d18 + this.m10 * d19 + this.m20 * d20;
        double d28 = this.m01 * d18 + this.m11 * d19 + this.m21 * d20;
        double d29 = this.m02 * d18 + this.m12 * d19 + this.m22 * d20;
        double d30 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        double d31 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        double d32 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        matrix3d.m20 = this.m00 * d24 + this.m10 * d25 + this.m20 * d26;
        matrix3d.m21 = this.m01 * d24 + this.m11 * d25 + this.m21 * d26;
        matrix3d.m22 = this.m02 * d24 + this.m12 * d25 + this.m22 * d26;
        matrix3d.m00 = d27;
        matrix3d.m01 = d28;
        matrix3d.m02 = d29;
        matrix3d.m10 = d30;
        matrix3d.m11 = d31;
        matrix3d.m12 = d32;
        return matrix3d;
    }

    public Matrix3d rotate(Quaternionfc quaternionfc) {
        return this.rotate(quaternionfc, this);
    }

    public Matrix3d rotate(Quaternionfc quaternionfc, Matrix3d matrix3d) {
        double d2 = quaternionfc.w() * quaternionfc.w();
        double d3 = quaternionfc.x() * quaternionfc.x();
        double d4 = quaternionfc.y() * quaternionfc.y();
        double d5 = quaternionfc.z() * quaternionfc.z();
        double d6 = quaternionfc.z() * quaternionfc.w();
        double d7 = d6 + d6;
        double d8 = quaternionfc.x() * quaternionfc.y();
        double d9 = d8 + d8;
        double d10 = quaternionfc.x() * quaternionfc.z();
        double d11 = d10 + d10;
        double d12 = quaternionfc.y() * quaternionfc.w();
        double d13 = d12 + d12;
        double d14 = quaternionfc.y() * quaternionfc.z();
        double d15 = d14 + d14;
        double d16 = quaternionfc.x() * quaternionfc.w();
        double d17 = d16 + d16;
        double d18 = d2 + d3 - d5 - d4;
        double d19 = d9 + d7;
        double d20 = d11 - d13;
        double d21 = d9 - d7;
        double d22 = d4 - d5 + d2 - d3;
        double d23 = d15 + d17;
        double d24 = d13 + d11;
        double d25 = d15 - d17;
        double d26 = d5 - d4 - d3 + d2;
        double d27 = this.m00 * d18 + this.m10 * d19 + this.m20 * d20;
        double d28 = this.m01 * d18 + this.m11 * d19 + this.m21 * d20;
        double d29 = this.m02 * d18 + this.m12 * d19 + this.m22 * d20;
        double d30 = this.m00 * d21 + this.m10 * d22 + this.m20 * d23;
        double d31 = this.m01 * d21 + this.m11 * d22 + this.m21 * d23;
        double d32 = this.m02 * d21 + this.m12 * d22 + this.m22 * d23;
        matrix3d.m20 = this.m00 * d24 + this.m10 * d25 + this.m20 * d26;
        matrix3d.m21 = this.m01 * d24 + this.m11 * d25 + this.m21 * d26;
        matrix3d.m22 = this.m02 * d24 + this.m12 * d25 + this.m22 * d26;
        matrix3d.m00 = d27;
        matrix3d.m01 = d28;
        matrix3d.m02 = d29;
        matrix3d.m10 = d30;
        matrix3d.m11 = d31;
        matrix3d.m12 = d32;
        return matrix3d;
    }

    public Matrix3d rotate(AxisAngle4f axisAngle4f) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
    }

    public Matrix3d rotate(AxisAngle4f axisAngle4f, Matrix3d matrix3d) {
        return this.rotate(axisAngle4f.angle, axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, matrix3d);
    }

    public Matrix3d rotate(AxisAngle4d axisAngle4d) {
        return this.rotate(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
    }

    public Matrix3d rotate(AxisAngle4d axisAngle4d, Matrix3d matrix3d) {
        return this.rotate(axisAngle4d.angle, axisAngle4d.x, axisAngle4d.y, axisAngle4d.z, matrix3d);
    }

    public Matrix3d rotate(double d2, Vector3dc vector3dc) {
        return this.rotate(d2, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix3d rotate(double d2, Vector3dc vector3dc, Matrix3d matrix3d) {
        return this.rotate(d2, vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix3d);
    }

    public Matrix3d rotate(double d2, Vector3fc vector3fc) {
        return this.rotate(d2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3d rotate(double d2, Vector3fc vector3fc, Matrix3d matrix3d) {
        return this.rotate(d2, vector3fc.x(), vector3fc.y(), vector3fc.z(), matrix3d);
    }

    public Vector3d getRow(int n2, Vector3d vector3d) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                return vector3d.set(this.m00, this.m10, this.m20);
            }
            case 1: {
                return vector3d.set(this.m01, this.m11, this.m21);
            }
            case 2: {
                return vector3d.set(this.m02, this.m12, this.m22);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix3d setRow(int n2, Vector3dc vector3dc) throws IndexOutOfBoundsException {
        return this.setRow(n2, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix3d setRow(int n2, double d2, double d3, double d4) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                this.m00 = d2;
                this.m10 = d3;
                this.m20 = d4;
                break;
            }
            case 1: {
                this.m01 = d2;
                this.m11 = d3;
                this.m21 = d4;
                break;
            }
            case 2: {
                this.m02 = d2;
                this.m12 = d3;
                this.m22 = d4;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public Vector3d getColumn(int n2, Vector3d vector3d) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                return vector3d.set(this.m00, this.m01, this.m02);
            }
            case 1: {
                return vector3d.set(this.m10, this.m11, this.m12);
            }
            case 2: {
                return vector3d.set(this.m20, this.m21, this.m22);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix3d setColumn(int n2, Vector3dc vector3dc) throws IndexOutOfBoundsException {
        return this.setColumn(n2, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix3d setColumn(int n2, double d2, double d3, double d4) throws IndexOutOfBoundsException {
        switch (n2) {
            case 0: {
                this.m00 = d2;
                this.m01 = d3;
                this.m02 = d4;
                break;
            }
            case 1: {
                this.m10 = d2;
                this.m11 = d3;
                this.m12 = d4;
                break;
            }
            case 2: {
                this.m20 = d2;
                this.m21 = d3;
                this.m22 = d4;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public double get(int n2, int n3) {
        return MemUtil.INSTANCE.get(this, n2, n3);
    }

    public Matrix3d set(int n2, int n3, double d2) {
        return MemUtil.INSTANCE.set(this, n2, n3, d2);
    }

    public double getRowColumn(int n2, int n3) {
        return MemUtil.INSTANCE.get(this, n3, n2);
    }

    public Matrix3d setRowColumn(int n2, int n3, double d2) {
        return MemUtil.INSTANCE.set(this, n3, n2, d2);
    }

    public Matrix3d normal() {
        Matrix3d matrix3d = this;
        return matrix3d.normal(matrix3d);
    }

    public Matrix3d normal(Matrix3d matrix3d) {
        double d2 = this.m00 * this.m11;
        double d3 = this.m01 * this.m10;
        double d4 = this.m02 * this.m10;
        double d5 = this.m00 * this.m12;
        double d6 = this.m01 * this.m12;
        double d7 = this.m02 * this.m11;
        double d8 = (d2 - d3) * this.m22 + (d4 - d5) * this.m21 + (d6 - d7) * this.m20;
        double d9 = 1.0 / d8;
        double d10 = (this.m11 * this.m22 - this.m21 * this.m12) * d9;
        double d11 = (this.m20 * this.m12 - this.m10 * this.m22) * d9;
        double d12 = (this.m10 * this.m21 - this.m20 * this.m11) * d9;
        double d13 = (this.m21 * this.m02 - this.m01 * this.m22) * d9;
        double d14 = (this.m00 * this.m22 - this.m20 * this.m02) * d9;
        double d15 = (this.m20 * this.m01 - this.m00 * this.m21) * d9;
        double d16 = (d6 - d7) * d9;
        double d17 = (d4 - d5) * d9;
        double d18 = (d2 - d3) * d9;
        matrix3d.m00 = d10;
        matrix3d.m01 = d11;
        matrix3d.m02 = d12;
        matrix3d.m10 = d13;
        matrix3d.m11 = d14;
        matrix3d.m12 = d15;
        matrix3d.m20 = d16;
        matrix3d.m21 = d17;
        matrix3d.m22 = d18;
        return matrix3d;
    }

    public Matrix3d cofactor() {
        Matrix3d matrix3d = this;
        return matrix3d.cofactor(matrix3d);
    }

    public Matrix3d cofactor(Matrix3d matrix3d) {
        double d2 = this.m11 * this.m22 - this.m21 * this.m12;
        double d3 = this.m20 * this.m12 - this.m10 * this.m22;
        double d4 = this.m10 * this.m21 - this.m20 * this.m11;
        double d5 = this.m21 * this.m02 - this.m01 * this.m22;
        double d6 = this.m00 * this.m22 - this.m20 * this.m02;
        double d7 = this.m20 * this.m01 - this.m00 * this.m21;
        double d8 = this.m01 * this.m12 - this.m11 * this.m02;
        double d9 = this.m02 * this.m10 - this.m12 * this.m00;
        double d10 = this.m00 * this.m11 - this.m10 * this.m01;
        matrix3d.m00 = d2;
        matrix3d.m01 = d3;
        matrix3d.m02 = d4;
        matrix3d.m10 = d5;
        matrix3d.m11 = d6;
        matrix3d.m12 = d7;
        matrix3d.m20 = d8;
        matrix3d.m21 = d9;
        matrix3d.m22 = d10;
        return matrix3d;
    }

    public Matrix3d lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    public Matrix3d lookAlong(Vector3dc vector3dc, Vector3dc vector3dc2, Matrix3d matrix3d) {
        return this.lookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix3d);
    }

    public Matrix3d lookAlong(double d2, double d3, double d4, double d5, double d6, double d7, Matrix3d matrix3d) {
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d6 * (d4 *= -d11) - d7 * (d3 *= -d11);
        double d13 = d7 * (d2 *= -d11) - d5 * d4;
        double d14 = d5 * d3 - d6 * d2;
        double d15 = d12;
        double d16 = d13;
        double d17 = d14;
        double d18 = Math.invsqrt(d15 * d15 + d16 * d16 + d17 * d17);
        double d19 = d3 * (d14 *= d18) - d4 * (d13 *= d18);
        double d20 = d4 * (d12 *= d18) - d2 * d14;
        double d21 = d2 * d13 - d3 * d12;
        double d22 = this.m00 * d12 + this.m10 * d19 + this.m20 * d2;
        double d23 = this.m01 * d12 + this.m11 * d19 + this.m21 * d2;
        double d24 = this.m02 * d12 + this.m12 * d19 + this.m22 * d2;
        double d25 = this.m00 * d13 + this.m10 * d20 + this.m20 * d3;
        double d26 = this.m01 * d13 + this.m11 * d20 + this.m21 * d3;
        double d27 = this.m02 * d13 + this.m12 * d20 + this.m22 * d3;
        matrix3d.m20 = this.m00 * d14 + this.m10 * d21 + this.m20 * d4;
        matrix3d.m21 = this.m01 * d14 + this.m11 * d21 + this.m21 * d4;
        matrix3d.m22 = this.m02 * d14 + this.m12 * d21 + this.m22 * d4;
        matrix3d.m00 = d22;
        matrix3d.m01 = d23;
        matrix3d.m02 = d24;
        matrix3d.m10 = d25;
        matrix3d.m11 = d26;
        matrix3d.m12 = d27;
        return matrix3d;
    }

    public Matrix3d lookAlong(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.lookAlong(d2, d3, d4, d5, d6, d7, this);
    }

    public Matrix3d setLookAlong(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.setLookAlong(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix3d setLookAlong(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d6 * (d4 *= -d11) - d7 * (d3 *= -d11);
        double d13 = d7 * (d2 *= -d11) - d5 * d4;
        double d14 = d5 * d3 - d6 * d2;
        double d15 = d12;
        double d16 = d13;
        double d17 = d14;
        double d18 = Math.invsqrt(d15 * d15 + d16 * d16 + d17 * d17);
        double d19 = d3 * (d14 *= d18) - d4 * (d13 *= d18);
        double d20 = d4 * (d12 *= d18) - d2 * d14;
        double d21 = d2 * d13 - d3 * d12;
        this.m00 = d12;
        this.m01 = d19;
        this.m02 = d2;
        this.m10 = d13;
        this.m11 = d20;
        this.m12 = d3;
        this.m20 = d14;
        this.m21 = d21;
        this.m22 = d4;
        return this;
    }

    public Vector3d getScale(Vector3d vector3d) {
        vector3d.x = Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        vector3d.y = Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        vector3d.z = Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        return vector3d;
    }

    public Vector3d positiveZ(Vector3d vector3d) {
        vector3d.x = this.m10 * this.m21 - this.m11 * this.m20;
        vector3d.y = this.m20 * this.m01 - this.m21 * this.m00;
        vector3d.z = this.m00 * this.m11 - this.m01 * this.m10;
        Vector3d vector3d2 = vector3d;
        return vector3d2.normalize(vector3d2);
    }

    public Vector3d normalizedPositiveZ(Vector3d vector3d) {
        vector3d.x = this.m02;
        vector3d.y = this.m12;
        vector3d.z = this.m22;
        return vector3d;
    }

    public Vector3d positiveX(Vector3d vector3d) {
        vector3d.x = this.m11 * this.m22 - this.m12 * this.m21;
        vector3d.y = this.m02 * this.m21 - this.m01 * this.m22;
        vector3d.z = this.m01 * this.m12 - this.m02 * this.m11;
        Vector3d vector3d2 = vector3d;
        return vector3d2.normalize(vector3d2);
    }

    public Vector3d normalizedPositiveX(Vector3d vector3d) {
        vector3d.x = this.m00;
        vector3d.y = this.m10;
        vector3d.z = this.m20;
        return vector3d;
    }

    public Vector3d positiveY(Vector3d vector3d) {
        vector3d.x = this.m12 * this.m20 - this.m10 * this.m22;
        vector3d.y = this.m00 * this.m22 - this.m02 * this.m20;
        vector3d.z = this.m02 * this.m10 - this.m00 * this.m12;
        Vector3d vector3d2 = vector3d;
        return vector3d2.normalize(vector3d2);
    }

    public Vector3d normalizedPositiveY(Vector3d vector3d) {
        vector3d.x = this.m01;
        vector3d.y = this.m11;
        vector3d.z = this.m21;
        return vector3d;
    }

    public int hashCode() {
        long l2;
        long l3 = l2 = Double.doubleToLongBits(this.m00);
        int n2 = 31 + (int)(l3 ^ l3 >>> 32);
        long l4 = l2 = Double.doubleToLongBits(this.m01);
        n2 = n2 * 31 + (int)(l4 ^ l4 >>> 32);
        long l5 = l2 = Double.doubleToLongBits(this.m02);
        n2 = n2 * 31 + (int)(l5 ^ l5 >>> 32);
        long l6 = l2 = Double.doubleToLongBits(this.m10);
        n2 = n2 * 31 + (int)(l6 ^ l6 >>> 32);
        long l7 = l2 = Double.doubleToLongBits(this.m11);
        n2 = n2 * 31 + (int)(l7 ^ l7 >>> 32);
        long l8 = l2 = Double.doubleToLongBits(this.m12);
        n2 = n2 * 31 + (int)(l8 ^ l8 >>> 32);
        long l9 = l2 = Double.doubleToLongBits(this.m20);
        n2 = n2 * 31 + (int)(l9 ^ l9 >>> 32);
        long l10 = l2 = Double.doubleToLongBits(this.m21);
        n2 = n2 * 31 + (int)(l10 ^ l10 >>> 32);
        long l11 = l2 = Double.doubleToLongBits(this.m22);
        return n2 * 31 + (int)(l11 ^ l11 >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Matrix3d)) {
            return false;
        }
        object = (Matrix3d)object;
        if (Double.doubleToLongBits(this.m00) != Double.doubleToLongBits(((Matrix3d)object).m00)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m01) != Double.doubleToLongBits(((Matrix3d)object).m01)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m02) != Double.doubleToLongBits(((Matrix3d)object).m02)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m10) != Double.doubleToLongBits(((Matrix3d)object).m10)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m11) != Double.doubleToLongBits(((Matrix3d)object).m11)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m12) != Double.doubleToLongBits(((Matrix3d)object).m12)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m20) != Double.doubleToLongBits(((Matrix3d)object).m20)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m21) != Double.doubleToLongBits(((Matrix3d)object).m21)) {
            return false;
        }
        return Double.doubleToLongBits(this.m22) == Double.doubleToLongBits(((Matrix3d)object).m22);
    }

    public boolean equals(Matrix3dc matrix3dc, double d2) {
        if (this == matrix3dc) {
            return true;
        }
        if (matrix3dc == null) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix3dc.m00(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix3dc.m01(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m02, matrix3dc.m02(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix3dc.m10(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m11, matrix3dc.m11(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m12, matrix3dc.m12(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m20, matrix3dc.m20(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.m21, matrix3dc.m21(), d2)) {
            return false;
        }
        return Runtime.equals(this.m22, matrix3dc.m22(), d2);
    }

    public Matrix3d swap(Matrix3d matrix3d) {
        double d2 = this.m00;
        this.m00 = matrix3d.m00;
        matrix3d.m00 = d2;
        d2 = this.m01;
        this.m01 = matrix3d.m01;
        matrix3d.m01 = d2;
        d2 = this.m02;
        this.m02 = matrix3d.m02;
        matrix3d.m02 = d2;
        d2 = this.m10;
        this.m10 = matrix3d.m10;
        matrix3d.m10 = d2;
        d2 = this.m11;
        this.m11 = matrix3d.m11;
        matrix3d.m11 = d2;
        d2 = this.m12;
        this.m12 = matrix3d.m12;
        matrix3d.m12 = d2;
        d2 = this.m20;
        this.m20 = matrix3d.m20;
        matrix3d.m20 = d2;
        d2 = this.m21;
        this.m21 = matrix3d.m21;
        matrix3d.m21 = d2;
        d2 = this.m22;
        this.m22 = matrix3d.m22;
        matrix3d.m22 = d2;
        return this;
    }

    public Matrix3d add(Matrix3dc matrix3dc) {
        return this.add(matrix3dc, this);
    }

    public Matrix3d add(Matrix3dc matrix3dc, Matrix3d matrix3d) {
        matrix3d.m00 = this.m00 + matrix3dc.m00();
        matrix3d.m01 = this.m01 + matrix3dc.m01();
        matrix3d.m02 = this.m02 + matrix3dc.m02();
        matrix3d.m10 = this.m10 + matrix3dc.m10();
        matrix3d.m11 = this.m11 + matrix3dc.m11();
        matrix3d.m12 = this.m12 + matrix3dc.m12();
        matrix3d.m20 = this.m20 + matrix3dc.m20();
        matrix3d.m21 = this.m21 + matrix3dc.m21();
        matrix3d.m22 = this.m22 + matrix3dc.m22();
        return matrix3d;
    }

    public Matrix3d sub(Matrix3dc matrix3dc) {
        return this.sub(matrix3dc, this);
    }

    public Matrix3d sub(Matrix3dc matrix3dc, Matrix3d matrix3d) {
        matrix3d.m00 = this.m00 - matrix3dc.m00();
        matrix3d.m01 = this.m01 - matrix3dc.m01();
        matrix3d.m02 = this.m02 - matrix3dc.m02();
        matrix3d.m10 = this.m10 - matrix3dc.m10();
        matrix3d.m11 = this.m11 - matrix3dc.m11();
        matrix3d.m12 = this.m12 - matrix3dc.m12();
        matrix3d.m20 = this.m20 - matrix3dc.m20();
        matrix3d.m21 = this.m21 - matrix3dc.m21();
        matrix3d.m22 = this.m22 - matrix3dc.m22();
        return matrix3d;
    }

    public Matrix3d mulComponentWise(Matrix3dc matrix3dc) {
        return this.mulComponentWise(matrix3dc, this);
    }

    public Matrix3d mulComponentWise(Matrix3dc matrix3dc, Matrix3d matrix3d) {
        matrix3d.m00 = this.m00 * matrix3dc.m00();
        matrix3d.m01 = this.m01 * matrix3dc.m01();
        matrix3d.m02 = this.m02 * matrix3dc.m02();
        matrix3d.m10 = this.m10 * matrix3dc.m10();
        matrix3d.m11 = this.m11 * matrix3dc.m11();
        matrix3d.m12 = this.m12 * matrix3dc.m12();
        matrix3d.m20 = this.m20 * matrix3dc.m20();
        matrix3d.m21 = this.m21 * matrix3dc.m21();
        matrix3d.m22 = this.m22 * matrix3dc.m22();
        return matrix3d;
    }

    public Matrix3d setSkewSymmetric(double d2, double d3, double d4) {
        Matrix3d matrix3d = this;
        this.m22 = 0.0;
        matrix3d.m11 = 0.0;
        matrix3d.m00 = 0.0;
        this.m01 = -d2;
        this.m02 = d3;
        this.m10 = d2;
        this.m12 = -d4;
        this.m20 = -d3;
        this.m21 = d4;
        return this;
    }

    public Matrix3d lerp(Matrix3dc matrix3dc, double d2) {
        return this.lerp(matrix3dc, d2, this);
    }

    public Matrix3d lerp(Matrix3dc matrix3dc, double d2, Matrix3d matrix3d) {
        matrix3d.m00 = Math.fma(matrix3dc.m00() - this.m00, d2, this.m00);
        matrix3d.m01 = Math.fma(matrix3dc.m01() - this.m01, d2, this.m01);
        matrix3d.m02 = Math.fma(matrix3dc.m02() - this.m02, d2, this.m02);
        matrix3d.m10 = Math.fma(matrix3dc.m10() - this.m10, d2, this.m10);
        matrix3d.m11 = Math.fma(matrix3dc.m11() - this.m11, d2, this.m11);
        matrix3d.m12 = Math.fma(matrix3dc.m12() - this.m12, d2, this.m12);
        matrix3d.m20 = Math.fma(matrix3dc.m20() - this.m20, d2, this.m20);
        matrix3d.m21 = Math.fma(matrix3dc.m21() - this.m21, d2, this.m21);
        matrix3d.m22 = Math.fma(matrix3dc.m22() - this.m22, d2, this.m22);
        return matrix3d;
    }

    public Matrix3d rotateTowards(Vector3dc vector3dc, Vector3dc vector3dc2, Matrix3d matrix3d) {
        return this.rotateTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), matrix3d);
    }

    public Matrix3d rotateTowards(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotateTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), this);
    }

    public Matrix3d rotateTowards(double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.rotateTowards(d2, d3, d4, d5, d6, d7, this);
    }

    public Matrix3d rotateTowards(double d2, double d3, double d4, double d5, double d6, double d7, Matrix3d matrix3d) {
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d2 * d11;
        double d13 = d3 * d11;
        double d14 = d4 * d11;
        double d15 = d6 * d14 - d7 * d13;
        double d16 = d7 * d12 - d5 * d14;
        double d17 = d5 * d13 - d6 * d12;
        double d18 = d15;
        double d19 = d16;
        double d20 = d17;
        double d21 = Math.invsqrt(d18 * d18 + d19 * d19 + d20 * d20);
        double d22 = d13 * (d17 *= d21) - d14 * (d16 *= d21);
        double d23 = d14 * (d15 *= d21) - d12 * d17;
        double d24 = d12 * d16 - d13 * d15;
        double d25 = this.m00 * d15 + this.m10 * d16 + this.m20 * d17;
        double d26 = this.m01 * d15 + this.m11 * d16 + this.m21 * d17;
        double d27 = this.m02 * d15 + this.m12 * d16 + this.m22 * d17;
        double d28 = this.m00 * d22 + this.m10 * d23 + this.m20 * d24;
        double d29 = this.m01 * d22 + this.m11 * d23 + this.m21 * d24;
        double d30 = this.m02 * d22 + this.m12 * d23 + this.m22 * d24;
        matrix3d.m20 = this.m00 * d12 + this.m10 * d13 + this.m20 * d14;
        matrix3d.m21 = this.m01 * d12 + this.m11 * d13 + this.m21 * d14;
        matrix3d.m22 = this.m02 * d12 + this.m12 * d13 + this.m22 * d14;
        matrix3d.m00 = d25;
        matrix3d.m01 = d26;
        matrix3d.m02 = d27;
        matrix3d.m10 = d28;
        matrix3d.m11 = d29;
        matrix3d.m12 = d30;
        return matrix3d;
    }

    public Matrix3d rotationTowards(Vector3dc vector3dc, Vector3dc vector3dc2) {
        return this.rotationTowards(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z());
    }

    public Matrix3d rotationTowards(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = Math.invsqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d2 * d11;
        double d13 = d3 * d11;
        double d14 = d4 * d11;
        double d15 = d6 * d14 - d7 * d13;
        double d16 = d7 * d12 - d5 * d14;
        double d17 = d5 * d13 - d6 * d12;
        double d18 = d15;
        double d19 = d16;
        double d20 = d17;
        double d21 = Math.invsqrt(d18 * d18 + d19 * d19 + d20 * d20);
        double d22 = d13 * (d17 *= d21) - d14 * (d16 *= d21);
        double d23 = d14 * (d15 *= d21) - d12 * d17;
        double d24 = d12 * d16 - d13 * d15;
        this.m00 = d15;
        this.m01 = d16;
        this.m02 = d17;
        this.m10 = d22;
        this.m11 = d23;
        this.m12 = d24;
        this.m20 = d12;
        this.m21 = d13;
        this.m22 = d14;
        return this;
    }

    public Vector3d getEulerAnglesZYX(Vector3d vector3d) {
        vector3d.x = Math.atan2(this.m12, this.m22);
        vector3d.y = Math.atan2(-this.m02, Math.sqrt(1.0 - this.m02 * this.m02));
        vector3d.z = Math.atan2(this.m01, this.m00);
        return vector3d;
    }

    public Vector3d getEulerAnglesXYZ(Vector3d vector3d) {
        vector3d.x = Math.atan2(-this.m21, this.m22);
        vector3d.y = Math.atan2(this.m20, Math.sqrt(1.0 - this.m20 * this.m20));
        vector3d.z = Math.atan2(-this.m10, this.m00);
        return vector3d;
    }

    public Vector3d getEulerAnglesYXZ(Vector3d vector3d) {
        vector3d.x = Math.atan2(-this.m21, Math.sqrt(1.0 - this.m21 * this.m21));
        vector3d.y = Math.atan2(this.m20, this.m22);
        vector3d.z = Math.atan2(this.m01, this.m11);
        return vector3d;
    }

    public Matrix3d obliqueZ(double d2, double d3) {
        this.m20 = this.m00 * d2 + this.m10 * d3 + this.m20;
        this.m21 = this.m01 * d2 + this.m11 * d3 + this.m21;
        this.m22 = this.m02 * d2 + this.m12 * d3 + this.m22;
        return this;
    }

    public Matrix3d obliqueZ(double d2, double d3, Matrix3d matrix3d) {
        matrix3d.m00 = this.m00;
        matrix3d.m01 = this.m01;
        matrix3d.m02 = this.m02;
        matrix3d.m10 = this.m10;
        matrix3d.m11 = this.m11;
        matrix3d.m12 = this.m12;
        matrix3d.m20 = this.m00 * d2 + this.m10 * d3 + this.m20;
        matrix3d.m21 = this.m01 * d2 + this.m11 * d3 + this.m21;
        matrix3d.m22 = this.m02 * d2 + this.m12 * d3 + this.m22;
        return matrix3d;
    }

    public Matrix3d reflect(double d2, double d3, double d4, Matrix3d matrix3d) {
        double d5 = d2;
        double d6 = d5 + d5;
        double d7 = d3;
        double d8 = d7 + d7;
        double d9 = d4;
        double d10 = d9 + d9;
        double d11 = 1.0 - d6 * d2;
        double d12 = -d6 * d3;
        double d13 = -d6 * d4;
        double d14 = -d8 * d2;
        double d15 = 1.0 - d8 * d3;
        double d16 = -d8 * d4;
        double d17 = -d10 * d2;
        double d18 = -d10 * d3;
        double d19 = 1.0 - d10 * d4;
        double d20 = this.m00 * d11 + this.m10 * d12 + this.m20 * d13;
        double d21 = this.m01 * d11 + this.m11 * d12 + this.m21 * d13;
        double d22 = this.m02 * d11 + this.m12 * d12 + this.m22 * d13;
        double d23 = this.m00 * d14 + this.m10 * d15 + this.m20 * d16;
        double d24 = this.m01 * d14 + this.m11 * d15 + this.m21 * d16;
        double d25 = this.m02 * d14 + this.m12 * d15 + this.m22 * d16;
        return matrix3d._m20(this.m00 * d17 + this.m10 * d18 + this.m20 * d19)._m21(this.m01 * d17 + this.m11 * d18 + this.m21 * d19)._m22(this.m02 * d17 + this.m12 * d18 + this.m22 * d19)._m00(d20)._m01(d21)._m02(d22)._m10(d23)._m11(d24)._m12(d25);
    }

    public Matrix3d reflect(double d2, double d3, double d4) {
        return this.reflect(d2, d3, d4, this);
    }

    public Matrix3d reflect(Vector3dc vector3dc) {
        return this.reflect(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix3d reflect(Quaterniondc quaterniondc) {
        return this.reflect(quaterniondc, this);
    }

    public Matrix3d reflect(Quaterniondc quaterniondc, Matrix3d matrix3d) {
        double d2 = quaterniondc.x() + quaterniondc.x();
        double d3 = quaterniondc.y() + quaterniondc.y();
        double d4 = quaterniondc.z() + quaterniondc.z();
        double d5 = quaterniondc.x() * d4 + quaterniondc.w() * d3;
        double d6 = quaterniondc.y() * d4 - quaterniondc.w() * d2;
        double d7 = 1.0 - (quaterniondc.x() * d2 + quaterniondc.y() * d3);
        return this.reflect(d5, d6, d7, matrix3d);
    }

    public Matrix3d reflect(Vector3dc vector3dc, Matrix3d matrix3d) {
        return this.reflect(vector3dc.x(), vector3dc.y(), vector3dc.z(), matrix3d);
    }

    public Matrix3d reflection(double d2, double d3, double d4) {
        double d5 = d2;
        double d6 = d5 + d5;
        double d7 = d3;
        double d8 = d7 + d7;
        double d9 = d4;
        double d10 = d9 + d9;
        this._m00(1.0 - d6 * d2);
        this._m01(-d6 * d3);
        this._m02(-d6 * d4);
        this._m10(-d8 * d2);
        this._m11(1.0 - d8 * d3);
        this._m12(-d8 * d4);
        this._m20(-d10 * d2);
        this._m21(-d10 * d3);
        this._m22(1.0 - d10 * d4);
        return this;
    }

    public Matrix3d reflection(Vector3dc vector3dc) {
        return this.reflection(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public Matrix3d reflection(Quaterniondc quaterniondc) {
        double d2 = quaterniondc.x() + quaterniondc.x();
        double d3 = quaterniondc.y() + quaterniondc.y();
        double d4 = quaterniondc.z() + quaterniondc.z();
        double d5 = quaterniondc.x() * d4 + quaterniondc.w() * d3;
        double d6 = quaterniondc.y() * d4 - quaterniondc.w() * d2;
        double d7 = 1.0 - (quaterniondc.x() * d2 + quaterniondc.y() * d3);
        return this.reflection(d5, d6, d7);
    }

    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m02) && Math.isFinite(this.m10) && Math.isFinite(this.m11) && Math.isFinite(this.m12) && Math.isFinite(this.m20) && Math.isFinite(this.m21) && Math.isFinite(this.m22);
    }

    public double quadraticFormProduct(double d2, double d3, double d4) {
        double d5 = this.m00 * d2 + this.m10 * d3 + this.m20 * d4;
        double d6 = this.m01 * d2 + this.m11 * d3 + this.m21 * d4;
        double d7 = this.m02 * d2 + this.m12 * d3 + this.m22 * d4;
        return d2 * d5 + d3 * d6 + d4 * d7;
    }

    public double quadraticFormProduct(Vector3dc vector3dc) {
        return this.quadraticFormProduct(vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public double quadraticFormProduct(Vector3fc vector3fc) {
        return this.quadraticFormProduct(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public Matrix3d mapXZY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapXZY(matrix3d);
    }

    public Matrix3d mapXZY(Matrix3d matrix3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapXZnY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapXZnY(matrix3d);
    }

    public Matrix3d mapXZnY(Matrix3d matrix3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d mapXnYnZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapXnYnZ(matrix3d);
    }

    public Matrix3d mapXnYnZ(Matrix3d matrix3d) {
        return matrix3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3d mapXnZY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapXnZY(matrix3d);
    }

    public Matrix3d mapXnZY(Matrix3d matrix3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapXnZnY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapXnZnY(matrix3d);
    }

    public Matrix3d mapXnZnY(Matrix3d matrix3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d mapYXZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapYXZ(matrix3d);
    }

    public Matrix3d mapYXZ(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(d2)._m11(d3)._m12(d4)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3d mapYXnZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapYXnZ(matrix3d);
    }

    public Matrix3d mapYXnZ(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(d2)._m11(d3)._m12(d4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3d mapYZX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapYZX(matrix3d);
    }

    public Matrix3d mapYZX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapYZnX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapYZnX(matrix3d);
    }

    public Matrix3d mapYZnX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d mapYnXZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapYnXZ(matrix3d);
    }

    public Matrix3d mapYnXZ(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-d2)._m11(-d3)._m12(-d4)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3d mapYnXnZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapYnXnZ(matrix3d);
    }

    public Matrix3d mapYnXnZ(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-d2)._m11(-d3)._m12(-d4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3d mapYnZX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapYnZX(matrix3d);
    }

    public Matrix3d mapYnZX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapYnZnX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapYnZnX(matrix3d);
    }

    public Matrix3d mapYnZnX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m10)._m01(this.m11)._m02(this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d mapZXY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapZXY(matrix3d);
    }

    public Matrix3d mapZXY(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(d2)._m11(d3)._m12(d4)._m20(d5)._m21(d6)._m22(d7);
    }

    public Matrix3d mapZXnY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapZXnY(matrix3d);
    }

    public Matrix3d mapZXnY(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(d2)._m11(d3)._m12(d4)._m20(-d5)._m21(-d6)._m22(-d7);
    }

    public Matrix3d mapZYX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapZYX(matrix3d);
    }

    public Matrix3d mapZYX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapZYnX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapZYnX(matrix3d);
    }

    public Matrix3d mapZYnX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d mapZnXY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapZnXY(matrix3d);
    }

    public Matrix3d mapZnXY(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-d2)._m11(-d3)._m12(-d4)._m20(d5)._m21(d6)._m22(d7);
    }

    public Matrix3d mapZnXnY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapZnXnY(matrix3d);
    }

    public Matrix3d mapZnXnY(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-d2)._m11(-d3)._m12(-d4)._m20(-d5)._m21(-d6)._m22(-d7);
    }

    public Matrix3d mapZnYX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapZnYX(matrix3d);
    }

    public Matrix3d mapZnYX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapZnYnX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapZnYnX(matrix3d);
    }

    public Matrix3d mapZnYnX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(this.m20)._m01(this.m21)._m02(this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d mapnXYnZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnXYnZ(matrix3d);
    }

    public Matrix3d mapnXYnZ(Matrix3d matrix3d) {
        return matrix3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3d mapnXZY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnXZY(matrix3d);
    }

    public Matrix3d mapnXZY(Matrix3d matrix3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapnXZnY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnXZnY(matrix3d);
    }

    public Matrix3d mapnXZnY(Matrix3d matrix3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d mapnXnYZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnXnYZ(matrix3d);
    }

    public Matrix3d mapnXnYZ(Matrix3d matrix3d) {
        return matrix3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3d mapnXnYnZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnXnYnZ(matrix3d);
    }

    public Matrix3d mapnXnYnZ(Matrix3d matrix3d) {
        return matrix3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3d mapnXnZY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnXnZY(matrix3d);
    }

    public Matrix3d mapnXnZY(Matrix3d matrix3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapnXnZnY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnXnZnY(matrix3d);
    }

    public Matrix3d mapnXnZnY(Matrix3d matrix3d) {
        double d2 = this.m10;
        double d3 = this.m11;
        double d4 = this.m12;
        return matrix3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d mapnYXZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnYXZ(matrix3d);
    }

    public Matrix3d mapnYXZ(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(d2)._m11(d3)._m12(d4)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3d mapnYXnZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnYXnZ(matrix3d);
    }

    public Matrix3d mapnYXnZ(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(d2)._m11(d3)._m12(d4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3d mapnYZX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnYZX(matrix3d);
    }

    public Matrix3d mapnYZX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapnYZnX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnYZnX(matrix3d);
    }

    public Matrix3d mapnYZnX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(this.m20)._m11(this.m21)._m12(this.m22)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d mapnYnXZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnYnXZ(matrix3d);
    }

    public Matrix3d mapnYnXZ(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-d2)._m11(-d3)._m12(-d4)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3d mapnYnXnZ() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnYnXnZ(matrix3d);
    }

    public Matrix3d mapnYnXnZ(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-d2)._m11(-d3)._m12(-d4)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3d mapnYnZX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnYnZX(matrix3d);
    }

    public Matrix3d mapnYnZX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapnYnZnX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnYnZnX(matrix3d);
    }

    public Matrix3d mapnYnZnX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m10)._m01(-this.m11)._m02(-this.m12)._m10(-this.m20)._m11(-this.m21)._m12(-this.m22)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d mapnZXY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnZXY(matrix3d);
    }

    public Matrix3d mapnZXY(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(d2)._m11(d3)._m12(d4)._m20(d5)._m21(d6)._m22(d7);
    }

    public Matrix3d mapnZXnY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnZXnY(matrix3d);
    }

    public Matrix3d mapnZXnY(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(d2)._m11(d3)._m12(d4)._m20(-d5)._m21(-d6)._m22(-d7);
    }

    public Matrix3d mapnZYX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnZYX(matrix3d);
    }

    public Matrix3d mapnZYX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapnZYnX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnZYnX(matrix3d);
    }

    public Matrix3d mapnZYnX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d mapnZnXY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnZnXY(matrix3d);
    }

    public Matrix3d mapnZnXY(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-d2)._m11(-d3)._m12(-d4)._m20(d5)._m21(d6)._m22(d7);
    }

    public Matrix3d mapnZnXnY() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnZnXnY(matrix3d);
    }

    public Matrix3d mapnZnXnY(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        double d5 = this.m10;
        double d6 = this.m11;
        double d7 = this.m12;
        return matrix3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-d2)._m11(-d3)._m12(-d4)._m20(-d5)._m21(-d6)._m22(-d7);
    }

    public Matrix3d mapnZnYX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnZnYX(matrix3d);
    }

    public Matrix3d mapnZnYX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(d2)._m21(d3)._m22(d4);
    }

    public Matrix3d mapnZnYnX() {
        Matrix3d matrix3d = this;
        return matrix3d.mapnZnYnX(matrix3d);
    }

    public Matrix3d mapnZnYnX(Matrix3d matrix3d) {
        double d2 = this.m00;
        double d3 = this.m01;
        double d4 = this.m02;
        return matrix3d._m00(-this.m20)._m01(-this.m21)._m02(-this.m22)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(-d2)._m21(-d3)._m22(-d4);
    }

    public Matrix3d negateX() {
        Matrix3d matrix3d = this;
        return matrix3d._m00(-matrix3d.m00)._m01(-this.m01)._m02(-this.m02);
    }

    public Matrix3d negateX(Matrix3d matrix3d) {
        return matrix3d._m00(-this.m00)._m01(-this.m01)._m02(-this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3d negateY() {
        Matrix3d matrix3d = this;
        return matrix3d._m10(-matrix3d.m10)._m11(-this.m11)._m12(-this.m12);
    }

    public Matrix3d negateY(Matrix3d matrix3d) {
        return matrix3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(-this.m10)._m11(-this.m11)._m12(-this.m12)._m20(this.m20)._m21(this.m21)._m22(this.m22);
    }

    public Matrix3d negateZ() {
        Matrix3d matrix3d = this;
        return matrix3d._m20(-matrix3d.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Matrix3d negateZ(Matrix3d matrix3d) {
        return matrix3d._m00(this.m00)._m01(this.m01)._m02(this.m02)._m10(this.m10)._m11(this.m11)._m12(this.m12)._m20(-this.m20)._m21(-this.m21)._m22(-this.m22);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

