/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Options;
import org.joml.Runtime;

public class Math {
    public static final double PI = java.lang.Math.PI;
    public static final double PI_TIMES_2 = java.lang.Math.PI * 2;
    public static final float PI_f = (float)java.lang.Math.PI;
    public static final float PI_TIMES_2_f = (float)java.lang.Math.PI * 2;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final float PI_OVER_2_f = 1.5707964f;
    public static final double PI_OVER_4 = 0.7853981633974483;
    public static final float PI_OVER_4_f = 0.7853982f;
    public static final double ONE_OVER_PI = 0.3183098861837907;
    public static final float ONE_OVER_PI_f = 0.31830987f;
    private static final int lookupBits = Options.SIN_LOOKUP_BITS;
    private static final int lookupTableSize = 1 << lookupBits;
    private static final int lookupTableSizeMinus1 = lookupTableSize - 1;
    private static final int lookupTableSizeWithMargin = lookupTableSize + 1;
    private static final float pi2OverLookupSize = (float)java.lang.Math.PI * 2 / (float)lookupTableSize;
    private static final float lookupSizeOverPi2 = (float)lookupTableSize / ((float)java.lang.Math.PI * 2);
    private static final float[] sinTable;
    private static final double c1;
    private static final double c2;
    private static final double c3;
    private static final double c4;
    private static final double c5;
    private static final double c6;
    private static final double c7;
    private static final double s5;
    private static final double s4;
    private static final double s3;
    private static final double s2;
    private static final double s1;
    private static final double k1;
    private static final double k2;
    private static final double k3;
    private static final double k4;
    private static final double k5;
    private static final double k6;
    private static final double k7;

    static double sin_theagentd_arith(double d2) {
        double d3 = Math.floor((d2 + 0.7853981633974483) * 0.3183098861837907);
        double d4 = d2 - d3 * java.lang.Math.PI;
        double d5 = ((int)d3 & 1) * -2 + 1;
        double d6 = d4;
        double d7 = d6 * d6;
        double d8 = d4 * d7;
        double d9 = d4 + d8 * c1;
        d9 += (d8 *= d7) * c2;
        d9 += (d8 *= d7) * c3;
        d9 += (d8 *= d7) * c4;
        d9 += (d8 *= d7) * c5;
        d9 += (d8 *= d7) * c6;
        return d5 * (d9 += (d8 *= d7) * c7);
    }

    static double sin_roquen_arith(double d2) {
        double d3 = Math.floor((d2 + 0.7853981633974483) * 0.3183098861837907);
        double d4 = d2 - d3 * java.lang.Math.PI;
        double d5 = ((int)d3 & 1) * -2 + 1;
        double d6 = d4;
        double d7 = d6 * d6;
        d4 = d5 * d4;
        double d8 = (((((c7 * d7 + c6) * d7 + c5) * d7 + c4) * d7 + c3) * d7 + c2) * d7 + c1;
        double d9 = d4;
        return d9 + d9 * d7 * d8;
    }

    static double sin_roquen_9(double d2) {
        double d3 = java.lang.Math.rint(d2 * 0.3183098861837907);
        double d4 = d2 - d3 * java.lang.Math.PI;
        double d5 = 1 - 2 * ((int)d3 & 1);
        double d6 = d4;
        double d7 = d6 * d6;
        d4 = d5 * d4;
        double d8 = (((s5 * d7 + s4) * d7 + s3) * d7 + s2) * d7 + s1;
        return d4 * d8;
    }

    static double sin_roquen_newk(double d2) {
        double d3 = java.lang.Math.rint(d2 * 0.3183098861837907);
        double d4 = d2 - d3 * java.lang.Math.PI;
        double d5 = 1 - 2 * ((int)d3 & 1);
        double d6 = d4;
        double d7 = d6 * d6;
        d4 = d5 * d4;
        double d8 = (((((k7 * d7 + k6) * d7 + k5) * d7 + k4) * d7 + k3) * d7 + k2) * d7 + k1;
        double d9 = d4;
        return d9 + d9 * d7 * d8;
    }

    static float sin_theagentd_lookup(float f2) {
        int n2 = (int)java.lang.Math.floor(f2 *= lookupSizeOverPi2);
        f2 -= (float)n2;
        float f3 = sinTable[n2 &= lookupTableSizeMinus1];
        float f4 = sinTable[n2 + 1];
        return f3 + (f4 - f3) * f2;
    }

    public static float sin(float f2) {
        if (Options.FASTMATH) {
            if (Options.SIN_LOOKUP) {
                return Math.sin_theagentd_lookup(f2);
            }
            return (float)Math.sin_roquen_newk(f2);
        }
        return (float)java.lang.Math.sin(f2);
    }

    public static double sin(double d2) {
        if (Options.FASTMATH) {
            if (Options.SIN_LOOKUP) {
                return Math.sin_theagentd_lookup((float)d2);
            }
            return Math.sin_roquen_newk(d2);
        }
        return java.lang.Math.sin(d2);
    }

    public static float cos(float f2) {
        if (Options.FASTMATH) {
            return Math.sin(f2 + 1.5707964f);
        }
        return (float)java.lang.Math.cos(f2);
    }

    public static double cos(double d2) {
        if (Options.FASTMATH) {
            return Math.sin(d2 + 1.5707963267948966);
        }
        return java.lang.Math.cos(d2);
    }

    public static float cosFromSin(float f2, float f3) {
        if (Options.FASTMATH) {
            return Math.sin(f3 + 1.5707964f);
        }
        return Math.cosFromSinInternal(f2, f3);
    }

    private static float cosFromSinInternal(float f2, float f3) {
        float f4;
        float f5 = f2;
        f2 = Math.sqrt(1.0f - f5 * f5);
        float f6 = f3 + 1.5707964f;
        f3 = f6 - (float)((int)(f6 / ((float)java.lang.Math.PI * 2))) * ((float)java.lang.Math.PI * 2);
        if ((double)f4 < 0.0) {
            f3 += (float)java.lang.Math.PI * 2;
        }
        if (f3 >= (float)java.lang.Math.PI) {
            return -f2;
        }
        return f2;
    }

    public static double cosFromSin(double d2, double d3) {
        double d4;
        if (Options.FASTMATH) {
            return Math.sin(d3 + 1.5707963267948966);
        }
        double d5 = d2;
        double d6 = Math.sqrt(1.0 - d5 * d5);
        double d7 = d3 + 1.5707963267948966;
        double d8 = d7 - (double)((int)(d7 / (java.lang.Math.PI * 2))) * (java.lang.Math.PI * 2);
        if (d4 < 0.0) {
            d8 += java.lang.Math.PI * 2;
        }
        if (d8 >= java.lang.Math.PI) {
            return -d6;
        }
        return d6;
    }

    public static float sqrt(float f2) {
        return (float)java.lang.Math.sqrt(f2);
    }

    public static double sqrt(double d2) {
        return java.lang.Math.sqrt(d2);
    }

    public static float invsqrt(float f2) {
        return 1.0f / (float)java.lang.Math.sqrt(f2);
    }

    public static double invsqrt(double d2) {
        return 1.0 / java.lang.Math.sqrt(d2);
    }

    public static float tan(float f2) {
        return (float)java.lang.Math.tan(f2);
    }

    public static double tan(double d2) {
        return java.lang.Math.tan(d2);
    }

    public static float acos(float f2) {
        return (float)java.lang.Math.acos(f2);
    }

    public static double acos(double d2) {
        return java.lang.Math.acos(d2);
    }

    public static float safeAcos(float f2) {
        if (f2 < -1.0f) {
            return (float)java.lang.Math.PI;
        }
        if (f2 > 1.0f) {
            return 0.0f;
        }
        return Math.acos(f2);
    }

    public static double safeAcos(double d2) {
        if (d2 < -1.0) {
            return java.lang.Math.PI;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        return Math.acos(d2);
    }

    private static double fastAtan2(double d2, double d3) {
        double d4 = d3 >= 0.0 ? d3 : -d3;
        double d5 = d2 >= 0.0 ? d2 : -d2;
        double d6 = d5 > d4 ? d4 / d5 : d5 / d4;
        double d7 = d6 * d6;
        double d8 = d6;
        double d9 = Math.fma(Math.fma(Math.fma(-0.0464964749, d7, 0.15931422), d7, -0.327622764) * d7, d8, d8);
        if (d5 > d4) {
            d9 = 1.5707963267948966 - d9;
        }
        if (d3 < 0.0) {
            d9 = java.lang.Math.PI - d9;
        }
        if (d2 >= 0.0) {
            return d9;
        }
        return -d9;
    }

    public static float atan2(float f2, float f3) {
        return (float)java.lang.Math.atan2(f2, f3);
    }

    public static double atan2(double d2, double d3) {
        if (Options.FASTMATH) {
            return Math.fastAtan2(d2, d3);
        }
        return java.lang.Math.atan2(d2, d3);
    }

    public static float asin(float f2) {
        return (float)java.lang.Math.asin(f2);
    }

    public static double asin(double d2) {
        return java.lang.Math.asin(d2);
    }

    public static float safeAsin(float f2) {
        if (f2 <= -1.0f) {
            return -1.5707964f;
        }
        if (f2 >= 1.0f) {
            return 1.5707964f;
        }
        return Math.asin(f2);
    }

    public static double safeAsin(double d2) {
        if (d2 <= -1.0) {
            return -1.5707963267948966;
        }
        if (d2 >= 1.0) {
            return 1.5707963267948966;
        }
        return Math.asin(d2);
    }

    public static float abs(float f2) {
        return java.lang.Math.abs(f2);
    }

    public static double abs(double d2) {
        return java.lang.Math.abs(d2);
    }

    static boolean absEqualsOne(float f2) {
        return (Float.floatToRawIntBits(f2) & Integer.MAX_VALUE) == 1065353216;
    }

    static boolean absEqualsOne(double d2) {
        return (Double.doubleToRawLongBits(d2) & Long.MAX_VALUE) == 0x3FF0000000000000L;
    }

    public static int abs(int n2) {
        return java.lang.Math.abs(n2);
    }

    public static long abs(long l2) {
        return java.lang.Math.abs(l2);
    }

    public static int max(int n2, int n3) {
        return java.lang.Math.max(n2, n3);
    }

    public static int min(int n2, int n3) {
        return java.lang.Math.min(n2, n3);
    }

    public static long max(long l2, long l3) {
        return java.lang.Math.max(l2, l3);
    }

    public static long min(long l2, long l3) {
        return java.lang.Math.min(l2, l3);
    }

    public static double min(double d2, double d3) {
        if (d2 < d3) {
            return d2;
        }
        return d3;
    }

    public static float min(float f2, float f3) {
        if (f2 < f3) {
            return f2;
        }
        return f3;
    }

    public static float max(float f2, float f3) {
        if (f2 > f3) {
            return f2;
        }
        return f3;
    }

    public static double max(double d2, double d3) {
        if (d2 > d3) {
            return d2;
        }
        return d3;
    }

    public static float clamp(float f2, float f3, float f4) {
        return Math.max(f2, Math.min(f3, f4));
    }

    public static double clamp(double d2, double d3, double d4) {
        return Math.max(d2, Math.min(d3, d4));
    }

    public static int clamp(int n2, int n3, int n4) {
        return Math.max(n2, Math.min(n3, n4));
    }

    public static long clamp(long l2, long l3, long l4) {
        return Math.max(l2, Math.min(l3, l4));
    }

    public static float toRadians(float f2) {
        return (float)java.lang.Math.toRadians(f2);
    }

    public static double toRadians(double d2) {
        return java.lang.Math.toRadians(d2);
    }

    public static float toDegrees(float f2) {
        return (float)java.lang.Math.toDegrees(f2);
    }

    public static double toDegrees(double d2) {
        return java.lang.Math.toDegrees(d2);
    }

    public static double floor(double d2) {
        return java.lang.Math.floor(d2);
    }

    public static float floor(float f2) {
        return (float)java.lang.Math.floor(f2);
    }

    public static double ceil(double d2) {
        return java.lang.Math.ceil(d2);
    }

    public static float ceil(float f2) {
        return (float)java.lang.Math.ceil(f2);
    }

    public static long round(double d2) {
        return java.lang.Math.round(d2);
    }

    public static int round(float f2) {
        return java.lang.Math.round(f2);
    }

    public static double exp(double d2) {
        return java.lang.Math.exp(d2);
    }

    public static boolean isFinite(double d2) {
        return Math.abs(d2) <= Double.MAX_VALUE;
    }

    public static boolean isFinite(float f2) {
        return Math.abs(f2) <= Float.MAX_VALUE;
    }

    public static float fma(float f2, float f3, float f4) {
        if (Runtime.HAS_Math_fma) {
            return java.lang.Math.fma(f2, f3, f4);
        }
        return f2 * f3 + f4;
    }

    public static double fma(double d2, double d3, double d4) {
        if (Runtime.HAS_Math_fma) {
            return java.lang.Math.fma(d2, d3, d4);
        }
        return d2 * d3 + d4;
    }

    public static int roundUsing(float f2, int n2) {
        switch (n2) {
            case 0: {
                return (int)f2;
            }
            case 1: {
                return (int)java.lang.Math.ceil(f2);
            }
            case 2: {
                return (int)java.lang.Math.floor(f2);
            }
            case 4: {
                return Math.roundHalfDown(f2);
            }
            case 5: {
                return Math.roundHalfUp(f2);
            }
            case 3: {
                return Math.roundHalfEven(f2);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static int roundUsing(double d2, int n2) {
        switch (n2) {
            case 0: {
                return (int)d2;
            }
            case 1: {
                return (int)java.lang.Math.ceil(d2);
            }
            case 2: {
                return (int)java.lang.Math.floor(d2);
            }
            case 4: {
                return Math.roundHalfDown(d2);
            }
            case 5: {
                return Math.roundHalfUp(d2);
            }
            case 3: {
                return Math.roundHalfEven(d2);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static long roundLongUsing(double d2, int n2) {
        switch (n2) {
            case 0: {
                return (long)d2;
            }
            case 1: {
                return (long)java.lang.Math.ceil(d2);
            }
            case 2: {
                return (long)java.lang.Math.floor(d2);
            }
            case 4: {
                return Math.roundHalfDown(d2);
            }
            case 5: {
                return Math.roundHalfUp(d2);
            }
            case 3: {
                return Math.roundHalfEven(d2);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static float lerp(float f2, float f3, float f4) {
        return Math.fma(f3 - f2, f4, f2);
    }

    public static double lerp(double d2, double d3, double d4) {
        return Math.fma(d3 - d2, d4, d2);
    }

    public static float biLerp(float f2, float f3, float f4, float f5, float f6, float f7) {
        f2 = Math.lerp(f2, f3, f6);
        f3 = Math.lerp(f4, f5, f6);
        return Math.lerp(f2, f3, f7);
    }

    public static double biLerp(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Math.lerp(d2, d3, d6);
        double d9 = Math.lerp(d4, d5, d6);
        return Math.lerp(d8, d9, d7);
    }

    public static float triLerp(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        f2 = Math.lerp(f2, f3, f10);
        f3 = Math.lerp(f4, f5, f10);
        f4 = Math.lerp(f6, f7, f10);
        f5 = Math.lerp(f8, f9, f10);
        f2 = Math.lerp(f2, f3, f11);
        f3 = Math.lerp(f4, f5, f11);
        return Math.lerp(f2, f3, f12);
    }

    public static double triLerp(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        double d13 = Math.lerp(d2, d3, d10);
        double d14 = Math.lerp(d4, d5, d10);
        double d15 = Math.lerp(d6, d7, d10);
        double d16 = Math.lerp(d8, d9, d10);
        double d17 = Math.lerp(d13, d14, d11);
        double d18 = Math.lerp(d15, d16, d11);
        return Math.lerp(d17, d18, d12);
    }

    public static int roundHalfEven(float f2) {
        return (int)java.lang.Math.rint(f2);
    }

    public static int roundHalfDown(float f2) {
        if (f2 > 0.0f) {
            return (int)java.lang.Math.ceil((double)f2 - 0.5);
        }
        return (int)java.lang.Math.floor((double)f2 + 0.5);
    }

    public static int roundHalfUp(float f2) {
        if (f2 > 0.0f) {
            return (int)java.lang.Math.floor((double)f2 + 0.5);
        }
        return (int)java.lang.Math.ceil((double)f2 - 0.5);
    }

    public static int roundHalfEven(double d2) {
        return (int)java.lang.Math.rint(d2);
    }

    public static int roundHalfDown(double d2) {
        if (d2 > 0.0) {
            return (int)java.lang.Math.ceil(d2 - 0.5);
        }
        return (int)java.lang.Math.floor(d2 + 0.5);
    }

    public static int roundHalfUp(double d2) {
        if (d2 > 0.0) {
            return (int)java.lang.Math.floor(d2 + 0.5);
        }
        return (int)java.lang.Math.ceil(d2 - 0.5);
    }

    public static long roundLongHalfEven(double d2) {
        return (long)java.lang.Math.rint(d2);
    }

    public static long roundLongHalfDown(double d2) {
        if (d2 > 0.0) {
            return (long)java.lang.Math.ceil(d2 - 0.5);
        }
        return (long)java.lang.Math.floor(d2 + 0.5);
    }

    public static long roundLongHalfUp(double d2) {
        if (d2 > 0.0) {
            return (long)java.lang.Math.floor(d2 + 0.5);
        }
        return (long)java.lang.Math.ceil(d2 - 0.5);
    }

    public static double random() {
        return java.lang.Math.random();
    }

    public static double signum(double d2) {
        return java.lang.Math.signum(d2);
    }

    public static float signum(float f2) {
        return java.lang.Math.signum(f2);
    }

    public static int signum(int n2) {
        return n2 >> 31 | -n2 >>> 31;
    }

    public static int signum(long l2) {
        return (int)(l2 >> 63 | -l2 >>> 63);
    }

    static {
        if (Options.FASTMATH && Options.SIN_LOOKUP) {
            sinTable = new float[lookupTableSizeWithMargin];
            for (int i2 = 0; i2 < lookupTableSizeWithMargin; ++i2) {
                double d2 = (float)i2 * pi2OverLookupSize;
                Math.sinTable[i2] = (float)java.lang.Math.sin(d2);
            }
        } else {
            sinTable = null;
        }
        c1 = Double.longBitsToDouble(-4628199217061079772L);
        c2 = Double.longBitsToDouble(4575957461383582011L);
        c3 = Double.longBitsToDouble(-4671919876300759001L);
        c4 = Double.longBitsToDouble(4523617214285661942L);
        c5 = Double.longBitsToDouble(-4730215272828025532L);
        c6 = Double.longBitsToDouble(4460272573143870633L);
        c7 = Double.longBitsToDouble(-4797767418267846529L);
        s5 = Double.longBitsToDouble(4523227044276562163L);
        s4 = Double.longBitsToDouble(-4671934770969572232L);
        s3 = Double.longBitsToDouble(4575957211482072852L);
        s2 = Double.longBitsToDouble(-4628199223918090387L);
        s1 = Double.longBitsToDouble(4607182418589157889L);
        k1 = Double.longBitsToDouble(-4628199217061079959L);
        k2 = Double.longBitsToDouble(4575957461383549981L);
        k3 = Double.longBitsToDouble(-4671919876307284301L);
        k4 = Double.longBitsToDouble(4523617213632129738L);
        k5 = Double.longBitsToDouble(-4730215344060517252L);
        k6 = Double.longBitsToDouble(4460268259291226124L);
        k7 = Double.longBitsToDouble(-4798040743777455072L);
    }
}

