/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class AxisAngle4f
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public float angle;
    public float x;
    public float y;
    public float z;

    public AxisAngle4f() {
        this.z = 1.0f;
    }

    public AxisAngle4f(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = ((double)axisAngle4f.angle < 0.0 ? (float)java.lang.Math.PI * 2 + axisAngle4f.angle % ((float)java.lang.Math.PI * 2) : axisAngle4f.angle) % ((float)java.lang.Math.PI * 2);
    }

    public AxisAngle4f(Quaternionfc quaternionfc) {
        float f2 = Math.safeAcos(quaternionfc.w());
        float f3 = Math.invsqrt(1.0f - quaternionfc.w() * quaternionfc.w());
        if (Float.isInfinite(f3)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = quaternionfc.x() * f3;
            this.y = quaternionfc.y() * f3;
            this.z = quaternionfc.z() * f3;
        }
        float f4 = f2;
        this.angle = f4 + f4;
    }

    public AxisAngle4f(float f2, float f3, float f4, float f5) {
        this.x = f3;
        this.y = f4;
        this.z = f5;
        this.angle = ((double)f2 < 0.0 ? (float)java.lang.Math.PI * 2 + f2 % ((float)java.lang.Math.PI * 2) : f2) % ((float)java.lang.Math.PI * 2);
    }

    public AxisAngle4f(float f2, Vector3fc vector3fc) {
        this(f2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public AxisAngle4f set(AxisAngle4f axisAngle4f) {
        AxisAngle4f axisAngle4f2;
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = axisAngle4f.angle;
        this.angle = ((double)axisAngle4f2.angle < 0.0 ? (float)java.lang.Math.PI * 2 + this.angle % ((float)java.lang.Math.PI * 2) : this.angle) % ((float)java.lang.Math.PI * 2);
        return this;
    }

    public AxisAngle4f set(AxisAngle4d axisAngle4d) {
        AxisAngle4f axisAngle4f;
        this.x = (float)axisAngle4d.x;
        this.y = (float)axisAngle4d.y;
        this.z = (float)axisAngle4d.z;
        this.angle = (float)axisAngle4d.angle;
        this.angle = ((double)axisAngle4f.angle < 0.0 ? (float)java.lang.Math.PI * 2 + this.angle % ((float)java.lang.Math.PI * 2) : this.angle) % ((float)java.lang.Math.PI * 2);
        return this;
    }

    public AxisAngle4f set(float f2, float f3, float f4, float f5) {
        this.x = f3;
        this.y = f4;
        this.z = f5;
        this.angle = ((double)f2 < 0.0 ? (float)java.lang.Math.PI * 2 + f2 % ((float)java.lang.Math.PI * 2) : f2) % ((float)java.lang.Math.PI * 2);
        return this;
    }

    public AxisAngle4f set(float f2, Vector3fc vector3fc) {
        return this.set(f2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public AxisAngle4f set(Quaternionfc quaternionfc) {
        float f2 = Math.safeAcos(quaternionfc.w());
        float f3 = Math.invsqrt(1.0f - quaternionfc.w() * quaternionfc.w());
        if (Float.isInfinite(f3)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = quaternionfc.x() * f3;
            this.y = quaternionfc.y() * f3;
            this.z = quaternionfc.z() * f3;
        }
        float f4 = f2;
        this.angle = f4 + f4;
        return this;
    }

    public AxisAngle4f set(Quaterniondc quaterniondc) {
        double d2 = Math.safeAcos(quaterniondc.w());
        double d3 = Math.invsqrt(1.0 - quaterniondc.w() * quaterniondc.w());
        if (Double.isInfinite(d3)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = (float)(quaterniondc.x() * d3);
            this.y = (float)(quaterniondc.y() * d3);
            this.z = (float)(quaterniondc.z() * d3);
        }
        double d4 = d2;
        this.angle = (float)(d4 + d4);
        return this;
    }

    public AxisAngle4f set(Matrix3fc matrix3fc) {
        float f2 = matrix3fc.m00();
        float f3 = matrix3fc.m01();
        float f4 = matrix3fc.m02();
        float f5 = matrix3fc.m10();
        float f6 = matrix3fc.m11();
        float f7 = matrix3fc.m12();
        float f8 = matrix3fc.m20();
        float f9 = matrix3fc.m21();
        float f10 = matrix3fc.m22();
        float f11 = Math.invsqrt(matrix3fc.m00() * matrix3fc.m00() + matrix3fc.m01() * matrix3fc.m01() + matrix3fc.m02() * matrix3fc.m02());
        float f12 = Math.invsqrt(matrix3fc.m10() * matrix3fc.m10() + matrix3fc.m11() * matrix3fc.m11() + matrix3fc.m12() * matrix3fc.m12());
        float f13 = Math.invsqrt(matrix3fc.m20() * matrix3fc.m20() + matrix3fc.m21() * matrix3fc.m21() + matrix3fc.m22() * matrix3fc.m22());
        f2 *= f11;
        f3 *= f11;
        f4 *= f11;
        f5 *= f12;
        f6 *= f12;
        f7 *= f12;
        f8 *= f13;
        f9 *= f13;
        f10 *= f13;
        if (Math.abs(f5 - f3) < 1.0E-4f && Math.abs(f8 - f4) < 1.0E-4f && Math.abs(f9 - f7) < 1.0E-4f) {
            if (Math.abs(f5 + f3) < 0.001f && Math.abs(f8 + f4) < 0.001f && Math.abs(f9 + f7) < 0.001f && Math.abs(f2 + f6 + f10 - 3.0f) < 0.001f) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            f13 = (f2 + 1.0f) / 2.0f;
            f2 = (f6 + 1.0f) / 2.0f;
            f6 = (f10 + 1.0f) / 2.0f;
            f3 = (f5 + f3) / 4.0f;
            f4 = (f8 + f4) / 4.0f;
            f5 = (f9 + f7) / 4.0f;
            if (f13 > f2 && f13 > f6) {
                this.x = Math.sqrt(f13);
                f13 = 1.0f / this.x;
                this.y = f3 * f13;
                this.z = f4 * f13;
            } else if (f2 > f6) {
                this.y = Math.sqrt(f2);
                f13 = 1.0f / this.z;
                this.x = f3 * f13;
                this.z = f5 * f13;
            } else {
                this.z = Math.sqrt(f6);
                f13 = 1.0f / this.y;
                this.x = f4 * f13;
                this.y = f5 * f13;
            }
            return this;
        }
        f13 = Math.invsqrt((f7 - f9) * (f7 - f9) + (f8 - f4) * (f8 - f4) + (f3 - f5) * (f3 - f5));
        this.angle = Math.safeAcos((f2 + f6 + f10 - 1.0f) / 2.0f);
        this.x = (f7 - f9) * f13;
        this.y = (f8 - f4) * f13;
        this.z = (f3 - f5) * f13;
        return this;
    }

    public AxisAngle4f set(Matrix3dc matrix3dc) {
        double d2 = matrix3dc.m00();
        double d3 = matrix3dc.m01();
        double d4 = matrix3dc.m02();
        double d5 = matrix3dc.m10();
        double d6 = matrix3dc.m11();
        double d7 = matrix3dc.m12();
        double d8 = matrix3dc.m20();
        double d9 = matrix3dc.m21();
        double d10 = matrix3dc.m22();
        double d11 = Math.invsqrt(matrix3dc.m00() * matrix3dc.m00() + matrix3dc.m01() * matrix3dc.m01() + matrix3dc.m02() * matrix3dc.m02());
        double d12 = Math.invsqrt(matrix3dc.m10() * matrix3dc.m10() + matrix3dc.m11() * matrix3dc.m11() + matrix3dc.m12() * matrix3dc.m12());
        double d13 = Math.invsqrt(matrix3dc.m20() * matrix3dc.m20() + matrix3dc.m21() * matrix3dc.m21() + matrix3dc.m22() * matrix3dc.m22());
        d2 *= d11;
        d3 *= d11;
        d4 *= d11;
        d5 *= d12;
        d6 *= d12;
        d7 *= d12;
        d8 *= d13;
        d9 *= d13;
        d10 *= d13;
        if (Math.abs(d5 - d3) < 1.0E-4 && Math.abs(d8 - d4) < 1.0E-4 && Math.abs(d9 - d7) < 1.0E-4) {
            if (Math.abs(d5 + d3) < 0.001 && Math.abs(d8 + d4) < 0.001 && Math.abs(d9 + d7) < 0.001 && Math.abs(d2 + d6 + d10 - 3.0) < 0.001) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            double d14 = (d2 + 1.0) / 2.0;
            double d15 = (d6 + 1.0) / 2.0;
            double d16 = (d10 + 1.0) / 2.0;
            double d17 = (d5 + d3) / 4.0;
            double d18 = (d8 + d4) / 4.0;
            double d19 = (d9 + d7) / 4.0;
            if (d14 > d15 && d14 > d16) {
                this.x = (float)Math.sqrt(d14);
                float f2 = 1.0f / this.x;
                this.y = (float)(d17 * (double)f2);
                this.z = (float)(d18 * (double)f2);
            } else if (d15 > d16) {
                this.y = (float)Math.sqrt(d15);
                float f3 = 1.0f / this.y;
                this.x = (float)(d17 * (double)f3);
                this.z = (float)(d19 * (double)f3);
            } else {
                this.z = (float)Math.sqrt(d16);
                float f4 = 1.0f / this.z;
                this.x = (float)(d18 * (double)f4);
                this.y = (float)(d19 * (double)f4);
            }
            return this;
        }
        double d20 = Math.invsqrt((d7 - d9) * (d7 - d9) + (d8 - d4) * (d8 - d4) + (d3 - d5) * (d3 - d5));
        this.angle = (float)Math.safeAcos((d2 + d6 + d10 - 1.0) / 2.0);
        this.x = (float)((d7 - d9) * d20);
        this.y = (float)((d8 - d4) * d20);
        this.z = (float)((d3 - d5) * d20);
        return this;
    }

    public AxisAngle4f set(Matrix4fc matrix4fc) {
        float f2 = matrix4fc.m00();
        float f3 = matrix4fc.m01();
        float f4 = matrix4fc.m02();
        float f5 = matrix4fc.m10();
        float f6 = matrix4fc.m11();
        float f7 = matrix4fc.m12();
        float f8 = matrix4fc.m20();
        float f9 = matrix4fc.m21();
        float f10 = matrix4fc.m22();
        float f11 = Math.invsqrt(matrix4fc.m00() * matrix4fc.m00() + matrix4fc.m01() * matrix4fc.m01() + matrix4fc.m02() * matrix4fc.m02());
        float f12 = Math.invsqrt(matrix4fc.m10() * matrix4fc.m10() + matrix4fc.m11() * matrix4fc.m11() + matrix4fc.m12() * matrix4fc.m12());
        float f13 = Math.invsqrt(matrix4fc.m20() * matrix4fc.m20() + matrix4fc.m21() * matrix4fc.m21() + matrix4fc.m22() * matrix4fc.m22());
        f2 *= f11;
        f3 *= f11;
        f4 *= f11;
        f5 *= f12;
        f6 *= f12;
        f7 *= f12;
        f8 *= f13;
        f9 *= f13;
        f10 *= f13;
        if (Math.abs(f5 - f3) < 1.0E-4f && Math.abs(f8 - f4) < 1.0E-4f && Math.abs(f9 - f7) < 1.0E-4f) {
            if (Math.abs(f5 + f3) < 0.001f && Math.abs(f8 + f4) < 0.001f && Math.abs(f9 + f7) < 0.001f && Math.abs(f2 + f6 + f10 - 3.0f) < 0.001f) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            f13 = (f2 + 1.0f) / 2.0f;
            f2 = (f6 + 1.0f) / 2.0f;
            f6 = (f10 + 1.0f) / 2.0f;
            f3 = (f5 + f3) / 4.0f;
            f4 = (f8 + f4) / 4.0f;
            f5 = (f9 + f7) / 4.0f;
            if (f13 > f2 && f13 > f6) {
                this.x = Math.sqrt(f13);
                f13 = 1.0f / this.x;
                this.y = f3 * f13;
                this.z = f4 * f13;
            } else if (f2 > f6) {
                this.y = Math.sqrt(f2);
                f13 = 1.0f / this.z;
                this.x = f3 * f13;
                this.z = f5 * f13;
            } else {
                this.z = Math.sqrt(f6);
                f13 = 1.0f / this.y;
                this.x = f4 * f13;
                this.y = f5 * f13;
            }
            return this;
        }
        f13 = Math.invsqrt((f7 - f9) * (f7 - f9) + (f8 - f4) * (f8 - f4) + (f3 - f5) * (f3 - f5));
        this.angle = Math.safeAcos((f2 + f6 + f10 - 1.0f) / 2.0f);
        this.x = (f7 - f9) * f13;
        this.y = (f8 - f4) * f13;
        this.z = (f3 - f5) * f13;
        return this;
    }

    public AxisAngle4f set(Matrix4x3fc matrix4x3fc) {
        float f2 = matrix4x3fc.m00();
        float f3 = matrix4x3fc.m01();
        float f4 = matrix4x3fc.m02();
        float f5 = matrix4x3fc.m10();
        float f6 = matrix4x3fc.m11();
        float f7 = matrix4x3fc.m12();
        float f8 = matrix4x3fc.m20();
        float f9 = matrix4x3fc.m21();
        float f10 = matrix4x3fc.m22();
        float f11 = Math.invsqrt(matrix4x3fc.m00() * matrix4x3fc.m00() + matrix4x3fc.m01() * matrix4x3fc.m01() + matrix4x3fc.m02() * matrix4x3fc.m02());
        float f12 = Math.invsqrt(matrix4x3fc.m10() * matrix4x3fc.m10() + matrix4x3fc.m11() * matrix4x3fc.m11() + matrix4x3fc.m12() * matrix4x3fc.m12());
        float f13 = Math.invsqrt(matrix4x3fc.m20() * matrix4x3fc.m20() + matrix4x3fc.m21() * matrix4x3fc.m21() + matrix4x3fc.m22() * matrix4x3fc.m22());
        f2 *= f11;
        f3 *= f11;
        f4 *= f11;
        f5 *= f12;
        f6 *= f12;
        f7 *= f12;
        f8 *= f13;
        f9 *= f13;
        f10 *= f13;
        if (Math.abs(f5 - f3) < 1.0E-4f && Math.abs(f8 - f4) < 1.0E-4f && Math.abs(f9 - f7) < 1.0E-4f) {
            if (Math.abs(f5 + f3) < 0.001f && Math.abs(f8 + f4) < 0.001f && Math.abs(f9 + f7) < 0.001f && Math.abs(f2 + f6 + f10 - 3.0f) < 0.001f) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            f13 = (f2 + 1.0f) / 2.0f;
            f2 = (f6 + 1.0f) / 2.0f;
            f6 = (f10 + 1.0f) / 2.0f;
            f3 = (f5 + f3) / 4.0f;
            f4 = (f8 + f4) / 4.0f;
            f5 = (f9 + f7) / 4.0f;
            if (f13 > f2 && f13 > f6) {
                this.x = Math.sqrt(f13);
                f13 = 1.0f / this.x;
                this.y = f3 * f13;
                this.z = f4 * f13;
            } else if (f2 > f6) {
                this.y = Math.sqrt(f2);
                f13 = 1.0f / this.z;
                this.x = f3 * f13;
                this.z = f5 * f13;
            } else {
                this.z = Math.sqrt(f6);
                f13 = 1.0f / this.y;
                this.x = f4 * f13;
                this.y = f5 * f13;
            }
            return this;
        }
        f13 = Math.invsqrt((f7 - f9) * (f7 - f9) + (f8 - f4) * (f8 - f4) + (f3 - f5) * (f3 - f5));
        this.angle = Math.safeAcos((f2 + f6 + f10 - 1.0f) / 2.0f);
        this.x = (f7 - f9) * f13;
        this.y = (f8 - f4) * f13;
        this.z = (f3 - f5) * f13;
        return this;
    }

    public AxisAngle4f set(Matrix4dc matrix4dc) {
        double d2 = matrix4dc.m00();
        double d3 = matrix4dc.m01();
        double d4 = matrix4dc.m02();
        double d5 = matrix4dc.m10();
        double d6 = matrix4dc.m11();
        double d7 = matrix4dc.m12();
        double d8 = matrix4dc.m20();
        double d9 = matrix4dc.m21();
        double d10 = matrix4dc.m22();
        double d11 = Math.invsqrt(matrix4dc.m00() * matrix4dc.m00() + matrix4dc.m01() * matrix4dc.m01() + matrix4dc.m02() * matrix4dc.m02());
        double d12 = Math.invsqrt(matrix4dc.m10() * matrix4dc.m10() + matrix4dc.m11() * matrix4dc.m11() + matrix4dc.m12() * matrix4dc.m12());
        double d13 = Math.invsqrt(matrix4dc.m20() * matrix4dc.m20() + matrix4dc.m21() * matrix4dc.m21() + matrix4dc.m22() * matrix4dc.m22());
        d2 *= d11;
        d3 *= d11;
        d4 *= d11;
        d5 *= d12;
        d6 *= d12;
        d7 *= d12;
        d8 *= d13;
        d9 *= d13;
        d10 *= d13;
        if (Math.abs(d5 - d3) < 1.0E-4 && Math.abs(d8 - d4) < 1.0E-4 && Math.abs(d9 - d7) < 1.0E-4) {
            if (Math.abs(d5 + d3) < 0.001 && Math.abs(d8 + d4) < 0.001 && Math.abs(d9 + d7) < 0.001 && Math.abs(d2 + d6 + d10 - 3.0) < 0.001) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            double d14 = (d2 + 1.0) / 2.0;
            double d15 = (d6 + 1.0) / 2.0;
            double d16 = (d10 + 1.0) / 2.0;
            double d17 = (d5 + d3) / 4.0;
            double d18 = (d8 + d4) / 4.0;
            double d19 = (d9 + d7) / 4.0;
            if (d14 > d15 && d14 > d16) {
                this.x = (float)Math.sqrt(d14);
                float f2 = 1.0f / this.x;
                this.y = (float)(d17 * (double)f2);
                this.z = (float)(d18 * (double)f2);
            } else if (d15 > d16) {
                this.y = (float)Math.sqrt(d15);
                float f3 = 1.0f / this.y;
                this.x = (float)(d17 * (double)f3);
                this.z = (float)(d19 * (double)f3);
            } else {
                this.z = (float)Math.sqrt(d16);
                float f4 = 1.0f / this.z;
                this.x = (float)(d18 * (double)f4);
                this.y = (float)(d19 * (double)f4);
            }
            return this;
        }
        double d20 = Math.invsqrt((d7 - d9) * (d7 - d9) + (d8 - d4) * (d8 - d4) + (d3 - d5) * (d3 - d5));
        this.angle = (float)Math.safeAcos((d2 + d6 + d10 - 1.0) / 2.0);
        this.x = (float)((d7 - d9) * d20);
        this.y = (float)((d8 - d4) * d20);
        this.z = (float)((d3 - d5) * d20);
        return this;
    }

    public Quaternionf get(Quaternionf quaternionf) {
        return quaternionf.set(this);
    }

    public Quaterniond get(Quaterniond quaterniond) {
        return quaterniond.set(this);
    }

    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set(this);
    }

    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    public AxisAngle4d get(AxisAngle4d axisAngle4d) {
        return axisAngle4d.set(this);
    }

    public AxisAngle4f get(AxisAngle4f axisAngle4f) {
        return axisAngle4f.set(this);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.angle);
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.angle = objectInput.readFloat();
        this.x = objectInput.readFloat();
        this.y = objectInput.readFloat();
        this.z = objectInput.readFloat();
    }

    public AxisAngle4f normalize() {
        float f2 = Math.invsqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        return this;
    }

    public AxisAngle4f rotate(float f2) {
        AxisAngle4f axisAngle4f;
        this.angle += f2;
        this.angle = ((double)axisAngle4f.angle < 0.0 ? (float)java.lang.Math.PI * 2 + this.angle % ((float)java.lang.Math.PI * 2) : this.angle) % ((float)java.lang.Math.PI * 2);
        return this;
    }

    public Vector3f transform(Vector3f vector3f) {
        Vector3f vector3f2 = vector3f;
        return this.transform(vector3f2, vector3f2);
    }

    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        double d2 = Math.sin(this.angle);
        double d3 = Math.cosFromSin(d2, (double)this.angle);
        float f2 = this.x * vector3fc.x() + this.y * vector3fc.y() + this.z * vector3fc.z();
        vector3f.set((float)((double)vector3fc.x() * d3 + d2 * (double)(this.y * vector3fc.z() - this.z * vector3fc.y()) + (1.0 - d3) * (double)f2 * (double)this.x), (float)((double)vector3fc.y() * d3 + d2 * (double)(this.z * vector3fc.x() - this.x * vector3fc.z()) + (1.0 - d3) * (double)f2 * (double)this.y), (float)((double)vector3fc.z() * d3 + d2 * (double)(this.x * vector3fc.y() - this.y * vector3fc.x()) + (1.0 - d3) * (double)f2 * (double)this.z));
        return vector3f;
    }

    public Vector4f transform(Vector4f vector4f) {
        Vector4f vector4f2 = vector4f;
        return this.transform(vector4f2, vector4f2);
    }

    public Vector4f transform(Vector4fc vector4fc, Vector4f vector4f) {
        double d2 = Math.sin(this.angle);
        double d3 = Math.cosFromSin(d2, (double)this.angle);
        float f2 = this.x * vector4fc.x() + this.y * vector4fc.y() + this.z * vector4fc.z();
        vector4f.set((float)((double)vector4fc.x() * d3 + d2 * (double)(this.y * vector4fc.z() - this.z * vector4fc.y()) + (1.0 - d3) * (double)f2 * (double)this.x), (float)((double)vector4fc.y() * d3 + d2 * (double)(this.z * vector4fc.x() - this.x * vector4fc.z()) + (1.0 - d3) * (double)f2 * (double)this.y), (float)((double)vector4fc.z() * d3 + d2 * (double)(this.x * vector4fc.y() - this.y * vector4fc.x()) + (1.0 - d3) * (double)f2 * (double)this.z), vector4f.w);
        return vector4f;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " <| " + Runtime.format(this.angle, numberFormat) + ")";
    }

    public int hashCode() {
        float f2 = ((double)this.angle < 0.0 ? (float)java.lang.Math.PI * 2 + this.angle % ((float)java.lang.Math.PI * 2) : this.angle) % ((float)java.lang.Math.PI * 2);
        return (((31 + Float.floatToIntBits(f2)) * 31 + Float.floatToIntBits(this.x)) * 31 + Float.floatToIntBits(this.y)) * 31 + Float.floatToIntBits(this.z);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (AxisAngle4f)object;
        float f2 = ((double)this.angle < 0.0 ? (float)java.lang.Math.PI * 2 + this.angle % ((float)java.lang.Math.PI * 2) : this.angle) % ((float)java.lang.Math.PI * 2);
        float f3 = ((double)((AxisAngle4f)object).angle < 0.0 ? (float)java.lang.Math.PI * 2 + ((AxisAngle4f)object).angle % ((float)java.lang.Math.PI * 2) : ((AxisAngle4f)object).angle) % ((float)java.lang.Math.PI * 2);
        if (Float.floatToIntBits(f2) != Float.floatToIntBits(f3)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(((AxisAngle4f)object).x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(((AxisAngle4f)object).y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(((AxisAngle4f)object).z);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

